"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Drs = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * (experimental) Statement provider for service [drs](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awselasticdisasterrecovery.html).
 *
 * @experimental
 */
class Drs extends shared_1.PolicyStatement {
    /**
     * (experimental) Statement provider for service [drs](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awselasticdisasterrecovery.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid) {
        super(sid);
        /**
         * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
         *
         * @experimental
         */
        this.servicePrefix = 'drs';
        /**
         * @experimental
         */
        this.accessLevelList = {
            Write: [
                'AssociateFailbackClientToRecoveryInstanceForDrs',
                'BatchCreateVolumeSnapshotGroupForDrs',
                'BatchDeleteSnapshotRequestForDrs',
                'CreateRecoveryInstanceForDrs',
                'CreateReplicationConfigurationTemplate',
                'CreateSessionForDrs',
                'CreateSourceServerForDrs',
                'DeleteJob',
                'DeleteRecoveryInstance',
                'DeleteReplicationConfigurationTemplate',
                'DeleteSourceServer',
                'DisconnectRecoveryInstance',
                'DisconnectSourceServer',
                'InitializeService',
                'IssueAgentCertificateForDrs',
                'NotifyAgentAuthenticationForDrs',
                'NotifyAgentConnectedForDrs',
                'NotifyAgentDisconnectedForDrs',
                'NotifyAgentReplicationProgressForDrs',
                'NotifyConsistencyAttainedForDrs',
                'NotifyReplicationServerAuthenticationForDrs',
                'RetryDataReplication',
                'SendAgentLogsForDrs',
                'SendAgentMetricsForDrs',
                'SendChannelCommandResultForDrs',
                'SendClientLogsForDrs',
                'SendClientMetricsForDrs',
                'StartFailbackLaunch',
                'StartRecovery',
                'StopFailback',
                'TerminateRecoveryInstances',
                'UpdateAgentBacklogForDrs',
                'UpdateAgentConversionInfoForDrs',
                'UpdateAgentReplicationInfoForDrs',
                'UpdateAgentReplicationProcessStateForDrs',
                'UpdateAgentSourcePropertiesForDrs',
                'UpdateFailbackClientDeviceMappingForDrs',
                'UpdateFailbackClientLastSeenForDrs',
                'UpdateFailbackReplicationConfiguration',
                'UpdateLaunchConfiguration',
                'UpdateReplicationCertificateForDrs',
                'UpdateReplicationConfiguration',
                'UpdateReplicationConfigurationTemplate'
            ],
            Read: [
                'DescribeJobLogItems',
                'DescribeJobs',
                'DescribeRecoveryInstances',
                'DescribeRecoverySnapshots',
                'DescribeReplicationConfigurationTemplates',
                'DescribeReplicationServerAssociationsForDrs',
                'DescribeSnapshotRequestsForDrs',
                'DescribeSourceServers',
                'GetAgentCommandForDrs',
                'GetAgentConfirmedResumeInfoForDrs',
                'GetAgentInstallationAssetsForDrs',
                'GetAgentReplicationInfoForDrs',
                'GetAgentRuntimeConfigurationForDrs',
                'GetAgentSnapshotCreditsForDrs',
                'GetChannelCommandsForDrs',
                'GetFailbackCommandForDrs',
                'GetFailbackLaunchRequestedForDrs',
                'GetFailbackReplicationConfiguration',
                'GetLaunchConfiguration',
                'GetReplicationConfiguration',
                'GetSuggestedFailbackClientDeviceMappingForDrs',
                'ListTagsForResource'
            ],
            Tagging: [
                'TagResource',
                'UntagResource'
            ]
        };
    }
    /**
     * (experimental) Grants permission to get associate failback client to recovery instance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     *
     * @experimental
     */
    toAssociateFailbackClientToRecoveryInstanceForDrs() {
        return this.to('AssociateFailbackClientToRecoveryInstanceForDrs');
    }
    /**
     * (experimental) Grants permission to batch create volume snapshot group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     *
     * @experimental
     */
    toBatchCreateVolumeSnapshotGroupForDrs() {
        return this.to('BatchCreateVolumeSnapshotGroupForDrs');
    }
    /**
     * (experimental) Grants permission to batch delete snapshot request.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     *
     * @experimental
     */
    toBatchDeleteSnapshotRequestForDrs() {
        return this.to('BatchDeleteSnapshotRequestForDrs');
    }
    /**
     * (experimental) Grants permission to create recovery instance.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     *
     * @experimental
     */
    toCreateRecoveryInstanceForDrs() {
        return this.to('CreateRecoveryInstanceForDrs');
    }
    /**
     * (experimental) Grants permission to create replication configuration template.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_CreateReplicationConfigurationTemplate.html
     *
     * @experimental
     */
    toCreateReplicationConfigurationTemplate() {
        return this.to('CreateReplicationConfigurationTemplate');
    }
    /**
     * (experimental) Grants permission to create a session.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     *
     * @experimental
     */
    toCreateSessionForDrs() {
        return this.to('CreateSessionForDrs');
    }
    /**
     * (experimental) Grants permission to create a source server.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     *
     * @experimental
     */
    toCreateSourceServerForDrs() {
        return this.to('CreateSourceServerForDrs');
    }
    /**
     * (experimental) Grants permission to delete a job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_DeleteJob.html
     *
     * @experimental
     */
    toDeleteJob() {
        return this.to('DeleteJob');
    }
    /**
     * (experimental) Grants permission to delete recovery instance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_DeleteRecoveryInstance.html
     *
     * @experimental
     */
    toDeleteRecoveryInstance() {
        return this.to('DeleteRecoveryInstance');
    }
    /**
     * (experimental) Grants permission to delete replication configuration template.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_DeleteReplicationConfigurationTemplate.html
     *
     * @experimental
     */
    toDeleteReplicationConfigurationTemplate() {
        return this.to('DeleteReplicationConfigurationTemplate');
    }
    /**
     * (experimental) Grants permission to delete source server.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_DeleteSourceServer.html
     *
     * @experimental
     */
    toDeleteSourceServer() {
        return this.to('DeleteSourceServer');
    }
    /**
     * (experimental) Grants permission to describe job log items.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_DescribeJobLogItems.html
     *
     * @experimental
     */
    toDescribeJobLogItems() {
        return this.to('DescribeJobLogItems');
    }
    /**
     * (experimental) Grants permission to describe jobs.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_DescribeJobs.html
     *
     * @experimental
     */
    toDescribeJobs() {
        return this.to('DescribeJobs');
    }
    /**
     * (experimental) Grants permission to describe recovery instances.
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - ec2:DescribeInstances
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_DescribeRecoveryInstances.html
     *
     * @experimental
     */
    toDescribeRecoveryInstances() {
        return this.to('DescribeRecoveryInstances');
    }
    /**
     * (experimental) Grants permission to describe recovery snapshots.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_DescribeRecoverySnapshots.html
     *
     * @experimental
     */
    toDescribeRecoverySnapshots() {
        return this.to('DescribeRecoverySnapshots');
    }
    /**
     * (experimental) Grants permission to describe replication configuration template.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_DescribeReplicationConfigurationTemplates.html
     *
     * @experimental
     */
    toDescribeReplicationConfigurationTemplates() {
        return this.to('DescribeReplicationConfigurationTemplates');
    }
    /**
     * (experimental) Grants permission to describe replication server associations.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     *
     * @experimental
     */
    toDescribeReplicationServerAssociationsForDrs() {
        return this.to('DescribeReplicationServerAssociationsForDrs');
    }
    /**
     * (experimental) Grants permission to describe snapshot requests.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     *
     * @experimental
     */
    toDescribeSnapshotRequestsForDrs() {
        return this.to('DescribeSnapshotRequestsForDrs');
    }
    /**
     * (experimental) Grants permission to describe source servers.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_DescribeSourceServers.html
     *
     * @experimental
     */
    toDescribeSourceServers() {
        return this.to('DescribeSourceServers');
    }
    /**
     * (experimental) Grants permission to disconnect recovery instance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_DisconnectRecoveryInstance.html
     *
     * @experimental
     */
    toDisconnectRecoveryInstance() {
        return this.to('DisconnectRecoveryInstance');
    }
    /**
     * (experimental) Grants permission to disconnect source server.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_DisconnectSourceServer.html
     *
     * @experimental
     */
    toDisconnectSourceServer() {
        return this.to('DisconnectSourceServer');
    }
    /**
     * (experimental) Grants permission to get agent command.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     *
     * @experimental
     */
    toGetAgentCommandForDrs() {
        return this.to('GetAgentCommandForDrs');
    }
    /**
     * (experimental) Grants permission to get agent confirmed resume info.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     *
     * @experimental
     */
    toGetAgentConfirmedResumeInfoForDrs() {
        return this.to('GetAgentConfirmedResumeInfoForDrs');
    }
    /**
     * (experimental) Grants permission to get agent installation assets.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     *
     * @experimental
     */
    toGetAgentInstallationAssetsForDrs() {
        return this.to('GetAgentInstallationAssetsForDrs');
    }
    /**
     * (experimental) Grants permission to get agent replication info.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     *
     * @experimental
     */
    toGetAgentReplicationInfoForDrs() {
        return this.to('GetAgentReplicationInfoForDrs');
    }
    /**
     * (experimental) Grants permission to get agent runtime configuration.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     *
     * @experimental
     */
    toGetAgentRuntimeConfigurationForDrs() {
        return this.to('GetAgentRuntimeConfigurationForDrs');
    }
    /**
     * (experimental) Grants permission to get agent snapshot credits.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     *
     * @experimental
     */
    toGetAgentSnapshotCreditsForDrs() {
        return this.to('GetAgentSnapshotCreditsForDrs');
    }
    /**
     * (experimental) Grants permission to get channel commands.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     *
     * @experimental
     */
    toGetChannelCommandsForDrs() {
        return this.to('GetChannelCommandsForDrs');
    }
    /**
     * (experimental) Grants permission to get failback command.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     *
     * @experimental
     */
    toGetFailbackCommandForDrs() {
        return this.to('GetFailbackCommandForDrs');
    }
    /**
     * (experimental) Grants permission to get failback launch requested.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     *
     * @experimental
     */
    toGetFailbackLaunchRequestedForDrs() {
        return this.to('GetFailbackLaunchRequestedForDrs');
    }
    /**
     * (experimental) Grants permission to get failback replication configuration.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_GetFailbackReplicationConfiguration.html
     *
     * @experimental
     */
    toGetFailbackReplicationConfiguration() {
        return this.to('GetFailbackReplicationConfiguration');
    }
    /**
     * (experimental) Grants permission to get launch configuration.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_GetLaunchConfiguration.html
     *
     * @experimental
     */
    toGetLaunchConfiguration() {
        return this.to('GetLaunchConfiguration');
    }
    /**
     * (experimental) Grants permission to get replication configuration.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_GetReplicationConfiguration.html
     *
     * @experimental
     */
    toGetReplicationConfiguration() {
        return this.to('GetReplicationConfiguration');
    }
    /**
     * (experimental) Grants permission to get suggested failback client device mapping.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     *
     * @experimental
     */
    toGetSuggestedFailbackClientDeviceMappingForDrs() {
        return this.to('GetSuggestedFailbackClientDeviceMappingForDrs');
    }
    /**
     * (experimental) Grants permission to initialize service.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:AddRoleToInstanceProfile
     * - iam:CreateInstanceProfile
     * - iam:CreateServiceLinkedRole
     * - iam:GetInstanceProfile
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_InitializeService.html
     *
     * @experimental
     */
    toInitializeService() {
        return this.to('InitializeService');
    }
    /**
     * (experimental) Grants permission to issue an agent certificate.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     *
     * @experimental
     */
    toIssueAgentCertificateForDrs() {
        return this.to('IssueAgentCertificateForDrs');
    }
    /**
     * (experimental) Grants permission to list tags for a resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_ListTagsForResource.html
     *
     * @experimental
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * (experimental) Grants permission to notify agent authentication.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     *
     * @experimental
     */
    toNotifyAgentAuthenticationForDrs() {
        return this.to('NotifyAgentAuthenticationForDrs');
    }
    /**
     * (experimental) Grants permission to notify agent is connected.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     *
     * @experimental
     */
    toNotifyAgentConnectedForDrs() {
        return this.to('NotifyAgentConnectedForDrs');
    }
    /**
     * (experimental) Grants permission to notify agent is disconnected.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     *
     * @experimental
     */
    toNotifyAgentDisconnectedForDrs() {
        return this.to('NotifyAgentDisconnectedForDrs');
    }
    /**
     * (experimental) Grants permission to notify agent replication progress.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     *
     * @experimental
     */
    toNotifyAgentReplicationProgressForDrs() {
        return this.to('NotifyAgentReplicationProgressForDrs');
    }
    /**
     * (experimental) Grants permission to notify consistency attained.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     *
     * @experimental
     */
    toNotifyConsistencyAttainedForDrs() {
        return this.to('NotifyConsistencyAttainedForDrs');
    }
    /**
     * (experimental) Grants permission to notify replication server authentication.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     *
     * @experimental
     */
    toNotifyReplicationServerAuthenticationForDrs() {
        return this.to('NotifyReplicationServerAuthenticationForDrs');
    }
    /**
     * (experimental) Grants permission to retry data replication.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_RetryDataReplication.html
     *
     * @experimental
     */
    toRetryDataReplication() {
        return this.to('RetryDataReplication');
    }
    /**
     * (experimental) Grants permission to send agent logs.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     *
     * @experimental
     */
    toSendAgentLogsForDrs() {
        return this.to('SendAgentLogsForDrs');
    }
    /**
     * (experimental) Grants permission to send agent metrics.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     *
     * @experimental
     */
    toSendAgentMetricsForDrs() {
        return this.to('SendAgentMetricsForDrs');
    }
    /**
     * (experimental) Grants permission to send channel command result.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     *
     * @experimental
     */
    toSendChannelCommandResultForDrs() {
        return this.to('SendChannelCommandResultForDrs');
    }
    /**
     * (experimental) Grants permission to send client logs.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     *
     * @experimental
     */
    toSendClientLogsForDrs() {
        return this.to('SendClientLogsForDrs');
    }
    /**
     * (experimental) Grants permission to send client metrics.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     *
     * @experimental
     */
    toSendClientMetricsForDrs() {
        return this.to('SendClientMetricsForDrs');
    }
    /**
     * (experimental) Grants permission to start failback launch.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_StartFailbackLaunch.html
     *
     * @experimental
     */
    toStartFailbackLaunch() {
        return this.to('StartFailbackLaunch');
    }
    /**
     * (experimental) Grants permission to start recovery.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - drs:CreateRecoveryInstanceForDrs
     * - drs:ListTagsForResource
     * - ec2:AttachVolume
     * - ec2:AuthorizeSecurityGroupEgress
     * - ec2:AuthorizeSecurityGroupIngress
     * - ec2:CreateLaunchTemplate
     * - ec2:CreateLaunchTemplateVersion
     * - ec2:CreateSnapshot
     * - ec2:CreateTags
     * - ec2:CreateVolume
     * - ec2:DeleteLaunchTemplateVersions
     * - ec2:DeleteSnapshot
     * - ec2:DeleteVolume
     * - ec2:DescribeAccountAttributes
     * - ec2:DescribeAvailabilityZones
     * - ec2:DescribeImages
     * - ec2:DescribeInstanceAttribute
     * - ec2:DescribeInstanceStatus
     * - ec2:DescribeInstanceTypes
     * - ec2:DescribeInstances
     * - ec2:DescribeLaunchTemplateVersions
     * - ec2:DescribeLaunchTemplates
     * - ec2:DescribeSecurityGroups
     * - ec2:DescribeSnapshots
     * - ec2:DescribeSubnets
     * - ec2:DescribeVolumes
     * - ec2:DetachVolume
     * - ec2:ModifyInstanceAttribute
     * - ec2:ModifyLaunchTemplate
     * - ec2:RevokeSecurityGroupEgress
     * - ec2:RunInstances
     * - ec2:StartInstances
     * - ec2:StopInstances
     * - ec2:TerminateInstances
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_StartRecovery.html
     *
     * @experimental
     */
    toStartRecovery() {
        return this.to('StartRecovery');
    }
    /**
     * (experimental) Grants permission to stop failback.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_StopFailback.html
     *
     * @experimental
     */
    toStopFailback() {
        return this.to('StopFailback');
    }
    /**
     * (experimental) Grants permission to assign a resource tag.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_TagResource.html
     *
     * @experimental
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * (experimental) Grants permission to terminate recovery instances.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - ec2:DeleteVolume
     * - ec2:DescribeInstances
     * - ec2:DescribeVolumes
     * - ec2:TerminateInstances
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_TerminateRecoveryInstances.html
     *
     * @experimental
     */
    toTerminateRecoveryInstances() {
        return this.to('TerminateRecoveryInstances');
    }
    /**
     * (experimental) Grants permission to untag a resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_UntagResource.html
     *
     * @experimental
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * (experimental) Grants permission to update agent backlog.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     *
     * @experimental
     */
    toUpdateAgentBacklogForDrs() {
        return this.to('UpdateAgentBacklogForDrs');
    }
    /**
     * (experimental) Grants permission to update agent conversion info.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     *
     * @experimental
     */
    toUpdateAgentConversionInfoForDrs() {
        return this.to('UpdateAgentConversionInfoForDrs');
    }
    /**
     * (experimental) Grants permission to update agent replication info.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     *
     * @experimental
     */
    toUpdateAgentReplicationInfoForDrs() {
        return this.to('UpdateAgentReplicationInfoForDrs');
    }
    /**
     * (experimental) Grants permission to update agent replication process state.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     *
     * @experimental
     */
    toUpdateAgentReplicationProcessStateForDrs() {
        return this.to('UpdateAgentReplicationProcessStateForDrs');
    }
    /**
     * (experimental) Grants permission to update agent source properties.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     *
     * @experimental
     */
    toUpdateAgentSourcePropertiesForDrs() {
        return this.to('UpdateAgentSourcePropertiesForDrs');
    }
    /**
     * (experimental) Grants permission to update failback client device mapping.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     *
     * @experimental
     */
    toUpdateFailbackClientDeviceMappingForDrs() {
        return this.to('UpdateFailbackClientDeviceMappingForDrs');
    }
    /**
     * (experimental) Grants permission to update failback client last seen.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     *
     * @experimental
     */
    toUpdateFailbackClientLastSeenForDrs() {
        return this.to('UpdateFailbackClientLastSeenForDrs');
    }
    /**
     * (experimental) Grants permission to update failback replication configuration.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_UpdateFailbackReplicationConfiguration.html
     *
     * @experimental
     */
    toUpdateFailbackReplicationConfiguration() {
        return this.to('UpdateFailbackReplicationConfiguration');
    }
    /**
     * (experimental) Grants permission to update launch configuration.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_UpdateLaunchConfiguration.html
     *
     * @experimental
     */
    toUpdateLaunchConfiguration() {
        return this.to('UpdateLaunchConfiguration');
    }
    /**
     * (experimental) Grants permission to update a replication certificate.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     *
     * @experimental
     */
    toUpdateReplicationCertificateForDrs() {
        return this.to('UpdateReplicationCertificateForDrs');
    }
    /**
     * (experimental) Grants permission to update replication configuration.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_UpdateReplicationConfiguration.html
     *
     * @experimental
     */
    toUpdateReplicationConfiguration() {
        return this.to('UpdateReplicationConfiguration');
    }
    /**
     * (experimental) Grants permission to update replication configuration template.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_UpdateReplicationConfigurationTemplate.html
     *
     * @experimental
     */
    toUpdateReplicationConfigurationTemplate() {
        return this.to('UpdateReplicationConfigurationTemplate');
    }
    /**
     * (experimental) Adds a resource of type JobResource to the statement.
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/failback-overview.html
     *
     * @param jobID - Identifier for the jobID.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onJobResource(jobID, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:drs:${region || '*'}:${account || '*'}:job/${jobID}`);
    }
    /**
     * (experimental) Adds a resource of type RecoveryInstanceResource to the statement.
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/recovery-instances.html
     *
     * @param recoveryInstanceID - Identifier for the recoveryInstanceID.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onRecoveryInstanceResource(recoveryInstanceID, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:drs:${region || '*'}:${account || '*'}:recovery-instance/${recoveryInstanceID}`);
    }
    /**
     * (experimental) Adds a resource of type ReplicationConfigurationTemplateResource to the statement.
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/replication-settings-template.html
     *
     * @param replicationConfigurationTemplateID - Identifier for the replicationConfigurationTemplateID.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onReplicationConfigurationTemplateResource(replicationConfigurationTemplateID, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:drs:${region || '*'}:${account || '*'}:replication-configuration-template/${replicationConfigurationTemplateID}`);
    }
    /**
     * (experimental) Adds a resource of type SourceServerResource to the statement.
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/source-servers.html
     *
     * @param sourceServerID - Identifier for the sourceServerID.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onSourceServerResource(sourceServerID, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:drs:${region || '*'}:${account || '*'}:source-server/${sourceServerID}`);
    }
    /**
     * (experimental) Filters access by the EC2 instance the request originated from.
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/security_iam_authentication.html
     *
     * Applies to resource types:
     * - RecoveryInstanceResource
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifEC2InstanceARN(value, operator) {
        return this.if(`EC2InstanceARN`, value, operator || 'StringLike');
    }
}
exports.Drs = Drs;
_a = JSII_RTTI_SYMBOL_1;
Drs[_a] = { fqn: "iam-floyd.Drs", version: "0.316.0" };
//# sourceMappingURL=data:application/json;base64,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