import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * (experimental) Statement provider for service [inspector2](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoninspector2.html).
 *
 * @experimental
 */
export declare class Inspector2 extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [inspector2](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoninspector2.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Grants permission to associate an account with an Amazon Inspector administrator account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_AssociateMember.html
     *
     * @experimental
     */
    toAssociateMember(): this;
    /**
     * (experimental) Grants permission to retrieve information about Amazon Inspector accounts for an account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_BatchGetAccountStatus.html
     *
     * @experimental
     */
    toBatchGetAccountStatus(): this;
    /**
     * (experimental) Grants permission to retrieve free trial period eligibility about Amazon Inspector accounts for an account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_BatchGetFreeTrialInfo.html
     *
     * @experimental
     */
    toBatchGetFreeTrialInfo(): this;
    /**
     * (experimental) Grants permission to cancel the generation of a findings report.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_CancelFindingsReport.html
     *
     * @experimental
     */
    toCancelFindingsReport(): this;
    /**
     * (experimental) Grants permission to create and define the settings for a findings filter.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_CreateFilter.html
     *
     * @experimental
     */
    toCreateFilter(): this;
    /**
     * (experimental) Grants permission to request the generation of a findings report.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_CreateFindingsReport.html
     *
     * @experimental
     */
    toCreateFindingsReport(): this;
    /**
     * (experimental) Grants permission to delete a findings filter.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_DeleteFilter.html
     *
     * @experimental
     */
    toDeleteFilter(): this;
    /**
     * (experimental) Grants permission to retrieve information about the Amazon Inspector configuration settings for an AWS organization.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_DescribeOrganizationConfiguration.html
     *
     * @experimental
     */
    toDescribeOrganizationConfiguration(): this;
    /**
     * (experimental) Grants permission to disable an Amazon Inspector account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_Disable.html
     *
     * @experimental
     */
    toDisable(): this;
    /**
     * (experimental) Grants permission to disable an account as the delegated Amazon Inspector administrator account for an AWS organization.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_DisableDelegatedAdminAccount.html
     *
     * @experimental
     */
    toDisableDelegatedAdminAccount(): this;
    /**
     * (experimental) Grants permission to an Amazon Inspector administrator account to disassociate from an Inspector member account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_DisassociateMember.html
     *
     * @experimental
     */
    toDisassociateMember(): this;
    /**
     * (experimental) Grants permission to enable and specify the configuration settings for a new Amazon Inspector account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_Enable.html
     *
     * @experimental
     */
    toEnable(): this;
    /**
     * (experimental) Grants permission to enable an account as the delegated Amazon Inspector administrator account for an AWS organization.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_EnableDelegatedAdminAccount.html
     *
     * @experimental
     */
    toEnableDelegatedAdminAccount(): this;
    /**
     * (experimental) Grants permission to retrieve information about the Amazon Inspector administrator account for an account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_GetDelegatedAdminAccount.html
     *
     * @experimental
     */
    toGetDelegatedAdminAccount(): this;
    /**
     * (experimental) Grants permission to retrieve status for a requested findings report.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_GetFindingsReportStatus.html
     *
     * @experimental
     */
    toGetFindingsReportStatus(): this;
    /**
     * (experimental) Grants permission to retrieve information about an account that's associated with an Amazon Inspector administrator account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_GetMember.html
     *
     * @experimental
     */
    toGetMember(): this;
    /**
     * (experimental) Grants permission to retrieve feature configuration permissions associated with an Amazon Inspector account within an organization.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_ListAccountPermissions.html
     *
     * @experimental
     */
    toListAccountPermissions(): this;
    /**
     * (experimental) Grants permission to retrieve the types of statistics Amazon Inspector can generate for resources Inspector monitors.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_ListCoverage.html
     *
     * @experimental
     */
    toListCoverage(): this;
    /**
     * (experimental) Grants permission to retrieve statistical data and other information about the resources Amazon Inspector monitors.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_ListCoverageStatistics.html
     *
     * @experimental
     */
    toListCoverageStatistics(): this;
    /**
     * (experimental) Grants permission to retrieve information about the delegated Amazon Inspector administrator account for an AWS organization.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_ListDelegatedAdminAccounts.html
     *
     * @experimental
     */
    toListDelegatedAdminAccounts(): this;
    /**
     * (experimental) Grants permission to retrieve information about all findings filters.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_ListFilters.html
     *
     * @experimental
     */
    toListFilters(): this;
    /**
     * (experimental) Grants permission to retrieve statistical data and other information about Amazon Inspector findings.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_ListFindingAggregations.html
     *
     * @experimental
     */
    toListFindingAggregations(): this;
    /**
     * (experimental) Grants permission to retrieve a subset of information about one or more findings.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_ListFindings.html
     *
     * @experimental
     */
    toListFindings(): this;
    /**
     * (experimental) Grants permission to retrieve information about the Amazon Inspector member accounts that are associated with an Inspector administrator account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_ListMembers.html
     *
     * @experimental
     */
    toListMembers(): this;
    /**
     * (experimental) Grants permission to retrieve the tags for an Amazon Inspector resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_ListTagsForResource.html
     *
     * @experimental
     */
    toListTagsForResource(): this;
    /**
     * (experimental) Grants permission to retrieve aggregated usage data for an account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_ListUsageTotals.html
     *
     * @experimental
     */
    toListUsageTotals(): this;
    /**
     * (experimental) Grants permission to add or update the tags for an Amazon Inspector resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_TagResource.html
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Grants permission to remove tags from an Amazon Inspector resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_UntagResource.html
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * (experimental) Grants permission to update the settings for a findings filter.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_UpdateFilter.html
     *
     * @experimental
     */
    toUpdateFilter(): this;
    /**
     * (experimental) Grants permission to update Amazon Inspector configuration settings for an AWS organization.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_UpdateOrganizationConfiguration.html
     *
     * @experimental
     */
    toUpdateOrganizationConfiguration(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type Filter to the statement.
     *
     * https://docs.aws.amazon.com/inspector/latest/user/what-is-inspector.html
     *
     * @param ownerId - Identifier for the ownerId.
     * @param filterId - Identifier for the filterId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onFilter(ownerId: string, filterId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type Finding to the statement.
     *
     * https://docs.aws.amazon.com/inspector/latest/user/what-is-inspector.html
     *
     * @param findingId - Identifier for the findingId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onFinding(findingId: string, account?: string, region?: string, partition?: string): this;
}
