"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Geo = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * (experimental) Statement provider for service [geo](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonlocation.html).
 *
 * @experimental
 */
class Geo extends shared_1.PolicyStatement {
    /**
     * (experimental) Statement provider for service [geo](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonlocation.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid) {
        super(sid);
        /**
         * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
         *
         * @experimental
         */
        this.servicePrefix = 'geo';
        /**
         * @experimental
         */
        this.accessLevelList = {
            Write: [
                'AssociateTrackerConsumer',
                'BatchDeleteDevicePositionHistory',
                'BatchDeleteGeofence',
                'BatchEvaluateGeofences',
                'BatchPutGeofence',
                'BatchUpdateDevicePosition',
                'CreateGeofenceCollection',
                'CreateMap',
                'CreatePlaceIndex',
                'CreateRouteCalculator',
                'CreateTracker',
                'DeleteGeofenceCollection',
                'DeleteMap',
                'DeletePlaceIndex',
                'DeleteRouteCalculator',
                'DeleteTracker',
                'DisassociateTrackerConsumer',
                'PutGeofence',
                'UpdateGeofenceCollection',
                'UpdateMap',
                'UpdatePlaceIndex',
                'UpdateRouteCalculator',
                'UpdateTracker'
            ],
            Read: [
                'BatchGetDevicePosition',
                'CalculateRoute',
                'CalculateRouteMatrix',
                'DescribeGeofenceCollection',
                'DescribeMap',
                'DescribePlaceIndex',
                'DescribeRouteCalculator',
                'DescribeTracker',
                'GetDevicePosition',
                'GetDevicePositionHistory',
                'GetGeofence',
                'GetMapGlyphs',
                'GetMapSprites',
                'GetMapStyleDescriptor',
                'GetMapTile',
                'ListDevicePositions',
                'ListGeofences',
                'ListTagsForResource',
                'ListTrackerConsumers',
                'SearchPlaceIndexForPosition',
                'SearchPlaceIndexForSuggestions',
                'SearchPlaceIndexForText'
            ],
            List: [
                'ListGeofenceCollections',
                'ListMaps',
                'ListPlaceIndexes',
                'ListRouteCalculators',
                'ListTrackers'
            ],
            Tagging: [
                'TagResource',
                'UntagResource'
            ]
        };
    }
    /**
     * (experimental) Grants permission to create an association between a geofence-collection and a tracker resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_AssociateTrackerConsumer.html
     *
     * @experimental
     */
    toAssociateTrackerConsumer() {
        return this.to('AssociateTrackerConsumer');
    }
    /**
     * (experimental) Grants permission to delete a batch of device position histories from a tracker resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_BatchDeleteDevicePositionHistory.html
     *
     * @experimental
     */
    toBatchDeleteDevicePositionHistory() {
        return this.to('BatchDeleteDevicePositionHistory');
    }
    /**
     * (experimental) Grants permission to delete a batch of geofences from a geofence collection.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_BatchDeleteGeofence.html
     *
     * @experimental
     */
    toBatchDeleteGeofence() {
        return this.to('BatchDeleteGeofence');
    }
    /**
     * (experimental) Grants permission to evaluate device positions against the position of geofences in a given geofence collection.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_BatchEvaluateGeofences.html
     *
     * @experimental
     */
    toBatchEvaluateGeofences() {
        return this.to('BatchEvaluateGeofences');
    }
    /**
     * (experimental) Grants permission to send a batch request to retrieve device positions.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_BatchGetDevicePosition.html
     *
     * @experimental
     */
    toBatchGetDevicePosition() {
        return this.to('BatchGetDevicePosition');
    }
    /**
     * (experimental) Grants permission to send a batch request for adding geofences into a given geofence collection.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_BatchPutGeofence.html
     *
     * @experimental
     */
    toBatchPutGeofence() {
        return this.to('BatchPutGeofence');
    }
    /**
     * (experimental) Grants permission to upload a position update for one or more devices to a tracker resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_BatchUpdateDevicePosition.html
     *
     * @experimental
     */
    toBatchUpdateDevicePosition() {
        return this.to('BatchUpdateDevicePosition');
    }
    /**
     * (experimental) Grants permission to calculate routes using a given route calculator resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_CalculateRoute.html
     *
     * @experimental
     */
    toCalculateRoute() {
        return this.to('CalculateRoute');
    }
    /**
     * (experimental) Grants permission to calculate a route matrix using a given route calculator resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_CalculateRouteMatrix.html
     *
     * @experimental
     */
    toCalculateRouteMatrix() {
        return this.to('CalculateRouteMatrix');
    }
    /**
     * (experimental) Grants permission to create a geofence-collection.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_CreateGeofenceCollection.html
     *
     * @experimental
     */
    toCreateGeofenceCollection() {
        return this.to('CreateGeofenceCollection');
    }
    /**
     * (experimental) Grants permission to create a map resource.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_CreateMap.html
     *
     * @experimental
     */
    toCreateMap() {
        return this.to('CreateMap');
    }
    /**
     * (experimental) Grants permission to create a place index resource.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_CreatePlaceIndex.html
     *
     * @experimental
     */
    toCreatePlaceIndex() {
        return this.to('CreatePlaceIndex');
    }
    /**
     * (experimental) Grants permission to create a route calculator resource.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_CreateRouteCalculator.html
     *
     * @experimental
     */
    toCreateRouteCalculator() {
        return this.to('CreateRouteCalculator');
    }
    /**
     * (experimental) Grants permission to create a tracker resource.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_CreateTracker.html
     *
     * @experimental
     */
    toCreateTracker() {
        return this.to('CreateTracker');
    }
    /**
     * (experimental) Grants permission to delete a geofence-collection.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_DeleteGeofenceCollection.html
     *
     * @experimental
     */
    toDeleteGeofenceCollection() {
        return this.to('DeleteGeofenceCollection');
    }
    /**
     * (experimental) Grants permission to delete a map resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_DeleteMap.html
     *
     * @experimental
     */
    toDeleteMap() {
        return this.to('DeleteMap');
    }
    /**
     * (experimental) Grants permission to delete a place index resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_DeletePlaceIndex.html
     *
     * @experimental
     */
    toDeletePlaceIndex() {
        return this.to('DeletePlaceIndex');
    }
    /**
     * (experimental) Grants permission to delete a route calculator resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_DeleteRouteCalculator.html
     *
     * @experimental
     */
    toDeleteRouteCalculator() {
        return this.to('DeleteRouteCalculator');
    }
    /**
     * (experimental) Grants permission to delete a tracker resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_DeleteTracker.html
     *
     * @experimental
     */
    toDeleteTracker() {
        return this.to('DeleteTracker');
    }
    /**
     * (experimental) Grants permission to retrieve geofence collection details.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_DescribeGeofenceCollection.html
     *
     * @experimental
     */
    toDescribeGeofenceCollection() {
        return this.to('DescribeGeofenceCollection');
    }
    /**
     * (experimental) Grants permission to retrieve map resource details.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_DescribeMap.html
     *
     * @experimental
     */
    toDescribeMap() {
        return this.to('DescribeMap');
    }
    /**
     * (experimental) Grants permission to retrieve place-index resource details.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_DescribePlaceIndex.html
     *
     * @experimental
     */
    toDescribePlaceIndex() {
        return this.to('DescribePlaceIndex');
    }
    /**
     * (experimental) Grants permission to retrieve route calculator resource details.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_DescribeRouteCalculator.html
     *
     * @experimental
     */
    toDescribeRouteCalculator() {
        return this.to('DescribeRouteCalculator');
    }
    /**
     * (experimental) Grants permission to retrieve a tracker resource details.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_DescribeTracker.html
     *
     * @experimental
     */
    toDescribeTracker() {
        return this.to('DescribeTracker');
    }
    /**
     * (experimental) Grants permission to remove the association between a tracker resource and a geofence-collection.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_DisassociateTrackerConsumer.html
     *
     * @experimental
     */
    toDisassociateTrackerConsumer() {
        return this.to('DisassociateTrackerConsumer');
    }
    /**
     * (experimental) Grants permission to retrieve the latest device position.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_GetDevicePosition.html
     *
     * @experimental
     */
    toGetDevicePosition() {
        return this.to('GetDevicePosition');
    }
    /**
     * (experimental) Grants permission to retrieve the device position history.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_GetDevicePositionHistory.html
     *
     * @experimental
     */
    toGetDevicePositionHistory() {
        return this.to('GetDevicePositionHistory');
    }
    /**
     * (experimental) Grants permission to retrieve the geofence details from a geofence-collection.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_GetGeofence.html
     *
     * @experimental
     */
    toGetGeofence() {
        return this.to('GetGeofence');
    }
    /**
     * (experimental) Grants permission to retrieve the glyph file for a map resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_GetMapGlyphs.html
     *
     * @experimental
     */
    toGetMapGlyphs() {
        return this.to('GetMapGlyphs');
    }
    /**
     * (experimental) Grants permission to retrieve the sprite file for a map resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_GetMapSprites.html
     *
     * @experimental
     */
    toGetMapSprites() {
        return this.to('GetMapSprites');
    }
    /**
     * (experimental) Grants permission to retrieve the map style descriptor from a map resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_GetMapStyleDescriptor.html
     *
     * @experimental
     */
    toGetMapStyleDescriptor() {
        return this.to('GetMapStyleDescriptor');
    }
    /**
     * (experimental) Grants permission to retrieve the map tile from the map resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_GetMapTile.html
     *
     * @experimental
     */
    toGetMapTile() {
        return this.to('GetMapTile');
    }
    /**
     * (experimental) Grants permission to retrieve a list of devices and their latest positions from the given tracker resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_ListDevicePositions.html
     *
     * @experimental
     */
    toListDevicePositions() {
        return this.to('ListDevicePositions');
    }
    /**
     * (experimental) Grants permission to lists geofence-collections.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_ListGeofenceCollections.html
     *
     * @experimental
     */
    toListGeofenceCollections() {
        return this.to('ListGeofenceCollections');
    }
    /**
     * (experimental) Grants permission to list geofences stored in a given geofence collection.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_ListGeofences.html
     *
     * @experimental
     */
    toListGeofences() {
        return this.to('ListGeofences');
    }
    /**
     * (experimental) Grants permission to list map resources.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_ListMaps.html
     *
     * @experimental
     */
    toListMaps() {
        return this.to('ListMaps');
    }
    /**
     * (experimental) Grants permission to return a list of place index resources.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_ListPlaceIndexes.html
     *
     * @experimental
     */
    toListPlaceIndexes() {
        return this.to('ListPlaceIndexes');
    }
    /**
     * (experimental) Grants permission to return a list of route calculator resources.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_ListRouteCalculators.html
     *
     * @experimental
     */
    toListRouteCalculators() {
        return this.to('ListRouteCalculators');
    }
    /**
     * (experimental) Grants permission to list the tags (metadata) which you have assigned to the resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_ListTagsForResource.html
     *
     * @experimental
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * (experimental) Grants permission to retrieve a list of geofence collections currently associated to the given tracker resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_ListTrackerConsumers.html
     *
     * @experimental
     */
    toListTrackerConsumers() {
        return this.to('ListTrackerConsumers');
    }
    /**
     * (experimental) Grants permission to return a list of tracker resources.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_ListTrackers.html
     *
     * @experimental
     */
    toListTrackers() {
        return this.to('ListTrackers');
    }
    /**
     * (experimental) Grants permission to add a new geofence or update an existing geofence to a given geofence-collection.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_PutGeofence.html
     *
     * @experimental
     */
    toPutGeofence() {
        return this.to('PutGeofence');
    }
    /**
     * (experimental) Grants permission to reverse geocodes a given coordinate.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_SearchPlaceIndexForPosition.html
     *
     * @experimental
     */
    toSearchPlaceIndexForPosition() {
        return this.to('SearchPlaceIndexForPosition');
    }
    /**
     * (experimental) Grants permission to generate suggestions for addresses and points of interest based on partial or misspelled free-form text.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_SearchPlaceIndexForSuggestions.html
     *
     * @experimental
     */
    toSearchPlaceIndexForSuggestions() {
        return this.to('SearchPlaceIndexForSuggestions');
    }
    /**
     * (experimental) Grants permission to geocode free-form text, such as an address, name, city or region.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_SearchPlaceIndexForText.html
     *
     * @experimental
     */
    toSearchPlaceIndexForText() {
        return this.to('SearchPlaceIndexForText');
    }
    /**
     * (experimental) Grants permission to adds to or modifies the tags of the given resource.
     *
     * Tags are metadata which can be used to manage a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_TagResource.html
     *
     * @experimental
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * (experimental) Grants permission to remove the given tags (metadata) from the resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_UntagResource.html
     *
     * @experimental
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * (experimental) Grants permission to update a geofence collection.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_UpdateGeofenceCollection.html
     *
     * @experimental
     */
    toUpdateGeofenceCollection() {
        return this.to('UpdateGeofenceCollection');
    }
    /**
     * (experimental) Grants permission to update a map resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_UpdateMap.html
     *
     * @experimental
     */
    toUpdateMap() {
        return this.to('UpdateMap');
    }
    /**
     * (experimental) Grants permission to update a place index resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_UpdatePlaceIndex.html
     *
     * @experimental
     */
    toUpdatePlaceIndex() {
        return this.to('UpdatePlaceIndex');
    }
    /**
     * (experimental) Grants permission to update a route calculator resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_UpdateRouteCalculator.html
     *
     * @experimental
     */
    toUpdateRouteCalculator() {
        return this.to('UpdateRouteCalculator');
    }
    /**
     * (experimental) Grants permission to update a tracker resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_UpdateTracker.html
     *
     * @experimental
     */
    toUpdateTracker() {
        return this.to('UpdateTracker');
    }
    /**
     * (experimental) Adds a resource of type geofence-collection to the statement.
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/overview.html#geofence-overview
     *
     * @param geofenceCollectionName - Identifier for the geofenceCollectionName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onGeofenceCollection(geofenceCollectionName, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:geo:${region || '*'}:${account || '*'}:geofence-collection/${geofenceCollectionName}`);
    }
    /**
     * (experimental) Adds a resource of type map to the statement.
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/overview.html#map-overview
     *
     * @param mapName - Identifier for the mapName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onMap(mapName, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:geo:${region || '*'}:${account || '*'}:map/${mapName}`);
    }
    /**
     * (experimental) Adds a resource of type place-index to the statement.
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/overview.html#places-overview
     *
     * @param indexName - Identifier for the indexName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onPlaceIndex(indexName, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:geo:${region || '*'}:${account || '*'}:place-index/${indexName}`);
    }
    /**
     * (experimental) Adds a resource of type route-calculator to the statement.
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/overview.html#routes-overview
     *
     * @param calculatorName - Identifier for the calculatorName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onRouteCalculator(calculatorName, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:geo:${region || '*'}:${account || '*'}:route-calculator/${calculatorName}`);
    }
    /**
     * (experimental) Adds a resource of type tracker to the statement.
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/overview.html#tracking-overview
     *
     * @param trackerName - Identifier for the trackerName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onTracker(trackerName, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:geo:${region || '*'}:${account || '*'}:tracker/${trackerName}`);
    }
}
exports.Geo = Geo;
_a = JSII_RTTI_SYMBOL_1;
Geo[_a] = { fqn: "iam-floyd.Geo", version: "0.316.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibG9jYXRpb24uanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJsb2NhdGlvbi50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUNBLHNDQUE0Qzs7Ozs7O0FBRzVDLE1BQWEsR0FBSSxTQUFRLHdCQUFlOzs7Ozs7O0lBSXRDLFlBQVksR0FBWTtRQUN0QixLQUFLLENBQUMsR0FBRyxDQUFDLENBQUM7Ozs7OztRQUpOLGtCQUFhLEdBQUcsS0FBSyxDQUFDOzs7O1FBMlFuQixvQkFBZSxHQUFvQjtZQUMzQyxLQUFLLEVBQUU7Z0JBQ0wsMEJBQTBCO2dCQUMxQixrQ0FBa0M7Z0JBQ2xDLHFCQUFxQjtnQkFDckIsd0JBQXdCO2dCQUN4QixrQkFBa0I7Z0JBQ2xCLDJCQUEyQjtnQkFDM0IsMEJBQTBCO2dCQUMxQixXQUFXO2dCQUNYLGtCQUFrQjtnQkFDbEIsdUJBQXVCO2dCQUN2QixlQUFlO2dCQUNmLDBCQUEwQjtnQkFDMUIsV0FBVztnQkFDWCxrQkFBa0I7Z0JBQ2xCLHVCQUF1QjtnQkFDdkIsZUFBZTtnQkFDZiw2QkFBNkI7Z0JBQzdCLGFBQWE7Z0JBQ2IsMEJBQTBCO2dCQUMxQixXQUFXO2dCQUNYLGtCQUFrQjtnQkFDbEIsdUJBQXVCO2dCQUN2QixlQUFlO2FBQ2hCO1lBQ0QsSUFBSSxFQUFFO2dCQUNKLHdCQUF3QjtnQkFDeEIsZ0JBQWdCO2dCQUNoQixzQkFBc0I7Z0JBQ3RCLDRCQUE0QjtnQkFDNUIsYUFBYTtnQkFDYixvQkFBb0I7Z0JBQ3BCLHlCQUF5QjtnQkFDekIsaUJBQWlCO2dCQUNqQixtQkFBbUI7Z0JBQ25CLDBCQUEwQjtnQkFDMUIsYUFBYTtnQkFDYixjQUFjO2dCQUNkLGVBQWU7Z0JBQ2YsdUJBQXVCO2dCQUN2QixZQUFZO2dCQUNaLHFCQUFxQjtnQkFDckIsZUFBZTtnQkFDZixxQkFBcUI7Z0JBQ3JCLHNCQUFzQjtnQkFDdEIsNkJBQTZCO2dCQUM3QixnQ0FBZ0M7Z0JBQ2hDLHlCQUF5QjthQUMxQjtZQUNELElBQUksRUFBRTtnQkFDSix5QkFBeUI7Z0JBQ3pCLFVBQVU7Z0JBQ1Ysa0JBQWtCO2dCQUNsQixzQkFBc0I7Z0JBQ3RCLGNBQWM7YUFDZjtZQUNELE9BQU8sRUFBRTtnQkFDUCxhQUFhO2dCQUNiLGVBQWU7YUFDaEI7U0FDRixDQUFDO0lBblVGLENBQUM7Ozs7Ozs7Ozs7SUFHTSwwQkFBMEI7UUFDL0IsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLDBCQUEwQixDQUFDLENBQUM7SUFDN0MsQ0FBQzs7Ozs7Ozs7OztJQUdNLGtDQUFrQztRQUN2QyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsa0NBQWtDLENBQUMsQ0FBQztJQUNyRCxDQUFDOzs7Ozs7Ozs7O0lBR00scUJBQXFCO1FBQzFCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDO0lBQ3hDLENBQUM7Ozs7Ozs7Ozs7SUFHTSx3QkFBd0I7UUFDN0IsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHdCQUF3QixDQUFDLENBQUM7SUFDM0MsQ0FBQzs7Ozs7Ozs7OztJQUdNLHdCQUF3QjtRQUM3QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsd0JBQXdCLENBQUMsQ0FBQztJQUMzQyxDQUFDOzs7Ozs7Ozs7O0lBR00sa0JBQWtCO1FBQ3ZCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDO0lBQ3JDLENBQUM7Ozs7Ozs7Ozs7SUFHTSwyQkFBMkI7UUFDaEMsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLDJCQUEyQixDQUFDLENBQUM7SUFDOUMsQ0FBQzs7Ozs7Ozs7OztJQUdNLGdCQUFnQjtRQUNyQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsZ0JBQWdCLENBQUMsQ0FBQztJQUNuQyxDQUFDOzs7Ozs7Ozs7O0lBR00sc0JBQXNCO1FBQzNCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDO0lBQ3pDLENBQUM7Ozs7Ozs7Ozs7Ozs7O0lBR00sMEJBQTBCO1FBQy9CLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQywwQkFBMEIsQ0FBQyxDQUFDO0lBQzdDLENBQUM7Ozs7Ozs7Ozs7Ozs7O0lBR00sV0FBVztRQUNoQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsV0FBVyxDQUFDLENBQUM7SUFDOUIsQ0FBQzs7Ozs7Ozs7Ozs7Ozs7SUFHTSxrQkFBa0I7UUFDdkIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGtCQUFrQixDQUFDLENBQUM7SUFDckMsQ0FBQzs7Ozs7Ozs7Ozs7Ozs7SUFHTSx1QkFBdUI7UUFDNUIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHVCQUF1QixDQUFDLENBQUM7SUFDMUMsQ0FBQzs7Ozs7Ozs7Ozs7Ozs7SUFHTSxlQUFlO1FBQ3BCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxlQUFlLENBQUMsQ0FBQztJQUNsQyxDQUFDOzs7Ozs7Ozs7O0lBR00sMEJBQTBCO1FBQy9CLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQywwQkFBMEIsQ0FBQyxDQUFDO0lBQzdDLENBQUM7Ozs7Ozs7Ozs7SUFHTSxXQUFXO1FBQ2hCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxXQUFXLENBQUMsQ0FBQztJQUM5QixDQUFDOzs7Ozs7Ozs7O0lBR00sa0JBQWtCO1FBQ3ZCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDO0lBQ3JDLENBQUM7Ozs7Ozs7Ozs7SUFHTSx1QkFBdUI7UUFDNUIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHVCQUF1QixDQUFDLENBQUM7SUFDMUMsQ0FBQzs7Ozs7Ozs7OztJQUdNLGVBQWU7UUFDcEIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGVBQWUsQ0FBQyxDQUFDO0lBQ2xDLENBQUM7Ozs7Ozs7Ozs7SUFHTSw0QkFBNEI7UUFDakMsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLDRCQUE0QixDQUFDLENBQUM7SUFDL0MsQ0FBQzs7Ozs7Ozs7OztJQUdNLGFBQWE7UUFDbEIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGFBQWEsQ0FBQyxDQUFDO0lBQ2hDLENBQUM7Ozs7Ozs7Ozs7SUFHTSxvQkFBb0I7UUFDekIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLG9CQUFvQixDQUFDLENBQUM7SUFDdkMsQ0FBQzs7Ozs7Ozs7OztJQUdNLHlCQUF5QjtRQUM5QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMseUJBQXlCLENBQUMsQ0FBQztJQUM1QyxDQUFDOzs7Ozs7Ozs7O0lBR00saUJBQWlCO1FBQ3RCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDO0lBQ3BDLENBQUM7Ozs7Ozs7Ozs7SUFHTSw2QkFBNkI7UUFDbEMsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLDZCQUE2QixDQUFDLENBQUM7SUFDaEQsQ0FBQzs7Ozs7Ozs7OztJQUdNLG1CQUFtQjtRQUN4QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsbUJBQW1CLENBQUMsQ0FBQztJQUN0QyxDQUFDOzs7Ozs7Ozs7O0lBR00sMEJBQTBCO1FBQy9CLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQywwQkFBMEIsQ0FBQyxDQUFDO0lBQzdDLENBQUM7Ozs7Ozs7Ozs7SUFHTSxhQUFhO1FBQ2xCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxhQUFhLENBQUMsQ0FBQztJQUNoQyxDQUFDOzs7Ozs7Ozs7O0lBR00sY0FBYztRQUNuQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsY0FBYyxDQUFDLENBQUM7SUFDakMsQ0FBQzs7Ozs7Ozs7OztJQUdNLGVBQWU7UUFDcEIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGVBQWUsQ0FBQyxDQUFDO0lBQ2xDLENBQUM7Ozs7Ozs7Ozs7SUFHTSx1QkFBdUI7UUFDNUIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHVCQUF1QixDQUFDLENBQUM7SUFDMUMsQ0FBQzs7Ozs7Ozs7OztJQUdNLFlBQVk7UUFDakIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLFlBQVksQ0FBQyxDQUFDO0lBQy9CLENBQUM7Ozs7Ozs7Ozs7SUFHTSxxQkFBcUI7UUFDMUIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHFCQUFxQixDQUFDLENBQUM7SUFDeEMsQ0FBQzs7Ozs7Ozs7OztJQUdNLHlCQUF5QjtRQUM5QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMseUJBQXlCLENBQUMsQ0FBQztJQUM1QyxDQUFDOzs7Ozs7Ozs7O0lBR00sZUFBZTtRQUNwQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsZUFBZSxDQUFDLENBQUM7SUFDbEMsQ0FBQzs7Ozs7Ozs7OztJQUdNLFVBQVU7UUFDZixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsVUFBVSxDQUFDLENBQUM7SUFDN0IsQ0FBQzs7Ozs7Ozs7OztJQUdNLGtCQUFrQjtRQUN2QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsa0JBQWtCLENBQUMsQ0FBQztJQUNyQyxDQUFDOzs7Ozs7Ozs7O0lBR00sc0JBQXNCO1FBQzNCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDO0lBQ3pDLENBQUM7Ozs7Ozs7Ozs7SUFHTSxxQkFBcUI7UUFDMUIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHFCQUFxQixDQUFDLENBQUM7SUFDeEMsQ0FBQzs7Ozs7Ozs7OztJQUdNLHNCQUFzQjtRQUMzQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsc0JBQXNCLENBQUMsQ0FBQztJQUN6QyxDQUFDOzs7Ozs7Ozs7O0lBR00sY0FBYztRQUNuQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsY0FBYyxDQUFDLENBQUM7SUFDakMsQ0FBQzs7Ozs7Ozs7OztJQUdNLGFBQWE7UUFDbEIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGFBQWEsQ0FBQyxDQUFDO0lBQ2hDLENBQUM7Ozs7Ozs7Ozs7SUFHTSw2QkFBNkI7UUFDbEMsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLDZCQUE2QixDQUFDLENBQUM7SUFDaEQsQ0FBQzs7Ozs7Ozs7OztJQUdNLGdDQUFnQztRQUNyQyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsZ0NBQWdDLENBQUMsQ0FBQztJQUNuRCxDQUFDOzs7Ozs7Ozs7O0lBR00seUJBQXlCO1FBQzlCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyx5QkFBeUIsQ0FBQyxDQUFDO0lBQzVDLENBQUM7Ozs7Ozs7Ozs7Ozs7Ozs7SUFHTSxhQUFhO1FBQ2xCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxhQUFhLENBQUMsQ0FBQztJQUNoQyxDQUFDOzs7Ozs7Ozs7Ozs7OztJQUdNLGVBQWU7UUFDcEIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGVBQWUsQ0FBQyxDQUFDO0lBQ2xDLENBQUM7Ozs7Ozs7Ozs7SUFHTSwwQkFBMEI7UUFDL0IsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLDBCQUEwQixDQUFDLENBQUM7SUFDN0MsQ0FBQzs7Ozs7Ozs7OztJQUdNLFdBQVc7UUFDaEIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLFdBQVcsQ0FBQyxDQUFDO0lBQzlCLENBQUM7Ozs7Ozs7Ozs7SUFHTSxrQkFBa0I7UUFDdkIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGtCQUFrQixDQUFDLENBQUM7SUFDckMsQ0FBQzs7Ozs7Ozs7OztJQUdNLHVCQUF1QjtRQUM1QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsdUJBQXVCLENBQUMsQ0FBQztJQUMxQyxDQUFDOzs7Ozs7Ozs7O0lBR00sZUFBZTtRQUNwQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsZUFBZSxDQUFDLENBQUM7SUFDbEMsQ0FBQzs7Ozs7Ozs7Ozs7O0lBa0VNLG9CQUFvQixDQUFDLHNCQUE4QixFQUFFLE9BQWdCLEVBQUUsTUFBZSxFQUFFLFNBQWtCO1FBQy9HLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxPQUFRLFNBQVMsSUFBSSxLQUFNLFFBQVMsTUFBTSxJQUFJLEdBQUksSUFBSyxPQUFPLElBQUksR0FBSSx3QkFBeUIsc0JBQXVCLEVBQUUsQ0FBQyxDQUFDO0lBQzNJLENBQUM7Ozs7Ozs7Ozs7OztJQUdNLEtBQUssQ0FBQyxPQUFlLEVBQUUsT0FBZ0IsRUFBRSxNQUFlLEVBQUUsU0FBa0I7UUFDakYsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLE9BQVEsU0FBUyxJQUFJLEtBQU0sUUFBUyxNQUFNLElBQUksR0FBSSxJQUFLLE9BQU8sSUFBSSxHQUFJLFFBQVMsT0FBUSxFQUFFLENBQUMsQ0FBQztJQUM1RyxDQUFDOzs7Ozs7Ozs7Ozs7SUFHTSxZQUFZLENBQUMsU0FBaUIsRUFBRSxPQUFnQixFQUFFLE1BQWUsRUFBRSxTQUFrQjtRQUMxRixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsT0FBUSxTQUFTLElBQUksS0FBTSxRQUFTLE1BQU0sSUFBSSxHQUFJLElBQUssT0FBTyxJQUFJLEdBQUksZ0JBQWlCLFNBQVUsRUFBRSxDQUFDLENBQUM7SUFDdEgsQ0FBQzs7Ozs7Ozs7Ozs7O0lBR00saUJBQWlCLENBQUMsY0FBc0IsRUFBRSxPQUFnQixFQUFFLE1BQWUsRUFBRSxTQUFrQjtRQUNwRyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsT0FBUSxTQUFTLElBQUksS0FBTSxRQUFTLE1BQU0sSUFBSSxHQUFJLElBQUssT0FBTyxJQUFJLEdBQUkscUJBQXNCLGNBQWUsRUFBRSxDQUFDLENBQUM7SUFDaEksQ0FBQzs7Ozs7Ozs7Ozs7O0lBR00sU0FBUyxDQUFDLFdBQW1CLEVBQUUsT0FBZ0IsRUFBRSxNQUFlLEVBQUUsU0FBa0I7UUFDekYsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLE9BQVEsU0FBUyxJQUFJLEtBQU0sUUFBUyxNQUFNLElBQUksR0FBSSxJQUFLLE9BQU8sSUFBSSxHQUFJLFlBQWEsV0FBWSxFQUFFLENBQUMsQ0FBQztJQUNwSCxDQUFDOztBQWxXSCxrQkFtV0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBBY2Nlc3NMZXZlbExpc3QgfSBmcm9tICcuLi9zaGFyZWQvYWNjZXNzLWxldmVsJztcbmltcG9ydCB7IFBvbGljeVN0YXRlbWVudCB9IGZyb20gJy4uL3NoYXJlZCc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBjbGFzcyBHZW8gZXh0ZW5kcyBQb2xpY3lTdGF0ZW1lbnQge1xuICBwdWJsaWMgc2VydmljZVByZWZpeCA9ICdnZW8nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBjb25zdHJ1Y3RvcihzaWQ/OiBzdHJpbmcpIHtcbiAgICBzdXBlcihzaWQpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b0Fzc29jaWF0ZVRyYWNrZXJDb25zdW1lcigpIHtcbiAgICByZXR1cm4gdGhpcy50bygnQXNzb2NpYXRlVHJhY2tlckNvbnN1bWVyJyk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b0JhdGNoRGVsZXRlRGV2aWNlUG9zaXRpb25IaXN0b3J5KCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdCYXRjaERlbGV0ZURldmljZVBvc2l0aW9uSGlzdG9yeScpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHRvQmF0Y2hEZWxldGVHZW9mZW5jZSgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnQmF0Y2hEZWxldGVHZW9mZW5jZScpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHRvQmF0Y2hFdmFsdWF0ZUdlb2ZlbmNlcygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnQmF0Y2hFdmFsdWF0ZUdlb2ZlbmNlcycpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHRvQmF0Y2hHZXREZXZpY2VQb3NpdGlvbigpIHtcbiAgICByZXR1cm4gdGhpcy50bygnQmF0Y2hHZXREZXZpY2VQb3NpdGlvbicpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9CYXRjaFB1dEdlb2ZlbmNlKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdCYXRjaFB1dEdlb2ZlbmNlJyk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHRvQmF0Y2hVcGRhdGVEZXZpY2VQb3NpdGlvbigpIHtcbiAgICByZXR1cm4gdGhpcy50bygnQmF0Y2hVcGRhdGVEZXZpY2VQb3NpdGlvbicpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9DYWxjdWxhdGVSb3V0ZSgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnQ2FsY3VsYXRlUm91dGUnKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9DYWxjdWxhdGVSb3V0ZU1hdHJpeCgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnQ2FsY3VsYXRlUm91dGVNYXRyaXgnKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHRvQ3JlYXRlR2VvZmVuY2VDb2xsZWN0aW9uKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdDcmVhdGVHZW9mZW5jZUNvbGxlY3Rpb24nKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9DcmVhdGVNYXAoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0NyZWF0ZU1hcCcpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b0NyZWF0ZVBsYWNlSW5kZXgoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0NyZWF0ZVBsYWNlSW5kZXgnKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHRvQ3JlYXRlUm91dGVDYWxjdWxhdG9yKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdDcmVhdGVSb3V0ZUNhbGN1bGF0b3InKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b0NyZWF0ZVRyYWNrZXIoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0NyZWF0ZVRyYWNrZXInKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b0RlbGV0ZUdlb2ZlbmNlQ29sbGVjdGlvbigpIHtcbiAgICByZXR1cm4gdGhpcy50bygnRGVsZXRlR2VvZmVuY2VDb2xsZWN0aW9uJyk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b0RlbGV0ZU1hcCgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnRGVsZXRlTWFwJyk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b0RlbGV0ZVBsYWNlSW5kZXgoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0RlbGV0ZVBsYWNlSW5kZXgnKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b0RlbGV0ZVJvdXRlQ2FsY3VsYXRvcigpIHtcbiAgICByZXR1cm4gdGhpcy50bygnRGVsZXRlUm91dGVDYWxjdWxhdG9yJyk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHRvRGVsZXRlVHJhY2tlcigpIHtcbiAgICByZXR1cm4gdGhpcy50bygnRGVsZXRlVHJhY2tlcicpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHRvRGVzY3JpYmVHZW9mZW5jZUNvbGxlY3Rpb24oKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0Rlc2NyaWJlR2VvZmVuY2VDb2xsZWN0aW9uJyk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b0Rlc2NyaWJlTWFwKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdEZXNjcmliZU1hcCcpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9EZXNjcmliZVBsYWNlSW5kZXgoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0Rlc2NyaWJlUGxhY2VJbmRleCcpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHRvRGVzY3JpYmVSb3V0ZUNhbGN1bGF0b3IoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0Rlc2NyaWJlUm91dGVDYWxjdWxhdG9yJyk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9EZXNjcmliZVRyYWNrZXIoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0Rlc2NyaWJlVHJhY2tlcicpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9EaXNhc3NvY2lhdGVUcmFja2VyQ29uc3VtZXIoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0Rpc2Fzc29jaWF0ZVRyYWNrZXJDb25zdW1lcicpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9HZXREZXZpY2VQb3NpdGlvbigpIHtcbiAgICByZXR1cm4gdGhpcy50bygnR2V0RGV2aWNlUG9zaXRpb24nKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9HZXREZXZpY2VQb3NpdGlvbkhpc3RvcnkoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0dldERldmljZVBvc2l0aW9uSGlzdG9yeScpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9HZXRHZW9mZW5jZSgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnR2V0R2VvZmVuY2UnKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9HZXRNYXBHbHlwaHMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0dldE1hcEdseXBocycpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHRvR2V0TWFwU3ByaXRlcygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnR2V0TWFwU3ByaXRlcycpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHRvR2V0TWFwU3R5bGVEZXNjcmlwdG9yKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdHZXRNYXBTdHlsZURlc2NyaXB0b3InKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b0dldE1hcFRpbGUoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0dldE1hcFRpbGUnKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b0xpc3REZXZpY2VQb3NpdGlvbnMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0xpc3REZXZpY2VQb3NpdGlvbnMnKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHRvTGlzdEdlb2ZlbmNlQ29sbGVjdGlvbnMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0xpc3RHZW9mZW5jZUNvbGxlY3Rpb25zJyk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9MaXN0R2VvZmVuY2VzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdMaXN0R2VvZmVuY2VzJyk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9MaXN0TWFwcygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnTGlzdE1hcHMnKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9MaXN0UGxhY2VJbmRleGVzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdMaXN0UGxhY2VJbmRleGVzJyk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHRvTGlzdFJvdXRlQ2FsY3VsYXRvcnMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0xpc3RSb3V0ZUNhbGN1bGF0b3JzJyk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9MaXN0VGFnc0ZvclJlc291cmNlKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdMaXN0VGFnc0ZvclJlc291cmNlJyk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9MaXN0VHJhY2tlckNvbnN1bWVycygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnTGlzdFRyYWNrZXJDb25zdW1lcnMnKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHRvTGlzdFRyYWNrZXJzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdMaXN0VHJhY2tlcnMnKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b1B1dEdlb2ZlbmNlKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdQdXRHZW9mZW5jZScpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHRvU2VhcmNoUGxhY2VJbmRleEZvclBvc2l0aW9uKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdTZWFyY2hQbGFjZUluZGV4Rm9yUG9zaXRpb24nKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHRvU2VhcmNoUGxhY2VJbmRleEZvclN1Z2dlc3Rpb25zKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdTZWFyY2hQbGFjZUluZGV4Rm9yU3VnZ2VzdGlvbnMnKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9TZWFyY2hQbGFjZUluZGV4Rm9yVGV4dCgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnU2VhcmNoUGxhY2VJbmRleEZvclRleHQnKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHRvVGFnUmVzb3VyY2UoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1RhZ1Jlc291cmNlJyk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9VbnRhZ1Jlc291cmNlKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdVbnRhZ1Jlc291cmNlJyk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9VcGRhdGVHZW9mZW5jZUNvbGxlY3Rpb24oKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1VwZGF0ZUdlb2ZlbmNlQ29sbGVjdGlvbicpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9VcGRhdGVNYXAoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1VwZGF0ZU1hcCcpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9VcGRhdGVQbGFjZUluZGV4KCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdVcGRhdGVQbGFjZUluZGV4Jyk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9VcGRhdGVSb3V0ZUNhbGN1bGF0b3IoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1VwZGF0ZVJvdXRlQ2FsY3VsYXRvcicpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b1VwZGF0ZVRyYWNrZXIoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1VwZGF0ZVRyYWNrZXInKTtcbiAgfVxuXG4gIHByb3RlY3RlZCBhY2Nlc3NMZXZlbExpc3Q6IEFjY2Vzc0xldmVsTGlzdCA9IHtcbiAgICBXcml0ZTogW1xuICAgICAgJ0Fzc29jaWF0ZVRyYWNrZXJDb25zdW1lcicsXG4gICAgICAnQmF0Y2hEZWxldGVEZXZpY2VQb3NpdGlvbkhpc3RvcnknLFxuICAgICAgJ0JhdGNoRGVsZXRlR2VvZmVuY2UnLFxuICAgICAgJ0JhdGNoRXZhbHVhdGVHZW9mZW5jZXMnLFxuICAgICAgJ0JhdGNoUHV0R2VvZmVuY2UnLFxuICAgICAgJ0JhdGNoVXBkYXRlRGV2aWNlUG9zaXRpb24nLFxuICAgICAgJ0NyZWF0ZUdlb2ZlbmNlQ29sbGVjdGlvbicsXG4gICAgICAnQ3JlYXRlTWFwJyxcbiAgICAgICdDcmVhdGVQbGFjZUluZGV4JyxcbiAgICAgICdDcmVhdGVSb3V0ZUNhbGN1bGF0b3InLFxuICAgICAgJ0NyZWF0ZVRyYWNrZXInLFxuICAgICAgJ0RlbGV0ZUdlb2ZlbmNlQ29sbGVjdGlvbicsXG4gICAgICAnRGVsZXRlTWFwJyxcbiAgICAgICdEZWxldGVQbGFjZUluZGV4JyxcbiAgICAgICdEZWxldGVSb3V0ZUNhbGN1bGF0b3InLFxuICAgICAgJ0RlbGV0ZVRyYWNrZXInLFxuICAgICAgJ0Rpc2Fzc29jaWF0ZVRyYWNrZXJDb25zdW1lcicsXG4gICAgICAnUHV0R2VvZmVuY2UnLFxuICAgICAgJ1VwZGF0ZUdlb2ZlbmNlQ29sbGVjdGlvbicsXG4gICAgICAnVXBkYXRlTWFwJyxcbiAgICAgICdVcGRhdGVQbGFjZUluZGV4JyxcbiAgICAgICdVcGRhdGVSb3V0ZUNhbGN1bGF0b3InLFxuICAgICAgJ1VwZGF0ZVRyYWNrZXInXG4gICAgXSxcbiAgICBSZWFkOiBbXG4gICAgICAnQmF0Y2hHZXREZXZpY2VQb3NpdGlvbicsXG4gICAgICAnQ2FsY3VsYXRlUm91dGUnLFxuICAgICAgJ0NhbGN1bGF0ZVJvdXRlTWF0cml4JyxcbiAgICAgICdEZXNjcmliZUdlb2ZlbmNlQ29sbGVjdGlvbicsXG4gICAgICAnRGVzY3JpYmVNYXAnLFxuICAgICAgJ0Rlc2NyaWJlUGxhY2VJbmRleCcsXG4gICAgICAnRGVzY3JpYmVSb3V0ZUNhbGN1bGF0b3InLFxuICAgICAgJ0Rlc2NyaWJlVHJhY2tlcicsXG4gICAgICAnR2V0RGV2aWNlUG9zaXRpb24nLFxuICAgICAgJ0dldERldmljZVBvc2l0aW9uSGlzdG9yeScsXG4gICAgICAnR2V0R2VvZmVuY2UnLFxuICAgICAgJ0dldE1hcEdseXBocycsXG4gICAgICAnR2V0TWFwU3ByaXRlcycsXG4gICAgICAnR2V0TWFwU3R5bGVEZXNjcmlwdG9yJyxcbiAgICAgICdHZXRNYXBUaWxlJyxcbiAgICAgICdMaXN0RGV2aWNlUG9zaXRpb25zJyxcbiAgICAgICdMaXN0R2VvZmVuY2VzJyxcbiAgICAgICdMaXN0VGFnc0ZvclJlc291cmNlJyxcbiAgICAgICdMaXN0VHJhY2tlckNvbnN1bWVycycsXG4gICAgICAnU2VhcmNoUGxhY2VJbmRleEZvclBvc2l0aW9uJyxcbiAgICAgICdTZWFyY2hQbGFjZUluZGV4Rm9yU3VnZ2VzdGlvbnMnLFxuICAgICAgJ1NlYXJjaFBsYWNlSW5kZXhGb3JUZXh0J1xuICAgIF0sXG4gICAgTGlzdDogW1xuICAgICAgJ0xpc3RHZW9mZW5jZUNvbGxlY3Rpb25zJyxcbiAgICAgICdMaXN0TWFwcycsXG4gICAgICAnTGlzdFBsYWNlSW5kZXhlcycsXG4gICAgICAnTGlzdFJvdXRlQ2FsY3VsYXRvcnMnLFxuICAgICAgJ0xpc3RUcmFja2VycydcbiAgICBdLFxuICAgIFRhZ2dpbmc6IFtcbiAgICAgICdUYWdSZXNvdXJjZScsXG4gICAgICAnVW50YWdSZXNvdXJjZSdcbiAgICBdXG4gIH07XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgb25HZW9mZW5jZUNvbGxlY3Rpb24oZ2VvZmVuY2VDb2xsZWN0aW9uTmFtZTogc3RyaW5nLCBhY2NvdW50Pzogc3RyaW5nLCByZWdpb24/OiBzdHJpbmcsIHBhcnRpdGlvbj86IHN0cmluZykge1xuICAgIHJldHVybiB0aGlzLm9uKGBhcm46JHsgcGFydGl0aW9uIHx8ICdhd3MnIH06Z2VvOiR7IHJlZ2lvbiB8fCAnKicgfTokeyBhY2NvdW50IHx8ICcqJyB9Omdlb2ZlbmNlLWNvbGxlY3Rpb24vJHsgZ2VvZmVuY2VDb2xsZWN0aW9uTmFtZSB9YCk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBvbk1hcChtYXBOYW1lOiBzdHJpbmcsIGFjY291bnQ/OiBzdHJpbmcsIHJlZ2lvbj86IHN0cmluZywgcGFydGl0aW9uPzogc3RyaW5nKSB7XG4gICAgcmV0dXJuIHRoaXMub24oYGFybjokeyBwYXJ0aXRpb24gfHwgJ2F3cycgfTpnZW86JHsgcmVnaW9uIHx8ICcqJyB9OiR7IGFjY291bnQgfHwgJyonIH06bWFwLyR7IG1hcE5hbWUgfWApO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgb25QbGFjZUluZGV4KGluZGV4TmFtZTogc3RyaW5nLCBhY2NvdW50Pzogc3RyaW5nLCByZWdpb24/OiBzdHJpbmcsIHBhcnRpdGlvbj86IHN0cmluZykge1xuICAgIHJldHVybiB0aGlzLm9uKGBhcm46JHsgcGFydGl0aW9uIHx8ICdhd3MnIH06Z2VvOiR7IHJlZ2lvbiB8fCAnKicgfTokeyBhY2NvdW50IHx8ICcqJyB9OnBsYWNlLWluZGV4LyR7IGluZGV4TmFtZSB9YCk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBvblJvdXRlQ2FsY3VsYXRvcihjYWxjdWxhdG9yTmFtZTogc3RyaW5nLCBhY2NvdW50Pzogc3RyaW5nLCByZWdpb24/OiBzdHJpbmcsIHBhcnRpdGlvbj86IHN0cmluZykge1xuICAgIHJldHVybiB0aGlzLm9uKGBhcm46JHsgcGFydGl0aW9uIHx8ICdhd3MnIH06Z2VvOiR7IHJlZ2lvbiB8fCAnKicgfTokeyBhY2NvdW50IHx8ICcqJyB9OnJvdXRlLWNhbGN1bGF0b3IvJHsgY2FsY3VsYXRvck5hbWUgfWApO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBvblRyYWNrZXIodHJhY2tlck5hbWU6IHN0cmluZywgYWNjb3VudD86IHN0cmluZywgcmVnaW9uPzogc3RyaW5nLCBwYXJ0aXRpb24/OiBzdHJpbmcpIHtcbiAgICByZXR1cm4gdGhpcy5vbihgYXJuOiR7IHBhcnRpdGlvbiB8fCAnYXdzJyB9OmdlbzokeyByZWdpb24gfHwgJyonIH06JHsgYWNjb3VudCB8fCAnKicgfTp0cmFja2VyLyR7IHRyYWNrZXJOYW1lIH1gKTtcbiAgfVxufVxuIl19