import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * (experimental) Statement provider for service [worklink](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonworklink.html).
 *
 * @experimental
 */
export declare class Worklink extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [worklink](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonworklink.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Grants permission to associate a domain with an Amazon WorkLink fleet.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/worklink/latest/api/API_AssociateDomain.html
     *
     * @experimental
     */
    toAssociateDomain(): this;
    /**
     * (experimental) Grants permission to associate a website authorization provider with an Amazon WorkLink fleet.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/worklink/latest/api/API_AssociateWebsiteAuthorizationProvider.html
     *
     * @experimental
     */
    toAssociateWebsiteAuthorizationProvider(): this;
    /**
     * (experimental) Grants permission to associate a website certificate authority with an Amazon WorkLink fleet.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/worklink/latest/api/API_AssociateWebsiteCertificateAuthority.html
     *
     * @experimental
     */
    toAssociateWebsiteCertificateAuthority(): this;
    /**
     * (experimental) Grants permission to create an Amazon WorkLink fleet.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/worklink/latest/api/API_CreateFleet.html
     *
     * @experimental
     */
    toCreateFleet(): this;
    /**
     * (experimental) Grants permission to delete an Amazon WorkLink fleet.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/worklink/latest/api/API_DeleteFleet.html
     *
     * @experimental
     */
    toDeleteFleet(): this;
    /**
     * (experimental) Grants permission to describe the audit stream configuration for an Amazon WorkLink fleet.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/worklink/latest/api/API_DescribeAuditStreamConfiguration.html
     *
     * @experimental
     */
    toDescribeAuditStreamConfiguration(): this;
    /**
     * (experimental) Grants permission to describe the company network configuration for an Amazon WorkLink fleet.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/worklink/latest/api/API_DescribeCompanyNetworkConfiguration.html
     *
     * @experimental
     */
    toDescribeCompanyNetworkConfiguration(): this;
    /**
     * (experimental) Grants permission to describe details of a device associated with an Amazon WorkLink fleet.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/worklink/latest/api/API_DescribeDevice.html
     *
     * @experimental
     */
    toDescribeDevice(): this;
    /**
     * (experimental) Grants permission to describe the device policy configuration for an Amazon WorkLink fleet.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/worklink/latest/api/API_DescribeDevicePolicyConfiguration.html
     *
     * @experimental
     */
    toDescribeDevicePolicyConfiguration(): this;
    /**
     * (experimental) Grants permission to describe details about a domain associated with an Amazon WorkLink fleet.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/worklink/latest/api/API_DescribeDomain.html
     *
     * @experimental
     */
    toDescribeDomain(): this;
    /**
     * (experimental) Grants permission to describe metadata of an Amazon WorkLink fleet.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/worklink/latest/api/API_DescribeFleetMetadata.html
     *
     * @experimental
     */
    toDescribeFleetMetadata(): this;
    /**
     * (experimental) Grants permission to describe the identity provider configuration for an Amazon WorkLink fleet.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/worklink/latest/api/API_DescribeIdentityProviderConfiguration.html
     *
     * @experimental
     */
    toDescribeIdentityProviderConfiguration(): this;
    /**
     * (experimental) Grants permission to describe a website certificate authority associated with an Amazon WorkLink fleet.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/worklink/latest/api/API_DescribeWebsiteCertificateAuthority.html
     *
     * @experimental
     */
    toDescribeWebsiteCertificateAuthority(): this;
    /**
     * (experimental) Grants permission to disassociate a domain from an Amazon WorkLink fleet.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/worklink/latest/api/API_DisassociateDomain.html
     *
     * @experimental
     */
    toDisassociateDomain(): this;
    /**
     * (experimental) Grants permission to disassociate a website authorization provider from an Amazon WorkLink fleet.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/worklink/latest/api/API_DisassociateWebsiteAuthorizationProvider.html
     *
     * @experimental
     */
    toDisassociateWebsiteAuthorizationProvider(): this;
    /**
     * (experimental) Grants permission to disassociate a website certificate authority from an Amazon WorkLink fleet.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/worklink/latest/api/API_DisassociateWebsiteCertificateAuthority.html
     *
     * @experimental
     */
    toDisassociateWebsiteCertificateAuthority(): this;
    /**
     * (experimental) Grants permission to list the devices associated with an Amazon WorkLink fleet.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/worklink/latest/api/API_ListDevices.html
     *
     * @experimental
     */
    toListDevices(): this;
    /**
     * (experimental) Grants permission to list the associated domains for an Amazon WorkLink fleet.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/worklink/latest/api/API_ListDomains.html
     *
     * @experimental
     */
    toListDomains(): this;
    /**
     * (experimental) Grants permission to list the Amazon WorkLink fleets associated with the account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/worklink/latest/api/API_ListFleets.html
     *
     * @experimental
     */
    toListFleets(): this;
    /**
     * (experimental) Grants permission to list tags for a resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/worklink/latest/api/API_ListTagsForResource.html
     *
     * @experimental
     */
    toListTagsForResource(): this;
    /**
     * (experimental) Grants permission to list the website authorization providers for an Amazon WorkLink fleet.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/worklink/latest/api/API_ListWebsiteAuthorizationProviders.html
     *
     * @experimental
     */
    toListWebsiteAuthorizationProviders(): this;
    /**
     * (experimental) Grants permission to list the website certificate authorities associated with an Amazon WorkLink fleet.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/worklink/latest/api/API_ListWebsiteCertificateAuthorities.html
     *
     * @experimental
     */
    toListWebsiteCertificateAuthorities(): this;
    /**
     * (experimental) Grants permission to restore access to a domain associated with an Amazon WorkLink fleet.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/worklink/latest/api/API_RestoreDomainAccess.html
     *
     * @experimental
     */
    toRestoreDomainAccess(): this;
    /**
     * (experimental) Grants permission to revoke access to a domain associated with an Amazon WorkLink fleet.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/worklink/latest/api/API_RevokeDomainAccess.html
     *
     * @experimental
     */
    toRevokeDomainAccess(): this;
    /**
     * (experimental) Grants permission to list devices for an Amazon WorkLink fleet.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/worklink/latest/ag/manage-devices.html
     *
     * @experimental
     */
    toSearchEntity(): this;
    /**
     * (experimental) Grants permission to sign out a user from an Amazon WorkLink fleet.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/worklink/latest/api/API_SignOutUser.html
     *
     * @experimental
     */
    toSignOutUser(): this;
    /**
     * (experimental) Grants permission to add one or more tags to a resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/worklink/latest/api/API_TagResource.html
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Grants permission to remove one or more tags from a resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/worklink/latest/api/API_UntagResource.html
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * (experimental) Grants permission to update the audit stream configuration for an Amazon WorkLink fleet.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/worklink/latest/api/API_UpdateAuditStreamConfiguration.html
     *
     * @experimental
     */
    toUpdateAuditStreamConfiguration(): this;
    /**
     * (experimental) Grants permission to update the company network configuration for an Amazon WorkLink fleet.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/worklink/latest/api/API_UpdateCompanyNetworkConfiguration.html
     *
     * @experimental
     */
    toUpdateCompanyNetworkConfiguration(): this;
    /**
     * (experimental) Grants permission to update the device policy configuration for an Amazon WorkLink fleet.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/worklink/latest/api/API_UpdateDevicePolicyConfiguration.html
     *
     * @experimental
     */
    toUpdateDevicePolicyConfiguration(): this;
    /**
     * (experimental) Grants permission to update the metadata for a domain associated with an Amazon WorkLink fleet.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/worklink/latest/api/API_UpdateDomainMetadata.html
     *
     * @experimental
     */
    toUpdateDomainMetadata(): this;
    /**
     * (experimental) Grants permission to update the metadata of an Amazon WorkLink fleet.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/worklink/latest/api/API_UpdateFleetMetadata.html
     *
     * @experimental
     */
    toUpdateFleetMetadata(): this;
    /**
     * (experimental) Grants permission to update the identity provider configuration for an Amazon WorkLink fleet.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/worklink/latest/api/API_UpdateIdentityProviderConfiguration.html
     *
     * @experimental
     */
    toUpdateIdentityProviderConfiguration(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type fleet to the statement.
     *
     * https://docs.aws.amazon.com/worklink/latest/api/API_CreateFleet.html
     *
     * @param fleetName - Identifier for the fleetName.
     * @param account - Account of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onFleet(fleetName: string, account?: string, partition?: string): this;
}
