import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * (experimental) Statement provider for service [workspaces-web](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonworkspacesweb.html).
 *
 * @experimental
 */
export declare class WorkspacesWeb extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [workspaces-web](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonworkspacesweb.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Grants permission to associate browser settings to web portals.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_AssociateBrowserSettings.html
     *
     * @experimental
     */
    toAssociateBrowserSettings(): this;
    /**
     * (experimental) Grants permission to associate network settings to web portals.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - ec2:CreateNetworkInterface
     * - ec2:CreateNetworkInterfacePermission
     * - ec2:CreateTags
     * - ec2:DeleteNetworkInterface
     * - ec2:DeleteNetworkInterfacePermission
     * - ec2:ModifyNetworkInterfaceAttribute
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_AssociateNetworkSettings.html
     *
     * @experimental
     */
    toAssociateNetworkSettings(): this;
    /**
     * (experimental) Grants permission to associate trust stores with web portals.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_AssociateTrustStore.html
     *
     * @experimental
     */
    toAssociateTrustStore(): this;
    /**
     * (experimental) Grants permission to associate user settings with web portals.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_AssociateUserSettings.html
     *
     * @experimental
     */
    toAssociateUserSettings(): this;
    /**
     * (experimental) Grants permission to create browser settings.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * Dependent actions:
     * - kms:CreateGrant
     * - kms:Decrypt
     * - kms:DescribeKey
     * - kms:GenerateDataKey
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_CreateBrowserSettings.html
     *
     * @experimental
     */
    toCreateBrowserSettings(): this;
    /**
     * (experimental) Grants permission to create identity providers.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_CreateIdentityProvider.html
     *
     * @experimental
     */
    toCreateIdentityProvider(): this;
    /**
     * (experimental) Grants permission to create network settings.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_CreateNetworkSettings.html
     *
     * @experimental
     */
    toCreateNetworkSettings(): this;
    /**
     * (experimental) Grants permission to create web portals.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * Dependent actions:
     * - iam:CreateServiceLinkedRole
     * - kms:CreateGrant
     * - kms:Decrypt
     * - kms:DescribeKey
     * - kms:GenerateDataKey
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_CreatePortal.html
     *
     * @experimental
     */
    toCreatePortal(): this;
    /**
     * (experimental) Grants permission to create trust stores.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_CreateTrustStore.html
     *
     * @experimental
     */
    toCreateTrustStore(): this;
    /**
     * (experimental) Grants permission to create user settings.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_CreateUserSettings.html
     *
     * @experimental
     */
    toCreateUserSettings(): this;
    /**
     * (experimental) Grants permission to delete browser settings.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_DeleteBrowserSettings.html
     *
     * @experimental
     */
    toDeleteBrowserSettings(): this;
    /**
     * (experimental) Grants permission to delete identity providers.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_DeleteIdentityProvider.html
     *
     * @experimental
     */
    toDeleteIdentityProvider(): this;
    /**
     * (experimental) Grants permission to delete network settings.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_DeleteNetworkSettings.html
     *
     * @experimental
     */
    toDeleteNetworkSettings(): this;
    /**
     * (experimental) Grants permission to delete web portals.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_DeletePortal.html
     *
     * @experimental
     */
    toDeletePortal(): this;
    /**
     * (experimental) Grants permission to delete trust stores.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_DeleteTrustStore.html
     *
     * @experimental
     */
    toDeleteTrustStore(): this;
    /**
     * (experimental) Grants permission to delete user settings.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_DeleteUserSettings.html
     *
     * @experimental
     */
    toDeleteUserSettings(): this;
    /**
     * (experimental) Grants permission to disassociate browser settings from web portals.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_DisassociateBrowserSettings.html
     *
     * @experimental
     */
    toDisassociateBrowserSettings(): this;
    /**
     * (experimental) Grants permission to disassociate network settings from web portals.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_DisassociateNetworkSettings.html
     *
     * @experimental
     */
    toDisassociateNetworkSettings(): this;
    /**
     * (experimental) Grants permission to disassociate trust stores from web portals.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_DisassociateTrustStore.html
     *
     * @experimental
     */
    toDisassociateTrustStore(): this;
    /**
     * (experimental) Grants permission to disassociate user settings from web portals.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_DisassociateUserSettings.html
     *
     * @experimental
     */
    toDisassociateUserSettings(): this;
    /**
     * (experimental) Grants permission to get details on browser settings.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_GetBrowserSettings.html
     *
     * @experimental
     */
    toGetBrowserSettings(): this;
    /**
     * (experimental) Grants permission to get details on identity providers.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_GetIdentityProvider.html
     *
     * @experimental
     */
    toGetIdentityProvider(): this;
    /**
     * (experimental) Grants permission to get details on network settings.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_GetNetworkSettings.html
     *
     * @experimental
     */
    toGetNetworkSettings(): this;
    /**
     * (experimental) Grants permission to get details on web portals.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_GetPortal.html
     *
     * @experimental
     */
    toGetPortal(): this;
    /**
     * (experimental) Grants permission to get service provider metadata information for web portals.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_GetPortalServiceProviderMetadata.html
     *
     * @experimental
     */
    toGetPortalServiceProviderMetadata(): this;
    /**
     * (experimental) Grants permission to get details on trust stores.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_GetTrustStore.html
     *
     * @experimental
     */
    toGetTrustStore(): this;
    /**
     * (experimental) Grants permission to get certificates from trust stores.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_GetTrustStoreCertificate.html
     *
     * @experimental
     */
    toGetTrustStoreCertificate(): this;
    /**
     * (experimental) Grants permission to get details on user settings.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_GetUserSettings.html
     *
     * @experimental
     */
    toGetUserSettings(): this;
    /**
     * (experimental) Grants permission to list browser settings.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_ListBrowserSettings.html
     *
     * @experimental
     */
    toListBrowserSettings(): this;
    /**
     * (experimental) Grants permission to list identity providers.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_ListIdentityProviders.html
     *
     * @experimental
     */
    toListIdentityProviders(): this;
    /**
     * (experimental) Grants permission to list network settings.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_ListNetworkSettings.html
     *
     * @experimental
     */
    toListNetworkSettings(): this;
    /**
     * (experimental) Grants permission to list web portals.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_ListPortals.html
     *
     * @experimental
     */
    toListPortals(): this;
    /**
     * (experimental) Grants permission to list tags for a resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_ListTagsForResource.html
     *
     * @experimental
     */
    toListTagsForResource(): this;
    /**
     * (experimental) Grants permission to list certificates in a trust store.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_ListTrustStoreCertificates.html
     *
     * @experimental
     */
    toListTrustStoreCertificates(): this;
    /**
     * (experimental) Grants permission to list trust stores.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_ListTrustStores.html
     *
     * @experimental
     */
    toListTrustStores(): this;
    /**
     * (experimental) Grants permission to list user settings.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_ListUserSettings.html
     *
     * @experimental
     */
    toListUserSettings(): this;
    /**
     * (experimental) Grants permission to add one or more tags to a resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_TagResource.html
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Grants permission to remove one or more tags from a resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_UntagResource.html
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * (experimental) Grants permission to update browser settings.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_UpdateBrowserSettings.html
     *
     * @experimental
     */
    toUpdateBrowserSettings(): this;
    /**
     * (experimental) Grants permission to update identity provider.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_UpdateIdentityProvider.html
     *
     * @experimental
     */
    toUpdateIdentityProvider(): this;
    /**
     * (experimental) Grants permission to update network settings.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_UpdateNetworkSettings.html
     *
     * @experimental
     */
    toUpdateNetworkSettings(): this;
    /**
     * (experimental) Grants permission to update web portals.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_UpdatePortal.html
     *
     * @experimental
     */
    toUpdatePortal(): this;
    /**
     * (experimental) Grants permission to update trust stores.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_UpdateTrustStore.html
     *
     * @experimental
     */
    toUpdateTrustStore(): this;
    /**
     * (experimental) Grants permission to update user settings.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_UpdateUserSettings.html
     *
     * @experimental
     */
    toUpdateUserSettings(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type browserSettings to the statement.
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_CreateBrowserSettings.html
     *
     * @param browserSettingsId - Identifier for the browserSettingsId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onBrowserSettings(browserSettingsId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type networkSettings to the statement.
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_CreateNetworkSettings.html
     *
     * @param networkSettingsId - Identifier for the networkSettingsId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onNetworkSettings(networkSettingsId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type portal to the statement.
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_CreatePortal.html
     *
     * @param portalId - Identifier for the portalId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onPortal(portalId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type trustStore to the statement.
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_CreateTrustStore.html
     *
     * @param trustStoreId - Identifier for the trustStoreId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onTrustStore(trustStoreId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type userSettings to the statement.
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_CreateUserSettings.html
     *
     * @param userSettingsId - Identifier for the userSettingsId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onUserSettings(userSettingsId: string, account?: string, region?: string, partition?: string): this;
}
