"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ECRDeployment = exports.S3ArchiveName = exports.DockerImageName = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
const child_process = require("child_process");
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
function getCode(buildImage) {
    const { CI, NO_PREBUILT_LAMBDA } = process.env;
    if (!(CI && ['true', true, 1, '1'].includes(CI)) || (NO_PREBUILT_LAMBDA && ['true', true, 1, '1'].includes(NO_PREBUILT_LAMBDA))) {
        try {
            console.log('Try to get prebuilt lambda');
            const installScript = path.join(__dirname, '../lambda/install.js');
            const prebuiltPath = path.join(__dirname, '../lambda/out');
            child_process.execSync(`${process.argv0} ${installScript} ${prebuiltPath}`);
            return aws_cdk_lib_1.aws_lambda.Code.fromAsset(prebuiltPath);
        }
        catch (err) {
            console.warn(`Can not get prebuilt lambda: ${err}`);
        }
    }
    console.log('Build lambda from scratch');
    return aws_cdk_lib_1.aws_lambda.Code.fromDockerBuild(path.join(__dirname, '../lambda'), {
        buildArgs: {
            buildImage,
        },
    });
}
/**
 * @stability stable
 */
class DockerImageName {
    /**
     * @stability stable
     */
    constructor(name, creds) {
        this.name = name;
        this.creds = creds;
    }
    /**
     * The uri of the docker image.
     *
     * The uri spec follows https://github.com/containers/skopeo
     *
     * @stability stable
     */
    get uri() { return `docker://${this.name}`; }
}
exports.DockerImageName = DockerImageName;
_a = JSII_RTTI_SYMBOL_1;
DockerImageName[_a] = { fqn: "cdk-ecr-deployment.DockerImageName", version: "2.3.1" };
/**
 * @stability stable
 */
class S3ArchiveName {
    /**
     * @stability stable
     */
    constructor(p, ref, creds) {
        this.creds = creds;
        this.name = p;
        if (ref) {
            this.name += ':' + ref;
        }
    }
    /**
     * The uri of the docker image.
     *
     * The uri spec follows https://github.com/containers/skopeo
     *
     * @stability stable
     */
    get uri() { return `s3://${this.name}`; }
}
exports.S3ArchiveName = S3ArchiveName;
_b = JSII_RTTI_SYMBOL_1;
S3ArchiveName[_b] = { fqn: "cdk-ecr-deployment.S3ArchiveName", version: "2.3.1" };
/**
 * @stability stable
 */
class ECRDeployment extends constructs_1.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _d, _e;
        super(scope, id);
        const memoryLimit = (_d = props.memoryLimit) !== null && _d !== void 0 ? _d : 512;
        const handler = new aws_cdk_lib_1.aws_lambda.SingletonFunction(this, 'CustomResourceHandler', {
            uuid: this.renderSingletonUuid(memoryLimit),
            code: getCode((_e = props.buildImage) !== null && _e !== void 0 ? _e : 'public.ecr.aws/sam/build-go1.x:latest'),
            runtime: aws_cdk_lib_1.aws_lambda.Runtime.GO_1_X,
            handler: 'main',
            environment: props.environment,
            lambdaPurpose: 'Custom::CDKECRDeployment',
            timeout: aws_cdk_lib_1.Duration.minutes(15),
            role: props.role,
            memorySize: memoryLimit,
            vpc: props.vpc,
            vpcSubnets: props.vpcSubnets,
        });
        const handlerRole = handler.role;
        if (!handlerRole) {
            throw new Error('lambda.SingletonFunction should have created a Role');
        }
        handlerRole.addToPrincipalPolicy(new aws_cdk_lib_1.aws_iam.PolicyStatement({
            effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
            actions: [
                'ecr:GetAuthorizationToken',
                'ecr:BatchCheckLayerAvailability',
                'ecr:GetDownloadUrlForLayer',
                'ecr:GetRepositoryPolicy',
                'ecr:DescribeRepositories',
                'ecr:ListImages',
                'ecr:DescribeImages',
                'ecr:BatchGetImage',
                'ecr:ListTagsForResource',
                'ecr:DescribeImageScanFindings',
                'ecr:InitiateLayerUpload',
                'ecr:UploadLayerPart',
                'ecr:CompleteLayerUpload',
                'ecr:PutImage',
            ],
            resources: ['*'],
        }));
        handlerRole.addToPrincipalPolicy(new aws_cdk_lib_1.aws_iam.PolicyStatement({
            effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
            actions: [
                's3:GetObject',
            ],
            resources: ['*'],
        }));
        new aws_cdk_lib_1.CustomResource(this, 'CustomResource', {
            serviceToken: handler.functionArn,
            resourceType: 'Custom::CDKBucketDeployment',
            properties: {
                SrcImage: props.src.uri,
                SrcCreds: props.src.creds,
                DestImage: props.dest.uri,
                DestCreds: props.dest.creds,
            },
        });
    }
    renderSingletonUuid(memoryLimit) {
        let uuid = 'bd07c930-edb9-4112-a20f-03f096f53666';
        // if user specify a custom memory limit, define another singleton handler
        // with this configuration. otherwise, it won't be possible to use multiple
        // configurations since we have a singleton.
        if (memoryLimit) {
            if (aws_cdk_lib_1.Token.isUnresolved(memoryLimit)) {
                throw new Error('Can\'t use tokens when specifying "memoryLimit" since we use it to identify the singleton custom resource handler');
            }
            uuid += `-${memoryLimit.toString()}MiB`;
        }
        return uuid;
    }
}
exports.ECRDeployment = ECRDeployment;
_c = JSII_RTTI_SYMBOL_1;
ECRDeployment[_c] = { fqn: "cdk-ecr-deployment.ECRDeployment", version: "2.3.1" };
//# sourceMappingURL=data:application/json;base64,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