import { Message } from "./message";
import { isString } from "../core/util/types";
import { assert } from "../core/util/assert";
export class Receiver {
    static __name__ = "Receiver";
    message = null;
    _partial = null;
    _fragments = [];
    _buf_header = null;
    _current_consumer = this._HEADER;
    consume(fragment) {
        this._current_consumer(fragment);
    }
    _HEADER(fragment) {
        this._assume_text(fragment);
        this.message = null;
        this._partial = null;
        this._fragments = [fragment];
        this._buf_header = null;
        this._current_consumer = this._METADATA;
    }
    _METADATA(fragment) {
        this._assume_text(fragment);
        this._fragments.push(fragment);
        this._current_consumer = this._CONTENT;
    }
    _CONTENT(fragment) {
        this._assume_text(fragment);
        this._fragments.push(fragment);
        const [header_json, metadata_json, content_json] = this._fragments;
        assert(header_json != null && metadata_json != null && content_json != null);
        this._partial = Message.assemble(header_json, metadata_json, content_json);
        this._check_complete();
    }
    _BUFFER_HEADER(fragment) {
        this._assume_text(fragment);
        this._buf_header = fragment;
        this._current_consumer = this._BUFFER_PAYLOAD;
    }
    _BUFFER_PAYLOAD(fragment) {
        this._assume_binary(fragment);
        assert(this._partial != null && this._buf_header != null);
        this._partial.assemble_buffer(this._buf_header, fragment);
        this._check_complete();
    }
    _assume_text(fragment) {
        if (!isString(fragment))
            throw new Error("Expected text fragment but received binary fragment");
    }
    _assume_binary(fragment) {
        if (!(fragment instanceof ArrayBuffer))
            throw new Error("Expected binary fragment but received text fragment");
    }
    _check_complete() {
        if (this._partial.complete()) {
            this.message = this._partial;
            this._current_consumer = this._HEADER;
        }
        else
            this._current_consumer = this._BUFFER_HEADER;
    }
}
//# sourceMappingURL=receiver.js.map