# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['hammer',
 'hammer.common',
 'hammer.common.cadence',
 'hammer.common.mentor',
 'hammer.common.openroad',
 'hammer.common.synopsys',
 'hammer.common.vivado',
 'hammer.config',
 'hammer.drc.magic',
 'hammer.drc.mockdrc',
 'hammer.drc.nop',
 'hammer.drc.openroad',
 'hammer.logging',
 'hammer.lvs.mocklvs',
 'hammer.lvs.netgen',
 'hammer.lvs.nop',
 'hammer.par.mockpar',
 'hammer.par.nop',
 'hammer.par.openroad',
 'hammer.par.vivado',
 'hammer.pcb.generic',
 'hammer.shell',
 'hammer.sim.mocksim',
 'hammer.sram_generator.mocksram_generator',
 'hammer.sram_generator.nop',
 'hammer.synthesis',
 'hammer.synthesis.mocksynth',
 'hammer.synthesis.vivado',
 'hammer.synthesis.yosys',
 'hammer.tech',
 'hammer.technology.asap7',
 'hammer.technology.asap7.sram_compiler',
 'hammer.technology.nangate45',
 'hammer.technology.nangate45.sram_compiler',
 'hammer.technology.nop',
 'hammer.technology.sky130',
 'hammer.technology.sky130.extra',
 'hammer.technology.sky130.sram_compiler',
 'hammer.utils',
 'hammer.vlsi',
 'hammer.vlsi.vendor']

package_data = \
{'': ['*'],
 'hammer': ['technology/vivado/*'],
 'hammer.synthesis.vivado': ['file_templates/*'],
 'hammer.technology.asap7.sram_compiler': ['memories/gds/*',
                                           'memories/lef/*',
                                           'memories/lib/SRAM1RW1024x16_lib/*',
                                           'memories/lib/SRAM1RW1024x17_lib/*',
                                           'memories/lib/SRAM1RW1024x32_lib/*',
                                           'memories/lib/SRAM1RW1024x37_lib/*',
                                           'memories/lib/SRAM1RW1024x38_lib/*',
                                           'memories/lib/SRAM1RW1024x44_lib/*',
                                           'memories/lib/SRAM1RW1024x64_lib/*',
                                           'memories/lib/SRAM1RW1024x8_lib/*',
                                           'memories/lib/SRAM1RW128x12_lib/*',
                                           'memories/lib/SRAM1RW128x14_lib/*',
                                           'memories/lib/SRAM1RW128x22_lib/*',
                                           'memories/lib/SRAM1RW128x40_lib/*',
                                           'memories/lib/SRAM1RW128x46_lib/*',
                                           'memories/lib/SRAM1RW128x48_lib/*',
                                           'memories/lib/SRAM1RW128x64_lib/*',
                                           'memories/lib/SRAM1RW128x8_lib/*',
                                           'memories/lib/SRAM1RW2048x8_lib/*',
                                           'memories/lib/SRAM1RW256x128_lib/*',
                                           'memories/lib/SRAM1RW256x32_lib/*',
                                           'memories/lib/SRAM1RW256x46_lib/*',
                                           'memories/lib/SRAM1RW256x48_lib/*',
                                           'memories/lib/SRAM1RW256x64_lib/*',
                                           'memories/lib/SRAM1RW256x8_lib/*',
                                           'memories/lib/SRAM1RW32x50_lib/*',
                                           'memories/lib/SRAM1RW4096x16_lib/*',
                                           'memories/lib/SRAM1RW4096x8_lib/*',
                                           'memories/lib/SRAM1RW512x128_lib/*',
                                           'memories/lib/SRAM1RW512x32_lib/*',
                                           'memories/lib/SRAM1RW512x64_lib/*',
                                           'memories/lib/SRAM1RW512x8_lib/*',
                                           'memories/lib/SRAM1RW64x128_lib/*',
                                           'memories/lib/SRAM1RW64x20_lib/*',
                                           'memories/lib/SRAM1RW64x21_lib/*',
                                           'memories/lib/SRAM1RW64x22_lib/*',
                                           'memories/lib/SRAM1RW64x32_lib/*',
                                           'memories/lib/SRAM1RW64x34_lib/*',
                                           'memories/lib/SRAM1RW64x8_lib/*',
                                           'memories/lib/SRAM2RW128x16_lib/*',
                                           'memories/lib/SRAM2RW128x32_lib/*',
                                           'memories/lib/SRAM2RW128x4_lib/*',
                                           'memories/lib/SRAM2RW128x8_lib/*',
                                           'memories/lib/SRAM2RW16x16_lib/*',
                                           'memories/lib/SRAM2RW16x32_lib/*',
                                           'memories/lib/SRAM2RW16x4_lib/*',
                                           'memories/lib/SRAM2RW16x8_lib/*',
                                           'memories/lib/SRAM2RW32x16_lib/*',
                                           'memories/lib/SRAM2RW32x22_lib/*',
                                           'memories/lib/SRAM2RW32x32_lib/*',
                                           'memories/lib/SRAM2RW32x33_lib/*',
                                           'memories/lib/SRAM2RW32x39_lib/*',
                                           'memories/lib/SRAM2RW32x4_lib/*',
                                           'memories/lib/SRAM2RW32x8_lib/*',
                                           'memories/lib/SRAM2RW64x16_lib/*',
                                           'memories/lib/SRAM2RW64x24_lib/*',
                                           'memories/lib/SRAM2RW64x32_lib/*',
                                           'memories/lib/SRAM2RW64x4_lib/*',
                                           'memories/lib/SRAM2RW64x8_lib/*'],
 'hammer.technology.sky130.extra': ['sky130-tech-gen-files/*']}

install_requires = \
['PyYAML>=6.0,<7.0',
 'numpy>=1.23.0,<2.0.0',
 'pydantic>=1.9.2,<2.0.0',
 'ruamel.yaml>=0.17.21,<0.18.0']

extras_require = \
{'asap7': ['gdspy==1.4'], 'asap7-gdstk': ['gdstk>=0.9.0,<0.10.0']}

entry_points = \
{'console_scripts': ['asap7_gds_scale = hammer.technology.asap7.gds_scale:main',
                     'get-config = hammer.shell.get_config:main',
                     'hammer-generate-mdf = '
                     'hammer.shell.hammer_generate_mdf:main',
                     'hammer-shell-test = hammer.shell.hammer_shell_test:main',
                     'hammer-vlsi = hammer.shell.hammer_vlsi:main',
                     'readlink-array = hammer.shell.readlink_array:main',
                     'yaml2json = hammer.shell.yaml2json:main']}

setup_kwargs = {
    'name': 'hammer-vlsi',
    'version': '1.0.0rc2',
    'description': 'Hammer is a physical design framework that wraps around vendor specific technologies and tools to provide a single API to create ASICs.',
    'long_description': "![Logo design by @kenhoberkeley](https://github.com/ucb-bar/hammer/raw/master/doc/logo_transparent.png)\n\n![Hammer PR CI](https://github.com/ucb-bar/hammer/actions/workflows/pr.yml/badge.svg?event=push) ![Hammer publish CI](https://github.com/ucb-bar/hammer/actions/workflows/publish.yml/badge.svg)\n\nHighly Agile Masks Made Effortlessly from RTL (Hammer)\n=============================================\n\nThis is the master (unstable) development branch.\n\nDocumentation\n=============\nThe documentation is found at https://hammer-vlsi.readthedocs.io\nDoc sources are available at `doc/` for offline reading.\n\nHammer currently requires Python 3.9+.\n\nFor a deeper dive into available options and environment configuration:\n\n* [Core Hammer settings](hammer/config/defaults.yml)\n* [Setup documentation](doc/Hammer-Basics/Hammer-Setup.md)\n* [Hammer technology library schema](hammer/tech/__init__.py)\n* For CAD tool settings, please see the relevant `defaults.yml` for those plugins.\n\nHammer is an integral component of UC Berkeley Architecture Research's [Chipyard framework](https://github.com/ucb-bar/chipyard).\nUseful documentation for how an example block is pushed through the VLSI flow with Hammer in the free ASAP7 and Sky130 PDKs is at https://chipyard.readthedocs.io/en/latest/VLSI.\n\nHistory\n=======\nThe list of contributors can be found in the Git history of the project, or online at https://github.com/ucb-bar/hammer/graphs/contributors\n\nThe Hammer project builds upon the legacy of the PLSI project by Palmer Dabbelt, a previous project which aimed to build a portable VLSI flow. The Hammer project is grateful for the feedback and lessons learned which provided valuable insight that ultimately led to the design and software architecture of Hammer as it is now.\n\nBelow is the list of Hammer publications in reverse chronological order:\n- [Hammer: a modular and reusable physical design flow tool (DAC 2022)](https://dl.acm.org/doi/abs/10.1145/3489517.3530672)\n- [A Methodology for Reusable Physical Design (ISQED 2020)](https://ieeexplore.ieee.org/document/9136999)\n- [PLSI: A Portable VLSI Flow (Master's Thesis, 2017)](https://www2.eecs.berkeley.edu/Pubs/TechRpts/2017/EECS-2017-77.html)\n",
    'author': 'Colin Schmidt',
    'author_email': 'colin.schmidt@sifive.com',
    'maintainer': 'Harrison Liew',
    'maintainer_email': 'harrisonliew@berkeley.edu',
    'url': 'https://github.com/ucb-bar/hammer',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
