from __future__ import annotations

from typing import Optional

from gi.repository import Gtk
from gi.repository import GObject

INDICATOR_SIGNAL_CONNECTION_CHANGED: str = ...
INDICATOR_SIGNAL_NEW_ATTENTION_ICON: str = ...
INDICATOR_SIGNAL_NEW_ICON: str = ...
INDICATOR_SIGNAL_NEW_ICON_THEME_PATH: str = ...
INDICATOR_SIGNAL_NEW_LABEL: str = ...
INDICATOR_SIGNAL_NEW_STATUS: str = ...
INDICATOR_SIGNAL_SCROLL_EVENT: str = ...
_namespace: str = ...
_version: str = ...

class Indicator:
    parent = ...
    priv = ...

    def build_menu_from_desktop(
        self, desktop_file: str, desktop_profile: str
    ) -> None: ...
    def get_attention_icon(self) -> str: ...
    def get_attention_icon_desc(self) -> str: ...
    def get_category(self) -> IndicatorCategory: ...
    def get_icon(self) -> str: ...
    def get_icon_desc(self) -> str: ...
    def get_icon_theme_path(self) -> str: ...
    def get_id(self) -> str: ...
    def get_label(self) -> str: ...
    def get_label_guide(self) -> str: ...
    def get_menu(self) -> Gtk.Menu: ...
    def get_ordering_index(self) -> int: ...
    def get_secondary_activate_target(self) -> Gtk.Widget: ...
    def get_status(self) -> IndicatorStatus: ...
    def get_title(self) -> str: ...
    @classmethod
    def new(cls, id: str, icon_name: str, category: IndicatorCategory) -> Indicator: ...
    @classmethod
    def new_with_path(
        cls, id: str, icon_name: str, category: IndicatorCategory, icon_theme_path: str
    ) -> Indicator: ...
    def set_attention_icon(self, icon_name: str) -> None: ...
    def set_attention_icon_full(self, icon_name: str, icon_desc: str) -> None: ...
    def set_icon(self, icon_name: str) -> None: ...
    def set_icon_full(self, icon_name: str, icon_desc: str) -> None: ...
    def set_icon_theme_path(self, icon_theme_path: str) -> None: ...
    def set_label(self, label: str, guide: str) -> None: ...
    def set_menu(self, menu: Optional[Gtk.Menu]) -> None: ...
    def set_ordering_index(self, ordering_index: int) -> None: ...
    def set_secondary_activate_target(self, target: Optional[Gtk.Widget]) -> None: ...
    def set_status(self, status: IndicatorStatus) -> None: ...
    def set_title(self, title: Optional[str]) -> None: ...
    def do_connection_changed(self, *args, **kwargs): ...
    def do_new_attention_icon(self, *args, **kwargs): ...
    def do_new_icon(self, *args, **kwargs): ...
    def do_new_icon_theme_path(self, *args, **kwargs): ...
    def do_new_label(self, *args, **kwargs): ...
    def do_new_status(self, *args, **kwargs): ...
    def do_scroll_event(self, *args, **kwargs): ...
    def do_unfallback(self, *args, **kwargs): ...

class IndicatorCategory(GObject.GEnum):
    APPLICATION_STATUS = ...
    COMMUNICATIONS = ...
    HARDWARE = ...
    OTHER = ...
    SYSTEM_SERVICES = ...

class IndicatorStatus(GObject.GEnum):
    ACTIVE = ...
    ATTENTION = ...
    PASSIVE = ...
