from typing import Any
from typing import Optional

from gi.repository import Gio
from gi.repository import GObject

def client_interface_info(*args, **kwargs): ...
def client_override_properties(*args, **kwargs): ...
def location_interface_info(*args, **kwargs): ...
def location_override_properties(*args, **kwargs): ...
def manager_interface_info(*args, **kwargs): ...
def manager_override_properties(*args, **kwargs): ...

class Client(GObject.Object):
    def call_start(*args, **kwargs): ...
    def call_start_finish(*args, **kwargs): ...
    def call_start_sync(*args, **kwargs): ...
    def call_stop(*args, **kwargs): ...
    def call_stop_finish(*args, **kwargs): ...
    def call_stop_sync(*args, **kwargs): ...
    def complete_start(*args, **kwargs): ...
    def complete_stop(*args, **kwargs): ...
    def emit_location_updated(*args, **kwargs): ...
    def interface_info(*args, **kwargs): ...
    def override_properties(*args, **kwargs): ...

class ClientProxy:
    def create(*args, **kwargs): ...
    def create_finish(*args, **kwargs): ...
    def create_full(*args, **kwargs): ...
    def create_full_finish(*args, **kwargs): ...
    def create_full_sync(*args, **kwargs): ...
    def create_sync(*args, **kwargs): ...

class ClientSkeleton:
    def new(*args, **kwargs): ...

class Location(GObject.Object):
    def interface_info(*args, **kwargs): ...
    def override_properties(*args, **kwargs): ...

class LocationProxy: ...

class LocationSkeleton:
    def new(*args, **kwargs): ...

class Manager:
    def call_add_agent(*args, **kwargs): ...
    def call_add_agent_finish(*args, **kwargs): ...
    def call_add_agent_sync(*args, **kwargs): ...
    def call_create_client(*args, **kwargs): ...
    def call_create_client_finish(*args, **kwargs): ...
    def call_create_client_sync(*args, **kwargs): ...
    def call_delete_client(*args, **kwargs): ...
    def call_delete_client_finish(*args, **kwargs): ...
    def call_delete_client_sync(*args, **kwargs): ...
    def call_get_client(*args, **kwargs): ...
    def call_get_client_finish(*args, **kwargs): ...
    def call_get_client_sync(*args, **kwargs): ...
    def complete_add_agent(*args, **kwargs): ...
    def complete_create_client(*args, **kwargs): ...
    def complete_delete_client(*args, **kwargs): ...
    def complete_get_client(*args, **kwargs): ...
    def interface_info(*args, **kwargs): ...
    def override_properties(*args, **kwargs): ...

class ManagerProxy: ...

class ManagerSkeleton:
    def new(*args, **kwargs): ...

class Simple(GObject.Object):
    parent = ...
    priv = ...

    def get_client(self) -> Client: ...
    def get_location(self) -> Location: ...
    @classmethod
    def new(
        cls,
        desktop_id: str,
        accuracy_level: AccuracyLevel,
        cancellable: Optional[Gio.Cancellable],
        callback: Gio.AsyncReadyCallback,
        user_data: Optional[Any] = ...,
    ) -> Simple: ...
    @classmethod
    def new_finish(cls, result: Gio.AsyncResult) -> Optional[Simple]: ...
    def new_sync(*args, **kwargs): ...

class ClientProxyCreateFlags(GObject.GFlags):
    NONE = 0
    AUTO_DELETE = 1

class AccuracyLevel(GObject.GEnum):
    NONE = 0
    COUNTRY = 1
    CITY = 4
    NEIGHBORHOOD = 5
    STREET = 6
    EXACT = 8
