from __future__ import annotations

from typing import Optional
from typing import TypeVar

from gi.repository import GObject
from gi.repository import Pango
import cairo

_namespace: str = ...
_version: str = ...

_SomeSurface = TypeVar("_SomeSurface", bound=cairo.Surface)

def context_get_font_options(context: Pango.Context) -> Optional[cairo.FontOptions]: ...
def context_get_resolution(context: Pango.Context) -> float: ...
def context_set_font_options(
    context: Pango.Context, options: Optional[cairo.FontOptions]
): ...
def context_set_resolution(context: Pango.Context, dpi: float) -> None: ...
def context_set_shape_renderer(*args, **kwargs): ...
def create_context(cr: cairo.Context[_SomeSurface]) -> Pango.Context: ...
def create_layout(cr: cairo.Context[_SomeSurface]) -> Pango.Layout: ...
def error_underline_path(
    cr: cairo.Context[_SomeSurface], x: float, y: float, width: float, height: float
) -> None: ...
def font_map_get_default() -> Pango.FontMap: ...
def font_map_new() -> Pango.FontMap: ...
def font_map_new_for_font_type(fonttype: cairo.FontType) -> Optional[Pango.FontMap]: ...
def glyph_string_path(
    cr: cairo.Context[_SomeSurface], font: Pango.Font, glyphs: Pango.GlyphString
) -> None: ...
def layout_line_path(cr: cairo.Context[_SomeSurface], line: Pango.LayoutLine): ...
def layout_path(cr: cairo.Context[_SomeSurface], layout: Pango.Layout) -> None: ...
def show_error_underline(
    cr: cairo.Context[_SomeSurface], x: float, y: float, width: float, height: float
) -> None: ...
def show_glyph_item(
    cr: cairo.Context[_SomeSurface], text: str, glyph_item: Pango.GlyphItem
) -> None: ...
def show_glyph_string(
    cr: cairo.Context[_SomeSurface], font: Pango.Font, glyphs: Pango.GlyphString
) -> None: ...
def show_layout(cr: cairo.Context[_SomeSurface], layout: Pango.Layout) -> None: ...
def show_layout_line(
    cr: cairo.Context[_SomeSurface], line: Pango.LayoutLine
) -> None: ...
def update_context(cr: cairo.Context[_SomeSurface], context: Pango.Context) -> None: ...
def update_layout(cr: cairo.Context[_SomeSurface], layout: Pango.Layout) -> None: ...

class Font(GObject.GInterface):
    def get_scaled_font(self) -> Optional[cairo.ScaledFont]: ...

class FontMap(GObject.GInterface):
    def get_default(cls) -> Pango.FontMap: ...
    def get_font_type(self) -> cairo.FontType: ...
    def get_resolution(self) -> float: ...
    def new(cls) -> Pango.FontMap: ...
    def new_for_font_type(cls, fonttype: cairo.FontType) -> Optional[Pango.FontMap]: ...
    def set_default(self) -> None: ...
    def set_resolution(self, dpi: float) -> None: ...
