# Configuration file for the Sphinx documentation builder.
#
# This file only contains a selection of the most common options. For a full
# list see the documentation:
# https://www.sphinx-doc.org/en/master/usage/configuration.html

# -- Path setup --------------------------------------------------------------

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#
# import os
# import sys
# sys.path.insert(0, os.path.abspath('.'))


# -- Project information -----------------------------------------------------

project = 'napari-boxmanager'
copyright = '2022, MPI-Dortmund'
author = 'Markus Stabrin, Thorsten Wagner, Gavin Rice'


# -- General configuration ---------------------------------------------------

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [
]
'''
extensions = [
    'versionwarning.extension',
]
versionwarning_messages = {
    'latest': 'This is the documentation for an unreleased development version. Documentation is available for the {newest} release, or for older versions, through the "v:" menu at the bottom left.',
}
'''
# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This pattern also affects html_static_path and html_extra_path.
exclude_patterns = []

master_doc = 'index'
# -- Options for HTML output -------------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#
html_theme = 'sphinx_rtd_theme'
#html_logo = 'img/general/TomoTwin_white_transparent_tight.png'


# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ['_static']

html_theme_options = {
    'sticky_navigation': True,
    'logo_only' : 'True',
    'style_nav_header_background' : '#5a8089',
}

extensions += ['sphinx-prompt']

def setup(app):
    app.add_js_file("version-alert.js")
