import os
import sys
import json
import re
import copy
from enrichsdk.contrib.lib.transforms.fileops import FileOperationsBase
import logging

logger = logging.getLogger("app")

__all__ = ['FileOperations']

class FileOperations(FileOperationsBase):
    """
    FileOperations performs a number of operations on files
    generated by pipelines.

    The transform takes a list of actions. The only action type
    supported for now is `copy`. Each copy task requires source,
    destination, and instruction on what to do with existing file.

    Example::

        {
                "transform": "FileOperations",
                "enable": true,
                "dependencies": {
                   ....
                },
                "args": {
                    "actions": [
                          {
                            "action": "copy",
                            "src": "%(output)s/%(runid)s/profile.sqlite",
                            "dst": "%(data_root)s/shared/campaigns/profile_daily/profile.sqlite",
                            "backupsuffix": ".backup"
                          }
                     ]
                }
        }

    """
    @classmethod
    def instantiable(cls):
        """
        Make this class instantiable
        """
        return True

    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        self.name = "FileOperations"
        self.description = "File operations such as move/copy etc."

        test_root = os.environ['ENRICH_TEST']
        self.testdata = {
            'data_root': os.path.join(test_root, self.name),
            'outputdir': os.path.join(test_root, self.name, 'output'),
            'inputdir': test_root,
            'statedir': os.path.join(test_root, self.name, 'state'),
            'global': {
                'args': {
                    'rundate': '2020-01-10'
                }
            },
            'conf': {
                'args': {
                    "actions": [
                        {
                            "action": "copy",
                            "src": "%(output)s/%(runid)s/outputs/cars.csv",
                            "dst": "%(data_root)s/shared/%(rundate)s/hello.csv"
                        }
                    ]
                }
            },
            'data': {
            }
        }


provider = FileOperations
