/**
 * Copyright (c) 2015-present, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 *
 * This file contains unit property data from BWAPI as simple arrays, indexed
 * by unit type value (torchcraft::BW::UnitType).
 */

#include <string>

namespace torchcraft {
namespace BW {
namespace data {

bool CanAttack[] = {
    true,  true,  true,  true,  false, true,  false, true,  true,  false, false,
    false, true,  true,  true,  false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, true,  false, true,
    false, false, false, false, true,  true,  true,  true,  true,  false, true,
    true,  false, false, true,  false, false, true,  false, false, false, false,
    false, false, false, true,  false, true,  true,  true,  false, true,  true,
    true,  false, true,  false, true,  true,  true,  true,  false, false, false,
    false, false, false, false, false, false, true,  false, true,  false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, true,  false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, true,  false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, true,  false, true,  false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, true,  false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false};

int DimensionRight[] = {
    8,  7,  15, 15, 0,  15, 0,  11, 18, 32, 0,  24, 37, 7,  7,  8,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  15, 0,  11, 13, 8,  7,
    15, 7,  10, 18, 9,  11, 24, 21, 21, 23, 13, 11, 0,  0,  8,  0,  0,  0,
    0,  0,  0,  0,  24, 15, 17, 11, 21, 15, 11, 11, 16, 11, 15, 19, 17, 21,
    31, 7,  0,  0,  0,  0,  0,  0,  0,  0,  0,  15, 15, 2,  0,  0,  0,  15,
    15, 0,  0,  15, 15, 15, 15, 15, 0,  0,  0,  0,  0,  16, 0,  59, 58, 31,
    31, 38, 56, 56, 44, 56, 48, 28, 48, 28, 28, 0,  31, 0,  48, 47, 16, 32,
    0,  0,  0,  0,  58, 49, 49, 49, 31, 40, 48, 28, 32, 32, 32, 28, 40, 23,
    23, 0,  23, 0,  0,  63, 0,  0,  0,  0,  56, 40, 16, 48, 0,  44, 48, 0,
    20, 40, 40, 32, 36, 48, 0,  47, 44, 32, 32, 0,  0,  0,  31, 31, 31, 0,
    0,  0,  0,  0,  0,  0,  0,  0,  63, 0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  79, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};

int Height[] = {
    20, 22, 32, 32, 0,   32, 0,  23, 30, 50, 0,  37, 59, 15, 29, 20, 0,  0,
    0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  32, 0,  22, 31, 20, 16,
    32, 16, 23, 32, 19,  23, 50, 44, 44, 48, 25, 24, 0,  0,  20, 0,  0,  0,
    0,  0,  0,  0,  37,  32, 32, 26, 44, 32, 23, 19, 32, 24, 32, 32, 32, 44,
    64, 16, 0,  0,  0,   0,  0,  0,  0,  0,  0,  32, 32, 5,  0,  0,  0,  32,
    32, 0,  0,  32, 32,  32, 32, 32, 0,  0,  0,  0,  0,  32, 0,  80, 83, 42,
    42, 49, 64, 73, 57,  81, 79, 47, 77, 47, 47, 0,  49, 0,  61, 55, 49, 41,
    0,  0,  0,  0,  83,  65, 65, 65, 64, 57, 37, 57, 57, 53, 64, 57, 47, 48,
    48, 0,  48, 0,  0,   64, 0,  0,  0,  0,  79, 37, 33, 57, 0,  45, 73, 0,
    33, 49, 49, 49, 45,  73, 0,  57, 57, 53, 33, 0,  0,  0,  32, 32, 32, 0,
    0,  0,  0,  0,  0,   0,  0,  0,  64, 0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  160, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};

bool IsMineralField[] = {
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    true,  true,  true,  false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false};

bool CanProduce[] = {
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, true,  false, false, false, false,
    false, false, false, false, false, false, true,  false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, true,  false, false, false,
    false, true,  false, true,  true,  false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, true,  true,
    true,  true,  false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    true,  true,  false, false, false, false, true,  false, false, false, false,
    false, false, true,  false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false};

bool IsRefinery[] = {
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    true,  false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, true,  false, false, false, false,
    false, false, false, true,  false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false};

bool IsResourceDepot[] = {
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, true,  false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, true,
    true,  true,  false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    true,  false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false};

bool RegeneratesHP[] = {
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, true,  false, true,  true,  true,  true,  true,  true,  true,
    true,  true,  true,  true,  false, false, true,  false, false, false, false,
    false, false, false, false, false, false, false, true,  false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, true,  false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, true,  true,
    true,  true,  true,  true,  true,  true,  true,  true,  true,  true,  true,
    true,  true,  false, true,  false, false, true,  false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false};

bool IsCloakable[] = {
    false, true,  false, false, false, false, false, false, true,  false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false};

bool IsTwoUnitsInOneEgg[] = {
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, true,  false, false, false, false, false, false,
    false, false, false, true,  false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false};

bool IsSpellcaster[] = {
    false, true,  false, false, false, false, false, false, true,  true,  false,
    false, true,  false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, true,  false, false, false, false, false, false, false, false, false,
    false, true,  true,  false, false, false, false, false, false, false, false,
    false, false, false, false, false, true,  false, false, true,  false, false,
    false, true,  false, false, false, true,  false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, true,  false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, true,  false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false};

int SupplyRequired[] = {
    2,  2, 4, 4, 0, 4, 0, 2, 4, 4, 0, 4, 12, 0, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0,  0, 0, 0, 0, 0, 4, 0, 2, 0, 2, 0, 0,  1, 2,  8, 0, 2, 0, 4, 4, 4, 4, 1,
    0,  0, 2, 0, 0, 0, 0, 0, 0, 0, 6, 0, 4,  4, 4,  8, 2, 4, 4, 4, 8, 4, 6, 8,
    12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 2,  0, 0,  0, 0, 0, 0, 0, 0, 0, 0, 0,
    0,  0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0,  0, 0,  0, 0, 0, 0, 0, 0, 0, 0, 0,
    0,  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0,  0, 0, 0, 0, 0, 0, 0, 0, 0,
    0,  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0,  0, 0, 0, 0, 0, 0, 0, 0, 0,
    0,  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0,  0, 0, 0, 0, 0, 0, 0, 0, 0,
    0,  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0,  0, 0, 0, 0, 0, 0, 0, 0, 0,
    0,  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0,  0, 0};

std::string AirWeapon[] = {"Gauss_Rifle",
                           "C_10_Canister_Rifle",
                           "None",
                           "Hellfire_Missile_Pack",
                           "",
                           "None",
                           "",
                           "None",
                           "Gemini_Missiles",
                           "None",
                           "",
                           "None",
                           "ATA_Laser_Battery",
                           "None",
                           "None",
                           "None",
                           "",
                           "",
                           "",
                           "",
                           "",
                           "",
                           "",
                           "",
                           "",
                           "",
                           "",
                           "",
                           "",
                           "",
                           "None",
                           "",
                           "None",
                           "None",
                           "None",
                           "None",
                           "None",
                           "None",
                           "Needle_Spines",
                           "None",
                           "None",
                           "None",
                           "None",
                           "Glave_Wurm",
                           "None",
                           "None",
                           "None",
                           "Suicide_Scourge",
                           "",
                           "",
                           "None",
                           "",
                           "",
                           "",
                           "",
                           "",
                           "",
                           "",
                           "Halo_Rockets",
                           "None",
                           "Neutron_Flare",
                           "None",
                           "Corrosive_Acid",
                           "None",
                           "None",
                           "None",
                           "Phase_Disruptor",
                           "None",
                           "Psionic_Shockwave",
                           "None",
                           "Anti_Matter_Missiles",
                           "Phase_Disruptor_Cannon",
                           "None",
                           "Pulse_Cannon",
                           "",
                           "",
                           "",
                           "",
                           "",
                           "",
                           "",
                           "",
                           "",
                           "None",
                           "None",
                           "None",
                           "",
                           "",
                           "",
                           "None",
                           "None",
                           "",
                           "",
                           "None",
                           "None",
                           "None",
                           "None",
                           "None",
                           "",
                           "",
                           "",
                           "",
                           "",
                           "None",
                           "",
                           "None",
                           "None",
                           "None",
                           "None",
                           "None",
                           "None",
                           "None",
                           "None",
                           "None",
                           "None",
                           "None",
                           "None",
                           "None",
                           "None",
                           "",
                           "None",
                           "",
                           "None",
                           "None",
                           "Longbolt_Missile",
                           "None",
                           "",
                           "",
                           "",
                           "",
                           "None",
                           "None",
                           "None",
                           "None",
                           "None",
                           "None",
                           "None",
                           "None",
                           "None",
                           "None",
                           "None",
                           "None",
                           "None",
                           "None",
                           "Seeker_Spores",
                           "",
                           "None",
                           "",
                           "",
                           "None",
                           "",
                           "",
                           "",
                           "",
                           "None",
                           "None",
                           "None",
                           "None",
                           "",
                           "None",
                           "None",
                           "",
                           "STA_Photon_Cannon",
                           "None",
                           "None",
                           "None",
                           "None",
                           "None",
                           "",
                           "None",
                           "None",
                           "None",
                           "None",
                           "",
                           "",
                           "",
                           "None",
                           "None",
                           "None",
                           "",
                           "",
                           "",
                           "",
                           "",
                           "",
                           "",
                           "",
                           "",
                           "None",
                           "",
                           "",
                           "",
                           "",
                           "",
                           "",
                           "",
                           "",
                           "",
                           "",
                           "",
                           "",
                           "",
                           "None",
                           "",
                           "",
                           "",
                           "",
                           "",
                           "",
                           "",
                           "",
                           "",
                           "",
                           "",
                           "",
                           "",
                           "",
                           "",
                           "",
                           "",
                           "",
                           "",
                           "",
                           "",
                           "",
                           "",
                           "",
                           "",
                           "",
                           "",
                           "",
                           "",
                           ""};

int BuildScore[] = {
    50,  175, 75,  200, 0,   350, 0,   50,  400, 625, 0,   300,  1200, 0,   800,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,    0,    0,   0,
    0,   0,   100, 0,   125, 0,   0,   25,  125, 650, 0,   50,   100,  300, 550,
    400, 225, 100, 0,   0,   200, 0,   0,   0,   0,   0,   0,    0,    400, 0,
    350, 325, 550, 650, 50,  100, 250, 350, 700, 200, 650, 1025, 950,  30,  0,
    0,   0,   0,   0,   0,   0,   0,   0,   400, 225, 0,   0,    0,    0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,    0,    250, 0,
    0,   400, 75,  75,  50,  50,  75,  100, 200, 200, 100, 275,  75,   75,  0,
    75,  0,   65,  100, 50,  50,  0,   0,   0,   0,   300, 300,  100,  100, 75,
    100, 150, 200, 175, 40,  275, 250, 75,  40,  25,  0,   40,   0,    0,   25,
    0,   0,   0,   0,   400, 300, 50,  50,  0,   175, 75,  0,    100,  200, 100,
    250, 100, 300, 0,   350, 450, 125, 50,  0,   0,   0,   10,   10,   10,  0,
    0,   0,   0,   0,   0,   0,   0,   0,   10,  0,   0,   0,    0,    0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,    0,    0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,    0,    0,   0,
    0,   0,   0,   0,   0,   0,   0,   0};

int MaxAirHits[] = {
    1, 1, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 1,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 0, 1, 1,
    0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

bool IsPowerup[] = {
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false};

bool IsBeacon[] = {
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false};

int MineralPrice[] = {
    50,  25,  75,  100, 0,   150, 0,   50,  150, 100, 0,   100, 400, 1,   200,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    150, 0,   50,  0,   50,  1,   1,   50,  75,  200, 1,   50,  100, 100, 50,
    100, 50,  25,  0,   0,   100, 0,   0,   0,   0,   0,   0,   0,   250, 1,
    150, 125, 150, 0,   50,  100, 125, 50,  0,   200, 275, 100, 350, 25,  0,
    0,   0,   0,   0,   0,   0,   0,   0,   200, 25,  15,  0,   0,   0,   1,
    1,   0,   0,   1,   1,   1,   1,   1,   0,   0,   0,   0,   0,   50,  0,
    250, 400, 50,  100, 100, 100, 150, 150, 200, 150, 50,  100, 50,  50,  0,
    50,  0,   125, 100, 75,  100, 0,   0,   0,   0,   1,   300, 150, 200, 150,
    100, 100, 100, 150, 75,  150, 200, 200, 75,  50,  0,   50,  0,   0,   50,
    0,   0,   0,   0,   400, 200, 100, 100, 0,   50,  150, 0,   150, 150, 200,
    150, 150, 150, 0,   300, 200, 150, 100, 0,   0,   0,   1,   1,   1,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   250, 0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0};

bool IsInvincible[] = {
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, true,  false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, true,  false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, true,  false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    true,  true,  true,  false, false, false, false, false, false, false, false,
    false, true,  false, false, false, false, false, false, false, false, false,
    false, false, false, false, true,  false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false};

std::string RequiredTech[] = {"None", "None",
                              "None", "None",
                              "",     "None",
                              "",     "None",
                              "None", "None",
                              "",     "None",
                              "None", "None",
                              "None", "None",
                              "",     "",
                              "",     "",
                              "",     "",
                              "",     "",
                              "",     "",
                              "",     "",
                              "",     "",
                              "None", "",
                              "None", "None",
                              "None", "None",
                              "None", "None",
                              "None", "None",
                              "None", "None",
                              "None", "None",
                              "None", "None",
                              "None", "None",
                              "",     "",
                              "None", "",
                              "",     "",
                              "",     "",
                              "",     "",
                              "None", "None",
                              "None", "None",
                              "None", "None",
                              "None", "None",
                              "None", "None",
                              "None", "None",
                              "None", "None",
                              "None", "None",
                              "",     "",
                              "",     "",
                              "",     "",
                              "",     "",
                              "",     "None",
                              "None", "None",
                              "",     "",
                              "",     "None",
                              "None", "",
                              "",     "None",
                              "None", "None",
                              "None", "Lurker_Aspect",
                              "",     "",
                              "",     "",
                              "",     "Lurker_Aspect",
                              "",     "None",
                              "None", "None",
                              "None", "None",
                              "None", "None",
                              "None", "None",
                              "None", "None",
                              "None", "None",
                              "None", "",
                              "None", "",
                              "None", "None",
                              "None", "None",
                              "",     "",
                              "",     "",
                              "None", "None",
                              "None", "None",
                              "None", "None",
                              "None", "None",
                              "None", "None",
                              "None", "None",
                              "None", "None",
                              "None", "",
                              "None", "",
                              "",     "None",
                              "",     "",
                              "",     "",
                              "None", "None",
                              "None", "None",
                              "",     "None",
                              "None", "",
                              "None", "None",
                              "None", "None",
                              "None", "None",
                              "",     "None",
                              "None", "None",
                              "None", "",
                              "",     "",
                              "None", "None",
                              "None", "",
                              "",     "",
                              "",     "",
                              "",     "",
                              "",     "",
                              "None", "",
                              "",     "",
                              "",     "",
                              "",     "",
                              "",     "",
                              "",     "",
                              "",     "",
                              "None", "",
                              "",     "",
                              "",     "",
                              "",     "",
                              "",     "",
                              "",     "",
                              "",     "",
                              "",     "",
                              "",     "",
                              "",     "",
                              "",     "",
                              "",     "",
                              "",     "",
                              "",     "",
                              "",     "",
                              ""};

int DimensionDown[] = {
    10, 11, 15, 15, 0,  15, 0,  11, 14, 16, 0,  20, 29, 7,  14, 10, 0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  15, 0,  14, 17, 10, 7,
    15, 11, 12, 15, 9,  11, 24, 21, 21, 23, 12, 11, 0,  0,  10, 0,  0,  0,
    0,  0,  0,  0,  20, 15, 15, 19, 21, 15, 11, 13, 16, 13, 15, 15, 15, 21,
    31, 7,  0,  0,  0,  0,  0,  0,  0,  0,  0,  15, 15, 2,  0,  0,  0,  15,
    15, 0,  0,  15, 15, 15, 15, 15, 0,  0,  0,  0,  0,  16, 0,  39, 41, 25,
    25, 26, 31, 32, 24, 40, 38, 22, 38, 22, 22, 0,  24, 0,  28, 22, 16, 16,
    0,  0,  0,  0,  41, 32, 32, 32, 31, 24, 4,  24, 28, 20, 31, 24, 18, 23,
    23, 0,  23, 0,  0,  31, 0,  0,  0,  0,  39, 20, 20, 24, 0,  28, 40, 0,
    16, 24, 24, 24, 20, 32, 0,  24, 28, 20, 16, 0,  0,  0,  15, 15, 15, 0,
    0,  0,  0,  0,  0,  0,  0,  0,  31, 0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  79, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};

bool CanBuildAddon[] = {
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, true,  false, false, false,
    false, false, false, true,  true,  false, true,  false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false};

int DimensionLeft[] = {
    8,  7,  16, 16, 0,  16, 0,  11, 19, 32, 0,  24, 37, 7,  7,  8,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  16, 0,  11, 13, 8,  8,
    16, 8,  10, 19, 9,  11, 25, 22, 22, 24, 13, 12, 0,  0,  8,  0,  0,  0,
    0,  0,  0,  0,  24, 16, 18, 12, 22, 16, 11, 11, 15, 12, 16, 20, 18, 22,
    32, 8,  0,  0,  0,  0,  0,  0,  0,  0,  0,  16, 16, 2,  0,  0,  0,  16,
    16, 0,  0,  16, 16, 16, 16, 16, 0,  0,  0,  0,  0,  15, 0,  60, 58, 37,
    37, 38, 56, 48, 40, 56, 48, 47, 48, 47, 47, 0,  39, 0,  48, 48, 16, 32,
    0,  0,  0,  0,  58, 49, 49, 49, 32, 40, 48, 28, 38, 44, 40, 28, 36, 24,
    24, 0,  24, 0,  0,  64, 0,  0,  0,  0,  56, 36, 16, 48, 0,  44, 48, 0,
    20, 24, 40, 32, 36, 48, 0,  40, 44, 32, 32, 0,  0,  0,  32, 32, 32, 0,
    0,  0,  0,  0,  0,  0,  0,  0,  64, 0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  80, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};

bool ProducesLarva[] = {
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, true,
    true,  true,  false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false};

int Armor[] = {
    0, 0,  0, 1, 0, 1, 0, 0, 0, 1, 0, 1,  3,  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0,  0, 0, 0, 0, 1, 0, 1, 0, 1, 10, 10, 0, 0, 1, 0, 0, 0, 0, 2, 0, 1, 0,
    0, 0,  0, 0, 0, 0, 0, 0, 0, 0, 2, 0,  1,  1, 2, 1, 0, 1, 1, 0, 0, 1, 0, 1,
    4, 0,  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 10, 0, 0, 0, 0, 0, 1, 0, 0, 1, 1,  1,  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0,
    1, 0,  1, 1, 0, 1, 0, 0, 0, 0, 1, 1,  1,  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0,
    0, 0,  2, 0, 0, 1, 0, 0, 0, 0, 1, 1,  0,  1, 0, 1, 1, 0, 0, 1, 1, 1, 1, 1,
    0, 1,  1, 1, 1, 0, 0, 0, 0, 0, 0, 0,  0,  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0,  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0,  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0, 0, 0, 0};

bool IsMechanical[] = {
    false, false, true,  true,  false, true,  false, true,  true,  true,  false,
    true,  true,  false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, true,  false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, true,  false, true,  false, false, false, true,  false,
    true,  false, false, true,  true,  true,  true,  true,  false, false, false,
    false, false, false, false, false, false, true,  true,  true,  false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, true,  true,  true,  true,
    true,  true,  true,  true,  true,  true,  true,  true,  true,  false, true,
    false, true,  true,  true,  true,  false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    true,  true,  true,  true,  false, true,  true,  false, true,  true,  true,
    true,  true,  true,  false, true,  true,  true,  true,  false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false};

bool IsBuilding[] = {
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, true,  true,  true,  true,
    true,  true,  true,  true,  true,  true,  true,  true,  true,  false, true,
    false, true,  true,  true,  true,  false, false, false, false, true,  true,
    true,  true,  true,  true,  true,  true,  true,  true,  true,  true,  true,
    true,  true,  false, true,  false, false, true,  false, false, false, false,
    true,  true,  true,  true,  false, true,  true,  false, true,  true,  true,
    true,  true,  true,  false, true,  true,  true,  true,  false, false, false,
    true,  true,  true,  false, false, false, false, false, false, false, false,
    false, true,  false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false};

int SupplyProvided[] = {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0,  0,  0, 0, 0, 0, 0,  0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0,  0,  0, 0, 0, 0, 16, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0,  0,  0, 0, 0, 0, 0,  0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0,  0,  0, 0, 0, 0, 0,  0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20, 0, 0,  16, 0, 0, 0, 0, 0,  0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  2, 2,  2,  0, 0, 0, 0, 0,  0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 18, 0, 16, 0,  0, 0, 0, 0, 0,  0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0,  0,  0, 0, 0, 0, 0,  0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0,  0,  0, 0, 0, 0, 0,  0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0,  0,  0, 0, 0};

int SightRange[] = {
    224, 288, 256, 256, 0,   320, 0,   224, 224, 320, 0,   256, 352, 96,  96,
    224, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    320, 0,   224, 320, 288, 128, 128, 160, 192, 224, 160, 224, 288, 224, 352,
    320, 320, 160, 0,   0,   160, 0,   0,   0,   0,   0,   0,   0,   256, 128,
    288, 224, 320, 320, 256, 224, 256, 224, 256, 256, 256, 288, 352, 192, 0,
    0,   0,   0,   0,   0,   0,   0,   0,   320, 288, 160, 0,   0,   0,   224,
    224, 0,   0,   224, 224, 224, 224, 128, 0,   0,   0,   0,   0,   256, 0,
    256, 320, 320, 256, 256, 256, 256, 256, 256, 320, 256, 320, 256, 256, 0,
    256, 0,   256, 256, 352, 320, 0,   0,   0,   0,   320, 288, 320, 352, 256,
    256, 256, 256, 256, 256, 256, 256, 256, 320, 320, 0,   320, 0,   0,   224,
    0,   0,   0,   0,   352, 320, 256, 320, 0,   320, 320, 0,   352, 320, 320,
    320, 320, 320, 0,   320, 320, 320, 320, 0,   0,   0,   288, 288, 288, 0,
    0,   0,   0,   0,   0,   0,   0,   0,   288, 0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   256, 0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0};

int GasPrice[] = {
    0,   75,  0,   50,  0,   100, 0,   0,   100, 225, 0,   100, 300, 0,   200,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    100, 0,   25,  0,   25,  1,   1,   0,   25,  200, 1,   0,   0,   100, 100,
    100, 150, 75,  0,   0,   50,  0,   0,   0,   0,   0,   0,   0,   125, 1,
    100, 100, 50,  0,   0,   0,   50,  150, 0,   0,   125, 350, 250, 0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   100, 75,  0,   0,   0,   0,   1,
    1,   0,   0,   1,   1,   1,   1,   1,   0,   0,   0,   0,   0,   100, 0,
    250, 0,   50,  100, 0,   0,   0,   0,   100, 100, 50,  150, 50,  50,  0,
    50,  0,   0,   50,  0,   0,   0,   0,   0,   0,   1,   0,   100, 150, 0,
    50,  100, 150, 100, 0,   200, 150, 0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   200, 0,   0,   0,   100, 0,   0,   0,   100, 0,
    200, 0,   150, 0,   200, 150, 100, 0,   0,   0,   0,   1,   1,   1,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   200, 0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0};

int MaxHitPoints[] = {
    40,   45,   80,  125,  0,   150,  0,    60,  120,    200,    0,      150,
    500,  20,   100, 40,   0,   0,    0,    0,   0,      0,      0,      0,
    0,    0,    0,   0,    0,   0,    150,  0,   50,     0,      60,     25,
    200,  35,   80,  400,  30,  40,   200,  120, 150,    120,    80,     25,
    0,    0,    60,  0,    0,   0,    0,    0,   0,      0,      200,    200,
    100,  80,   250, 25,   20,  100,  100,  40,  10,     80,     150,    200,
    300,  40,   0,   0,    0,   0,    0,    0,   0,      0,      0,      100,
    40,   20,   0,   0,    0,   60,   60,   0,   0,      60,     60,     60,
    60,   200,  0,   0,    0,   0,    0,    125, 0,      800,    1500,   500,
    600,  500,  750, 1000, 600, 1250, 1300, 500, 850,    750,    600,    0,
    750,  0,    850, 750,  200, 350,  0,    0,   0,      0,      1500,   1250,
    1800, 2500, 250, 850,  850, 1000, 850,  750, 600,    600,    750,    400,
    400,  0,    300, 0,    0,   750,  0,    0,   0,      0,      750,    500,
    300,  450,  0,   250,  500, 0,    100,  450, 500,    500,    550,    600,
    0,    500,  500, 450,  200, 0,    0,    0,   100000, 100000, 100000, 0,
    0,    0,    0,   0,    0,   0,    0,    0,   100000, 0,      0,      0,
    0,    0,    0,   0,    0,   0,    0,    0,   0,      0,      800,    0,
    0,    0,    0,   0,    0,   0,    0,    0,   0,      0,      0,      0,
    0,    0,    0,   0,    0,   0,    0,    0,   0,      0,      0,      0,
    0,    0,    0,   0,    0};

int Width[] = {
    17, 15,  32, 32,  0,   32, 0,  23, 38,  65,  0,  49,  75, 15,  15, 17,  0,
    0,  0,   0,  0,   0,   0,  0,  0,  0,   0,   0,  0,   0,  32,  0,  23,  27,
    17, 16,  32, 16,  21,  38, 19, 23, 50,  44,  44, 48,  27, 24,  0,  0,   17,
    0,  0,   0,  0,   0,   0,  0,  49, 32,  36,  24, 44,  32, 23,  23, 32,  24,
    32, 40,  36, 44,  64,  16, 0,  0,  0,   0,   0,  0,   0,  0,   0,  32,  32,
    5,  0,   0,  0,   32,  32, 0,  0,  32,  32,  32, 32,  32, 0,   0,  0,   0,
    0,  32,  0,  120, 117, 69, 69, 77, 113, 105, 85, 113, 97, 76,  97, 76,  76,
    0,  71,  0,  97,  96,  33, 65, 0,  0,   0,   0,  117, 99, 99,  99, 64,  81,
    97, 57,  71, 77,  73,  57, 77, 48, 48,  0,   48, 0,   0,  128, 0,  0,   0,
    0,  113, 77, 33,  97,  0,  89, 97, 0,   41,  65, 81,  65, 73,  97, 0,   88,
    89, 65,  65, 0,   0,   0,  64, 64, 64,  0,   0,  0,   0,  0,   0,  0,   0,
    0,  128, 0,  0,   0,   0,  0,  0,  0,   0,   0,  0,   0,  0,   0,  160, 0,
    0,  0,   0,  0,   0,   0,  0,  0,  0,   0,   0,  0,   0,  0,   0,  0,   0,
    0,  0,   0,  0,   0,   0,  0,  0,  0,   0,   0,  0};

int TileWidth[] = {
    1, 1, 1, 1, 0, 1, 0, 1, 1, 2, 0, 2, 2, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 2, 2, 2, 2, 1, 1,
    0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 2, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 2, 2, 2,
    2, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 1, 1, 0, 0, 1, 1, 1,
    1, 1, 0, 0, 0, 0, 0, 1, 0, 4, 4, 2, 2, 3, 4, 4, 3, 4, 4, 2, 4, 2, 2, 0,
    2, 0, 4, 3, 2, 3, 0, 0, 0, 0, 4, 4, 4, 4, 2, 3, 4, 2, 3, 3, 3, 2, 3, 2,
    2, 0, 2, 0, 0, 4, 0, 0, 0, 0, 4, 3, 2, 4, 0, 3, 4, 0, 2, 3, 3, 3, 3, 4,
    0, 3, 3, 3, 3, 0, 0, 0, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

bool IsHero[] = {
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, true,  false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false};

int SeekRange[] = {
    0,   0,  0, 160, 0,  256, 0,   32, 0,   0,   0, 0,   0, 96,  0,  0, 0,   0,
    0,   0,  0, 0,   0,  0,   0,   0,  0,   0,   0, 0,   0, 0,   96, 0, 288, 0,
    0,   96, 0, 96,  96, 0,   0,   96, 0,   256, 0, 96,  0, 0,   96, 0, 0,   0,
    0,   0,  0, 0,   0,  0,   288, 96, 224, 224, 0, 96,  0, 96,  96, 0, 0,   0,
    256, 0,  0, 0,   0,  0,   0,   0,  0,   0,   0, 256, 0, 96,  0,  0, 0,   0,
    0,   0,  0, 0,   0,  0,   0,   0,  0,   0,   0, 0,   0, 192, 0,  0, 0,   0,
    0,   0,  0, 0,   0,  0,   0,   0,  0,   0,   0, 0,   0, 0,   0,  0, 0,   0,
    0,   0,  0, 0,   0,  0,   0,   0,  0,   0,   0, 0,   0, 0,   0,  0, 0,   0,
    0,   0,  0, 0,   0,  0,   0,   0,  0,   0,   0, 0,   0, 0,   0,  0, 0,   0,
    0,   0,  0, 0,   0,  0,   0,   0,  0,   0,   0, 0,   0, 0,   0,  0, 0,   0,
    0,   0,  0, 0,   0,  0,   0,   0,  0,   0,   0, 0,   0, 0,   0,  0, 0,   0,
    0,   0,  0, 0,   0,  0,   0,   0,  0,   0,   0, 0,   0, 0,   0,  0, 0,   0,
    0,   0,  0, 0,   0,  0,   0,   0,  0,   0,   0, 0,   0, 0,   0,  0, 0};

int BuildTime[] = {
    360,  750,  450,  600,  0,    750,  0,    300, 900,  1200, 0,    750,
    2000, 1,    1500, 1,    0,    0,    0,    0,   0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    750,  0,   360,  1,    450,  1,
    1,    420,  420,  900,  1,    300,  600,  600, 600,  750,  750,  450,
    0,    0,    600,  0,    0,    0,    0,    0,   0,    0,    750,  1,
    600,  750,  600,  300,  300,  600,  750,  750, 300,  900,  1200, 2400,
    2100, 300,  0,    0,    0,    0,    0,    0,   0,    0,    0,    1050,
    600,  105,  0,    0,    0,    1,    1,    0,   0,    1,    1,    1,
    1,    1,    0,    0,    0,    0,    0,    600, 0,    2400, 1800, 600,
    1200, 600,  600,  1200, 1200, 1200, 1050, 600, 900,  600,  600,  0,
    600,  0,    900,  1200, 450,  450,  0,    0,   0,    0,    1800, 1800,
    1500, 1800, 600,  600,  900,  1800, 900,  600, 1200, 1800, 1200, 300,
    300,  0,    300,  0,    0,    600,  0,    0,   0,    0,    1800, 1200,
    450,  600,  0,    450,  900,  0,    750,  900, 900,  900,  600,  1050,
    0,    900,  900,  450,  450,  0,    0,    0,   1,    1,    1,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   1,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   0,    0,    2400, 0,
    0,    0,    0,    0,    0,    0,    0,    0,   0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   0,    0,    0,    0,
    0,    0,    0,    0,    0};

bool IsCritter[] = {
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, true,  true,  false, false, true,  true,  true,  true,  false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false};

bool RequiresPsi[] = {
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, true,  false, false, false, true,  true,  false, true,  true,  true,
    true,  true,  true,  false, true,  true,  true,  true,  false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false};

bool IsSpecialBuilding[] = {
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    true,  true,  true,  false, false, false, false, false, false, false, false,
    false, true,  false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false};

std::string GroundWeapon[] = {"Gauss_Rifle",
                              "C_10_Canister_Rifle",
                              "Fragmentation_Grenade",
                              "Twin_Autocannons",
                              "",
                              "Arclite_Cannon",
                              "",
                              "Fusion_Cutter",
                              "Burst_Lasers",
                              "None",
                              "",
                              "None",
                              "ATS_Laser_Battery",
                              "Spider_Mines",
                              "None",
                              "None",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "Arclite_Shock_Cannon",
                              "",
                              "Flame_Thrower",
                              "None",
                              "None",
                              "None",
                              "None",
                              "Claws",
                              "Needle_Spines",
                              "Kaiser_Blades",
                              "Toxic_Spores",
                              "Spines",
                              "None",
                              "Glave_Wurm",
                              "Acid_Spore",
                              "None",
                              "None",
                              "None",
                              "",
                              "",
                              "Suicide_Infested_Terran",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "None",
                              "None",
                              "None",
                              "Warp_Blades",
                              "None",
                              "None",
                              "Particle_Beam",
                              "Psi_Blades",
                              "Phase_Disruptor",
                              "None",
                              "Psionic_Shockwave",
                              "None",
                              "Dual_Photon_Blasters",
                              "Phase_Disruptor_Cannon",
                              "None",
                              "Pulse_Cannon",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "None",
                              "None",
                              "Scarab",
                              "",
                              "",
                              "",
                              "None",
                              "None",
                              "",
                              "",
                              "None",
                              "None",
                              "None",
                              "None",
                              "None",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "Subterranean_Spines",
                              "",
                              "None",
                              "None",
                              "None",
                              "None",
                              "None",
                              "None",
                              "None",
                              "None",
                              "None",
                              "None",
                              "None",
                              "None",
                              "None",
                              "None",
                              "",
                              "None",
                              "",
                              "None",
                              "None",
                              "None",
                              "None",
                              "",
                              "",
                              "",
                              "",
                              "None",
                              "None",
                              "None",
                              "None",
                              "None",
                              "None",
                              "None",
                              "None",
                              "None",
                              "None",
                              "None",
                              "None",
                              "None",
                              "None",
                              "None",
                              "",
                              "Subterranean_Tentacle",
                              "",
                              "",
                              "None",
                              "",
                              "",
                              "",
                              "",
                              "None",
                              "None",
                              "None",
                              "None",
                              "",
                              "None",
                              "None",
                              "",
                              "STS_Photon_Cannon",
                              "None",
                              "None",
                              "None",
                              "None",
                              "None",
                              "",
                              "None",
                              "None",
                              "None",
                              "None",
                              "",
                              "",
                              "",
                              "None",
                              "None",
                              "None",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "None",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "None",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              ""};

bool IsFlyer[] = {
    false, false, false, false, false, false, false, false, true,  true,  false,
    true,  true,  false, true,  false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    true,  false, false, false, false, false, false, false, false, true,  true,
    true,  true,  false, true,  false, false, false, false, false, false, false,
    false, false, false, true,  true,  true,  false, true,  false, false, false,
    false, false, false, true,  true,  true,  true,  true,  false, false, false,
    false, false, false, false, false, false, false, true,  false, false, false,
    false, false, false, false, false, false, true,  false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false};

std::string Size[] = {"Small",
                      "Small",
                      "Medium",
                      "Large",
                      "",
                      "Large",
                      "",
                      "Small",
                      "Large",
                      "Large",
                      "",
                      "Large",
                      "Large",
                      "Small",
                      "Independent",
                      "Small",
                      "",
                      "",
                      "",
                      "",
                      "",
                      "",
                      "",
                      "",
                      "",
                      "",
                      "",
                      "",
                      "",
                      "",
                      "Large",
                      "",
                      "Small",
                      "Independent",
                      "Small",
                      "Small",
                      "Medium",
                      "Small",
                      "Medium",
                      "Large",
                      "Small",
                      "Small",
                      "Large",
                      "Small",
                      "Large",
                      "Medium",
                      "Medium",
                      "Small",
                      "",
                      "",
                      "Small",
                      "",
                      "",
                      "",
                      "",
                      "",
                      "",
                      "",
                      "Large",
                      "Large",
                      "Medium",
                      "Small",
                      "Large",
                      "Large",
                      "Small",
                      "Small",
                      "Large",
                      "Small",
                      "Large",
                      "Large",
                      "Large",
                      "Large",
                      "Large",
                      "Small",
                      "",
                      "",
                      "",
                      "",
                      "",
                      "",
                      "",
                      "",
                      "",
                      "Large",
                      "Small",
                      "Small",
                      "",
                      "",
                      "",
                      "Small",
                      "Small",
                      "",
                      "",
                      "Small",
                      "Small",
                      "Small",
                      "Small",
                      "Medium",
                      "",
                      "",
                      "",
                      "",
                      "",
                      "Medium",
                      "",
                      "Independent",
                      "Large",
                      "Large",
                      "Large",
                      "Large",
                      "Large",
                      "Large",
                      "Large",
                      "Large",
                      "Large",
                      "Large",
                      "Large",
                      "Large",
                      "Large",
                      "",
                      "Large",
                      "",
                      "Large",
                      "Large",
                      "Large",
                      "Large",
                      "",
                      "",
                      "",
                      "",
                      "Large",
                      "Large",
                      "Large",
                      "Large",
                      "Large",
                      "Large",
                      "Large",
                      "Large",
                      "Large",
                      "Large",
                      "Large",
                      "Large",
                      "Large",
                      "Large",
                      "Large",
                      "",
                      "Large",
                      "",
                      "",
                      "Large",
                      "",
                      "",
                      "",
                      "",
                      "Large",
                      "Large",
                      "Large",
                      "Large",
                      "",
                      "Large",
                      "Large",
                      "",
                      "Large",
                      "Large",
                      "Large",
                      "Large",
                      "Large",
                      "Large",
                      "",
                      "Large",
                      "Large",
                      "Large",
                      "Large",
                      "",
                      "",
                      "",
                      "Independent",
                      "Independent",
                      "Independent",
                      "",
                      "",
                      "",
                      "",
                      "",
                      "",
                      "",
                      "",
                      "",
                      "Independent",
                      "",
                      "",
                      "",
                      "",
                      "",
                      "",
                      "",
                      "",
                      "",
                      "",
                      "",
                      "",
                      "",
                      "Independent",
                      "",
                      "",
                      "",
                      "",
                      "",
                      "",
                      "",
                      "",
                      "",
                      "",
                      "",
                      "",
                      "",
                      "",
                      "",
                      "",
                      "",
                      "",
                      "",
                      "",
                      "",
                      "",
                      "",
                      "",
                      "",
                      "",
                      "",
                      "",
                      "",
                      ""};

bool IsNeutral[] = {
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, true,  true,  false, false, true,  true,  true,  true,  false, false,
    false, false, false, false, false, false, true,  false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    true,  true,  true,  false, false, false, false, false, false, false, false,
    false, true,  false, false, false, false, false, false, false, false, false,
    false, false, false, false, true,  false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false};

int MaxShields[] = {
    0,   0,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 0,
    0,   0,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 0,
    0,   0,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 0,
    0,   0,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   80,  40,  0, 200,
    20,  60, 80,  40,  350, 60,  100, 150, 150, 40,  0,   0,   0,   0,   0, 0,
    0,   0,  0,   80,  20,  10,  0,   0,   0,   0,   0,   0,   0,   0,   0, 0,
    0,   0,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 0,
    0,   0,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 0,
    0,   0,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 0,
    0,   0,  0,   0,   0,   0,   0,   0,   0,   0,   750, 500, 300, 450, 0, 250,
    500, 0,  100, 450, 500, 500, 550, 600, 0,   500, 500, 450, 200, 0,   0, 0,
    0,   0,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 0,
    0,   0,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 0,
    0,   0,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 0,
    0,   0,  0,   0,   0,   0,   0,   0,   0};

bool HasPermanentCloak[] = {
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, true,  false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, true,  false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false};

double TopSpeed[] = {
    4,    4,     6.4,   4.57, 0.0,  4,    0.0,  4.92, 6.67, 5,    0.0, 5.47,
    2.5,  16,    33.33, 4,    0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0, 0.0,
    0.0,  0.0,   0.0,   0.0,  0.0,  0.0,  0,    0.0,  4,    0,    4,   0,
    0,    5.49,  3.66,  5.12, 6,    4.92, 0.83, 6.67, 2.5,  6.67, 4,   6.67,
    0.0,  0.0,   5.82,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  6.6, 0,
    6.67, 4.92,  5,     4.92, 4.92, 4,    5,    3.2,  4.92, 4.43, 5,   5,
    3.33, 13.33, 0.0,   0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0, 1.78,
    3.33, 16,    0.0,   0.0,  0.0,  4,    4,    0.0,  0.0,  4,    5,   4,
    4,    0,     0.0,   0.0,  0.0,  0.0,  0.0,  5.82, 0.0,  0,    1,   0,
    0,    0,     0,     1,    0,    1,    1,    0,    1,    0,    0,   0.0,
    0,    0.0,   1,     0,    0,    0,    0.0,  0.0,  0.0,  0.0,  1,   0,
    0,    0,     0,     0,    0,    0,    0,    0,    0,    0,    0,   0,
    0,    0.0,   0,     0.0,  0.0,  0,    0.0,  0.0,  0.0,  0.0,  0,   0,
    0,    0,     0.0,   0,    0,    0.0,  0,    0,    0,    0,    0,   0,
    0.0,  0,     0,     0,    0,    0.0,  0.0,  0.0,  0,    0,    0,   0.0,
    0.0,  0.0,   0.0,   0.0,  0.0,  0.0,  0.0,  0.0,  0,    0.0,  0.0, 0.0,
    0.0,  0.0,   0.0,   0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0,   0.0,
    0.0,  0.0,   0.0,   0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0, 0.0,
    0.0,  0.0,   0.0,   0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0, 0.0,
    0.0,  0.0,   0.0,   0.0,  0.0};

int TileHeight[] = {
    1, 1, 1, 1, 0, 1, 0, 1, 1, 2, 0, 2, 2, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 2, 2, 2, 2, 1, 1,
    0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 2, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 2,
    2, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 1, 1, 0, 0, 1, 1, 1,
    1, 1, 0, 0, 0, 0, 0, 1, 0, 3, 3, 2, 2, 2, 2, 3, 2, 3, 3, 2, 3, 2, 2, 0,
    2, 0, 3, 2, 2, 2, 0, 0, 0, 0, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 0, 2, 0, 0, 2, 0, 0, 0, 0, 3, 2, 2, 2, 0, 2, 3, 0, 2, 2, 2, 2, 2, 3,
    0, 2, 2, 2, 2, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

bool IsRobotic[] = {
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, true,  false,
    false, false, false, true,  false, false, false, false, false, false, false,
    false, false, false, false, false, false, true,  true,  false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false};

int DimensionUp[] = {
    9,  10, 16, 16, 0,  16, 0,  11, 15, 33, 0,  16, 29, 7,  14, 9,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  16, 0,  7,  13, 9,  8,
    16, 4,  10, 16, 9,  11, 25, 22, 22, 24, 12, 12, 0,  0,  9,  0,  0,  0,
    0,  0,  0,  0,  16, 16, 16, 6,  22, 16, 11, 5,  15, 10, 16, 16, 16, 22,
    32, 8,  0,  0,  0,  0,  0,  0,  0,  0,  0,  16, 16, 2,  0,  0,  0,  16,
    16, 0,  0,  16, 16, 16, 16, 16, 0,  0,  0,  0,  0,  15, 0,  40, 41, 16,
    16, 22, 32, 40, 32, 40, 40, 24, 38, 24, 24, 0,  24, 0,  32, 32, 32, 24,
    0,  0,  0,  0,  41, 32, 32, 32, 32, 32, 32, 32, 28, 32, 32, 32, 28, 24,
    24, 0,  24, 0,  0,  32, 0,  0,  0,  0,  39, 16, 12, 32, 0,  16, 32, 0,
    16, 24, 24, 24, 24, 40, 0,  32, 28, 32, 16, 0,  0,  0,  16, 16, 16, 0,
    0,  0,  0,  0,  0,  0,  0,  0,  32, 0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  80, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};

int DestroyScore[] = {
    100,  350,  150,  400,  0,   700,  0,    100,  800, 1250, 0,    600,  2400,
    25,   0,    10,   0,    0,   0,    0,    0,    0,   0,    0,    0,    0,
    0,    0,    0,    0,    700, 0,    200,  0,    250, 10,   25,   50,   350,
    1300, 25,   100,  200,  600, 1100, 800,  450,  200, 0,    0,    400,  0,
    0,    0,    0,    0,    0,   0,    800,  1100, 700, 650,  1100, 1300, 100,
    200,  500,  700,  1400, 400, 1300, 2050, 1900, 60,  0,    0,    0,    0,
    0,    0,    0,    0,    0,   800,  450,  0,    0,   0,    0,    10,   10,
    0,    0,    10,   10,   10,  10,   500,  0,    0,   0,    0,    0,    500,
    0,    0,    1200, 225,  225, 150,  150,  225,  300, 600,  600,  300,  825,
    225,  225,  0,    225,  0,   195,  300,  150,  150, 0,    0,    0,    0,
    900,  900,  1200, 1500, 225, 300,  450,  1350, 525, 120,  825,  750,  225,
    120,  195,  0,    240,  0,   0,    75,   0,    0,   0,    0,    1200, 900,
    150,  150,  0,    525,  225, 0,    300,  600,  300, 750,  300,  900,  0,
    1050, 1350, 375,  150,  0,   0,    0,    10,   10,  10,   0,    0,    0,
    0,    0,    0,    0,    0,   0,    10,   0,    0,   0,    0,    0,    0,
    0,    0,    0,    0,    0,   0,    0,    0,    0,   0,    0,    0,    0,
    0,    0,    0,    0,    0,   0,    0,    0,    0,   0,    0,    0,    0,
    0,    0,    0,    0,    0,   0,    0,    0,    0,   0,    0,    0};

int SpaceProvided[] = {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

std::string TileSize[] = {"BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "",
                          "BWAPI::TilePosition",
                          "",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "",
                          "",
                          "",
                          "",
                          "",
                          "",
                          "",
                          "",
                          "",
                          "",
                          "",
                          "",
                          "",
                          "",
                          "BWAPI::TilePosition",
                          "",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "",
                          "",
                          "BWAPI::TilePosition",
                          "",
                          "",
                          "",
                          "",
                          "",
                          "",
                          "",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "",
                          "",
                          "",
                          "",
                          "",
                          "",
                          "",
                          "",
                          "",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "",
                          "",
                          "",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "",
                          "",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "",
                          "",
                          "",
                          "",
                          "",
                          "BWAPI::TilePosition",
                          "",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "",
                          "BWAPI::TilePosition",
                          "",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "",
                          "",
                          "",
                          "",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "",
                          "BWAPI::TilePosition",
                          "",
                          "",
                          "BWAPI::TilePosition",
                          "",
                          "",
                          "",
                          "",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "",
                          "",
                          "",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "BWAPI::TilePosition",
                          "",
                          "",
                          "",
                          "",
                          "",
                          "",
                          "",
                          "",
                          "",
                          "BWAPI::TilePosition",
                          "",
                          "",
                          "",
                          "",
                          "",
                          "",
                          "",
                          "",
                          "",
                          "",
                          "",
                          "",
                          "",
                          "BWAPI::TilePosition",
                          "",
                          "",
                          "",
                          "",
                          "",
                          "",
                          "",
                          "",
                          "",
                          "",
                          "",
                          "",
                          "",
                          "",
                          "",
                          "",
                          "",
                          "",
                          "",
                          "",
                          "",
                          "",
                          "",
                          "",
                          "",
                          "",
                          "",
                          "",
                          "",
                          ""};

int HaltDistance[] = {
    1,     1,     14569, 1,     0,       1,     0,    12227, 21745, 5120,
    0,     37756, 7585,  1,     1103213, 1,     0,    0,     0,     0,
    0,     0,     0,     0,     0,       0,     0,    0,     0,     0,
    1,     0,     1,     0,     1,       1,     0,    1,     1,     1,
    1,     12227, 840,   21745, 7585,    21745, 1,    13616, 0,     0,
    1,     0,     0,     0,     0,       0,     0,    0,     21901, 0,
    17067, 13474, 17067, 5120,  12227,   1,     1,    13474, 5120,  37756,
    17067, 24824, 13474, 13640, 0,       0,     0,    0,     0,     0,
    0,     0,     0,     1,     13474,   1,     0,    0,     0,     1,
    1,     0,     0,     1,     51200,   1,     1,    0,     0,     0,
    0,     0,     0,     1,     0,       0,     2763, 0,     0,     0,
    2763,  2763,  0,     2763,  2763,    0,     2763, 0,     0,     0,
    0,     0,     2763,  0,     0,       2763,  0,    0,     0,     0,
    2763,  0,     0,     0,     0,       0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,       0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,       0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,       0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,       0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,       0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,       0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,       0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,       0,     0,    0,     0,     0,
    0,     0,     0,     0,     0,       0,     0,    0,     0,     0,
    0,     0,     0};

bool IsAddon[] = {
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, true,  true,  false,
    false, false, false, false, false, true,  false, true,  true,  false, true,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false};

bool CanMove[] = {
    true,  true,  true,  true,  false, true,  false, true,  true,  true,  false,
    true,  true,  true,  true,  true,  false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, true,
    true,  true,  true,  false, true,  true,  true,  true,  true,  true,  true,
    true,  true,  true,  true,  false, false, true,  false, false, false, false,
    false, false, false, true,  false, true,  true,  true,  true,  true,  true,
    true,  true,  true,  true,  true,  true,  true,  true,  false, false, false,
    false, false, false, false, false, false, true,  true,  true,  false, false,
    false, true,  true,  false, false, true,  true,  true,  true,  false, false,
    false, false, false, false, true,  false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false};

bool IsFlyingBuilding[] = {
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, true,  false, false, false,
    false, true,  false, true,  true,  false, true,  false, false, false, false,
    false, true,  false, false, false, false, false, false, false, true,  false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false};

int MaxEnergy[] = {
    0, 200, 0, 0, 0, 0, 0,   0, 200, 200, 0,   0, 200, 0,   0, 0, 0,   0,
    0, 0,   0, 0, 0, 0, 0,   0, 0,   0,   0,   0, 0,   0,   0, 0, 200, 0,
    0, 0,   0, 0, 0, 0, 0,   0, 0,   200, 200, 0, 0,   0,   0, 0, 0,   0,
    0, 0,   0, 0, 0, 0, 200, 0, 0,   200, 0,   0, 0,   200, 0, 0, 0,   200,
    0, 0,   0, 0, 0, 0, 0,   0, 0,   0,   0,   0, 0,   0,   0, 0, 0,   0,
    0, 0,   0, 0, 0, 0, 0,   0, 0,   0,   0,   0, 0,   0,   0, 0, 0,   200,
    0, 0,   0, 0, 0, 0, 0,   0, 0,   0,   0,   0, 0,   0,   0, 0, 0,   0,
    0, 0,   0, 0, 0, 0, 0,   0, 0,   0,   0,   0, 0,   0,   0, 0, 0,   0,
    0, 0,   0, 0, 0, 0, 0,   0, 0,   0,   0,   0, 0,   0,   0, 0, 0,   0,
    0, 0,   0, 0, 0, 0, 0,   0, 0,   0,   200, 0, 0,   0,   0, 0, 0,   0,
    0, 0,   0, 0, 0, 0, 0,   0, 0,   0,   0,   0, 0,   0,   0, 0, 0,   0,
    0, 0,   0, 0, 0, 0, 0,   0, 0,   0,   0,   0, 0,   0,   0, 0, 0,   0,
    0, 0,   0, 0, 0, 0, 0,   0, 0,   0,   0,   0, 0,   0,   0, 0, 0};

bool IsDetector[] = {
    false, false, false, false, false, false, false, false, false, true,  false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    true,  false, false, false, false, false, false, false, false, true,  false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, true,  false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, true,  false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, true,  false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, true,  false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false};

bool IsOrganic[] = {
    true,  true,  false, false, false, false, false, true,  false, false, false,
    false, false, false, false, true,  false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, true,
    false, true,  true,  true,  true,  true,  true,  true,  true,  true,  true,
    true,  true,  true,  true,  false, false, true,  false, false, false, false,
    false, false, false, false, true,  false, true,  true,  false, false, true,
    false, true,  false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, true,  true,  false, false, true,  true,  true,  true,  true,  false,
    false, false, false, false, true,  false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, true,  true,
    true,  true,  true,  true,  true,  true,  true,  true,  true,  true,  true,
    true,  true,  false, true,  false, false, true,  false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false};

int SpaceRequired[] = {
    1,   1,   2,   2,   0,   4,   0,   1,   255, 255, 0,   255, 255, 255, 255,
    1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    255, 0,   1,   255, 1,   255, 255, 1,   2,   4,   1,   1,   255, 255, 255,
    255, 2,   255, 0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   255, 255,
    255, 2,   255, 4,   1,   2,   4,   2,   4,   255, 255, 255, 255, 255, 0,
    0,   0,   0,   0,   0,   0,   0,   0,   4,   255, 255, 0,   0,   0,   255,
    255, 0,   0,   255, 255, 255, 255, 255, 0,   0,   0,   0,   0,   4,   0,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0,
    255, 0,   255, 255, 255, 255, 0,   0,   0,   0,   255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0,   255, 0,   0,   255,
    0,   0,   0,   0,   255, 255, 255, 255, 0,   255, 255, 0,   255, 255, 255,
    255, 255, 255, 0,   255, 255, 255, 255, 0,   0,   0,   255, 255, 255, 0,
    0,   0,   0,   0,   0,   0,   0,   0,   255, 0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   255, 0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0};

bool IsFlagBeacon[] = {
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false};

bool IsWorker[] = {
    false, false, false, false, false, false, false, true,  false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, true,  false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, true,  false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false};

bool IsBurrowable[] = {
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, true,  true,  false, false, true,  false, false,
    false, false, true,  false, false, false, true,  false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, true,  false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false};

std::string CloakingTech[] = {"None",
                              "Personnel_Cloaking",
                              "None",
                              "None",
                              "",
                              "None",
                              "",
                              "None",
                              "Cloaking_Field",
                              "None",
                              "",
                              "None",
                              "None",
                              "None",
                              "None",
                              "None",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "None",
                              "",
                              "None",
                              "None",
                              "None",
                              "None",
                              "None",
                              "None",
                              "None",
                              "None",
                              "None",
                              "None",
                              "None",
                              "None",
                              "None",
                              "None",
                              "None",
                              "None",
                              "",
                              "",
                              "None",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "None",
                              "None",
                              "None",
                              "None",
                              "None",
                              "None",
                              "None",
                              "None",
                              "None",
                              "None",
                              "None",
                              "None",
                              "None",
                              "None",
                              "None",
                              "None",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "None",
                              "None",
                              "None",
                              "",
                              "",
                              "",
                              "None",
                              "None",
                              "",
                              "",
                              "None",
                              "None",
                              "None",
                              "None",
                              "None",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "None",
                              "",
                              "None",
                              "None",
                              "None",
                              "None",
                              "None",
                              "None",
                              "None",
                              "None",
                              "None",
                              "None",
                              "None",
                              "None",
                              "None",
                              "None",
                              "",
                              "None",
                              "",
                              "None",
                              "None",
                              "None",
                              "None",
                              "",
                              "",
                              "",
                              "",
                              "None",
                              "None",
                              "None",
                              "None",
                              "None",
                              "None",
                              "None",
                              "None",
                              "None",
                              "None",
                              "None",
                              "None",
                              "None",
                              "None",
                              "None",
                              "",
                              "None",
                              "",
                              "",
                              "None",
                              "",
                              "",
                              "",
                              "",
                              "None",
                              "None",
                              "None",
                              "None",
                              "",
                              "None",
                              "None",
                              "",
                              "None",
                              "None",
                              "None",
                              "None",
                              "None",
                              "None",
                              "",
                              "None",
                              "None",
                              "None",
                              "None",
                              "",
                              "",
                              "",
                              "None",
                              "None",
                              "None",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "None",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "None",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              ""};

bool IsResourceContainer[] = {
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    true,  false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, true,  false, false, false, false,
    false, false, false, true,  false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    true,  true,  true,  false, false, false, false, false, false, false, false,
    false, true,  false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false};

int Acceleration[] = {
    1,  1,   100, 1,  0,  1,  0,  67, 67, 50,  0,  17,  27, 1,  33,  1,  0,  0,
    0,  0,   0,   0,  0,  0,  0,  0,  0,  0,   0,  0,   1,  0,  1,   0,  1,  1,
    0,  1,   1,   1,  1,  67, 27, 67, 27, 67,  1,  107, 0,  0,  1,   0,  0,  0,
    0,  0,   0,   0,  65, 0,  67, 27, 48, 160, 67, 1,   1,  27, 160, 17, 48, 33,
    27, 427, 0,   0,  0,  0,  0,  0,  0,  0,   0,  1,   27, 1,  0,   0,  0,  1,
    1,  0,   0,   1,  16, 1,  1,  0,  0,  0,   0,  0,   0,  1,  0,   0,  33, 0,
    0,  0,   33,  33, 0,  33, 33, 0,  33, 0,   0,  0,   0,  0,  33,  0,  0,  33,
    0,  0,   0,   0,  33, 0,  0,  0,  0,  0,   0,  0,   0,  0,  0,   0,  0,  0,
    0,  0,   0,   0,  0,  0,  0,  0,  0,  0,   0,  0,   0,  0,  0,   0,  0,  0,
    0,  0,   0,   0,  0,  0,  0,  0,  0,  0,   0,  0,   0,  0,  0,   0,  0,  0,
    0,  0,   0,   0,  0,  0,  0,  0,  0,  0,   0,  0,   0,  0,  0,   0,  0,  0,
    0,  0,   0,   0,  0,  0,  0,  0,  0,  0,   0,  0,   0,  0,  0,   0,  0,  0,
    0,  0,   0,   0,  0,  0,  0,  0,  0,  0,   0,  0,   0,  0,  0,   0,  0};

bool IsSpell[] = {
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    true,  false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, true,  false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, true,  false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false};

bool RequiresCreep[] = {
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, true,  true,  true,  true,  true,  true,  true,  true,  true,
    true,  true,  false, true,  false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false, false, false, false, false, false, false, false, false, false,
    false, false};

std::string ArmorUpgrade[] = {"Terran_Infantry_Armor",
                              "Terran_Infantry_Armor",
                              "Terran_Vehicle_Plating",
                              "Terran_Vehicle_Plating",
                              "",
                              "Terran_Vehicle_Plating",
                              "",
                              "Terran_Infantry_Armor",
                              "Terran_Ship_Plating",
                              "Terran_Ship_Plating",
                              "",
                              "Terran_Ship_Plating",
                              "Terran_Ship_Plating",
                              "Upgrade_60",
                              "Upgrade_60",
                              "Terran_Infantry_Armor",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "Terran_Vehicle_Plating",
                              "",
                              "Terran_Infantry_Armor",
                              "Upgrade_60",
                              "Terran_Infantry_Armor",
                              "Zerg_Carapace",
                              "Zerg_Carapace",
                              "Zerg_Carapace",
                              "Zerg_Carapace",
                              "Zerg_Carapace",
                              "Zerg_Carapace",
                              "Zerg_Carapace",
                              "Zerg_Flyer_Carapace",
                              "Zerg_Flyer_Carapace",
                              "Zerg_Flyer_Carapace",
                              "Zerg_Flyer_Carapace",
                              "Zerg_Carapace",
                              "Zerg_Flyer_Carapace",
                              "",
                              "",
                              "Zerg_Carapace",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "Terran_Ship_Plating",
                              "Zerg_Carapace",
                              "Protoss_Air_Armor",
                              "Protoss_Ground_Armor",
                              "Zerg_Flyer_Carapace",
                              "Protoss_Ground_Armor",
                              "Protoss_Ground_Armor",
                              "Protoss_Ground_Armor",
                              "Protoss_Ground_Armor",
                              "Protoss_Ground_Armor",
                              "Protoss_Ground_Armor",
                              "Protoss_Air_Armor",
                              "Protoss_Air_Armor",
                              "Protoss_Air_Armor",
                              "Protoss_Air_Armor",
                              "Protoss_Air_Armor",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "Protoss_Ground_Armor",
                              "Protoss_Air_Armor",
                              "Protoss_Ground_Armor",
                              "",
                              "",
                              "",
                              "Upgrade_60",
                              "Upgrade_60",
                              "",
                              "",
                              "Upgrade_60",
                              "Upgrade_60",
                              "Upgrade_60",
                              "Upgrade_60",
                              "Zerg_Carapace",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "Zerg_Carapace",
                              "",
                              "Upgrade_60",
                              "Upgrade_60",
                              "Upgrade_60",
                              "Upgrade_60",
                              "Upgrade_60",
                              "Upgrade_60",
                              "Upgrade_60",
                              "Upgrade_60",
                              "Upgrade_60",
                              "Upgrade_60",
                              "Upgrade_60",
                              "Upgrade_60",
                              "Upgrade_60",
                              "Upgrade_60",
                              "",
                              "Upgrade_60",
                              "",
                              "Upgrade_60",
                              "Upgrade_60",
                              "Upgrade_60",
                              "Upgrade_60",
                              "",
                              "",
                              "",
                              "",
                              "Upgrade_60",
                              "Upgrade_60",
                              "Upgrade_60",
                              "Upgrade_60",
                              "Upgrade_60",
                              "Upgrade_60",
                              "Upgrade_60",
                              "Upgrade_60",
                              "Upgrade_60",
                              "Upgrade_60",
                              "Upgrade_60",
                              "Upgrade_60",
                              "Upgrade_60",
                              "Upgrade_60",
                              "Upgrade_60",
                              "",
                              "Upgrade_60",
                              "",
                              "",
                              "Upgrade_60",
                              "",
                              "",
                              "",
                              "",
                              "Upgrade_60",
                              "Upgrade_60",
                              "Upgrade_60",
                              "Upgrade_60",
                              "",
                              "Upgrade_60",
                              "Upgrade_60",
                              "",
                              "Upgrade_60",
                              "Upgrade_60",
                              "Upgrade_60",
                              "Upgrade_60",
                              "Upgrade_60",
                              "Upgrade_60",
                              "",
                              "Upgrade_60",
                              "Upgrade_60",
                              "Upgrade_60",
                              "Upgrade_60",
                              "",
                              "",
                              "",
                              "Upgrade_60",
                              "Upgrade_60",
                              "Upgrade_60",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "Upgrade_60",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "Upgrade_60",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              "",
                              ""};

int MaxGroundHits[] = {
    1, 1, 1, 1, 0, 1, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 1, 0, 3, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 1, 1, 0, 0, 0,
    0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 2, 1, 0, 1, 0, 1, 1,
    0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

int TurnRadius[] = {
    40, 40, 40, 17, 0,  13, 0,  40, 40, 40, 0,  20, 20, 127, 127, 40, 0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  40, 0,   40,  0,  40, 20,
    0,  27, 27, 40, 27, 40, 20, 40, 20, 40, 27, 40, 0,  0,   40,  0,  0,  0,
    0,  0,  0,  0,  30, 0,  30, 40, 30, 40, 40, 40, 40, 40,  40,  20, 30, 40,
    20, 40, 0,  0,  0,  0,  0,  0,  0,  0,  0,  20, 20, 27,  0,   0,  0,  27,
    27, 0,  0,  27, 14, 27, 27, 0,  0,  0,  0,  0,  0,  40,  0,   0,  27, 0,
    0,  0,  27, 27, 0,  27, 27, 0,  27, 0,  0,  0,  0,  0,   27,  0,  40, 27,
    0,  0,  0,  0,  27, 0,  0,  0,  0,  0,  0,  0,  0,  0,   0,   0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,   0,   0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,   0,   0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,   0,   0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,   0,   0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,   0,   0,  0};

std::string GetRace[] = {
    "Terran",  "Terran",  "Terran",  "Terran",  "",        "Terran",  "",
    "Terran",  "Terran",  "Terran",  "",        "Terran",  "Terran",  "Terran",
    "Terran",  "Terran",  "",        "",        "",        "",        "",
    "",        "",        "",        "",        "",        "",        "",
    "",        "",        "Terran",  "",        "Terran",  "Terran",  "Terran",
    "Zerg",    "Zerg",    "Zerg",    "Zerg",    "Zerg",    "Zerg",    "Zerg",
    "Zerg",    "Zerg",    "Zerg",    "Zerg",    "Zerg",    "Zerg",    "",
    "",        "Zerg",    "",        "",        "",        "",        "",
    "",        "",        "Terran",  "Zerg",    "Protoss", "Protoss", "Zerg",
    "Protoss", "Protoss", "Protoss", "Protoss", "Protoss", "Protoss", "Protoss",
    "Protoss", "Protoss", "Protoss", "Protoss", "",        "",        "",
    "",        "",        "",        "",        "",        "",        "Protoss",
    "Protoss", "Protoss", "",        "",        "",        "None",    "None",
    "",        "",        "None",    "None",    "None",    "None",    "Zerg",
    "",        "",        "",        "",        "",        "Zerg",    "",
    "None",    "Terran",  "Terran",  "Terran",  "Terran",  "Terran",  "Terran",
    "Terran",  "Terran",  "Terran",  "Terran",  "Terran",  "Terran",  "Terran",
    "",        "Terran",  "",        "Terran",  "Terran",  "Terran",  "Terran",
    "",        "",        "",        "",        "Zerg",    "Zerg",    "Zerg",
    "Zerg",    "Zerg",    "Zerg",    "Zerg",    "Zerg",    "Zerg",    "Zerg",
    "Zerg",    "Zerg",    "Zerg",    "Zerg",    "Zerg",    "",        "Zerg",
    "",        "",        "Zerg",    "",        "",        "",        "",
    "Protoss", "Protoss", "Protoss", "Protoss", "",        "Protoss", "Protoss",
    "",        "Protoss", "Protoss", "Protoss", "Protoss", "Protoss", "Protoss",
    "",        "Protoss", "Protoss", "Protoss", "Protoss", "",        "",
    "",        "None",    "None",    "None",    "",        "",        "",
    "",        "",        "",        "",        "",        "",        "None",
    "",        "",        "",        "",        "",        "",        "",
    "",        "",        "",        "",        "",        "",        "None",
    "",        "",        "",        "",        "",        "",        "",
    "",        "",        "",        "",        "",        "",        "",
    "",        "",        "",        "",        "",        "",        "",
    "",        "",        "",        "",        "",        "",        "",
    "",        ""};

} // namespace data
} // namespace BW
} // namespace torchcraft
