# Copyright (c) 2015-present, Facebook, Inc.
# All rights reserved.
# 
# This source code is licensed under the BSD-style license found in the
# LICENSE file in the root directory of this source tree. An additional grant
# of patent rights can be found in the PATENTS file in the same directory.

# Try to find ZSTD (dynamic and static libraries)

FIND_PATH(ZSTD_INCLUDE_DIR zstd.h HINTS ENV CPLUS_INCLUDE_PATH)
IF(";${ZSTD_FIND_COMPONENTS};" MATCHES ";static;")
  FIND_LIBRARY(ZSTD_LIBRARY NAMES libzstd.a zstd.lib
    HINTS ENV LIBRARY_PATH ENV LD_LIBRARY_PATH )
ELSE()
  FIND_LIBRARY(ZSTD_LIBRARY NAMES zstd
    HINTS ENV LIBRARY_PATH ENV LD_LIBRARY_PATH )
ENDIF()

# Parse version; not very robust...
IF(NOT (${ZSTD_INCLUDE_DIR} STREQUAL "ZSTD_INCLUDE_DIR-NOTFOUND"))
  FILE(STRINGS "${ZSTD_INCLUDE_DIR}/zstd.h" LINES REGEX "#define ZSTD_VERSION_MAJOR")
  STRING(REGEX MATCH "[0-9]+" ZSTD_VERSION_MAJOR ${LINES})
  FILE(STRINGS "${ZSTD_INCLUDE_DIR}/zstd.h" LINES REGEX "#define ZSTD_VERSION_MINOR")
  STRING(REGEX MATCH "[0-9]+" ZSTD_VERSION_MINOR ${LINES})
  FILE(STRINGS "${ZSTD_INCLUDE_DIR}/zstd.h" LINES REGEX "#define ZSTD_VERSION_RELEASE")
  STRING(REGEX MATCH "[0-9]+" ZSTD_VERSION_RELEASE ${LINES})
  SET(ZSTD_VERSION
    "${ZSTD_VERSION_MAJOR}.${ZSTD_VERSION_MINOR}.${ZSTD_VERSION_RELEASE}")
ENDIF()

INCLUDE(FindPackageHandleStandardArgs)
FIND_PACKAGE_HANDLE_STANDARD_ARGS(ZSTD
  REQUIRED_VARS ZSTD_LIBRARY ZSTD_INCLUDE_DIR
  VERSION_VAR ZSTD_VERSION)
