# coding=utf-8
# *** WARNING: this file was generated by pulumi-gen-eks. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables
from .vpc_cni import VpcCni
import pulumi_aws
import pulumi_kubernetes

__all__ = [
    'ClusterNodeGroupOptionsArgs',
    'CoreDataArgs',
    'CreationRoleProviderArgs',
    'FargateProfileArgs',
    'KubeconfigOptionsArgs',
    'RoleMappingArgs',
    'StorageClassArgs',
    'TaintArgs',
    'UserMappingArgs',
    'VpcCniOptionsArgs',
]

@pulumi.input_type
class ClusterNodeGroupOptionsArgs:
    def __init__(__self__, *,
                 ami_id: Optional[pulumi.Input[str]] = None,
                 auto_scaling_group_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 bootstrap_extra_args: Optional[pulumi.Input[str]] = None,
                 cloud_formation_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 cluster_ingress_rule: Optional[pulumi.Input['pulumi_aws.ec2.SecurityGroupRule']] = None,
                 desired_capacity: Optional[pulumi.Input[int]] = None,
                 encrypt_root_block_device: Optional[pulumi.Input[bool]] = None,
                 extra_node_security_groups: Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ec2.SecurityGroup']]]] = None,
                 gpu: Optional[pulumi.Input[bool]] = None,
                 instance_profile: Optional[pulumi.Input['pulumi_aws.iam.InstanceProfile']] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 key_name: Optional[pulumi.Input[str]] = None,
                 kubelet_extra_args: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 max_size: Optional[pulumi.Input[int]] = None,
                 min_size: Optional[pulumi.Input[int]] = None,
                 node_associate_public_ip_address: Optional[pulumi.Input[bool]] = None,
                 node_public_key: Optional[pulumi.Input[str]] = None,
                 node_root_volume_size: Optional[pulumi.Input[int]] = None,
                 node_security_group: Optional[pulumi.Input['pulumi_aws.ec2.SecurityGroup']] = None,
                 node_subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 node_user_data: Optional[pulumi.Input[str]] = None,
                 node_user_data_override: Optional[pulumi.Input[str]] = None,
                 spot_price: Optional[pulumi.Input[str]] = None,
                 taints: Optional[pulumi.Input[Mapping[str, pulumi.Input['TaintArgs']]]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        Describes the configuration options accepted by a cluster to create its own node groups.
        :param pulumi.Input[str] ami_id: The AMI ID to use for the worker nodes.
               
               Defaults to the latest recommended EKS Optimized Linux AMI from the AWS Systems Manager Parameter Store.
               
               Note: `amiId` and `gpu` are mutually exclusive.
               
               See for more details:
               - https://docs.aws.amazon.com/eks/latest/userguide/eks-optimized-ami.html.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] auto_scaling_group_tags: The tags to apply to the NodeGroup's AutoScalingGroup in the CloudFormation Stack.
               
               Per AWS, all stack-level tags, including automatically created tags, and the `cloudFormationTags` option are propagated to resources that AWS CloudFormation supports, including the AutoScalingGroup. See https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html
               
               Note: Given the inheritance of auto-generated CF tags and `cloudFormationTags`, you should either supply the tag in `autoScalingGroupTags` or `cloudFormationTags`, but not both.
        :param pulumi.Input[str] bootstrap_extra_args: Additional args to pass directly to `/etc/eks/bootstrap.sh`. Fror details on available options, see: https://github.com/awslabs/amazon-eks-ami/blob/master/files/bootstrap.sh. Note that the `--apiserver-endpoint`, `--b64-cluster-ca` and `--kubelet-extra-args` flags are included automatically based on other configuration parameters.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] cloud_formation_tags: The tags to apply to the CloudFormation Stack of the Worker NodeGroup.
               
               Note: Given the inheritance of auto-generated CF tags and `cloudFormationTags`, you should either supply the tag in `autoScalingGroupTags` or `cloudFormationTags`, but not both.
        :param pulumi.Input['pulumi_aws.ec2.SecurityGroupRule'] cluster_ingress_rule: The ingress rule that gives node group access.
        :param pulumi.Input[int] desired_capacity: The number of worker nodes that should be running in the cluster. Defaults to 2.
        :param pulumi.Input[bool] encrypt_root_block_device: Encrypt the root block device of the nodes in the node group.
        :param pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ec2.SecurityGroup']]] extra_node_security_groups: Extra security groups to attach on all nodes in this worker node group.
               
               This additional set of security groups captures any user application rules that will be needed for the nodes.
        :param pulumi.Input[bool] gpu: Use the latest recommended EKS Optimized Linux AMI with GPU support for the worker nodes from the AWS Systems Manager Parameter Store.
               
               Defaults to false.
               
               Note: `gpu` and `amiId` are mutually exclusive.
               
               See for more details:
               - https://docs.aws.amazon.com/eks/latest/userguide/eks-optimized-ami.html
               - https://docs.aws.amazon.com/eks/latest/userguide/retrieve-ami-id.html
        :param pulumi.Input['pulumi_aws.iam.InstanceProfile'] instance_profile: The ingress rule that gives node group access.
        :param pulumi.Input[str] instance_type: The instance type to use for the cluster's nodes. Defaults to "t2.medium".
        :param pulumi.Input[str] key_name: Name of the key pair to use for SSH access to worker nodes.
        :param pulumi.Input[str] kubelet_extra_args: Extra args to pass to the Kubelet. Corresponds to the options passed in the `--kubeletExtraArgs` flag to `/etc/eks/bootstrap.sh`. For example, '--port=10251 --address=0.0.0.0'. Note that the `labels` and `taints` properties will be applied to this list (using `--node-labels` and `--register-with-taints` respectively) after to the expicit `kubeletExtraArgs`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Custom k8s node labels to be attached to each woker node. Adds the given key/value pairs to the `--node-labels` kubelet argument.
        :param pulumi.Input[int] max_size: The maximum number of worker nodes running in the cluster. Defaults to 2.
        :param pulumi.Input[int] min_size: The minimum number of worker nodes running in the cluster. Defaults to 1.
        :param pulumi.Input[bool] node_associate_public_ip_address: Whether or not to auto-assign public IP addresses on the EKS worker nodes. If this toggle is set to true, the EKS workers will be auto-assigned public IPs. If false, they will not be auto-assigned public IPs.
        :param pulumi.Input[str] node_public_key: Public key material for SSH access to worker nodes. See allowed formats at:
               https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html
               If not provided, no SSH access is enabled on VMs.
        :param pulumi.Input[int] node_root_volume_size: The size in GiB of a cluster node's root volume. Defaults to 20.
        :param pulumi.Input['pulumi_aws.ec2.SecurityGroup'] node_security_group: The security group for the worker node group to communicate with the cluster.
               
               This security group requires specific inbound and outbound rules.
               
               See for more details:
               https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html
               
               Note: The `nodeSecurityGroup` option and the cluster option`nodeSecurityGroupTags` are mutually exclusive.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] node_subnet_ids: The set of subnets to override and use for the worker node group.
               
               Setting this option overrides which subnets to use for the worker node group, regardless if the cluster's `subnetIds` is set, or if `publicSubnetIds` and/or `privateSubnetIds` were set.
        :param pulumi.Input[str] node_user_data: Extra code to run on node startup. This code will run after the AWS EKS bootstrapping code and before the node signals its readiness to the managing CloudFormation stack. This code must be a typical user data script: critically it must begin with an interpreter directive (i.e. a `#!`).
        :param pulumi.Input[str] node_user_data_override: User specified code to run on node startup. This code is expected to handle the full AWS EKS bootstrapping code and signal node readiness to the managing CloudFormation stack. This code must be a complete and executable user data script in bash (Linux) or powershell (Windows).
               
               See for more details: https://docs.aws.amazon.com/eks/latest/userguide/worker.html
        :param pulumi.Input[str] spot_price: Bidding price for spot instance. If set, only spot instances will be added as worker node.
        :param pulumi.Input[Mapping[str, pulumi.Input['TaintArgs']]] taints: Custom k8s node taints to be attached to each worker node. Adds the given taints to the `--register-with-taints` kubelet argument
        :param pulumi.Input[str] version: Desired Kubernetes master / control plane version. If you do not specify a value, the latest available version is used.
        """
        if ami_id is not None:
            pulumi.set(__self__, "ami_id", ami_id)
        if auto_scaling_group_tags is not None:
            pulumi.set(__self__, "auto_scaling_group_tags", auto_scaling_group_tags)
        if bootstrap_extra_args is not None:
            pulumi.set(__self__, "bootstrap_extra_args", bootstrap_extra_args)
        if cloud_formation_tags is not None:
            pulumi.set(__self__, "cloud_formation_tags", cloud_formation_tags)
        if cluster_ingress_rule is not None:
            pulumi.set(__self__, "cluster_ingress_rule", cluster_ingress_rule)
        if desired_capacity is not None:
            pulumi.set(__self__, "desired_capacity", desired_capacity)
        if encrypt_root_block_device is not None:
            pulumi.set(__self__, "encrypt_root_block_device", encrypt_root_block_device)
        if extra_node_security_groups is not None:
            pulumi.set(__self__, "extra_node_security_groups", extra_node_security_groups)
        if gpu is not None:
            pulumi.set(__self__, "gpu", gpu)
        if instance_profile is not None:
            pulumi.set(__self__, "instance_profile", instance_profile)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if key_name is not None:
            pulumi.set(__self__, "key_name", key_name)
        if kubelet_extra_args is not None:
            pulumi.set(__self__, "kubelet_extra_args", kubelet_extra_args)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if max_size is not None:
            pulumi.set(__self__, "max_size", max_size)
        if min_size is not None:
            pulumi.set(__self__, "min_size", min_size)
        if node_associate_public_ip_address is not None:
            pulumi.set(__self__, "node_associate_public_ip_address", node_associate_public_ip_address)
        if node_public_key is not None:
            pulumi.set(__self__, "node_public_key", node_public_key)
        if node_root_volume_size is not None:
            pulumi.set(__self__, "node_root_volume_size", node_root_volume_size)
        if node_security_group is not None:
            pulumi.set(__self__, "node_security_group", node_security_group)
        if node_subnet_ids is not None:
            pulumi.set(__self__, "node_subnet_ids", node_subnet_ids)
        if node_user_data is not None:
            pulumi.set(__self__, "node_user_data", node_user_data)
        if node_user_data_override is not None:
            pulumi.set(__self__, "node_user_data_override", node_user_data_override)
        if spot_price is not None:
            pulumi.set(__self__, "spot_price", spot_price)
        if taints is not None:
            pulumi.set(__self__, "taints", taints)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="amiId")
    def ami_id(self) -> Optional[pulumi.Input[str]]:
        """
        The AMI ID to use for the worker nodes.

        Defaults to the latest recommended EKS Optimized Linux AMI from the AWS Systems Manager Parameter Store.

        Note: `amiId` and `gpu` are mutually exclusive.

        See for more details:
        - https://docs.aws.amazon.com/eks/latest/userguide/eks-optimized-ami.html.
        """
        return pulumi.get(self, "ami_id")

    @ami_id.setter
    def ami_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ami_id", value)

    @property
    @pulumi.getter(name="autoScalingGroupTags")
    def auto_scaling_group_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The tags to apply to the NodeGroup's AutoScalingGroup in the CloudFormation Stack.

        Per AWS, all stack-level tags, including automatically created tags, and the `cloudFormationTags` option are propagated to resources that AWS CloudFormation supports, including the AutoScalingGroup. See https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html

        Note: Given the inheritance of auto-generated CF tags and `cloudFormationTags`, you should either supply the tag in `autoScalingGroupTags` or `cloudFormationTags`, but not both.
        """
        return pulumi.get(self, "auto_scaling_group_tags")

    @auto_scaling_group_tags.setter
    def auto_scaling_group_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "auto_scaling_group_tags", value)

    @property
    @pulumi.getter(name="bootstrapExtraArgs")
    def bootstrap_extra_args(self) -> Optional[pulumi.Input[str]]:
        """
        Additional args to pass directly to `/etc/eks/bootstrap.sh`. Fror details on available options, see: https://github.com/awslabs/amazon-eks-ami/blob/master/files/bootstrap.sh. Note that the `--apiserver-endpoint`, `--b64-cluster-ca` and `--kubelet-extra-args` flags are included automatically based on other configuration parameters.
        """
        return pulumi.get(self, "bootstrap_extra_args")

    @bootstrap_extra_args.setter
    def bootstrap_extra_args(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bootstrap_extra_args", value)

    @property
    @pulumi.getter(name="cloudFormationTags")
    def cloud_formation_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The tags to apply to the CloudFormation Stack of the Worker NodeGroup.

        Note: Given the inheritance of auto-generated CF tags and `cloudFormationTags`, you should either supply the tag in `autoScalingGroupTags` or `cloudFormationTags`, but not both.
        """
        return pulumi.get(self, "cloud_formation_tags")

    @cloud_formation_tags.setter
    def cloud_formation_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "cloud_formation_tags", value)

    @property
    @pulumi.getter(name="clusterIngressRule")
    def cluster_ingress_rule(self) -> Optional[pulumi.Input['pulumi_aws.ec2.SecurityGroupRule']]:
        """
        The ingress rule that gives node group access.
        """
        return pulumi.get(self, "cluster_ingress_rule")

    @cluster_ingress_rule.setter
    def cluster_ingress_rule(self, value: Optional[pulumi.Input['pulumi_aws.ec2.SecurityGroupRule']]):
        pulumi.set(self, "cluster_ingress_rule", value)

    @property
    @pulumi.getter(name="desiredCapacity")
    def desired_capacity(self) -> Optional[pulumi.Input[int]]:
        """
        The number of worker nodes that should be running in the cluster. Defaults to 2.
        """
        return pulumi.get(self, "desired_capacity")

    @desired_capacity.setter
    def desired_capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "desired_capacity", value)

    @property
    @pulumi.getter(name="encryptRootBlockDevice")
    def encrypt_root_block_device(self) -> Optional[pulumi.Input[bool]]:
        """
        Encrypt the root block device of the nodes in the node group.
        """
        return pulumi.get(self, "encrypt_root_block_device")

    @encrypt_root_block_device.setter
    def encrypt_root_block_device(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "encrypt_root_block_device", value)

    @property
    @pulumi.getter(name="extraNodeSecurityGroups")
    def extra_node_security_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ec2.SecurityGroup']]]]:
        """
        Extra security groups to attach on all nodes in this worker node group.

        This additional set of security groups captures any user application rules that will be needed for the nodes.
        """
        return pulumi.get(self, "extra_node_security_groups")

    @extra_node_security_groups.setter
    def extra_node_security_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ec2.SecurityGroup']]]]):
        pulumi.set(self, "extra_node_security_groups", value)

    @property
    @pulumi.getter
    def gpu(self) -> Optional[pulumi.Input[bool]]:
        """
        Use the latest recommended EKS Optimized Linux AMI with GPU support for the worker nodes from the AWS Systems Manager Parameter Store.

        Defaults to false.

        Note: `gpu` and `amiId` are mutually exclusive.

        See for more details:
        - https://docs.aws.amazon.com/eks/latest/userguide/eks-optimized-ami.html
        - https://docs.aws.amazon.com/eks/latest/userguide/retrieve-ami-id.html
        """
        return pulumi.get(self, "gpu")

    @gpu.setter
    def gpu(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "gpu", value)

    @property
    @pulumi.getter(name="instanceProfile")
    def instance_profile(self) -> Optional[pulumi.Input['pulumi_aws.iam.InstanceProfile']]:
        """
        The ingress rule that gives node group access.
        """
        return pulumi.get(self, "instance_profile")

    @instance_profile.setter
    def instance_profile(self, value: Optional[pulumi.Input['pulumi_aws.iam.InstanceProfile']]):
        pulumi.set(self, "instance_profile", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        The instance type to use for the cluster's nodes. Defaults to "t2.medium".
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the key pair to use for SSH access to worker nodes.
        """
        return pulumi.get(self, "key_name")

    @key_name.setter
    def key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_name", value)

    @property
    @pulumi.getter(name="kubeletExtraArgs")
    def kubelet_extra_args(self) -> Optional[pulumi.Input[str]]:
        """
        Extra args to pass to the Kubelet. Corresponds to the options passed in the `--kubeletExtraArgs` flag to `/etc/eks/bootstrap.sh`. For example, '--port=10251 --address=0.0.0.0'. Note that the `labels` and `taints` properties will be applied to this list (using `--node-labels` and `--register-with-taints` respectively) after to the expicit `kubeletExtraArgs`.
        """
        return pulumi.get(self, "kubelet_extra_args")

    @kubelet_extra_args.setter
    def kubelet_extra_args(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kubelet_extra_args", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Custom k8s node labels to be attached to each woker node. Adds the given key/value pairs to the `--node-labels` kubelet argument.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of worker nodes running in the cluster. Defaults to 2.
        """
        return pulumi.get(self, "max_size")

    @max_size.setter
    def max_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_size", value)

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum number of worker nodes running in the cluster. Defaults to 1.
        """
        return pulumi.get(self, "min_size")

    @min_size.setter
    def min_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_size", value)

    @property
    @pulumi.getter(name="nodeAssociatePublicIpAddress")
    def node_associate_public_ip_address(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to auto-assign public IP addresses on the EKS worker nodes. If this toggle is set to true, the EKS workers will be auto-assigned public IPs. If false, they will not be auto-assigned public IPs.
        """
        return pulumi.get(self, "node_associate_public_ip_address")

    @node_associate_public_ip_address.setter
    def node_associate_public_ip_address(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "node_associate_public_ip_address", value)

    @property
    @pulumi.getter(name="nodePublicKey")
    def node_public_key(self) -> Optional[pulumi.Input[str]]:
        """
        Public key material for SSH access to worker nodes. See allowed formats at:
        https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html
        If not provided, no SSH access is enabled on VMs.
        """
        return pulumi.get(self, "node_public_key")

    @node_public_key.setter
    def node_public_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_public_key", value)

    @property
    @pulumi.getter(name="nodeRootVolumeSize")
    def node_root_volume_size(self) -> Optional[pulumi.Input[int]]:
        """
        The size in GiB of a cluster node's root volume. Defaults to 20.
        """
        return pulumi.get(self, "node_root_volume_size")

    @node_root_volume_size.setter
    def node_root_volume_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "node_root_volume_size", value)

    @property
    @pulumi.getter(name="nodeSecurityGroup")
    def node_security_group(self) -> Optional[pulumi.Input['pulumi_aws.ec2.SecurityGroup']]:
        """
        The security group for the worker node group to communicate with the cluster.

        This security group requires specific inbound and outbound rules.

        See for more details:
        https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html

        Note: The `nodeSecurityGroup` option and the cluster option`nodeSecurityGroupTags` are mutually exclusive.
        """
        return pulumi.get(self, "node_security_group")

    @node_security_group.setter
    def node_security_group(self, value: Optional[pulumi.Input['pulumi_aws.ec2.SecurityGroup']]):
        pulumi.set(self, "node_security_group", value)

    @property
    @pulumi.getter(name="nodeSubnetIds")
    def node_subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The set of subnets to override and use for the worker node group.

        Setting this option overrides which subnets to use for the worker node group, regardless if the cluster's `subnetIds` is set, or if `publicSubnetIds` and/or `privateSubnetIds` were set.
        """
        return pulumi.get(self, "node_subnet_ids")

    @node_subnet_ids.setter
    def node_subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "node_subnet_ids", value)

    @property
    @pulumi.getter(name="nodeUserData")
    def node_user_data(self) -> Optional[pulumi.Input[str]]:
        """
        Extra code to run on node startup. This code will run after the AWS EKS bootstrapping code and before the node signals its readiness to the managing CloudFormation stack. This code must be a typical user data script: critically it must begin with an interpreter directive (i.e. a `#!`).
        """
        return pulumi.get(self, "node_user_data")

    @node_user_data.setter
    def node_user_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_user_data", value)

    @property
    @pulumi.getter(name="nodeUserDataOverride")
    def node_user_data_override(self) -> Optional[pulumi.Input[str]]:
        """
        User specified code to run on node startup. This code is expected to handle the full AWS EKS bootstrapping code and signal node readiness to the managing CloudFormation stack. This code must be a complete and executable user data script in bash (Linux) or powershell (Windows).

        See for more details: https://docs.aws.amazon.com/eks/latest/userguide/worker.html
        """
        return pulumi.get(self, "node_user_data_override")

    @node_user_data_override.setter
    def node_user_data_override(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_user_data_override", value)

    @property
    @pulumi.getter(name="spotPrice")
    def spot_price(self) -> Optional[pulumi.Input[str]]:
        """
        Bidding price for spot instance. If set, only spot instances will be added as worker node.
        """
        return pulumi.get(self, "spot_price")

    @spot_price.setter
    def spot_price(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "spot_price", value)

    @property
    @pulumi.getter
    def taints(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['TaintArgs']]]]:
        """
        Custom k8s node taints to be attached to each worker node. Adds the given taints to the `--register-with-taints` kubelet argument
        """
        return pulumi.get(self, "taints")

    @taints.setter
    def taints(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['TaintArgs']]]]):
        pulumi.set(self, "taints", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Desired Kubernetes master / control plane version. If you do not specify a value, the latest available version is used.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class CoreDataArgs:
    def __init__(__self__, *,
                 cluster: pulumi.Input['pulumi_aws.eks.Cluster'],
                 cluster_security_group: pulumi.Input['pulumi_aws.ec2.SecurityGroup'],
                 endpoint: pulumi.Input[str],
                 instance_roles: pulumi.Input[Sequence[pulumi.Input['pulumi_aws.iam.Role']]],
                 node_group_options: pulumi.Input['ClusterNodeGroupOptionsArgs'],
                 provider: pulumi.Input['pulumi_kubernetes.Provider'],
                 subnet_ids: pulumi.Input[Sequence[pulumi.Input[str]]],
                 vpc_id: pulumi.Input[str],
                 aws_provider: Optional[pulumi.Input['pulumi_aws.Provider']] = None,
                 eks_node_access: Optional[pulumi.Input['pulumi_kubernetes.core.v1.ConfigMap']] = None,
                 encryption_config: Optional[pulumi.Input['pulumi_aws.eks.ClusterEncryptionConfigArgs']] = None,
                 fargate_profile: Optional[pulumi.Input['pulumi_aws.eks.FargateProfile']] = None,
                 kubeconfig: Optional[Any] = None,
                 node_security_group_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 oidc_provider: Optional[pulumi.Input['pulumi_aws.iam.OpenIdConnectProvider']] = None,
                 private_subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 public_subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 storage_classes: Optional[pulumi.Input[Mapping[str, pulumi.Input['pulumi_kubernetes.storage.v1.StorageClass']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 vpc_cni: Optional[pulumi.Input['VpcCni']] = None):
        """
        Defines the core set of data associated with an EKS cluster, including the network in which it runs.
        """
        pulumi.set(__self__, "cluster", cluster)
        pulumi.set(__self__, "cluster_security_group", cluster_security_group)
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "instance_roles", instance_roles)
        pulumi.set(__self__, "node_group_options", node_group_options)
        pulumi.set(__self__, "provider", provider)
        pulumi.set(__self__, "subnet_ids", subnet_ids)
        pulumi.set(__self__, "vpc_id", vpc_id)
        if aws_provider is not None:
            pulumi.set(__self__, "aws_provider", aws_provider)
        if eks_node_access is not None:
            pulumi.set(__self__, "eks_node_access", eks_node_access)
        if encryption_config is not None:
            pulumi.set(__self__, "encryption_config", encryption_config)
        if fargate_profile is not None:
            pulumi.set(__self__, "fargate_profile", fargate_profile)
        if kubeconfig is not None:
            pulumi.set(__self__, "kubeconfig", kubeconfig)
        if node_security_group_tags is not None:
            pulumi.set(__self__, "node_security_group_tags", node_security_group_tags)
        if oidc_provider is not None:
            pulumi.set(__self__, "oidc_provider", oidc_provider)
        if private_subnet_ids is not None:
            pulumi.set(__self__, "private_subnet_ids", private_subnet_ids)
        if public_subnet_ids is not None:
            pulumi.set(__self__, "public_subnet_ids", public_subnet_ids)
        if storage_classes is not None:
            pulumi.set(__self__, "storage_classes", storage_classes)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc_cni is not None:
            pulumi.set(__self__, "vpc_cni", vpc_cni)

    @property
    @pulumi.getter
    def cluster(self) -> pulumi.Input['pulumi_aws.eks.Cluster']:
        return pulumi.get(self, "cluster")

    @cluster.setter
    def cluster(self, value: pulumi.Input['pulumi_aws.eks.Cluster']):
        pulumi.set(self, "cluster", value)

    @property
    @pulumi.getter(name="clusterSecurityGroup")
    def cluster_security_group(self) -> pulumi.Input['pulumi_aws.ec2.SecurityGroup']:
        return pulumi.get(self, "cluster_security_group")

    @cluster_security_group.setter
    def cluster_security_group(self, value: pulumi.Input['pulumi_aws.ec2.SecurityGroup']):
        pulumi.set(self, "cluster_security_group", value)

    @property
    @pulumi.getter
    def endpoint(self) -> pulumi.Input[str]:
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: pulumi.Input[str]):
        pulumi.set(self, "endpoint", value)

    @property
    @pulumi.getter(name="instanceRoles")
    def instance_roles(self) -> pulumi.Input[Sequence[pulumi.Input['pulumi_aws.iam.Role']]]:
        return pulumi.get(self, "instance_roles")

    @instance_roles.setter
    def instance_roles(self, value: pulumi.Input[Sequence[pulumi.Input['pulumi_aws.iam.Role']]]):
        pulumi.set(self, "instance_roles", value)

    @property
    @pulumi.getter(name="nodeGroupOptions")
    def node_group_options(self) -> pulumi.Input['ClusterNodeGroupOptionsArgs']:
        return pulumi.get(self, "node_group_options")

    @node_group_options.setter
    def node_group_options(self, value: pulumi.Input['ClusterNodeGroupOptionsArgs']):
        pulumi.set(self, "node_group_options", value)

    @property
    @pulumi.getter
    def provider(self) -> pulumi.Input['pulumi_kubernetes.Provider']:
        return pulumi.get(self, "provider")

    @provider.setter
    def provider(self, value: pulumi.Input['pulumi_kubernetes.Provider']):
        pulumi.set(self, "provider", value)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "subnet_ids", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="awsProvider")
    def aws_provider(self) -> Optional[pulumi.Input['pulumi_aws.Provider']]:
        return pulumi.get(self, "aws_provider")

    @aws_provider.setter
    def aws_provider(self, value: Optional[pulumi.Input['pulumi_aws.Provider']]):
        pulumi.set(self, "aws_provider", value)

    @property
    @pulumi.getter(name="eksNodeAccess")
    def eks_node_access(self) -> Optional[pulumi.Input['pulumi_kubernetes.core.v1.ConfigMap']]:
        return pulumi.get(self, "eks_node_access")

    @eks_node_access.setter
    def eks_node_access(self, value: Optional[pulumi.Input['pulumi_kubernetes.core.v1.ConfigMap']]):
        pulumi.set(self, "eks_node_access", value)

    @property
    @pulumi.getter(name="encryptionConfig")
    def encryption_config(self) -> Optional[pulumi.Input['pulumi_aws.eks.ClusterEncryptionConfigArgs']]:
        return pulumi.get(self, "encryption_config")

    @encryption_config.setter
    def encryption_config(self, value: Optional[pulumi.Input['pulumi_aws.eks.ClusterEncryptionConfigArgs']]):
        pulumi.set(self, "encryption_config", value)

    @property
    @pulumi.getter(name="fargateProfile")
    def fargate_profile(self) -> Optional[pulumi.Input['pulumi_aws.eks.FargateProfile']]:
        return pulumi.get(self, "fargate_profile")

    @fargate_profile.setter
    def fargate_profile(self, value: Optional[pulumi.Input['pulumi_aws.eks.FargateProfile']]):
        pulumi.set(self, "fargate_profile", value)

    @property
    @pulumi.getter
    def kubeconfig(self) -> Optional[Any]:
        return pulumi.get(self, "kubeconfig")

    @kubeconfig.setter
    def kubeconfig(self, value: Optional[Any]):
        pulumi.set(self, "kubeconfig", value)

    @property
    @pulumi.getter(name="nodeSecurityGroupTags")
    def node_security_group_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "node_security_group_tags")

    @node_security_group_tags.setter
    def node_security_group_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "node_security_group_tags", value)

    @property
    @pulumi.getter(name="oidcProvider")
    def oidc_provider(self) -> Optional[pulumi.Input['pulumi_aws.iam.OpenIdConnectProvider']]:
        return pulumi.get(self, "oidc_provider")

    @oidc_provider.setter
    def oidc_provider(self, value: Optional[pulumi.Input['pulumi_aws.iam.OpenIdConnectProvider']]):
        pulumi.set(self, "oidc_provider", value)

    @property
    @pulumi.getter(name="privateSubnetIds")
    def private_subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "private_subnet_ids")

    @private_subnet_ids.setter
    def private_subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "private_subnet_ids", value)

    @property
    @pulumi.getter(name="publicSubnetIds")
    def public_subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "public_subnet_ids")

    @public_subnet_ids.setter
    def public_subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "public_subnet_ids", value)

    @property
    @pulumi.getter(name="storageClasses")
    def storage_classes(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['pulumi_kubernetes.storage.v1.StorageClass']]]]:
        return pulumi.get(self, "storage_classes")

    @storage_classes.setter
    def storage_classes(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['pulumi_kubernetes.storage.v1.StorageClass']]]]):
        pulumi.set(self, "storage_classes", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="vpcCni")
    def vpc_cni(self) -> Optional[pulumi.Input['VpcCni']]:
        return pulumi.get(self, "vpc_cni")

    @vpc_cni.setter
    def vpc_cni(self, value: Optional[pulumi.Input['VpcCni']]):
        pulumi.set(self, "vpc_cni", value)


@pulumi.input_type
class CreationRoleProviderArgs:
    def __init__(__self__, *,
                 provider: pulumi.Input['pulumi_aws.Provider'],
                 role: pulumi.Input['pulumi_aws.iam.Role']):
        """
        Contains the AWS Role and Provider necessary to override the `[system:master]` entity ARN. This is an optional argument used when creating `Cluster`. Read more: https://docs.aws.amazon.com/eks/latest/userguide/add-user-role.html
        """
        pulumi.set(__self__, "provider", provider)
        pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def provider(self) -> pulumi.Input['pulumi_aws.Provider']:
        return pulumi.get(self, "provider")

    @provider.setter
    def provider(self, value: pulumi.Input['pulumi_aws.Provider']):
        pulumi.set(self, "provider", value)

    @property
    @pulumi.getter
    def role(self) -> pulumi.Input['pulumi_aws.iam.Role']:
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: pulumi.Input['pulumi_aws.iam.Role']):
        pulumi.set(self, "role", value)


@pulumi.input_type
class FargateProfileArgs:
    def __init__(__self__, *,
                 pod_execution_role_arn: Optional[pulumi.Input[str]] = None,
                 selectors: Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.eks.FargateProfileSelectorArgs']]]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Defines how Kubernetes pods are executed in Fargate. See aws.eks.FargateProfileArgs for reference.
        :param pulumi.Input[str] pod_execution_role_arn: Specify a custom role to use for executing pods in Fargate. Defaults to creating a new role with the `arn:aws:iam::aws:policy/AmazonEKSFargatePodExecutionRolePolicy` policy attached.
        :param pulumi.Input[Sequence[pulumi.Input['pulumi_aws.eks.FargateProfileSelectorArgs']]] selectors: Specify the namespace and label selectors to use for launching pods into Fargate.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnet_ids: Specify the subnets in which to execute Fargate tasks for pods. Defaults to the private subnets associated with the cluster.
        """
        if pod_execution_role_arn is not None:
            pulumi.set(__self__, "pod_execution_role_arn", pod_execution_role_arn)
        if selectors is not None:
            pulumi.set(__self__, "selectors", selectors)
        if subnet_ids is not None:
            pulumi.set(__self__, "subnet_ids", subnet_ids)

    @property
    @pulumi.getter(name="podExecutionRoleArn")
    def pod_execution_role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        Specify a custom role to use for executing pods in Fargate. Defaults to creating a new role with the `arn:aws:iam::aws:policy/AmazonEKSFargatePodExecutionRolePolicy` policy attached.
        """
        return pulumi.get(self, "pod_execution_role_arn")

    @pod_execution_role_arn.setter
    def pod_execution_role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pod_execution_role_arn", value)

    @property
    @pulumi.getter
    def selectors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.eks.FargateProfileSelectorArgs']]]]:
        """
        Specify the namespace and label selectors to use for launching pods into Fargate.
        """
        return pulumi.get(self, "selectors")

    @selectors.setter
    def selectors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.eks.FargateProfileSelectorArgs']]]]):
        pulumi.set(self, "selectors", value)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specify the subnets in which to execute Fargate tasks for pods. Defaults to the private subnets associated with the cluster.
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "subnet_ids", value)


@pulumi.input_type
class KubeconfigOptionsArgs:
    def __init__(__self__, *,
                 profile_name: Optional[pulumi.Input[str]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None):
        """
        Represents the AWS credentials to scope a given kubeconfig when using a non-default credential chain.

        The options can be used independently, or additively.

        A scoped kubeconfig is necessary for certain auth scenarios. For example:
          1. Assume a role on the default account caller,
          2. Use an AWS creds profile instead of the default account caller,
          3. Use an AWS creds creds profile instead of the default account caller,
             and then assume a given role on the profile. This scenario is also
             possible by only using a profile, iff the profile includes a role to
             assume in its settings.

        See for more details:
        - https://docs.aws.amazon.com/eks/latest/userguide/create-kubeconfig.html
        - https://docs.aws.amazon.com/cli/latest/userguide/cli-configure-role.html
        - https://docs.aws.amazon.com/cli/latest/userguide/cli-configure-profiles.html
        :param pulumi.Input[str] profile_name: AWS credential profile name to always use instead of the default AWS credential provider chain.
               
               The profile is passed to kubeconfig as an authentication environment setting.
        :param pulumi.Input[str] role_arn: Role ARN to assume instead of the default AWS credential provider chain.
               
               The role is passed to kubeconfig as an authentication exec argument.
        """
        if profile_name is not None:
            pulumi.set(__self__, "profile_name", profile_name)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)

    @property
    @pulumi.getter(name="profileName")
    def profile_name(self) -> Optional[pulumi.Input[str]]:
        """
        AWS credential profile name to always use instead of the default AWS credential provider chain.

        The profile is passed to kubeconfig as an authentication environment setting.
        """
        return pulumi.get(self, "profile_name")

    @profile_name.setter
    def profile_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "profile_name", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        Role ARN to assume instead of the default AWS credential provider chain.

        The role is passed to kubeconfig as an authentication exec argument.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role_arn", value)


@pulumi.input_type
class RoleMappingArgs:
    def __init__(__self__, *,
                 groups: pulumi.Input[Sequence[pulumi.Input[str]]],
                 role_arn: pulumi.Input[str],
                 username: pulumi.Input[str]):
        """
        Describes a mapping from an AWS IAM role to a Kubernetes user and groups.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] groups: A list of groups within Kubernetes to which the role is mapped.
        :param pulumi.Input[str] role_arn: The ARN of the IAM role to add.
        :param pulumi.Input[str] username: The user name within Kubernetes to map to the IAM role. By default, the user name is the ARN of the IAM role.
        """
        pulumi.set(__self__, "groups", groups)
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def groups(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        A list of groups within Kubernetes to which the role is mapped.
        """
        return pulumi.get(self, "groups")

    @groups.setter
    def groups(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "groups", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the IAM role to add.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[str]:
        """
        The user name within Kubernetes to map to the IAM role. By default, the user name is the ARN of the IAM role.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[str]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class StorageClassArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 allow_volume_expansion: Optional[pulumi.Input[bool]] = None,
                 default: Optional[pulumi.Input[bool]] = None,
                 encrypted: Optional[pulumi.Input[bool]] = None,
                 iops_per_gb: Optional[pulumi.Input[int]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input['pulumi_kubernetes.meta.v1.ObjectMetaArgs']] = None,
                 mount_options: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 reclaim_policy: Optional[pulumi.Input[str]] = None,
                 volume_binding_mode: Optional[pulumi.Input[str]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        StorageClass describes the inputs to a single Kubernetes StorageClass provisioned by AWS. Any number of storage classes can be added to a cluster at creation time. One of these storage classes may be configured the default storage class for the cluster.
        :param pulumi.Input[str] type: The EBS volume type.
        :param pulumi.Input[bool] allow_volume_expansion: AllowVolumeExpansion shows whether the storage class allow volume expand.
        :param pulumi.Input[bool] default: True if this storage class should be a default storage class for the cluster.
               
               Note: As of Kubernetes v1.11+ on EKS, a default `gp2` storage class will always be created automatically for the cluster by the EKS service. See https://docs.aws.amazon.com/eks/latest/userguide/storage-classes.html
               
               Please note that at most one storage class can be marked as default. If two or more of them are marked as default, a PersistentVolumeClaim without `storageClassName` explicitly specified cannot be created. See: https://kubernetes.io/docs/tasks/administer-cluster/change-default-storage-class/#changing-the-default-storageclass
        :param pulumi.Input[bool] encrypted: Denotes whether the EBS volume should be encrypted.
        :param pulumi.Input[int] iops_per_gb: I/O operations per second per GiB for "io1" volumes. The AWS volume plugin multiplies this with the size of a requested volume to compute IOPS of the volume and caps the result at 20,000 IOPS.
        :param pulumi.Input[str] kms_key_id: The full Amazon Resource Name of the key to use when encrypting the volume. If none is supplied but encrypted is true, a key is generated by AWS.
        :param pulumi.Input['pulumi_kubernetes.meta.v1.ObjectMetaArgs'] metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
        :param pulumi.Input[Sequence[pulumi.Input[str]]] mount_options: Dynamically provisioned PersistentVolumes of this storage class are created with these mountOptions, e.g. ["ro", "soft"]. Not validated - mount of the PVs will simply fail if one is invalid.
        :param pulumi.Input[str] reclaim_policy: Dynamically provisioned PersistentVolumes of this storage class are created with this reclaimPolicy. Defaults to Delete.
        :param pulumi.Input[str] volume_binding_mode: VolumeBindingMode indicates how PersistentVolumeClaims should be provisioned and bound. When unset, VolumeBindingImmediate is used. This field is alpha-level and is only honored by servers that enable the VolumeScheduling feature.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] zones: The AWS zone or zones for the EBS volume. If zones is not specified, volumes are generally round-robin-ed across all active zones where Kubernetes cluster has a node. zone and zones parameters must not be used at the same time.
        """
        pulumi.set(__self__, "type", type)
        if allow_volume_expansion is not None:
            pulumi.set(__self__, "allow_volume_expansion", allow_volume_expansion)
        if default is not None:
            pulumi.set(__self__, "default", default)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if iops_per_gb is not None:
            pulumi.set(__self__, "iops_per_gb", iops_per_gb)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if mount_options is not None:
            pulumi.set(__self__, "mount_options", mount_options)
        if reclaim_policy is not None:
            pulumi.set(__self__, "reclaim_policy", reclaim_policy)
        if volume_binding_mode is not None:
            pulumi.set(__self__, "volume_binding_mode", volume_binding_mode)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The EBS volume type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="allowVolumeExpansion")
    def allow_volume_expansion(self) -> Optional[pulumi.Input[bool]]:
        """
        AllowVolumeExpansion shows whether the storage class allow volume expand.
        """
        return pulumi.get(self, "allow_volume_expansion")

    @allow_volume_expansion.setter
    def allow_volume_expansion(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_volume_expansion", value)

    @property
    @pulumi.getter
    def default(self) -> Optional[pulumi.Input[bool]]:
        """
        True if this storage class should be a default storage class for the cluster.

        Note: As of Kubernetes v1.11+ on EKS, a default `gp2` storage class will always be created automatically for the cluster by the EKS service. See https://docs.aws.amazon.com/eks/latest/userguide/storage-classes.html

        Please note that at most one storage class can be marked as default. If two or more of them are marked as default, a PersistentVolumeClaim without `storageClassName` explicitly specified cannot be created. See: https://kubernetes.io/docs/tasks/administer-cluster/change-default-storage-class/#changing-the-default-storageclass
        """
        return pulumi.get(self, "default")

    @default.setter
    def default(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "default", value)

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[pulumi.Input[bool]]:
        """
        Denotes whether the EBS volume should be encrypted.
        """
        return pulumi.get(self, "encrypted")

    @encrypted.setter
    def encrypted(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "encrypted", value)

    @property
    @pulumi.getter(name="iopsPerGb")
    def iops_per_gb(self) -> Optional[pulumi.Input[int]]:
        """
        I/O operations per second per GiB for "io1" volumes. The AWS volume plugin multiplies this with the size of a requested volume to compute IOPS of the volume and caps the result at 20,000 IOPS.
        """
        return pulumi.get(self, "iops_per_gb")

    @iops_per_gb.setter
    def iops_per_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "iops_per_gb", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The full Amazon Resource Name of the key to use when encrypting the volume. If none is supplied but encrypted is true, a key is generated by AWS.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['pulumi_kubernetes.meta.v1.ObjectMetaArgs']]:
        """
        Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['pulumi_kubernetes.meta.v1.ObjectMetaArgs']]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter(name="mountOptions")
    def mount_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Dynamically provisioned PersistentVolumes of this storage class are created with these mountOptions, e.g. ["ro", "soft"]. Not validated - mount of the PVs will simply fail if one is invalid.
        """
        return pulumi.get(self, "mount_options")

    @mount_options.setter
    def mount_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "mount_options", value)

    @property
    @pulumi.getter(name="reclaimPolicy")
    def reclaim_policy(self) -> Optional[pulumi.Input[str]]:
        """
        Dynamically provisioned PersistentVolumes of this storage class are created with this reclaimPolicy. Defaults to Delete.
        """
        return pulumi.get(self, "reclaim_policy")

    @reclaim_policy.setter
    def reclaim_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reclaim_policy", value)

    @property
    @pulumi.getter(name="volumeBindingMode")
    def volume_binding_mode(self) -> Optional[pulumi.Input[str]]:
        """
        VolumeBindingMode indicates how PersistentVolumeClaims should be provisioned and bound. When unset, VolumeBindingImmediate is used. This field is alpha-level and is only honored by servers that enable the VolumeScheduling feature.
        """
        return pulumi.get(self, "volume_binding_mode")

    @volume_binding_mode.setter
    def volume_binding_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "volume_binding_mode", value)

    @property
    @pulumi.getter
    def zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The AWS zone or zones for the EBS volume. If zones is not specified, volumes are generally round-robin-ed across all active zones where Kubernetes cluster has a node. zone and zones parameters must not be used at the same time.
        """
        return pulumi.get(self, "zones")

    @zones.setter
    def zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "zones", value)


@pulumi.input_type
class TaintArgs:
    def __init__(__self__, *,
                 effect: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        Represents a Kubernetes `taint` to apply to all Nodes in a NodeGroup. See https://kubernetes.io/docs/concepts/configuration/taint-and-toleration/.
        :param pulumi.Input[str] effect: The effect of the taint.
        :param pulumi.Input[str] value: The value of the taint.
        """
        pulumi.set(__self__, "effect", effect)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def effect(self) -> pulumi.Input[str]:
        """
        The effect of the taint.
        """
        return pulumi.get(self, "effect")

    @effect.setter
    def effect(self, value: pulumi.Input[str]):
        pulumi.set(self, "effect", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The value of the taint.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class UserMappingArgs:
    def __init__(__self__, *,
                 groups: pulumi.Input[Sequence[pulumi.Input[str]]],
                 user_arn: pulumi.Input[str],
                 username: pulumi.Input[str]):
        """
        Describes a mapping from an AWS IAM user to a Kubernetes user and groups.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] groups: A list of groups within Kubernetes to which the user is mapped to.
        :param pulumi.Input[str] user_arn: The ARN of the IAM user to add.
        :param pulumi.Input[str] username: The user name within Kubernetes to map to the IAM user. By default, the user name is the ARN of the IAM user.
        """
        pulumi.set(__self__, "groups", groups)
        pulumi.set(__self__, "user_arn", user_arn)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def groups(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        A list of groups within Kubernetes to which the user is mapped to.
        """
        return pulumi.get(self, "groups")

    @groups.setter
    def groups(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "groups", value)

    @property
    @pulumi.getter(name="userArn")
    def user_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the IAM user to add.
        """
        return pulumi.get(self, "user_arn")

    @user_arn.setter
    def user_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "user_arn", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[str]:
        """
        The user name within Kubernetes to map to the IAM user. By default, the user name is the ARN of the IAM user.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[str]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class VpcCniOptionsArgs:
    def __init__(__self__, *,
                 custom_network_config: Optional[pulumi.Input[bool]] = None,
                 eni_config_label_def: Optional[pulumi.Input[str]] = None,
                 eni_mtu: Optional[pulumi.Input[int]] = None,
                 external_snat: Optional[pulumi.Input[bool]] = None,
                 image: Optional[pulumi.Input[str]] = None,
                 log_file: Optional[pulumi.Input[str]] = None,
                 log_level: Optional[pulumi.Input[str]] = None,
                 node_port_support: Optional[pulumi.Input[bool]] = None,
                 veth_prefix: Optional[pulumi.Input[str]] = None,
                 warm_eni_target: Optional[pulumi.Input[int]] = None,
                 warm_ip_target: Optional[pulumi.Input[int]] = None):
        """
        Describes the configuration options available for the Amazon VPC CNI plugin for Kubernetes.
        :param pulumi.Input[bool] custom_network_config: Specifies that your pods may use subnets and security groups (within the same VPC as your control plane resources) that are independent of your cluster's `resourcesVpcConfig`.
               
               Defaults to false.
        :param pulumi.Input[str] eni_config_label_def: Specifies the ENI_CONFIG_LABEL_DEF environment variable value for worker nodes. This is used to tell Kubernetes to automatically apply the ENIConfig for each Availability Zone
               Ref: https://docs.aws.amazon.com/eks/latest/userguide/cni-custom-network.html (step 5(c))
               
               Defaults to the official AWS CNI image in ECR.
        :param pulumi.Input[int] eni_mtu: Used to configure the MTU size for attached ENIs. The valid range is from 576 to 9001.
               
               Defaults to 9001.
        :param pulumi.Input[bool] external_snat: Specifies whether an external NAT gateway should be used to provide SNAT of secondary ENI IP addresses. If set to true, the SNAT iptables rule and off-VPC IP rule are not applied, and these rules are removed if they have already been applied.
               
               Defaults to false.
        :param pulumi.Input[str] image: Specifies the container image to use in the AWS CNI cluster DaemonSet.
               
               Defaults to the official AWS CNI image in ECR.
        :param pulumi.Input[str] log_file: Specifies the file path used for logs.
               
               Defaults to "stdout" to emit Pod logs for `kubectl logs`.
        :param pulumi.Input[str] log_level: Specifies the log level used for logs.
               
               Defaults to "DEBUG"
               Valid values: "DEBUG", "INFO", "WARN", "ERROR", or "FATAL".
        :param pulumi.Input[bool] node_port_support: Specifies whether NodePort services are enabled on a worker node's primary network interface. This requires additional iptables rules and that the kernel's reverse path filter on the primary interface is set to loose.
               
               Defaults to true.
        :param pulumi.Input[str] veth_prefix: Specifies the veth prefix used to generate the host-side veth device name for the CNI.
               
               The prefix can be at most 4 characters long.
               
               Defaults to "eni".
        :param pulumi.Input[int] warm_eni_target: Specifies the number of free elastic network interfaces (and all of their available IP addresses) that the ipamD daemon should attempt to keep available for pod assignment on the node.
               
               Defaults to 1.
        :param pulumi.Input[int] warm_ip_target: Specifies the number of free IP addresses that the ipamD daemon should attempt to keep available for pod assignment on the node.
        """
        if custom_network_config is not None:
            pulumi.set(__self__, "custom_network_config", custom_network_config)
        if eni_config_label_def is not None:
            pulumi.set(__self__, "eni_config_label_def", eni_config_label_def)
        if eni_mtu is not None:
            pulumi.set(__self__, "eni_mtu", eni_mtu)
        if external_snat is not None:
            pulumi.set(__self__, "external_snat", external_snat)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if log_file is not None:
            pulumi.set(__self__, "log_file", log_file)
        if log_level is not None:
            pulumi.set(__self__, "log_level", log_level)
        if node_port_support is not None:
            pulumi.set(__self__, "node_port_support", node_port_support)
        if veth_prefix is not None:
            pulumi.set(__self__, "veth_prefix", veth_prefix)
        if warm_eni_target is not None:
            pulumi.set(__self__, "warm_eni_target", warm_eni_target)
        if warm_ip_target is not None:
            pulumi.set(__self__, "warm_ip_target", warm_ip_target)

    @property
    @pulumi.getter(name="customNetworkConfig")
    def custom_network_config(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies that your pods may use subnets and security groups (within the same VPC as your control plane resources) that are independent of your cluster's `resourcesVpcConfig`.

        Defaults to false.
        """
        return pulumi.get(self, "custom_network_config")

    @custom_network_config.setter
    def custom_network_config(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "custom_network_config", value)

    @property
    @pulumi.getter(name="eniConfigLabelDef")
    def eni_config_label_def(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ENI_CONFIG_LABEL_DEF environment variable value for worker nodes. This is used to tell Kubernetes to automatically apply the ENIConfig for each Availability Zone
        Ref: https://docs.aws.amazon.com/eks/latest/userguide/cni-custom-network.html (step 5(c))

        Defaults to the official AWS CNI image in ECR.
        """
        return pulumi.get(self, "eni_config_label_def")

    @eni_config_label_def.setter
    def eni_config_label_def(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "eni_config_label_def", value)

    @property
    @pulumi.getter(name="eniMtu")
    def eni_mtu(self) -> Optional[pulumi.Input[int]]:
        """
        Used to configure the MTU size for attached ENIs. The valid range is from 576 to 9001.

        Defaults to 9001.
        """
        return pulumi.get(self, "eni_mtu")

    @eni_mtu.setter
    def eni_mtu(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "eni_mtu", value)

    @property
    @pulumi.getter(name="externalSnat")
    def external_snat(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether an external NAT gateway should be used to provide SNAT of secondary ENI IP addresses. If set to true, the SNAT iptables rule and off-VPC IP rule are not applied, and these rules are removed if they have already been applied.

        Defaults to false.
        """
        return pulumi.get(self, "external_snat")

    @external_snat.setter
    def external_snat(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "external_snat", value)

    @property
    @pulumi.getter
    def image(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the container image to use in the AWS CNI cluster DaemonSet.

        Defaults to the official AWS CNI image in ECR.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter(name="logFile")
    def log_file(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the file path used for logs.

        Defaults to "stdout" to emit Pod logs for `kubectl logs`.
        """
        return pulumi.get(self, "log_file")

    @log_file.setter
    def log_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_file", value)

    @property
    @pulumi.getter(name="logLevel")
    def log_level(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the log level used for logs.

        Defaults to "DEBUG"
        Valid values: "DEBUG", "INFO", "WARN", "ERROR", or "FATAL".
        """
        return pulumi.get(self, "log_level")

    @log_level.setter
    def log_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_level", value)

    @property
    @pulumi.getter(name="nodePortSupport")
    def node_port_support(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether NodePort services are enabled on a worker node's primary network interface. This requires additional iptables rules and that the kernel's reverse path filter on the primary interface is set to loose.

        Defaults to true.
        """
        return pulumi.get(self, "node_port_support")

    @node_port_support.setter
    def node_port_support(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "node_port_support", value)

    @property
    @pulumi.getter(name="vethPrefix")
    def veth_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the veth prefix used to generate the host-side veth device name for the CNI.

        The prefix can be at most 4 characters long.

        Defaults to "eni".
        """
        return pulumi.get(self, "veth_prefix")

    @veth_prefix.setter
    def veth_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "veth_prefix", value)

    @property
    @pulumi.getter(name="warmEniTarget")
    def warm_eni_target(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the number of free elastic network interfaces (and all of their available IP addresses) that the ipamD daemon should attempt to keep available for pod assignment on the node.

        Defaults to 1.
        """
        return pulumi.get(self, "warm_eni_target")

    @warm_eni_target.setter
    def warm_eni_target(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "warm_eni_target", value)

    @property
    @pulumi.getter(name="warmIpTarget")
    def warm_ip_target(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the number of free IP addresses that the ipamD daemon should attempt to keep available for pod assignment on the node.
        """
        return pulumi.get(self, "warm_ip_target")

    @warm_ip_target.setter
    def warm_ip_target(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "warm_ip_target", value)


