"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Ds = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [ds](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsdirectoryservice.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Ds extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [ds](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsdirectoryservice.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'ds';
        this.accessLevelList = {
            Write: [
                'AcceptSharedDirectory',
                'AddIpRoutes',
                'AddRegion',
                'AuthorizeApplication',
                'CancelSchemaExtension',
                'ConnectDirectory',
                'CreateAlias',
                'CreateComputer',
                'CreateConditionalForwarder',
                'CreateDirectory',
                'CreateIdentityPoolDirectory',
                'CreateLogSubscription',
                'CreateMicrosoftAD',
                'CreateSnapshot',
                'CreateTrust',
                'DeleteConditionalForwarder',
                'DeleteDirectory',
                'DeleteLogSubscription',
                'DeleteSnapshot',
                'DeleteTrust',
                'DeregisterCertificate',
                'DeregisterEventTopic',
                'DisableClientAuthentication',
                'DisableLDAPS',
                'DisableRadius',
                'DisableSso',
                'EnableClientAuthentication',
                'EnableLDAPS',
                'EnableRadius',
                'EnableSso',
                'RegisterCertificate',
                'RegisterEventTopic',
                'RejectSharedDirectory',
                'RemoveIpRoutes',
                'RemoveRegion',
                'ResetUserPassword',
                'RestoreFromSnapshot',
                'ShareDirectory',
                'StartSchemaExtension',
                'UnauthorizeApplication',
                'UnshareDirectory',
                'UpdateConditionalForwarder',
                'UpdateDirectorySetup',
                'UpdateNumberOfDomainControllers',
                'UpdateRadius',
                'UpdateSettings',
                'UpdateTrust'
            ],
            Tagging: [
                'AddTagsToResource',
                'RemoveTagsFromResource'
            ],
            Read: [
                'CheckAlias',
                'DescribeCertificate',
                'DescribeClientAuthenticationSettings',
                'DescribeConditionalForwarders',
                'DescribeDomainControllers',
                'DescribeEventTopics',
                'DescribeLDAPSSettings',
                'DescribeRegions',
                'DescribeSettings',
                'DescribeSharedDirectories',
                'DescribeSnapshots',
                'DescribeTrusts',
                'DescribeUpdateDirectory',
                'GetAuthorizedApplicationDetails',
                'GetDirectoryLimits',
                'GetSnapshotLimits',
                'ListAuthorizedApplications',
                'ListIpRoutes',
                'ListLogSubscriptions',
                'ListTagsForResource',
                'VerifyTrust'
            ],
            List: [
                'DescribeDirectories',
                'ListCertificates',
                'ListSchemaExtensions'
            ]
        };
    }
    /**
     * Grants permission to accept a directory sharing request that was sent from the directory owner account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/devguide/API_AcceptSharedDirectory.html
     */
    toAcceptSharedDirectory() {
        return this.to('AcceptSharedDirectory');
    }
    /**
     * Grants permission to add a CIDR address block to correctly route traffic to and from your Microsoft AD on Amazon Web Services
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - ec2:AuthorizeSecurityGroupEgress
     * - ec2:AuthorizeSecurityGroupIngress
     * - ec2:DescribeSecurityGroups
     *
     * https://docs.aws.amazon.com/directoryservice/latest/devguide/API_AddIpRoutes.html
     */
    toAddIpRoutes() {
        return this.to('AddIpRoutes');
    }
    /**
     * Grants permission to add two domain controllers in the specified Region for the specified directory
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/devguide/API_AddRegion.html
     */
    toAddRegion() {
        return this.to('AddRegion');
    }
    /**
     * Grants permission to add or overwrite one or more tags for the specified Amazon Directory Services directory
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - ec2:CreateTags
     *
     * https://docs.aws.amazon.com/directoryservice/latest/devguide/API_AddTagsToResource.html
     */
    toAddTagsToResource() {
        return this.to('AddTagsToResource');
    }
    /**
     * Grants permission to authorize an application for your AWS Directory
     *
     * Access Level: Write
     */
    toAuthorizeApplication() {
        return this.to('AuthorizeApplication');
    }
    /**
     * Grants permission to cancel an in-progress schema extension to a Microsoft AD directory
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/devguide/API_CancelSchemaExtension.html
     */
    toCancelSchemaExtension() {
        return this.to('CancelSchemaExtension');
    }
    /**
     * Grants permission to verify that the alias is available for use
     *
     * Access Level: Read
     */
    toCheckAlias() {
        return this.to('CheckAlias');
    }
    /**
     * Grants permission to create an AD Connector to connect to an on-premises directory
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - ec2:AuthorizeSecurityGroupEgress
     * - ec2:AuthorizeSecurityGroupIngress
     * - ec2:CreateNetworkInterface
     * - ec2:CreateSecurityGroup
     * - ec2:CreateTags
     * - ec2:DescribeNetworkInterfaces
     * - ec2:DescribeSubnets
     * - ec2:DescribeVpcs
     *
     * https://docs.aws.amazon.com/directoryservice/latest/devguide/API_ConnectDirectory.html
     */
    toConnectDirectory() {
        return this.to('ConnectDirectory');
    }
    /**
     * Grants permission to create an alias for a directory and assigns the alias to the directory
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/devguide/API_CreateAlias.html
     */
    toCreateAlias() {
        return this.to('CreateAlias');
    }
    /**
     * Grants permission to create a computer account in the specified directory, and joins the computer to the directory
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/devguide/API_CreateComputer.html
     */
    toCreateComputer() {
        return this.to('CreateComputer');
    }
    /**
     * Grants permission to create a conditional forwarder associated with your AWS directory
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/devguide/API_CreateConditionalForwarder.html
     */
    toCreateConditionalForwarder() {
        return this.to('CreateConditionalForwarder');
    }
    /**
     * Grants permission to create a Simple AD directory
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - ec2:AuthorizeSecurityGroupEgress
     * - ec2:AuthorizeSecurityGroupIngress
     * - ec2:CreateNetworkInterface
     * - ec2:CreateSecurityGroup
     * - ec2:CreateTags
     * - ec2:DescribeNetworkInterfaces
     * - ec2:DescribeSubnets
     * - ec2:DescribeVpcs
     *
     * https://docs.aws.amazon.com/directoryservice/latest/devguide/API_CreateDirectory.html
     */
    toCreateDirectory() {
        return this.to('CreateDirectory');
    }
    /**
     * Grants permission to create an IdentityPool Directory in the AWS cloud
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     */
    toCreateIdentityPoolDirectory() {
        return this.to('CreateIdentityPoolDirectory');
    }
    /**
     * Grants permission to create a subscription to forward real time Directory Service domain controller security logs to the specified CloudWatch log group in your AWS account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/devguide/API_CreateLogSubscription.html
     */
    toCreateLogSubscription() {
        return this.to('CreateLogSubscription');
    }
    /**
     * Grants permission to create a Microsoft AD in the AWS cloud
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - ec2:AuthorizeSecurityGroupEgress
     * - ec2:AuthorizeSecurityGroupIngress
     * - ec2:CreateNetworkInterface
     * - ec2:CreateSecurityGroup
     * - ec2:CreateTags
     * - ec2:DescribeNetworkInterfaces
     * - ec2:DescribeSubnets
     * - ec2:DescribeVpcs
     *
     * https://docs.aws.amazon.com/directoryservice/latest/devguide/API_CreateMicrosoftAD.html
     */
    toCreateMicrosoftAD() {
        return this.to('CreateMicrosoftAD');
    }
    /**
     * Grants permission to create a snapshot of a Simple AD or Microsoft AD directory in the AWS cloud
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/devguide/API_CreateSnapshot.html
     */
    toCreateSnapshot() {
        return this.to('CreateSnapshot');
    }
    /**
     * Grants permission to initiate the creation of the AWS side of a trust relationship between a Microsoft AD in the AWS cloud and an external domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/devguide/API_CreateTrust.html
     */
    toCreateTrust() {
        return this.to('CreateTrust');
    }
    /**
     * Grants permission to delete a conditional forwarder that has been set up for your AWS directory
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/devguide/API_DeleteConditionalForwarder.html
     */
    toDeleteConditionalForwarder() {
        return this.to('DeleteConditionalForwarder');
    }
    /**
     * Grants permission to delete an AWS Directory Service directory
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - ec2:DeleteNetworkInterface
     * - ec2:DeleteSecurityGroup
     * - ec2:DescribeNetworkInterfaces
     * - ec2:RevokeSecurityGroupEgress
     * - ec2:RevokeSecurityGroupIngress
     *
     * https://docs.aws.amazon.com/directoryservice/latest/devguide/API_DeleteDirectory.html
     */
    toDeleteDirectory() {
        return this.to('DeleteDirectory');
    }
    /**
     * Grants permission to delete the specified log subscription
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/devguide/API_DeleteLogSubscription.html
     */
    toDeleteLogSubscription() {
        return this.to('DeleteLogSubscription');
    }
    /**
     * Grants permission to delete a directory snapshot
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/devguide/API_DeleteSnapshot.html
     */
    toDeleteSnapshot() {
        return this.to('DeleteSnapshot');
    }
    /**
     * Grants permission to delete an existing trust relationship between your Microsoft AD in the AWS cloud and an external domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/devguide/DeleteTrust.html
     */
    toDeleteTrust() {
        return this.to('DeleteTrust');
    }
    /**
     * Grants permission to delete from the system the certificate that was registered for a secured LDAP connection
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/devguide/API_DeregisterCertificate.html
     */
    toDeregisterCertificate() {
        return this.to('DeregisterCertificate');
    }
    /**
     * Grants permission to remove the specified directory as a publisher to the specified SNS topic
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/devguide/API_DeregisterEventTopic.html
     */
    toDeregisterEventTopic() {
        return this.to('DeregisterEventTopic');
    }
    /**
     * Grants permission to display information about the certificate registered for a secured LDAP connection
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/devguide/API_DescribeCertificate.html
     */
    toDescribeCertificate() {
        return this.to('DescribeCertificate');
    }
    /**
     * Grants permission to retrieve information about the type of client authentication for the specified directory, if the type is specified. If no type is specified, information about all client authentication types that are supported for the specified directory is retrieved. Currently, only SmartCard is supported
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/devguide/API_DescribeClientAuthenticationSettings.html
     */
    toDescribeClientAuthenticationSettings() {
        return this.to('DescribeClientAuthenticationSettings');
    }
    /**
     * Grants permission to obtain information about the conditional forwarders for this account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/devguide/API_DescribeConditionalForwarders.html
     */
    toDescribeConditionalForwarders() {
        return this.to('DescribeConditionalForwarders');
    }
    /**
     * Grants permission to obtain information about the directories that belong to this account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/directoryservice/latest/devguide/API_DescribeDirectories.html
     */
    toDescribeDirectories() {
        return this.to('DescribeDirectories');
    }
    /**
     * Grants permission to provide information about any domain controllers in your directory
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/devguide/API_DescribeDomainControllers.html
     */
    toDescribeDomainControllers() {
        return this.to('DescribeDomainControllers');
    }
    /**
     * Grants permission to obtain information about which SNS topics receive status messages from the specified directory
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/devguide/API_DescribeEventTopics.html
     */
    toDescribeEventTopics() {
        return this.to('DescribeEventTopics');
    }
    /**
     * Grants permission to describe the status of LDAP security for the specified directory
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/devguide/API_DescribeLDAPSSettings.html
     */
    toDescribeLDAPSSettings() {
        return this.to('DescribeLDAPSSettings');
    }
    /**
     * Grants permission to provide information about the Regions that are configured for multi-Region replication
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/devguide/API_DescribeRegions.html
     */
    toDescribeRegions() {
        return this.to('DescribeRegions');
    }
    /**
     * Grants permission to retrieve information about the configurable settings for the specified directory
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/devguide/API_DescribeSettings.html
     */
    toDescribeSettings() {
        return this.to('DescribeSettings');
    }
    /**
     * Grants permission to return the shared directories in your account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/devguide/API_DescribeSharedDirectories.html
     */
    toDescribeSharedDirectories() {
        return this.to('DescribeSharedDirectories');
    }
    /**
     * Grants permission to obtain information about the directory snapshots that belong to this account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/devguide/API_DescribeSnapshots.html
     */
    toDescribeSnapshots() {
        return this.to('DescribeSnapshots');
    }
    /**
     * Grants permission to obtain information about the trust relationships for this account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/devguide/API_DescribeTrusts.html
     */
    toDescribeTrusts() {
        return this.to('DescribeTrusts');
    }
    /**
     * Grants permission to describe the updates of a directory for a particular update type
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/devguide/API_DescribeUpdateDirectory.html
     */
    toDescribeUpdateDirectory() {
        return this.to('DescribeUpdateDirectory');
    }
    /**
     * Grants permission to disable alternative client authentication methods for the specified directory
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/devguide/API_DisableClientAuthentication.html
     */
    toDisableClientAuthentication() {
        return this.to('DisableClientAuthentication');
    }
    /**
     * Grants permission to deactivate LDAP secure calls for the specified directory
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/devguide/API_DisableLDAPS.html
     */
    toDisableLDAPS() {
        return this.to('DisableLDAPS');
    }
    /**
     * Grants permission to disable multi-factor authentication (MFA) with the Remote Authentication Dial In User Service (RADIUS) server for an AD Connector directory
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/devguide/API_DisableRadius.html
     */
    toDisableRadius() {
        return this.to('DisableRadius');
    }
    /**
     * Grants permission to disable single-sign on for a directory
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/devguide/API_DisableSso.html
     */
    toDisableSso() {
        return this.to('DisableSso');
    }
    /**
     * Grants permission to enable alternative client authentication methods for the specified directory
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/devguide/API_EnableClientAuthentication.html
     */
    toEnableClientAuthentication() {
        return this.to('EnableClientAuthentication');
    }
    /**
     * Grants permission to activate the switch for the specific directory to always use LDAP secure calls
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/devguide/API_EnableLDAPS.html
     */
    toEnableLDAPS() {
        return this.to('EnableLDAPS');
    }
    /**
     * Grants permission to enable multi-factor authentication (MFA) with the Remote Authentication Dial In User Service (RADIUS) server for an AD Connector directory
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/devguide/API_EnableRadius.html
     */
    toEnableRadius() {
        return this.to('EnableRadius');
    }
    /**
     * Grants permission to enable single-sign on for a directory
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/devguide/API_EnableSso.html
     */
    toEnableSso() {
        return this.to('EnableSso');
    }
    /**
     * Grants permission to retrieve the details of the authorized applications on a directory
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/devguide/API_GetAuthorizedApplicationDetails.html
     */
    toGetAuthorizedApplicationDetails() {
        return this.to('GetAuthorizedApplicationDetails');
    }
    /**
     * Grants permission to obtain directory limit information for the current region
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/devguide/API_GetDirectoryLimits.html
     */
    toGetDirectoryLimits() {
        return this.to('GetDirectoryLimits');
    }
    /**
     * Grants permission to obtain the manual snapshot limits for a directory
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/devguide/API_GetSnapshotLimits.html
     */
    toGetSnapshotLimits() {
        return this.to('GetSnapshotLimits');
    }
    /**
     * Grants permission to obtain the AWS applications authorized for a directory
     *
     * Access Level: Read
     */
    toListAuthorizedApplications() {
        return this.to('ListAuthorizedApplications');
    }
    /**
     * Grants permission to list all the certificates registered for a secured LDAP connection, for the specified directory
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/directoryservice/latest/devguide/API_ListCertificates.html
     */
    toListCertificates() {
        return this.to('ListCertificates');
    }
    /**
     * Grants permission to list the address blocks that you have added to a directory
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/devguide/API_ListIpRoutes.html
     */
    toListIpRoutes() {
        return this.to('ListIpRoutes');
    }
    /**
     * Grants permission to list the active log subscriptions for the AWS account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/devguide/API_ListLogSubscriptions.html
     */
    toListLogSubscriptions() {
        return this.to('ListLogSubscriptions');
    }
    /**
     * Grants permission to list all schema extensions applied to a Microsoft AD Directory
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/directoryservice/latest/devguide/API_ListSchemaExtensions.html
     */
    toListSchemaExtensions() {
        return this.to('ListSchemaExtensions');
    }
    /**
     * Grants permission to list all tags on an Amazon Directory Services directory
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/devguide/API_ListTagsForResource.html
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * Grants permission to register a certificate for secured LDAP connection
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/devguide/API_RegisterCertificate.html
     */
    toRegisterCertificate() {
        return this.to('RegisterCertificate');
    }
    /**
     * Grants permission to associate a directory with an SNS topic
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - sns:GetTopicAttributes
     *
     * https://docs.aws.amazon.com/directoryservice/latest/devguide/API_RegisterEventTopic.html
     */
    toRegisterEventTopic() {
        return this.to('RegisterEventTopic');
    }
    /**
     * Grants permission to reject a directory sharing request that was sent from the directory owner account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/devguide/API_RejectSharedDirectory.html
     */
    toRejectSharedDirectory() {
        return this.to('RejectSharedDirectory');
    }
    /**
     * Grants permission to remove IP address blocks from a directory
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/devguide/API_RemoveIpRoutes.html
     */
    toRemoveIpRoutes() {
        return this.to('RemoveIpRoutes');
    }
    /**
     * Grants permission to stop all replication and removes the domain controllers from the specified Region. You cannot remove the primary Region with this operation
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/devguide/API_RemoveRegion.html
     */
    toRemoveRegion() {
        return this.to('RemoveRegion');
    }
    /**
     * Grants permission to remove tags from an Amazon Directory Services directory
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - ec2:DeleteTags
     *
     * https://docs.aws.amazon.com/directoryservice/latest/devguide/API_RemoveTagsFromResource.html
     */
    toRemoveTagsFromResource() {
        return this.to('RemoveTagsFromResource');
    }
    /**
     * Grants permission to reset the password for any user in your AWS Managed Microsoft AD or Simple AD directory
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/devguide/API_ResetUserPassword.html
     */
    toResetUserPassword() {
        return this.to('ResetUserPassword');
    }
    /**
     * Grants permission to restore a directory using an existing directory snapshot
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/devguide/API_RestoreFromSnapshot.html
     */
    toRestoreFromSnapshot() {
        return this.to('RestoreFromSnapshot');
    }
    /**
     * Grants permission to share a specified directory in your AWS account (directory owner) with another AWS account (directory consumer). With this operation you can use your directory from any AWS account and from any Amazon VPC within an AWS Region
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/devguide/API_ShareDirectory.html
     */
    toShareDirectory() {
        return this.to('ShareDirectory');
    }
    /**
     * Grants permission to apply a schema extension to a Microsoft AD directory
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/devguide/API_StartSchemaExtension.html
     */
    toStartSchemaExtension() {
        return this.to('StartSchemaExtension');
    }
    /**
     * Grants permission to unauthorize an application from your AWS Directory
     *
     * Access Level: Write
     */
    toUnauthorizeApplication() {
        return this.to('UnauthorizeApplication');
    }
    /**
     * Grants permission to stop the directory sharing between the directory owner and consumer accounts
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/devguide/API_UnshareDirectory.html
     */
    toUnshareDirectory() {
        return this.to('UnshareDirectory');
    }
    /**
     * Grants permission to update a conditional forwarder that has been set up for your AWS directory
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/devguide/API_UpdateConditionalForwarder.html
     */
    toUpdateConditionalForwarder() {
        return this.to('UpdateConditionalForwarder');
    }
    /**
     * Grants permission to update the directory for a particular update type
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/devguide/API_UpdateDirectorySetup.html
     */
    toUpdateDirectorySetup() {
        return this.to('UpdateDirectorySetup');
    }
    /**
     * Grants permission to add or remove domain controllers to or from the directory. Based on the difference between current value and new value (provided through this API call), domain controllers will be added or removed. It may take up to 45 minutes for any new domain controllers to become fully active once the requested number of domain controllers is updated. During this time, you cannot make another update request
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/devguide/API_UpdateNumberOfDomainControllers.html
     */
    toUpdateNumberOfDomainControllers() {
        return this.to('UpdateNumberOfDomainControllers');
    }
    /**
     * Grants permission to update the Remote Authentication Dial In User Service (RADIUS) server information for an AD Connector directory
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/devguide/API_UpdateRadius.html
     */
    toUpdateRadius() {
        return this.to('UpdateRadius');
    }
    /**
     * Grants permission to update the configurable settings for the specified directory
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/devguide/API_UpdateSettings.html
     */
    toUpdateSettings() {
        return this.to('UpdateSettings');
    }
    /**
     * Grants permission to update the trust that has been set up between your AWS Managed Microsoft AD directory and an on-premises Active Directory
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/devguide/API_UpdateTrust.html
     */
    toUpdateTrust() {
        return this.to('UpdateTrust');
    }
    /**
     * Grants permission to verify a trust relationship between your Microsoft AD in the AWS cloud and an external domain
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/devguide/API_VerifyTrust.html
     */
    toVerifyTrust() {
        return this.to('VerifyTrust');
    }
    /**
     * Adds a resource of type directory to the statement
     *
     * https://docs.aws.amazon.com/directoryservice/latest/devguide/welcome.html
     *
     * @param directoryId - Identifier for the directoryId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onDirectory(directoryId, account, region, partition) {
        return this.on(`arn:${partition || Ds.defaultPartition}:ds:${region || '*'}:${account || '*'}:directory/${directoryId}`);
    }
}
exports.Ds = Ds;
_a = JSII_RTTI_SYMBOL_1;
Ds[_a] = { fqn: "iam-floyd.Ds", version: "0.452.0" };
//# sourceMappingURL=data:application/json;base64,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