import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement } from "../shared";
/**
 * (experimental) Statement provider for service [geo](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonlocation.html).
 *
 * @experimental
 */
export declare class Geo extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [geo](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonlocation.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Grants permission to create an association between a geofence-collection and a tracker resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_AssociateTrackerConsumer.html
     *
     * @experimental
     */
    toAssociateTrackerConsumer(): this;
    /**
     * (experimental) Grants permission to delete a batch of geofences from a geofence collection.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_BatchDeleteGeofence.html
     *
     * @experimental
     */
    toBatchDeleteGeofence(): this;
    /**
     * (experimental) Grants permission to evaluate device positions against the position of geofences in a given geofence collection.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_BatchEvaluateGeofences.html
     *
     * @experimental
     */
    toBatchEvaluateGeofences(): this;
    /**
     * (experimental) Grants permission to send a batch request to retrieve device positions.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_BatchGetDevicePosition.html
     *
     * @experimental
     */
    toBatchGetDevicePosition(): this;
    /**
     * (experimental) Grants permission to send a batch request for adding geofences into a given geofence collection.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_BatchPutGeofence.html
     *
     * @experimental
     */
    toBatchPutGeofence(): this;
    /**
     * (experimental) Grants permission to upload a position update for one or more devices to a tracker resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_BatchUpdateDevicePosition.html
     *
     * @experimental
     */
    toBatchUpdateDevicePosition(): this;
    /**
     * (experimental) Grants permission to create a geofence-collection.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_CreateGeofenceCollection.html
     *
     * @experimental
     */
    toCreateGeofenceCollection(): this;
    /**
     * (experimental) Grants permission to create a map resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_CreateMap.html
     *
     * @experimental
     */
    toCreateMap(): this;
    /**
     * (experimental) Grants permission to create a place index resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_CreatePlaceIndex.html
     *
     * @experimental
     */
    toCreatePlaceIndex(): this;
    /**
     * (experimental) Grants permission to create a tracker resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_CreateTracker.html
     *
     * @experimental
     */
    toCreateTracker(): this;
    /**
     * (experimental) Grants permission to deletes a geofence-collection.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_DeleteGeofenceCollection.html
     *
     * @experimental
     */
    toDeleteGeofenceCollection(): this;
    /**
     * (experimental) Grants permission to delete a map resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_DeleteMap.html
     *
     * @experimental
     */
    toDeleteMap(): this;
    /**
     * (experimental) Grants permission to delete a place index resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_DeletePlaceIndex.html
     *
     * @experimental
     */
    toDeletePlaceIndex(): this;
    /**
     * (experimental) Grants permission to delete a tracker resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_DeleteTracker.html
     *
     * @experimental
     */
    toDeleteTracker(): this;
    /**
     * (experimental) Grants permission to retrieve a geofence collection details.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_DescribeGeofenceCollection.html
     *
     * @experimental
     */
    toDescribeGeofenceCollection(): this;
    /**
     * (experimental) Grants permission to retrieve a map resource details.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_DescribeMap.html
     *
     * @experimental
     */
    toDescribeMap(): this;
    /**
     * (experimental) Grants permission to retrieve a a place-index resource details.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_DescribePlaceIndex.html
     *
     * @experimental
     */
    toDescribePlaceIndex(): this;
    /**
     * (experimental) Grants permission to retrieve a tracker resource details.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_DescribeTracker.html
     *
     * @experimental
     */
    toDescribeTracker(): this;
    /**
     * (experimental) Grants permission to remove the association between a tracker resource and a geofence-collection.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_DisassociateTrackerConsumer.html
     *
     * @experimental
     */
    toDisassociateTrackerConsumer(): this;
    /**
     * (experimental) Grants permission to retrieve the latest device position.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_GetDevicePosition.html
     *
     * @experimental
     */
    toGetDevicePosition(): this;
    /**
     * (experimental) Grant permission to retrieve the device position history.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_GetDevicePositionHistory.html
     *
     * @experimental
     */
    toGetDevicePositionHistory(): this;
    /**
     * (experimental) Grants permission to retrieve the geofence details from a geofence-collection.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_GetGeofence.html
     *
     * @experimental
     */
    toGetGeofence(): this;
    /**
     * (experimental) Grants permission to retrieve the glyph file for a map resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_GetMapGlyphs.html
     *
     * @experimental
     */
    toGetMapGlyphs(): this;
    /**
     * (experimental) Grants permission to retrieve the sprite file for a map resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_GetMapSprites.html
     *
     * @experimental
     */
    toGetMapSprites(): this;
    /**
     * (experimental) Grants permission to retrieve the map style descriptor from a map resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_GetMapStyleDescriptor.html
     *
     * @experimental
     */
    toGetMapStyleDescriptor(): this;
    /**
     * (experimental) Grants permission to retrieve the map tile from the map resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_GetMapTile.html
     *
     * @experimental
     */
    toGetMapTile(): this;
    /**
     * (experimental) Grants permission to retrieves the map TileJSON details from a given map resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_GetMapTileJson.html
     *
     * @experimental
     */
    toGetMapTileJson(): this;
    /**
     * (experimental) Grants permission to lists geofence-collections.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_ListGeofenceCollections.html
     *
     * @experimental
     */
    toListGeofenceCollections(): this;
    /**
     * (experimental) Grants permission to list geofences stored in a given geofence collection.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_ListGeofences.html
     *
     * @experimental
     */
    toListGeofences(): this;
    /**
     * (experimental) Grants permission to list map resources.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_ListMaps.html
     *
     * @experimental
     */
    toListMaps(): this;
    /**
     * (experimental) Grants permission to return a list of place index resources.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_ListPlaceIndexes.html
     *
     * @experimental
     */
    toListPlaceIndexes(): this;
    /**
     * (experimental) Grants permission to retrieve a list of geofence collections currently associated to the given tracker resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_ListTrackerConsumers.html
     *
     * @experimental
     */
    toListTrackerConsumers(): this;
    /**
     * (experimental) Grants permission to return a list of tracker resources.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_ListTrackers.html
     *
     * @experimental
     */
    toListTrackers(): this;
    /**
     * (experimental) Grants permission to add a new geofence or update an existing geofence to a given geofence-collection.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_PutGeofence.html
     *
     * @experimental
     */
    toPutGeofence(): this;
    /**
     * (experimental) Grants permission to reverse geocodes a given coordinate.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_SearchPlaceIndexForPosition.html
     *
     * @experimental
     */
    toSearchPlaceIndexForPosition(): this;
    /**
     * (experimental) Grants permission to geocode free-form text, such as an address, name, city or region.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_SearchPlaceIndexForText.html
     *
     * @experimental
     */
    toSearchPlaceIndexForText(): this;
    /**
     * (experimental) Grants permission to update the description of a geofence collection.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_UpdateGeofenceCollection.html
     *
     * @experimental
     */
    toUpdateGeofenceCollection(): this;
    /**
     * (experimental) Grants permission to update the description of a tracker resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_UpdateTracker.html
     *
     * @experimental
     */
    toUpdateTracker(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type geofence-collection to the statement.
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/overview.html#geofence-overview
     *
     * @param geofenceCollectionName - Identifier for the geofenceCollectionName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onGeofenceCollection(geofenceCollectionName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type map to the statement.
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/overview.html#map-overview
     *
     * @param mapName - Identifier for the mapName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onMap(mapName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type place-index to the statement.
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/overview.html#places-overview
     *
     * @param indexName - Identifier for the indexName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onPlaceIndex(indexName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type tracker to the statement.
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/overview.html#tracking-overview
     *
     * @param trackerName - Identifier for the trackerName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onTracker(trackerName: string, account?: string, region?: string, partition?: string): this;
}
