import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement } from "../shared";
/**
 * (experimental) Statement provider for service [tag](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonresourcegrouptaggingapi.html).
 *
 * @experimental
 */
export declare class Tag extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [tag](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonresourcegrouptaggingapi.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Describe the status of the StartReportCreation operation.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/API_DescribeReportCreation.html
     *
     * @experimental
     */
    toDescribeReportCreation(): this;
    /**
     * (experimental) Get a table that shows counts of resources that are noncompliant with their effective tag policies.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/API_GetComplianceSummary.html
     *
     * @experimental
     */
    toGetComplianceSummary(): this;
    /**
     * (experimental) Get tagged AWS resources that match the given tag filters.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/API_GetResources.html
     *
     * @experimental
     */
    toGetResources(): this;
    /**
     * (experimental) Get all tagKeys for the account in the specific region.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/API_GetTagKeys.html
     *
     * @experimental
     */
    toGetTagKeys(): this;
    /**
     * (experimental) Get all tagValues for the account in the specific region.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/API_GetTagValues.html
     *
     * @experimental
     */
    toGetTagValues(): this;
    /**
     * (experimental) Generate a report that lists all tagged resources in accounts across your organization, and whether each resource is compliant with the effective tag policy.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/API_StartReportCreation.html
     *
     * @experimental
     */
    toStartReportCreation(): this;
    /**
     * (experimental) Add tags to AWS resources.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/API_TagResources.html
     *
     * @experimental
     */
    toTagResources(): this;
    /**
     * (experimental) Remove tags from AWS resources.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/API_UntagResources.html
     *
     * @experimental
     */
    toUntagResources(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
}
