import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement } from "../shared";
/**
 * (experimental) Statement provider for service [route53domains](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonroute53domains.html).
 *
 * @experimental
 */
export declare class Route53domains extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [route53domains](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonroute53domains.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Grants permission to check the availability of one domain name.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_CheckDomainAvailability.html
     *
     * @experimental
     */
    toCheckDomainAvailability(): this;
    /**
     * (experimental) Grants permission to delete the specified tags for a domain.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_DeleteTagsForDomain.html
     *
     * @experimental
     */
    toDeleteTagsForDomain(): this;
    /**
     * (experimental) Grants permission to configure Amazon Route 53 to automatically renew the specified domain before the domain registration expires.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_DisableDomainAutoRenew.html
     *
     * @experimental
     */
    toDisableDomainAutoRenew(): this;
    /**
     * (experimental) Grants permission to remove the transfer lock on the domain (specifically the clientTransferProhibited status) to allow domain transfers.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_DisableDomainTransferLock.html
     *
     * @experimental
     */
    toDisableDomainTransferLock(): this;
    /**
     * (experimental) Grants permission to configure Amazon Route 53 to automatically renew the specified domain before the domain registration expires.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_DisableDomainAutoRenew.html
     *
     * @experimental
     */
    toEnableDomainAutoRenew(): this;
    /**
     * (experimental) Grants permission to set the transfer lock on the domain (specifically the clientTransferProhibited status) to prevent domain transfers.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_EnableDomainTransferLock.html
     *
     * @experimental
     */
    toEnableDomainTransferLock(): this;
    /**
     * (experimental) For operations that require confirmation that the email address for the registrant contact is valid, such as registering a new domain, grants permission to get information about whether the registrant contact has responded.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetContactReachabilityStatus.html
     *
     * @experimental
     */
    toGetContactReachabilityStatus(): this;
    /**
     * (experimental) Grants permission to get detailed information about a domain.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetDomainDetail.html
     *
     * @experimental
     */
    toGetDomainDetail(): this;
    /**
     * (experimental) Grants permission to get a list of suggested domain names given a string, which can either be a domain name or simply a word or phrase (without spaces).
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetDomainSuggestions.html
     *
     * @experimental
     */
    toGetDomainSuggestions(): this;
    /**
     * (experimental) Grants permission to get the current status of an operation that is not completed.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html
     *
     * @experimental
     */
    toGetOperationDetail(): this;
    /**
     * (experimental) Grants permission to list all the domain names registered with Amazon Route 53 for the current AWS account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ListDomains.html
     *
     * @experimental
     */
    toListDomains(): this;
    /**
     * (experimental) Grants permission to list the operation IDs of operations that are not yet complete.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ListOperations.html
     *
     * @experimental
     */
    toListOperations(): this;
    /**
     * (experimental) Grants permission to list all the tags that are associated with the specified domain.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ListTagsForDomain.html
     *
     * @experimental
     */
    toListTagsForDomain(): this;
    /**
     * (experimental) Grants permission to register domains.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_RegisterDomain.html
     *
     * @experimental
     */
    toRegisterDomain(): this;
    /**
     * (experimental) Grants permission to renew domains for the specified number of years.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_RenewDomain.html
     *
     * @experimental
     */
    toRenewDomain(): this;
    /**
     * (experimental) For operations that require confirmation that the email address for the registrant contact is valid, such as registering a new domain, grants permission to resend the confirmation email to the current email address for the registrant contact.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ResendContactReachabilityEmail.html
     *
     * @experimental
     */
    toResendContactReachabilityEmail(): this;
    /**
     * (experimental) Grants permission to get the AuthCode for the domain.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_RetrieveDomainAuthCode.html
     *
     * @experimental
     */
    toRetrieveDomainAuthCode(): this;
    /**
     * (experimental) Grants permission to transfer a domain from another registrar to Amazon Route 53.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomain.html
     *
     * @experimental
     */
    toTransferDomain(): this;
    /**
     * (experimental) Grants permission to update the contact information for domain.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_UpdateDomainContact.html
     *
     * @experimental
     */
    toUpdateDomainContact(): this;
    /**
     * (experimental) Grants permission to update the domain contact privacy setting.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_UpdateDomainContactPrivacy.html
     *
     * @experimental
     */
    toUpdateDomainContactPrivacy(): this;
    /**
     * (experimental) Grants permission to replace the current set of name servers for a domain with the specified set of name servers.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_UpdateDomainNameservers.html
     *
     * @experimental
     */
    toUpdateDomainNameservers(): this;
    /**
     * (experimental) Grants permission to add or update tags for a specified domain.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_UpdateTagsForDomain.html
     *
     * @experimental
     */
    toUpdateTagsForDomain(): this;
    /**
     * (experimental) Grants permission to get all the domain-related billing records for the current AWS account for a specified period.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ViewBilling.html
     *
     * @experimental
     */
    toViewBilling(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
}
