"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApplicationListenerCertificate = void 0;
const cdk = require("@aws-cdk/core");
const elasticloadbalancingv2_generated_1 = require("../elasticloadbalancingv2.generated");
/**
 * Add certificates to a listener
 */
class ApplicationListenerCertificate extends cdk.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        if (!props.certificateArns && !props.certificates) {
            throw new Error('At least one of \'certificateArns\' or \'certificates\' is required');
        }
        const certificates = [
            ...(props.certificates || []).map(c => ({ certificateArn: c.certificateArn })),
            ...(props.certificateArns || []).map(certificateArn => ({ certificateArn })),
        ];
        new elasticloadbalancingv2_generated_1.CfnListenerCertificate(this, 'Resource', {
            listenerArn: props.listener.listenerArn,
            certificates,
        });
    }
}
exports.ApplicationListenerCertificate = ApplicationListenerCertificate;
//# sourceMappingURL=data:application/json;base64,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