#!/usr/bin/env node
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const ec2 = require("@aws-cdk/aws-ec2");
const cdk = require("@aws-cdk/core");
const elbv2 = require("../lib");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'aws-cdk-elbv2-integ');
const vpc = new ec2.Vpc(stack, 'VPC', {
    maxAzs: 2,
});
const lb = new elbv2.ApplicationLoadBalancer(stack, 'LB', {
    vpc,
    internetFacing: true,
});
const listener = lb.addListener('Listener', {
    port: 80,
});
const group1 = listener.addTargets('Target', {
    port: 80,
    targets: [new elbv2.IpTarget('10.0.128.4')],
});
const group2 = listener.addTargets('ConditionalTarget', {
    priority: 10,
    hostHeader: 'example.com',
    port: 80,
    targets: [new elbv2.IpTarget('10.0.128.5')],
});
group1.metricTargetResponseTime().createAlarm(stack, 'ResponseTimeHigh1', {
    threshold: 5,
    evaluationPeriods: 2,
});
group2.metricTargetResponseTime().createAlarm(stack, 'ResponseTimeHigh2', {
    threshold: 5,
    evaluationPeriods: 2,
});
app.synth();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcuYWxiLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiaW50ZWcuYWxiLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUNBLHdDQUF3QztBQUN4QyxxQ0FBcUM7QUFDckMsZ0NBQWdDO0FBRWhDLE1BQU0sR0FBRyxHQUFHLElBQUksR0FBRyxDQUFDLEdBQUcsRUFBRSxDQUFDO0FBQzFCLE1BQU0sS0FBSyxHQUFHLElBQUksR0FBRyxDQUFDLEtBQUssQ0FBQyxHQUFHLEVBQUUscUJBQXFCLENBQUMsQ0FBQztBQUV4RCxNQUFNLEdBQUcsR0FBRyxJQUFJLEdBQUcsQ0FBQyxHQUFHLENBQUMsS0FBSyxFQUFFLEtBQUssRUFBRTtJQUNwQyxNQUFNLEVBQUUsQ0FBQztDQUNWLENBQUMsQ0FBQztBQUVILE1BQU0sRUFBRSxHQUFHLElBQUksS0FBSyxDQUFDLHVCQUF1QixDQUFDLEtBQUssRUFBRSxJQUFJLEVBQUU7SUFDeEQsR0FBRztJQUNILGNBQWMsRUFBRSxJQUFJO0NBQ3JCLENBQUMsQ0FBQztBQUVILE1BQU0sUUFBUSxHQUFHLEVBQUUsQ0FBQyxXQUFXLENBQUMsVUFBVSxFQUFFO0lBQzFDLElBQUksRUFBRSxFQUFFO0NBQ1QsQ0FBQyxDQUFDO0FBRUgsTUFBTSxNQUFNLEdBQUcsUUFBUSxDQUFDLFVBQVUsQ0FBQyxRQUFRLEVBQUU7SUFDM0MsSUFBSSxFQUFFLEVBQUU7SUFDUixPQUFPLEVBQUUsQ0FBQyxJQUFJLEtBQUssQ0FBQyxRQUFRLENBQUMsWUFBWSxDQUFDLENBQUM7Q0FDNUMsQ0FBQyxDQUFDO0FBRUgsTUFBTSxNQUFNLEdBQUcsUUFBUSxDQUFDLFVBQVUsQ0FBQyxtQkFBbUIsRUFBRTtJQUN0RCxRQUFRLEVBQUUsRUFBRTtJQUNaLFVBQVUsRUFBRSxhQUFhO0lBQ3pCLElBQUksRUFBRSxFQUFFO0lBQ1IsT0FBTyxFQUFFLENBQUMsSUFBSSxLQUFLLENBQUMsUUFBUSxDQUFDLFlBQVksQ0FBQyxDQUFDO0NBQzVDLENBQUMsQ0FBQztBQUVILE1BQU0sQ0FBQyx3QkFBd0IsRUFBRSxDQUFDLFdBQVcsQ0FBQyxLQUFLLEVBQUUsbUJBQW1CLEVBQUU7SUFDeEUsU0FBUyxFQUFFLENBQUM7SUFDWixpQkFBaUIsRUFBRSxDQUFDO0NBQ3JCLENBQUMsQ0FBQztBQUVILE1BQU0sQ0FBQyx3QkFBd0IsRUFBRSxDQUFDLFdBQVcsQ0FBQyxLQUFLLEVBQUUsbUJBQW1CLEVBQUU7SUFDeEUsU0FBUyxFQUFFLENBQUM7SUFDWixpQkFBaUIsRUFBRSxDQUFDO0NBQ3JCLENBQUMsQ0FBQztBQUVILEdBQUcsQ0FBQyxLQUFLLEVBQUUsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbIiMhL3Vzci9iaW4vZW52IG5vZGVcbmltcG9ydCAqIGFzIGVjMiBmcm9tICdAYXdzLWNkay9hd3MtZWMyJztcbmltcG9ydCAqIGFzIGNkayBmcm9tICdAYXdzLWNkay9jb3JlJztcbmltcG9ydCAqIGFzIGVsYnYyIGZyb20gJy4uL2xpYic7XG5cbmNvbnN0IGFwcCA9IG5ldyBjZGsuQXBwKCk7XG5jb25zdCBzdGFjayA9IG5ldyBjZGsuU3RhY2soYXBwLCAnYXdzLWNkay1lbGJ2Mi1pbnRlZycpO1xuXG5jb25zdCB2cGMgPSBuZXcgZWMyLlZwYyhzdGFjaywgJ1ZQQycsIHtcbiAgbWF4QXpzOiAyLFxufSk7XG5cbmNvbnN0IGxiID0gbmV3IGVsYnYyLkFwcGxpY2F0aW9uTG9hZEJhbGFuY2VyKHN0YWNrLCAnTEInLCB7XG4gIHZwYyxcbiAgaW50ZXJuZXRGYWNpbmc6IHRydWUsXG59KTtcblxuY29uc3QgbGlzdGVuZXIgPSBsYi5hZGRMaXN0ZW5lcignTGlzdGVuZXInLCB7XG4gIHBvcnQ6IDgwLFxufSk7XG5cbmNvbnN0IGdyb3VwMSA9IGxpc3RlbmVyLmFkZFRhcmdldHMoJ1RhcmdldCcsIHtcbiAgcG9ydDogODAsXG4gIHRhcmdldHM6IFtuZXcgZWxidjIuSXBUYXJnZXQoJzEwLjAuMTI4LjQnKV0sXG59KTtcblxuY29uc3QgZ3JvdXAyID0gbGlzdGVuZXIuYWRkVGFyZ2V0cygnQ29uZGl0aW9uYWxUYXJnZXQnLCB7XG4gIHByaW9yaXR5OiAxMCxcbiAgaG9zdEhlYWRlcjogJ2V4YW1wbGUuY29tJyxcbiAgcG9ydDogODAsXG4gIHRhcmdldHM6IFtuZXcgZWxidjIuSXBUYXJnZXQoJzEwLjAuMTI4LjUnKV0sXG59KTtcblxuZ3JvdXAxLm1ldHJpY1RhcmdldFJlc3BvbnNlVGltZSgpLmNyZWF0ZUFsYXJtKHN0YWNrLCAnUmVzcG9uc2VUaW1lSGlnaDEnLCB7XG4gIHRocmVzaG9sZDogNSxcbiAgZXZhbHVhdGlvblBlcmlvZHM6IDIsXG59KTtcblxuZ3JvdXAyLm1ldHJpY1RhcmdldFJlc3BvbnNlVGltZSgpLmNyZWF0ZUFsYXJtKHN0YWNrLCAnUmVzcG9uc2VUaW1lSGlnaDInLCB7XG4gIHRocmVzaG9sZDogNSxcbiAgZXZhbHVhdGlvblBlcmlvZHM6IDIsXG59KTtcblxuYXBwLnN5bnRoKCk7XG4iXX0=