"use strict";
var _a, _b, _c, _d, _e, _f, _g, _h;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnScript = exports.CfnMatchmakingRuleSet = exports.CfnMatchmakingConfiguration = exports.CfnGameSessionQueue = exports.CfnGameServerGroup = exports.CfnFleet = exports.CfnBuild = exports.CfnAlias = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright 2012-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
// Generated from the AWS CloudFormation Resource Specification
// See: docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-resource-specification.html
// @cfn2ts:meta@ {"generated":"2022-05-04T19:20:33.314Z","fingerprint":"8HMicsO15Zeds6hgCgIUmQFpSc2tCqyiQWh7NuYngNo="}
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
const cdk = require("@aws-cdk/core");
const cfn_parse = require("@aws-cdk/core/lib/helpers-internal");
/**
 * Determine whether the given properties match those of a `CfnAliasProps`
 *
 * @param properties - the TypeScript properties of a `CfnAliasProps`
 *
 * @returns the result of the validation.
 */
function CfnAliasPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('description', cdk.validateString)(properties.description));
    errors.collect(cdk.propertyValidator('name', cdk.requiredValidator)(properties.name));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('routingStrategy', cdk.requiredValidator)(properties.routingStrategy));
    errors.collect(cdk.propertyValidator('routingStrategy', CfnAlias_RoutingStrategyPropertyValidator)(properties.routingStrategy));
    return errors.wrap('supplied properties not correct for "CfnAliasProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::GameLift::Alias` resource
 *
 * @param properties - the TypeScript properties of a `CfnAliasProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::GameLift::Alias` resource.
 */
// @ts-ignore TS6133
function cfnAliasPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAliasPropsValidator(properties).assertSuccess();
    return {
        Name: cdk.stringToCloudFormation(properties.name),
        RoutingStrategy: cfnAliasRoutingStrategyPropertyToCloudFormation(properties.routingStrategy),
        Description: cdk.stringToCloudFormation(properties.description),
    };
}
// @ts-ignore TS6133
function CfnAliasPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('name', 'Name', cfn_parse.FromCloudFormation.getString(properties.Name));
    ret.addPropertyResult('routingStrategy', 'RoutingStrategy', CfnAliasRoutingStrategyPropertyFromCloudFormation(properties.RoutingStrategy));
    ret.addPropertyResult('description', 'Description', properties.Description != null ? cfn_parse.FromCloudFormation.getString(properties.Description) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::GameLift::Alias`
 *
 * The `AWS::GameLift::Alias` resource creates an alias for an Amazon GameLift (GameLift) fleet destination. There are two types of routing strategies for aliases: simple and terminal. A simple alias points to an active fleet. A terminal alias displays a message instead of routing players to an active fleet. For example, a terminal alias might display a URL link that directs players to an upgrade site. You can use aliases to define destinations in a game session queue or when requesting new game sessions.
 *
 * @cloudformationResource AWS::GameLift::Alias
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-alias.html
 */
class CfnAlias extends cdk.CfnResource {
    /**
     * Create a new `AWS::GameLift::Alias`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnAlias.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_gamelift_CfnAliasProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        cdk.requireProperty(props, 'name', this);
        cdk.requireProperty(props, 'routingStrategy', this);
        this.attrAliasId = cdk.Token.asString(this.getAtt('AliasId'));
        this.name = props.name;
        this.routingStrategy = props.routingStrategy;
        this.description = props.description;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnAliasPropsFromCloudFormation(resourceProperties);
        const ret = new CfnAlias(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnAlias.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            name: this.name,
            routingStrategy: this.routingStrategy,
            description: this.description,
        };
    }
    renderProperties(props) {
        return cfnAliasPropsToCloudFormation(props);
    }
}
exports.CfnAlias = CfnAlias;
_a = JSII_RTTI_SYMBOL_1;
CfnAlias[_a] = { fqn: "@aws-cdk/aws-gamelift.CfnAlias", version: "1.155.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnAlias.CFN_RESOURCE_TYPE_NAME = "AWS::GameLift::Alias";
/**
 * Determine whether the given properties match those of a `RoutingStrategyProperty`
 *
 * @param properties - the TypeScript properties of a `RoutingStrategyProperty`
 *
 * @returns the result of the validation.
 */
function CfnAlias_RoutingStrategyPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('fleetId', cdk.validateString)(properties.fleetId));
    errors.collect(cdk.propertyValidator('message', cdk.validateString)(properties.message));
    errors.collect(cdk.propertyValidator('type', cdk.requiredValidator)(properties.type));
    errors.collect(cdk.propertyValidator('type', cdk.validateString)(properties.type));
    return errors.wrap('supplied properties not correct for "RoutingStrategyProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::GameLift::Alias.RoutingStrategy` resource
 *
 * @param properties - the TypeScript properties of a `RoutingStrategyProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::GameLift::Alias.RoutingStrategy` resource.
 */
// @ts-ignore TS6133
function cfnAliasRoutingStrategyPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAlias_RoutingStrategyPropertyValidator(properties).assertSuccess();
    return {
        FleetId: cdk.stringToCloudFormation(properties.fleetId),
        Message: cdk.stringToCloudFormation(properties.message),
        Type: cdk.stringToCloudFormation(properties.type),
    };
}
// @ts-ignore TS6133
function CfnAliasRoutingStrategyPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('fleetId', 'FleetId', properties.FleetId != null ? cfn_parse.FromCloudFormation.getString(properties.FleetId) : undefined);
    ret.addPropertyResult('message', 'Message', properties.Message != null ? cfn_parse.FromCloudFormation.getString(properties.Message) : undefined);
    ret.addPropertyResult('type', 'Type', cfn_parse.FromCloudFormation.getString(properties.Type));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnBuildProps`
 *
 * @param properties - the TypeScript properties of a `CfnBuildProps`
 *
 * @returns the result of the validation.
 */
function CfnBuildPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('operatingSystem', cdk.validateString)(properties.operatingSystem));
    errors.collect(cdk.propertyValidator('storageLocation', CfnBuild_S3LocationPropertyValidator)(properties.storageLocation));
    errors.collect(cdk.propertyValidator('version', cdk.validateString)(properties.version));
    return errors.wrap('supplied properties not correct for "CfnBuildProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::GameLift::Build` resource
 *
 * @param properties - the TypeScript properties of a `CfnBuildProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::GameLift::Build` resource.
 */
// @ts-ignore TS6133
function cfnBuildPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnBuildPropsValidator(properties).assertSuccess();
    return {
        Name: cdk.stringToCloudFormation(properties.name),
        OperatingSystem: cdk.stringToCloudFormation(properties.operatingSystem),
        StorageLocation: cfnBuildS3LocationPropertyToCloudFormation(properties.storageLocation),
        Version: cdk.stringToCloudFormation(properties.version),
    };
}
// @ts-ignore TS6133
function CfnBuildPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('name', 'Name', properties.Name != null ? cfn_parse.FromCloudFormation.getString(properties.Name) : undefined);
    ret.addPropertyResult('operatingSystem', 'OperatingSystem', properties.OperatingSystem != null ? cfn_parse.FromCloudFormation.getString(properties.OperatingSystem) : undefined);
    ret.addPropertyResult('storageLocation', 'StorageLocation', properties.StorageLocation != null ? CfnBuildS3LocationPropertyFromCloudFormation(properties.StorageLocation) : undefined);
    ret.addPropertyResult('version', 'Version', properties.Version != null ? cfn_parse.FromCloudFormation.getString(properties.Version) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::GameLift::Build`
 *
 * The `AWS::GameLift::Build` resource creates a game server build that is installed and run on instances in an Amazon GameLift fleet. This resource points to an Amazon S3 location that contains a zip file with all of the components of the game server build.
 *
 * @cloudformationResource AWS::GameLift::Build
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-build.html
 */
class CfnBuild extends cdk.CfnResource {
    /**
     * Create a new `AWS::GameLift::Build`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props = {}) {
        super(scope, id, { type: CfnBuild.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_gamelift_CfnBuildProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        this.name = props.name;
        this.operatingSystem = props.operatingSystem;
        this.storageLocation = props.storageLocation;
        this.version = props.version;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnBuildPropsFromCloudFormation(resourceProperties);
        const ret = new CfnBuild(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnBuild.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            name: this.name,
            operatingSystem: this.operatingSystem,
            storageLocation: this.storageLocation,
            version: this.version,
        };
    }
    renderProperties(props) {
        return cfnBuildPropsToCloudFormation(props);
    }
}
exports.CfnBuild = CfnBuild;
_b = JSII_RTTI_SYMBOL_1;
CfnBuild[_b] = { fqn: "@aws-cdk/aws-gamelift.CfnBuild", version: "1.155.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnBuild.CFN_RESOURCE_TYPE_NAME = "AWS::GameLift::Build";
/**
 * Determine whether the given properties match those of a `S3LocationProperty`
 *
 * @param properties - the TypeScript properties of a `S3LocationProperty`
 *
 * @returns the result of the validation.
 */
function CfnBuild_S3LocationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('bucket', cdk.requiredValidator)(properties.bucket));
    errors.collect(cdk.propertyValidator('bucket', cdk.validateString)(properties.bucket));
    errors.collect(cdk.propertyValidator('key', cdk.requiredValidator)(properties.key));
    errors.collect(cdk.propertyValidator('key', cdk.validateString)(properties.key));
    errors.collect(cdk.propertyValidator('objectVersion', cdk.validateString)(properties.objectVersion));
    errors.collect(cdk.propertyValidator('roleArn', cdk.requiredValidator)(properties.roleArn));
    errors.collect(cdk.propertyValidator('roleArn', cdk.validateString)(properties.roleArn));
    return errors.wrap('supplied properties not correct for "S3LocationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::GameLift::Build.S3Location` resource
 *
 * @param properties - the TypeScript properties of a `S3LocationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::GameLift::Build.S3Location` resource.
 */
// @ts-ignore TS6133
function cfnBuildS3LocationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnBuild_S3LocationPropertyValidator(properties).assertSuccess();
    return {
        Bucket: cdk.stringToCloudFormation(properties.bucket),
        Key: cdk.stringToCloudFormation(properties.key),
        ObjectVersion: cdk.stringToCloudFormation(properties.objectVersion),
        RoleArn: cdk.stringToCloudFormation(properties.roleArn),
    };
}
// @ts-ignore TS6133
function CfnBuildS3LocationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('bucket', 'Bucket', cfn_parse.FromCloudFormation.getString(properties.Bucket));
    ret.addPropertyResult('key', 'Key', cfn_parse.FromCloudFormation.getString(properties.Key));
    ret.addPropertyResult('objectVersion', 'ObjectVersion', properties.ObjectVersion != null ? cfn_parse.FromCloudFormation.getString(properties.ObjectVersion) : undefined);
    ret.addPropertyResult('roleArn', 'RoleArn', cfn_parse.FromCloudFormation.getString(properties.RoleArn));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnFleetProps`
 *
 * @param properties - the TypeScript properties of a `CfnFleetProps`
 *
 * @returns the result of the validation.
 */
function CfnFleetPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('buildId', cdk.validateString)(properties.buildId));
    errors.collect(cdk.propertyValidator('certificateConfiguration', CfnFleet_CertificateConfigurationPropertyValidator)(properties.certificateConfiguration));
    errors.collect(cdk.propertyValidator('description', cdk.validateString)(properties.description));
    errors.collect(cdk.propertyValidator('desiredEc2Instances', cdk.validateNumber)(properties.desiredEc2Instances));
    errors.collect(cdk.propertyValidator('ec2InboundPermissions', cdk.listValidator(CfnFleet_IpPermissionPropertyValidator))(properties.ec2InboundPermissions));
    errors.collect(cdk.propertyValidator('ec2InstanceType', cdk.validateString)(properties.ec2InstanceType));
    errors.collect(cdk.propertyValidator('fleetType', cdk.validateString)(properties.fleetType));
    errors.collect(cdk.propertyValidator('instanceRoleArn', cdk.validateString)(properties.instanceRoleArn));
    errors.collect(cdk.propertyValidator('locations', cdk.listValidator(CfnFleet_LocationConfigurationPropertyValidator))(properties.locations));
    errors.collect(cdk.propertyValidator('maxSize', cdk.validateNumber)(properties.maxSize));
    errors.collect(cdk.propertyValidator('metricGroups', cdk.listValidator(cdk.validateString))(properties.metricGroups));
    errors.collect(cdk.propertyValidator('minSize', cdk.validateNumber)(properties.minSize));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('newGameSessionProtectionPolicy', cdk.validateString)(properties.newGameSessionProtectionPolicy));
    errors.collect(cdk.propertyValidator('peerVpcAwsAccountId', cdk.validateString)(properties.peerVpcAwsAccountId));
    errors.collect(cdk.propertyValidator('peerVpcId', cdk.validateString)(properties.peerVpcId));
    errors.collect(cdk.propertyValidator('resourceCreationLimitPolicy', CfnFleet_ResourceCreationLimitPolicyPropertyValidator)(properties.resourceCreationLimitPolicy));
    errors.collect(cdk.propertyValidator('runtimeConfiguration', CfnFleet_RuntimeConfigurationPropertyValidator)(properties.runtimeConfiguration));
    errors.collect(cdk.propertyValidator('scriptId', cdk.validateString)(properties.scriptId));
    return errors.wrap('supplied properties not correct for "CfnFleetProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::GameLift::Fleet` resource
 *
 * @param properties - the TypeScript properties of a `CfnFleetProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::GameLift::Fleet` resource.
 */
// @ts-ignore TS6133
function cfnFleetPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnFleetPropsValidator(properties).assertSuccess();
    return {
        BuildId: cdk.stringToCloudFormation(properties.buildId),
        CertificateConfiguration: cfnFleetCertificateConfigurationPropertyToCloudFormation(properties.certificateConfiguration),
        Description: cdk.stringToCloudFormation(properties.description),
        DesiredEC2Instances: cdk.numberToCloudFormation(properties.desiredEc2Instances),
        EC2InboundPermissions: cdk.listMapper(cfnFleetIpPermissionPropertyToCloudFormation)(properties.ec2InboundPermissions),
        EC2InstanceType: cdk.stringToCloudFormation(properties.ec2InstanceType),
        FleetType: cdk.stringToCloudFormation(properties.fleetType),
        InstanceRoleARN: cdk.stringToCloudFormation(properties.instanceRoleArn),
        Locations: cdk.listMapper(cfnFleetLocationConfigurationPropertyToCloudFormation)(properties.locations),
        MaxSize: cdk.numberToCloudFormation(properties.maxSize),
        MetricGroups: cdk.listMapper(cdk.stringToCloudFormation)(properties.metricGroups),
        MinSize: cdk.numberToCloudFormation(properties.minSize),
        Name: cdk.stringToCloudFormation(properties.name),
        NewGameSessionProtectionPolicy: cdk.stringToCloudFormation(properties.newGameSessionProtectionPolicy),
        PeerVpcAwsAccountId: cdk.stringToCloudFormation(properties.peerVpcAwsAccountId),
        PeerVpcId: cdk.stringToCloudFormation(properties.peerVpcId),
        ResourceCreationLimitPolicy: cfnFleetResourceCreationLimitPolicyPropertyToCloudFormation(properties.resourceCreationLimitPolicy),
        RuntimeConfiguration: cfnFleetRuntimeConfigurationPropertyToCloudFormation(properties.runtimeConfiguration),
        ScriptId: cdk.stringToCloudFormation(properties.scriptId),
    };
}
// @ts-ignore TS6133
function CfnFleetPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('buildId', 'BuildId', properties.BuildId != null ? cfn_parse.FromCloudFormation.getString(properties.BuildId) : undefined);
    ret.addPropertyResult('certificateConfiguration', 'CertificateConfiguration', properties.CertificateConfiguration != null ? CfnFleetCertificateConfigurationPropertyFromCloudFormation(properties.CertificateConfiguration) : undefined);
    ret.addPropertyResult('description', 'Description', properties.Description != null ? cfn_parse.FromCloudFormation.getString(properties.Description) : undefined);
    ret.addPropertyResult('desiredEc2Instances', 'DesiredEC2Instances', properties.DesiredEC2Instances != null ? cfn_parse.FromCloudFormation.getNumber(properties.DesiredEC2Instances) : undefined);
    ret.addPropertyResult('ec2InboundPermissions', 'EC2InboundPermissions', properties.EC2InboundPermissions != null ? cfn_parse.FromCloudFormation.getArray(CfnFleetIpPermissionPropertyFromCloudFormation)(properties.EC2InboundPermissions) : undefined);
    ret.addPropertyResult('ec2InstanceType', 'EC2InstanceType', properties.EC2InstanceType != null ? cfn_parse.FromCloudFormation.getString(properties.EC2InstanceType) : undefined);
    ret.addPropertyResult('fleetType', 'FleetType', properties.FleetType != null ? cfn_parse.FromCloudFormation.getString(properties.FleetType) : undefined);
    ret.addPropertyResult('instanceRoleArn', 'InstanceRoleARN', properties.InstanceRoleARN != null ? cfn_parse.FromCloudFormation.getString(properties.InstanceRoleARN) : undefined);
    ret.addPropertyResult('locations', 'Locations', properties.Locations != null ? cfn_parse.FromCloudFormation.getArray(CfnFleetLocationConfigurationPropertyFromCloudFormation)(properties.Locations) : undefined);
    ret.addPropertyResult('maxSize', 'MaxSize', properties.MaxSize != null ? cfn_parse.FromCloudFormation.getNumber(properties.MaxSize) : undefined);
    ret.addPropertyResult('metricGroups', 'MetricGroups', properties.MetricGroups != null ? cfn_parse.FromCloudFormation.getStringArray(properties.MetricGroups) : undefined);
    ret.addPropertyResult('minSize', 'MinSize', properties.MinSize != null ? cfn_parse.FromCloudFormation.getNumber(properties.MinSize) : undefined);
    ret.addPropertyResult('name', 'Name', properties.Name != null ? cfn_parse.FromCloudFormation.getString(properties.Name) : undefined);
    ret.addPropertyResult('newGameSessionProtectionPolicy', 'NewGameSessionProtectionPolicy', properties.NewGameSessionProtectionPolicy != null ? cfn_parse.FromCloudFormation.getString(properties.NewGameSessionProtectionPolicy) : undefined);
    ret.addPropertyResult('peerVpcAwsAccountId', 'PeerVpcAwsAccountId', properties.PeerVpcAwsAccountId != null ? cfn_parse.FromCloudFormation.getString(properties.PeerVpcAwsAccountId) : undefined);
    ret.addPropertyResult('peerVpcId', 'PeerVpcId', properties.PeerVpcId != null ? cfn_parse.FromCloudFormation.getString(properties.PeerVpcId) : undefined);
    ret.addPropertyResult('resourceCreationLimitPolicy', 'ResourceCreationLimitPolicy', properties.ResourceCreationLimitPolicy != null ? CfnFleetResourceCreationLimitPolicyPropertyFromCloudFormation(properties.ResourceCreationLimitPolicy) : undefined);
    ret.addPropertyResult('runtimeConfiguration', 'RuntimeConfiguration', properties.RuntimeConfiguration != null ? CfnFleetRuntimeConfigurationPropertyFromCloudFormation(properties.RuntimeConfiguration) : undefined);
    ret.addPropertyResult('scriptId', 'ScriptId', properties.ScriptId != null ? cfn_parse.FromCloudFormation.getString(properties.ScriptId) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::GameLift::Fleet`
 *
 * The `AWS::GameLift::Fleet` resource creates an Amazon GameLift (GameLift) fleet to host game servers. A fleet is a set of EC2 instances, each of which can host multiple game sessions.
 *
 * @cloudformationResource AWS::GameLift::Fleet
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html
 */
class CfnFleet extends cdk.CfnResource {
    /**
     * Create a new `AWS::GameLift::Fleet`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props = {}) {
        super(scope, id, { type: CfnFleet.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_gamelift_CfnFleetProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        this.attrFleetId = cdk.Token.asString(this.getAtt('FleetId'));
        this.buildId = props.buildId;
        this.certificateConfiguration = props.certificateConfiguration;
        this.description = props.description;
        this.desiredEc2Instances = props.desiredEc2Instances;
        this.ec2InboundPermissions = props.ec2InboundPermissions;
        this.ec2InstanceType = props.ec2InstanceType;
        this.fleetType = props.fleetType;
        this.instanceRoleArn = props.instanceRoleArn;
        this.locations = props.locations;
        this.maxSize = props.maxSize;
        this.metricGroups = props.metricGroups;
        this.minSize = props.minSize;
        this.name = props.name;
        this.newGameSessionProtectionPolicy = props.newGameSessionProtectionPolicy;
        this.peerVpcAwsAccountId = props.peerVpcAwsAccountId;
        this.peerVpcId = props.peerVpcId;
        this.resourceCreationLimitPolicy = props.resourceCreationLimitPolicy;
        this.runtimeConfiguration = props.runtimeConfiguration;
        this.scriptId = props.scriptId;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnFleetPropsFromCloudFormation(resourceProperties);
        const ret = new CfnFleet(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnFleet.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            buildId: this.buildId,
            certificateConfiguration: this.certificateConfiguration,
            description: this.description,
            desiredEc2Instances: this.desiredEc2Instances,
            ec2InboundPermissions: this.ec2InboundPermissions,
            ec2InstanceType: this.ec2InstanceType,
            fleetType: this.fleetType,
            instanceRoleArn: this.instanceRoleArn,
            locations: this.locations,
            maxSize: this.maxSize,
            metricGroups: this.metricGroups,
            minSize: this.minSize,
            name: this.name,
            newGameSessionProtectionPolicy: this.newGameSessionProtectionPolicy,
            peerVpcAwsAccountId: this.peerVpcAwsAccountId,
            peerVpcId: this.peerVpcId,
            resourceCreationLimitPolicy: this.resourceCreationLimitPolicy,
            runtimeConfiguration: this.runtimeConfiguration,
            scriptId: this.scriptId,
        };
    }
    renderProperties(props) {
        return cfnFleetPropsToCloudFormation(props);
    }
}
exports.CfnFleet = CfnFleet;
_c = JSII_RTTI_SYMBOL_1;
CfnFleet[_c] = { fqn: "@aws-cdk/aws-gamelift.CfnFleet", version: "1.155.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnFleet.CFN_RESOURCE_TYPE_NAME = "AWS::GameLift::Fleet";
/**
 * Determine whether the given properties match those of a `CertificateConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `CertificateConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnFleet_CertificateConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('certificateType', cdk.requiredValidator)(properties.certificateType));
    errors.collect(cdk.propertyValidator('certificateType', cdk.validateString)(properties.certificateType));
    return errors.wrap('supplied properties not correct for "CertificateConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::GameLift::Fleet.CertificateConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `CertificateConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::GameLift::Fleet.CertificateConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnFleetCertificateConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnFleet_CertificateConfigurationPropertyValidator(properties).assertSuccess();
    return {
        CertificateType: cdk.stringToCloudFormation(properties.certificateType),
    };
}
// @ts-ignore TS6133
function CfnFleetCertificateConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('certificateType', 'CertificateType', cfn_parse.FromCloudFormation.getString(properties.CertificateType));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `IpPermissionProperty`
 *
 * @param properties - the TypeScript properties of a `IpPermissionProperty`
 *
 * @returns the result of the validation.
 */
function CfnFleet_IpPermissionPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('fromPort', cdk.requiredValidator)(properties.fromPort));
    errors.collect(cdk.propertyValidator('fromPort', cdk.validateNumber)(properties.fromPort));
    errors.collect(cdk.propertyValidator('ipRange', cdk.requiredValidator)(properties.ipRange));
    errors.collect(cdk.propertyValidator('ipRange', cdk.validateString)(properties.ipRange));
    errors.collect(cdk.propertyValidator('protocol', cdk.requiredValidator)(properties.protocol));
    errors.collect(cdk.propertyValidator('protocol', cdk.validateString)(properties.protocol));
    errors.collect(cdk.propertyValidator('toPort', cdk.requiredValidator)(properties.toPort));
    errors.collect(cdk.propertyValidator('toPort', cdk.validateNumber)(properties.toPort));
    return errors.wrap('supplied properties not correct for "IpPermissionProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::GameLift::Fleet.IpPermission` resource
 *
 * @param properties - the TypeScript properties of a `IpPermissionProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::GameLift::Fleet.IpPermission` resource.
 */
// @ts-ignore TS6133
function cfnFleetIpPermissionPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnFleet_IpPermissionPropertyValidator(properties).assertSuccess();
    return {
        FromPort: cdk.numberToCloudFormation(properties.fromPort),
        IpRange: cdk.stringToCloudFormation(properties.ipRange),
        Protocol: cdk.stringToCloudFormation(properties.protocol),
        ToPort: cdk.numberToCloudFormation(properties.toPort),
    };
}
// @ts-ignore TS6133
function CfnFleetIpPermissionPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('fromPort', 'FromPort', cfn_parse.FromCloudFormation.getNumber(properties.FromPort));
    ret.addPropertyResult('ipRange', 'IpRange', cfn_parse.FromCloudFormation.getString(properties.IpRange));
    ret.addPropertyResult('protocol', 'Protocol', cfn_parse.FromCloudFormation.getString(properties.Protocol));
    ret.addPropertyResult('toPort', 'ToPort', cfn_parse.FromCloudFormation.getNumber(properties.ToPort));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `LocationCapacityProperty`
 *
 * @param properties - the TypeScript properties of a `LocationCapacityProperty`
 *
 * @returns the result of the validation.
 */
function CfnFleet_LocationCapacityPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('desiredEc2Instances', cdk.requiredValidator)(properties.desiredEc2Instances));
    errors.collect(cdk.propertyValidator('desiredEc2Instances', cdk.validateNumber)(properties.desiredEc2Instances));
    errors.collect(cdk.propertyValidator('maxSize', cdk.requiredValidator)(properties.maxSize));
    errors.collect(cdk.propertyValidator('maxSize', cdk.validateNumber)(properties.maxSize));
    errors.collect(cdk.propertyValidator('minSize', cdk.requiredValidator)(properties.minSize));
    errors.collect(cdk.propertyValidator('minSize', cdk.validateNumber)(properties.minSize));
    return errors.wrap('supplied properties not correct for "LocationCapacityProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::GameLift::Fleet.LocationCapacity` resource
 *
 * @param properties - the TypeScript properties of a `LocationCapacityProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::GameLift::Fleet.LocationCapacity` resource.
 */
// @ts-ignore TS6133
function cfnFleetLocationCapacityPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnFleet_LocationCapacityPropertyValidator(properties).assertSuccess();
    return {
        DesiredEC2Instances: cdk.numberToCloudFormation(properties.desiredEc2Instances),
        MaxSize: cdk.numberToCloudFormation(properties.maxSize),
        MinSize: cdk.numberToCloudFormation(properties.minSize),
    };
}
// @ts-ignore TS6133
function CfnFleetLocationCapacityPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('desiredEc2Instances', 'DesiredEC2Instances', cfn_parse.FromCloudFormation.getNumber(properties.DesiredEC2Instances));
    ret.addPropertyResult('maxSize', 'MaxSize', cfn_parse.FromCloudFormation.getNumber(properties.MaxSize));
    ret.addPropertyResult('minSize', 'MinSize', cfn_parse.FromCloudFormation.getNumber(properties.MinSize));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `LocationConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `LocationConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnFleet_LocationConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('location', cdk.requiredValidator)(properties.location));
    errors.collect(cdk.propertyValidator('location', cdk.validateString)(properties.location));
    errors.collect(cdk.propertyValidator('locationCapacity', CfnFleet_LocationCapacityPropertyValidator)(properties.locationCapacity));
    return errors.wrap('supplied properties not correct for "LocationConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::GameLift::Fleet.LocationConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `LocationConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::GameLift::Fleet.LocationConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnFleetLocationConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnFleet_LocationConfigurationPropertyValidator(properties).assertSuccess();
    return {
        Location: cdk.stringToCloudFormation(properties.location),
        LocationCapacity: cfnFleetLocationCapacityPropertyToCloudFormation(properties.locationCapacity),
    };
}
// @ts-ignore TS6133
function CfnFleetLocationConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('location', 'Location', cfn_parse.FromCloudFormation.getString(properties.Location));
    ret.addPropertyResult('locationCapacity', 'LocationCapacity', properties.LocationCapacity != null ? CfnFleetLocationCapacityPropertyFromCloudFormation(properties.LocationCapacity) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ResourceCreationLimitPolicyProperty`
 *
 * @param properties - the TypeScript properties of a `ResourceCreationLimitPolicyProperty`
 *
 * @returns the result of the validation.
 */
function CfnFleet_ResourceCreationLimitPolicyPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('newGameSessionsPerCreator', cdk.validateNumber)(properties.newGameSessionsPerCreator));
    errors.collect(cdk.propertyValidator('policyPeriodInMinutes', cdk.validateNumber)(properties.policyPeriodInMinutes));
    return errors.wrap('supplied properties not correct for "ResourceCreationLimitPolicyProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::GameLift::Fleet.ResourceCreationLimitPolicy` resource
 *
 * @param properties - the TypeScript properties of a `ResourceCreationLimitPolicyProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::GameLift::Fleet.ResourceCreationLimitPolicy` resource.
 */
// @ts-ignore TS6133
function cfnFleetResourceCreationLimitPolicyPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnFleet_ResourceCreationLimitPolicyPropertyValidator(properties).assertSuccess();
    return {
        NewGameSessionsPerCreator: cdk.numberToCloudFormation(properties.newGameSessionsPerCreator),
        PolicyPeriodInMinutes: cdk.numberToCloudFormation(properties.policyPeriodInMinutes),
    };
}
// @ts-ignore TS6133
function CfnFleetResourceCreationLimitPolicyPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('newGameSessionsPerCreator', 'NewGameSessionsPerCreator', properties.NewGameSessionsPerCreator != null ? cfn_parse.FromCloudFormation.getNumber(properties.NewGameSessionsPerCreator) : undefined);
    ret.addPropertyResult('policyPeriodInMinutes', 'PolicyPeriodInMinutes', properties.PolicyPeriodInMinutes != null ? cfn_parse.FromCloudFormation.getNumber(properties.PolicyPeriodInMinutes) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `RuntimeConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `RuntimeConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnFleet_RuntimeConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('gameSessionActivationTimeoutSeconds', cdk.validateNumber)(properties.gameSessionActivationTimeoutSeconds));
    errors.collect(cdk.propertyValidator('maxConcurrentGameSessionActivations', cdk.validateNumber)(properties.maxConcurrentGameSessionActivations));
    errors.collect(cdk.propertyValidator('serverProcesses', cdk.listValidator(CfnFleet_ServerProcessPropertyValidator))(properties.serverProcesses));
    return errors.wrap('supplied properties not correct for "RuntimeConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::GameLift::Fleet.RuntimeConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `RuntimeConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::GameLift::Fleet.RuntimeConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnFleetRuntimeConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnFleet_RuntimeConfigurationPropertyValidator(properties).assertSuccess();
    return {
        GameSessionActivationTimeoutSeconds: cdk.numberToCloudFormation(properties.gameSessionActivationTimeoutSeconds),
        MaxConcurrentGameSessionActivations: cdk.numberToCloudFormation(properties.maxConcurrentGameSessionActivations),
        ServerProcesses: cdk.listMapper(cfnFleetServerProcessPropertyToCloudFormation)(properties.serverProcesses),
    };
}
// @ts-ignore TS6133
function CfnFleetRuntimeConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('gameSessionActivationTimeoutSeconds', 'GameSessionActivationTimeoutSeconds', properties.GameSessionActivationTimeoutSeconds != null ? cfn_parse.FromCloudFormation.getNumber(properties.GameSessionActivationTimeoutSeconds) : undefined);
    ret.addPropertyResult('maxConcurrentGameSessionActivations', 'MaxConcurrentGameSessionActivations', properties.MaxConcurrentGameSessionActivations != null ? cfn_parse.FromCloudFormation.getNumber(properties.MaxConcurrentGameSessionActivations) : undefined);
    ret.addPropertyResult('serverProcesses', 'ServerProcesses', properties.ServerProcesses != null ? cfn_parse.FromCloudFormation.getArray(CfnFleetServerProcessPropertyFromCloudFormation)(properties.ServerProcesses) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ServerProcessProperty`
 *
 * @param properties - the TypeScript properties of a `ServerProcessProperty`
 *
 * @returns the result of the validation.
 */
function CfnFleet_ServerProcessPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('concurrentExecutions', cdk.requiredValidator)(properties.concurrentExecutions));
    errors.collect(cdk.propertyValidator('concurrentExecutions', cdk.validateNumber)(properties.concurrentExecutions));
    errors.collect(cdk.propertyValidator('launchPath', cdk.requiredValidator)(properties.launchPath));
    errors.collect(cdk.propertyValidator('launchPath', cdk.validateString)(properties.launchPath));
    errors.collect(cdk.propertyValidator('parameters', cdk.validateString)(properties.parameters));
    return errors.wrap('supplied properties not correct for "ServerProcessProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::GameLift::Fleet.ServerProcess` resource
 *
 * @param properties - the TypeScript properties of a `ServerProcessProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::GameLift::Fleet.ServerProcess` resource.
 */
// @ts-ignore TS6133
function cfnFleetServerProcessPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnFleet_ServerProcessPropertyValidator(properties).assertSuccess();
    return {
        ConcurrentExecutions: cdk.numberToCloudFormation(properties.concurrentExecutions),
        LaunchPath: cdk.stringToCloudFormation(properties.launchPath),
        Parameters: cdk.stringToCloudFormation(properties.parameters),
    };
}
// @ts-ignore TS6133
function CfnFleetServerProcessPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('concurrentExecutions', 'ConcurrentExecutions', cfn_parse.FromCloudFormation.getNumber(properties.ConcurrentExecutions));
    ret.addPropertyResult('launchPath', 'LaunchPath', cfn_parse.FromCloudFormation.getString(properties.LaunchPath));
    ret.addPropertyResult('parameters', 'Parameters', properties.Parameters != null ? cfn_parse.FromCloudFormation.getString(properties.Parameters) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnGameServerGroupProps`
 *
 * @param properties - the TypeScript properties of a `CfnGameServerGroupProps`
 *
 * @returns the result of the validation.
 */
function CfnGameServerGroupPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('autoScalingPolicy', CfnGameServerGroup_AutoScalingPolicyPropertyValidator)(properties.autoScalingPolicy));
    errors.collect(cdk.propertyValidator('balancingStrategy', cdk.validateString)(properties.balancingStrategy));
    errors.collect(cdk.propertyValidator('deleteOption', cdk.validateString)(properties.deleteOption));
    errors.collect(cdk.propertyValidator('gameServerGroupName', cdk.requiredValidator)(properties.gameServerGroupName));
    errors.collect(cdk.propertyValidator('gameServerGroupName', cdk.validateString)(properties.gameServerGroupName));
    errors.collect(cdk.propertyValidator('gameServerProtectionPolicy', cdk.validateString)(properties.gameServerProtectionPolicy));
    errors.collect(cdk.propertyValidator('instanceDefinitions', cdk.requiredValidator)(properties.instanceDefinitions));
    errors.collect(cdk.propertyValidator('instanceDefinitions', cdk.listValidator(CfnGameServerGroup_InstanceDefinitionPropertyValidator))(properties.instanceDefinitions));
    errors.collect(cdk.propertyValidator('launchTemplate', cdk.requiredValidator)(properties.launchTemplate));
    errors.collect(cdk.propertyValidator('launchTemplate', CfnGameServerGroup_LaunchTemplatePropertyValidator)(properties.launchTemplate));
    errors.collect(cdk.propertyValidator('maxSize', cdk.validateNumber)(properties.maxSize));
    errors.collect(cdk.propertyValidator('minSize', cdk.validateNumber)(properties.minSize));
    errors.collect(cdk.propertyValidator('roleArn', cdk.requiredValidator)(properties.roleArn));
    errors.collect(cdk.propertyValidator('roleArn', cdk.validateString)(properties.roleArn));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    errors.collect(cdk.propertyValidator('vpcSubnets', cdk.listValidator(cdk.validateString))(properties.vpcSubnets));
    return errors.wrap('supplied properties not correct for "CfnGameServerGroupProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::GameLift::GameServerGroup` resource
 *
 * @param properties - the TypeScript properties of a `CfnGameServerGroupProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::GameLift::GameServerGroup` resource.
 */
// @ts-ignore TS6133
function cfnGameServerGroupPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnGameServerGroupPropsValidator(properties).assertSuccess();
    return {
        GameServerGroupName: cdk.stringToCloudFormation(properties.gameServerGroupName),
        InstanceDefinitions: cdk.listMapper(cfnGameServerGroupInstanceDefinitionPropertyToCloudFormation)(properties.instanceDefinitions),
        LaunchTemplate: cfnGameServerGroupLaunchTemplatePropertyToCloudFormation(properties.launchTemplate),
        RoleArn: cdk.stringToCloudFormation(properties.roleArn),
        AutoScalingPolicy: cfnGameServerGroupAutoScalingPolicyPropertyToCloudFormation(properties.autoScalingPolicy),
        BalancingStrategy: cdk.stringToCloudFormation(properties.balancingStrategy),
        DeleteOption: cdk.stringToCloudFormation(properties.deleteOption),
        GameServerProtectionPolicy: cdk.stringToCloudFormation(properties.gameServerProtectionPolicy),
        MaxSize: cdk.numberToCloudFormation(properties.maxSize),
        MinSize: cdk.numberToCloudFormation(properties.minSize),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
        VpcSubnets: cdk.listMapper(cdk.stringToCloudFormation)(properties.vpcSubnets),
    };
}
// @ts-ignore TS6133
function CfnGameServerGroupPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('gameServerGroupName', 'GameServerGroupName', cfn_parse.FromCloudFormation.getString(properties.GameServerGroupName));
    ret.addPropertyResult('instanceDefinitions', 'InstanceDefinitions', cfn_parse.FromCloudFormation.getArray(CfnGameServerGroupInstanceDefinitionPropertyFromCloudFormation)(properties.InstanceDefinitions));
    ret.addPropertyResult('launchTemplate', 'LaunchTemplate', CfnGameServerGroupLaunchTemplatePropertyFromCloudFormation(properties.LaunchTemplate));
    ret.addPropertyResult('roleArn', 'RoleArn', cfn_parse.FromCloudFormation.getString(properties.RoleArn));
    ret.addPropertyResult('autoScalingPolicy', 'AutoScalingPolicy', properties.AutoScalingPolicy != null ? CfnGameServerGroupAutoScalingPolicyPropertyFromCloudFormation(properties.AutoScalingPolicy) : undefined);
    ret.addPropertyResult('balancingStrategy', 'BalancingStrategy', properties.BalancingStrategy != null ? cfn_parse.FromCloudFormation.getString(properties.BalancingStrategy) : undefined);
    ret.addPropertyResult('deleteOption', 'DeleteOption', properties.DeleteOption != null ? cfn_parse.FromCloudFormation.getString(properties.DeleteOption) : undefined);
    ret.addPropertyResult('gameServerProtectionPolicy', 'GameServerProtectionPolicy', properties.GameServerProtectionPolicy != null ? cfn_parse.FromCloudFormation.getString(properties.GameServerProtectionPolicy) : undefined);
    ret.addPropertyResult('maxSize', 'MaxSize', properties.MaxSize != null ? cfn_parse.FromCloudFormation.getNumber(properties.MaxSize) : undefined);
    ret.addPropertyResult('minSize', 'MinSize', properties.MinSize != null ? cfn_parse.FromCloudFormation.getNumber(properties.MinSize) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addPropertyResult('vpcSubnets', 'VpcSubnets', properties.VpcSubnets != null ? cfn_parse.FromCloudFormation.getStringArray(properties.VpcSubnets) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::GameLift::GameServerGroup`
 *
 * *This operation is used with the Amazon GameLift FleetIQ solution and game server groups.*
 *
 * Creates a GameLift FleetIQ game server group for managing game hosting on a collection of Amazon EC2 instances for game hosting. This operation creates the game server group, creates an Auto Scaling group in your AWS account , and establishes a link between the two groups. You can view the status of your game server groups in the GameLift console. Game server group metrics and events are emitted to Amazon CloudWatch.
 *
 * Before creating a new game server group, you must have the following:
 *
 * - An Amazon EC2 launch template that specifies how to launch Amazon EC2 instances with your game server build. For more information, see [Launching an Instance from a Launch Template](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html) in the *Amazon EC2 User Guide* .
 * - An IAM role that extends limited access to your AWS account to allow GameLift FleetIQ to create and interact with the Auto Scaling group. For more information, see [Create IAM roles for cross-service interaction](https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-iam-permissions-roles.html) in the *GameLift FleetIQ Developer Guide* .
 *
 * To create a new game server group, specify a unique group name, IAM role and Amazon EC2 launch template, and provide a list of instance types that can be used in the group. You must also set initial maximum and minimum limits on the group's instance count. You can optionally set an Auto Scaling policy with target tracking based on a GameLift FleetIQ metric.
 *
 * Once the game server group and corresponding Auto Scaling group are created, you have full access to change the Auto Scaling group's configuration as needed. Several properties that are set when creating a game server group, including maximum/minimum size and auto-scaling policy settings, must be updated directly in the Auto Scaling group. Keep in mind that some Auto Scaling group properties are periodically updated by GameLift FleetIQ as part of its balancing activities to optimize for availability and cost.
 *
 * *Learn more*
 *
 * [GameLift FleetIQ Guide](https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html)
 *
 * @cloudformationResource AWS::GameLift::GameServerGroup
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-gameservergroup.html
 */
class CfnGameServerGroup extends cdk.CfnResource {
    /**
     * Create a new `AWS::GameLift::GameServerGroup`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnGameServerGroup.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_gamelift_CfnGameServerGroupProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        cdk.requireProperty(props, 'gameServerGroupName', this);
        cdk.requireProperty(props, 'instanceDefinitions', this);
        cdk.requireProperty(props, 'launchTemplate', this);
        cdk.requireProperty(props, 'roleArn', this);
        this.attrAutoScalingGroupArn = cdk.Token.asString(this.getAtt('AutoScalingGroupArn'));
        this.attrGameServerGroupArn = cdk.Token.asString(this.getAtt('GameServerGroupArn'));
        this.gameServerGroupName = props.gameServerGroupName;
        this.instanceDefinitions = props.instanceDefinitions;
        this.launchTemplate = props.launchTemplate;
        this.roleArn = props.roleArn;
        this.autoScalingPolicy = props.autoScalingPolicy;
        this.balancingStrategy = props.balancingStrategy;
        this.deleteOption = props.deleteOption;
        this.gameServerProtectionPolicy = props.gameServerProtectionPolicy;
        this.maxSize = props.maxSize;
        this.minSize = props.minSize;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::GameLift::GameServerGroup", props.tags, { tagPropertyName: 'tags' });
        this.vpcSubnets = props.vpcSubnets;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnGameServerGroupPropsFromCloudFormation(resourceProperties);
        const ret = new CfnGameServerGroup(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnGameServerGroup.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            gameServerGroupName: this.gameServerGroupName,
            instanceDefinitions: this.instanceDefinitions,
            launchTemplate: this.launchTemplate,
            roleArn: this.roleArn,
            autoScalingPolicy: this.autoScalingPolicy,
            balancingStrategy: this.balancingStrategy,
            deleteOption: this.deleteOption,
            gameServerProtectionPolicy: this.gameServerProtectionPolicy,
            maxSize: this.maxSize,
            minSize: this.minSize,
            tags: this.tags.renderTags(),
            vpcSubnets: this.vpcSubnets,
        };
    }
    renderProperties(props) {
        return cfnGameServerGroupPropsToCloudFormation(props);
    }
}
exports.CfnGameServerGroup = CfnGameServerGroup;
_d = JSII_RTTI_SYMBOL_1;
CfnGameServerGroup[_d] = { fqn: "@aws-cdk/aws-gamelift.CfnGameServerGroup", version: "1.155.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnGameServerGroup.CFN_RESOURCE_TYPE_NAME = "AWS::GameLift::GameServerGroup";
/**
 * Determine whether the given properties match those of a `AutoScalingPolicyProperty`
 *
 * @param properties - the TypeScript properties of a `AutoScalingPolicyProperty`
 *
 * @returns the result of the validation.
 */
function CfnGameServerGroup_AutoScalingPolicyPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('estimatedInstanceWarmup', cdk.validateNumber)(properties.estimatedInstanceWarmup));
    errors.collect(cdk.propertyValidator('targetTrackingConfiguration', cdk.requiredValidator)(properties.targetTrackingConfiguration));
    errors.collect(cdk.propertyValidator('targetTrackingConfiguration', CfnGameServerGroup_TargetTrackingConfigurationPropertyValidator)(properties.targetTrackingConfiguration));
    return errors.wrap('supplied properties not correct for "AutoScalingPolicyProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::GameLift::GameServerGroup.AutoScalingPolicy` resource
 *
 * @param properties - the TypeScript properties of a `AutoScalingPolicyProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::GameLift::GameServerGroup.AutoScalingPolicy` resource.
 */
// @ts-ignore TS6133
function cfnGameServerGroupAutoScalingPolicyPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnGameServerGroup_AutoScalingPolicyPropertyValidator(properties).assertSuccess();
    return {
        EstimatedInstanceWarmup: cdk.numberToCloudFormation(properties.estimatedInstanceWarmup),
        TargetTrackingConfiguration: cfnGameServerGroupTargetTrackingConfigurationPropertyToCloudFormation(properties.targetTrackingConfiguration),
    };
}
// @ts-ignore TS6133
function CfnGameServerGroupAutoScalingPolicyPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('estimatedInstanceWarmup', 'EstimatedInstanceWarmup', properties.EstimatedInstanceWarmup != null ? cfn_parse.FromCloudFormation.getNumber(properties.EstimatedInstanceWarmup) : undefined);
    ret.addPropertyResult('targetTrackingConfiguration', 'TargetTrackingConfiguration', CfnGameServerGroupTargetTrackingConfigurationPropertyFromCloudFormation(properties.TargetTrackingConfiguration));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `InstanceDefinitionProperty`
 *
 * @param properties - the TypeScript properties of a `InstanceDefinitionProperty`
 *
 * @returns the result of the validation.
 */
function CfnGameServerGroup_InstanceDefinitionPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('instanceType', cdk.requiredValidator)(properties.instanceType));
    errors.collect(cdk.propertyValidator('instanceType', cdk.validateString)(properties.instanceType));
    errors.collect(cdk.propertyValidator('weightedCapacity', cdk.validateString)(properties.weightedCapacity));
    return errors.wrap('supplied properties not correct for "InstanceDefinitionProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::GameLift::GameServerGroup.InstanceDefinition` resource
 *
 * @param properties - the TypeScript properties of a `InstanceDefinitionProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::GameLift::GameServerGroup.InstanceDefinition` resource.
 */
// @ts-ignore TS6133
function cfnGameServerGroupInstanceDefinitionPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnGameServerGroup_InstanceDefinitionPropertyValidator(properties).assertSuccess();
    return {
        InstanceType: cdk.stringToCloudFormation(properties.instanceType),
        WeightedCapacity: cdk.stringToCloudFormation(properties.weightedCapacity),
    };
}
// @ts-ignore TS6133
function CfnGameServerGroupInstanceDefinitionPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('instanceType', 'InstanceType', cfn_parse.FromCloudFormation.getString(properties.InstanceType));
    ret.addPropertyResult('weightedCapacity', 'WeightedCapacity', properties.WeightedCapacity != null ? cfn_parse.FromCloudFormation.getString(properties.WeightedCapacity) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `LaunchTemplateProperty`
 *
 * @param properties - the TypeScript properties of a `LaunchTemplateProperty`
 *
 * @returns the result of the validation.
 */
function CfnGameServerGroup_LaunchTemplatePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('launchTemplateId', cdk.validateString)(properties.launchTemplateId));
    errors.collect(cdk.propertyValidator('launchTemplateName', cdk.validateString)(properties.launchTemplateName));
    errors.collect(cdk.propertyValidator('version', cdk.validateString)(properties.version));
    return errors.wrap('supplied properties not correct for "LaunchTemplateProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::GameLift::GameServerGroup.LaunchTemplate` resource
 *
 * @param properties - the TypeScript properties of a `LaunchTemplateProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::GameLift::GameServerGroup.LaunchTemplate` resource.
 */
// @ts-ignore TS6133
function cfnGameServerGroupLaunchTemplatePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnGameServerGroup_LaunchTemplatePropertyValidator(properties).assertSuccess();
    return {
        LaunchTemplateId: cdk.stringToCloudFormation(properties.launchTemplateId),
        LaunchTemplateName: cdk.stringToCloudFormation(properties.launchTemplateName),
        Version: cdk.stringToCloudFormation(properties.version),
    };
}
// @ts-ignore TS6133
function CfnGameServerGroupLaunchTemplatePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('launchTemplateId', 'LaunchTemplateId', properties.LaunchTemplateId != null ? cfn_parse.FromCloudFormation.getString(properties.LaunchTemplateId) : undefined);
    ret.addPropertyResult('launchTemplateName', 'LaunchTemplateName', properties.LaunchTemplateName != null ? cfn_parse.FromCloudFormation.getString(properties.LaunchTemplateName) : undefined);
    ret.addPropertyResult('version', 'Version', properties.Version != null ? cfn_parse.FromCloudFormation.getString(properties.Version) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `TargetTrackingConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `TargetTrackingConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnGameServerGroup_TargetTrackingConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('targetValue', cdk.requiredValidator)(properties.targetValue));
    errors.collect(cdk.propertyValidator('targetValue', cdk.validateNumber)(properties.targetValue));
    return errors.wrap('supplied properties not correct for "TargetTrackingConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::GameLift::GameServerGroup.TargetTrackingConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `TargetTrackingConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::GameLift::GameServerGroup.TargetTrackingConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnGameServerGroupTargetTrackingConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnGameServerGroup_TargetTrackingConfigurationPropertyValidator(properties).assertSuccess();
    return {
        TargetValue: cdk.numberToCloudFormation(properties.targetValue),
    };
}
// @ts-ignore TS6133
function CfnGameServerGroupTargetTrackingConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('targetValue', 'TargetValue', cfn_parse.FromCloudFormation.getNumber(properties.TargetValue));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnGameSessionQueueProps`
 *
 * @param properties - the TypeScript properties of a `CfnGameSessionQueueProps`
 *
 * @returns the result of the validation.
 */
function CfnGameSessionQueuePropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('customEventData', cdk.validateString)(properties.customEventData));
    errors.collect(cdk.propertyValidator('destinations', cdk.listValidator(CfnGameSessionQueue_DestinationPropertyValidator))(properties.destinations));
    errors.collect(cdk.propertyValidator('filterConfiguration', CfnGameSessionQueue_FilterConfigurationPropertyValidator)(properties.filterConfiguration));
    errors.collect(cdk.propertyValidator('name', cdk.requiredValidator)(properties.name));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('notificationTarget', cdk.validateString)(properties.notificationTarget));
    errors.collect(cdk.propertyValidator('playerLatencyPolicies', cdk.listValidator(CfnGameSessionQueue_PlayerLatencyPolicyPropertyValidator))(properties.playerLatencyPolicies));
    errors.collect(cdk.propertyValidator('priorityConfiguration', CfnGameSessionQueue_PriorityConfigurationPropertyValidator)(properties.priorityConfiguration));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    errors.collect(cdk.propertyValidator('timeoutInSeconds', cdk.validateNumber)(properties.timeoutInSeconds));
    return errors.wrap('supplied properties not correct for "CfnGameSessionQueueProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::GameLift::GameSessionQueue` resource
 *
 * @param properties - the TypeScript properties of a `CfnGameSessionQueueProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::GameLift::GameSessionQueue` resource.
 */
// @ts-ignore TS6133
function cfnGameSessionQueuePropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnGameSessionQueuePropsValidator(properties).assertSuccess();
    return {
        Name: cdk.stringToCloudFormation(properties.name),
        CustomEventData: cdk.stringToCloudFormation(properties.customEventData),
        Destinations: cdk.listMapper(cfnGameSessionQueueDestinationPropertyToCloudFormation)(properties.destinations),
        FilterConfiguration: cfnGameSessionQueueFilterConfigurationPropertyToCloudFormation(properties.filterConfiguration),
        NotificationTarget: cdk.stringToCloudFormation(properties.notificationTarget),
        PlayerLatencyPolicies: cdk.listMapper(cfnGameSessionQueuePlayerLatencyPolicyPropertyToCloudFormation)(properties.playerLatencyPolicies),
        PriorityConfiguration: cfnGameSessionQueuePriorityConfigurationPropertyToCloudFormation(properties.priorityConfiguration),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
        TimeoutInSeconds: cdk.numberToCloudFormation(properties.timeoutInSeconds),
    };
}
// @ts-ignore TS6133
function CfnGameSessionQueuePropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('name', 'Name', cfn_parse.FromCloudFormation.getString(properties.Name));
    ret.addPropertyResult('customEventData', 'CustomEventData', properties.CustomEventData != null ? cfn_parse.FromCloudFormation.getString(properties.CustomEventData) : undefined);
    ret.addPropertyResult('destinations', 'Destinations', properties.Destinations != null ? cfn_parse.FromCloudFormation.getArray(CfnGameSessionQueueDestinationPropertyFromCloudFormation)(properties.Destinations) : undefined);
    ret.addPropertyResult('filterConfiguration', 'FilterConfiguration', properties.FilterConfiguration != null ? CfnGameSessionQueueFilterConfigurationPropertyFromCloudFormation(properties.FilterConfiguration) : undefined);
    ret.addPropertyResult('notificationTarget', 'NotificationTarget', properties.NotificationTarget != null ? cfn_parse.FromCloudFormation.getString(properties.NotificationTarget) : undefined);
    ret.addPropertyResult('playerLatencyPolicies', 'PlayerLatencyPolicies', properties.PlayerLatencyPolicies != null ? cfn_parse.FromCloudFormation.getArray(CfnGameSessionQueuePlayerLatencyPolicyPropertyFromCloudFormation)(properties.PlayerLatencyPolicies) : undefined);
    ret.addPropertyResult('priorityConfiguration', 'PriorityConfiguration', properties.PriorityConfiguration != null ? CfnGameSessionQueuePriorityConfigurationPropertyFromCloudFormation(properties.PriorityConfiguration) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addPropertyResult('timeoutInSeconds', 'TimeoutInSeconds', properties.TimeoutInSeconds != null ? cfn_parse.FromCloudFormation.getNumber(properties.TimeoutInSeconds) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::GameLift::GameSessionQueue`
 *
 * The `AWS::GameLift::GameSessionQueue` resource creates a placement queue that processes requests for new game sessions. A queue uses FleetIQ algorithms to determine the best placement locations and find an available game server, then prompts the game server to start a new game session. Queues can have destinations (GameLift fleets or aliases), which determine where the queue can place new game sessions. A queue can have destinations with varied fleet type (Spot and On-Demand), instance type, and AWS Region .
 *
 * @cloudformationResource AWS::GameLift::GameSessionQueue
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-gamesessionqueue.html
 */
class CfnGameSessionQueue extends cdk.CfnResource {
    /**
     * Create a new `AWS::GameLift::GameSessionQueue`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnGameSessionQueue.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_gamelift_CfnGameSessionQueueProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        cdk.requireProperty(props, 'name', this);
        this.attrArn = cdk.Token.asString(this.getAtt('Arn'));
        this.attrName = cdk.Token.asString(this.getAtt('Name'));
        this.name = props.name;
        this.customEventData = props.customEventData;
        this.destinations = props.destinations;
        this.filterConfiguration = props.filterConfiguration;
        this.notificationTarget = props.notificationTarget;
        this.playerLatencyPolicies = props.playerLatencyPolicies;
        this.priorityConfiguration = props.priorityConfiguration;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::GameLift::GameSessionQueue", props.tags, { tagPropertyName: 'tags' });
        this.timeoutInSeconds = props.timeoutInSeconds;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnGameSessionQueuePropsFromCloudFormation(resourceProperties);
        const ret = new CfnGameSessionQueue(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnGameSessionQueue.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            name: this.name,
            customEventData: this.customEventData,
            destinations: this.destinations,
            filterConfiguration: this.filterConfiguration,
            notificationTarget: this.notificationTarget,
            playerLatencyPolicies: this.playerLatencyPolicies,
            priorityConfiguration: this.priorityConfiguration,
            tags: this.tags.renderTags(),
            timeoutInSeconds: this.timeoutInSeconds,
        };
    }
    renderProperties(props) {
        return cfnGameSessionQueuePropsToCloudFormation(props);
    }
}
exports.CfnGameSessionQueue = CfnGameSessionQueue;
_e = JSII_RTTI_SYMBOL_1;
CfnGameSessionQueue[_e] = { fqn: "@aws-cdk/aws-gamelift.CfnGameSessionQueue", version: "1.155.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnGameSessionQueue.CFN_RESOURCE_TYPE_NAME = "AWS::GameLift::GameSessionQueue";
/**
 * Determine whether the given properties match those of a `DestinationProperty`
 *
 * @param properties - the TypeScript properties of a `DestinationProperty`
 *
 * @returns the result of the validation.
 */
function CfnGameSessionQueue_DestinationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('destinationArn', cdk.validateString)(properties.destinationArn));
    return errors.wrap('supplied properties not correct for "DestinationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::GameLift::GameSessionQueue.Destination` resource
 *
 * @param properties - the TypeScript properties of a `DestinationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::GameLift::GameSessionQueue.Destination` resource.
 */
// @ts-ignore TS6133
function cfnGameSessionQueueDestinationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnGameSessionQueue_DestinationPropertyValidator(properties).assertSuccess();
    return {
        DestinationArn: cdk.stringToCloudFormation(properties.destinationArn),
    };
}
// @ts-ignore TS6133
function CfnGameSessionQueueDestinationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('destinationArn', 'DestinationArn', properties.DestinationArn != null ? cfn_parse.FromCloudFormation.getString(properties.DestinationArn) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `FilterConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `FilterConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnGameSessionQueue_FilterConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('allowedLocations', cdk.listValidator(cdk.validateString))(properties.allowedLocations));
    return errors.wrap('supplied properties not correct for "FilterConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::GameLift::GameSessionQueue.FilterConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `FilterConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::GameLift::GameSessionQueue.FilterConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnGameSessionQueueFilterConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnGameSessionQueue_FilterConfigurationPropertyValidator(properties).assertSuccess();
    return {
        AllowedLocations: cdk.listMapper(cdk.stringToCloudFormation)(properties.allowedLocations),
    };
}
// @ts-ignore TS6133
function CfnGameSessionQueueFilterConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('allowedLocations', 'AllowedLocations', properties.AllowedLocations != null ? cfn_parse.FromCloudFormation.getStringArray(properties.AllowedLocations) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `PlayerLatencyPolicyProperty`
 *
 * @param properties - the TypeScript properties of a `PlayerLatencyPolicyProperty`
 *
 * @returns the result of the validation.
 */
function CfnGameSessionQueue_PlayerLatencyPolicyPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('maximumIndividualPlayerLatencyMilliseconds', cdk.validateNumber)(properties.maximumIndividualPlayerLatencyMilliseconds));
    errors.collect(cdk.propertyValidator('policyDurationSeconds', cdk.validateNumber)(properties.policyDurationSeconds));
    return errors.wrap('supplied properties not correct for "PlayerLatencyPolicyProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::GameLift::GameSessionQueue.PlayerLatencyPolicy` resource
 *
 * @param properties - the TypeScript properties of a `PlayerLatencyPolicyProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::GameLift::GameSessionQueue.PlayerLatencyPolicy` resource.
 */
// @ts-ignore TS6133
function cfnGameSessionQueuePlayerLatencyPolicyPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnGameSessionQueue_PlayerLatencyPolicyPropertyValidator(properties).assertSuccess();
    return {
        MaximumIndividualPlayerLatencyMilliseconds: cdk.numberToCloudFormation(properties.maximumIndividualPlayerLatencyMilliseconds),
        PolicyDurationSeconds: cdk.numberToCloudFormation(properties.policyDurationSeconds),
    };
}
// @ts-ignore TS6133
function CfnGameSessionQueuePlayerLatencyPolicyPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('maximumIndividualPlayerLatencyMilliseconds', 'MaximumIndividualPlayerLatencyMilliseconds', properties.MaximumIndividualPlayerLatencyMilliseconds != null ? cfn_parse.FromCloudFormation.getNumber(properties.MaximumIndividualPlayerLatencyMilliseconds) : undefined);
    ret.addPropertyResult('policyDurationSeconds', 'PolicyDurationSeconds', properties.PolicyDurationSeconds != null ? cfn_parse.FromCloudFormation.getNumber(properties.PolicyDurationSeconds) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `PriorityConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `PriorityConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnGameSessionQueue_PriorityConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('locationOrder', cdk.listValidator(cdk.validateString))(properties.locationOrder));
    errors.collect(cdk.propertyValidator('priorityOrder', cdk.listValidator(cdk.validateString))(properties.priorityOrder));
    return errors.wrap('supplied properties not correct for "PriorityConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::GameLift::GameSessionQueue.PriorityConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `PriorityConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::GameLift::GameSessionQueue.PriorityConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnGameSessionQueuePriorityConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnGameSessionQueue_PriorityConfigurationPropertyValidator(properties).assertSuccess();
    return {
        LocationOrder: cdk.listMapper(cdk.stringToCloudFormation)(properties.locationOrder),
        PriorityOrder: cdk.listMapper(cdk.stringToCloudFormation)(properties.priorityOrder),
    };
}
// @ts-ignore TS6133
function CfnGameSessionQueuePriorityConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('locationOrder', 'LocationOrder', properties.LocationOrder != null ? cfn_parse.FromCloudFormation.getStringArray(properties.LocationOrder) : undefined);
    ret.addPropertyResult('priorityOrder', 'PriorityOrder', properties.PriorityOrder != null ? cfn_parse.FromCloudFormation.getStringArray(properties.PriorityOrder) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnMatchmakingConfigurationProps`
 *
 * @param properties - the TypeScript properties of a `CfnMatchmakingConfigurationProps`
 *
 * @returns the result of the validation.
 */
function CfnMatchmakingConfigurationPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('acceptanceRequired', cdk.requiredValidator)(properties.acceptanceRequired));
    errors.collect(cdk.propertyValidator('acceptanceRequired', cdk.validateBoolean)(properties.acceptanceRequired));
    errors.collect(cdk.propertyValidator('acceptanceTimeoutSeconds', cdk.validateNumber)(properties.acceptanceTimeoutSeconds));
    errors.collect(cdk.propertyValidator('additionalPlayerCount', cdk.validateNumber)(properties.additionalPlayerCount));
    errors.collect(cdk.propertyValidator('backfillMode', cdk.validateString)(properties.backfillMode));
    errors.collect(cdk.propertyValidator('customEventData', cdk.validateString)(properties.customEventData));
    errors.collect(cdk.propertyValidator('description', cdk.validateString)(properties.description));
    errors.collect(cdk.propertyValidator('flexMatchMode', cdk.validateString)(properties.flexMatchMode));
    errors.collect(cdk.propertyValidator('gameProperties', cdk.listValidator(CfnMatchmakingConfiguration_GamePropertyPropertyValidator))(properties.gameProperties));
    errors.collect(cdk.propertyValidator('gameSessionData', cdk.validateString)(properties.gameSessionData));
    errors.collect(cdk.propertyValidator('gameSessionQueueArns', cdk.listValidator(cdk.validateString))(properties.gameSessionQueueArns));
    errors.collect(cdk.propertyValidator('name', cdk.requiredValidator)(properties.name));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('notificationTarget', cdk.validateString)(properties.notificationTarget));
    errors.collect(cdk.propertyValidator('requestTimeoutSeconds', cdk.requiredValidator)(properties.requestTimeoutSeconds));
    errors.collect(cdk.propertyValidator('requestTimeoutSeconds', cdk.validateNumber)(properties.requestTimeoutSeconds));
    errors.collect(cdk.propertyValidator('ruleSetName', cdk.requiredValidator)(properties.ruleSetName));
    errors.collect(cdk.propertyValidator('ruleSetName', cdk.validateString)(properties.ruleSetName));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnMatchmakingConfigurationProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::GameLift::MatchmakingConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `CfnMatchmakingConfigurationProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::GameLift::MatchmakingConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnMatchmakingConfigurationPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnMatchmakingConfigurationPropsValidator(properties).assertSuccess();
    return {
        AcceptanceRequired: cdk.booleanToCloudFormation(properties.acceptanceRequired),
        Name: cdk.stringToCloudFormation(properties.name),
        RequestTimeoutSeconds: cdk.numberToCloudFormation(properties.requestTimeoutSeconds),
        RuleSetName: cdk.stringToCloudFormation(properties.ruleSetName),
        AcceptanceTimeoutSeconds: cdk.numberToCloudFormation(properties.acceptanceTimeoutSeconds),
        AdditionalPlayerCount: cdk.numberToCloudFormation(properties.additionalPlayerCount),
        BackfillMode: cdk.stringToCloudFormation(properties.backfillMode),
        CustomEventData: cdk.stringToCloudFormation(properties.customEventData),
        Description: cdk.stringToCloudFormation(properties.description),
        FlexMatchMode: cdk.stringToCloudFormation(properties.flexMatchMode),
        GameProperties: cdk.listMapper(cfnMatchmakingConfigurationGamePropertyPropertyToCloudFormation)(properties.gameProperties),
        GameSessionData: cdk.stringToCloudFormation(properties.gameSessionData),
        GameSessionQueueArns: cdk.listMapper(cdk.stringToCloudFormation)(properties.gameSessionQueueArns),
        NotificationTarget: cdk.stringToCloudFormation(properties.notificationTarget),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnMatchmakingConfigurationPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('acceptanceRequired', 'AcceptanceRequired', cfn_parse.FromCloudFormation.getBoolean(properties.AcceptanceRequired));
    ret.addPropertyResult('name', 'Name', cfn_parse.FromCloudFormation.getString(properties.Name));
    ret.addPropertyResult('requestTimeoutSeconds', 'RequestTimeoutSeconds', cfn_parse.FromCloudFormation.getNumber(properties.RequestTimeoutSeconds));
    ret.addPropertyResult('ruleSetName', 'RuleSetName', cfn_parse.FromCloudFormation.getString(properties.RuleSetName));
    ret.addPropertyResult('acceptanceTimeoutSeconds', 'AcceptanceTimeoutSeconds', properties.AcceptanceTimeoutSeconds != null ? cfn_parse.FromCloudFormation.getNumber(properties.AcceptanceTimeoutSeconds) : undefined);
    ret.addPropertyResult('additionalPlayerCount', 'AdditionalPlayerCount', properties.AdditionalPlayerCount != null ? cfn_parse.FromCloudFormation.getNumber(properties.AdditionalPlayerCount) : undefined);
    ret.addPropertyResult('backfillMode', 'BackfillMode', properties.BackfillMode != null ? cfn_parse.FromCloudFormation.getString(properties.BackfillMode) : undefined);
    ret.addPropertyResult('customEventData', 'CustomEventData', properties.CustomEventData != null ? cfn_parse.FromCloudFormation.getString(properties.CustomEventData) : undefined);
    ret.addPropertyResult('description', 'Description', properties.Description != null ? cfn_parse.FromCloudFormation.getString(properties.Description) : undefined);
    ret.addPropertyResult('flexMatchMode', 'FlexMatchMode', properties.FlexMatchMode != null ? cfn_parse.FromCloudFormation.getString(properties.FlexMatchMode) : undefined);
    ret.addPropertyResult('gameProperties', 'GameProperties', properties.GameProperties != null ? cfn_parse.FromCloudFormation.getArray(CfnMatchmakingConfigurationGamePropertyPropertyFromCloudFormation)(properties.GameProperties) : undefined);
    ret.addPropertyResult('gameSessionData', 'GameSessionData', properties.GameSessionData != null ? cfn_parse.FromCloudFormation.getString(properties.GameSessionData) : undefined);
    ret.addPropertyResult('gameSessionQueueArns', 'GameSessionQueueArns', properties.GameSessionQueueArns != null ? cfn_parse.FromCloudFormation.getStringArray(properties.GameSessionQueueArns) : undefined);
    ret.addPropertyResult('notificationTarget', 'NotificationTarget', properties.NotificationTarget != null ? cfn_parse.FromCloudFormation.getString(properties.NotificationTarget) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::GameLift::MatchmakingConfiguration`
 *
 * The `AWS::GameLift::MatchmakingConfiguration` resource defines a new matchmaking configuration for use with FlexMatch. Whether you're using FlexMatch with GameLift hosting or as a standalone matchmaking service, the matchmaking configuration sets out rules for matching players and forming teams. If you're using GameLift hosting, it also defines how to start game sessions for each match. Your matchmaking system can use multiple configurations to handle different game scenarios. All matchmaking requests identify the matchmaking configuration to use and provide player attributes that are consistent with that configuration.
 *
 * @cloudformationResource AWS::GameLift::MatchmakingConfiguration
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-matchmakingconfiguration.html
 */
class CfnMatchmakingConfiguration extends cdk.CfnResource {
    /**
     * Create a new `AWS::GameLift::MatchmakingConfiguration`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnMatchmakingConfiguration.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_gamelift_CfnMatchmakingConfigurationProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        cdk.requireProperty(props, 'acceptanceRequired', this);
        cdk.requireProperty(props, 'name', this);
        cdk.requireProperty(props, 'requestTimeoutSeconds', this);
        cdk.requireProperty(props, 'ruleSetName', this);
        this.attrArn = cdk.Token.asString(this.getAtt('Arn'));
        this.attrName = cdk.Token.asString(this.getAtt('Name'));
        this.acceptanceRequired = props.acceptanceRequired;
        this.name = props.name;
        this.requestTimeoutSeconds = props.requestTimeoutSeconds;
        this.ruleSetName = props.ruleSetName;
        this.acceptanceTimeoutSeconds = props.acceptanceTimeoutSeconds;
        this.additionalPlayerCount = props.additionalPlayerCount;
        this.backfillMode = props.backfillMode;
        this.customEventData = props.customEventData;
        this.description = props.description;
        this.flexMatchMode = props.flexMatchMode;
        this.gameProperties = props.gameProperties;
        this.gameSessionData = props.gameSessionData;
        this.gameSessionQueueArns = props.gameSessionQueueArns;
        this.notificationTarget = props.notificationTarget;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::GameLift::MatchmakingConfiguration", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnMatchmakingConfigurationPropsFromCloudFormation(resourceProperties);
        const ret = new CfnMatchmakingConfiguration(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnMatchmakingConfiguration.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            acceptanceRequired: this.acceptanceRequired,
            name: this.name,
            requestTimeoutSeconds: this.requestTimeoutSeconds,
            ruleSetName: this.ruleSetName,
            acceptanceTimeoutSeconds: this.acceptanceTimeoutSeconds,
            additionalPlayerCount: this.additionalPlayerCount,
            backfillMode: this.backfillMode,
            customEventData: this.customEventData,
            description: this.description,
            flexMatchMode: this.flexMatchMode,
            gameProperties: this.gameProperties,
            gameSessionData: this.gameSessionData,
            gameSessionQueueArns: this.gameSessionQueueArns,
            notificationTarget: this.notificationTarget,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnMatchmakingConfigurationPropsToCloudFormation(props);
    }
}
exports.CfnMatchmakingConfiguration = CfnMatchmakingConfiguration;
_f = JSII_RTTI_SYMBOL_1;
CfnMatchmakingConfiguration[_f] = { fqn: "@aws-cdk/aws-gamelift.CfnMatchmakingConfiguration", version: "1.155.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnMatchmakingConfiguration.CFN_RESOURCE_TYPE_NAME = "AWS::GameLift::MatchmakingConfiguration";
/**
 * Determine whether the given properties match those of a `GamePropertyProperty`
 *
 * @param properties - the TypeScript properties of a `GamePropertyProperty`
 *
 * @returns the result of the validation.
 */
function CfnMatchmakingConfiguration_GamePropertyPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('key', cdk.requiredValidator)(properties.key));
    errors.collect(cdk.propertyValidator('key', cdk.validateString)(properties.key));
    errors.collect(cdk.propertyValidator('value', cdk.requiredValidator)(properties.value));
    errors.collect(cdk.propertyValidator('value', cdk.validateString)(properties.value));
    return errors.wrap('supplied properties not correct for "GamePropertyProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::GameLift::MatchmakingConfiguration.GameProperty` resource
 *
 * @param properties - the TypeScript properties of a `GamePropertyProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::GameLift::MatchmakingConfiguration.GameProperty` resource.
 */
// @ts-ignore TS6133
function cfnMatchmakingConfigurationGamePropertyPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnMatchmakingConfiguration_GamePropertyPropertyValidator(properties).assertSuccess();
    return {
        Key: cdk.stringToCloudFormation(properties.key),
        Value: cdk.stringToCloudFormation(properties.value),
    };
}
// @ts-ignore TS6133
function CfnMatchmakingConfigurationGamePropertyPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('key', 'Key', cfn_parse.FromCloudFormation.getString(properties.Key));
    ret.addPropertyResult('value', 'Value', cfn_parse.FromCloudFormation.getString(properties.Value));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnMatchmakingRuleSetProps`
 *
 * @param properties - the TypeScript properties of a `CfnMatchmakingRuleSetProps`
 *
 * @returns the result of the validation.
 */
function CfnMatchmakingRuleSetPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('name', cdk.requiredValidator)(properties.name));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('ruleSetBody', cdk.requiredValidator)(properties.ruleSetBody));
    errors.collect(cdk.propertyValidator('ruleSetBody', cdk.validateString)(properties.ruleSetBody));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnMatchmakingRuleSetProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::GameLift::MatchmakingRuleSet` resource
 *
 * @param properties - the TypeScript properties of a `CfnMatchmakingRuleSetProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::GameLift::MatchmakingRuleSet` resource.
 */
// @ts-ignore TS6133
function cfnMatchmakingRuleSetPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnMatchmakingRuleSetPropsValidator(properties).assertSuccess();
    return {
        Name: cdk.stringToCloudFormation(properties.name),
        RuleSetBody: cdk.stringToCloudFormation(properties.ruleSetBody),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnMatchmakingRuleSetPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('name', 'Name', cfn_parse.FromCloudFormation.getString(properties.Name));
    ret.addPropertyResult('ruleSetBody', 'RuleSetBody', cfn_parse.FromCloudFormation.getString(properties.RuleSetBody));
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::GameLift::MatchmakingRuleSet`
 *
 * Creates a new rule set for FlexMatch matchmaking. A rule set describes the type of match to create, such as the number and size of teams. It also sets the parameters for acceptable player matches, such as minimum skill level or character type.
 *
 * To create a matchmaking rule set, provide unique rule set name and the rule set body in JSON format. Rule sets must be defined in the same Region as the matchmaking configuration they are used with.
 *
 * Since matchmaking rule sets cannot be edited, it is a good idea to check the rule set syntax.
 *
 * *Learn more*
 *
 * - [Build a rule set](https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-rulesets.html)
 * - [Design a matchmaker](https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-configuration.html)
 * - [Matchmaking with FlexMatch](https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-intro.html)
 *
 * @cloudformationResource AWS::GameLift::MatchmakingRuleSet
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-matchmakingruleset.html
 */
class CfnMatchmakingRuleSet extends cdk.CfnResource {
    /**
     * Create a new `AWS::GameLift::MatchmakingRuleSet`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnMatchmakingRuleSet.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_gamelift_CfnMatchmakingRuleSetProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        cdk.requireProperty(props, 'name', this);
        cdk.requireProperty(props, 'ruleSetBody', this);
        this.attrArn = cdk.Token.asString(this.getAtt('Arn'));
        this.attrName = cdk.Token.asString(this.getAtt('Name'));
        this.name = props.name;
        this.ruleSetBody = props.ruleSetBody;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::GameLift::MatchmakingRuleSet", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnMatchmakingRuleSetPropsFromCloudFormation(resourceProperties);
        const ret = new CfnMatchmakingRuleSet(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnMatchmakingRuleSet.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            name: this.name,
            ruleSetBody: this.ruleSetBody,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnMatchmakingRuleSetPropsToCloudFormation(props);
    }
}
exports.CfnMatchmakingRuleSet = CfnMatchmakingRuleSet;
_g = JSII_RTTI_SYMBOL_1;
CfnMatchmakingRuleSet[_g] = { fqn: "@aws-cdk/aws-gamelift.CfnMatchmakingRuleSet", version: "1.155.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnMatchmakingRuleSet.CFN_RESOURCE_TYPE_NAME = "AWS::GameLift::MatchmakingRuleSet";
/**
 * Determine whether the given properties match those of a `CfnScriptProps`
 *
 * @param properties - the TypeScript properties of a `CfnScriptProps`
 *
 * @returns the result of the validation.
 */
function CfnScriptPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('storageLocation', cdk.requiredValidator)(properties.storageLocation));
    errors.collect(cdk.propertyValidator('storageLocation', CfnScript_S3LocationPropertyValidator)(properties.storageLocation));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    errors.collect(cdk.propertyValidator('version', cdk.validateString)(properties.version));
    return errors.wrap('supplied properties not correct for "CfnScriptProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::GameLift::Script` resource
 *
 * @param properties - the TypeScript properties of a `CfnScriptProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::GameLift::Script` resource.
 */
// @ts-ignore TS6133
function cfnScriptPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnScriptPropsValidator(properties).assertSuccess();
    return {
        StorageLocation: cfnScriptS3LocationPropertyToCloudFormation(properties.storageLocation),
        Name: cdk.stringToCloudFormation(properties.name),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
        Version: cdk.stringToCloudFormation(properties.version),
    };
}
// @ts-ignore TS6133
function CfnScriptPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('storageLocation', 'StorageLocation', CfnScriptS3LocationPropertyFromCloudFormation(properties.StorageLocation));
    ret.addPropertyResult('name', 'Name', properties.Name != null ? cfn_parse.FromCloudFormation.getString(properties.Name) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addPropertyResult('version', 'Version', properties.Version != null ? cfn_parse.FromCloudFormation.getString(properties.Version) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::GameLift::Script`
 *
 * The `AWS::GameLift::Script` resource creates a new script record for your Realtime Servers script. Realtime scripts are JavaScript that provide configuration settings and optional custom game logic for your game. The script is deployed when you create a Realtime Servers fleet to host your game sessions. Script logic is executed during an active game session.
 *
 * @cloudformationResource AWS::GameLift::Script
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-script.html
 */
class CfnScript extends cdk.CfnResource {
    /**
     * Create a new `AWS::GameLift::Script`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnScript.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_gamelift_CfnScriptProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        cdk.requireProperty(props, 'storageLocation', this);
        this.attrArn = cdk.Token.asString(this.getAtt('Arn'));
        this.attrId = cdk.Token.asString(this.getAtt('Id'));
        this.storageLocation = props.storageLocation;
        this.name = props.name;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::GameLift::Script", props.tags, { tagPropertyName: 'tags' });
        this.version = props.version;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnScriptPropsFromCloudFormation(resourceProperties);
        const ret = new CfnScript(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnScript.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            storageLocation: this.storageLocation,
            name: this.name,
            tags: this.tags.renderTags(),
            version: this.version,
        };
    }
    renderProperties(props) {
        return cfnScriptPropsToCloudFormation(props);
    }
}
exports.CfnScript = CfnScript;
_h = JSII_RTTI_SYMBOL_1;
CfnScript[_h] = { fqn: "@aws-cdk/aws-gamelift.CfnScript", version: "1.155.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnScript.CFN_RESOURCE_TYPE_NAME = "AWS::GameLift::Script";
/**
 * Determine whether the given properties match those of a `S3LocationProperty`
 *
 * @param properties - the TypeScript properties of a `S3LocationProperty`
 *
 * @returns the result of the validation.
 */
function CfnScript_S3LocationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('bucket', cdk.requiredValidator)(properties.bucket));
    errors.collect(cdk.propertyValidator('bucket', cdk.validateString)(properties.bucket));
    errors.collect(cdk.propertyValidator('key', cdk.requiredValidator)(properties.key));
    errors.collect(cdk.propertyValidator('key', cdk.validateString)(properties.key));
    errors.collect(cdk.propertyValidator('objectVersion', cdk.validateString)(properties.objectVersion));
    errors.collect(cdk.propertyValidator('roleArn', cdk.requiredValidator)(properties.roleArn));
    errors.collect(cdk.propertyValidator('roleArn', cdk.validateString)(properties.roleArn));
    return errors.wrap('supplied properties not correct for "S3LocationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::GameLift::Script.S3Location` resource
 *
 * @param properties - the TypeScript properties of a `S3LocationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::GameLift::Script.S3Location` resource.
 */
// @ts-ignore TS6133
function cfnScriptS3LocationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnScript_S3LocationPropertyValidator(properties).assertSuccess();
    return {
        Bucket: cdk.stringToCloudFormation(properties.bucket),
        Key: cdk.stringToCloudFormation(properties.key),
        ObjectVersion: cdk.stringToCloudFormation(properties.objectVersion),
        RoleArn: cdk.stringToCloudFormation(properties.roleArn),
    };
}
// @ts-ignore TS6133
function CfnScriptS3LocationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('bucket', 'Bucket', cfn_parse.FromCloudFormation.getString(properties.Bucket));
    ret.addPropertyResult('key', 'Key', cfn_parse.FromCloudFormation.getString(properties.Key));
    ret.addPropertyResult('objectVersion', 'ObjectVersion', properties.ObjectVersion != null ? cfn_parse.FromCloudFormation.getString(properties.ObjectVersion) : undefined);
    ret.addPropertyResult('roleArn', 'RoleArn', cfn_parse.FromCloudFormation.getString(properties.RoleArn));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZ2FtZWxpZnQuZ2VuZXJhdGVkLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiZ2FtZWxpZnQuZ2VuZXJhdGVkLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7OztBQUFBLCtFQUErRTtBQUMvRSwrREFBK0Q7QUFDL0QsOEZBQThGO0FBQzlGLHNIQUFzSDtBQUV0SCw0QkFBNEIsQ0FBQyxpRUFBaUU7QUFFOUYscUNBQXFDO0FBQ3JDLGdFQUFnRTtBQWtDaEU7Ozs7OztHQU1HO0FBQ0gsU0FBUyxzQkFBc0IsQ0FBQyxVQUFlO0lBQzNDLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxHQUFHLENBQUMsa0JBQWtCLENBQUM7S0FBRTtJQUNuRSxNQUFNLE1BQU0sR0FBRyxJQUFJLEdBQUcsQ0FBQyxpQkFBaUIsRUFBRSxDQUFDO0lBQzNDLElBQUksT0FBTyxVQUFVLEtBQUssUUFBUSxFQUFFO1FBQ2hDLE1BQU0sQ0FBQyxPQUFPLENBQUMsSUFBSSxHQUFHLENBQUMsZ0JBQWdCLENBQUMsb0NBQW9DLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLENBQUM7S0FDL0c7SUFDRCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxhQUFhLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxXQUFXLENBQUMsQ0FBQyxDQUFDO0lBQ2pHLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLE1BQU0sRUFBRSxHQUFHLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQztJQUN0RixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxNQUFNLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDO0lBQ25GLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGlCQUFpQixFQUFFLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxlQUFlLENBQUMsQ0FBQyxDQUFDO0lBQzVHLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGlCQUFpQixFQUFFLHlDQUF5QyxDQUFDLENBQUMsVUFBVSxDQUFDLGVBQWUsQ0FBQyxDQUFDLENBQUM7SUFDaEksT0FBTyxNQUFNLENBQUMsSUFBSSxDQUFDLHFEQUFxRCxDQUFDLENBQUM7QUFDOUUsQ0FBQztBQUVEOzs7Ozs7R0FNRztBQUNILG9CQUFvQjtBQUNwQixTQUFTLDZCQUE2QixDQUFDLFVBQWU7SUFDbEQsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLFVBQVUsQ0FBQztLQUFFO0lBQ3ZELHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxDQUFDLGFBQWEsRUFBRSxDQUFDO0lBQ25ELE9BQU87UUFDSCxJQUFJLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUM7UUFDakQsZUFBZSxFQUFFLCtDQUErQyxDQUFDLFVBQVUsQ0FBQyxlQUFlLENBQUM7UUFDNUYsV0FBVyxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsV0FBVyxDQUFDO0tBQ2xFLENBQUM7QUFDTixDQUFDO0FBRUQsb0JBQW9CO0FBQ3BCLFNBQVMsK0JBQStCLENBQUMsVUFBZTtJQUNwRCxVQUFVLEdBQUcsVUFBVSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUM7SUFDbEQsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsT0FBTyxJQUFJLFNBQVMsQ0FBQyx3QkFBd0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztLQUM3RDtJQUNELE1BQU0sR0FBRyxHQUFHLElBQUksU0FBUyxDQUFDLGdDQUFnQyxFQUFpQixDQUFDO0lBQzVFLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxNQUFNLEVBQUUsTUFBTSxFQUFFLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUM7SUFDL0YsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGlCQUFpQixFQUFFLGlCQUFpQixFQUFFLGlEQUFpRCxDQUFDLFVBQVUsQ0FBQyxlQUFlLENBQUMsQ0FBQyxDQUFDO0lBQzNJLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxhQUFhLEVBQUUsYUFBYSxFQUFFLFVBQVUsQ0FBQyxXQUFXLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxXQUFXLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDakssR0FBRyxDQUFDLGdDQUFnQyxDQUFDLFVBQVUsQ0FBQyxDQUFDO0lBQ2pELE9BQU8sR0FBRyxDQUFDO0FBQ2YsQ0FBQztBQUVEOzs7Ozs7Ozs7R0FTRztBQUNILE1BQWEsUUFBUyxTQUFRLEdBQUcsQ0FBQyxXQUFXO0lBc0R6Qzs7Ozs7O09BTUc7SUFDSCxZQUFZLEtBQW9CLEVBQUUsRUFBVSxFQUFFLEtBQW9CO1FBQzlELEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLEVBQUUsSUFBSSxFQUFFLFFBQVEsQ0FBQyxzQkFBc0IsRUFBRSxVQUFVLEVBQUUsS0FBSyxFQUFFLENBQUMsQ0FBQzs7Ozs7Ozs7OztRQUMvRSxHQUFHLENBQUMsZUFBZSxDQUFDLEtBQUssRUFBRSxNQUFNLEVBQUUsSUFBSSxDQUFDLENBQUM7UUFDekMsR0FBRyxDQUFDLGVBQWUsQ0FBQyxLQUFLLEVBQUUsaUJBQWlCLEVBQUUsSUFBSSxDQUFDLENBQUM7UUFDcEQsSUFBSSxDQUFDLFdBQVcsR0FBRyxHQUFHLENBQUMsS0FBSyxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUM7UUFFOUQsSUFBSSxDQUFDLElBQUksR0FBRyxLQUFLLENBQUMsSUFBSSxDQUFDO1FBQ3ZCLElBQUksQ0FBQyxlQUFlLEdBQUcsS0FBSyxDQUFDLGVBQWUsQ0FBQztRQUM3QyxJQUFJLENBQUMsV0FBVyxHQUFHLEtBQUssQ0FBQyxXQUFXLENBQUM7S0FDeEM7SUFoRUQ7Ozs7OztPQU1HO0lBQ0ksTUFBTSxDQUFDLG1CQUFtQixDQUFDLEtBQW9CLEVBQUUsRUFBVSxFQUFFLGtCQUF1QixFQUFFLE9BQTRDO1FBQ3JJLGtCQUFrQixHQUFHLGtCQUFrQixJQUFJLEVBQUUsQ0FBQztRQUM5QyxNQUFNLGtCQUFrQixHQUFHLE9BQU8sQ0FBQyxNQUFNLENBQUMsVUFBVSxDQUFDLGtCQUFrQixDQUFDLFVBQVUsQ0FBQyxDQUFDO1FBQ3BGLE1BQU0sV0FBVyxHQUFHLCtCQUErQixDQUFDLGtCQUFrQixDQUFDLENBQUM7UUFDeEUsTUFBTSxHQUFHLEdBQUcsSUFBSSxRQUFRLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxXQUFXLENBQUMsS0FBSyxDQUFDLENBQUM7UUFDdkQsS0FBSyxNQUFNLENBQUMsT0FBTyxFQUFFLE9BQU8sQ0FBQyxJQUFJLE1BQU0sQ0FBQyxPQUFPLENBQUMsV0FBVyxDQUFDLGVBQWUsQ0FBQyxFQUFHO1lBQzNFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxPQUFPLEVBQUUsT0FBTyxDQUFDLENBQUM7U0FDN0M7UUFDRCxPQUFPLENBQUMsTUFBTSxDQUFDLGdCQUFnQixDQUFDLEdBQUcsRUFBRSxrQkFBa0IsRUFBRSxFQUFFLENBQUMsQ0FBQztRQUM3RCxPQUFPLEdBQUcsQ0FBQztLQUNkO0lBaUREOzs7OztPQUtHO0lBQ0ksT0FBTyxDQUFDLFNBQTRCO1FBQ3ZDLFNBQVMsQ0FBQyxZQUFZLENBQUMsNkJBQTZCLEVBQUUsUUFBUSxDQUFDLHNCQUFzQixDQUFDLENBQUM7UUFDdkYsU0FBUyxDQUFDLFlBQVksQ0FBQyw4QkFBOEIsRUFBRSxJQUFJLENBQUMsYUFBYSxDQUFDLENBQUM7S0FDOUU7SUFFRCxJQUFjLGFBQWE7UUFDdkIsT0FBTztZQUNILElBQUksRUFBRSxJQUFJLENBQUMsSUFBSTtZQUNmLGVBQWUsRUFBRSxJQUFJLENBQUMsZUFBZTtZQUNyQyxXQUFXLEVBQUUsSUFBSSxDQUFDLFdBQVc7U0FDaEMsQ0FBQztLQUNMO0lBRVMsZ0JBQWdCLENBQUMsS0FBMkI7UUFDbEQsT0FBTyw2QkFBNkIsQ0FBQyxLQUFLLENBQUMsQ0FBQztLQUMvQzs7QUE3RkwsNEJBOEZDOzs7QUE3Rkc7O0dBRUc7QUFDb0IsK0JBQXNCLEdBQUcsc0JBQXNCLENBQUM7QUFnSTNFOzs7Ozs7R0FNRztBQUNILFNBQVMseUNBQXlDLENBQUMsVUFBZTtJQUM5RCxJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sR0FBRyxDQUFDLGtCQUFrQixDQUFDO0tBQUU7SUFDbkUsTUFBTSxNQUFNLEdBQUcsSUFBSSxHQUFHLENBQUMsaUJBQWlCLEVBQUUsQ0FBQztJQUMzQyxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxNQUFNLENBQUMsT0FBTyxDQUFDLElBQUksR0FBRyxDQUFDLGdCQUFnQixDQUFDLG9DQUFvQyxHQUFHLElBQUksQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxDQUFDO0tBQy9HO0lBQ0QsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsU0FBUyxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQztJQUN6RixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxTQUFTLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDO0lBQ3pGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLE1BQU0sRUFBRSxHQUFHLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQztJQUN0RixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxNQUFNLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDO0lBQ25GLE9BQU8sTUFBTSxDQUFDLElBQUksQ0FBQywrREFBK0QsQ0FBQyxDQUFDO0FBQ3hGLENBQUM7QUFFRDs7Ozs7O0dBTUc7QUFDSCxvQkFBb0I7QUFDcEIsU0FBUywrQ0FBK0MsQ0FBQyxVQUFlO0lBQ3BFLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxVQUFVLENBQUM7S0FBRTtJQUN2RCx5Q0FBeUMsQ0FBQyxVQUFVLENBQUMsQ0FBQyxhQUFhLEVBQUUsQ0FBQztJQUN0RSxPQUFPO1FBQ0gsT0FBTyxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsT0FBTyxDQUFDO1FBQ3ZELE9BQU8sRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLE9BQU8sQ0FBQztRQUN2RCxJQUFJLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUM7S0FDcEQsQ0FBQztBQUNOLENBQUM7QUFFRCxvQkFBb0I7QUFDcEIsU0FBUyxpREFBaUQsQ0FBQyxVQUFlO0lBQ3RFLElBQUksR0FBRyxDQUFDLGtCQUFrQixDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQ3BDLE9BQU8sSUFBSSxTQUFTLENBQUMsd0JBQXdCLENBQUMsVUFBVSxDQUFDLENBQUM7S0FDN0Q7SUFDRCxVQUFVLEdBQUcsVUFBVSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUM7SUFDbEQsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsT0FBTyxJQUFJLFNBQVMsQ0FBQyx3QkFBd0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztLQUM3RDtJQUNELE1BQU0sR0FBRyxHQUFHLElBQUksU0FBUyxDQUFDLGdDQUFnQyxFQUFvQyxDQUFDO0lBQy9GLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxTQUFTLEVBQUUsU0FBUyxFQUFFLFVBQVUsQ0FBQyxPQUFPLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDakosR0FBRyxDQUFDLGlCQUFpQixDQUFDLFNBQVMsRUFBRSxTQUFTLEVBQUUsVUFBVSxDQUFDLE9BQU8sSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUNqSixHQUFHLENBQUMsaUJBQWlCLENBQUMsTUFBTSxFQUFFLE1BQU0sRUFBRSxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDO0lBQy9GLEdBQUcsQ0FBQyxnQ0FBZ0MsQ0FBQyxVQUFVLENBQUMsQ0FBQztJQUNqRCxPQUFPLEdBQUcsQ0FBQztBQUNmLENBQUM7QUEyQ0Q7Ozs7OztHQU1HO0FBQ0gsU0FBUyxzQkFBc0IsQ0FBQyxVQUFlO0lBQzNDLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxHQUFHLENBQUMsa0JBQWtCLENBQUM7S0FBRTtJQUNuRSxNQUFNLE1BQU0sR0FBRyxJQUFJLEdBQUcsQ0FBQyxpQkFBaUIsRUFBRSxDQUFDO0lBQzNDLElBQUksT0FBTyxVQUFVLEtBQUssUUFBUSxFQUFFO1FBQ2hDLE1BQU0sQ0FBQyxPQUFPLENBQUMsSUFBSSxHQUFHLENBQUMsZ0JBQWdCLENBQUMsb0NBQW9DLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLENBQUM7S0FDL0c7SUFDRCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxNQUFNLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDO0lBQ25GLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGlCQUFpQixFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsZUFBZSxDQUFDLENBQUMsQ0FBQztJQUN6RyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxpQkFBaUIsRUFBRSxvQ0FBb0MsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxlQUFlLENBQUMsQ0FBQyxDQUFDO0lBQzNILE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFNBQVMsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUM7SUFDekYsT0FBTyxNQUFNLENBQUMsSUFBSSxDQUFDLHFEQUFxRCxDQUFDLENBQUM7QUFDOUUsQ0FBQztBQUVEOzs7Ozs7R0FNRztBQUNILG9CQUFvQjtBQUNwQixTQUFTLDZCQUE2QixDQUFDLFVBQWU7SUFDbEQsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLFVBQVUsQ0FBQztLQUFFO0lBQ3ZELHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxDQUFDLGFBQWEsRUFBRSxDQUFDO0lBQ25ELE9BQU87UUFDSCxJQUFJLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUM7UUFDakQsZUFBZSxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsZUFBZSxDQUFDO1FBQ3ZFLGVBQWUsRUFBRSwwQ0FBMEMsQ0FBQyxVQUFVLENBQUMsZUFBZSxDQUFDO1FBQ3ZGLE9BQU8sRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLE9BQU8sQ0FBQztLQUMxRCxDQUFDO0FBQ04sQ0FBQztBQUVELG9CQUFvQjtBQUNwQixTQUFTLCtCQUErQixDQUFDLFVBQWU7SUFDcEQsVUFBVSxHQUFHLFVBQVUsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDO0lBQ2xELElBQUksT0FBTyxVQUFVLEtBQUssUUFBUSxFQUFFO1FBQ2hDLE9BQU8sSUFBSSxTQUFTLENBQUMsd0JBQXdCLENBQUMsVUFBVSxDQUFDLENBQUM7S0FDN0Q7SUFDRCxNQUFNLEdBQUcsR0FBRyxJQUFJLFNBQVMsQ0FBQyxnQ0FBZ0MsRUFBaUIsQ0FBQztJQUM1RSxHQUFHLENBQUMsaUJBQWlCLENBQUMsTUFBTSxFQUFFLE1BQU0sRUFBRSxVQUFVLENBQUMsSUFBSSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ3JJLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxpQkFBaUIsRUFBRSxpQkFBaUIsRUFBRSxVQUFVLENBQUMsZUFBZSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsZUFBZSxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ2pMLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxpQkFBaUIsRUFBRSxpQkFBaUIsRUFBRSxVQUFVLENBQUMsZUFBZSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsNENBQTRDLENBQUMsVUFBVSxDQUFDLGVBQWUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUN2TCxHQUFHLENBQUMsaUJBQWlCLENBQUMsU0FBUyxFQUFFLFNBQVMsRUFBRSxVQUFVLENBQUMsT0FBTyxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ2pKLEdBQUcsQ0FBQyxnQ0FBZ0MsQ0FBQyxVQUFVLENBQUMsQ0FBQztJQUNqRCxPQUFPLEdBQUcsQ0FBQztBQUNmLENBQUM7QUFFRDs7Ozs7Ozs7O0dBU0c7QUFDSCxNQUFhLFFBQVMsU0FBUSxHQUFHLENBQUMsV0FBVztJQXVEekM7Ozs7OztPQU1HO0lBQ0gsWUFBWSxLQUFvQixFQUFFLEVBQVUsRUFBRSxRQUF1QixFQUFFO1FBQ25FLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLEVBQUUsSUFBSSxFQUFFLFFBQVEsQ0FBQyxzQkFBc0IsRUFBRSxVQUFVLEVBQUUsS0FBSyxFQUFFLENBQUMsQ0FBQzs7Ozs7Ozs7OztRQUUvRSxJQUFJLENBQUMsSUFBSSxHQUFHLEtBQUssQ0FBQyxJQUFJLENBQUM7UUFDdkIsSUFBSSxDQUFDLGVBQWUsR0FBRyxLQUFLLENBQUMsZUFBZSxDQUFDO1FBQzdDLElBQUksQ0FBQyxlQUFlLEdBQUcsS0FBSyxDQUFDLGVBQWUsQ0FBQztRQUM3QyxJQUFJLENBQUMsT0FBTyxHQUFHLEtBQUssQ0FBQyxPQUFPLENBQUM7S0FDaEM7SUEvREQ7Ozs7OztPQU1HO0lBQ0ksTUFBTSxDQUFDLG1CQUFtQixDQUFDLEtBQW9CLEVBQUUsRUFBVSxFQUFFLGtCQUF1QixFQUFFLE9BQTRDO1FBQ3JJLGtCQUFrQixHQUFHLGtCQUFrQixJQUFJLEVBQUUsQ0FBQztRQUM5QyxNQUFNLGtCQUFrQixHQUFHLE9BQU8sQ0FBQyxNQUFNLENBQUMsVUFBVSxDQUFDLGtCQUFrQixDQUFDLFVBQVUsQ0FBQyxDQUFDO1FBQ3BGLE1BQU0sV0FBVyxHQUFHLCtCQUErQixDQUFDLGtCQUFrQixDQUFDLENBQUM7UUFDeEUsTUFBTSxHQUFHLEdBQUcsSUFBSSxRQUFRLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxXQUFXLENBQUMsS0FBSyxDQUFDLENBQUM7UUFDdkQsS0FBSyxNQUFNLENBQUMsT0FBTyxFQUFFLE9BQU8sQ0FBQyxJQUFJLE1BQU0sQ0FBQyxPQUFPLENBQUMsV0FBVyxDQUFDLGVBQWUsQ0FBQyxFQUFHO1lBQzNFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxPQUFPLEVBQUUsT0FBTyxDQUFDLENBQUM7U0FDN0M7UUFDRCxPQUFPLENBQUMsTUFBTSxDQUFDLGdCQUFnQixDQUFDLEdBQUcsRUFBRSxrQkFBa0IsRUFBRSxFQUFFLENBQUMsQ0FBQztRQUM3RCxPQUFPLEdBQUcsQ0FBQztLQUNkO0lBZ0REOzs7OztPQUtHO0lBQ0ksT0FBTyxDQUFDLFNBQTRCO1FBQ3ZDLFNBQVMsQ0FBQyxZQUFZLENBQUMsNkJBQTZCLEVBQUUsUUFBUSxDQUFDLHNCQUFzQixDQUFDLENBQUM7UUFDdkYsU0FBUyxDQUFDLFlBQVksQ0FBQyw4QkFBOEIsRUFBRSxJQUFJLENBQUMsYUFBYSxDQUFDLENBQUM7S0FDOUU7SUFFRCxJQUFjLGFBQWE7UUFDdkIsT0FBTztZQUNILElBQUksRUFBRSxJQUFJLENBQUMsSUFBSTtZQUNmLGVBQWUsRUFBRSxJQUFJLENBQUMsZUFBZTtZQUNyQyxlQUFlLEVBQUUsSUFBSSxDQUFDLGVBQWU7WUFDckMsT0FBTyxFQUFFLElBQUksQ0FBQyxPQUFPO1NBQ3hCLENBQUM7S0FDTDtJQUVTLGdCQUFnQixDQUFDLEtBQTJCO1FBQ2xELE9BQU8sNkJBQTZCLENBQUMsS0FBSyxDQUFDLENBQUM7S0FDL0M7O0FBN0ZMLDRCQThGQzs7O0FBN0ZHOztHQUVHO0FBQ29CLCtCQUFzQixHQUFHLHNCQUFzQixDQUFDO0FBbUkzRTs7Ozs7O0dBTUc7QUFDSCxTQUFTLG9DQUFvQyxDQUFDLFVBQWU7SUFDekQsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQztLQUFFO0lBQ25FLE1BQU0sTUFBTSxHQUFHLElBQUksR0FBRyxDQUFDLGlCQUFpQixFQUFFLENBQUM7SUFDM0MsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsTUFBTSxDQUFDLE9BQU8sQ0FBQyxJQUFJLEdBQUcsQ0FBQyxnQkFBZ0IsQ0FBQyxvQ0FBb0MsR0FBRyxJQUFJLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUMsQ0FBQztLQUMvRztJQUNELE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFFBQVEsRUFBRSxHQUFHLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxVQUFVLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQztJQUMxRixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxRQUFRLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDO0lBQ3ZGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLEtBQUssRUFBRSxHQUFHLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQztJQUNwRixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxLQUFLLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDO0lBQ2pGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGVBQWUsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLGFBQWEsQ0FBQyxDQUFDLENBQUM7SUFDckcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsU0FBUyxFQUFFLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDO0lBQzVGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFNBQVMsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUM7SUFDekYsT0FBTyxNQUFNLENBQUMsSUFBSSxDQUFDLDBEQUEwRCxDQUFDLENBQUM7QUFDbkYsQ0FBQztBQUVEOzs7Ozs7R0FNRztBQUNILG9CQUFvQjtBQUNwQixTQUFTLDBDQUEwQyxDQUFDLFVBQWU7SUFDL0QsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLFVBQVUsQ0FBQztLQUFFO0lBQ3ZELG9DQUFvQyxDQUFDLFVBQVUsQ0FBQyxDQUFDLGFBQWEsRUFBRSxDQUFDO0lBQ2pFLE9BQU87UUFDSCxNQUFNLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxNQUFNLENBQUM7UUFDckQsR0FBRyxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDO1FBQy9DLGFBQWEsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLGFBQWEsQ0FBQztRQUNuRSxPQUFPLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUM7S0FDMUQsQ0FBQztBQUNOLENBQUM7QUFFRCxvQkFBb0I7QUFDcEIsU0FBUyw0Q0FBNEMsQ0FBQyxVQUFlO0lBQ2pFLElBQUksR0FBRyxDQUFDLGtCQUFrQixDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQ3BDLE9BQU8sSUFBSSxTQUFTLENBQUMsd0JBQXdCLENBQUMsVUFBVSxDQUFDLENBQUM7S0FDN0Q7SUFDRCxVQUFVLEdBQUcsVUFBVSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUM7SUFDbEQsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsT0FBTyxJQUFJLFNBQVMsQ0FBQyx3QkFBd0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztLQUM3RDtJQUNELE1BQU0sR0FBRyxHQUFHLElBQUksU0FBUyxDQUFDLGdDQUFnQyxFQUErQixDQUFDO0lBQzFGLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxRQUFRLEVBQUUsUUFBUSxFQUFFLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUM7SUFDckcsR0FBRyxDQUFDLGlCQUFpQixDQUFDLEtBQUssRUFBRSxLQUFLLEVBQUUsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQztJQUM1RixHQUFHLENBQUMsaUJBQWlCLENBQUMsZUFBZSxFQUFFLGVBQWUsRUFBRSxVQUFVLENBQUMsYUFBYSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsYUFBYSxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ3pLLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxTQUFTLEVBQUUsU0FBUyxFQUFFLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUM7SUFDeEcsR0FBRyxDQUFDLGdDQUFnQyxDQUFDLFVBQVUsQ0FBQyxDQUFDO0lBQ2pELE9BQU8sR0FBRyxDQUFDO0FBQ2YsQ0FBQztBQTJKRDs7Ozs7O0dBTUc7QUFDSCxTQUFTLHNCQUFzQixDQUFDLFVBQWU7SUFDM0MsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQztLQUFFO0lBQ25FLE1BQU0sTUFBTSxHQUFHLElBQUksR0FBRyxDQUFDLGlCQUFpQixFQUFFLENBQUM7SUFDM0MsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsTUFBTSxDQUFDLE9BQU8sQ0FBQyxJQUFJLEdBQUcsQ0FBQyxnQkFBZ0IsQ0FBQyxvQ0FBb0MsR0FBRyxJQUFJLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUMsQ0FBQztLQUMvRztJQUNELE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFNBQVMsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUM7SUFDekYsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsMEJBQTBCLEVBQUUsa0RBQWtELENBQUMsQ0FBQyxVQUFVLENBQUMsd0JBQXdCLENBQUMsQ0FBQyxDQUFDO0lBQzNKLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGFBQWEsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLFdBQVcsQ0FBQyxDQUFDLENBQUM7SUFDakcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMscUJBQXFCLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDLENBQUM7SUFDakgsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsdUJBQXVCLEVBQUUsR0FBRyxDQUFDLGFBQWEsQ0FBQyxzQ0FBc0MsQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDLHFCQUFxQixDQUFDLENBQUMsQ0FBQztJQUM1SixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxpQkFBaUIsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLGVBQWUsQ0FBQyxDQUFDLENBQUM7SUFDekcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsV0FBVyxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsU0FBUyxDQUFDLENBQUMsQ0FBQztJQUM3RixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxpQkFBaUIsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLGVBQWUsQ0FBQyxDQUFDLENBQUM7SUFDekcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsV0FBVyxFQUFFLEdBQUcsQ0FBQyxhQUFhLENBQUMsK0NBQStDLENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQUMsQ0FBQyxDQUFDO0lBQzdJLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFNBQVMsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUM7SUFDekYsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsY0FBYyxFQUFFLEdBQUcsQ0FBQyxhQUFhLENBQUMsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDLFlBQVksQ0FBQyxDQUFDLENBQUM7SUFDdEgsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsU0FBUyxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQztJQUN6RixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxNQUFNLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDO0lBQ25GLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGdDQUFnQyxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsOEJBQThCLENBQUMsQ0FBQyxDQUFDO0lBQ3ZJLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLHFCQUFxQixFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsbUJBQW1CLENBQUMsQ0FBQyxDQUFDO0lBQ2pILE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFdBQVcsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUM7SUFDN0YsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsNkJBQTZCLEVBQUUscURBQXFELENBQUMsQ0FBQyxVQUFVLENBQUMsMkJBQTJCLENBQUMsQ0FBQyxDQUFDO0lBQ3BLLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLHNCQUFzQixFQUFFLDhDQUE4QyxDQUFDLENBQUMsVUFBVSxDQUFDLG9CQUFvQixDQUFDLENBQUMsQ0FBQztJQUMvSSxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxVQUFVLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxRQUFRLENBQUMsQ0FBQyxDQUFDO0lBQzNGLE9BQU8sTUFBTSxDQUFDLElBQUksQ0FBQyxxREFBcUQsQ0FBQyxDQUFDO0FBQzlFLENBQUM7QUFFRDs7Ozs7O0dBTUc7QUFDSCxvQkFBb0I7QUFDcEIsU0FBUyw2QkFBNkIsQ0FBQyxVQUFlO0lBQ2xELElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxVQUFVLENBQUM7S0FBRTtJQUN2RCxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsQ0FBQyxhQUFhLEVBQUUsQ0FBQztJQUNuRCxPQUFPO1FBQ0gsT0FBTyxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsT0FBTyxDQUFDO1FBQ3ZELHdCQUF3QixFQUFFLHdEQUF3RCxDQUFDLFVBQVUsQ0FBQyx3QkFBd0IsQ0FBQztRQUN2SCxXQUFXLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxXQUFXLENBQUM7UUFDL0QsbUJBQW1CLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxtQkFBbUIsQ0FBQztRQUMvRSxxQkFBcUIsRUFBRSxHQUFHLENBQUMsVUFBVSxDQUFDLDRDQUE0QyxDQUFDLENBQUMsVUFBVSxDQUFDLHFCQUFxQixDQUFDO1FBQ3JILGVBQWUsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLGVBQWUsQ0FBQztRQUN2RSxTQUFTLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQUM7UUFDM0QsZUFBZSxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsZUFBZSxDQUFDO1FBQ3ZFLFNBQVMsRUFBRSxHQUFHLENBQUMsVUFBVSxDQUFDLHFEQUFxRCxDQUFDLENBQUMsVUFBVSxDQUFDLFNBQVMsQ0FBQztRQUN0RyxPQUFPLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUM7UUFDdkQsWUFBWSxFQUFFLEdBQUcsQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDLHNCQUFzQixDQUFDLENBQUMsVUFBVSxDQUFDLFlBQVksQ0FBQztRQUNqRixPQUFPLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUM7UUFDdkQsSUFBSSxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDO1FBQ2pELDhCQUE4QixFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsOEJBQThCLENBQUM7UUFDckcsbUJBQW1CLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxtQkFBbUIsQ0FBQztRQUMvRSxTQUFTLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQUM7UUFDM0QsMkJBQTJCLEVBQUUsMkRBQTJELENBQUMsVUFBVSxDQUFDLDJCQUEyQixDQUFDO1FBQ2hJLG9CQUFvQixFQUFFLG9EQUFvRCxDQUFDLFVBQVUsQ0FBQyxvQkFBb0IsQ0FBQztRQUMzRyxRQUFRLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxRQUFRLENBQUM7S0FDNUQsQ0FBQztBQUNOLENBQUM7QUFFRCxvQkFBb0I7QUFDcEIsU0FBUywrQkFBK0IsQ0FBQyxVQUFlO0lBQ3BELFVBQVUsR0FBRyxVQUFVLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQztJQUNsRCxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxPQUFPLElBQUksU0FBUyxDQUFDLHdCQUF3QixDQUFDLFVBQVUsQ0FBQyxDQUFDO0tBQzdEO0lBQ0QsTUFBTSxHQUFHLEdBQUcsSUFBSSxTQUFTLENBQUMsZ0NBQWdDLEVBQWlCLENBQUM7SUFDNUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFNBQVMsRUFBRSxTQUFTLEVBQUUsVUFBVSxDQUFDLE9BQU8sSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUNqSixHQUFHLENBQUMsaUJBQWlCLENBQUMsMEJBQTBCLEVBQUUsMEJBQTBCLEVBQUUsVUFBVSxDQUFDLHdCQUF3QixJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsMERBQTBELENBQUMsVUFBVSxDQUFDLHdCQUF3QixDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ3pPLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxhQUFhLEVBQUUsYUFBYSxFQUFFLFVBQVUsQ0FBQyxXQUFXLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxXQUFXLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDakssR0FBRyxDQUFDLGlCQUFpQixDQUFDLHFCQUFxQixFQUFFLHFCQUFxQixFQUFFLFVBQVUsQ0FBQyxtQkFBbUIsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLG1CQUFtQixDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ2pNLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyx1QkFBdUIsRUFBRSx1QkFBdUIsRUFBRSxVQUFVLENBQUMscUJBQXFCLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsUUFBUSxDQUFDLDhDQUE4QyxDQUFDLENBQUMsVUFBVSxDQUFDLHFCQUFxQixDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ3hQLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxpQkFBaUIsRUFBRSxpQkFBaUIsRUFBRSxVQUFVLENBQUMsZUFBZSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsZUFBZSxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ2pMLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxXQUFXLEVBQUUsV0FBVyxFQUFFLFVBQVUsQ0FBQyxTQUFTLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDekosR0FBRyxDQUFDLGlCQUFpQixDQUFDLGlCQUFpQixFQUFFLGlCQUFpQixFQUFFLFVBQVUsQ0FBQyxlQUFlLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxlQUFlLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDakwsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFdBQVcsRUFBRSxXQUFXLEVBQUUsVUFBVSxDQUFDLFNBQVMsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxRQUFRLENBQUMsdURBQXVELENBQUMsQ0FBQyxVQUFVLENBQUMsU0FBUyxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ2pOLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxTQUFTLEVBQUUsU0FBUyxFQUFFLFVBQVUsQ0FBQyxPQUFPLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDakosR0FBRyxDQUFDLGlCQUFpQixDQUFDLGNBQWMsRUFBRSxjQUFjLEVBQUUsVUFBVSxDQUFDLFlBQVksSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxjQUFjLENBQUMsVUFBVSxDQUFDLFlBQVksQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUMxSyxHQUFHLENBQUMsaUJBQWlCLENBQUMsU0FBUyxFQUFFLFNBQVMsRUFBRSxVQUFVLENBQUMsT0FBTyxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ2pKLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxNQUFNLEVBQUUsTUFBTSxFQUFFLFVBQVUsQ0FBQyxJQUFJLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDckksR0FBRyxDQUFDLGlCQUFpQixDQUFDLGdDQUFnQyxFQUFFLGdDQUFnQyxFQUFFLFVBQVUsQ0FBQyw4QkFBOEIsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLDhCQUE4QixDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQzdPLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxxQkFBcUIsRUFBRSxxQkFBcUIsRUFBRSxVQUFVLENBQUMsbUJBQW1CLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUNqTSxHQUFHLENBQUMsaUJBQWlCLENBQUMsV0FBVyxFQUFFLFdBQVcsRUFBRSxVQUFVLENBQUMsU0FBUyxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsU0FBUyxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ3pKLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyw2QkFBNkIsRUFBRSw2QkFBNkIsRUFBRSxVQUFVLENBQUMsMkJBQTJCLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyw2REFBNkQsQ0FBQyxVQUFVLENBQUMsMkJBQTJCLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDeFAsR0FBRyxDQUFDLGlCQUFpQixDQUFDLHNCQUFzQixFQUFFLHNCQUFzQixFQUFFLFVBQVUsQ0FBQyxvQkFBb0IsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLHNEQUFzRCxDQUFDLFVBQVUsQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUNyTixHQUFHLENBQUMsaUJBQWlCLENBQUMsVUFBVSxFQUFFLFVBQVUsRUFBRSxVQUFVLENBQUMsUUFBUSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsUUFBUSxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ3JKLEdBQUcsQ0FBQyxnQ0FBZ0MsQ0FBQyxVQUFVLENBQUMsQ0FBQztJQUNqRCxPQUFPLEdBQUcsQ0FBQztBQUNmLENBQUM7QUFFRDs7Ozs7Ozs7O0dBU0c7QUFDSCxNQUFhLFFBQVMsU0FBUSxHQUFHLENBQUMsV0FBVztJQTZLekM7Ozs7OztPQU1HO0lBQ0gsWUFBWSxLQUFvQixFQUFFLEVBQVUsRUFBRSxRQUF1QixFQUFFO1FBQ25FLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLEVBQUUsSUFBSSxFQUFFLFFBQVEsQ0FBQyxzQkFBc0IsRUFBRSxVQUFVLEVBQUUsS0FBSyxFQUFFLENBQUMsQ0FBQzs7Ozs7Ozs7OztRQUMvRSxJQUFJLENBQUMsV0FBVyxHQUFHLEdBQUcsQ0FBQyxLQUFLLENBQUMsUUFBUSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsU0FBUyxDQUFDLENBQUMsQ0FBQztRQUU5RCxJQUFJLENBQUMsT0FBTyxHQUFHLEtBQUssQ0FBQyxPQUFPLENBQUM7UUFDN0IsSUFBSSxDQUFDLHdCQUF3QixHQUFHLEtBQUssQ0FBQyx3QkFBd0IsQ0FBQztRQUMvRCxJQUFJLENBQUMsV0FBVyxHQUFHLEtBQUssQ0FBQyxXQUFXLENBQUM7UUFDckMsSUFBSSxDQUFDLG1CQUFtQixHQUFHLEtBQUssQ0FBQyxtQkFBbUIsQ0FBQztRQUNyRCxJQUFJLENBQUMscUJBQXFCLEdBQUcsS0FBSyxDQUFDLHFCQUFxQixDQUFDO1FBQ3pELElBQUksQ0FBQyxlQUFlLEdBQUcsS0FBSyxDQUFDLGVBQWUsQ0FBQztRQUM3QyxJQUFJLENBQUMsU0FBUyxHQUFHLEtBQUssQ0FBQyxTQUFTLENBQUM7UUFDakMsSUFBSSxDQUFDLGVBQWUsR0FBRyxLQUFLLENBQUMsZUFBZSxDQUFDO1FBQzdDLElBQUksQ0FBQyxTQUFTLEdBQUcsS0FBSyxDQUFDLFNBQVMsQ0FBQztRQUNqQyxJQUFJLENBQUMsT0FBTyxHQUFHLEtBQUssQ0FBQyxPQUFPLENBQUM7UUFDN0IsSUFBSSxDQUFDLFlBQVksR0FBRyxLQUFLLENBQUMsWUFBWSxDQUFDO1FBQ3ZDLElBQUksQ0FBQyxPQUFPLEdBQUcsS0FBSyxDQUFDLE9BQU8sQ0FBQztRQUM3QixJQUFJLENBQUMsSUFBSSxHQUFHLEtBQUssQ0FBQyxJQUFJLENBQUM7UUFDdkIsSUFBSSxDQUFDLDhCQUE4QixHQUFHLEtBQUssQ0FBQyw4QkFBOEIsQ0FBQztRQUMzRSxJQUFJLENBQUMsbUJBQW1CLEdBQUcsS0FBSyxDQUFDLG1CQUFtQixDQUFDO1FBQ3JELElBQUksQ0FBQyxTQUFTLEdBQUcsS0FBSyxDQUFDLFNBQVMsQ0FBQztRQUNqQyxJQUFJLENBQUMsMkJBQTJCLEdBQUcsS0FBSyxDQUFDLDJCQUEyQixDQUFDO1FBQ3JFLElBQUksQ0FBQyxvQkFBb0IsR0FBRyxLQUFLLENBQUMsb0JBQW9CLENBQUM7UUFDdkQsSUFBSSxDQUFDLFFBQVEsR0FBRyxLQUFLLENBQUMsUUFBUSxDQUFDO0tBQ2xDO0lBck1EOzs7Ozs7T0FNRztJQUNJLE1BQU0sQ0FBQyxtQkFBbUIsQ0FBQyxLQUFvQixFQUFFLEVBQVUsRUFBRSxrQkFBdUIsRUFBRSxPQUE0QztRQUNySSxrQkFBa0IsR0FBRyxrQkFBa0IsSUFBSSxFQUFFLENBQUM7UUFDOUMsTUFBTSxrQkFBa0IsR0FBRyxPQUFPLENBQUMsTUFBTSxDQUFDLFVBQVUsQ0FBQyxrQkFBa0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztRQUNwRixNQUFNLFdBQVcsR0FBRywrQkFBK0IsQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDO1FBQ3hFLE1BQU0sR0FBRyxHQUFHLElBQUksUUFBUSxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUUsV0FBVyxDQUFDLEtBQUssQ0FBQyxDQUFDO1FBQ3ZELEtBQUssTUFBTSxDQUFDLE9BQU8sRUFBRSxPQUFPLENBQUMsSUFBSSxNQUFNLENBQUMsT0FBTyxDQUFDLFdBQVcsQ0FBQyxlQUFlLENBQUMsRUFBRztZQUMzRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsT0FBTyxFQUFFLE9BQU8sQ0FBQyxDQUFDO1NBQzdDO1FBQ0QsT0FBTyxDQUFDLE1BQU0sQ0FBQyxnQkFBZ0IsQ0FBQyxHQUFHLEVBQUUsa0JBQWtCLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFDN0QsT0FBTyxHQUFHLENBQUM7S0FDZDtJQXNMRDs7Ozs7T0FLRztJQUNJLE9BQU8sQ0FBQyxTQUE0QjtRQUN2QyxTQUFTLENBQUMsWUFBWSxDQUFDLDZCQUE2QixFQUFFLFFBQVEsQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDO1FBQ3ZGLFNBQVMsQ0FBQyxZQUFZLENBQUMsOEJBQThCLEVBQUUsSUFBSSxDQUFDLGFBQWEsQ0FBQyxDQUFDO0tBQzlFO0lBRUQsSUFBYyxhQUFhO1FBQ3ZCLE9BQU87WUFDSCxPQUFPLEVBQUUsSUFBSSxDQUFDLE9BQU87WUFDckIsd0JBQXdCLEVBQUUsSUFBSSxDQUFDLHdCQUF3QjtZQUN2RCxXQUFXLEVBQUUsSUFBSSxDQUFDLFdBQVc7WUFDN0IsbUJBQW1CLEVBQUUsSUFBSSxDQUFDLG1CQUFtQjtZQUM3QyxxQkFBcUIsRUFBRSxJQUFJLENBQUMscUJBQXFCO1lBQ2pELGVBQWUsRUFBRSxJQUFJLENBQUMsZUFBZTtZQUNyQyxTQUFTLEVBQUUsSUFBSSxDQUFDLFNBQVM7WUFDekIsZUFBZSxFQUFFLElBQUksQ0FBQyxlQUFlO1lBQ3JDLFNBQVMsRUFBRSxJQUFJLENBQUMsU0FBUztZQUN6QixPQUFPLEVBQUUsSUFBSSxDQUFDLE9BQU87WUFDckIsWUFBWSxFQUFFLElBQUksQ0FBQyxZQUFZO1lBQy9CLE9BQU8sRUFBRSxJQUFJLENBQUMsT0FBTztZQUNyQixJQUFJLEVBQUUsSUFBSSxDQUFDLElBQUk7WUFDZiw4QkFBOEIsRUFBRSxJQUFJLENBQUMsOEJBQThCO1lBQ25FLG1CQUFtQixFQUFFLElBQUksQ0FBQyxtQkFBbUI7WUFDN0MsU0FBUyxFQUFFLElBQUksQ0FBQyxTQUFTO1lBQ3pCLDJCQUEyQixFQUFFLElBQUksQ0FBQywyQkFBMkI7WUFDN0Qsb0JBQW9CLEVBQUUsSUFBSSxDQUFDLG9CQUFvQjtZQUMvQyxRQUFRLEVBQUUsSUFBSSxDQUFDLFFBQVE7U0FDMUIsQ0FBQztLQUNMO0lBRVMsZ0JBQWdCLENBQUMsS0FBMkI7UUFDbEQsT0FBTyw2QkFBNkIsQ0FBQyxLQUFLLENBQUMsQ0FBQztLQUMvQzs7QUFsUEwsNEJBbVBDOzs7QUFsUEc7O0dBRUc7QUFDb0IsK0JBQXNCLEdBQUcsc0JBQXNCLENBQUM7QUF5UTNFOzs7Ozs7R0FNRztBQUNILFNBQVMsa0RBQWtELENBQUMsVUFBZTtJQUN2RSxJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sR0FBRyxDQUFDLGtCQUFrQixDQUFDO0tBQUU7SUFDbkUsTUFBTSxNQUFNLEdBQUcsSUFBSSxHQUFHLENBQUMsaUJBQWlCLEVBQUUsQ0FBQztJQUMzQyxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxNQUFNLENBQUMsT0FBTyxDQUFDLElBQUksR0FBRyxDQUFDLGdCQUFnQixDQUFDLG9DQUFvQyxHQUFHLElBQUksQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxDQUFDO0tBQy9HO0lBQ0QsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsaUJBQWlCLEVBQUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUMsVUFBVSxDQUFDLGVBQWUsQ0FBQyxDQUFDLENBQUM7SUFDNUcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsaUJBQWlCLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxlQUFlLENBQUMsQ0FBQyxDQUFDO0lBQ3pHLE9BQU8sTUFBTSxDQUFDLElBQUksQ0FBQyx3RUFBd0UsQ0FBQyxDQUFDO0FBQ2pHLENBQUM7QUFFRDs7Ozs7O0dBTUc7QUFDSCxvQkFBb0I7QUFDcEIsU0FBUyx3REFBd0QsQ0FBQyxVQUFlO0lBQzdFLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxVQUFVLENBQUM7S0FBRTtJQUN2RCxrREFBa0QsQ0FBQyxVQUFVLENBQUMsQ0FBQyxhQUFhLEVBQUUsQ0FBQztJQUMvRSxPQUFPO1FBQ0gsZUFBZSxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsZUFBZSxDQUFDO0tBQzFFLENBQUM7QUFDTixDQUFDO0FBRUQsb0JBQW9CO0FBQ3BCLFNBQVMsMERBQTBELENBQUMsVUFBZTtJQUMvRSxJQUFJLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUNwQyxPQUFPLElBQUksU0FBUyxDQUFDLHdCQUF3QixDQUFDLFVBQVUsQ0FBQyxDQUFDO0tBQzdEO0lBQ0QsVUFBVSxHQUFHLFVBQVUsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDO0lBQ2xELElBQUksT0FBTyxVQUFVLEtBQUssUUFBUSxFQUFFO1FBQ2hDLE9BQU8sSUFBSSxTQUFTLENBQUMsd0JBQXdCLENBQUMsVUFBVSxDQUFDLENBQUM7S0FDN0Q7SUFDRCxNQUFNLEdBQUcsR0FBRyxJQUFJLFNBQVMsQ0FBQyxnQ0FBZ0MsRUFBNkMsQ0FBQztJQUN4RyxHQUFHLENBQUMsaUJBQWlCLENBQUMsaUJBQWlCLEVBQUUsaUJBQWlCLEVBQUUsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsZUFBZSxDQUFDLENBQUMsQ0FBQztJQUNoSSxHQUFHLENBQUMsZ0NBQWdDLENBQUMsVUFBVSxDQUFDLENBQUM7SUFDakQsT0FBTyxHQUFHLENBQUM7QUFDZixDQUFDO0FBMkNEOzs7Ozs7R0FNRztBQUNILFNBQVMsc0NBQXNDLENBQUMsVUFBZTtJQUMzRCxJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sR0FBRyxDQUFDLGtCQUFrQixDQUFDO0tBQUU7SUFDbkUsTUFBTSxNQUFNLEdBQUcsSUFBSSxHQUFHLENBQUMsaUJBQWlCLEVBQUUsQ0FBQztJQUMzQyxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxNQUFNLENBQUMsT0FBTyxDQUFDLElBQUksR0FBRyxDQUFDLGdCQUFnQixDQUFDLG9DQUFvQyxHQUFHLElBQUksQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxDQUFDO0tBQy9HO0lBQ0QsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsVUFBVSxFQUFFLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxRQUFRLENBQUMsQ0FBQyxDQUFDO0lBQzlGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFVBQVUsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLFFBQVEsQ0FBQyxDQUFDLENBQUM7SUFDM0YsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsU0FBUyxFQUFFLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDO0lBQzVGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFNBQVMsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUM7SUFDekYsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsVUFBVSxFQUFFLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxRQUFRLENBQUMsQ0FBQyxDQUFDO0lBQzlGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFVBQVUsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLFFBQVEsQ0FBQyxDQUFDLENBQUM7SUFDM0YsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsUUFBUSxFQUFFLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDO0lBQzFGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFFBQVEsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUM7SUFDdkYsT0FBTyxNQUFNLENBQUMsSUFBSSxDQUFDLDREQUE0RCxDQUFDLENBQUM7QUFDckYsQ0FBQztBQUVEOzs7Ozs7R0FNRztBQUNILG9CQUFvQjtBQUNwQixTQUFTLDRDQUE0QyxDQUFDLFVBQWU7SUFDakUsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLFVBQVUsQ0FBQztLQUFFO0lBQ3ZELHNDQUFzQyxDQUFDLFVBQVUsQ0FBQyxDQUFDLGFBQWEsRUFBRSxDQUFDO0lBQ25FLE9BQU87UUFDSCxRQUFRLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxRQUFRLENBQUM7UUFDekQsT0FBTyxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsT0FBTyxDQUFDO1FBQ3ZELFFBQVEsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLFFBQVEsQ0FBQztRQUN6RCxNQUFNLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxNQUFNLENBQUM7S0FDeEQsQ0FBQztBQUNOLENBQUM7QUFFRCxvQkFBb0I7QUFDcEIsU0FBUyw4Q0FBOEMsQ0FBQyxVQUFlO0lBQ25FLElBQUksR0FBRyxDQUFDLGtCQUFrQixDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQ3BDLE9BQU8sSUFBSSxTQUFTLENBQUMsd0JBQXdCLENBQUMsVUFBVSxDQUFDLENBQUM7S0FDN0Q7SUFDRCxVQUFVLEdBQUcsVUFBVSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUM7SUFDbEQsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsT0FBTyxJQUFJLFNBQVMsQ0FBQyx3QkFBd0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztLQUM3RDtJQUNELE1BQU0sR0FBRyxHQUFHLElBQUksU0FBUyxDQUFDLGdDQUFnQyxFQUFpQyxDQUFDO0lBQzVGLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxVQUFVLEVBQUUsVUFBVSxFQUFFLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLFFBQVEsQ0FBQyxDQUFDLENBQUM7SUFDM0csR0FBRyxDQUFDLGlCQUFpQixDQUFDLFNBQVMsRUFBRSxTQUFTLEVBQUUsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQztJQUN4RyxHQUFHLENBQUMsaUJBQWlCLENBQUMsVUFBVSxFQUFFLFVBQVUsRUFBRSxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxRQUFRLENBQUMsQ0FBQyxDQUFDO0lBQzNHLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxRQUFRLEVBQUUsUUFBUSxFQUFFLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUM7SUFDckcsR0FBRyxDQUFDLGdDQUFnQyxDQUFDLFVBQVUsQ0FBQyxDQUFDO0lBQ2pELE9BQU8sR0FBRyxDQUFDO0FBQ2YsQ0FBQztBQXFDRDs7Ozs7O0dBTUc7QUFDSCxTQUFTLDBDQUEwQyxDQUFDLFVBQWU7SUFDL0QsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQztLQUFFO0lBQ25FLE1BQU0sTUFBTSxHQUFHLElBQUksR0FBRyxDQUFDLGlCQUFpQixFQUFFLENBQUM7SUFDM0MsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsTUFBTSxDQUFDLE9BQU8sQ0FBQyxJQUFJLEdBQUcsQ0FBQyxnQkFBZ0IsQ0FBQyxvQ0FBb0MsR0FBRyxJQUFJLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUMsQ0FBQztLQUMvRztJQUNELE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLHFCQUFxQixFQUFFLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDLENBQUM7SUFDcEgsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMscUJBQXFCLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDLENBQUM7SUFDakgsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsU0FBUyxFQUFFLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDO0lBQzVGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFNBQVMsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUM7SUFDekYsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsU0FBUyxFQUFFLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDO0lBQzVGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFNBQVMsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUM7SUFDekYsT0FBTyxNQUFNLENBQUMsSUFBSSxDQUFDLGdFQUFnRSxDQUFDLENBQUM7QUFDekYsQ0FBQztBQUVEOzs7Ozs7R0FNRztBQUNILG9CQUFvQjtBQUNwQixTQUFTLGdEQUFnRCxDQUFDLFVBQWU7SUFDckUsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLFVBQVUsQ0FBQztLQUFFO0lBQ3ZELDBDQUEwQyxDQUFDLFVBQVUsQ0FBQyxDQUFDLGFBQWEsRUFBRSxDQUFDO0lBQ3ZFLE9BQU87UUFDSCxtQkFBbUIsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLG1CQUFtQixDQUFDO1FBQy9FLE9BQU8sRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLE9BQU8sQ0FBQztRQUN2RCxPQUFPLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUM7S0FDMUQsQ0FBQztBQUNOLENBQUM7QUFFRCxvQkFBb0I7QUFDcEIsU0FBUyxrREFBa0QsQ0FBQyxVQUFlO0lBQ3ZFLElBQUksR0FBRyxDQUFDLGtCQUFrQixDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQ3BDLE9BQU8sSUFBSSxTQUFTLENBQUMsd0JBQXdCLENBQUMsVUFBVSxDQUFDLENBQUM7S0FDN0Q7SUFDRCxVQUFVLEdBQUcsVUFBVSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUM7SUFDbEQsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsT0FBTyxJQUFJLFNBQVMsQ0FBQyx3QkFBd0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztLQUM3RDtJQUNELE1BQU0sR0FBRyxHQUFHLElBQUksU0FBUyxDQUFDLGdDQUFnQyxFQUFxQyxDQUFDO0lBQ2hHLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxxQkFBcUIsRUFBRSxxQkFBcUIsRUFBRSxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDLENBQUM7SUFDNUksR0FBRyxDQUFDLGlCQUFpQixDQUFDLFNBQVMsRUFBRSxTQUFTLEVBQUUsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQztJQUN4RyxHQUFHLENBQUMsaUJBQWlCLENBQUMsU0FBUyxFQUFFLFNBQVMsRUFBRSxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDO0lBQ3hHLEdBQUcsQ0FBQyxnQ0FBZ0MsQ0FBQyxVQUFVLENBQUMsQ0FBQztJQUNqRCxPQUFPLEdBQUcsQ0FBQztBQUNmLENBQUM7QUFtQ0Q7Ozs7OztHQU1HO0FBQ0gsU0FBUywrQ0FBK0MsQ0FBQyxVQUFlO0lBQ3BFLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxHQUFHLENBQUMsa0JBQWtCLENBQUM7S0FBRTtJQUNuRSxNQUFNLE1BQU0sR0FBRyxJQUFJLEdBQUcsQ0FBQyxpQkFBaUIsRUFBRSxDQUFDO0lBQzNDLElBQUksT0FBTyxVQUFVLEtBQUssUUFBUSxFQUFFO1FBQ2hDLE1BQU0sQ0FBQyxPQUFPLENBQUMsSUFBSSxHQUFHLENBQUMsZ0JBQWdCLENBQUMsb0NBQW9DLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLENBQUM7S0FDL0c7SUFDRCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxVQUFVLEVBQUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUMsVUFBVSxDQUFDLFFBQVEsQ0FBQyxDQUFDLENBQUM7SUFDOUYsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsVUFBVSxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsUUFBUSxDQUFDLENBQUMsQ0FBQztJQUMzRixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxrQkFBa0IsRUFBRSwwQ0FBMEMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDLENBQUM7SUFDbkksT0FBTyxNQUFNLENBQUMsSUFBSSxDQUFDLHFFQUFxRSxDQUFDLENBQUM7QUFDOUYsQ0FBQztBQUVEOzs7Ozs7R0FNRztBQUNILG9CQUFvQjtBQUNwQixTQUFTLHFEQUFxRCxDQUFDLFVBQWU7SUFDMUUsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLFVBQVUsQ0FBQztLQUFFO0lBQ3ZELCtDQUErQyxDQUFDLFVBQVUsQ0FBQyxDQUFDLGFBQWEsRUFBRSxDQUFDO0lBQzVFLE9BQU87UUFDSCxRQUFRLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxRQUFRLENBQUM7UUFDekQsZ0JBQWdCLEVBQUUsZ0RBQWdELENBQUMsVUFBVSxDQUFDLGdCQUFnQixDQUFDO0tBQ2xHLENBQUM7QUFDTixDQUFDO0FBRUQsb0JBQW9CO0FBQ3BCLFNBQVMsdURBQXVELENBQUMsVUFBZTtJQUM1RSxJQUFJLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUNwQyxPQUFPLElBQUksU0FBUyxDQUFDLHdCQUF3QixDQUFDLFVBQVUsQ0FBQyxDQUFDO0tBQzdEO0lBQ0QsVUFBVSxHQUFHLFVBQVUsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDO0lBQ2xELElBQUksT0FBTyxVQUFVLEtBQUssUUFBUSxFQUFFO1FBQ2hDLE9BQU8sSUFBSSxTQUFTLENBQUMsd0JBQXdCLENBQUMsVUFBVSxDQUFDLENBQUM7S0FDN0Q7SUFDRCxNQUFNLEdBQUcsR0FBRyxJQUFJLFNBQVMsQ0FBQyxnQ0FBZ0MsRUFBMEMsQ0FBQztJQUNyRyxHQUFHLENBQUMsaUJBQWlCLENBQUMsVUFBVSxFQUFFLFVBQVUsRUFBRSxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxRQUFRLENBQUMsQ0FBQyxDQUFDO0lBQzNHLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxrQkFBa0IsRUFBRSxrQkFBa0IsRUFBRSxVQUFVLENBQUMsZ0JBQWdCLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxrREFBa0QsQ0FBQyxVQUFVLENBQUMsZ0JBQWdCLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDak0sR0FBRyxDQUFDLGdDQUFnQyxDQUFDLFVBQVUsQ0FBQyxDQUFDO0lBQ2pELE9BQU8sR0FBRyxDQUFDO0FBQ2YsQ0FBQztBQTZCRDs7Ozs7O0dBTUc7QUFDSCxTQUFTLHFEQUFxRCxDQUFDLFVBQWU7SUFDMUUsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQztLQUFFO0lBQ25FLE1BQU0sTUFBTSxHQUFHLElBQUksR0FBRyxDQUFDLGlCQUFpQixFQUFFLENBQUM7SUFDM0MsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsTUFBTSxDQUFDLE9BQU8sQ0FBQyxJQUFJLEdBQUcsQ0FBQyxnQkFBZ0IsQ0FBQyxvQ0FBb0MsR0FBRyxJQUFJLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUMsQ0FBQztLQUMvRztJQUNELE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLDJCQUEyQixFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMseUJBQXlCLENBQUMsQ0FBQyxDQUFDO0lBQzdILE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLHVCQUF1QixFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMscUJBQXFCLENBQUMsQ0FBQyxDQUFDO0lBQ3JILE9BQU8sTUFBTSxDQUFDLElBQUksQ0FBQywyRUFBMkUsQ0FBQyxDQUFDO0FBQ3BHLENBQUM7QUFFRDs7Ozs7O0dBTUc7QUFDSCxvQkFBb0I7QUFDcEIsU0FBUywyREFBMkQsQ0FBQyxVQUFlO0lBQ2hGLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxVQUFVLENBQUM7S0FBRTtJQUN2RCxxREFBcUQsQ0FBQyxVQUFVLENBQUMsQ0FBQyxhQUFhLEVBQUUsQ0FBQztJQUNsRixPQUFPO1FBQ0gseUJBQXlCLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyx5QkFBeUIsQ0FBQztRQUMzRixxQkFBcUIsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLHFCQUFxQixDQUFDO0tBQ3RGLENBQUM7QUFDTixDQUFDO0FBRUQsb0JBQW9CO0FBQ3BCLFNBQVMsNkRBQTZELENBQUMsVUFBZTtJQUNsRixJQUFJLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUNwQyxPQUFPLElBQUksU0FBUyxDQUFDLHdCQUF3QixDQUFDLFVBQVUsQ0FBQyxDQUFDO0tBQzdEO0lBQ0QsVUFBVSxHQUFHLFVBQVUsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDO0lBQ2xELElBQUksT0FBTyxVQUFVLEtBQUssUUFBUSxFQUFFO1FBQ2hDLE9BQU8sSUFBSSxTQUFTLENBQUMsd0JBQXdCLENBQUMsVUFBVSxDQUFDLENBQUM7S0FDN0Q7SUFDRCxNQUFNLEdBQUcsR0FBRyxJQUFJLFNBQVMsQ0FBQyxnQ0FBZ0MsRUFBZ0QsQ0FBQztJQUMzRyxHQUFHLENBQUMsaUJBQWlCLENBQUMsMkJBQTJCLEVBQUUsMkJBQTJCLEVBQUUsVUFBVSxDQUFDLHlCQUF5QixJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMseUJBQXlCLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDek4sR0FBRyxDQUFDLGlCQUFpQixDQUFDLHVCQUF1QixFQUFFLHVCQUF1QixFQUFFLFVBQVUsQ0FBQyxxQkFBcUIsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLHFCQUFxQixDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ3pNLEdBQUcsQ0FBQyxnQ0FBZ0MsQ0FBQyxVQUFVLENBQUMsQ0FBQztJQUNqRCxPQUFPLEdBQUcsQ0FBQztBQUNmLENBQUM7QUFtQ0Q7Ozs7OztHQU1HO0FBQ0gsU0FBUyw4Q0FBOEMsQ0FBQyxVQUFlO0lBQ25FLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxHQUFHLENBQUMsa0JBQWtCLENBQUM7S0FBRTtJQUNuRSxNQUFNLE1BQU0sR0FBRyxJQUFJLEdBQUcsQ0FBQyxpQkFBaUIsRUFBRSxDQUFDO0lBQzNDLElBQUksT0FBTyxVQUFVLEtBQUssUUFBUSxFQUFFO1FBQ2hDLE1BQU0sQ0FBQyxPQUFPLENBQUMsSUFBSSxHQUFHLENBQUMsZ0JBQWdCLENBQUMsb0NBQW9DLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLENBQUM7S0FDL0c7SUFDRCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxxQ0FBcUMsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLG1DQUFtQyxDQUFDLENBQUMsQ0FBQztJQUNqSixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxxQ0FBcUMsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLG1DQUFtQyxDQUFDLENBQUMsQ0FBQztJQUNqSixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxpQkFBaUIsRUFBRSxHQUFHLENBQUMsYUFBYSxDQUFDLHVDQUF1QyxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUMsZUFBZSxDQUFDLENBQUMsQ0FBQztJQUNqSixPQUFPLE1BQU0sQ0FBQyxJQUFJLENBQUMsb0VBQW9FLENBQUMsQ0FBQztBQUM3RixDQUFDO0FBRUQ7Ozs7OztHQU1HO0FBQ0gsb0JBQW9CO0FBQ3BCLFNBQVMsb0RBQW9ELENBQUMsVUFBZTtJQUN6RSxJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sVUFBVSxDQUFDO0tBQUU7SUFDdkQsOENBQThDLENBQUMsVUFBVSxDQUFDLENBQUMsYUFBYSxFQUFFLENBQUM7SUFDM0UsT0FBTztRQUNILG1DQUFtQyxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsbUNBQW1DLENBQUM7UUFDL0csbUNBQW1DLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxtQ0FBbUMsQ0FBQztRQUMvRyxlQUFlLEVBQUUsR0FBRyxDQUFDLFVBQVUsQ0FBQyw2Q0FBNkMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxlQUFlLENBQUM7S0FDN0csQ0FBQztBQUNOLENBQUM7QUFFRCxvQkFBb0I7QUFDcEIsU0FBUyxzREFBc0QsQ0FBQyxVQUFlO0lBQzNFLElBQUksR0FBRyxDQUFDLGtCQUFrQixDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQ3BDLE9BQU8sSUFBSSxTQUFTLENBQUMsd0JBQXdCLENBQUMsVUFBVSxDQUFDLENBQUM7S0FDN0Q7SUFDRCxVQUFVLEdBQUcsVUFBVSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUM7SUFDbEQsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsT0FBTyxJQUFJLFNBQVMsQ0FBQyx3QkFBd0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztLQUM3RDtJQUNELE1BQU0sR0FBRyxHQUFHLElBQUksU0FBUyxDQUFDLGdDQUFnQyxFQUF5QyxDQUFDO0lBQ3BHLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxxQ0FBcUMsRUFBRSxxQ0FBcUMsRUFBRSxVQUFVLENBQUMsbUNBQW1DLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxtQ0FBbUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUNqUSxHQUFHLENBQUMsaUJBQWlCLENBQUMscUNBQXFDLEVBQUUscUNBQXFDLEVBQUUsVUFBVSxDQUFDLG1DQUFtQyxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsbUNBQW1DLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDalEsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGlCQUFpQixFQUFFLGlCQUFpQixFQUFFLFVBQVUsQ0FBQyxlQUFlLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsUUFBUSxDQUFDLCtDQUErQyxDQUFDLENBQUMsVUFBVSxDQUFDLGVBQWUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUNqTyxHQUFHLENBQUMsZ0NBQWdDLENBQUMsVUFBVSxDQUFDLENBQUM7SUFDakQsT0FBTyxHQUFHLENBQUM7QUFDZixDQUFDO0FBb0NEOzs7Ozs7R0FNRztBQUNILFNBQVMsdUNBQXVDLENBQUMsVUFBZTtJQUM1RCxJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sR0FBRyxDQUFDLGtCQUFrQixDQUFDO0tBQUU7SUFDbkUsTUFBTSxNQUFNLEdBQUcsSUFBSSxHQUFHLENBQUMsaUJBQWlCLEVBQUUsQ0FBQztJQUMzQyxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxNQUFNLENBQUMsT0FBTyxDQUFDLElBQUksR0FBRyxDQUFDLGdCQUFnQixDQUFDLG9DQUFvQyxHQUFHLElBQUksQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxDQUFDO0tBQy9HO0lBQ0QsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsc0JBQXNCLEVBQUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUMsVUFBVSxDQUFDLG9CQUFvQixDQUFDLENBQUMsQ0FBQztJQUN0SCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxzQkFBc0IsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLG9CQUFvQixDQUFDLENBQUMsQ0FBQztJQUNuSCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxZQUFZLEVBQUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUM7SUFDbEcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsWUFBWSxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQztJQUMvRixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxZQUFZLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDO0lBQy9GLE9BQU8sTUFBTSxDQUFDLElBQUksQ0FBQyw2REFBNkQsQ0FBQyxDQUFDO0FBQ3RGLENBQUM7QUFFRDs7Ozs7O0dBTUc7QUFDSCxvQkFBb0I7QUFDcEIsU0FBUyw2Q0FBNkMsQ0FBQyxVQUFlO0lBQ2xFLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxVQUFVLENBQUM7S0FBRTtJQUN2RCx1Q0FBdUMsQ0FBQyxVQUFVLENBQUMsQ0FBQyxhQUFhLEVBQUUsQ0FBQztJQUNwRSxPQUFPO1FBQ0gsb0JBQW9CLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxvQkFBb0IsQ0FBQztRQUNqRixVQUFVLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUM7UUFDN0QsVUFBVSxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDO0tBQ2hFLENBQUM7QUFDTixDQUFDO0FBRUQsb0JBQW9CO0FBQ3BCLFNBQVMsK0NBQStDLENBQUMsVUFBZTtJQUNwRSxJQUFJLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUNwQyxPQUFPLElBQUksU0FBUyxDQUFDLHdCQUF3QixDQUFDLFVBQVUsQ0FBQyxDQUFDO0tBQzdEO0lBQ0QsVUFBVSxHQUFHLFVBQVUsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDO0lBQ2xELElBQUksT0FBTyxVQUFVLEtBQUssUUFBUSxFQUFFO1FBQ2hDLE9BQU8sSUFBSSxTQUFTLENBQUMsd0JBQXdCLENBQUMsVUFBVSxDQUFDLENBQUM7S0FDN0Q7SUFDRCxNQUFNLEdBQUcsR0FBRyxJQUFJLFNBQVMsQ0FBQyxnQ0FBZ0MsRUFBa0MsQ0FBQztJQUM3RixHQUFHLENBQUMsaUJBQWlCLENBQUMsc0JBQXNCLEVBQUUsc0JBQXNCLEVBQUUsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsb0JBQW9CLENBQUMsQ0FBQyxDQUFDO0lBQy9JLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxZQUFZLEVBQUUsWUFBWSxFQUFFLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUM7SUFDakgsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFlBQVksRUFBRSxZQUFZLEVBQUUsVUFBVSxDQUFDLFVBQVUsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUM3SixHQUFHLENBQUMsZ0NBQWdDLENBQUMsVUFBVSxDQUFDLENBQUM7SUFDakQsT0FBTyxHQUFHLENBQUM7QUFDZixDQUFDO0FBMkdEOzs7Ozs7R0FNRztBQUNILFNBQVMsZ0NBQWdDLENBQUMsVUFBZTtJQUNyRCxJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sR0FBRyxDQUFDLGtCQUFrQixDQUFDO0tBQUU7SUFDbkUsTUFBTSxNQUFNLEdBQUcsSUFBSSxHQUFHLENBQUMsaUJBQWlCLEVBQUUsQ0FBQztJQUMzQyxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxNQUFNLENBQUMsT0FBTyxDQUFDLElBQUksR0FBRyxDQUFDLGdCQUFnQixDQUFDLG9DQUFvQyxHQUFHLElBQUksQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxDQUFDO0tBQy9HO0lBQ0QsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsbUJBQW1CLEVBQUUscURBQXFELENBQUMsQ0FBQyxVQUFVLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxDQUFDO0lBQ2hKLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLG1CQUFtQixFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxDQUFDO0lBQzdHLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGNBQWMsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLFlBQVksQ0FBQyxDQUFDLENBQUM7SUFDbkcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMscUJBQXFCLEVBQUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUMsVUFBVSxDQUFDLG1CQUFtQixDQUFDLENBQUMsQ0FBQztJQUNwSCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxxQkFBcUIsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLG1CQUFtQixDQUFDLENBQUMsQ0FBQztJQUNqSCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyw0QkFBNEIsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLDBCQUEwQixDQUFDLENBQUMsQ0FBQztJQUMvSCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxxQkFBcUIsRUFBRSxHQUFHLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxVQUFVLENBQUMsbUJBQW1CLENBQUMsQ0FBQyxDQUFDO0lBQ3BILE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLHFCQUFxQixFQUFFLEdBQUcsQ0FBQyxhQUFhLENBQUMsc0RBQXNELENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDLENBQUM7SUFDeEssTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsZ0JBQWdCLEVBQUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUMsVUFBVSxDQUFDLGNBQWMsQ0FBQyxDQUFDLENBQUM7SUFDMUcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsZ0JBQWdCLEVBQUUsa0RBQWtELENBQUMsQ0FBQyxVQUFVLENBQUMsY0FBYyxDQUFDLENBQUMsQ0FBQztJQUN2SSxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxTQUFTLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDO0lBQ3pGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFNBQVMsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUM7SUFDekYsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsU0FBUyxFQUFFLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDO0lBQzVGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFNBQVMsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUM7SUFDekYsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsTUFBTSxFQUFFLEdBQUcsQ0FBQyxhQUFhLENBQUMsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUM7SUFDdEcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsWUFBWSxFQUFFLEdBQUcsQ0FBQyxhQUFhLENBQUMsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUM7SUFDbEgsT0FBTyxNQUFNLENBQUMsSUFBSSxDQUFDLCtEQUErRCxDQUFDLENBQUM7QUFDeEYsQ0FBQztBQUVEOzs7Ozs7R0FNRztBQUNILG9CQUFvQjtBQUNwQixTQUFTLHVDQUF1QyxDQUFDLFVBQWU7SUFDNUQsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLFVBQVUsQ0FBQztLQUFFO0lBQ3ZELGdDQUFnQyxDQUFDLFVBQVUsQ0FBQyxDQUFDLGFBQWEsRUFBRSxDQUFDO0lBQzdELE9BQU87UUFDSCxtQkFBbUIsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLG1CQUFtQixDQUFDO1FBQy9FLG1CQUFtQixFQUFFLEdBQUcsQ0FBQyxVQUFVLENBQUMsNERBQTRELENBQUMsQ0FBQyxVQUFVLENBQUMsbUJBQW1CLENBQUM7UUFDakksY0FBYyxFQUFFLHdEQUF3RCxDQUFDLFVBQVUsQ0FBQyxjQUFjLENBQUM7UUFDbkcsT0FBTyxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsT0FBTyxDQUFDO1FBQ3ZELGlCQUFpQixFQUFFLDJEQUEyRCxDQUFDLFVBQVUsQ0FBQyxpQkFBaUIsQ0FBQztRQUM1RyxpQkFBaUIsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLGlCQUFpQixDQUFDO1FBQzNFLFlBQVksRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLFlBQVksQ0FBQztRQUNqRSwwQkFBMEIsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLDBCQUEwQixDQUFDO1FBQzdGLE9BQU8sRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLE9BQU8sQ0FBQztRQUN2RCxPQUFPLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUM7UUFDdkQsSUFBSSxFQUFFLEdBQUcsQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDLHNCQUFzQixDQUFDLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQztRQUNqRSxVQUFVLEVBQUUsR0FBRyxDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUMsc0JBQXNCLENBQUMsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDO0tBQ2hGLENBQUM7QUFDTixDQUFDO0FBRUQsb0JBQW9CO0FBQ3BCLFNBQVMseUNBQXlDLENBQUMsVUFBZTtJQUM5RCxVQUFVLEdBQUcsVUFBVSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUM7SUFDbEQsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsT0FBTyxJQUFJLFNBQVMsQ0FBQyx3QkFBd0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztLQUM3RDtJQUNELE1BQU0sR0FBRyxHQUFHLElBQUksU0FBUyxDQUFDLGdDQUFnQyxFQUEyQixDQUFDO0lBQ3RGLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxxQkFBcUIsRUFBRSxxQkFBcUIsRUFBRSxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDLENBQUM7SUFDNUksR0FBRyxDQUFDLGlCQUFpQixDQUFDLHFCQUFxQixFQUFFLHFCQUFxQixFQUFFLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxRQUFRLENBQUMsOERBQThELENBQUMsQ0FBQyxVQUFVLENBQUMsbUJBQW1CLENBQUMsQ0FBQyxDQUFDO0lBQzNNLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxnQkFBZ0IsRUFBRSxnQkFBZ0IsRUFBRSwwREFBMEQsQ0FBQyxVQUFVLENBQUMsY0FBYyxDQUFDLENBQUMsQ0FBQztJQUNqSixHQUFHLENBQUMsaUJBQWlCLENBQUMsU0FBUyxFQUFFLFNBQVMsRUFBRSxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDO0lBQ3hHLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxtQkFBbUIsRUFBRSxtQkFBbUIsRUFBRSxVQUFVLENBQUMsaUJBQWlCLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyw2REFBNkQsQ0FBQyxVQUFVLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDaE4sR0FBRyxDQUFDLGlCQUFpQixDQUFDLG1CQUFtQixFQUFFLG1CQUFtQixFQUFFLFVBQVUsQ0FBQyxpQkFBaUIsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLGlCQUFpQixDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ3pMLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxjQUFjLEVBQUUsY0FBYyxFQUFFLFVBQVUsQ0FBQyxZQUFZLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxZQUFZLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDckssR0FBRyxDQUFDLGlCQUFpQixDQUFDLDRCQUE0QixFQUFFLDRCQUE0QixFQUFFLFVBQVUsQ0FBQywwQkFBMEIsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLDBCQUEwQixDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQzdOLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxTQUFTLEVBQUUsU0FBUyxFQUFFLFVBQVUsQ0FBQyxPQUFPLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDakosR0FBRyxDQUFDLGlCQUFpQixDQUFDLFNBQVMsRUFBRSxTQUFTLEVBQUUsVUFBVSxDQUFDLE9BQU8sSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUNqSixHQUFHLENBQUMsaUJBQWlCLENBQUMsTUFBTSxFQUFFLE1BQU0sRUFBRSxVQUFVLENBQUMsSUFBSSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFFBQVEsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFnQixDQUFDLENBQUM7SUFDbkwsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFlBQVksRUFBRSxZQUFZLEVBQUUsVUFBVSxDQUFDLFVBQVUsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxjQUFjLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUNsSyxHQUFHLENBQUMsZ0NBQWdDLENBQUMsVUFBVSxDQUFDLENBQUM7SUFDakQsT0FBTyxHQUFHLENBQUM7QUFDZixDQUFDO0FBRUQ7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztHQXdCRztBQUNILE1BQWEsa0JBQW1CLFNBQVEsR0FBRyxDQUFDLFdBQVc7SUFtSW5EOzs7Ozs7T0FNRztJQUNILFlBQVksS0FBb0IsRUFBRSxFQUFVLEVBQUUsS0FBOEI7UUFDeEUsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUUsRUFBRSxJQUFJLEVBQUUsa0JBQWtCLENBQUMsc0JBQXNCLEVBQUUsVUFBVSxFQUFFLEtBQUssRUFBRSxDQUFDLENBQUM7Ozs7Ozs7Ozs7UUFDekYsR0FBRyxDQUFDLGVBQWUsQ0FBQyxLQUFLLEVBQUUscUJBQXFCLEVBQUUsSUFBSSxDQUFDLENBQUM7UUFDeEQsR0FBRyxDQUFDLGVBQWUsQ0FBQyxLQUFLLEVBQUUscUJBQXFCLEVBQUUsSUFBSSxDQUFDLENBQUM7UUFDeEQsR0FBRyxDQUFDLGVBQWUsQ0FBQyxLQUFLLEVBQUUsZ0JBQWdCLEVBQUUsSUFBSSxDQUFDLENBQUM7UUFDbkQsR0FBRyxDQUFDLGVBQWUsQ0FBQyxLQUFLLEVBQUUsU0FBUyxFQUFFLElBQUksQ0FBQyxDQUFDO1FBQzVDLElBQUksQ0FBQyx1QkFBdUIsR0FBRyxHQUFHLENBQUMsS0FBSyxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLHFCQUFxQixDQUFDLENBQUMsQ0FBQztRQUN0RixJQUFJLENBQUMsc0JBQXNCLEdBQUcsR0FBRyxDQUFDLEtBQUssQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDLENBQUM7UUFFcEYsSUFBSSxDQUFDLG1CQUFtQixHQUFHLEtBQUssQ0FBQyxtQkFBbUIsQ0FBQztRQUNyRCxJQUFJLENBQUMsbUJBQW1CLEdBQUcsS0FBSyxDQUFDLG1CQUFtQixDQUFDO1FBQ3JELElBQUksQ0FBQyxjQUFjLEdBQUcsS0FBSyxDQUFDLGNBQWMsQ0FBQztRQUMzQyxJQUFJLENBQUMsT0FBTyxHQUFHLEtBQUssQ0FBQyxPQUFPLENBQUM7UUFDN0IsSUFBSSxDQUFDLGlCQUFpQixHQUFHLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQztRQUNqRCxJQUFJLENBQUMsaUJBQWlCLEdBQUcsS0FBSyxDQUFDLGlCQUFpQixDQUFDO1FBQ2pELElBQUksQ0FBQyxZQUFZLEdBQUcsS0FBSyxDQUFDLFlBQVksQ0FBQztRQUN2QyxJQUFJLENBQUMsMEJBQTBCLEdBQUcsS0FBSyxDQUFDLDBCQUEwQixDQUFDO1FBQ25FLElBQUksQ0FBQyxPQUFPLEdBQUcsS0FBSyxDQUFDLE9BQU8sQ0FBQztRQUM3QixJQUFJLENBQUMsT0FBTyxHQUFHLEtBQUssQ0FBQyxPQUFPLENBQUM7UUFDN0IsSUFBSSxDQUFDLElBQUksR0FBRyxJQUFJLEdBQUcsQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDLE9BQU8sQ0FBQyxRQUFRLEVBQUUsZ0NBQWdDLEVBQUUsS0FBSyxDQUFDLElBQUksRUFBRSxFQUFFLGVBQWUsRUFBRSxNQUFNLEVBQUUsQ0FBQyxDQUFDO1FBQ2hJLElBQUksQ0FBQyxVQUFVLEdBQUcsS0FBSyxDQUFDLFVBQVUsQ0FBQztLQUN0QztJQXpKRDs7Ozs7O09BTUc7SUFDSSxNQUFNLENBQUMsbUJBQW1CLENBQUMsS0FBb0IsRUFBRSxFQUFVLEVBQUUsa0JBQXVCLEVBQUUsT0FBNEM7UUFDckksa0JBQWtCLEdBQUcsa0JBQWtCLElBQUksRUFBRSxDQUFDO1FBQzlDLE1BQU0sa0JBQWtCLEdBQUcsT0FBTyxDQUFDLE1BQU0sQ0FBQyxVQUFVLENBQUMsa0JBQWtCLENBQUMsVUFBVSxDQUFDLENBQUM7UUFDcEYsTUFBTSxXQUFXLEdBQUcseUNBQXlDLENBQUMsa0JBQWtCLENBQUMsQ0FBQztRQUNsRixNQUFNLEdBQUcsR0FBRyxJQUFJLGtCQUFrQixDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUUsV0FBVyxDQUFDLEtBQUssQ0FBQyxDQUFDO1FBQ2pFLEtBQUssTUFBTSxDQUFDLE9BQU8sRUFBRSxPQUFPLENBQUMsSUFBSSxNQUFNLENBQUMsT0FBTyxDQUFDLFdBQVcsQ0FBQyxlQUFlLENBQUMsRUFBRztZQUMzRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsT0FBTyxFQUFFLE9BQU8sQ0FBQyxDQUFDO1NBQzdDO1FBQ0QsT0FBTyxDQUFDLE1BQU0sQ0FBQyxnQkFBZ0IsQ0FBQyxHQUFHLEVBQUUsa0JBQWtCLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFDN0QsT0FBTyxHQUFHLENBQUM7S0FDZDtJQTBJRDs7Ozs7T0FLRztJQUNJLE9BQU8sQ0FBQyxTQUE0QjtRQUN2QyxTQUFTLENBQUMsWUFBWSxDQUFDLDZCQUE2QixFQUFFLGtCQUFrQixDQUFDLHNCQUFzQixDQUFDLENBQUM7UUFDakcsU0FBUyxDQUFDLFlBQVksQ0FBQyw4QkFBOEIsRUFBRSxJQUFJLENBQUMsYUFBYSxDQUFDLENBQUM7S0FDOUU7SUFFRCxJQUFjLGFBQWE7UUFDdkIsT0FBTztZQUNILG1CQUFtQixFQUFFLElBQUksQ0FBQyxtQkFBbUI7WUFDN0MsbUJBQW1CLEVBQUUsSUFBSSxDQUFDLG1CQUFtQjtZQUM3QyxjQUFjLEVBQUUsSUFBSSxDQUFDLGNBQWM7WUFDbkMsT0FBTyxFQUFFLElBQUksQ0FBQyxPQUFPO1lBQ3JCLGlCQUFpQixFQUFFLElBQUksQ0FBQyxpQkFBaUI7WUFDekMsaUJBQWlCLEVBQUUsSUFBSSxDQUFDLGlCQUFpQjtZQUN6QyxZQUFZLEVBQUUsSUFBSSxDQUFDLFlBQVk7WUFDL0IsMEJBQTBCLEVBQUUsSUFBSSxDQUFDLDBCQUEwQjtZQUMzRCxPQUFPLEVBQUUsSUFBSSxDQUFDLE9BQU87WUFDckIsT0FBTyxFQUFFLElBQUksQ0FBQyxPQUFPO1lBQ3JCLElBQUksRUFBRSxJQUFJLENBQUMsSUFBSSxDQUFDLFVBQVUsRUFBRTtZQUM1QixVQUFVLEVBQUUsSUFBSSxDQUFDLFVBQVU7U0FDOUIsQ0FBQztLQUNMO0lBRVMsZ0JBQWdCLENBQUMsS0FBMkI7UUFDbEQsT0FBTyx1Q0FBdUMsQ0FBQyxLQUFLLENBQUMsQ0FBQztLQUN6RDs7QUEvTEwsZ0RBZ01DOzs7QUEvTEc7O0dBRUc7QUFDb0IseUNBQXNCLEdBQUcsZ0NBQWdDLENBQUM7QUF5TnJGOzs7Ozs7R0FNRztBQUNILFNBQVMscURBQXFELENBQUMsVUFBZTtJQUMxRSxJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sR0FBRyxDQUFDLGtCQUFrQixDQUFDO0tBQUU7SUFDbkUsTUFBTSxNQUFNLEdBQUcsSUFBSSxHQUFHLENBQUMsaUJBQWlCLEVBQUUsQ0FBQztJQUMzQyxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxNQUFNLENBQUMsT0FBTyxDQUFDLElBQUksR0FBRyxDQUFDLGdCQUFnQixDQUFDLG9DQUFvQyxHQUFHLElBQUksQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxDQUFDO0tBQy9HO0lBQ0QsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMseUJBQXlCLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyx1QkFBdUIsQ0FBQyxDQUFDLENBQUM7SUFDekgsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsNkJBQTZCLEVBQUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUMsVUFBVSxDQUFDLDJCQUEyQixDQUFDLENBQUMsQ0FBQztJQUNwSSxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyw2QkFBNkIsRUFBRSwrREFBK0QsQ0FBQyxDQUFDLFVBQVUsQ0FBQywyQkFBMkIsQ0FBQyxDQUFDLENBQUM7SUFDOUssT0FBTyxNQUFNLENBQUMsSUFBSSxDQUFDLGlFQUFpRSxDQUFDLENBQUM7QUFDMUYsQ0FBQztBQUVEOzs7Ozs7R0FNRztBQUNILG9CQUFvQjtBQUNwQixTQUFTLDJEQUEyRCxDQUFDLFVBQWU7SUFDaEYsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLFVBQVUsQ0FBQztLQUFFO0lBQ3ZELHFEQUFxRCxDQUFDLFVBQVUsQ0FBQyxDQUFDLGFBQWEsRUFBRSxDQUFDO0lBQ2xGLE9BQU87UUFDSCx1QkFBdUIsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLHVCQUF1QixDQUFDO1FBQ3ZGLDJCQUEyQixFQUFFLHFFQUFxRSxDQUFDLFVBQVUsQ0FBQywyQkFBMkIsQ0FBQztLQUM3SSxDQUFDO0FBQ04sQ0FBQztBQUVELG9CQUFvQjtBQUNwQixTQUFTLDZEQUE2RCxDQUFDLFVBQWU7SUFDbEYsSUFBSSxHQUFHLENBQUMsa0JBQWtCLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFDcEMsT0FBTyxJQUFJLFNBQVMsQ0FBQyx3QkFBd0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztLQUM3RDtJQUNELFVBQVUsR0FBRyxVQUFVLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQztJQUNsRCxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxPQUFPLElBQUksU0FBUyxDQUFDLHdCQUF3QixDQUFDLFVBQVUsQ0FBQyxDQUFDO0tBQzdEO0lBQ0QsTUFBTSxHQUFHLEdBQUcsSUFBSSxTQUFTLENBQUMsZ0NBQWdDLEVBQWdELENBQUM7SUFDM0csR0FBRyxDQUFDLGlCQUFpQixDQUFDLHlCQUF5QixFQUFFLHlCQUF5QixFQUFFLFVBQVUsQ0FBQyx1QkFBdUIsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLHVCQUF1QixDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ2pOLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyw2QkFBNkIsRUFBRSw2QkFBNkIsRUFBRSx1RUFBdUUsQ0FBQyxVQUFVLENBQUMsMkJBQTJCLENBQUMsQ0FBQyxDQUFDO0lBQ3JNLEdBQUcsQ0FBQyxnQ0FBZ0MsQ0FBQyxVQUFVLENBQUMsQ0FBQztJQUNqRCxPQUFPLEdBQUcsQ0FBQztBQUNmLENBQUM7QUE2QkQ7Ozs7OztHQU1HO0FBQ0gsU0FBUyxzREFBc0QsQ0FBQyxVQUFlO0lBQzNFLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxHQUFHLENBQUMsa0JBQWtCLENBQUM7S0FBRTtJQUNuRSxNQUFNLE1BQU0sR0FBRyxJQUFJLEdBQUcsQ0FBQyxpQkFBaUIsRUFBRSxDQUFDO0lBQzNDLElBQUksT0FBTyxVQUFVLEtBQUssUUFBUSxFQUFFO1FBQ2hDLE1BQU0sQ0FBQyxPQUFPLENBQUMsSUFBSSxHQUFHLENBQUMsZ0JBQWdCLENBQUMsb0NBQW9DLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLENBQUM7S0FDL0c7SUFDRCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxjQUFjLEVBQUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUMsVUFBVSxDQUFDLFlBQVksQ0FBQyxDQUFDLENBQUM7SUFDdEcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsY0FBYyxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsWUFBWSxDQUFDLENBQUMsQ0FBQztJQUNuRyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxrQkFBa0IsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLGdCQUFnQixDQUFDLENBQUMsQ0FBQztJQUMzRyxPQUFPLE1BQU0sQ0FBQyxJQUFJLENBQUMsa0VBQWtFLENBQUMsQ0FBQztBQUMzRixDQUFDO0FBRUQ7Ozs7OztHQU1HO0FBQ0gsb0JBQW9CO0FBQ3BCLFNBQVMsNERBQTRELENBQUMsVUFBZTtJQUNqRixJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sVUFBVSxDQUFDO0tBQUU7SUFDdkQsc0RBQXNELENBQUMsVUFBVSxDQUFDLENBQUMsYUFBYSxFQUFFLENBQUM7SUFDbkYsT0FBTztRQUNILFlBQVksRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLFlBQVksQ0FBQztRQUNqRSxnQkFBZ0IsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLGdCQUFnQixDQUFDO0tBQzVFLENBQUM7QUFDTixDQUFDO0FBRUQsb0JBQW9CO0FBQ3BCLFNBQVMsOERBQThELENBQUMsVUFBZTtJQUNuRixJQUFJLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUNwQyxPQUFPLElBQUksU0FBUyxDQUFDLHdCQUF3QixDQUFDLFVBQVUsQ0FBQyxDQUFDO0tBQzdEO0lBQ0QsVUFBVSxHQUFHLFVBQVUsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDO0lBQ2xELElBQUksT0FBTyxVQUFVLEtBQUssUUFBUSxFQUFFO1FBQ2hDLE9BQU8sSUFBSSxTQUFTLENBQUMsd0JBQXdCLENBQUMsVUFBVSxDQUFDLENBQUM7S0FDN0Q7SUFDRCxNQUFNLEdBQUcsR0FBRyxJQUFJLFNBQVMsQ0FBQyxnQ0FBZ0MsRUFBaUQsQ0FBQztJQUM1RyxHQUFHLENBQUMsaUJBQWlCLENBQUMsY0FBYyxFQUFFLGNBQWMsRUFBRSxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxZQUFZLENBQUMsQ0FBQyxDQUFDO0lBQ3ZILEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxrQkFBa0IsRUFBRSxrQkFBa0IsRUFBRSxVQUFVLENBQUMsZ0JBQWdCLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUNyTCxHQUFHLENBQUMsZ0NBQWdDLENBQUMsVUFBVSxDQUFDLENBQUM7SUFDakQsT0FBTyxHQUFHLENBQUM7QUFDZixDQUFDO0FBbUNEOzs7Ozs7R0FNRztBQUNILFNBQVMsa0RBQWtELENBQUMsVUFBZTtJQUN2RSxJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sR0FBRyxDQUFDLGtCQUFrQixDQUFDO0tBQUU7SUFDbkUsTUFBTSxNQUFNLEdBQUcsSUFBSSxHQUFHLENBQUMsaUJBQWlCLEVBQUUsQ0FBQztJQUMzQyxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxNQUFNLENBQUMsT0FBTyxDQUFDLElBQUksR0FBRyxDQUFDLGdCQUFnQixDQUFDLG9DQUFvQyxHQUFHLElBQUksQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxDQUFDO0tBQy9HO0lBQ0QsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsa0JBQWtCLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDLENBQUM7SUFDM0csTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsb0JBQW9CLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDLENBQUM7SUFDL0csTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsU0FBUyxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQztJQUN6RixPQUFPLE1BQU0sQ0FBQyxJQUFJLENBQUMsOERBQThELENBQUMsQ0FBQztBQUN2RixDQUFDO0FBRUQ7Ozs7OztHQU1HO0FBQ0gsb0JBQW9CO0FBQ3BCLFNBQVMsd0RBQXdELENBQUMsVUFBZTtJQUM3RSxJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sVUFBVSxDQUFDO0tBQUU7SUFDdkQsa0RBQWtELENBQUMsVUFBVSxDQUFDLENBQUMsYUFBYSxFQUFFLENBQUM7SUFDL0UsT0FBTztRQUNILGdCQUFnQixFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsZ0JBQWdCLENBQUM7UUFDekUsa0JBQWtCLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxrQkFBa0IsQ0FBQztRQUM3RSxPQUFPLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUM7S0FDMUQsQ0FBQztBQUNOLENBQUM7QUFFRCxvQkFBb0I7QUFDcEIsU0FBUywwREFBMEQsQ0FBQyxVQUFlO0lBQy9FLElBQUksR0FBRyxDQUFDLGtCQUFrQixDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQ3BDLE9BQU8sSUFBSSxTQUFTLENBQUMsd0JBQXdCLENBQUMsVUFBVSxDQUFDLENBQUM7S0FDN0Q7SUFDRCxVQUFVLEdBQUcsVUFBVSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUM7SUFDbEQsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsT0FBTyxJQUFJLFNBQVMsQ0FBQyx3QkFBd0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztLQUM3RDtJQUNELE1BQU0sR0FBRyxHQUFHLElBQUksU0FBUyxDQUFDLGdDQUFnQyxFQUE2QyxDQUFDO0lBQ3hHLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxrQkFBa0IsRUFBRSxrQkFBa0IsRUFBRSxVQUFVLENBQUMsZ0JBQWdCLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUNyTCxHQUFHLENBQUMsaUJBQWlCLENBQUMsb0JBQW9CLEVBQUUsb0JBQW9CLEVBQUUsVUFBVSxDQUFDLGtCQUFrQixJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsa0JBQWtCLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDN0wsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFNBQVMsRUFBRSxTQUFTLEVBQUUsVUFBVSxDQUFDLE9BQU8sSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUNqSixHQUFHLENBQUMsZ0NBQWdDLENBQUMsVUFBVSxDQUFDLENBQUM7SUFDakQsT0FBTyxHQUFHLENBQUM7QUFDZixDQUFDO0FBdUJEOzs7Ozs7R0FNRztBQUNILFNBQVMsK0RBQStELENBQUMsVUFBZTtJQUNwRixJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sR0FBRyxDQUFDLGtCQUFrQixDQUFDO0tBQUU7SUFDbkUsTUFBTSxNQUFNLEdBQUcsSUFBSSxHQUFHLENBQUMsaUJBQWlCLEVBQUUsQ0FBQztJQUMzQyxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxNQUFNLENBQUMsT0FBTyxDQUFDLElBQUksR0FBRyxDQUFDLGdCQUFnQixDQUFDLG9DQUFvQyxHQUFHLElBQUksQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxDQUFDO0tBQy9HO0lBQ0QsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsYUFBYSxFQUFFLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxXQUFXLENBQUMsQ0FBQyxDQUFDO0lBQ3BHLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGFBQWEsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLFdBQVcsQ0FBQyxDQUFDLENBQUM7SUFDakcsT0FBTyxNQUFNLENBQUMsSUFBSSxDQUFDLDJFQUEyRSxDQUFDLENBQUM7QUFDcEcsQ0FBQztBQUVEOzs7Ozs7R0FNRztBQUNILG9CQUFvQjtBQUNwQixTQUFTLHFFQUFxRSxDQUFDLFVBQWU7SUFDMUYsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLFVBQVUsQ0FBQztLQUFFO0lBQ3ZELCtEQUErRCxDQUFDLFVBQVUsQ0FBQyxDQUFDLGFBQWEsRUFBRSxDQUFDO0lBQzVGLE9BQU87UUFDSCxXQUFXLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxXQUFXLENBQUM7S0FDbEUsQ0FBQztBQUNOLENBQUM7QUFFRCxvQkFBb0I7QUFDcEIsU0FBUyx1RUFBdUUsQ0FBQyxVQUFlO0lBQzVGLElBQUksR0FBRyxDQUFDLGtCQUFrQixDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQ3BDLE9BQU8sSUFBSSxTQUFTLENBQUMsd0JBQXdCLENBQUMsVUFBVSxDQUFDLENBQUM7S0FDN0Q7SUFDRCxVQUFVLEdBQUcsVUFBVSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUM7SUFDbEQsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsT0FBTyxJQUFJLFNBQVMsQ0FBQyx3QkFBd0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztLQUM3RDtJQUNELE1BQU0sR0FBRyxHQUFHLElBQUksU0FBUyxDQUFDLGdDQUFnQyxFQUEwRCxDQUFDO0lBQ3JILEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxhQUFhLEVBQUUsYUFBYSxFQUFFLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLFdBQVcsQ0FBQyxDQUFDLENBQUM7SUFDcEgsR0FBRyxDQUFDLGdDQUFnQyxDQUFDLFVBQVUsQ0FBQyxDQUFDO0lBQ2pELE9BQU8sR0FBRyxDQUFDO0FBQ2YsQ0FBQztBQTRFRDs7Ozs7O0dBTUc7QUFDSCxTQUFTLGlDQUFpQyxDQUFDLFVBQWU7SUFDdEQsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQztLQUFFO0lBQ25FLE1BQU0sTUFBTSxHQUFHLElBQUksR0FBRyxDQUFDLGlCQUFpQixFQUFFLENBQUM7SUFDM0MsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsTUFBTSxDQUFDLE9BQU8sQ0FBQyxJQUFJLEdBQUcsQ0FBQyxnQkFBZ0IsQ0FBQyxvQ0FBb0MsR0FBRyxJQUFJLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUMsQ0FBQztLQUMvRztJQUNELE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGlCQUFpQixFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsZUFBZSxDQUFDLENBQUMsQ0FBQztJQUN6RyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxjQUFjLEVBQUUsR0FBRyxDQUFDLGFBQWEsQ0FBQyxnREFBZ0QsQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDLFlBQVksQ0FBQyxDQUFDLENBQUM7SUFDcEosTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMscUJBQXFCLEVBQUUsd0RBQXdELENBQUMsQ0FBQyxVQUFVLENBQUMsbUJBQW1CLENBQUMsQ0FBQyxDQUFDO0lBQ3ZKLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLE1BQU0sRUFBRSxHQUFHLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQztJQUN0RixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxNQUFNLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDO0lBQ25GLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLG9CQUFvQixFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsa0JBQWtCLENBQUMsQ0FBQyxDQUFDO0lBQy9HLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLHVCQUF1QixFQUFFLEdBQUcsQ0FBQyxhQUFhLENBQUMsd0RBQXdELENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDLENBQUM7SUFDOUssTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsdUJBQXVCLEVBQUUsMERBQTBELENBQUMsQ0FBQyxVQUFVLENBQUMscUJBQXFCLENBQUMsQ0FBQyxDQUFDO0lBQzdKLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLE1BQU0sRUFBRSxHQUFHLENBQUMsYUFBYSxDQUFDLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDO0lBQ3RHLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGtCQUFrQixFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsZ0JBQWdCLENBQUMsQ0FBQyxDQUFDO0lBQzNHLE9BQU8sTUFBTSxDQUFDLElBQUksQ0FBQyxnRUFBZ0UsQ0FBQyxDQUFDO0FBQ3pGLENBQUM7QUFFRDs7Ozs7O0dBTUc7QUFDSCxvQkFBb0I7QUFDcEIsU0FBUyx3Q0FBd0MsQ0FBQyxVQUFlO0lBQzdELElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxVQUFVLENBQUM7S0FBRTtJQUN2RCxpQ0FBaUMsQ0FBQyxVQUFVLENBQUMsQ0FBQyxhQUFhLEVBQUUsQ0FBQztJQUM5RCxPQUFPO1FBQ0gsSUFBSSxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDO1FBQ2pELGVBQWUsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLGVBQWUsQ0FBQztRQUN2RSxZQUFZLEVBQUUsR0FBRyxDQUFDLFVBQVUsQ0FBQyxzREFBc0QsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxZQUFZLENBQUM7UUFDN0csbUJBQW1CLEVBQUUsOERBQThELENBQUMsVUFBVSxDQUFDLG1CQUFtQixDQUFDO1FBQ25ILGtCQUFrQixFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsa0JBQWtCLENBQUM7UUFDN0UscUJBQXFCLEVBQUUsR0FBRyxDQUFDLFVBQVUsQ0FBQyw4REFBOEQsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxxQkFBcUIsQ0FBQztRQUN2SSxxQkFBcUIsRUFBRSxnRUFBZ0UsQ0FBQyxVQUFVLENBQUMscUJBQXFCLENBQUM7UUFDekgsSUFBSSxFQUFFLEdBQUcsQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDLHNCQUFzQixDQUFDLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQztRQUNqRSxnQkFBZ0IsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLGdCQUFnQixDQUFDO0tBQzVFLENBQUM7QUFDTixDQUFDO0FBRUQsb0JBQW9CO0FBQ3BCLFNBQVMsMENBQTBDLENBQUMsVUFBZTtJQUMvRCxVQUFVLEdBQUcsVUFBVSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUM7SUFDbEQsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsT0FBTyxJQUFJLFNBQVMsQ0FBQyx3QkFBd0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztLQUM3RDtJQUNELE1BQU0sR0FBRyxHQUFHLElBQUksU0FBUyxDQUFDLGdDQUFnQyxFQUE0QixDQUFDO0lBQ3ZGLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxNQUFNLEVBQUUsTUFBTSxFQUFFLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUM7SUFDL0YsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGlCQUFpQixFQUFFLGlCQUFpQixFQUFFLFVBQVUsQ0FBQyxlQUFlLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxlQUFlLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDakwsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGNBQWMsRUFBRSxjQUFjLEVBQUUsVUFBVSxDQUFDLFlBQVksSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxRQUFRLENBQUMsd0RBQXdELENBQUMsQ0FBQyxVQUFVLENBQUMsWUFBWSxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQzlOLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxxQkFBcUIsRUFBRSxxQkFBcUIsRUFBRSxVQUFVLENBQUMsbUJBQW1CLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxnRUFBZ0UsQ0FBQyxVQUFVLENBQUMsbUJBQW1CLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDM04sR0FBRyxDQUFDLGlCQUFpQixDQUFDLG9CQUFvQixFQUFFLG9CQUFvQixFQUFFLFVBQVUsQ0FBQyxrQkFBa0IsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLGtCQUFrQixDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQzdMLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyx1QkFBdUIsRUFBRSx1QkFBdUIsRUFBRSxVQUFVLENBQUMscUJBQXFCLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsUUFBUSxDQUFDLGdFQUFnRSxDQUFDLENBQUMsVUFBVSxDQUFDLHFCQUFxQixDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQzFRLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyx1QkFBdUIsRUFBRSx1QkFBdUIsRUFBRSxVQUFVLENBQUMscUJBQXFCLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxrRUFBa0UsQ0FBQyxVQUFVLENBQUMscUJBQXFCLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDck8sR0FBRyxDQUFDLGlCQUFpQixDQUFDLE1BQU0sRUFBRSxNQUFNLEVBQUUsVUFBVSxDQUFDLElBQUksSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxRQUFRLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBZ0IsQ0FBQyxDQUFDO0lBQ25MLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxrQkFBa0IsRUFBRSxrQkFBa0IsRUFBRSxVQUFVLENBQUMsZ0JBQWdCLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUNyTCxHQUFHLENBQUMsZ0NBQWdDLENBQUMsVUFBVSxDQUFDLENBQUM7SUFDakQsT0FBTyxHQUFHLENBQUM7QUFDZixDQUFDO0FBRUQ7Ozs7Ozs7OztHQVNHO0FBQ0gsTUFBYSxtQkFBb0IsU0FBUSxHQUFHLENBQUMsV0FBVztJQW9HcEQ7Ozs7OztPQU1HO0lBQ0gsWUFBWSxLQUFvQixFQUFFLEVBQVUsRUFBRSxLQUErQjtRQUN6RSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxFQUFFLElBQUksRUFBRSxtQkFBbUIsQ0FBQyxzQkFBc0IsRUFBRSxVQUFVLEVBQUUsS0FBSyxFQUFFLENBQUMsQ0FBQzs7Ozs7Ozs7OztRQUMxRixHQUFHLENBQUMsZUFBZSxDQUFDLEtBQUssRUFBRSxNQUFNLEVBQUUsSUFBSSxDQUFDLENBQUM7UUFDekMsSUFBSSxDQUFDLE9BQU8sR0FBRyxHQUFHLENBQUMsS0FBSyxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUM7UUFDdEQsSUFBSSxDQUFDLFFBQVEsR0FBRyxHQUFHLENBQUMsS0FBSyxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUM7UUFFeEQsSUFBSSxDQUFDLElBQUksR0FBRyxLQUFLLENBQUMsSUFBSSxDQUFDO1FBQ3ZCLElBQUksQ0FBQyxlQUFlLEdBQUcsS0FBSyxDQUFDLGVBQWUsQ0FBQztRQUM3QyxJQUFJLENBQUMsWUFBWSxHQUFHLEtBQUssQ0FBQyxZQUFZLENBQUM7UUFDdkMsSUFBSSxDQUFDLG1CQUFtQixHQUFHLEtBQUssQ0FBQyxtQkFBbUIsQ0FBQztRQUNyRCxJQUFJLENBQUMsa0JBQWtCLEdBQUcsS0FBSyxDQUFDLGtCQUFrQixDQUFDO1FBQ25ELElBQUksQ0FBQyxxQkFBcUIsR0FBRyxLQUFLLENBQUMscUJBQXFCLENBQUM7UUFDekQsSUFBSSxDQUFDLHFCQUFxQixHQUFHLEtBQUssQ0FBQyxxQkFBcUIsQ0FBQztRQUN6RCxJQUFJLENBQUMsSUFBSSxHQUFHLElBQUksR0FBRyxDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUMsT0FBTyxDQUFDLFFBQVEsRUFBRSxpQ0FBaUMsRUFBRSxLQUFLLENBQUMsSUFBSSxFQUFFLEVBQUUsZUFBZSxFQUFFLE1BQU0sRUFBRSxDQUFDLENBQUM7UUFDakksSUFBSSxDQUFDLGdCQUFnQixHQUFHLEtBQUssQ0FBQyxnQkFBZ0IsQ0FBQztLQUNsRDtJQXBIRDs7Ozs7O09BTUc7SUFDSSxNQUFNLENBQUMsbUJBQW1CLENBQUMsS0FBb0IsRUFBRSxFQUFVLEVBQUUsa0JBQXVCLEVBQUUsT0FBNEM7UUFDckksa0JBQWtCLEdBQUcsa0JBQWtCLElBQUksRUFBRSxDQUFDO1FBQzlDLE1BQU0sa0JBQWtCLEdBQUcsT0FBTyxDQUFDLE1BQU0sQ0FBQyxVQUFVLENBQUMsa0JBQWtCLENBQUMsVUFBVSxDQUFDLENBQUM7UUFDcEYsTUFBTSxXQUFXLEdBQUcsMENBQTBDLENBQUMsa0JBQWtCLENBQUMsQ0FBQztRQUNuRixNQUFNLEdBQUcsR0FBRyxJQUFJLG1CQUFtQixDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUUsV0FBVyxDQUFDLEtBQUssQ0FBQyxDQUFDO1FBQ2xFLEtBQUssTUFBTSxDQUFDLE9BQU8sRUFBRSxPQUFPLENBQUMsSUFBSSxNQUFNLENBQUMsT0FBTyxDQUFDLFdBQVcsQ0FBQyxlQUFlLENBQUMsRUFBRztZQUMzRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsT0FBTyxFQUFFLE9BQU8sQ0FBQyxDQUFDO1NBQzdDO1FBQ0QsT0FBTyxDQUFDLE1BQU0sQ0FBQyxnQkFBZ0IsQ0FBQyxHQUFHLEVBQUUsa0JBQWtCLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFDN0QsT0FBTyxHQUFHLENBQUM7S0FDZDtJQXFHRDs7Ozs7T0FLRztJQUNJLE9BQU8sQ0FBQyxTQUE0QjtRQUN2QyxTQUFTLENBQUMsWUFBWSxDQUFDLDZCQUE2QixFQUFFLG1CQUFtQixDQUFDLHNCQUFzQixDQUFDLENBQUM7UUFDbEcsU0FBUyxDQUFDLFlBQVksQ0FBQyw4QkFBOEIsRUFBRSxJQUFJLENBQUMsYUFBYSxDQUFDLENBQUM7S0FDOUU7SUFFRCxJQUFjLGFBQWE7UUFDdkIsT0FBTztZQUNILElBQUksRUFBRSxJQUFJLENBQUMsSUFBSTtZQUNmLGVBQWUsRUFBRSxJQUFJLENBQUMsZUFBZTtZQUNyQyxZQUFZLEVBQUUsSUFBSSxDQUFDLFlBQVk7WUFDL0IsbUJBQW1CLEVBQUUsSUFBSSxDQUFDLG1CQUFtQjtZQUM3QyxrQkFBa0IsRUFBRSxJQUFJLENBQUMsa0JBQWtCO1lBQzNDLHFCQUFxQixFQUFFLElBQUksQ0FBQyxxQkFBcUI7WUFDakQscUJBQXFCLEVBQUUsSUFBSSxDQUFDLHFCQUFxQjtZQUNqRCxJQUFJLEVBQUUsSUFBSSxDQUFDLElBQUksQ0FBQyxVQUFVLEVBQUU7WUFDNUIsZ0JBQWdCLEVBQUUsSUFBSSxDQUFDLGdCQUFnQjtTQUMxQyxDQUFDO0tBQ0w7SUFFUyxnQkFBZ0IsQ0FBQyxLQUEyQjtRQUNsRCxPQUFPLHdDQUF3QyxDQUFDLEtBQUssQ0FBQyxDQUFDO0tBQzFEOztBQXZKTCxrREF3SkM7OztBQXZKRzs7R0FFRztBQUNvQiwwQ0FBc0IsR0FBRyxpQ0FBaUMsQ0FBQztBQXlLdEY7Ozs7OztHQU1HO0FBQ0gsU0FBUyxnREFBZ0QsQ0FBQyxVQUFlO0lBQ3JFLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxHQUFHLENBQUMsa0JBQWtCLENBQUM7S0FBRTtJQUNuRSxNQUFNLE1BQU0sR0FBRyxJQUFJLEdBQUcsQ0FBQyxpQkFBaUIsRUFBRSxDQUFDO0lBQzNDLElBQUksT0FBTyxVQUFVLEtBQUssUUFBUSxFQUFFO1FBQ2hDLE1BQU0sQ0FBQyxPQUFPLENBQUMsSUFBSSxHQUFHLENBQUMsZ0JBQWdCLENBQUMsb0NBQW9DLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLENBQUM7S0FDL0c7SUFDRCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxnQkFBZ0IsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLGNBQWMsQ0FBQyxDQUFDLENBQUM7SUFDdkcsT0FBTyxNQUFNLENBQUMsSUFBSSxDQUFDLDJEQUEyRCxDQUFDLENBQUM7QUFDcEYsQ0FBQztBQUVEOzs7Ozs7R0FNRztBQUNILG9CQUFvQjtBQUNwQixTQUFTLHNEQUFzRCxDQUFDLFVBQWU7SUFDM0UsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLFVBQVUsQ0FBQztLQUFFO0lBQ3ZELGdEQUFnRCxDQUFDLFVBQVUsQ0FBQyxDQUFDLGFBQWEsRUFBRSxDQUFDO0lBQzdFLE9BQU87UUFDSCxjQUFjLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxjQUFjLENBQUM7S0FDeEUsQ0FBQztBQUNOLENBQUM7QUFFRCxvQkFBb0I7QUFDcEIsU0FBUyx3REFBd0QsQ0FBQyxVQUFlO0lBQzdFLElBQUksR0FBRyxDQUFDLGtCQUFrQixDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQ3BDLE9BQU8sSUFBSSxTQUFTLENBQUMsd0JBQXdCLENBQUMsVUFBVSxDQUFDLENBQUM7S0FDN0Q7SUFDRCxVQUFVLEdBQUcsVUFBVSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUM7SUFDbEQsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsT0FBTyxJQUFJLFNBQVMsQ0FBQyx3QkFBd0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztLQUM3RDtJQUNELE1BQU0sR0FBRyxHQUFHLElBQUksU0FBUyxDQUFDLGdDQUFnQyxFQUEyQyxDQUFDO0lBQ3RHLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxnQkFBZ0IsRUFBRSxnQkFBZ0IsRUFBRSxVQUFVLENBQUMsY0FBYyxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsY0FBYyxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQzdLLEdBQUcsQ0FBQyxnQ0FBZ0MsQ0FBQyxVQUFVLENBQUMsQ0FBQztJQUNqRCxPQUFPLEdBQUcsQ0FBQztBQUNmLENBQUM7QUFxQkQ7Ozs7OztHQU1HO0FBQ0gsU0FBUyx3REFBd0QsQ0FBQyxVQUFlO0lBQzdFLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxHQUFHLENBQUMsa0JBQWtCLENBQUM7S0FBRTtJQUNuRSxNQUFNLE1BQU0sR0FBRyxJQUFJLEdBQUcsQ0FBQyxpQkFBaUIsRUFBRSxDQUFDO0lBQzNDLElBQUksT0FBTyxVQUFVLEtBQUssUUFBUSxFQUFFO1FBQ2hDLE1BQU0sQ0FBQyxPQUFPLENBQUMsSUFBSSxHQUFHLENBQUMsZ0JBQWdCLENBQUMsb0NBQW9DLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLENBQUM7S0FDL0c7SUFDRCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxrQkFBa0IsRUFBRSxHQUFHLENBQUMsYUFBYSxDQUFDLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDLENBQUM7SUFDOUgsT0FBTyxNQUFNLENBQUMsSUFBSSxDQUFDLG1FQUFtRSxDQUFDLENBQUM7QUFDNUYsQ0FBQztBQUVEOzs7Ozs7R0FNRztBQUNILG9CQUFvQjtBQUNwQixTQUFTLDhEQUE4RCxDQUFDLFVBQWU7SUFDbkYsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLFVBQVUsQ0FBQztLQUFFO0lBQ3ZELHdEQUF3RCxDQUFDLFVBQVUsQ0FBQyxDQUFDLGFBQWEsRUFBRSxDQUFDO0lBQ3JGLE9BQU87UUFDSCxnQkFBZ0IsRUFBRSxHQUFHLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxnQkFBZ0IsQ0FBQztLQUM1RixDQUFDO0FBQ04sQ0FBQztBQUVELG9CQUFvQjtBQUNwQixTQUFTLGdFQUFnRSxDQUFDLFVBQWU7SUFDckYsSUFBSSxHQUFHLENBQUMsa0JBQWtCLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFDcEMsT0FBTyxJQUFJLFNBQVMsQ0FBQyx3QkFBd0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztLQUM3RDtJQUNELFVBQVUsR0FBRyxVQUFVLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQztJQUNsRCxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxPQUFPLElBQUksU0FBUyxDQUFDLHdCQUF3QixDQUFDLFVBQVUsQ0FBQyxDQUFDO0tBQzdEO0lBQ0QsTUFBTSxHQUFHLEdBQUcsSUFBSSxTQUFTLENBQUMsZ0NBQWdDLEVBQW1ELENBQUM7SUFDOUcsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGtCQUFrQixFQUFFLGtCQUFrQixFQUFFLFVBQVUsQ0FBQyxnQkFBZ0IsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxjQUFjLENBQUMsVUFBVSxDQUFDLGdCQUFnQixDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQzFMLEdBQUcsQ0FBQyxnQ0FBZ0MsQ0FBQyxVQUFVLENBQUMsQ0FBQztJQUNqRCxPQUFPLEdBQUcsQ0FBQztBQUNmLENBQUM7QUEyQkQ7Ozs7OztHQU1HO0FBQ0gsU0FBUyx3REFBd0QsQ0FBQyxVQUFlO0lBQzdFLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxHQUFHLENBQUMsa0JBQWtCLENBQUM7S0FBRTtJQUNuRSxNQUFNLE1BQU0sR0FBRyxJQUFJLEdBQUcsQ0FBQyxpQkFBaUIsRUFBRSxDQUFDO0lBQzNDLElBQUksT0FBTyxVQUFVLEtBQUssUUFBUSxFQUFFO1FBQ2hDLE1BQU0sQ0FBQyxPQUFPLENBQUMsSUFBSSxHQUFHLENBQUMsZ0JBQWdCLENBQUMsb0NBQW9DLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLENBQUM7S0FDL0c7SUFDRCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyw0Q0FBNEMsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLDBDQUEwQyxDQUFDLENBQUMsQ0FBQztJQUMvSixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyx1QkFBdUIsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLHFCQUFxQixDQUFDLENBQUMsQ0FBQztJQUNySCxPQUFPLE1BQU0sQ0FBQyxJQUFJLENBQUMsbUVBQW1FLENBQUMsQ0FBQztBQUM1RixDQUFDO0FBRUQ7Ozs7OztHQU1HO0FBQ0gsb0JBQW9CO0FBQ3BCLFNBQVMsOERBQThELENBQUMsVUFBZTtJQUNuRixJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sVUFBVSxDQUFDO0tBQUU7SUFDdkQsd0RBQXdELENBQUMsVUFBVSxDQUFDLENBQUMsYUFBYSxFQUFFLENBQUM7SUFDckYsT0FBTztRQUNILDBDQUEwQyxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsMENBQTBDLENBQUM7UUFDN0gscUJBQXFCLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxxQkFBcUIsQ0FBQztLQUN0RixDQUFDO0FBQ04sQ0FBQztBQUVELG9CQUFvQjtBQUNwQixTQUFTLGdFQUFnRSxDQUFDLFVBQWU7SUFDckYsSUFBSSxHQUFHLENBQUMsa0JBQWtCLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFDcEMsT0FBTyxJQUFJLFNBQVMsQ0FBQyx3QkFBd0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztLQUM3RDtJQUNELFVBQVUsR0FBRyxVQUFVLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQztJQUNsRCxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxPQUFPLElBQUksU0FBUyxDQUFDLHdCQUF3QixDQUFDLFVBQVUsQ0FBQyxDQUFDO0tBQzdEO0lBQ0QsTUFBTSxHQUFHLEdBQUcsSUFBSSxTQUFTLENBQUMsZ0NBQWdDLEVBQW1ELENBQUM7SUFDOUcsR0FBRyxDQUFDLGlCQUFpQixDQUFDLDRDQUE0QyxFQUFFLDRDQUE0QyxFQUFFLFVBQVUsQ0FBQywwQ0FBMEMsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLDBDQUEwQyxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQzdSLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyx1QkFBdUIsRUFBRSx1QkFBdUIsRUFBRSxVQUFVLENBQUMscUJBQXFCLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUN6TSxHQUFHLENBQUMsZ0NBQWdDLENBQUMsVUFBVSxDQUFDLENBQUM7SUFDakQsT0FBTyxHQUFHLENBQUM7QUFDZixDQUFDO0FBcUNEOzs7Ozs7R0FNRztBQUNILFNBQVMsMERBQTBELENBQUMsVUFBZTtJQUMvRSxJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sR0FBRyxDQUFDLGtCQUFrQixDQUFDO0tBQUU7SUFDbkUsTUFBTSxNQUFNLEdBQUcsSUFBSSxHQUFHLENBQUMsaUJBQWlCLEVBQUUsQ0FBQztJQUMzQyxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxNQUFNLENBQUMsT0FBTyxDQUFDLElBQUksR0FBRyxDQUFDLGdCQUFnQixDQUFDLG9DQUFvQyxHQUFHLElBQUksQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxDQUFDO0tBQy9HO0lBQ0QsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsZUFBZSxFQUFFLEdBQUcsQ0FBQyxhQUFhLENBQUMsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDLGFBQWEsQ0FBQyxDQUFDLENBQUM7SUFDeEgsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsZUFBZSxFQUFFLEdBQUcsQ0FBQyxhQUFhLENBQUMsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDLGFBQWEsQ0FBQyxDQUFDLENBQUM7SUFDeEgsT0FBTyxNQUFNLENBQUMsSUFBSSxDQUFDLHFFQUFxRSxDQUFDLENBQUM7QUFDOUYsQ0FBQztBQUVEOzs7Ozs7R0FNRztBQUNILG9CQUFvQjtBQUNwQixTQUFTLGdFQUFnRSxDQUFDLFVBQWU7SUFDckYsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLFVBQVUsQ0FBQztLQUFFO0lBQ3ZELDBEQUEwRCxDQUFDLFVBQVUsQ0FBQyxDQUFDLGFBQWEsRUFBRSxDQUFDO0lBQ3ZGLE9BQU87UUFDSCxhQUFhLEVBQUUsR0FBRyxDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUMsc0JBQXNCLENBQUMsQ0FBQyxVQUFVLENBQUMsYUFBYSxDQUFDO1FBQ25GLGFBQWEsRUFBRSxHQUFHLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxhQUFhLENBQUM7S0FDdEYsQ0FBQztBQUNOLENBQUM7QUFFRCxvQkFBb0I7QUFDcEIsU0FBUyxrRUFBa0UsQ0FBQyxVQUFlO0lBQ3ZGLElBQUksR0FBRyxDQUFDLGtCQUFrQixDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQ3BDLE9BQU8sSUFBSSxTQUFTLENBQUMsd0JBQXdCLENBQUMsVUFBVSxDQUFDLENBQUM7S0FDN0Q7SUFDRCxVQUFVLEdBQUcsVUFBVSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUM7SUFDbEQsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsT0FBTyxJQUFJLFNBQVMsQ0FBQyx3QkFBd0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztLQUM3RDtJQUNELE1BQU0sR0FBRyxHQUFHLElBQUksU0FBUyxDQUFDLGdDQUFnQyxFQUFxRCxDQUFDO0lBQ2hILEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxlQUFlLEVBQUUsZUFBZSxFQUFFLFVBQVUsQ0FBQyxhQUFhLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsY0FBYyxDQUFDLFVBQVUsQ0FBQyxhQUFhLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDOUssR0FBRyxDQUFDLGlCQUFpQixDQUFDLGVBQWUsRUFBRSxlQUFlLEVBQUUsVUFBVSxDQUFDLGFBQWEsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxjQUFjLENBQUMsVUFBVSxDQUFDLGFBQWEsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUM5SyxHQUFHLENBQUMsZ0NBQWdDLENBQUMsVUFBVSxDQUFDLENBQUM7SUFDakQsT0FBTyxHQUFHLENBQUM7QUFDZixDQUFDO0FBeUhEOzs7Ozs7R0FNRztBQUNILFNBQVMseUNBQXlDLENBQUMsVUFBZTtJQUM5RCxJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sR0FBRyxDQUFDLGtCQUFrQixDQUFDO0tBQUU7SUFDbkUsTUFBTSxNQUFNLEdBQUcsSUFBSSxHQUFHLENBQUMsaUJBQWlCLEVBQUUsQ0FBQztJQUMzQyxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxNQUFNLENBQUMsT0FBTyxDQUFDLElBQUksR0FBRyxDQUFDLGdCQUFnQixDQUFDLG9DQUFvQyxHQUFHLElBQUksQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxDQUFDO0tBQy9HO0lBQ0QsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsb0JBQW9CLEVBQUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUMsVUFBVSxDQUFDLGtCQUFrQixDQUFDLENBQUMsQ0FBQztJQUNsSCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxvQkFBb0IsRUFBRSxHQUFHLENBQUMsZUFBZSxDQUFDLENBQUMsVUFBVSxDQUFDLGtCQUFrQixDQUFDLENBQUMsQ0FBQztJQUNoSCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQywwQkFBMEIsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLHdCQUF3QixDQUFDLENBQUMsQ0FBQztJQUMzSCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyx1QkFBdUIsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLHFCQUFxQixDQUFDLENBQUMsQ0FBQztJQUNySCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxjQUFjLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxZQUFZLENBQUMsQ0FBQyxDQUFDO0lBQ25HLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGlCQUFpQixFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsZUFBZSxDQUFDLENBQUMsQ0FBQztJQUN6RyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxhQUFhLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxXQUFXLENBQUMsQ0FBQyxDQUFDO0lBQ2pHLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGVBQWUsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLGFBQWEsQ0FBQyxDQUFDLENBQUM7SUFDckcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsZ0JBQWdCLEVBQUUsR0FBRyxDQUFDLGFBQWEsQ0FBQyx5REFBeUQsQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDLGNBQWMsQ0FBQyxDQUFDLENBQUM7SUFDakssTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsaUJBQWlCLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxlQUFlLENBQUMsQ0FBQyxDQUFDO0lBQ3pHLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLHNCQUFzQixFQUFFLEdBQUcsQ0FBQyxhQUFhLENBQUMsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDLG9CQUFvQixDQUFDLENBQUMsQ0FBQztJQUN0SSxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxNQUFNLEVBQUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUM7SUFDdEYsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsTUFBTSxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQztJQUNuRixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxvQkFBb0IsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLGtCQUFrQixDQUFDLENBQUMsQ0FBQztJQUMvRyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyx1QkFBdUIsRUFBRSxHQUFHLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxVQUFVLENBQUMscUJBQXFCLENBQUMsQ0FBQyxDQUFDO0lBQ3hILE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLHVCQUF1QixFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMscUJBQXFCLENBQUMsQ0FBQyxDQUFDO0lBQ3JILE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGFBQWEsRUFBRSxHQUFHLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxVQUFVLENBQUMsV0FBVyxDQUFDLENBQUMsQ0FBQztJQUNwRyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxhQUFhLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxXQUFXLENBQUMsQ0FBQyxDQUFDO0lBQ2pHLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLE1BQU0sRUFBRSxHQUFHLENBQUMsYUFBYSxDQUFDLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDO0lBQ3RHLE9BQU8sTUFBTSxDQUFDLElBQUksQ0FBQyx3RUFBd0UsQ0FBQyxDQUFDO0FBQ2pHLENBQUM7QUFFRDs7Ozs7O0dBTUc7QUFDSCxvQkFBb0I7QUFDcEIsU0FBUyxnREFBZ0QsQ0FBQyxVQUFlO0lBQ3JFLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxVQUFVLENBQUM7S0FBRTtJQUN2RCx5Q0FBeUMsQ0FBQyxVQUFVLENBQUMsQ0FBQyxhQUFhLEVBQUUsQ0FBQztJQUN0RSxPQUFPO1FBQ0gsa0JBQWtCLEVBQUUsR0FBRyxDQUFDLHVCQUF1QixDQUFDLFVBQVUsQ0FBQyxrQkFBa0IsQ0FBQztRQUM5RSxJQUFJLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUM7UUFDakQscUJBQXFCLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxxQkFBcUIsQ0FBQztRQUNuRixXQUFXLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxXQUFXLENBQUM7UUFDL0Qsd0JBQXdCLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyx3QkFBd0IsQ0FBQztRQUN6RixxQkFBcUIsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLHFCQUFxQixDQUFDO1FBQ25GLFlBQVksRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLFlBQVksQ0FBQztRQUNqRSxlQUFlLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxlQUFlLENBQUM7UUFDdkUsV0FBVyxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsV0FBVyxDQUFDO1FBQy9ELGFBQWEsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLGFBQWEsQ0FBQztRQUNuRSxjQUFjLEVBQUUsR0FBRyxDQUFDLFVBQVUsQ0FBQywrREFBK0QsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxjQUFjLENBQUM7UUFDMUgsZUFBZSxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsZUFBZSxDQUFDO1FBQ3ZFLG9CQUFvQixFQUFFLEdBQUcsQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDLHNCQUFzQixDQUFDLENBQUMsVUFBVSxDQUFDLG9CQUFvQixDQUFDO1FBQ2pHLGtCQUFrQixFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsa0JBQWtCLENBQUM7UUFDN0UsSUFBSSxFQUFFLEdBQUcsQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDLHNCQUFzQixDQUFDLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQztLQUNwRSxDQUFDO0FBQ04sQ0FBQztBQUVELG9CQUFvQjtBQUNwQixTQUFTLGtEQUFrRCxDQUFDLFVBQWU7SUFDdkUsVUFBVSxHQUFHLFVBQVUsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDO0lBQ2xELElBQUksT0FBTyxVQUFVLEtBQUssUUFBUSxFQUFFO1FBQ2hDLE9BQU8sSUFBSSxTQUFTLENBQUMsd0JBQXdCLENBQUMsVUFBVSxDQUFDLENBQUM7S0FDN0Q7SUFDRCxNQUFNLEdBQUcsR0FBRyxJQUFJLFNBQVMsQ0FBQyxnQ0FBZ0MsRUFBb0MsQ0FBQztJQUMvRixHQUFHLENBQUMsaUJBQWlCLENBQUMsb0JBQW9CLEVBQUUsb0JBQW9CLEVBQUUsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsa0JBQWtCLENBQUMsQ0FBQyxDQUFDO0lBQzFJLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxNQUFNLEVBQUUsTUFBTSxFQUFFLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUM7SUFDL0YsR0FBRyxDQUFDLGlCQUFpQixDQUFDLHVCQUF1QixFQUFFLHVCQUF1QixFQUFFLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLHFCQUFxQixDQUFDLENBQUMsQ0FBQztJQUNsSixHQUFHLENBQUMsaUJBQWlCLENBQUMsYUFBYSxFQUFFLGFBQWEsRUFBRSxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxXQUFXLENBQUMsQ0FBQyxDQUFDO0lBQ3BILEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQywwQkFBMEIsRUFBRSwwQkFBMEIsRUFBRSxVQUFVLENBQUMsd0JBQXdCLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyx3QkFBd0IsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUNyTixHQUFHLENBQUMsaUJBQWlCLENBQUMsdUJBQXVCLEVBQUUsdUJBQXVCLEVBQUUsVUFBVSxDQUFDLHFCQUFxQixJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMscUJBQXFCLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDek0sR0FBRyxDQUFDLGlCQUFpQixDQUFDLGNBQWMsRUFBRSxjQUFjLEVBQUUsVUFBVSxDQUFDLFlBQVksSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLFlBQVksQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUNySyxHQUFHLENBQUMsaUJBQWlCLENBQUMsaUJBQWlCLEVBQUUsaUJBQWlCLEVBQUUsVUFBVSxDQUFDLGVBQWUsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLGVBQWUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUNqTCxHQUFHLENBQUMsaUJBQWlCLENBQUMsYUFBYSxFQUFFLGFBQWEsRUFBRSxVQUFVLENBQUMsV0FBVyxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsV0FBVyxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ2pLLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxlQUFlLEVBQUUsZUFBZSxFQUFFLFVBQVUsQ0FBQyxhQUFhLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxhQUFhLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDekssR0FBRyxDQUFDLGlCQUFpQixDQUFDLGdCQUFnQixFQUFFLGdCQUFnQixFQUFFLFVBQVUsQ0FBQyxjQUFjLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsUUFBUSxDQUFDLGlFQUFpRSxDQUFDLENBQUMsVUFBVSxDQUFDLGNBQWMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUMvTyxHQUFHLENBQUMsaUJBQWlCLENBQUMsaUJBQWlCLEVBQUUsaUJBQWlCLEVBQUUsVUFBVSxDQUFDLGVBQWUsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLGVBQWUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUNqTCxHQUFHLENBQUMsaUJBQWlCLENBQUMsc0JBQXNCLEVBQUUsc0JBQXNCLEVBQUUsVUFBVSxDQUFDLG9CQUFvQixJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLGNBQWMsQ0FBQyxVQUFVLENBQUMsb0JBQW9CLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDMU0sR0FBRyxDQUFDLGlCQUFpQixDQUFDLG9CQUFvQixFQUFFLG9CQUFvQixFQUFFLFVBQVUsQ0FBQyxrQkFBa0IsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLGtCQUFrQixDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQzdMLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxNQUFNLEVBQUUsTUFBTSxFQUFFLFVBQVUsQ0FBQyxJQUFJLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsUUFBUSxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQWdCLENBQUMsQ0FBQztJQUNuTCxHQUFHLENBQUMsZ0NBQWdDLENBQUMsVUFBVSxDQUFDLENBQUM7SUFDakQsT0FBTyxHQUFHLENBQUM7QUFDZixDQUFDO0FBRUQ7Ozs7Ozs7OztHQVNHO0FBQ0gsTUFBYSwyQkFBNEIsU0FBUSxHQUFHLENBQUMsV0FBVztJQWlKNUQ7Ozs7OztPQU1HO0lBQ0gsWUFBWSxLQUFvQixFQUFFLEVBQVUsRUFBRSxLQUF1QztRQUNqRixLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxFQUFFLElBQUksRUFBRSwyQkFBMkIsQ0FBQyxzQkFBc0IsRUFBRSxVQUFVLEVBQUUsS0FBSyxFQUFFLENBQUMsQ0FBQzs7Ozs7Ozs7OztRQUNsRyxHQUFHLENBQUMsZUFBZSxDQUFDLEtBQUssRUFBRSxvQkFBb0IsRUFBRSxJQUFJLENBQUMsQ0FBQztRQUN2RCxHQUFHLENBQUMsZUFBZSxDQUFDLEtBQUssRUFBRSxNQUFNLEVBQUUsSUFBSSxDQUFDLENBQUM7UUFDekMsR0FBRyxDQUFDLGVBQWUsQ0FBQyxLQUFLLEVBQUUsdUJBQXVCLEVBQUUsSUFBSSxDQUFDLENBQUM7UUFDMUQsR0FBRyxDQUFDLGVBQWUsQ0FBQyxLQUFLLEVBQUUsYUFBYSxFQUFFLElBQUksQ0FBQyxDQUFDO1FBQ2hELElBQUksQ0FBQyxPQUFPLEdBQUcsR0FBRyxDQUFDLEtBQUssQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDO1FBQ3RELElBQUksQ0FBQyxRQUFRLEdBQUcsR0FBRyxDQUFDLEtBQUssQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDO1FBRXhELElBQUksQ0FBQyxrQkFBa0IsR0FBRyxLQUFLLENBQUMsa0JBQWtCLENBQUM7UUFDbkQsSUFBSSxDQUFDLElBQUksR0FBRyxLQUFLLENBQUMsSUFBSSxDQUFDO1FBQ3ZCLElBQUksQ0FBQyxxQkFBcUIsR0FBRyxLQUFLLENBQUMscUJBQXFCLENBQUM7UUFDekQsSUFBSSxDQUFDLFdBQVcsR0FBRyxLQUFLLENBQUMsV0FBVyxDQUFDO1FBQ3JDLElBQUksQ0FBQyx3QkFBd0IsR0FBRyxLQUFLLENBQUMsd0JBQXdCLENBQUM7UUFDL0QsSUFBSSxDQUFDLHFCQUFxQixHQUFHLEtBQUssQ0FBQyxxQkFBcUIsQ0FBQztRQUN6RCxJQUFJLENBQUMsWUFBWSxHQUFHLEtBQUssQ0FBQyxZQUFZLENBQUM7UUFDdkMsSUFBSSxDQUFDLGVBQWUsR0FBRyxLQUFLLENBQUMsZUFBZSxDQUFDO1FBQzdDLElBQUksQ0FBQyxXQUFXLEdBQUcsS0FBSyxDQUFDLFdBQVcsQ0FBQztRQUNyQyxJQUFJLENBQUMsYUFBYSxHQUFHLEtBQUssQ0FBQyxhQUFhLENBQUM7UUFDekMsSUFBSSxDQUFDLGNBQWMsR0FBRyxLQUFLLENBQUMsY0FBYyxDQUFDO1FBQzNDLElBQUksQ0FBQyxlQUFlLEdBQUcsS0FBSyxDQUFDLGVBQWUsQ0FBQztRQUM3QyxJQUFJLENBQUMsb0JBQW9CLEdBQUcsS0FBSyxDQUFDLG9CQUFvQixDQUFDO1FBQ3ZELElBQUksQ0FBQyxrQkFBa0IsR0FBRyxLQUFLLENBQUMsa0JBQWtCLENBQUM7UUFDbkQsSUFBSSxDQUFDLElBQUksR0FBRyxJQUFJLEdBQUcsQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDLE9BQU8sQ0FBQyxRQUFRLEVBQUUseUNBQXlDLEVBQUUsS0FBSyxDQUFDLElBQUksRUFBRSxFQUFFLGVBQWUsRUFBRSxNQUFNLEVBQUUsQ0FBQyxDQUFDO0tBQzVJO0lBMUtEOzs7Ozs7T0FNRztJQUNJLE1BQU0sQ0FBQyxtQkFBbUIsQ0FBQyxLQUFvQixFQUFFLEVBQVUsRUFBRSxrQkFBdUIsRUFBRSxPQUE0QztRQUNySSxrQkFBa0IsR0FBRyxrQkFBa0IsSUFBSSxFQUFFLENBQUM7UUFDOUMsTUFBTSxrQkFBa0IsR0FBRyxPQUFPLENBQUMsTUFBTSxDQUFDLFVBQVUsQ0FBQyxrQkFBa0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztRQUNwRixNQUFNLFdBQVcsR0FBRyxrREFBa0QsQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDO1FBQzNGLE1BQU0sR0FBRyxHQUFHLElBQUksMkJBQTJCLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxXQUFXLENBQUMsS0FBSyxDQUFDLENBQUM7UUFDMUUsS0FBSyxNQUFNLENBQUMsT0FBTyxFQUFFLE9BQU8sQ0FBQyxJQUFJLE1BQU0sQ0FBQyxPQUFPLENBQUMsV0FBVyxDQUFDLGVBQWUsQ0FBQyxFQUFHO1lBQzNFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxPQUFPLEVBQUUsT0FBTyxDQUFDLENBQUM7U0FDN0M7UUFDRCxPQUFPLENBQUMsTUFBTSxDQUFDLGdCQUFnQixDQUFDLEdBQUcsRUFBRSxrQkFBa0IsRUFBRSxFQUFFLENBQUMsQ0FBQztRQUM3RCxPQUFPLEdBQUcsQ0FBQztLQUNkO0lBMkpEOzs7OztPQUtHO0lBQ0ksT0FBTyxDQUFDLFNBQTRCO1FBQ3ZDLFNBQVMsQ0FBQyxZQUFZLENBQUMsNkJBQTZCLEVBQUUsMkJBQTJCLENBQUMsc0JBQXNCLENBQUMsQ0FBQztRQUMxRyxTQUFTLENBQUMsWUFBWSxDQUFDLDhCQUE4QixFQUFFLElBQUksQ0FBQyxhQUFhLENBQUMsQ0FBQztLQUM5RTtJQUVELElBQWMsYUFBYTtRQUN2QixPQUFPO1lBQ0gsa0JBQWtCLEVBQUUsSUFBSSxDQUFDLGtCQUFrQjtZQUMzQyxJQUFJLEVBQUUsSUFBSSxDQUFDLElBQUk7WUFDZixxQkFBcUIsRUFBRSxJQUFJLENBQUMscUJBQXFCO1lBQ2pELFdBQVcsRUFBRSxJQUFJLENBQUMsV0FBVztZQUM3Qix3QkFBd0IsRUFBRSxJQUFJLENBQUMsd0JBQXdCO1lBQ3ZELHFCQUFxQixFQUFFLElBQUksQ0FBQyxxQkFBcUI7WUFDakQsWUFBWSxFQUFFLElBQUksQ0FBQyxZQUFZO1lBQy9CLGVBQWUsRUFBRSxJQUFJLENBQUMsZUFBZTtZQUNyQyxXQUFXLEVBQUUsSUFBSSxDQUFDLFdBQVc7WUFDN0IsYUFBYSxFQUFFLElBQUksQ0FBQyxhQUFhO1lBQ2pDLGNBQWMsRUFBRSxJQUFJLENBQUMsY0FBYztZQUNuQyxlQUFlLEVBQUUsSUFBSSxDQUFDLGVBQWU7WUFDckMsb0JBQW9CLEVBQUUsSUFBSSxDQUFDLG9CQUFvQjtZQUMvQyxrQkFBa0IsRUFBRSxJQUFJLENBQUMsa0JBQWtCO1lBQzNDLElBQUksRUFBRSxJQUFJLENBQUMsSUFBSSxDQUFDLFVBQVUsRUFBRTtTQUMvQixDQUFDO0tBQ0w7SUFFUyxnQkFBZ0IsQ0FBQyxLQUEyQjtRQUNsRCxPQUFPLGdEQUFnRCxDQUFDLEtBQUssQ0FBQyxDQUFDO0tBQ2xFOztBQW5OTCxrRUFvTkM7OztBQW5ORzs7R0FFRztBQUNvQixrREFBc0IsR0FBRyx5Q0FBeUMsQ0FBQztBQTJPOUY7Ozs7OztHQU1HO0FBQ0gsU0FBUyx5REFBeUQsQ0FBQyxVQUFlO0lBQzlFLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxHQUFHLENBQUMsa0JBQWtCLENBQUM7S0FBRTtJQUNuRSxNQUFNLE1BQU0sR0FBRyxJQUFJLEdBQUcsQ0FBQyxpQkFBaUIsRUFBRSxDQUFDO0lBQzNDLElBQUksT0FBTyxVQUFVLEtBQUssUUFBUSxFQUFFO1FBQ2hDLE1BQU0sQ0FBQyxPQUFPLENBQUMsSUFBSSxHQUFHLENBQUMsZ0JBQWdCLENBQUMsb0NBQW9DLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLENBQUM7S0FDL0c7SUFDRCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxLQUFLLEVBQUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUM7SUFDcEYsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsS0FBSyxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQztJQUNqRixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxPQUFPLEVBQUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUMsVUFBVSxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUM7SUFDeEYsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsT0FBTyxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQztJQUNyRixPQUFPLE1BQU0sQ0FBQyxJQUFJLENBQUMsNERBQTRELENBQUMsQ0FBQztBQUNyRixDQUFDO0FBRUQ7Ozs7OztHQU1HO0FBQ0gsb0JBQW9CO0FBQ3BCLFNBQVMsK0RBQStELENBQUMsVUFBZTtJQUNwRixJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sVUFBVSxDQUFDO0tBQUU7SUFDdkQseURBQXlELENBQUMsVUFBVSxDQUFDLENBQUMsYUFBYSxFQUFFLENBQUM7SUFDdEYsT0FBTztRQUNILEdBQUcsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQztRQUMvQyxLQUFLLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxLQUFLLENBQUM7S0FDdEQsQ0FBQztBQUNOLENBQUM7QUFFRCxvQkFBb0I7QUFDcEIsU0FBUyxpRUFBaUUsQ0FBQyxVQUFlO0lBQ3RGLElBQUksR0FBRyxDQUFDLGtCQUFrQixDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQ3BDLE9BQU8sSUFBSSxTQUFTLENBQUMsd0JBQXdCLENBQUMsVUFBVSxDQUFDLENBQUM7S0FDN0Q7SUFDRCxVQUFVLEdBQUcsVUFBVSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUM7SUFDbEQsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsT0FBTyxJQUFJLFNBQVMsQ0FBQyx3QkFBd0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztLQUM3RDtJQUNELE1BQU0sR0FBRyxHQUFHLElBQUksU0FBUyxDQUFDLGdDQUFnQyxFQUFvRCxDQUFDO0lBQy9HLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxLQUFLLEVBQUUsS0FBSyxFQUFFLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUM7SUFDNUYsR0FBRyxDQUFDLGlCQUFpQixDQUFDLE9BQU8sRUFBRSxPQUFPLEVBQUUsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQztJQUNsRyxHQUFHLENBQUMsZ0NBQWdDLENBQUMsVUFBVSxDQUFDLENBQUM7SUFDakQsT0FBTyxHQUFHLENBQUM7QUFDZixDQUFDO0FBa0NEOzs7Ozs7R0FNRztBQUNILFNBQVMsbUNBQW1DLENBQUMsVUFBZTtJQUN4RCxJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sR0FBRyxDQUFDLGtCQUFrQixDQUFDO0tBQUU7SUFDbkUsTUFBTSxNQUFNLEdBQUcsSUFBSSxHQUFHLENBQUMsaUJBQWlCLEVBQUUsQ0FBQztJQUMzQyxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxNQUFNLENBQUMsT0FBTyxDQUFDLElBQUksR0FBRyxDQUFDLGdCQUFnQixDQUFDLG9DQUFvQyxHQUFHLElBQUksQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxDQUFDO0tBQy9HO0lBQ0QsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsTUFBTSxFQUFFLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDO0lBQ3RGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLE1BQU0sRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUM7SUFDbkYsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsYUFBYSxFQUFFLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxXQUFXLENBQUMsQ0FBQyxDQUFDO0lBQ3BHLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGFBQWEsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLFdBQVcsQ0FBQyxDQUFDLENBQUM7SUFDakcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsTUFBTSxFQUFFLEdBQUcsQ0FBQyxhQUFhLENBQUMsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUM7SUFDdEcsT0FBTyxNQUFNLENBQUMsSUFBSSxDQUFDLGtFQUFrRSxDQUFDLENBQUM7QUFDM0YsQ0FBQztBQUVEOzs7Ozs7R0FNRztBQUNILG9CQUFvQjtBQUNwQixTQUFTLDBDQUEwQyxDQUFDLFVBQWU7SUFDL0QsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLFVBQVUsQ0FBQztLQUFFO0lBQ3ZELG1DQUFtQyxDQUFDLFVBQVUsQ0FBQyxDQUFDLGFBQWEsRUFBRSxDQUFDO0lBQ2hFLE9BQU87UUFDSCxJQUFJLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUM7UUFDakQsV0FBVyxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsV0FBVyxDQUFDO1FBQy9ELElBQUksRUFBRSxHQUFHLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUM7S0FDcEUsQ0FBQztBQUNOLENBQUM7QUFFRCxvQkFBb0I7QUFDcEIsU0FBUyw0Q0FBNEMsQ0FBQyxVQUFlO0lBQ2pFLFVBQVUsR0FBRyxVQUFVLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQztJQUNsRCxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxPQUFPLElBQUksU0FBUyxDQUFDLHdCQUF3QixDQUFDLFVBQVUsQ0FBQyxDQUFDO0tBQzdEO0lBQ0QsTUFBTSxHQUFHLEdBQUcsSUFBSSxTQUFTLENBQUMsZ0NBQWdDLEVBQThCLENBQUM7SUFDekYsR0FBRyxDQUFDLGlCQUFpQixDQUFDLE1BQU0sRUFBRSxNQUFNLEVBQUUsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQztJQUMvRixHQUFHLENBQUMsaUJBQWlCLENBQUMsYUFBYSxFQUFFLGFBQWEsRUFBRSxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxXQUFXLENBQUMsQ0FBQyxDQUFDO0lBQ3BILEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxNQUFNLEVBQUUsTUFBTSxFQUFFLFVBQVUsQ0FBQyxJQUFJLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsUUFBUSxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQWdCLENBQUMsQ0FBQztJQUNuTCxHQUFHLENBQUMsZ0NBQWdDLENBQUMsVUFBVSxDQUFDLENBQUM7SUFDakQsT0FBTyxHQUFHLENBQUM7QUFDZixDQUFDO0FBRUQ7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7R0FtQkc7QUFDSCxNQUFhLHFCQUFzQixTQUFRLEdBQUcsQ0FBQyxXQUFXO0lBMER0RDs7Ozs7O09BTUc7SUFDSCxZQUFZLEtBQW9CLEVBQUUsRUFBVSxFQUFFLEtBQWlDO1FBQzNFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLEVBQUUsSUFBSSxFQUFFLHFCQUFxQixDQUFDLHNCQUFzQixFQUFFLFVBQVUsRUFBRSxLQUFLLEVBQUUsQ0FBQyxDQUFDOzs7Ozs7Ozs7O1FBQzVGLEdBQUcsQ0FBQyxlQUFlLENBQUMsS0FBSyxFQUFFLE1BQU0sRUFBRSxJQUFJLENBQUMsQ0FBQztRQUN6QyxHQUFHLENBQUMsZUFBZSxDQUFDLEtBQUssRUFBRSxhQUFhLEVBQUUsSUFBSSxDQUFDLENBQUM7UUFDaEQsSUFBSSxDQUFDLE9BQU8sR0FBRyxHQUFHLENBQUMsS0FBSyxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUM7UUFDdEQsSUFBSSxDQUFDLFFBQVEsR0FBRyxHQUFHLENBQUMsS0FBSyxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUM7UUFFeEQsSUFBSSxDQUFDLElBQUksR0FBRyxLQUFLLENBQUMsSUFBSSxDQUFDO1FBQ3ZCLElBQUksQ0FBQyxXQUFXLEdBQUcsS0FBSyxDQUFDLFdBQVcsQ0FBQztRQUNyQyxJQUFJLENBQUMsSUFBSSxHQUFHLElBQUksR0FBRyxDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUMsT0FBTyxDQUFDLFFBQVEsRUFBRSxtQ0FBbUMsRUFBRSxLQUFLLENBQUMsSUFBSSxFQUFFLEVBQUUsZUFBZSxFQUFFLE1BQU0sRUFBRSxDQUFDLENBQUM7S0FDdEk7SUFyRUQ7Ozs7OztPQU1HO0lBQ0ksTUFBTSxDQUFDLG1CQUFtQixDQUFDLEtBQW9CLEVBQUUsRUFBVSxFQUFFLGtCQUF1QixFQUFFLE9BQTRDO1FBQ3JJLGtCQUFrQixHQUFHLGtCQUFrQixJQUFJLEVBQUUsQ0FBQztRQUM5QyxNQUFNLGtCQUFrQixHQUFHLE9BQU8sQ0FBQyxNQUFNLENBQUMsVUFBVSxDQUFDLGtCQUFrQixDQUFDLFVBQVUsQ0FBQyxDQUFDO1FBQ3BGLE1BQU0sV0FBVyxHQUFHLDRDQUE0QyxDQUFDLGtCQUFrQixDQUFDLENBQUM7UUFDckYsTUFBTSxHQUFHLEdBQUcsSUFBSSxxQkFBcUIsQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLFdBQVcsQ0FBQyxLQUFLLENBQUMsQ0FBQztRQUNwRSxLQUFLLE1BQU0sQ0FBQyxPQUFPLEVBQUUsT0FBTyxDQUFDLElBQUksTUFBTSxDQUFDLE9BQU8sQ0FBQyxXQUFXLENBQUMsZUFBZSxDQUFDLEVBQUc7WUFDM0UsR0FBRyxDQUFDLG1CQUFtQixDQUFDLE9BQU8sRUFBRSxPQUFPLENBQUMsQ0FBQztTQUM3QztRQUNELE9BQU8sQ0FBQyxNQUFNLENBQUMsZ0JBQWdCLENBQUMsR0FBRyxFQUFFLGtCQUFrQixFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBQzdELE9BQU8sR0FBRyxDQUFDO0tBQ2Q7SUFzREQ7Ozs7O09BS0c7SUFDSSxPQUFPLENBQUMsU0FBNEI7UUFDdkMsU0FBUyxDQUFDLFlBQVksQ0FBQyw2QkFBNkIsRUFBRSxxQkFBcUIsQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDO1FBQ3BHLFNBQVMsQ0FBQyxZQUFZLENBQUMsOEJBQThCLEVBQUUsSUFBSSxDQUFDLGFBQWEsQ0FBQyxDQUFDO0tBQzlFO0lBRUQsSUFBYyxhQUFhO1FBQ3ZCLE9BQU87WUFDSCxJQUFJLEVBQUUsSUFBSSxDQUFDLElBQUk7WUFDZixXQUFXLEVBQUUsSUFBSSxDQUFDLFdBQVc7WUFDN0IsSUFBSSxFQUFFLElBQUksQ0FBQyxJQUFJLENBQUMsVUFBVSxFQUFFO1NBQy9CLENBQUM7S0FDTDtJQUVTLGdCQUFnQixDQUFDLEtBQTJCO1FBQ2xELE9BQU8sMENBQTBDLENBQUMsS0FBSyxDQUFDLENBQUM7S0FDNUQ7O0FBbEdMLHNEQW1HQzs7O0FBbEdHOztHQUVHO0FBQ29CLDRDQUFzQixHQUFHLG1DQUFtQyxDQUFDO0FBd0l4Rjs7Ozs7O0dBTUc7QUFDSCxTQUFTLHVCQUF1QixDQUFDLFVBQWU7SUFDNUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQztLQUFFO0lBQ25FLE1BQU0sTUFBTSxHQUFHLElBQUksR0FBRyxDQUFDLGlCQUFpQixFQUFFLENBQUM7SUFDM0MsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsTUFBTSxDQUFDLE9BQU8sQ0FBQyxJQUFJLEdBQUcsQ0FBQyxnQkFBZ0IsQ0FBQyxvQ0FBb0MsR0FBRyxJQUFJLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUMsQ0FBQztLQUMvRztJQUNELE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLE1BQU0sRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUM7SUFDbkYsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsaUJBQWlCLEVBQUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUMsVUFBVSxDQUFDLGVBQWUsQ0FBQyxDQUFDLENBQUM7SUFDNUcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsaUJBQWlCLEVBQUUscUNBQXFDLENBQUMsQ0FBQyxVQUFVLENBQUMsZUFBZSxDQUFDLENBQUMsQ0FBQztJQUM1SCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxNQUFNLEVBQUUsR0FBRyxDQUFDLGFBQWEsQ0FBQyxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQztJQUN0RyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxTQUFTLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDO0lBQ3pGLE9BQU8sTUFBTSxDQUFDLElBQUksQ0FBQyxzREFBc0QsQ0FBQyxDQUFDO0FBQy9FLENBQUM7QUFFRDs7Ozs7O0dBTUc7QUFDSCxvQkFBb0I7QUFDcEIsU0FBUyw4QkFBOEIsQ0FBQyxVQUFlO0lBQ25ELElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxVQUFVLENBQUM7S0FBRTtJQUN2RCx1QkFBdUIsQ0FBQyxVQUFVLENBQUMsQ0FBQyxhQUFhLEVBQUUsQ0FBQztJQUNwRCxPQUFPO1FBQ0gsZUFBZSxFQUFFLDJDQUEyQyxDQUFDLFVBQVUsQ0FBQyxlQUFlLENBQUM7UUFDeEYsSUFBSSxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDO1FBQ2pELElBQUksRUFBRSxHQUFHLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUM7UUFDakUsT0FBTyxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsT0FBTyxDQUFDO0tBQzFELENBQUM7QUFDTixDQUFDO0FBRUQsb0JBQW9CO0FBQ3BCLFNBQVMsZ0NBQWdDLENBQUMsVUFBZTtJQUNyRCxVQUFVLEdBQUcsVUFBVSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUM7SUFDbEQsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsT0FBTyxJQUFJLFNBQVMsQ0FBQyx3QkFBd0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztLQUM3RDtJQUNELE1BQU0sR0FBRyxHQUFHLElBQUksU0FBUyxDQUFDLGdDQUFnQyxFQUFrQixDQUFDO0lBQzdFLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxpQkFBaUIsRUFBRSxpQkFBaUIsRUFBRSw2Q0FBNkMsQ0FBQyxVQUFVLENBQUMsZUFBZSxDQUFDLENBQUMsQ0FBQztJQUN2SSxHQUFHLENBQUMsaUJBQWlCLENBQUMsTUFBTSxFQUFFLE1BQU0sRUFBRSxVQUFVLENBQUMsSUFBSSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ3JJLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxNQUFNLEVBQUUsTUFBTSxFQUFFLFVBQVUsQ0FBQyxJQUFJLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsUUFBUSxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQWdCLENBQUMsQ0FBQztJQUNuTCxHQUFHLENBQUMsaUJBQWlCLENBQUMsU0FBUyxFQUFFLFNBQVMsRUFBRSxVQUFVLENBQUMsT0FBTyxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ2pKLEdBQUcsQ0FBQyxnQ0FBZ0MsQ0FBQyxVQUFVLENBQUMsQ0FBQztJQUNqRCxPQUFPLEdBQUcsQ0FBQztBQUNmLENBQUM7QUFFRDs7Ozs7Ozs7O0dBU0c7QUFDSCxNQUFhLFNBQVUsU0FBUSxHQUFHLENBQUMsV0FBVztJQWlFMUM7Ozs7OztPQU1HO0lBQ0gsWUFBWSxLQUFvQixFQUFFLEVBQVUsRUFBRSxLQUFxQjtRQUMvRCxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxFQUFFLElBQUksRUFBRSxTQUFTLENBQUMsc0JBQXNCLEVBQUUsVUFBVSxFQUFFLEtBQUssRUFBRSxDQUFDLENBQUM7Ozs7Ozs7Ozs7UUFDaEYsR0FBRyxDQUFDLGVBQWUsQ0FBQyxLQUFLLEVBQUUsaUJBQWlCLEVBQUUsSUFBSSxDQUFDLENBQUM7UUFDcEQsSUFBSSxDQUFDLE9BQU8sR0FBRyxHQUFHLENBQUMsS0FBSyxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUM7UUFDdEQsSUFBSSxDQUFDLE1BQU0sR0FBRyxHQUFHLENBQUMsS0FBSyxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUM7UUFFcEQsSUFBSSxDQUFDLGVBQWUsR0FBRyxLQUFLLENBQUMsZUFBZSxDQUFDO1FBQzdDLElBQUksQ0FBQyxJQUFJLEdBQUcsS0FBSyxDQUFDLElBQUksQ0FBQztRQUN2QixJQUFJLENBQUMsSUFBSSxHQUFHLElBQUksR0FBRyxDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUMsT0FBTyxDQUFDLFFBQVEsRUFBRSx1QkFBdUIsRUFBRSxLQUFLLENBQUMsSUFBSSxFQUFFLEVBQUUsZUFBZSxFQUFFLE1BQU0sRUFBRSxDQUFDLENBQUM7UUFDdkgsSUFBSSxDQUFDLE9BQU8sR0FBRyxLQUFLLENBQUMsT0FBTyxDQUFDO0tBQ2hDO0lBNUVEOzs7Ozs7T0FNRztJQUNJLE1BQU0sQ0FBQyxtQkFBbUIsQ0FBQyxLQUFvQixFQUFFLEVBQVUsRUFBRSxrQkFBdUIsRUFBRSxPQUE0QztRQUNySSxrQkFBa0IsR0FBRyxrQkFBa0IsSUFBSSxFQUFFLENBQUM7UUFDOUMsTUFBTSxrQkFBa0IsR0FBRyxPQUFPLENBQUMsTUFBTSxDQUFDLFVBQVUsQ0FBQyxrQkFBa0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztRQUNwRixNQUFNLFdBQVcsR0FBRyxnQ0FBZ0MsQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDO1FBQ3pFLE1BQU0sR0FBRyxHQUFHLElBQUksU0FBUyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUUsV0FBVyxDQUFDLEtBQUssQ0FBQyxDQUFDO1FBQ3hELEtBQUssTUFBTSxDQUFDLE9BQU8sRUFBRSxPQUFPLENBQUMsSUFBSSxNQUFNLENBQUMsT0FBTyxDQUFDLFdBQVcsQ0FBQyxlQUFlLENBQUMsRUFBRztZQUMzRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsT0FBTyxFQUFFLE9BQU8sQ0FBQyxDQUFDO1NBQzdDO1FBQ0QsT0FBTyxDQUFDLE1BQU0sQ0FBQyxnQkFBZ0IsQ0FBQyxHQUFHLEVBQUUsa0JBQWtCLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFDN0QsT0FBTyxHQUFHLENBQUM7S0FDZDtJQTZERDs7Ozs7T0FLRztJQUNJLE9BQU8sQ0FBQyxTQUE0QjtRQUN2QyxTQUFTLENBQUMsWUFBWSxDQUFDLDZCQUE2QixFQUFFLFNBQVMsQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDO1FBQ3hGLFNBQVMsQ0FBQyxZQUFZLENBQUMsOEJBQThCLEVBQUUsSUFBSSxDQUFDLGFBQWEsQ0FBQyxDQUFDO0tBQzlFO0lBRUQsSUFBYyxhQUFhO1FBQ3ZCLE9BQU87WUFDSCxlQUFlLEVBQUUsSUFBSSxDQUFDLGVBQWU7WUFDckMsSUFBSSxFQUFFLElBQUksQ0FBQyxJQUFJO1lBQ2YsSUFBSSxFQUFFLElBQUksQ0FBQyxJQUFJLENBQUMsVUFBVSxFQUFFO1lBQzVCLE9BQU8sRUFBRSxJQUFJLENBQUMsT0FBTztTQUN4QixDQUFDO0tBQ0w7SUFFUyxnQkFBZ0IsQ0FBQyxLQUEyQjtRQUNsRCxPQUFPLDhCQUE4QixDQUFDLEtBQUssQ0FBQyxDQUFDO0tBQ2hEOztBQTFHTCw4QkEyR0M7OztBQTFHRzs7R0FFRztBQUNvQixnQ0FBc0IsR0FBRyx1QkFBdUIsQ0FBQztBQWdKNUU7Ozs7OztHQU1HO0FBQ0gsU0FBUyxxQ0FBcUMsQ0FBQyxVQUFlO0lBQzFELElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxHQUFHLENBQUMsa0JBQWtCLENBQUM7S0FBRTtJQUNuRSxNQUFNLE1BQU0sR0FBRyxJQUFJLEdBQUcsQ0FBQyxpQkFBaUIsRUFBRSxDQUFDO0lBQzNDLElBQUksT0FBTyxVQUFVLEtBQUssUUFBUSxFQUFFO1FBQ2hDLE1BQU0sQ0FBQyxPQUFPLENBQUMsSUFBSSxHQUFHLENBQUMsZ0JBQWdCLENBQUMsb0NBQW9DLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLENBQUM7S0FDL0c7SUFDRCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxRQUFRLEVBQUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUMsVUFBVSxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUM7SUFDMUYsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsUUFBUSxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQztJQUN2RixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxLQUFLLEVBQUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUM7SUFDcEYsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsS0FBSyxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQztJQUNqRixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxlQUFlLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxhQUFhLENBQUMsQ0FBQyxDQUFDO0lBQ3JHLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFNBQVMsRUFBRSxHQUFHLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxVQUFVLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQztJQUM1RixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxTQUFTLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDO0lBQ3pGLE9BQU8sTUFBTSxDQUFDLElBQUksQ0FBQywwREFBMEQsQ0FBQyxDQUFDO0FBQ25GLENBQUM7QUFFRDs7Ozs7O0dBTUc7QUFDSCxvQkFBb0I7QUFDcEIsU0FBUywyQ0FBMkMsQ0FBQyxVQUFlO0lBQ2hFLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxVQUFVLENBQUM7S0FBRTtJQUN2RCxxQ0FBcUMsQ0FBQyxVQUFVLENBQUMsQ0FBQyxhQUFhLEVBQUUsQ0FBQztJQUNsRSxPQUFPO1FBQ0gsTUFBTSxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsTUFBTSxDQUFDO1FBQ3JELEdBQUcsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQztRQUMvQyxhQUFhLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxhQUFhLENBQUM7UUFDbkUsT0FBTyxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsT0FBTyxDQUFDO0tBQzFELENBQUM7QUFDTixDQUFDO0FBRUQsb0JBQW9CO0FBQ3BCLFNBQVMsNkNBQTZDLENBQUMsVUFBZTtJQUNsRSxJQUFJLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUNwQyxPQUFPLElBQUksU0FBUyxDQUFDLHdCQUF3QixDQUFDLFVBQVUsQ0FBQyxDQUFDO0tBQzdEO0lBQ0QsVUFBVSxHQUFHLFVBQVUsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDO0lBQ2xELElBQUksT0FBTyxVQUFVLEtBQUssUUFBUSxFQUFFO1FBQ2hDLE9BQU8sSUFBSSxTQUFTLENBQUMsd0JBQXdCLENBQUMsVUFBVSxDQUFDLENBQUM7S0FDN0Q7SUFDRCxNQUFNLEdBQUcsR0FBRyxJQUFJLFNBQVMsQ0FBQyxnQ0FBZ0MsRUFBZ0MsQ0FBQztJQUMzRixHQUFHLENBQUMsaUJBQWlCLENBQUMsUUFBUSxFQUFFLFFBQVEsRUFBRSxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDO0lBQ3JHLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxLQUFLLEVBQUUsS0FBSyxFQUFFLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUM7SUFDNUYsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGVBQWUsRUFBRSxlQUFlLEVBQUUsVUFBVSxDQUFDLGFBQWEsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLGFBQWEsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUN6SyxHQUFHLENBQUMsaUJBQWlCLENBQUMsU0FBUyxFQUFFLFNBQVMsRUFBRSxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDO0lBQ3hHLEdBQUcsQ0FBQyxnQ0FBZ0MsQ0FBQyxVQUFVLENBQUMsQ0FBQztJQUNqRCxPQUFPLEdBQUcsQ0FBQztBQUNmLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyIvLyBDb3B5cmlnaHQgMjAxMi0yMDIyIEFtYXpvbi5jb20sIEluYy4gb3IgaXRzIGFmZmlsaWF0ZXMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG4vLyBHZW5lcmF0ZWQgZnJvbSB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIFJlc291cmNlIFNwZWNpZmljYXRpb25cbi8vIFNlZTogZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2Nmbi1yZXNvdXJjZS1zcGVjaWZpY2F0aW9uLmh0bWxcbi8vIEBjZm4ydHM6bWV0YUAge1wiZ2VuZXJhdGVkXCI6XCIyMDIyLTA1LTA0VDE5OjIwOjMzLjMxNFpcIixcImZpbmdlcnByaW50XCI6XCI4SE1pY3NPMTVaZWRzNmhnQ2dJVW1RRnBTYzJ0Q3F5aVFXaDdOdVluZ05vPVwifVxuXG4vKiBlc2xpbnQtZGlzYWJsZSBtYXgtbGVuICovIC8vIFRoaXMgaXMgZ2VuZXJhdGVkIGNvZGUgLSBsaW5lIGxlbmd0aHMgYXJlIGRpZmZpY3VsdCB0byBjb250cm9sXG5cbmltcG9ydCAqIGFzIGNkayBmcm9tICdAYXdzLWNkay9jb3JlJztcbmltcG9ydCAqIGFzIGNmbl9wYXJzZSBmcm9tICdAYXdzLWNkay9jb3JlL2xpYi9oZWxwZXJzLWludGVybmFsJztcblxuLyoqXG4gKiBQcm9wZXJ0aWVzIGZvciBkZWZpbmluZyBhIGBDZm5BbGlhc2BcbiAqXG4gKiBAc3RydWN0XG4gKiBAc3RhYmlsaXR5IGV4dGVybmFsXG4gKlxuICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZ2FtZWxpZnQtYWxpYXMuaHRtbFxuICovXG5leHBvcnQgaW50ZXJmYWNlIENmbkFsaWFzUHJvcHMge1xuXG4gICAgLyoqXG4gICAgICogQSBkZXNjcmlwdGl2ZSBsYWJlbCB0aGF0IGlzIGFzc29jaWF0ZWQgd2l0aCBhbiBhbGlhcy4gQWxpYXMgbmFtZXMgZG8gbm90IG5lZWQgdG8gYmUgdW5pcXVlLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZ2FtZWxpZnQtYWxpYXMuaHRtbCNjZm4tZ2FtZWxpZnQtYWxpYXMtbmFtZVxuICAgICAqL1xuICAgIHJlYWRvbmx5IG5hbWU6IHN0cmluZztcblxuICAgIC8qKlxuICAgICAqIFRoZSByb3V0aW5nIGNvbmZpZ3VyYXRpb24sIGluY2x1ZGluZyByb3V0aW5nIHR5cGUgYW5kIGZsZWV0IHRhcmdldCwgZm9yIHRoZSBhbGlhcy5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWdhbWVsaWZ0LWFsaWFzLmh0bWwjY2ZuLWdhbWVsaWZ0LWFsaWFzLXJvdXRpbmdzdHJhdGVneVxuICAgICAqL1xuICAgIHJlYWRvbmx5IHJvdXRpbmdTdHJhdGVneTogQ2ZuQWxpYXMuUm91dGluZ1N0cmF0ZWd5UHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBBIGh1bWFuLXJlYWRhYmxlIGRlc2NyaXB0aW9uIG9mIHRoZSBhbGlhcy5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWdhbWVsaWZ0LWFsaWFzLmh0bWwjY2ZuLWdhbWVsaWZ0LWFsaWFzLWRlc2NyaXB0aW9uXG4gICAgICovXG4gICAgcmVhZG9ubHkgZGVzY3JpcHRpb24/OiBzdHJpbmc7XG59XG5cbi8qKlxuICogRGV0ZXJtaW5lIHdoZXRoZXIgdGhlIGdpdmVuIHByb3BlcnRpZXMgbWF0Y2ggdGhvc2Ugb2YgYSBgQ2ZuQWxpYXNQcm9wc2BcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgQ2ZuQWxpYXNQcm9wc2BcbiAqXG4gKiBAcmV0dXJucyB0aGUgcmVzdWx0IG9mIHRoZSB2YWxpZGF0aW9uLlxuICovXG5mdW5jdGlvbiBDZm5BbGlhc1Byb3BzVmFsaWRhdG9yKHByb3BlcnRpZXM6IGFueSk6IGNkay5WYWxpZGF0aW9uUmVzdWx0IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBjZGsuVkFMSURBVElPTl9TVUNDRVNTOyB9XG4gICAgY29uc3QgZXJyb3JzID0gbmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0cygpO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgZXJyb3JzLmNvbGxlY3QobmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0KCdFeHBlY3RlZCBhbiBvYmplY3QsIGJ1dCByZWNlaXZlZDogJyArIEpTT04uc3RyaW5naWZ5KHByb3BlcnRpZXMpKSk7XG4gICAgfVxuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignZGVzY3JpcHRpb24nLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuZGVzY3JpcHRpb24pKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ25hbWUnLCBjZGsucmVxdWlyZWRWYWxpZGF0b3IpKHByb3BlcnRpZXMubmFtZSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignbmFtZScsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5uYW1lKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdyb3V0aW5nU3RyYXRlZ3knLCBjZGsucmVxdWlyZWRWYWxpZGF0b3IpKHByb3BlcnRpZXMucm91dGluZ1N0cmF0ZWd5KSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdyb3V0aW5nU3RyYXRlZ3knLCBDZm5BbGlhc19Sb3V0aW5nU3RyYXRlZ3lQcm9wZXJ0eVZhbGlkYXRvcikocHJvcGVydGllcy5yb3V0aW5nU3RyYXRlZ3kpKTtcbiAgICByZXR1cm4gZXJyb3JzLndyYXAoJ3N1cHBsaWVkIHByb3BlcnRpZXMgbm90IGNvcnJlY3QgZm9yIFwiQ2ZuQWxpYXNQcm9wc1wiJyk7XG59XG5cbi8qKlxuICogUmVuZGVycyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6R2FtZUxpZnQ6OkFsaWFzYCByZXNvdXJjZVxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBDZm5BbGlhc1Byb3BzYFxuICpcbiAqIEByZXR1cm5zIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpHYW1lTGlmdDo6QWxpYXNgIHJlc291cmNlLlxuICovXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gY2ZuQWxpYXNQcm9wc1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogYW55IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBwcm9wZXJ0aWVzOyB9XG4gICAgQ2ZuQWxpYXNQcm9wc1ZhbGlkYXRvcihwcm9wZXJ0aWVzKS5hc3NlcnRTdWNjZXNzKCk7XG4gICAgcmV0dXJuIHtcbiAgICAgICAgTmFtZTogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5uYW1lKSxcbiAgICAgICAgUm91dGluZ1N0cmF0ZWd5OiBjZm5BbGlhc1JvdXRpbmdTdHJhdGVneVByb3BlcnR5VG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLnJvdXRpbmdTdHJhdGVneSksXG4gICAgICAgIERlc2NyaXB0aW9uOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLmRlc2NyaXB0aW9uKSxcbiAgICB9O1xufVxuXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gQ2ZuQWxpYXNQcm9wc0Zyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0PENmbkFsaWFzUHJvcHM+IHtcbiAgICBwcm9wZXJ0aWVzID0gcHJvcGVydGllcyA9PSBudWxsID8ge30gOiBwcm9wZXJ0aWVzO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0KHByb3BlcnRpZXMpO1xuICAgIH1cbiAgICBjb25zdCByZXQgPSBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblByb3BlcnR5T2JqZWN0PENmbkFsaWFzUHJvcHM+KCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCduYW1lJywgJ05hbWUnLCBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLk5hbWUpKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ3JvdXRpbmdTdHJhdGVneScsICdSb3V0aW5nU3RyYXRlZ3knLCBDZm5BbGlhc1JvdXRpbmdTdHJhdGVneVByb3BlcnR5RnJvbUNsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuUm91dGluZ1N0cmF0ZWd5KSk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdkZXNjcmlwdGlvbicsICdEZXNjcmlwdGlvbicsIHByb3BlcnRpZXMuRGVzY3JpcHRpb24gIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuRGVzY3JpcHRpb24pIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkVW5yZWNvZ25pemVkUHJvcGVydGllc0FzRXh0cmEocHJvcGVydGllcyk7XG4gICAgcmV0dXJuIHJldDtcbn1cblxuLyoqXG4gKiBBIENsb3VkRm9ybWF0aW9uIGBBV1M6OkdhbWVMaWZ0OjpBbGlhc2BcbiAqXG4gKiBUaGUgYEFXUzo6R2FtZUxpZnQ6OkFsaWFzYCByZXNvdXJjZSBjcmVhdGVzIGFuIGFsaWFzIGZvciBhbiBBbWF6b24gR2FtZUxpZnQgKEdhbWVMaWZ0KSBmbGVldCBkZXN0aW5hdGlvbi4gVGhlcmUgYXJlIHR3byB0eXBlcyBvZiByb3V0aW5nIHN0cmF0ZWdpZXMgZm9yIGFsaWFzZXM6IHNpbXBsZSBhbmQgdGVybWluYWwuIEEgc2ltcGxlIGFsaWFzIHBvaW50cyB0byBhbiBhY3RpdmUgZmxlZXQuIEEgdGVybWluYWwgYWxpYXMgZGlzcGxheXMgYSBtZXNzYWdlIGluc3RlYWQgb2Ygcm91dGluZyBwbGF5ZXJzIHRvIGFuIGFjdGl2ZSBmbGVldC4gRm9yIGV4YW1wbGUsIGEgdGVybWluYWwgYWxpYXMgbWlnaHQgZGlzcGxheSBhIFVSTCBsaW5rIHRoYXQgZGlyZWN0cyBwbGF5ZXJzIHRvIGFuIHVwZ3JhZGUgc2l0ZS4gWW91IGNhbiB1c2UgYWxpYXNlcyB0byBkZWZpbmUgZGVzdGluYXRpb25zIGluIGEgZ2FtZSBzZXNzaW9uIHF1ZXVlIG9yIHdoZW4gcmVxdWVzdGluZyBuZXcgZ2FtZSBzZXNzaW9ucy5cbiAqXG4gKiBAY2xvdWRmb3JtYXRpb25SZXNvdXJjZSBBV1M6OkdhbWVMaWZ0OjpBbGlhc1xuICogQHN0YWJpbGl0eSBleHRlcm5hbFxuICpcbiAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWdhbWVsaWZ0LWFsaWFzLmh0bWxcbiAqL1xuZXhwb3J0IGNsYXNzIENmbkFsaWFzIGV4dGVuZHMgY2RrLkNmblJlc291cmNlIGltcGxlbWVudHMgY2RrLklJbnNwZWN0YWJsZSB7XG4gICAgLyoqXG4gICAgICogVGhlIENsb3VkRm9ybWF0aW9uIHJlc291cmNlIHR5cGUgbmFtZSBmb3IgdGhpcyByZXNvdXJjZSBjbGFzcy5cbiAgICAgKi9cbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IENGTl9SRVNPVVJDRV9UWVBFX05BTUUgPSBcIkFXUzo6R2FtZUxpZnQ6OkFsaWFzXCI7XG5cbiAgICAvKipcbiAgICAgKiBBIGZhY3RvcnkgbWV0aG9kIHRoYXQgY3JlYXRlcyBhIG5ldyBpbnN0YW5jZSBvZiB0aGlzIGNsYXNzIGZyb20gYW4gb2JqZWN0XG4gICAgICogY29udGFpbmluZyB0aGUgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiB0aGlzIHJlc291cmNlLlxuICAgICAqIFVzZWQgaW4gdGhlIEBhd3MtY2RrL2Nsb3VkZm9ybWF0aW9uLWluY2x1ZGUgbW9kdWxlLlxuICAgICAqXG4gICAgICogQGludGVybmFsXG4gICAgICovXG4gICAgcHVibGljIHN0YXRpYyBfZnJvbUNsb3VkRm9ybWF0aW9uKHNjb3BlOiBjZGsuQ29uc3RydWN0LCBpZDogc3RyaW5nLCByZXNvdXJjZUF0dHJpYnV0ZXM6IGFueSwgb3B0aW9uczogY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbk9wdGlvbnMpOiBDZm5BbGlhcyB7XG4gICAgICAgIHJlc291cmNlQXR0cmlidXRlcyA9IHJlc291cmNlQXR0cmlidXRlcyB8fCB7fTtcbiAgICAgICAgY29uc3QgcmVzb3VyY2VQcm9wZXJ0aWVzID0gb3B0aW9ucy5wYXJzZXIucGFyc2VWYWx1ZShyZXNvdXJjZUF0dHJpYnV0ZXMuUHJvcGVydGllcyk7XG4gICAgICAgIGNvbnN0IHByb3BzUmVzdWx0ID0gQ2ZuQWxpYXNQcm9wc0Zyb21DbG91ZEZvcm1hdGlvbihyZXNvdXJjZVByb3BlcnRpZXMpO1xuICAgICAgICBjb25zdCByZXQgPSBuZXcgQ2ZuQWxpYXMoc2NvcGUsIGlkLCBwcm9wc1Jlc3VsdC52YWx1ZSk7XG4gICAgICAgIGZvciAoY29uc3QgW3Byb3BLZXksIHByb3BWYWxdIG9mIE9iamVjdC5lbnRyaWVzKHByb3BzUmVzdWx0LmV4dHJhUHJvcGVydGllcykpICB7XG4gICAgICAgICAgICByZXQuYWRkUHJvcGVydHlPdmVycmlkZShwcm9wS2V5LCBwcm9wVmFsKTtcbiAgICAgICAgfVxuICAgICAgICBvcHRpb25zLnBhcnNlci5oYW5kbGVBdHRyaWJ1dGVzKHJldCwgcmVzb3VyY2VBdHRyaWJ1dGVzLCBpZCk7XG4gICAgICAgIHJldHVybiByZXQ7XG4gICAgfVxuXG4gICAgLyoqXG4gICAgICogQSB1bmlxdWUgaWRlbnRpZmllciBmb3IgdGhlIGFsaWFzLiBGb3IgZXhhbXBsZSwgYGFybjphd3M6Z2FtZWxpZnQ6dXMtd2VzdC0xOjphbGlhcy9hbGlhcy1hMTIzNDU2Ny1iOGM5LTBkMWUtMmZhMy1iNDVjNmQ3ZTg5MTJgXG4gICAgICpcbiAgICAgKiBBbGlhcyBJRHMgYXJlIHVuaXF1ZSB3aXRoaW4gYSBSZWdpb24uXG4gICAgICogQGNsb3VkZm9ybWF0aW9uQXR0cmlidXRlIEFsaWFzSWRcbiAgICAgKi9cbiAgICBwdWJsaWMgcmVhZG9ubHkgYXR0ckFsaWFzSWQ6IHN0cmluZztcblxuICAgIC8qKlxuICAgICAqIEEgZGVzY3JpcHRpdmUgbGFiZWwgdGhhdCBpcyBhc3NvY2lhdGVkIHdpdGggYW4gYWxpYXMuIEFsaWFzIG5hbWVzIGRvIG5vdCBuZWVkIHRvIGJlIHVuaXF1ZS5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWdhbWVsaWZ0LWFsaWFzLmh0bWwjY2ZuLWdhbWVsaWZ0LWFsaWFzLW5hbWVcbiAgICAgKi9cbiAgICBwdWJsaWMgbmFtZTogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogVGhlIHJvdXRpbmcgY29uZmlndXJhdGlvbiwgaW5jbHVkaW5nIHJvdXRpbmcgdHlwZSBhbmQgZmxlZXQgdGFyZ2V0LCBmb3IgdGhlIGFsaWFzLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZ2FtZWxpZnQtYWxpYXMuaHRtbCNjZm4tZ2FtZWxpZnQtYWxpYXMtcm91dGluZ3N0cmF0ZWd5XG4gICAgICovXG4gICAgcHVibGljIHJvdXRpbmdTdHJhdGVneTogQ2ZuQWxpYXMuUm91dGluZ1N0cmF0ZWd5UHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBBIGh1bWFuLXJlYWRhYmxlIGRlc2NyaXB0aW9uIG9mIHRoZSBhbGlhcy5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWdhbWVsaWZ0LWFsaWFzLmh0bWwjY2ZuLWdhbWVsaWZ0LWFsaWFzLWRlc2NyaXB0aW9uXG4gICAgICovXG4gICAgcHVibGljIGRlc2NyaXB0aW9uOiBzdHJpbmcgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBDcmVhdGUgYSBuZXcgYEFXUzo6R2FtZUxpZnQ6OkFsaWFzYC5cbiAgICAgKlxuICAgICAqIEBwYXJhbSBzY29wZSAtIHNjb3BlIGluIHdoaWNoIHRoaXMgcmVzb3VyY2UgaXMgZGVmaW5lZFxuICAgICAqIEBwYXJhbSBpZCAgICAtIHNjb3BlZCBpZCBvZiB0aGUgcmVzb3VyY2VcbiAgICAgKiBAcGFyYW0gcHJvcHMgLSByZXNvdXJjZSBwcm9wZXJ0aWVzXG4gICAgICovXG4gICAgY29uc3RydWN0b3Ioc2NvcGU6IGNkay5Db25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBDZm5BbGlhc1Byb3BzKSB7XG4gICAgICAgIHN1cGVyKHNjb3BlLCBpZCwgeyB0eXBlOiBDZm5BbGlhcy5DRk5fUkVTT1VSQ0VfVFlQRV9OQU1FLCBwcm9wZXJ0aWVzOiBwcm9wcyB9KTtcbiAgICAgICAgY2RrLnJlcXVpcmVQcm9wZXJ0eShwcm9wcywgJ25hbWUnLCB0aGlzKTtcbiAgICAgICAgY2RrLnJlcXVpcmVQcm9wZXJ0eShwcm9wcywgJ3JvdXRpbmdTdHJhdGVneScsIHRoaXMpO1xuICAgICAgICB0aGlzLmF0dHJBbGlhc0lkID0gY2RrLlRva2VuLmFzU3RyaW5nKHRoaXMuZ2V0QXR0KCdBbGlhc0lkJykpO1xuXG4gICAgICAgIHRoaXMubmFtZSA9IHByb3BzLm5hbWU7XG4gICAgICAgIHRoaXMucm91dGluZ1N0cmF0ZWd5ID0gcHJvcHMucm91dGluZ1N0cmF0ZWd5O1xuICAgICAgICB0aGlzLmRlc2NyaXB0aW9uID0gcHJvcHMuZGVzY3JpcHRpb247XG4gICAgfVxuXG4gICAgLyoqXG4gICAgICogRXhhbWluZXMgdGhlIENsb3VkRm9ybWF0aW9uIHJlc291cmNlIGFuZCBkaXNjbG9zZXMgYXR0cmlidXRlcy5cbiAgICAgKlxuICAgICAqIEBwYXJhbSBpbnNwZWN0b3IgLSB0cmVlIGluc3BlY3RvciB0byBjb2xsZWN0IGFuZCBwcm9jZXNzIGF0dHJpYnV0ZXNcbiAgICAgKlxuICAgICAqL1xuICAgIHB1YmxpYyBpbnNwZWN0KGluc3BlY3RvcjogY2RrLlRyZWVJbnNwZWN0b3IpIHtcbiAgICAgICAgaW5zcGVjdG9yLmFkZEF0dHJpYnV0ZShcImF3czpjZGs6Y2xvdWRmb3JtYXRpb246dHlwZVwiLCBDZm5BbGlhcy5DRk5fUkVTT1VSQ0VfVFlQRV9OQU1FKTtcbiAgICAgICAgaW5zcGVjdG9yLmFkZEF0dHJpYnV0ZShcImF3czpjZGs6Y2xvdWRmb3JtYXRpb246cHJvcHNcIiwgdGhpcy5jZm5Qcm9wZXJ0aWVzKTtcbiAgICB9XG5cbiAgICBwcm90ZWN0ZWQgZ2V0IGNmblByb3BlcnRpZXMoKTogeyBba2V5OiBzdHJpbmddOiBhbnkgfSAge1xuICAgICAgICByZXR1cm4ge1xuICAgICAgICAgICAgbmFtZTogdGhpcy5uYW1lLFxuICAgICAgICAgICAgcm91dGluZ1N0cmF0ZWd5OiB0aGlzLnJvdXRpbmdTdHJhdGVneSxcbiAgICAgICAgICAgIGRlc2NyaXB0aW9uOiB0aGlzLmRlc2NyaXB0aW9uLFxuICAgICAgICB9O1xuICAgIH1cblxuICAgIHByb3RlY3RlZCByZW5kZXJQcm9wZXJ0aWVzKHByb3BzOiB7W2tleTogc3RyaW5nXTogYW55fSk6IHsgW2tleTogc3RyaW5nXTogYW55IH0gIHtcbiAgICAgICAgcmV0dXJuIGNmbkFsaWFzUHJvcHNUb0Nsb3VkRm9ybWF0aW9uKHByb3BzKTtcbiAgICB9XG59XG5cbmV4cG9ydCBuYW1lc3BhY2UgQ2ZuQWxpYXMge1xuICAgIC8qKlxuICAgICAqIFRoZSByb3V0aW5nIGNvbmZpZ3VyYXRpb24gZm9yIGEgZmxlZXQgYWxpYXMuXG4gICAgICpcbiAgICAgKiBAc3RydWN0XG4gICAgICogQHN0YWJpbGl0eSBleHRlcm5hbFxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1nYW1lbGlmdC1hbGlhcy1yb3V0aW5nc3RyYXRlZ3kuaHRtbFxuICAgICAqL1xuICAgIGV4cG9ydCBpbnRlcmZhY2UgUm91dGluZ1N0cmF0ZWd5UHJvcGVydHkge1xuICAgICAgICAvKipcbiAgICAgICAgICogQSB1bmlxdWUgaWRlbnRpZmllciBmb3IgYSBmbGVldCB0aGF0IHRoZSBhbGlhcyBwb2ludHMgdG8uIElmIHlvdSBzcGVjaWZ5IGBTSU1QTEVgIGZvciB0aGUgYFR5cGVgIHByb3BlcnR5LCB5b3UgbXVzdCBzcGVjaWZ5IHRoaXMgcHJvcGVydHkuXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtZ2FtZWxpZnQtYWxpYXMtcm91dGluZ3N0cmF0ZWd5Lmh0bWwjY2ZuLWdhbWVsaWZ0LWFsaWFzLXJvdXRpbmdzdHJhdGVneS1mbGVldGlkXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBmbGVldElkPzogc3RyaW5nO1xuICAgICAgICAvKipcbiAgICAgICAgICogVGhlIG1lc3NhZ2UgdGV4dCB0byBiZSB1c2VkIHdpdGggYSB0ZXJtaW5hbCByb3V0aW5nIHN0cmF0ZWd5LiBJZiB5b3Ugc3BlY2lmeSBgVEVSTUlOQUxgIGZvciB0aGUgYFR5cGVgIHByb3BlcnR5LCB5b3UgbXVzdCBzcGVjaWZ5IHRoaXMgcHJvcGVydHkuXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtZ2FtZWxpZnQtYWxpYXMtcm91dGluZ3N0cmF0ZWd5Lmh0bWwjY2ZuLWdhbWVsaWZ0LWFsaWFzLXJvdXRpbmdzdHJhdGVneS1tZXNzYWdlXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBtZXNzYWdlPzogc3RyaW5nO1xuICAgICAgICAvKipcbiAgICAgICAgICogQSB0eXBlIG9mIHJvdXRpbmcgc3RyYXRlZ3kuXG4gICAgICAgICAqXG4gICAgICAgICAqIFBvc3NpYmxlIHJvdXRpbmcgdHlwZXMgaW5jbHVkZSB0aGUgZm9sbG93aW5nOlxuICAgICAgICAgKlxuICAgICAgICAgKiAtICpTSU1QTEUqIC0gVGhlIGFsaWFzIHJlc29sdmVzIHRvIG9uZSBzcGVjaWZpYyBmbGVldC4gVXNlIHRoaXMgdHlwZSB3aGVuIHJvdXRpbmcgdG8gYWN0aXZlIGZsZWV0cy5cbiAgICAgICAgICogLSAqVEVSTUlOQUwqIC0gVGhlIGFsaWFzIGRvZXMgbm90IHJlc29sdmUgdG8gYSBmbGVldCBidXQgaW5zdGVhZCBjYW4gYmUgdXNlZCB0byBkaXNwbGF5IGEgbWVzc2FnZSB0byB0aGUgdXNlci4gQSB0ZXJtaW5hbCBhbGlhcyB0aHJvd3MgYSBgVGVybWluYWxSb3V0aW5nU3RyYXRlZ3lFeGNlcHRpb25gIHdpdGggdGhlIG1lc3NhZ2UgdGhhdCB5b3Ugc3BlY2lmaWVkIGluIHRoZSBgTWVzc2FnZWAgcHJvcGVydHkuXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtZ2FtZWxpZnQtYWxpYXMtcm91dGluZ3N0cmF0ZWd5Lmh0bWwjY2ZuLWdhbWVsaWZ0LWFsaWFzLXJvdXRpbmdzdHJhdGVneS10eXBlXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSB0eXBlOiBzdHJpbmc7XG4gICAgfVxufVxuXG4vKipcbiAqIERldGVybWluZSB3aGV0aGVyIHRoZSBnaXZlbiBwcm9wZXJ0aWVzIG1hdGNoIHRob3NlIG9mIGEgYFJvdXRpbmdTdHJhdGVneVByb3BlcnR5YFxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBSb3V0aW5nU3RyYXRlZ3lQcm9wZXJ0eWBcbiAqXG4gKiBAcmV0dXJucyB0aGUgcmVzdWx0IG9mIHRoZSB2YWxpZGF0aW9uLlxuICovXG5mdW5jdGlvbiBDZm5BbGlhc19Sb3V0aW5nU3RyYXRlZ3lQcm9wZXJ0eVZhbGlkYXRvcihwcm9wZXJ0aWVzOiBhbnkpOiBjZGsuVmFsaWRhdGlvblJlc3VsdCB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gY2RrLlZBTElEQVRJT05fU1VDQ0VTUzsgfVxuICAgIGNvbnN0IGVycm9ycyA9IG5ldyBjZGsuVmFsaWRhdGlvblJlc3VsdHMoKTtcbiAgICBpZiAodHlwZW9mIHByb3BlcnRpZXMgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIGVycm9ycy5jb2xsZWN0KG5ldyBjZGsuVmFsaWRhdGlvblJlc3VsdCgnRXhwZWN0ZWQgYW4gb2JqZWN0LCBidXQgcmVjZWl2ZWQ6ICcgKyBKU09OLnN0cmluZ2lmeShwcm9wZXJ0aWVzKSkpO1xuICAgIH1cbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2ZsZWV0SWQnLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuZmxlZXRJZCkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignbWVzc2FnZScsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5tZXNzYWdlKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCd0eXBlJywgY2RrLnJlcXVpcmVkVmFsaWRhdG9yKShwcm9wZXJ0aWVzLnR5cGUpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3R5cGUnLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMudHlwZSkpO1xuICAgIHJldHVybiBlcnJvcnMud3JhcCgnc3VwcGxpZWQgcHJvcGVydGllcyBub3QgY29ycmVjdCBmb3IgXCJSb3V0aW5nU3RyYXRlZ3lQcm9wZXJ0eVwiJyk7XG59XG5cbi8qKlxuICogUmVuZGVycyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6R2FtZUxpZnQ6OkFsaWFzLlJvdXRpbmdTdHJhdGVneWAgcmVzb3VyY2VcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgUm91dGluZ1N0cmF0ZWd5UHJvcGVydHlgXG4gKlxuICogQHJldHVybnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OkdhbWVMaWZ0OjpBbGlhcy5Sb3V0aW5nU3RyYXRlZ3lgIHJlc291cmNlLlxuICovXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gY2ZuQWxpYXNSb3V0aW5nU3RyYXRlZ3lQcm9wZXJ0eVRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogYW55IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBwcm9wZXJ0aWVzOyB9XG4gICAgQ2ZuQWxpYXNfUm91dGluZ1N0cmF0ZWd5UHJvcGVydHlWYWxpZGF0b3IocHJvcGVydGllcykuYXNzZXJ0U3VjY2VzcygpO1xuICAgIHJldHVybiB7XG4gICAgICAgIEZsZWV0SWQ6IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuZmxlZXRJZCksXG4gICAgICAgIE1lc3NhZ2U6IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMubWVzc2FnZSksXG4gICAgICAgIFR5cGU6IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMudHlwZSksXG4gICAgfTtcbn1cblxuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIENmbkFsaWFzUm91dGluZ1N0cmF0ZWd5UHJvcGVydHlGcm9tQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdDxDZm5BbGlhcy5Sb3V0aW5nU3RyYXRlZ3lQcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZT4ge1xuICAgIGlmIChjZGsuaXNSZXNvbHZhYmxlT2JqZWN0KHByb3BlcnRpZXMpKSB7XG4gICAgICAgIHJldHVybiBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdChwcm9wZXJ0aWVzKTtcbiAgICB9XG4gICAgcHJvcGVydGllcyA9IHByb3BlcnRpZXMgPT0gbnVsbCA/IHt9IDogcHJvcGVydGllcztcbiAgICBpZiAodHlwZW9mIHByb3BlcnRpZXMgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIHJldHVybiBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdChwcm9wZXJ0aWVzKTtcbiAgICB9XG4gICAgY29uc3QgcmV0ID0gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25Qcm9wZXJ0eU9iamVjdDxDZm5BbGlhcy5Sb3V0aW5nU3RyYXRlZ3lQcm9wZXJ0eT4oKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2ZsZWV0SWQnLCAnRmxlZXRJZCcsIHByb3BlcnRpZXMuRmxlZXRJZCAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5GbGVldElkKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdtZXNzYWdlJywgJ01lc3NhZ2UnLCBwcm9wZXJ0aWVzLk1lc3NhZ2UgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuTWVzc2FnZSkgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgndHlwZScsICdUeXBlJywgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5UeXBlKSk7XG4gICAgcmV0LmFkZFVucmVjb2duaXplZFByb3BlcnRpZXNBc0V4dHJhKHByb3BlcnRpZXMpO1xuICAgIHJldHVybiByZXQ7XG59XG5cbi8qKlxuICogUHJvcGVydGllcyBmb3IgZGVmaW5pbmcgYSBgQ2ZuQnVpbGRgXG4gKlxuICogQHN0cnVjdFxuICogQHN0YWJpbGl0eSBleHRlcm5hbFxuICpcbiAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWdhbWVsaWZ0LWJ1aWxkLmh0bWxcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBDZm5CdWlsZFByb3BzIHtcblxuICAgIC8qKlxuICAgICAqIEEgZGVzY3JpcHRpdmUgbGFiZWwgdGhhdCBpcyBhc3NvY2lhdGVkIHdpdGggYSBidWlsZC4gQnVpbGQgbmFtZXMgZG8gbm90IG5lZWQgdG8gYmUgdW5pcXVlLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZ2FtZWxpZnQtYnVpbGQuaHRtbCNjZm4tZ2FtZWxpZnQtYnVpbGQtbmFtZVxuICAgICAqL1xuICAgIHJlYWRvbmx5IG5hbWU/OiBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgb3BlcmF0aW5nIHN5c3RlbSB0aGF0IHRoZSBnYW1lIHNlcnZlciBiaW5hcmllcyBhcmUgYnVpbHQgdG8gcnVuIG9uLiBUaGlzIHZhbHVlIGRldGVybWluZXMgdGhlIHR5cGUgb2YgZmxlZXQgcmVzb3VyY2VzIHRoYXQgeW91IGNhbiB1c2UgZm9yIHRoaXMgYnVpbGQuIElmIHlvdXIgZ2FtZSBidWlsZCBjb250YWlucyBtdWx0aXBsZSBleGVjdXRhYmxlcywgdGhleSBhbGwgbXVzdCBydW4gb24gdGhlIHNhbWUgb3BlcmF0aW5nIHN5c3RlbS4gSWYgYW4gb3BlcmF0aW5nIHN5c3RlbSBpcyBub3Qgc3BlY2lmaWVkIHdoZW4gY3JlYXRpbmcgYSBidWlsZCwgQW1hem9uIEdhbWVMaWZ0IHVzZXMgdGhlIGRlZmF1bHQgdmFsdWUgKFdJTkRPV1NfMjAxMikuIFRoaXMgdmFsdWUgY2Fubm90IGJlIGNoYW5nZWQgbGF0ZXIuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1nYW1lbGlmdC1idWlsZC5odG1sI2Nmbi1nYW1lbGlmdC1idWlsZC1vcGVyYXRpbmdzeXN0ZW1cbiAgICAgKi9cbiAgICByZWFkb25seSBvcGVyYXRpbmdTeXN0ZW0/OiBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBJbmZvcm1hdGlvbiBpbmRpY2F0aW5nIHdoZXJlIHlvdXIgZ2FtZSBidWlsZCBmaWxlcyBhcmUgc3RvcmVkLiBVc2UgdGhpcyBwYXJhbWV0ZXIgb25seSB3aGVuIGNyZWF0aW5nIGEgYnVpbGQgd2l0aCBmaWxlcyBzdG9yZWQgaW4gYW4gQW1hem9uIFMzIGJ1Y2tldCB0aGF0IHlvdSBvd24uIFRoZSBzdG9yYWdlIGxvY2F0aW9uIG11c3Qgc3BlY2lmeSBhbiBBbWF6b24gUzMgYnVja2V0IG5hbWUgYW5kIGtleS4gVGhlIGxvY2F0aW9uIG11c3QgYWxzbyBzcGVjaWZ5IGEgcm9sZSBBUk4gdGhhdCB5b3Ugc2V0IHVwIHRvIGFsbG93IEFtYXpvbiBHYW1lTGlmdCB0byBhY2Nlc3MgeW91ciBBbWF6b24gUzMgYnVja2V0LiBUaGUgUzMgYnVja2V0IGFuZCB5b3VyIG5ldyBidWlsZCBtdXN0IGJlIGluIHRoZSBzYW1lIFJlZ2lvbi5cbiAgICAgKlxuICAgICAqIElmIGEgYFN0b3JhZ2VMb2NhdGlvbmAgaXMgc3BlY2lmaWVkLCB0aGUgc2l6ZSBvZiB5b3VyIGZpbGUgY2FuIGJlIGZvdW5kIGluIHlvdXIgQW1hem9uIFMzIGJ1Y2tldC4gQW1hem9uIEdhbWVMaWZ0IHdpbGwgcmVwb3J0IGEgYFNpemVPbkRpc2tgIG9mIDAuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1nYW1lbGlmdC1idWlsZC5odG1sI2Nmbi1nYW1lbGlmdC1idWlsZC1zdG9yYWdlbG9jYXRpb25cbiAgICAgKi9cbiAgICByZWFkb25seSBzdG9yYWdlTG9jYXRpb24/OiBDZm5CdWlsZC5TM0xvY2F0aW9uUHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBWZXJzaW9uIGluZm9ybWF0aW9uIHRoYXQgaXMgYXNzb2NpYXRlZCB3aXRoIHRoaXMgYnVpbGQuIFZlcnNpb24gc3RyaW5ncyBkbyBub3QgbmVlZCB0byBiZSB1bmlxdWUuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1nYW1lbGlmdC1idWlsZC5odG1sI2Nmbi1nYW1lbGlmdC1idWlsZC12ZXJzaW9uXG4gICAgICovXG4gICAgcmVhZG9ubHkgdmVyc2lvbj86IHN0cmluZztcbn1cblxuLyoqXG4gKiBEZXRlcm1pbmUgd2hldGhlciB0aGUgZ2l2ZW4gcHJvcGVydGllcyBtYXRjaCB0aG9zZSBvZiBhIGBDZm5CdWlsZFByb3BzYFxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBDZm5CdWlsZFByb3BzYFxuICpcbiAqIEByZXR1cm5zIHRoZSByZXN1bHQgb2YgdGhlIHZhbGlkYXRpb24uXG4gKi9cbmZ1bmN0aW9uIENmbkJ1aWxkUHJvcHNWYWxpZGF0b3IocHJvcGVydGllczogYW55KTogY2RrLlZhbGlkYXRpb25SZXN1bHQge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIGNkay5WQUxJREFUSU9OX1NVQ0NFU1M7IH1cbiAgICBjb25zdCBlcnJvcnMgPSBuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHRzKCk7XG4gICAgaWYgKHR5cGVvZiBwcm9wZXJ0aWVzICE9PSAnb2JqZWN0Jykge1xuICAgICAgICBlcnJvcnMuY29sbGVjdChuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHQoJ0V4cGVjdGVkIGFuIG9iamVjdCwgYnV0IHJlY2VpdmVkOiAnICsgSlNPTi5zdHJpbmdpZnkocHJvcGVydGllcykpKTtcbiAgICB9XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCduYW1lJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLm5hbWUpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ29wZXJhdGluZ1N5c3RlbScsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5vcGVyYXRpbmdTeXN0ZW0pKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3N0b3JhZ2VMb2NhdGlvbicsIENmbkJ1aWxkX1MzTG9jYXRpb25Qcm9wZXJ0eVZhbGlkYXRvcikocHJvcGVydGllcy5zdG9yYWdlTG9jYXRpb24pKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3ZlcnNpb24nLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMudmVyc2lvbikpO1xuICAgIHJldHVybiBlcnJvcnMud3JhcCgnc3VwcGxpZWQgcHJvcGVydGllcyBub3QgY29ycmVjdCBmb3IgXCJDZm5CdWlsZFByb3BzXCInKTtcbn1cblxuLyoqXG4gKiBSZW5kZXJzIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpHYW1lTGlmdDo6QnVpbGRgIHJlc291cmNlXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYENmbkJ1aWxkUHJvcHNgXG4gKlxuICogQHJldHVybnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OkdhbWVMaWZ0OjpCdWlsZGAgcmVzb3VyY2UuXG4gKi9cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBjZm5CdWlsZFByb3BzVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBhbnkge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIHByb3BlcnRpZXM7IH1cbiAgICBDZm5CdWlsZFByb3BzVmFsaWRhdG9yKHByb3BlcnRpZXMpLmFzc2VydFN1Y2Nlc3MoKTtcbiAgICByZXR1cm4ge1xuICAgICAgICBOYW1lOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLm5hbWUpLFxuICAgICAgICBPcGVyYXRpbmdTeXN0ZW06IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMub3BlcmF0aW5nU3lzdGVtKSxcbiAgICAgICAgU3RvcmFnZUxvY2F0aW9uOiBjZm5CdWlsZFMzTG9jYXRpb25Qcm9wZXJ0eVRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5zdG9yYWdlTG9jYXRpb24pLFxuICAgICAgICBWZXJzaW9uOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLnZlcnNpb24pLFxuICAgIH07XG59XG5cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBDZm5CdWlsZFByb3BzRnJvbUNsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQ8Q2ZuQnVpbGRQcm9wcz4ge1xuICAgIHByb3BlcnRpZXMgPSBwcm9wZXJ0aWVzID09IG51bGwgPyB7fSA6IHByb3BlcnRpZXM7XG4gICAgaWYgKHR5cGVvZiBwcm9wZXJ0aWVzICE9PSAnb2JqZWN0Jykge1xuICAgICAgICByZXR1cm4gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQocHJvcGVydGllcyk7XG4gICAgfVxuICAgIGNvbnN0IHJldCA9IG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUHJvcGVydHlPYmplY3Q8Q2ZuQnVpbGRQcm9wcz4oKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ25hbWUnLCAnTmFtZScsIHByb3BlcnRpZXMuTmFtZSAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5OYW1lKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdvcGVyYXRpbmdTeXN0ZW0nLCAnT3BlcmF0aW5nU3lzdGVtJywgcHJvcGVydGllcy5PcGVyYXRpbmdTeXN0ZW0gIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuT3BlcmF0aW5nU3lzdGVtKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdzdG9yYWdlTG9jYXRpb24nLCAnU3RvcmFnZUxvY2F0aW9uJywgcHJvcGVydGllcy5TdG9yYWdlTG9jYXRpb24gIT0gbnVsbCA/IENmbkJ1aWxkUzNMb2NhdGlvblByb3BlcnR5RnJvbUNsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuU3RvcmFnZUxvY2F0aW9uKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCd2ZXJzaW9uJywgJ1ZlcnNpb24nLCBwcm9wZXJ0aWVzLlZlcnNpb24gIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuVmVyc2lvbikgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRVbnJlY29nbml6ZWRQcm9wZXJ0aWVzQXNFeHRyYShwcm9wZXJ0aWVzKTtcbiAgICByZXR1cm4gcmV0O1xufVxuXG4vKipcbiAqIEEgQ2xvdWRGb3JtYXRpb24gYEFXUzo6R2FtZUxpZnQ6OkJ1aWxkYFxuICpcbiAqIFRoZSBgQVdTOjpHYW1lTGlmdDo6QnVpbGRgIHJlc291cmNlIGNyZWF0ZXMgYSBnYW1lIHNlcnZlciBidWlsZCB0aGF0IGlzIGluc3RhbGxlZCBhbmQgcnVuIG9uIGluc3RhbmNlcyBpbiBhbiBBbWF6b24gR2FtZUxpZnQgZmxlZXQuIFRoaXMgcmVzb3VyY2UgcG9pbnRzIHRvIGFuIEFtYXpvbiBTMyBsb2NhdGlvbiB0aGF0IGNvbnRhaW5zIGEgemlwIGZpbGUgd2l0aCBhbGwgb2YgdGhlIGNvbXBvbmVudHMgb2YgdGhlIGdhbWUgc2VydmVyIGJ1aWxkLlxuICpcbiAqIEBjbG91ZGZvcm1hdGlvblJlc291cmNlIEFXUzo6R2FtZUxpZnQ6OkJ1aWxkXG4gKiBAc3RhYmlsaXR5IGV4dGVybmFsXG4gKlxuICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZ2FtZWxpZnQtYnVpbGQuaHRtbFxuICovXG5leHBvcnQgY2xhc3MgQ2ZuQnVpbGQgZXh0ZW5kcyBjZGsuQ2ZuUmVzb3VyY2UgaW1wbGVtZW50cyBjZGsuSUluc3BlY3RhYmxlIHtcbiAgICAvKipcbiAgICAgKiBUaGUgQ2xvdWRGb3JtYXRpb24gcmVzb3VyY2UgdHlwZSBuYW1lIGZvciB0aGlzIHJlc291cmNlIGNsYXNzLlxuICAgICAqL1xuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgQ0ZOX1JFU09VUkNFX1RZUEVfTkFNRSA9IFwiQVdTOjpHYW1lTGlmdDo6QnVpbGRcIjtcblxuICAgIC8qKlxuICAgICAqIEEgZmFjdG9yeSBtZXRob2QgdGhhdCBjcmVhdGVzIGEgbmV3IGluc3RhbmNlIG9mIHRoaXMgY2xhc3MgZnJvbSBhbiBvYmplY3RcbiAgICAgKiBjb250YWluaW5nIHRoZSBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIHRoaXMgcmVzb3VyY2UuXG4gICAgICogVXNlZCBpbiB0aGUgQGF3cy1jZGsvY2xvdWRmb3JtYXRpb24taW5jbHVkZSBtb2R1bGUuXG4gICAgICpcbiAgICAgKiBAaW50ZXJuYWxcbiAgICAgKi9cbiAgICBwdWJsaWMgc3RhdGljIF9mcm9tQ2xvdWRGb3JtYXRpb24oc2NvcGU6IGNkay5Db25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHJlc291cmNlQXR0cmlidXRlczogYW55LCBvcHRpb25zOiBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uT3B0aW9ucyk6IENmbkJ1aWxkIHtcbiAgICAgICAgcmVzb3VyY2VBdHRyaWJ1dGVzID0gcmVzb3VyY2VBdHRyaWJ1dGVzIHx8IHt9O1xuICAgICAgICBjb25zdCByZXNvdXJjZVByb3BlcnRpZXMgPSBvcHRpb25zLnBhcnNlci5wYXJzZVZhbHVlKHJlc291cmNlQXR0cmlidXRlcy5Qcm9wZXJ0aWVzKTtcbiAgICAgICAgY29uc3QgcHJvcHNSZXN1bHQgPSBDZm5CdWlsZFByb3BzRnJvbUNsb3VkRm9ybWF0aW9uKHJlc291cmNlUHJvcGVydGllcyk7XG4gICAgICAgIGNvbnN0IHJldCA9IG5ldyBDZm5CdWlsZChzY29wZSwgaWQsIHByb3BzUmVzdWx0LnZhbHVlKTtcbiAgICAgICAgZm9yIChjb25zdCBbcHJvcEtleSwgcHJvcFZhbF0gb2YgT2JqZWN0LmVudHJpZXMocHJvcHNSZXN1bHQuZXh0cmFQcm9wZXJ0aWVzKSkgIHtcbiAgICAgICAgICAgIHJldC5hZGRQcm9wZXJ0eU92ZXJyaWRlKHByb3BLZXksIHByb3BWYWwpO1xuICAgICAgICB9XG4gICAgICAgIG9wdGlvbnMucGFyc2VyLmhhbmRsZUF0dHJpYnV0ZXMocmV0LCByZXNvdXJjZUF0dHJpYnV0ZXMsIGlkKTtcbiAgICAgICAgcmV0dXJuIHJldDtcbiAgICB9XG5cbiAgICAvKipcbiAgICAgKiBBIGRlc2NyaXB0aXZlIGxhYmVsIHRoYXQgaXMgYXNzb2NpYXRlZCB3aXRoIGEgYnVpbGQuIEJ1aWxkIG5hbWVzIGRvIG5vdCBuZWVkIHRvIGJlIHVuaXF1ZS5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWdhbWVsaWZ0LWJ1aWxkLmh0bWwjY2ZuLWdhbWVsaWZ0LWJ1aWxkLW5hbWVcbiAgICAgKi9cbiAgICBwdWJsaWMgbmFtZTogc3RyaW5nIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogVGhlIG9wZXJhdGluZyBzeXN0ZW0gdGhhdCB0aGUgZ2FtZSBzZXJ2ZXIgYmluYXJpZXMgYXJlIGJ1aWx0IHRvIHJ1biBvbi4gVGhpcyB2YWx1ZSBkZXRlcm1pbmVzIHRoZSB0eXBlIG9mIGZsZWV0IHJlc291cmNlcyB0aGF0IHlvdSBjYW4gdXNlIGZvciB0aGlzIGJ1aWxkLiBJZiB5b3VyIGdhbWUgYnVpbGQgY29udGFpbnMgbXVsdGlwbGUgZXhlY3V0YWJsZXMsIHRoZXkgYWxsIG11c3QgcnVuIG9uIHRoZSBzYW1lIG9wZXJhdGluZyBzeXN0ZW0uIElmIGFuIG9wZXJhdGluZyBzeXN0ZW0gaXMgbm90IHNwZWNpZmllZCB3aGVuIGNyZWF0aW5nIGEgYnVpbGQsIEFtYXpvbiBHYW1lTGlmdCB1c2VzIHRoZSBkZWZhdWx0IHZhbHVlIChXSU5ET1dTXzIwMTIpLiBUaGlzIHZhbHVlIGNhbm5vdCBiZSBjaGFuZ2VkIGxhdGVyLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZ2FtZWxpZnQtYnVpbGQuaHRtbCNjZm4tZ2FtZWxpZnQtYnVpbGQtb3BlcmF0aW5nc3lzdGVtXG4gICAgICovXG4gICAgcHVibGljIG9wZXJhdGluZ1N5c3RlbTogc3RyaW5nIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogSW5mb3JtYXRpb24gaW5kaWNhdGluZyB3aGVyZSB5b3VyIGdhbWUgYnVpbGQgZmlsZXMgYXJlIHN0b3JlZC4gVXNlIHRoaXMgcGFyYW1ldGVyIG9ubHkgd2hlbiBjcmVhdGluZyBhIGJ1aWxkIHdpdGggZmlsZXMgc3RvcmVkIGluIGFuIEFtYXpvbiBTMyBidWNrZXQgdGhhdCB5b3Ugb3duLiBUaGUgc3RvcmFnZSBsb2NhdGlvbiBtdXN0IHNwZWNpZnkgYW4gQW1hem9uIFMzIGJ1Y2tldCBuYW1lIGFuZCBrZXkuIFRoZSBsb2NhdGlvbiBtdXN0IGFsc28gc3BlY2lmeSBhIHJvbGUgQVJOIHRoYXQgeW91IHNldCB1cCB0byBhbGxvdyBBbWF6b24gR2FtZUxpZnQgdG8gYWNjZXNzIHlvdXIgQW1hem9uIFMzIGJ1Y2tldC4gVGhlIFMzIGJ1Y2tldCBhbmQgeW91ciBuZXcgYnVpbGQgbXVzdCBiZSBpbiB0aGUgc2FtZSBSZWdpb24uXG4gICAgICpcbiAgICAgKiBJZiBhIGBTdG9yYWdlTG9jYXRpb25gIGlzIHNwZWNpZmllZCwgdGhlIHNpemUgb2YgeW91ciBmaWxlIGNhbiBiZSBmb3VuZCBpbiB5b3VyIEFtYXpvbiBTMyBidWNrZXQuIEFtYXpvbiBHYW1lTGlmdCB3aWxsIHJlcG9ydCBhIGBTaXplT25EaXNrYCBvZiAwLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZ2FtZWxpZnQtYnVpbGQuaHRtbCNjZm4tZ2FtZWxpZnQtYnVpbGQtc3RvcmFnZWxvY2F0aW9uXG4gICAgICovXG4gICAgcHVibGljIHN0b3JhZ2VMb2NhdGlvbjogQ2ZuQnVpbGQuUzNMb2NhdGlvblByb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogVmVyc2lvbiBpbmZvcm1hdGlvbiB0aGF0IGlzIGFzc29jaWF0ZWQgd2l0aCB0aGlzIGJ1aWxkLiBWZXJzaW9uIHN0cmluZ3MgZG8gbm90IG5lZWQgdG8gYmUgdW5pcXVlLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZ2FtZWxpZnQtYnVpbGQuaHRtbCNjZm4tZ2FtZWxpZnQtYnVpbGQtdmVyc2lvblxuICAgICAqL1xuICAgIHB1YmxpYyB2ZXJzaW9uOiBzdHJpbmcgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBDcmVhdGUgYSBuZXcgYEFXUzo6R2FtZUxpZnQ6OkJ1aWxkYC5cbiAgICAgKlxuICAgICAqIEBwYXJhbSBzY29wZSAtIHNjb3BlIGluIHdoaWNoIHRoaXMgcmVzb3VyY2UgaXMgZGVmaW5lZFxuICAgICAqIEBwYXJhbSBpZCAgICAtIHNjb3BlZCBpZCBvZiB0aGUgcmVzb3VyY2VcbiAgICAgKiBAcGFyYW0gcHJvcHMgLSByZXNvdXJjZSBwcm9wZXJ0aWVzXG4gICAgICovXG4gICAgY29uc3RydWN0b3Ioc2NvcGU6IGNkay5Db25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBDZm5CdWlsZFByb3BzID0ge30pIHtcbiAgICAgICAgc3VwZXIoc2NvcGUsIGlkLCB7IHR5cGU6IENmbkJ1aWxkLkNGTl9SRVNPVVJDRV9UWVBFX05BTUUsIHByb3BlcnRpZXM6IHByb3BzIH0pO1xuXG4gICAgICAgIHRoaXMubmFtZSA9IHByb3BzLm5hbWU7XG4gICAgICAgIHRoaXMub3BlcmF0aW5nU3lzdGVtID0gcHJvcHMub3BlcmF0aW5nU3lzdGVtO1xuICAgICAgICB0aGlzLnN0b3JhZ2VMb2NhdGlvbiA9IHByb3BzLnN0b3JhZ2VMb2NhdGlvbjtcbiAgICAgICAgdGhpcy52ZXJzaW9uID0gcHJvcHMudmVyc2lvbjtcbiAgICB9XG5cbiAgICAvKipcbiAgICAgKiBFeGFtaW5lcyB0aGUgQ2xvdWRGb3JtYXRpb24gcmVzb3VyY2UgYW5kIGRpc2Nsb3NlcyBhdHRyaWJ1dGVzLlxuICAgICAqXG4gICAgICogQHBhcmFtIGluc3BlY3RvciAtIHRyZWUgaW5zcGVjdG9yIHRvIGNvbGxlY3QgYW5kIHByb2Nlc3MgYXR0cmlidXRlc1xuICAgICAqXG4gICAgICovXG4gICAgcHVibGljIGluc3BlY3QoaW5zcGVjdG9yOiBjZGsuVHJlZUluc3BlY3Rvcikge1xuICAgICAgICBpbnNwZWN0b3IuYWRkQXR0cmlidXRlKFwiYXdzOmNkazpjbG91ZGZvcm1hdGlvbjp0eXBlXCIsIENmbkJ1aWxkLkNGTl9SRVNPVVJDRV9UWVBFX05BTUUpO1xuICAgICAgICBpbnNwZWN0b3IuYWRkQXR0cmlidXRlKFwiYXdzOmNkazpjbG91ZGZvcm1hdGlvbjpwcm9wc1wiLCB0aGlzLmNmblByb3BlcnRpZXMpO1xuICAgIH1cblxuICAgIHByb3RlY3RlZCBnZXQgY2ZuUHJvcGVydGllcygpOiB7IFtrZXk6IHN0cmluZ106IGFueSB9ICB7XG4gICAgICAgIHJldHVybiB7XG4gICAgICAgICAgICBuYW1lOiB0aGlzLm5hbWUsXG4gICAgICAgICAgICBvcGVyYXRpbmdTeXN0ZW06IHRoaXMub3BlcmF0aW5nU3lzdGVtLFxuICAgICAgICAgICAgc3RvcmFnZUxvY2F0aW9uOiB0aGlzLnN0b3JhZ2VMb2NhdGlvbixcbiAgICAgICAgICAgIHZlcnNpb246IHRoaXMudmVyc2lvbixcbiAgICAgICAgfTtcbiAgICB9XG5cbiAgICBwcm90ZWN0ZWQgcmVuZGVyUHJvcGVydGllcyhwcm9wczoge1trZXk6IHN0cmluZ106IGFueX0pOiB7IFtrZXk6IHN0cmluZ106IGFueSB9ICB7XG4gICAgICAgIHJldHVybiBjZm5CdWlsZFByb3BzVG9DbG91ZEZvcm1hdGlvbihwcm9wcyk7XG4gICAgfVxufVxuXG5leHBvcnQgbmFtZXNwYWNlIENmbkJ1aWxkIHtcbiAgICAvKipcbiAgICAgKiBUaGUgbG9jYXRpb24gaW4gQW1hem9uIFMzIHdoZXJlIGJ1aWxkIG9yIHNjcmlwdCBmaWxlcyBhcmUgc3RvcmVkIGZvciBhY2Nlc3MgYnkgQW1hem9uIEdhbWVMaWZ0LlxuICAgICAqXG4gICAgICogQHN0cnVjdFxuICAgICAqIEBzdGFiaWxpdHkgZXh0ZXJuYWxcbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtZ2FtZWxpZnQtYnVpbGQtc3RvcmFnZWxvY2F0aW9uLmh0bWxcbiAgICAgKi9cbiAgICBleHBvcnQgaW50ZXJmYWNlIFMzTG9jYXRpb25Qcm9wZXJ0eSB7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBBbiBBbWF6b24gUzMgYnVja2V0IGlkZW50aWZpZXIuIFRoaXMgaXMgdGhlIG5hbWUgb2YgdGhlIFMzIGJ1Y2tldC5cbiAgICAgICAgICpcbiAgICAgICAgICogPiBHYW1lTGlmdCBjdXJyZW50bHkgZG9lcyBub3Qgc3VwcG9ydCB1cGxvYWRpbmcgZnJvbSBBbWF6b24gUzMgYnVja2V0cyB3aXRoIG5hbWVzIHRoYXQgY29udGFpbiBhIGRvdCAoLikuXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtZ2FtZWxpZnQtYnVpbGQtc3RvcmFnZWxvY2F0aW9uLmh0bWwjY2ZuLWdhbWVsaWZ0LWJ1aWxkLXN0b3JhZ2UtYnVja2V0XG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBidWNrZXQ6IHN0cmluZztcbiAgICAgICAgLyoqXG4gICAgICAgICAqIFRoZSBuYW1lIG9mIHRoZSB6aXAgZmlsZSB0aGF0IGNvbnRhaW5zIHRoZSBidWlsZCBmaWxlcyBvciBzY3JpcHQgZmlsZXMuXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtZ2FtZWxpZnQtYnVpbGQtc3RvcmFnZWxvY2F0aW9uLmh0bWwjY2ZuLWdhbWVsaWZ0LWJ1aWxkLXN0b3JhZ2Uta2V5XG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBrZXk6IHN0cmluZztcbiAgICAgICAgLyoqXG4gICAgICAgICAqIFRoZSB2ZXJzaW9uIG9mIHRoZSBmaWxlLCBpZiBvYmplY3QgdmVyc2lvbmluZyBpcyB0dXJuZWQgb24gZm9yIHRoZSBidWNrZXQuIEFtYXpvbiBHYW1lTGlmdCB1c2VzIHRoaXMgaW5mb3JtYXRpb24gd2hlbiByZXRyaWV2aW5nIGZpbGVzIGZyb20geW91ciBTMyBidWNrZXQuIFRvIHJldHJpZXZlIGEgc3BlY2lmaWMgdmVyc2lvbiBvZiB0aGUgZmlsZSwgcHJvdmlkZSBhbiBvYmplY3QgdmVyc2lvbi4gVG8gcmV0cmlldmUgdGhlIGxhdGVzdCB2ZXJzaW9uIG9mIHRoZSBmaWxlLCBkbyBub3Qgc2V0IHRoaXMgcGFyYW1ldGVyLlxuICAgICAgICAgKlxuICAgICAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWdhbWVsaWZ0LWJ1aWxkLXN0b3JhZ2Vsb2NhdGlvbi5odG1sI2Nmbi1nYW1lbGlmdC1idWlsZC1vYmplY3QtdmVyaXNvblxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgb2JqZWN0VmVyc2lvbj86IHN0cmluZztcbiAgICAgICAgLyoqXG4gICAgICAgICAqIFRoZSBBbWF6b24gUmVzb3VyY2UgTmFtZSAoIFtBUk5dKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BbWF6b25TMy9sYXRlc3QvZGV2L3MzLWFybi1mb3JtYXQuaHRtbCkgKSBmb3IgYW4gSUFNIHJvbGUgdGhhdCBhbGxvd3MgQW1hem9uIEdhbWVMaWZ0IHRvIGFjY2VzcyB0aGUgUzMgYnVja2V0LlxuICAgICAgICAgKlxuICAgICAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWdhbWVsaWZ0LWJ1aWxkLXN0b3JhZ2Vsb2NhdGlvbi5odG1sI2Nmbi1nYW1lbGlmdC1idWlsZC1zdG9yYWdlLXJvbGVhcm5cbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IHJvbGVBcm46IHN0cmluZztcbiAgICB9XG59XG5cbi8qKlxuICogRGV0ZXJtaW5lIHdoZXRoZXIgdGhlIGdpdmVuIHByb3BlcnRpZXMgbWF0Y2ggdGhvc2Ugb2YgYSBgUzNMb2NhdGlvblByb3BlcnR5YFxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBTM0xvY2F0aW9uUHJvcGVydHlgXG4gKlxuICogQHJldHVybnMgdGhlIHJlc3VsdCBvZiB0aGUgdmFsaWRhdGlvbi5cbiAqL1xuZnVuY3Rpb24gQ2ZuQnVpbGRfUzNMb2NhdGlvblByb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXM6IGFueSk6IGNkay5WYWxpZGF0aW9uUmVzdWx0IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBjZGsuVkFMSURBVElPTl9TVUNDRVNTOyB9XG4gICAgY29uc3QgZXJyb3JzID0gbmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0cygpO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgZXJyb3JzLmNvbGxlY3QobmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0KCdFeHBlY3RlZCBhbiBvYmplY3QsIGJ1dCByZWNlaXZlZDogJyArIEpTT04uc3RyaW5naWZ5KHByb3BlcnRpZXMpKSk7XG4gICAgfVxuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignYnVja2V0JywgY2RrLnJlcXVpcmVkVmFsaWRhdG9yKShwcm9wZXJ0aWVzLmJ1Y2tldCkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignYnVja2V0JywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmJ1Y2tldCkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigna2V5JywgY2RrLnJlcXVpcmVkVmFsaWRhdG9yKShwcm9wZXJ0aWVzLmtleSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigna2V5JywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmtleSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignb2JqZWN0VmVyc2lvbicsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5vYmplY3RWZXJzaW9uKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdyb2xlQXJuJywgY2RrLnJlcXVpcmVkVmFsaWRhdG9yKShwcm9wZXJ0aWVzLnJvbGVBcm4pKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3JvbGVBcm4nLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMucm9sZUFybikpO1xuICAgIHJldHVybiBlcnJvcnMud3JhcCgnc3VwcGxpZWQgcHJvcGVydGllcyBub3QgY29ycmVjdCBmb3IgXCJTM0xvY2F0aW9uUHJvcGVydHlcIicpO1xufVxuXG4vKipcbiAqIFJlbmRlcnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OkdhbWVMaWZ0OjpCdWlsZC5TM0xvY2F0aW9uYCByZXNvdXJjZVxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBTM0xvY2F0aW9uUHJvcGVydHlgXG4gKlxuICogQHJldHVybnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OkdhbWVMaWZ0OjpCdWlsZC5TM0xvY2F0aW9uYCByZXNvdXJjZS5cbiAqL1xuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIGNmbkJ1aWxkUzNMb2NhdGlvblByb3BlcnR5VG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBhbnkge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIHByb3BlcnRpZXM7IH1cbiAgICBDZm5CdWlsZF9TM0xvY2F0aW9uUHJvcGVydHlWYWxpZGF0b3IocHJvcGVydGllcykuYXNzZXJ0U3VjY2VzcygpO1xuICAgIHJldHVybiB7XG4gICAgICAgIEJ1Y2tldDogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5idWNrZXQpLFxuICAgICAgICBLZXk6IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMua2V5KSxcbiAgICAgICAgT2JqZWN0VmVyc2lvbjogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5vYmplY3RWZXJzaW9uKSxcbiAgICAgICAgUm9sZUFybjogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5yb2xlQXJuKSxcbiAgICB9O1xufVxuXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gQ2ZuQnVpbGRTM0xvY2F0aW9uUHJvcGVydHlGcm9tQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdDxDZm5CdWlsZC5TM0xvY2F0aW9uUHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGU+IHtcbiAgICBpZiAoY2RrLmlzUmVzb2x2YWJsZU9iamVjdChwcm9wZXJ0aWVzKSkge1xuICAgICAgICByZXR1cm4gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQocHJvcGVydGllcyk7XG4gICAgfVxuICAgIHByb3BlcnRpZXMgPSBwcm9wZXJ0aWVzID09IG51bGwgPyB7fSA6IHByb3BlcnRpZXM7XG4gICAgaWYgKHR5cGVvZiBwcm9wZXJ0aWVzICE9PSAnb2JqZWN0Jykge1xuICAgICAgICByZXR1cm4gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQocHJvcGVydGllcyk7XG4gICAgfVxuICAgIGNvbnN0IHJldCA9IG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUHJvcGVydHlPYmplY3Q8Q2ZuQnVpbGQuUzNMb2NhdGlvblByb3BlcnR5PigpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnYnVja2V0JywgJ0J1Y2tldCcsIGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuQnVja2V0KSk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdrZXknLCAnS2V5JywgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5LZXkpKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ29iamVjdFZlcnNpb24nLCAnT2JqZWN0VmVyc2lvbicsIHByb3BlcnRpZXMuT2JqZWN0VmVyc2lvbiAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5PYmplY3RWZXJzaW9uKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdyb2xlQXJuJywgJ1JvbGVBcm4nLCBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLlJvbGVBcm4pKTtcbiAgICByZXQuYWRkVW5yZWNvZ25pemVkUHJvcGVydGllc0FzRXh0cmEocHJvcGVydGllcyk7XG4gICAgcmV0dXJuIHJldDtcbn1cblxuLyoqXG4gKiBQcm9wZXJ0aWVzIGZvciBkZWZpbmluZyBhIGBDZm5GbGVldGBcbiAqXG4gKiBAc3RydWN0XG4gKiBAc3RhYmlsaXR5IGV4dGVybmFsXG4gKlxuICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZ2FtZWxpZnQtZmxlZXQuaHRtbFxuICovXG5leHBvcnQgaW50ZXJmYWNlIENmbkZsZWV0UHJvcHMge1xuXG4gICAgLyoqXG4gICAgICogQSB1bmlxdWUgaWRlbnRpZmllciBmb3IgYSBidWlsZCB0byBiZSBkZXBsb3llZCBvbiB0aGUgbmV3IGZsZWV0LiBJZiB5b3UgYXJlIGRlcGxveWluZyB0aGUgZmxlZXQgd2l0aCBhIGN1c3RvbSBnYW1lIGJ1aWxkLCB5b3UgbXVzdCBzcGVjaWZ5IHRoaXMgcHJvcGVydHkuIFRoZSBidWlsZCBtdXN0IGhhdmUgYmVlbiBzdWNjZXNzZnVsbHkgdXBsb2FkZWQgdG8gQW1hem9uIEdhbWVMaWZ0IGFuZCBiZSBpbiBhIGBSRUFEWWAgc3RhdHVzLiBUaGlzIGZsZWV0IHNldHRpbmcgY2Fubm90IGJlIGNoYW5nZWQgb25jZSB0aGUgZmxlZXQgaXMgY3JlYXRlZC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWdhbWVsaWZ0LWZsZWV0Lmh0bWwjY2ZuLWdhbWVsaWZ0LWZsZWV0LWJ1aWxkaWRcbiAgICAgKi9cbiAgICByZWFkb25seSBidWlsZElkPzogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogUHJvbXB0cyBHYW1lTGlmdCB0byBnZW5lcmF0ZSBhIFRMUy9TU0wgY2VydGlmaWNhdGUgZm9yIHRoZSBmbGVldC4gVExTIGNlcnRpZmljYXRlcyBhcmUgdXNlZCBmb3IgZW5jcnlwdGluZyB0cmFmZmljIGJldHdlZW4gZ2FtZSBjbGllbnRzIGFuZCB0aGUgZ2FtZSBzZXJ2ZXJzIHRoYXQgYXJlIHJ1bm5pbmcgb24gR2FtZUxpZnQuIEJ5IGRlZmF1bHQsIHRoZSBgQ2VydGlmaWNhdGVDb25maWd1cmF0aW9uYCBpcyBzZXQgdG8gYERJU0FCTEVEYCAuIFRoaXMgcHJvcGVydHkgY2Fubm90IGJlIGNoYW5nZWQgYWZ0ZXIgdGhlIGZsZWV0IGlzIGNyZWF0ZWQuXG4gICAgICpcbiAgICAgKiBOb3RlOiBUaGlzIGZlYXR1cmUgcmVxdWlyZXMgdGhlIEFXUyBDZXJ0aWZpY2F0ZSBNYW5hZ2VyIChBQ00pIHNlcnZpY2UsIHdoaWNoIGlzIG5vdCBhdmFpbGFibGUgaW4gYWxsIEFXUyByZWdpb25zLiBXaGVuIHdvcmtpbmcgaW4gYSByZWdpb24gdGhhdCBkb2VzIG5vdCBzdXBwb3J0IHRoaXMgZmVhdHVyZSwgYSBmbGVldCBjcmVhdGlvbiByZXF1ZXN0IHdpdGggY2VydGlmaWNhdGUgZ2VuZXJhdGlvbiBmYWlscyB3aXRoIGEgNHh4IGVycm9yLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZ2FtZWxpZnQtZmxlZXQuaHRtbCNjZm4tZ2FtZWxpZnQtZmxlZXQtY2VydGlmaWNhdGVjb25maWd1cmF0aW9uXG4gICAgICovXG4gICAgcmVhZG9ubHkgY2VydGlmaWNhdGVDb25maWd1cmF0aW9uPzogQ2ZuRmxlZXQuQ2VydGlmaWNhdGVDb25maWd1cmF0aW9uUHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBBIGh1bWFuLXJlYWRhYmxlIGRlc2NyaXB0aW9uIG9mIHRoZSBmbGVldC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWdhbWVsaWZ0LWZsZWV0Lmh0bWwjY2ZuLWdhbWVsaWZ0LWZsZWV0LWRlc2NyaXB0aW9uXG4gICAgICovXG4gICAgcmVhZG9ubHkgZGVzY3JpcHRpb24/OiBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgbnVtYmVyIG9mIEVDMiBpbnN0YW5jZXMgdGhhdCB5b3Ugd2FudCB0aGlzIGZsZWV0IHRvIGhvc3QuIFdoZW4gY3JlYXRpbmcgYSBuZXcgZmxlZXQsIEdhbWVMaWZ0IGF1dG9tYXRpY2FsbHkgc2V0cyB0aGlzIHZhbHVlIHRvIFwiMVwiIGFuZCBpbml0aWF0ZXMgYSBzaW5nbGUgaW5zdGFuY2UuIE9uY2UgdGhlIGZsZWV0IGlzIGFjdGl2ZSwgdXBkYXRlIHRoaXMgdmFsdWUgdG8gdHJpZ2dlciBHYW1lTGlmdCB0byBhZGQgb3IgcmVtb3ZlIGluc3RhbmNlcyBmcm9tIHRoZSBmbGVldC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWdhbWVsaWZ0LWZsZWV0Lmh0bWwjY2ZuLWdhbWVsaWZ0LWZsZWV0LWRlc2lyZWRlYzJpbnN0YW5jZXNcbiAgICAgKi9cbiAgICByZWFkb25seSBkZXNpcmVkRWMySW5zdGFuY2VzPzogbnVtYmVyO1xuXG4gICAgLyoqXG4gICAgICogVGhlIGFsbG93ZWQgSVAgYWRkcmVzcyByYW5nZXMgYW5kIHBvcnQgc2V0dGluZ3MgdGhhdCBhbGxvdyBpbmJvdW5kIHRyYWZmaWMgdG8gYWNjZXNzIGdhbWUgc2Vzc2lvbnMgb24gdGhpcyBmbGVldC4gSWYgdGhlIGZsZWV0IGlzIGhvc3RpbmcgYSBjdXN0b20gZ2FtZSBidWlsZCwgdGhpcyBwcm9wZXJ0eSBtdXN0IGJlIHNldCBiZWZvcmUgcGxheWVycyBjYW4gY29ubmVjdCB0byBnYW1lIHNlc3Npb25zLiBGb3IgUmVhbHRpbWUgU2VydmVycyBmbGVldHMsIEdhbWVMaWZ0IGF1dG9tYXRpY2FsbHkgc2V0cyBUQ1AgYW5kIFVEUCByYW5nZXMuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1nYW1lbGlmdC1mbGVldC5odG1sI2Nmbi1nYW1lbGlmdC1mbGVldC1lYzJpbmJvdW5kcGVybWlzc2lvbnNcbiAgICAgKi9cbiAgICByZWFkb25seSBlYzJJbmJvdW5kUGVybWlzc2lvbnM/OiBBcnJheTxDZm5GbGVldC5JcFBlcm1pc3Npb25Qcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZT4gfCBjZGsuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgR2FtZUxpZnQtc3VwcG9ydGVkIEFtYXpvbiBFQzIgaW5zdGFuY2UgdHlwZSB0byB1c2UgZm9yIGFsbCBmbGVldCBpbnN0YW5jZXMuIEluc3RhbmNlIHR5cGUgZGV0ZXJtaW5lcyB0aGUgY29tcHV0aW5nIHJlc291cmNlcyB0aGF0IHdpbGwgYmUgdXNlZCB0byBob3N0IHlvdXIgZ2FtZSBzZXJ2ZXJzLCBpbmNsdWRpbmcgQ1BVLCBtZW1vcnksIHN0b3JhZ2UsIGFuZCBuZXR3b3JraW5nIGNhcGFjaXR5LiBTZWUgW0FtYXpvbiBFbGFzdGljIENvbXB1dGUgQ2xvdWQgSW5zdGFuY2UgVHlwZXNdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9lYzIvaW5zdGFuY2UtdHlwZXMvKSBmb3IgZGV0YWlsZWQgZGVzY3JpcHRpb25zIG9mIEFtYXpvbiBFQzIgaW5zdGFuY2UgdHlwZXMuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1nYW1lbGlmdC1mbGVldC5odG1sI2Nmbi1nYW1lbGlmdC1mbGVldC1lYzJpbnN0YW5jZXR5cGVcbiAgICAgKi9cbiAgICByZWFkb25seSBlYzJJbnN0YW5jZVR5cGU/OiBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBJbmRpY2F0ZXMgd2hldGhlciB0byB1c2UgT24tRGVtYW5kIG9yIFNwb3QgaW5zdGFuY2VzIGZvciB0aGlzIGZsZWV0LiBCeSBkZWZhdWx0LCB0aGlzIHByb3BlcnR5IGlzIHNldCB0byBgT05fREVNQU5EYCAuIExlYXJuIG1vcmUgYWJvdXQgd2hlbiB0byB1c2UgW09uLURlbWFuZCB2ZXJzdXMgU3BvdCBJbnN0YW5jZXNdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9nYW1lbGlmdC9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUvZ2FtZWxpZnQtZWMyLWluc3RhbmNlcy5odG1sI2dhbWVsaWZ0LWVjMi1pbnN0YW5jZXMtc3BvdCkgLiBUaGlzIHByb3BlcnR5IGNhbm5vdCBiZSBjaGFuZ2VkIGFmdGVyIHRoZSBmbGVldCBpcyBjcmVhdGVkLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZ2FtZWxpZnQtZmxlZXQuaHRtbCNjZm4tZ2FtZWxpZnQtZmxlZXQtZmxlZXR0eXBlXG4gICAgICovXG4gICAgcmVhZG9ubHkgZmxlZXRUeXBlPzogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogQSB1bmlxdWUgaWRlbnRpZmllciBmb3IgYW4gSUFNIHJvbGUgdGhhdCBtYW5hZ2VzIGFjY2VzcyB0byB5b3VyIEFXUyBzZXJ2aWNlcy4gV2l0aCBhbiBpbnN0YW5jZSByb2xlIEFSTiBzZXQsIGFueSBhcHBsaWNhdGlvbiB0aGF0IHJ1bnMgb24gYW4gaW5zdGFuY2UgaW4gdGhpcyBmbGVldCBjYW4gYXNzdW1lIHRoZSByb2xlLCBpbmNsdWRpbmcgaW5zdGFsbCBzY3JpcHRzLCBzZXJ2ZXIgcHJvY2Vzc2VzLCBhbmQgZGFlbW9ucyAoYmFja2dyb3VuZCBwcm9jZXNzZXMpLiBDcmVhdGUgYSByb2xlIG9yIGxvb2sgdXAgYSByb2xlJ3MgQVJOIGJ5IHVzaW5nIHRoZSBbSUFNIGRhc2hib2FyZF0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lhbS8pIGluIHRoZSBBV1MgTWFuYWdlbWVudCBDb25zb2xlIC4gTGVhcm4gbW9yZSBhYm91dCB1c2luZyBvbi1ib3ggY3JlZGVudGlhbHMgZm9yIHlvdXIgZ2FtZSBzZXJ2ZXJzIGF0IFtBY2Nlc3MgZXh0ZXJuYWwgcmVzb3VyY2VzIGZyb20gYSBnYW1lIHNlcnZlcl0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2dhbWVsaWZ0L2xhdGVzdC9kZXZlbG9wZXJndWlkZS9nYW1lbGlmdC1zZGstc2VydmVyLXJlc291cmNlcy5odG1sKSAuIFRoaXMgcHJvcGVydHkgY2Fubm90IGJlIGNoYW5nZWQgYWZ0ZXIgdGhlIGZsZWV0IGlzIGNyZWF0ZWQuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1nYW1lbGlmdC1mbGVldC5odG1sI2Nmbi1nYW1lbGlmdC1mbGVldC1pbnN0YW5jZXJvbGVhcm5cbiAgICAgKi9cbiAgICByZWFkb25seSBpbnN0YW5jZVJvbGVBcm4/OiBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBBIHNldCBvZiByZW1vdGUgbG9jYXRpb25zIHRvIGRlcGxveSBhZGRpdGlvbmFsIGluc3RhbmNlcyB0byBhbmQgbWFuYWdlIGFzIHBhcnQgb2YgdGhlIGZsZWV0LiBUaGlzIHBhcmFtZXRlciBjYW4gb25seSBiZSB1c2VkIHdoZW4gY3JlYXRpbmcgZmxlZXRzIGluIEFXUyBSZWdpb25zIHRoYXQgc3VwcG9ydCBtdWx0aXBsZSBsb2NhdGlvbnMuIFlvdSBjYW4gYWRkIGFueSBHYW1lTGlmdC1zdXBwb3J0ZWQgQVdTIFJlZ2lvbiBhcyBhIHJlbW90ZSBsb2NhdGlvbiwgaW4gdGhlIGZvcm0gb2YgYW4gQVdTIFJlZ2lvbiBjb2RlIHN1Y2ggYXMgYHVzLXdlc3QtMmAgLiBUbyBjcmVhdGUgYSBmbGVldCB3aXRoIGluc3RhbmNlcyBpbiB0aGUgaG9tZSBSZWdpb24gb25seSwgb21pdCB0aGlzIHBhcmFtZXRlci5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWdhbWVsaWZ0LWZsZWV0Lmh0bWwjY2ZuLWdhbWVsaWZ0LWZsZWV0LWxvY2F0aW9uc1xuICAgICAqL1xuICAgIHJlYWRvbmx5IGxvY2F0aW9ucz86IEFycmF5PENmbkZsZWV0LkxvY2F0aW9uQ29uZmlndXJhdGlvblByb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlPiB8IGNkay5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFRoZSBtYXhpbXVtIG51bWJlciBvZiBpbnN0YW5jZXMgdGhhdCBhcmUgYWxsb3dlZCBpbiB0aGUgc3BlY2lmaWVkIGZsZWV0IGxvY2F0aW9uLiBJZiB0aGlzIHBhcmFtZXRlciBpcyBub3Qgc2V0LCB0aGUgZGVmYXVsdCBpcyAxLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZ2FtZWxpZnQtZmxlZXQuaHRtbCNjZm4tZ2FtZWxpZnQtZmxlZXQtbWF4c2l6ZVxuICAgICAqL1xuICAgIHJlYWRvbmx5IG1heFNpemU/OiBudW1iZXI7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgbmFtZSBvZiBhbiBBV1MgQ2xvdWRXYXRjaCBtZXRyaWMgZ3JvdXAgdG8gYWRkIHRoaXMgZmxlZXQgdG8uIEEgbWV0cmljIGdyb3VwIGlzIHVzZWQgdG8gYWdncmVnYXRlIHRoZSBtZXRyaWNzIGZvciBtdWx0aXBsZSBmbGVldHMuIFlvdSBjYW4gc3BlY2lmeSBhbiBleGlzdGluZyBtZXRyaWMgZ3JvdXAgbmFtZSBvciBzZXQgYSBuZXcgbmFtZSB0byBjcmVhdGUgYSBuZXcgbWV0cmljIGdyb3VwLiBBIGZsZWV0IGNhbiBiZSBpbmNsdWRlZCBpbiBvbmx5IG9uZSBtZXRyaWMgZ3JvdXAgYXQgYSB0aW1lLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZ2FtZWxpZnQtZmxlZXQuaHRtbCNjZm4tZ2FtZWxpZnQtZmxlZXQtbWV0cmljZ3JvdXBzXG4gICAgICovXG4gICAgcmVhZG9ubHkgbWV0cmljR3JvdXBzPzogc3RyaW5nW107XG5cbiAgICAvKipcbiAgICAgKiBUaGUgbWluaW11bSBudW1iZXIgb2YgaW5zdGFuY2VzIHRoYXQgYXJlIGFsbG93ZWQgaW4gdGhlIHNwZWNpZmllZCBmbGVldCBsb2NhdGlvbi4gSWYgdGhpcyBwYXJhbWV0ZXIgaXMgbm90IHNldCwgdGhlIGRlZmF1bHQgaXMgMC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWdhbWVsaWZ0LWZsZWV0Lmh0bWwjY2ZuLWdhbWVsaWZ0LWZsZWV0LW1pbnNpemVcbiAgICAgKi9cbiAgICByZWFkb25seSBtaW5TaXplPzogbnVtYmVyO1xuXG4gICAgLyoqXG4gICAgICogQSBkZXNjcmlwdGl2ZSBsYWJlbCB0aGF0IGlzIGFzc29jaWF0ZWQgd2l0aCBhIGZsZWV0LiBGbGVldCBuYW1lcyBkbyBub3QgbmVlZCB0byBiZSB1bmlxdWUuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1nYW1lbGlmdC1mbGVldC5odG1sI2Nmbi1nYW1lbGlmdC1mbGVldC1uYW1lXG4gICAgICovXG4gICAgcmVhZG9ubHkgbmFtZT86IHN0cmluZztcblxuICAgIC8qKlxuICAgICAqIFRoZSBzdGF0dXMgb2YgdGVybWluYXRpb24gcHJvdGVjdGlvbiBmb3IgYWN0aXZlIGdhbWUgc2Vzc2lvbnMgb24gdGhlIGZsZWV0LiBCeSBkZWZhdWx0LCB0aGlzIHByb3BlcnR5IGlzIHNldCB0byBgTm9Qcm90ZWN0aW9uYCAuXG4gICAgICpcbiAgICAgKiAtICpOb1Byb3RlY3Rpb24qIC0gR2FtZSBzZXNzaW9ucyBjYW4gYmUgdGVybWluYXRlZCBkdXJpbmcgYWN0aXZlIGdhbWVwbGF5IGFzIGEgcmVzdWx0IG9mIGEgc2NhbGUtZG93biBldmVudC5cbiAgICAgKiAtICpGdWxsUHJvdGVjdGlvbiogLSBHYW1lIHNlc3Npb25zIGluIGBBQ1RJVkVgIHN0YXR1cyBjYW5ub3QgYmUgdGVybWluYXRlZCBkdXJpbmcgYSBzY2FsZS1kb3duIGV2ZW50LlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZ2FtZWxpZnQtZmxlZXQuaHRtbCNjZm4tZ2FtZWxpZnQtZmxlZXQtbmV3Z2FtZXNlc3Npb25wcm90ZWN0aW9ucG9saWN5XG4gICAgICovXG4gICAgcmVhZG9ubHkgbmV3R2FtZVNlc3Npb25Qcm90ZWN0aW9uUG9saWN5Pzogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogVXNlZCB3aGVuIHBlZXJpbmcgeW91ciBHYW1lTGlmdCBmbGVldCB3aXRoIGEgVlBDLCB0aGUgdW5pcXVlIGlkZW50aWZpZXIgZm9yIHRoZSBBV1MgYWNjb3VudCB0aGF0IG93bnMgdGhlIFZQQy4gWW91IGNhbiBmaW5kIHlvdXIgYWNjb3VudCBJRCBpbiB0aGUgQVdTIE1hbmFnZW1lbnQgQ29uc29sZSB1bmRlciBhY2NvdW50IHNldHRpbmdzLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZ2FtZWxpZnQtZmxlZXQuaHRtbCNjZm4tZ2FtZWxpZnQtZmxlZXQtcGVlcnZwY2F3c2FjY291bnRpZFxuICAgICAqL1xuICAgIHJlYWRvbmx5IHBlZXJWcGNBd3NBY2NvdW50SWQ/OiBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBBIHVuaXF1ZSBpZGVudGlmaWVyIGZvciBhIFZQQyB3aXRoIHJlc291cmNlcyB0byBiZSBhY2Nlc3NlZCBieSB5b3VyIEdhbWVMaWZ0IGZsZWV0LiBUaGUgVlBDIG11c3QgYmUgaW4gdGhlIHNhbWUgUmVnaW9uIGFzIHlvdXIgZmxlZXQuIFRvIGxvb2sgdXAgYSBWUEMgSUQsIHVzZSB0aGUgW1ZQQyBEYXNoYm9hcmRdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS92cGMvKSBpbiB0aGUgQVdTIE1hbmFnZW1lbnQgQ29uc29sZSAuIExlYXJuIG1vcmUgYWJvdXQgVlBDIHBlZXJpbmcgaW4gW1ZQQyBQZWVyaW5nIHdpdGggR2FtZUxpZnQgRmxlZXRzXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZ2FtZWxpZnQvbGF0ZXN0L2RldmVsb3Blcmd1aWRlL3ZwYy1wZWVyaW5nLmh0bWwpIC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWdhbWVsaWZ0LWZsZWV0Lmh0bWwjY2ZuLWdhbWVsaWZ0LWZsZWV0LXBlZXJ2cGNpZFxuICAgICAqL1xuICAgIHJlYWRvbmx5IHBlZXJWcGNJZD86IHN0cmluZztcblxuICAgIC8qKlxuICAgICAqIEEgcG9saWN5IHRoYXQgbGltaXRzIHRoZSBudW1iZXIgb2YgZ2FtZSBzZXNzaW9ucyB0aGF0IGFuIGluZGl2aWR1YWwgcGxheWVyIGNhbiBjcmVhdGUgb24gaW5zdGFuY2VzIGluIHRoaXMgZmxlZXQgd2l0aGluIGEgc3BlY2lmaWVkIHNwYW4gb2YgdGltZS5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWdhbWVsaWZ0LWZsZWV0Lmh0bWwjY2ZuLWdhbWVsaWZ0LWZsZWV0LXJlc291cmNlY3JlYXRpb25saW1pdHBvbGljeVxuICAgICAqL1xuICAgIHJlYWRvbmx5IHJlc291cmNlQ3JlYXRpb25MaW1pdFBvbGljeT86IENmbkZsZWV0LlJlc291cmNlQ3JlYXRpb25MaW1pdFBvbGljeVByb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogSW5zdHJ1Y3Rpb25zIGZvciBob3cgdG8gbGF1bmNoIGFuZCBtYWludGFpbiBzZXJ2ZXIgcHJvY2Vzc2VzIG9uIGluc3RhbmNlcyBpbiB0aGUgZmxlZXQuIFRoZSBydW50aW1lIGNvbmZpZ3VyYXRpb24gZGVmaW5lcyBvbmUgb3IgbW9yZSBzZXJ2ZXIgcHJvY2VzcyBjb25maWd1cmF0aW9ucywgZWFjaCBpZGVudGlmeWluZyBhIGJ1aWxkIGV4ZWN1dGFibGUgb3IgUmVhbHRpbWUgc2NyaXB0IGZpbGUgYW5kIHRoZSBudW1iZXIgb2YgcHJvY2Vzc2VzIG9mIHRoYXQgdHlwZSB0byBydW4gY29uY3VycmVudGx5LlxuICAgICAqXG4gICAgICogPiBUaGUgYFJ1bnRpbWVDb25maWd1cmF0aW9uYCBwYXJhbWV0ZXIgaXMgcmVxdWlyZWQgdW5sZXNzIHRoZSBmbGVldCBpcyBiZWluZyBjb25maWd1cmVkIHVzaW5nIHRoZSBvbGRlciBwYXJhbWV0ZXJzIGBTZXJ2ZXJMYXVuY2hQYXRoYCBhbmQgYFNlcnZlckxhdW5jaFBhcmFtZXRlcnNgICwgd2hpY2ggYXJlIHN0aWxsIHN1cHBvcnRlZCBmb3IgYmFja3dhcmQgY29tcGF0aWJpbGl0eS5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWdhbWVsaWZ0LWZsZWV0Lmh0bWwjY2ZuLWdhbWVsaWZ0LWZsZWV0LXJ1bnRpbWVjb25maWd1cmF0aW9uXG4gICAgICovXG4gICAgcmVhZG9ubHkgcnVudGltZUNvbmZpZ3VyYXRpb24/OiBDZm5GbGVldC5SdW50aW1lQ29uZmlndXJhdGlvblByb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogVGhlIHVuaXF1ZSBpZGVudGlmaWVyIGZvciBhIFJlYWx0aW1lIGNvbmZpZ3VyYXRpb24gc2NyaXB0IHRvIGJlIGRlcGxveWVkIG9uIGZsZWV0IGluc3RhbmNlcy4gWW91IGNhbiB1c2UgZWl0aGVyIHRoZSBzY3JpcHQgSUQgb3IgQVJOLiBTY3JpcHRzIG11c3QgYmUgdXBsb2FkZWQgdG8gR2FtZUxpZnQgcHJpb3IgdG8gY3JlYXRpbmcgdGhlIGZsZWV0LiBUaGlzIGZsZWV0IHByb3BlcnR5IGNhbm5vdCBiZSBjaGFuZ2VkIGxhdGVyLlxuICAgICAqXG4gICAgICogPiBZb3UgY2FuJ3QgdXNlIHRoZSBgIVJlZmAgY29tbWFuZCB0byByZWZlcmVuY2UgYSBzY3JpcHQgY3JlYXRlZCB3aXRoIGEgQ2xvdWRGb3JtYXRpb24gdGVtcGxhdGUgZm9yIHRoZSBmbGVldCBwcm9wZXJ0eSBgU2NyaXB0SWRgIC4gSW5zdGVhZCwgdXNlIGBGbjo6R2V0QXR0IFNjcmlwdC5Bcm5gIG9yIGBGbjo6R2V0QXR0IFNjcmlwdC5JZGAgdG8gcmV0cmlldmUgZWl0aGVyIG9mIHRoZXNlIHByb3BlcnRpZXMgYXMgaW5wdXQgZm9yIGBTY3JpcHRJZGAgLiBBbHRlcm5hdGl2ZWx5LCBlbnRlciBhIGBTY3JpcHRJZGAgc3RyaW5nIG1hbnVhbGx5LlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZ2FtZWxpZnQtZmxlZXQuaHRtbCNjZm4tZ2FtZWxpZnQtZmxlZXQtc2NyaXB0aWRcbiAgICAgKi9cbiAgICByZWFkb25seSBzY3JpcHRJZD86IHN0cmluZztcbn1cblxuLyoqXG4gKiBEZXRlcm1pbmUgd2hldGhlciB0aGUgZ2l2ZW4gcHJvcGVydGllcyBtYXRjaCB0aG9zZSBvZiBhIGBDZm5GbGVldFByb3BzYFxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBDZm5GbGVldFByb3BzYFxuICpcbiAqIEByZXR1cm5zIHRoZSByZXN1bHQgb2YgdGhlIHZhbGlkYXRpb24uXG4gKi9cbmZ1bmN0aW9uIENmbkZsZWV0UHJvcHNWYWxpZGF0b3IocHJvcGVydGllczogYW55KTogY2RrLlZhbGlkYXRpb25SZXN1bHQge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIGNkay5WQUxJREFUSU9OX1NVQ0NFU1M7IH1cbiAgICBjb25zdCBlcnJvcnMgPSBuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHRzKCk7XG4gICAgaWYgKHR5cGVvZiBwcm9wZXJ0aWVzICE9PSAnb2JqZWN0Jykge1xuICAgICAgICBlcnJvcnMuY29sbGVjdChuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHQoJ0V4cGVjdGVkIGFuIG9iamVjdCwgYnV0IHJlY2VpdmVkOiAnICsgSlNPTi5zdHJpbmdpZnkocHJvcGVydGllcykpKTtcbiAgICB9XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdidWlsZElkJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmJ1aWxkSWQpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2NlcnRpZmljYXRlQ29uZmlndXJhdGlvbicsIENmbkZsZWV0X0NlcnRpZmljYXRlQ29uZmlndXJhdGlvblByb3BlcnR5VmFsaWRhdG9yKShwcm9wZXJ0aWVzLmNlcnRpZmljYXRlQ29uZmlndXJhdGlvbikpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignZGVzY3JpcHRpb24nLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuZGVzY3JpcHRpb24pKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2Rlc2lyZWRFYzJJbnN0YW5jZXMnLCBjZGsudmFsaWRhdGVOdW1iZXIpKHByb3BlcnRpZXMuZGVzaXJlZEVjMkluc3RhbmNlcykpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignZWMySW5ib3VuZFBlcm1pc3Npb25zJywgY2RrLmxpc3RWYWxpZGF0b3IoQ2ZuRmxlZXRfSXBQZXJtaXNzaW9uUHJvcGVydHlWYWxpZGF0b3IpKShwcm9wZXJ0aWVzLmVjMkluYm91bmRQZXJtaXNzaW9ucykpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignZWMySW5zdGFuY2VUeXBlJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmVjMkluc3RhbmNlVHlwZSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignZmxlZXRUeXBlJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmZsZWV0VHlwZSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignaW5zdGFuY2VSb2xlQXJuJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmluc3RhbmNlUm9sZUFybikpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignbG9jYXRpb25zJywgY2RrLmxpc3RWYWxpZGF0b3IoQ2ZuRmxlZXRfTG9jYXRpb25Db25maWd1cmF0aW9uUHJvcGVydHlWYWxpZGF0b3IpKShwcm9wZXJ0aWVzLmxvY2F0aW9ucykpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignbWF4U2l6ZScsIGNkay52YWxpZGF0ZU51bWJlcikocHJvcGVydGllcy5tYXhTaXplKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdtZXRyaWNHcm91cHMnLCBjZGsubGlzdFZhbGlkYXRvcihjZGsudmFsaWRhdGVTdHJpbmcpKShwcm9wZXJ0aWVzLm1ldHJpY0dyb3VwcykpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignbWluU2l6ZScsIGNkay52YWxpZGF0ZU51bWJlcikocHJvcGVydGllcy5taW5TaXplKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCduYW1lJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLm5hbWUpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ25ld0dhbWVTZXNzaW9uUHJvdGVjdGlvblBvbGljeScsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5uZXdHYW1lU2Vzc2lvblByb3RlY3Rpb25Qb2xpY3kpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3BlZXJWcGNBd3NBY2NvdW50SWQnLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMucGVlclZwY0F3c0FjY291bnRJZCkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigncGVlclZwY0lkJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLnBlZXJWcGNJZCkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigncmVzb3VyY2VDcmVhdGlvbkxpbWl0UG9saWN5JywgQ2ZuRmxlZXRfUmVzb3VyY2VDcmVhdGlvbkxpbWl0UG9saWN5UHJvcGVydHlWYWxpZGF0b3IpKHByb3BlcnRpZXMucmVzb3VyY2VDcmVhdGlvbkxpbWl0UG9saWN5KSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdydW50aW1lQ29uZmlndXJhdGlvbicsIENmbkZsZWV0X1J1bnRpbWVDb25maWd1cmF0aW9uUHJvcGVydHlWYWxpZGF0b3IpKHByb3BlcnRpZXMucnVudGltZUNvbmZpZ3VyYXRpb24pKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3NjcmlwdElkJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLnNjcmlwdElkKSk7XG4gICAgcmV0dXJuIGVycm9ycy53cmFwKCdzdXBwbGllZCBwcm9wZXJ0aWVzIG5vdCBjb3JyZWN0IGZvciBcIkNmbkZsZWV0UHJvcHNcIicpO1xufVxuXG4vKipcbiAqIFJlbmRlcnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OkdhbWVMaWZ0OjpGbGVldGAgcmVzb3VyY2VcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgQ2ZuRmxlZXRQcm9wc2BcbiAqXG4gKiBAcmV0dXJucyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6R2FtZUxpZnQ6OkZsZWV0YCByZXNvdXJjZS5cbiAqL1xuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIGNmbkZsZWV0UHJvcHNUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGFueSB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gcHJvcGVydGllczsgfVxuICAgIENmbkZsZWV0UHJvcHNWYWxpZGF0b3IocHJvcGVydGllcykuYXNzZXJ0U3VjY2VzcygpO1xuICAgIHJldHVybiB7XG4gICAgICAgIEJ1aWxkSWQ6IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuYnVpbGRJZCksXG4gICAgICAgIENlcnRpZmljYXRlQ29uZmlndXJhdGlvbjogY2ZuRmxlZXRDZXJ0aWZpY2F0ZUNvbmZpZ3VyYXRpb25Qcm9wZXJ0eVRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5jZXJ0aWZpY2F0ZUNvbmZpZ3VyYXRpb24pLFxuICAgICAgICBEZXNjcmlwdGlvbjogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5kZXNjcmlwdGlvbiksXG4gICAgICAgIERlc2lyZWRFQzJJbnN0YW5jZXM6IGNkay5udW1iZXJUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuZGVzaXJlZEVjMkluc3RhbmNlcyksXG4gICAgICAgIEVDMkluYm91bmRQZXJtaXNzaW9uczogY2RrLmxpc3RNYXBwZXIoY2ZuRmxlZXRJcFBlcm1pc3Npb25Qcm9wZXJ0eVRvQ2xvdWRGb3JtYXRpb24pKHByb3BlcnRpZXMuZWMySW5ib3VuZFBlcm1pc3Npb25zKSxcbiAgICAgICAgRUMySW5zdGFuY2VUeXBlOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLmVjMkluc3RhbmNlVHlwZSksXG4gICAgICAgIEZsZWV0VHlwZTogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5mbGVldFR5cGUpLFxuICAgICAgICBJbnN0YW5jZVJvbGVBUk46IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuaW5zdGFuY2VSb2xlQXJuKSxcbiAgICAgICAgTG9jYXRpb25zOiBjZGsubGlzdE1hcHBlcihjZm5GbGVldExvY2F0aW9uQ29uZmlndXJhdGlvblByb3BlcnR5VG9DbG91ZEZvcm1hdGlvbikocHJvcGVydGllcy5sb2NhdGlvbnMpLFxuICAgICAgICBNYXhTaXplOiBjZGsubnVtYmVyVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLm1heFNpemUpLFxuICAgICAgICBNZXRyaWNHcm91cHM6IGNkay5saXN0TWFwcGVyKGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKShwcm9wZXJ0aWVzLm1ldHJpY0dyb3VwcyksXG4gICAgICAgIE1pblNpemU6IGNkay5udW1iZXJUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMubWluU2l6ZSksXG4gICAgICAgIE5hbWU6IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMubmFtZSksXG4gICAgICAgIE5ld0dhbWVTZXNzaW9uUHJvdGVjdGlvblBvbGljeTogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5uZXdHYW1lU2Vzc2lvblByb3RlY3Rpb25Qb2xpY3kpLFxuICAgICAgICBQZWVyVnBjQXdzQWNjb3VudElkOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLnBlZXJWcGNBd3NBY2NvdW50SWQpLFxuICAgICAgICBQZWVyVnBjSWQ6IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMucGVlclZwY0lkKSxcbiAgICAgICAgUmVzb3VyY2VDcmVhdGlvbkxpbWl0UG9saWN5OiBjZm5GbGVldFJlc291cmNlQ3JlYXRpb25MaW1pdFBvbGljeVByb3BlcnR5VG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLnJlc291cmNlQ3JlYXRpb25MaW1pdFBvbGljeSksXG4gICAgICAgIFJ1bnRpbWVDb25maWd1cmF0aW9uOiBjZm5GbGVldFJ1bnRpbWVDb25maWd1cmF0aW9uUHJvcGVydHlUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMucnVudGltZUNvbmZpZ3VyYXRpb24pLFxuICAgICAgICBTY3JpcHRJZDogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5zY3JpcHRJZCksXG4gICAgfTtcbn1cblxuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIENmbkZsZWV0UHJvcHNGcm9tQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdDxDZm5GbGVldFByb3BzPiB7XG4gICAgcHJvcGVydGllcyA9IHByb3BlcnRpZXMgPT0gbnVsbCA/IHt9IDogcHJvcGVydGllcztcbiAgICBpZiAodHlwZW9mIHByb3BlcnRpZXMgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIHJldHVybiBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdChwcm9wZXJ0aWVzKTtcbiAgICB9XG4gICAgY29uc3QgcmV0ID0gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25Qcm9wZXJ0eU9iamVjdDxDZm5GbGVldFByb3BzPigpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnYnVpbGRJZCcsICdCdWlsZElkJywgcHJvcGVydGllcy5CdWlsZElkICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLkJ1aWxkSWQpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2NlcnRpZmljYXRlQ29uZmlndXJhdGlvbicsICdDZXJ0aWZpY2F0ZUNvbmZpZ3VyYXRpb24nLCBwcm9wZXJ0aWVzLkNlcnRpZmljYXRlQ29uZmlndXJhdGlvbiAhPSBudWxsID8gQ2ZuRmxlZXRDZXJ0aWZpY2F0ZUNvbmZpZ3VyYXRpb25Qcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLkNlcnRpZmljYXRlQ29uZmlndXJhdGlvbikgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnZGVzY3JpcHRpb24nLCAnRGVzY3JpcHRpb24nLCBwcm9wZXJ0aWVzLkRlc2NyaXB0aW9uICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLkRlc2NyaXB0aW9uKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdkZXNpcmVkRWMySW5zdGFuY2VzJywgJ0Rlc2lyZWRFQzJJbnN0YW5jZXMnLCBwcm9wZXJ0aWVzLkRlc2lyZWRFQzJJbnN0YW5jZXMgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0TnVtYmVyKHByb3BlcnRpZXMuRGVzaXJlZEVDMkluc3RhbmNlcykgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnZWMySW5ib3VuZFBlcm1pc3Npb25zJywgJ0VDMkluYm91bmRQZXJtaXNzaW9ucycsIHByb3BlcnRpZXMuRUMySW5ib3VuZFBlcm1pc3Npb25zICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldEFycmF5KENmbkZsZWV0SXBQZXJtaXNzaW9uUHJvcGVydHlGcm9tQ2xvdWRGb3JtYXRpb24pKHByb3BlcnRpZXMuRUMySW5ib3VuZFBlcm1pc3Npb25zKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdlYzJJbnN0YW5jZVR5cGUnLCAnRUMySW5zdGFuY2VUeXBlJywgcHJvcGVydGllcy5FQzJJbnN0YW5jZVR5cGUgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuRUMySW5zdGFuY2VUeXBlKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdmbGVldFR5cGUnLCAnRmxlZXRUeXBlJywgcHJvcGVydGllcy5GbGVldFR5cGUgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuRmxlZXRUeXBlKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdpbnN0YW5jZVJvbGVBcm4nLCAnSW5zdGFuY2VSb2xlQVJOJywgcHJvcGVydGllcy5JbnN0YW5jZVJvbGVBUk4gIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuSW5zdGFuY2VSb2xlQVJOKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdsb2NhdGlvbnMnLCAnTG9jYXRpb25zJywgcHJvcGVydGllcy5Mb2NhdGlvbnMgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0QXJyYXkoQ2ZuRmxlZXRMb2NhdGlvbkNvbmZpZ3VyYXRpb25Qcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbikocHJvcGVydGllcy5Mb2NhdGlvbnMpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ21heFNpemUnLCAnTWF4U2l6ZScsIHByb3BlcnRpZXMuTWF4U2l6ZSAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXROdW1iZXIocHJvcGVydGllcy5NYXhTaXplKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdtZXRyaWNHcm91cHMnLCAnTWV0cmljR3JvdXBzJywgcHJvcGVydGllcy5NZXRyaWNHcm91cHMgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nQXJyYXkocHJvcGVydGllcy5NZXRyaWNHcm91cHMpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ21pblNpemUnLCAnTWluU2l6ZScsIHByb3BlcnRpZXMuTWluU2l6ZSAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXROdW1iZXIocHJvcGVydGllcy5NaW5TaXplKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCduYW1lJywgJ05hbWUnLCBwcm9wZXJ0aWVzLk5hbWUgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuTmFtZSkgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnbmV3R2FtZVNlc3Npb25Qcm90ZWN0aW9uUG9saWN5JywgJ05ld0dhbWVTZXNzaW9uUHJvdGVjdGlvblBvbGljeScsIHByb3BlcnRpZXMuTmV3R2FtZVNlc3Npb25Qcm90ZWN0aW9uUG9saWN5ICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLk5ld0dhbWVTZXNzaW9uUHJvdGVjdGlvblBvbGljeSkgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgncGVlclZwY0F3c0FjY291bnRJZCcsICdQZWVyVnBjQXdzQWNjb3VudElkJywgcHJvcGVydGllcy5QZWVyVnBjQXdzQWNjb3VudElkICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLlBlZXJWcGNBd3NBY2NvdW50SWQpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ3BlZXJWcGNJZCcsICdQZWVyVnBjSWQnLCBwcm9wZXJ0aWVzLlBlZXJWcGNJZCAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5QZWVyVnBjSWQpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ3Jlc291cmNlQ3JlYXRpb25MaW1pdFBvbGljeScsICdSZXNvdXJjZUNyZWF0aW9uTGltaXRQb2xpY3knLCBwcm9wZXJ0aWVzLlJlc291cmNlQ3JlYXRpb25MaW1pdFBvbGljeSAhPSBudWxsID8gQ2ZuRmxlZXRSZXNvdXJjZUNyZWF0aW9uTGltaXRQb2xpY3lQcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLlJlc291cmNlQ3JlYXRpb25MaW1pdFBvbGljeSkgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgncnVudGltZUNvbmZpZ3VyYXRpb24nLCAnUnVudGltZUNvbmZpZ3VyYXRpb24nLCBwcm9wZXJ0aWVzLlJ1bnRpbWVDb25maWd1cmF0aW9uICE9IG51bGwgPyBDZm5GbGVldFJ1bnRpbWVDb25maWd1cmF0aW9uUHJvcGVydHlGcm9tQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5SdW50aW1lQ29uZmlndXJhdGlvbikgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnc2NyaXB0SWQnLCAnU2NyaXB0SWQnLCBwcm9wZXJ0aWVzLlNjcmlwdElkICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLlNjcmlwdElkKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFVucmVjb2duaXplZFByb3BlcnRpZXNBc0V4dHJhKHByb3BlcnRpZXMpO1xuICAgIHJldHVybiByZXQ7XG59XG5cbi8qKlxuICogQSBDbG91ZEZvcm1hdGlvbiBgQVdTOjpHYW1lTGlmdDo6RmxlZXRgXG4gKlxuICogVGhlIGBBV1M6OkdhbWVMaWZ0OjpGbGVldGAgcmVzb3VyY2UgY3JlYXRlcyBhbiBBbWF6b24gR2FtZUxpZnQgKEdhbWVMaWZ0KSBmbGVldCB0byBob3N0IGdhbWUgc2VydmVycy4gQSBmbGVldCBpcyBhIHNldCBvZiBFQzIgaW5zdGFuY2VzLCBlYWNoIG9mIHdoaWNoIGNhbiBob3N0IG11bHRpcGxlIGdhbWUgc2Vzc2lvbnMuXG4gKlxuICogQGNsb3VkZm9ybWF0aW9uUmVzb3VyY2UgQVdTOjpHYW1lTGlmdDo6RmxlZXRcbiAqIEBzdGFiaWxpdHkgZXh0ZXJuYWxcbiAqXG4gKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1nYW1lbGlmdC1mbGVldC5odG1sXG4gKi9cbmV4cG9ydCBjbGFzcyBDZm5GbGVldCBleHRlbmRzIGNkay5DZm5SZXNvdXJjZSBpbXBsZW1lbnRzIGNkay5JSW5zcGVjdGFibGUge1xuICAgIC8qKlxuICAgICAqIFRoZSBDbG91ZEZvcm1hdGlvbiByZXNvdXJjZSB0eXBlIG5hbWUgZm9yIHRoaXMgcmVzb3VyY2UgY2xhc3MuXG4gICAgICovXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBDRk5fUkVTT1VSQ0VfVFlQRV9OQU1FID0gXCJBV1M6OkdhbWVMaWZ0OjpGbGVldFwiO1xuXG4gICAgLyoqXG4gICAgICogQSBmYWN0b3J5IG1ldGhvZCB0aGF0IGNyZWF0ZXMgYSBuZXcgaW5zdGFuY2Ugb2YgdGhpcyBjbGFzcyBmcm9tIGFuIG9iamVjdFxuICAgICAqIGNvbnRhaW5pbmcgdGhlIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgdGhpcyByZXNvdXJjZS5cbiAgICAgKiBVc2VkIGluIHRoZSBAYXdzLWNkay9jbG91ZGZvcm1hdGlvbi1pbmNsdWRlIG1vZHVsZS5cbiAgICAgKlxuICAgICAqIEBpbnRlcm5hbFxuICAgICAqL1xuICAgIHB1YmxpYyBzdGF0aWMgX2Zyb21DbG91ZEZvcm1hdGlvbihzY29wZTogY2RrLkNvbnN0cnVjdCwgaWQ6IHN0cmluZywgcmVzb3VyY2VBdHRyaWJ1dGVzOiBhbnksIG9wdGlvbnM6IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25PcHRpb25zKTogQ2ZuRmxlZXQge1xuICAgICAgICByZXNvdXJjZUF0dHJpYnV0ZXMgPSByZXNvdXJjZUF0dHJpYnV0ZXMgfHwge307XG4gICAgICAgIGNvbnN0IHJlc291cmNlUHJvcGVydGllcyA9IG9wdGlvbnMucGFyc2VyLnBhcnNlVmFsdWUocmVzb3VyY2VBdHRyaWJ1dGVzLlByb3BlcnRpZXMpO1xuICAgICAgICBjb25zdCBwcm9wc1Jlc3VsdCA9IENmbkZsZWV0UHJvcHNGcm9tQ2xvdWRGb3JtYXRpb24ocmVzb3VyY2VQcm9wZXJ0aWVzKTtcbiAgICAgICAgY29uc3QgcmV0ID0gbmV3IENmbkZsZWV0KHNjb3BlLCBpZCwgcHJvcHNSZXN1bHQudmFsdWUpO1xuICAgICAgICBmb3IgKGNvbnN0IFtwcm9wS2V5LCBwcm9wVmFsXSBvZiBPYmplY3QuZW50cmllcyhwcm9wc1Jlc3VsdC5leHRyYVByb3BlcnRpZXMpKSAge1xuICAgICAgICAgICAgcmV0LmFkZFByb3BlcnR5T3ZlcnJpZGUocHJvcEtleSwgcHJvcFZhbCk7XG4gICAgICAgIH1cbiAgICAgICAgb3B0aW9ucy5wYXJzZXIuaGFuZGxlQXR0cmlidXRlcyhyZXQsIHJlc291cmNlQXR0cmlidXRlcywgaWQpO1xuICAgICAgICByZXR1cm4gcmV0O1xuICAgIH1cblxuICAgIC8qKlxuICAgICAqIEEgdW5pcXVlIGlkZW50aWZpZXIgZm9yIHRoZSBmbGVldC5cbiAgICAgKiBAY2xvdWRmb3JtYXRpb25BdHRyaWJ1dGUgRmxlZXRJZFxuICAgICAqL1xuICAgIHB1YmxpYyByZWFkb25seSBhdHRyRmxlZXRJZDogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogQSB1bmlxdWUgaWRlbnRpZmllciBmb3IgYSBidWlsZCB0byBiZSBkZXBsb3llZCBvbiB0aGUgbmV3IGZsZWV0LiBJZiB5b3UgYXJlIGRlcGxveWluZyB0aGUgZmxlZXQgd2l0aCBhIGN1c3RvbSBnYW1lIGJ1aWxkLCB5b3UgbXVzdCBzcGVjaWZ5IHRoaXMgcHJvcGVydHkuIFRoZSBidWlsZCBtdXN0IGhhdmUgYmVlbiBzdWNjZXNzZnVsbHkgdXBsb2FkZWQgdG8gQW1hem9uIEdhbWVMaWZ0IGFuZCBiZSBpbiBhIGBSRUFEWWAgc3RhdHVzLiBUaGlzIGZsZWV0IHNldHRpbmcgY2Fubm90IGJlIGNoYW5nZWQgb25jZSB0aGUgZmxlZXQgaXMgY3JlYXRlZC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWdhbWVsaWZ0LWZsZWV0Lmh0bWwjY2ZuLWdhbWVsaWZ0LWZsZWV0LWJ1aWxkaWRcbiAgICAgKi9cbiAgICBwdWJsaWMgYnVpbGRJZDogc3RyaW5nIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogUHJvbXB0cyBHYW1lTGlmdCB0byBnZW5lcmF0ZSBhIFRMUy9TU0wgY2VydGlmaWNhdGUgZm9yIHRoZSBmbGVldC4gVExTIGNlcnRpZmljYXRlcyBhcmUgdXNlZCBmb3IgZW5jcnlwdGluZyB0cmFmZmljIGJldHdlZW4gZ2FtZSBjbGllbnRzIGFuZCB0aGUgZ2FtZSBzZXJ2ZXJzIHRoYXQgYXJlIHJ1bm5pbmcgb24gR2FtZUxpZnQuIEJ5IGRlZmF1bHQsIHRoZSBgQ2VydGlmaWNhdGVDb25maWd1cmF0aW9uYCBpcyBzZXQgdG8gYERJU0FCTEVEYCAuIFRoaXMgcHJvcGVydHkgY2Fubm90IGJlIGNoYW5nZWQgYWZ0ZXIgdGhlIGZsZWV0IGlzIGNyZWF0ZWQuXG4gICAgICpcbiAgICAgKiBOb3RlOiBUaGlzIGZlYXR1cmUgcmVxdWlyZXMgdGhlIEFXUyBDZXJ0aWZpY2F0ZSBNYW5hZ2VyIChBQ00pIHNlcnZpY2UsIHdoaWNoIGlzIG5vdCBhdmFpbGFibGUgaW4gYWxsIEFXUyByZWdpb25zLiBXaGVuIHdvcmtpbmcgaW4gYSByZWdpb24gdGhhdCBkb2VzIG5vdCBzdXBwb3J0IHRoaXMgZmVhdHVyZSwgYSBmbGVldCBjcmVhdGlvbiByZXF1ZXN0IHdpdGggY2VydGlmaWNhdGUgZ2VuZXJhdGlvbiBmYWlscyB3aXRoIGEgNHh4IGVycm9yLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZ2FtZWxpZnQtZmxlZXQuaHRtbCNjZm4tZ2FtZWxpZnQtZmxlZXQtY2VydGlmaWNhdGVjb25maWd1cmF0aW9uXG4gICAgICovXG4gICAgcHVibGljIGNlcnRpZmljYXRlQ29uZmlndXJhdGlvbjogQ2ZuRmxlZXQuQ2VydGlmaWNhdGVDb25maWd1cmF0aW9uUHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGUgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBBIGh1bWFuLXJlYWRhYmxlIGRlc2NyaXB0aW9uIG9mIHRoZSBmbGVldC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWdhbWVsaWZ0LWZsZWV0Lmh0bWwjY2ZuLWdhbWVsaWZ0LWZsZWV0LWRlc2NyaXB0aW9uXG4gICAgICovXG4gICAgcHVibGljIGRlc2NyaXB0aW9uOiBzdHJpbmcgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgbnVtYmVyIG9mIEVDMiBpbnN0YW5jZXMgdGhhdCB5b3Ugd2FudCB0aGlzIGZsZWV0IHRvIGhvc3QuIFdoZW4gY3JlYXRpbmcgYSBuZXcgZmxlZXQsIEdhbWVMaWZ0IGF1dG9tYXRpY2FsbHkgc2V0cyB0aGlzIHZhbHVlIHRvIFwiMVwiIGFuZCBpbml0aWF0ZXMgYSBzaW5nbGUgaW5zdGFuY2UuIE9uY2UgdGhlIGZsZWV0IGlzIGFjdGl2ZSwgdXBkYXRlIHRoaXMgdmFsdWUgdG8gdHJpZ2dlciBHYW1lTGlmdCB0byBhZGQgb3IgcmVtb3ZlIGluc3RhbmNlcyBmcm9tIHRoZSBmbGVldC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWdhbWVsaWZ0LWZsZWV0Lmh0bWwjY2ZuLWdhbWVsaWZ0LWZsZWV0LWRlc2lyZWRlYzJpbnN0YW5jZXNcbiAgICAgKi9cbiAgICBwdWJsaWMgZGVzaXJlZEVjMkluc3RhbmNlczogbnVtYmVyIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogVGhlIGFsbG93ZWQgSVAgYWRkcmVzcyByYW5nZXMgYW5kIHBvcnQgc2V0dGluZ3MgdGhhdCBhbGxvdyBpbmJvdW5kIHRyYWZmaWMgdG8gYWNjZXNzIGdhbWUgc2Vzc2lvbnMgb24gdGhpcyBmbGVldC4gSWYgdGhlIGZsZWV0IGlzIGhvc3RpbmcgYSBjdXN0b20gZ2FtZSBidWlsZCwgdGhpcyBwcm9wZXJ0eSBtdXN0IGJlIHNldCBiZWZvcmUgcGxheWVycyBjYW4gY29ubmVjdCB0byBnYW1lIHNlc3Npb25zLiBGb3IgUmVhbHRpbWUgU2VydmVycyBmbGVldHMsIEdhbWVMaWZ0IGF1dG9tYXRpY2FsbHkgc2V0cyBUQ1AgYW5kIFVEUCByYW5nZXMuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1nYW1lbGlmdC1mbGVldC5odG1sI2Nmbi1nYW1lbGlmdC1mbGVldC1lYzJpbmJvdW5kcGVybWlzc2lvbnNcbiAgICAgKi9cbiAgICBwdWJsaWMgZWMySW5ib3VuZFBlcm1pc3Npb25zOiBBcnJheTxDZm5GbGVldC5JcFBlcm1pc3Npb25Qcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZT4gfCBjZGsuSVJlc29sdmFibGUgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgR2FtZUxpZnQtc3VwcG9ydGVkIEFtYXpvbiBFQzIgaW5zdGFuY2UgdHlwZSB0byB1c2UgZm9yIGFsbCBmbGVldCBpbnN0YW5jZXMuIEluc3RhbmNlIHR5cGUgZGV0ZXJtaW5lcyB0aGUgY29tcHV0aW5nIHJlc291cmNlcyB0aGF0IHdpbGwgYmUgdXNlZCB0byBob3N0IHlvdXIgZ2FtZSBzZXJ2ZXJzLCBpbmNsdWRpbmcgQ1BVLCBtZW1vcnksIHN0b3JhZ2UsIGFuZCBuZXR3b3JraW5nIGNhcGFjaXR5LiBTZWUgW0FtYXpvbiBFbGFzdGljIENvbXB1dGUgQ2xvdWQgSW5zdGFuY2UgVHlwZXNdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9lYzIvaW5zdGFuY2UtdHlwZXMvKSBmb3IgZGV0YWlsZWQgZGVzY3JpcHRpb25zIG9mIEFtYXpvbiBFQzIgaW5zdGFuY2UgdHlwZXMuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1nYW1lbGlmdC1mbGVldC5odG1sI2Nmbi1nYW1lbGlmdC1mbGVldC1lYzJpbnN0YW5jZXR5cGVcbiAgICAgKi9cbiAgICBwdWJsaWMgZWMySW5zdGFuY2VUeXBlOiBzdHJpbmcgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBJbmRpY2F0ZXMgd2hldGhlciB0byB1c2UgT24tRGVtYW5kIG9yIFNwb3QgaW5zdGFuY2VzIGZvciB0aGlzIGZsZWV0LiBCeSBkZWZhdWx0LCB0aGlzIHByb3BlcnR5IGlzIHNldCB0byBgT05fREVNQU5EYCAuIExlYXJuIG1vcmUgYWJvdXQgd2hlbiB0byB1c2UgW09uLURlbWFuZCB2ZXJzdXMgU3BvdCBJbnN0YW5jZXNdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9nYW1lbGlmdC9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUvZ2FtZWxpZnQtZWMyLWluc3RhbmNlcy5odG1sI2dhbWVsaWZ0LWVjMi1pbnN0YW5jZXMtc3BvdCkgLiBUaGlzIHByb3BlcnR5IGNhbm5vdCBiZSBjaGFuZ2VkIGFmdGVyIHRoZSBmbGVldCBpcyBjcmVhdGVkLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZ2FtZWxpZnQtZmxlZXQuaHRtbCNjZm4tZ2FtZWxpZnQtZmxlZXQtZmxlZXR0eXBlXG4gICAgICovXG4gICAgcHVibGljIGZsZWV0VHlwZTogc3RyaW5nIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogQSB1bmlxdWUgaWRlbnRpZmllciBmb3IgYW4gSUFNIHJvbGUgdGhhdCBtYW5hZ2VzIGFjY2VzcyB0byB5b3VyIEFXUyBzZXJ2aWNlcy4gV2l0aCBhbiBpbnN0YW5jZSByb2xlIEFSTiBzZXQsIGFueSBhcHBsaWNhdGlvbiB0aGF0IHJ1bnMgb24gYW4gaW5zdGFuY2UgaW4gdGhpcyBmbGVldCBjYW4gYXNzdW1lIHRoZSByb2xlLCBpbmNsdWRpbmcgaW5zdGFsbCBzY3JpcHRzLCBzZXJ2ZXIgcHJvY2Vzc2VzLCBhbmQgZGFlbW9ucyAoYmFja2dyb3VuZCBwcm9jZXNzZXMpLiBDcmVhdGUgYSByb2xlIG9yIGxvb2sgdXAgYSByb2xlJ3MgQVJOIGJ5IHVzaW5nIHRoZSBbSUFNIGRhc2hib2FyZF0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lhbS8pIGluIHRoZSBBV1MgTWFuYWdlbWVudCBDb25zb2xlIC4gTGVhcm4gbW9yZSBhYm91dCB1c2luZyBvbi1ib3ggY3JlZGVudGlhbHMgZm9yIHlvdXIgZ2FtZSBzZXJ2ZXJzIGF0IFtBY2Nlc3MgZXh0ZXJuYWwgcmVzb3VyY2VzIGZyb20gYSBnYW1lIHNlcnZlcl0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2dhbWVsaWZ0L2xhdGVzdC9kZXZlbG9wZXJndWlkZS9nYW1lbGlmdC1zZGstc2VydmVyLXJlc291cmNlcy5odG1sKSAuIFRoaXMgcHJvcGVydHkgY2Fubm90IGJlIGNoYW5nZWQgYWZ0ZXIgdGhlIGZsZWV0IGlzIGNyZWF0ZWQuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1nYW1lbGlmdC1mbGVldC5odG1sI2Nmbi1nYW1lbGlmdC1mbGVldC1pbnN0YW5jZXJvbGVhcm5cbiAgICAgKi9cbiAgICBwdWJsaWMgaW5zdGFuY2VSb2xlQXJuOiBzdHJpbmcgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBBIHNldCBvZiByZW1vdGUgbG9jYXRpb25zIHRvIGRlcGxveSBhZGRpdGlvbmFsIGluc3RhbmNlcyB0byBhbmQgbWFuYWdlIGFzIHBhcnQgb2YgdGhlIGZsZWV0LiBUaGlzIHBhcmFtZXRlciBjYW4gb25seSBiZSB1c2VkIHdoZW4gY3JlYXRpbmcgZmxlZXRzIGluIEFXUyBSZWdpb25zIHRoYXQgc3VwcG9ydCBtdWx0aXBsZSBsb2NhdGlvbnMuIFlvdSBjYW4gYWRkIGFueSBHYW1lTGlmdC1zdXBwb3J0ZWQgQVdTIFJlZ2lvbiBhcyBhIHJlbW90ZSBsb2NhdGlvbiwgaW4gdGhlIGZvcm0gb2YgYW4gQVdTIFJlZ2lvbiBjb2RlIHN1Y2ggYXMgYHVzLXdlc3QtMmAgLiBUbyBjcmVhdGUgYSBmbGVldCB3aXRoIGluc3RhbmNlcyBpbiB0aGUgaG9tZSBSZWdpb24gb25seSwgb21pdCB0aGlzIHBhcmFtZXRlci5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWdhbWVsaWZ0LWZsZWV0Lmh0bWwjY2ZuLWdhbWVsaWZ0LWZsZWV0LWxvY2F0aW9uc1xuICAgICAqL1xuICAgIHB1YmxpYyBsb2NhdGlvbnM6IEFycmF5PENmbkZsZWV0LkxvY2F0aW9uQ29uZmlndXJhdGlvblByb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlPiB8IGNkay5JUmVzb2x2YWJsZSB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIFRoZSBtYXhpbXVtIG51bWJlciBvZiBpbnN0YW5jZXMgdGhhdCBhcmUgYWxsb3dlZCBpbiB0aGUgc3BlY2lmaWVkIGZsZWV0IGxvY2F0aW9uLiBJZiB0aGlzIHBhcmFtZXRlciBpcyBub3Qgc2V0LCB0aGUgZGVmYXVsdCBpcyAxLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZ2FtZWxpZnQtZmxlZXQuaHRtbCNjZm4tZ2FtZWxpZnQtZmxlZXQtbWF4c2l6ZVxuICAgICAqL1xuICAgIHB1YmxpYyBtYXhTaXplOiBudW1iZXIgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgbmFtZSBvZiBhbiBBV1MgQ2xvdWRXYXRjaCBtZXRyaWMgZ3JvdXAgdG8gYWRkIHRoaXMgZmxlZXQgdG8uIEEgbWV0cmljIGdyb3VwIGlzIHVzZWQgdG8gYWdncmVnYXRlIHRoZSBtZXRyaWNzIGZvciBtdWx0aXBsZSBmbGVldHMuIFlvdSBjYW4gc3BlY2lmeSBhbiBleGlzdGluZyBtZXRyaWMgZ3JvdXAgbmFtZSBvciBzZXQgYSBuZXcgbmFtZSB0byBjcmVhdGUgYSBuZXcgbWV0cmljIGdyb3VwLiBBIGZsZWV0IGNhbiBiZSBpbmNsdWRlZCBpbiBvbmx5IG9uZSBtZXRyaWMgZ3JvdXAgYXQgYSB0aW1lLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZ2FtZWxpZnQtZmxlZXQuaHRtbCNjZm4tZ2FtZWxpZnQtZmxlZXQtbWV0cmljZ3JvdXBzXG4gICAgICovXG4gICAgcHVibGljIG1ldHJpY0dyb3Vwczogc3RyaW5nW10gfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgbWluaW11bSBudW1iZXIgb2YgaW5zdGFuY2VzIHRoYXQgYXJlIGFsbG93ZWQgaW4gdGhlIHNwZWNpZmllZCBmbGVldCBsb2NhdGlvbi4gSWYgdGhpcyBwYXJhbWV0ZXIgaXMgbm90IHNldCwgdGhlIGRlZmF1bHQgaXMgMC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWdhbWVsaWZ0LWZsZWV0Lmh0bWwjY2ZuLWdhbWVsaWZ0LWZsZWV0LW1pbnNpemVcbiAgICAgKi9cbiAgICBwdWJsaWMgbWluU2l6ZTogbnVtYmVyIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogQSBkZXNjcmlwdGl2ZSBsYWJlbCB0aGF0IGlzIGFzc29jaWF0ZWQgd2l0aCBhIGZsZWV0LiBGbGVldCBuYW1lcyBkbyBub3QgbmVlZCB0byBiZSB1bmlxdWUuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1nYW1lbGlmdC1mbGVldC5odG1sI2Nmbi1nYW1lbGlmdC1mbGVldC1uYW1lXG4gICAgICovXG4gICAgcHVibGljIG5hbWU6IHN0cmluZyB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIFRoZSBzdGF0dXMgb2YgdGVybWluYXRpb24gcHJvdGVjdGlvbiBmb3IgYWN0aXZlIGdhbWUgc2Vzc2lvbnMgb24gdGhlIGZsZWV0LiBCeSBkZWZhdWx0LCB0aGlzIHByb3BlcnR5IGlzIHNldCB0byBgTm9Qcm90ZWN0aW9uYCAuXG4gICAgICpcbiAgICAgKiAtICpOb1Byb3RlY3Rpb24qIC0gR2FtZSBzZXNzaW9ucyBjYW4gYmUgdGVybWluYXRlZCBkdXJpbmcgYWN0aXZlIGdhbWVwbGF5IGFzIGEgcmVzdWx0IG9mIGEgc2NhbGUtZG93biBldmVudC5cbiAgICAgKiAtICpGdWxsUHJvdGVjdGlvbiogLSBHYW1lIHNlc3Npb25zIGluIGBBQ1RJVkVgIHN0YXR1cyBjYW5ub3QgYmUgdGVybWluYXRlZCBkdXJpbmcgYSBzY2FsZS1kb3duIGV2ZW50LlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZ2FtZWxpZnQtZmxlZXQuaHRtbCNjZm4tZ2FtZWxpZnQtZmxlZXQtbmV3Z2FtZXNlc3Npb25wcm90ZWN0aW9ucG9saWN5XG4gICAgICovXG4gICAgcHVibGljIG5ld0dhbWVTZXNzaW9uUHJvdGVjdGlvblBvbGljeTogc3RyaW5nIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogVXNlZCB3aGVuIHBlZXJpbmcgeW91ciBHYW1lTGlmdCBmbGVldCB3aXRoIGEgVlBDLCB0aGUgdW5pcXVlIGlkZW50aWZpZXIgZm9yIHRoZSBBV1MgYWNjb3VudCB0aGF0IG93bnMgdGhlIFZQQy4gWW91IGNhbiBmaW5kIHlvdXIgYWNjb3VudCBJRCBpbiB0aGUgQVdTIE1hbmFnZW1lbnQgQ29uc29sZSB1bmRlciBhY2NvdW50IHNldHRpbmdzLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZ2FtZWxpZnQtZmxlZXQuaHRtbCNjZm4tZ2FtZWxpZnQtZmxlZXQtcGVlcnZwY2F3c2FjY291bnRpZFxuICAgICAqL1xuICAgIHB1YmxpYyBwZWVyVnBjQXdzQWNjb3VudElkOiBzdHJpbmcgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBBIHVuaXF1ZSBpZGVudGlmaWVyIGZvciBhIFZQQyB3aXRoIHJlc291cmNlcyB0byBiZSBhY2Nlc3NlZCBieSB5b3VyIEdhbWVMaWZ0IGZsZWV0LiBUaGUgVlBDIG11c3QgYmUgaW4gdGhlIHNhbWUgUmVnaW9uIGFzIHlvdXIgZmxlZXQuIFRvIGxvb2sgdXAgYSBWUEMgSUQsIHVzZSB0aGUgW1ZQQyBEYXNoYm9hcmRdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS92cGMvKSBpbiB0aGUgQVdTIE1hbmFnZW1lbnQgQ29uc29sZSAuIExlYXJuIG1vcmUgYWJvdXQgVlBDIHBlZXJpbmcgaW4gW1ZQQyBQZWVyaW5nIHdpdGggR2FtZUxpZnQgRmxlZXRzXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZ2FtZWxpZnQvbGF0ZXN0L2RldmVsb3Blcmd1aWRlL3ZwYy1wZWVyaW5nLmh0bWwpIC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWdhbWVsaWZ0LWZsZWV0Lmh0bWwjY2ZuLWdhbWVsaWZ0LWZsZWV0LXBlZXJ2cGNpZFxuICAgICAqL1xuICAgIHB1YmxpYyBwZWVyVnBjSWQ6IHN0cmluZyB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIEEgcG9saWN5IHRoYXQgbGltaXRzIHRoZSBudW1iZXIgb2YgZ2FtZSBzZXNzaW9ucyB0aGF0IGFuIGluZGl2aWR1YWwgcGxheWVyIGNhbiBjcmVhdGUgb24gaW5zdGFuY2VzIGluIHRoaXMgZmxlZXQgd2l0aGluIGEgc3BlY2lmaWVkIHNwYW4gb2YgdGltZS5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWdhbWVsaWZ0LWZsZWV0Lmh0bWwjY2ZuLWdhbWVsaWZ0LWZsZWV0LXJlc291cmNlY3JlYXRpb25saW1pdHBvbGljeVxuICAgICAqL1xuICAgIHB1YmxpYyByZXNvdXJjZUNyZWF0aW9uTGltaXRQb2xpY3k6IENmbkZsZWV0LlJlc291cmNlQ3JlYXRpb25MaW1pdFBvbGljeVByb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogSW5zdHJ1Y3Rpb25zIGZvciBob3cgdG8gbGF1bmNoIGFuZCBtYWludGFpbiBzZXJ2ZXIgcHJvY2Vzc2VzIG9uIGluc3RhbmNlcyBpbiB0aGUgZmxlZXQuIFRoZSBydW50aW1lIGNvbmZpZ3VyYXRpb24gZGVmaW5lcyBvbmUgb3IgbW9yZSBzZXJ2ZXIgcHJvY2VzcyBjb25maWd1cmF0aW9ucywgZWFjaCBpZGVudGlmeWluZyBhIGJ1aWxkIGV4ZWN1dGFibGUgb3IgUmVhbHRpbWUgc2NyaXB0IGZpbGUgYW5kIHRoZSBudW1iZXIgb2YgcHJvY2Vzc2VzIG9mIHRoYXQgdHlwZSB0byBydW4gY29uY3VycmVudGx5LlxuICAgICAqXG4gICAgICogPiBUaGUgYFJ1bnRpbWVDb25maWd1cmF0aW9uYCBwYXJhbWV0ZXIgaXMgcmVxdWlyZWQgdW5sZXNzIHRoZSBmbGVldCBpcyBiZWluZyBjb25maWd1cmVkIHVzaW5nIHRoZSBvbGRlciBwYXJhbWV0ZXJzIGBTZXJ2ZXJMYXVuY2hQYXRoYCBhbmQgYFNlcnZlckxhdW5jaFBhcmFtZXRlcnNgICwgd2hpY2ggYXJlIHN0aWxsIHN1cHBvcnRlZCBmb3IgYmFja3dhcmQgY29tcGF0aWJpbGl0eS5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWdhbWVsaWZ0LWZsZWV0Lmh0bWwjY2ZuLWdhbWVsaWZ0LWZsZWV0LXJ1bnRpbWVjb25maWd1cmF0aW9uXG4gICAgICovXG4gICAgcHVibGljIHJ1bnRpbWVDb25maWd1cmF0aW9uOiBDZm5GbGVldC5SdW50aW1lQ29uZmlndXJhdGlvblByb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogVGhlIHVuaXF1ZSBpZGVudGlmaWVyIGZvciBhIFJlYWx0aW1lIGNvbmZpZ3VyYXRpb24gc2NyaXB0IHRvIGJlIGRlcGxveWVkIG9uIGZsZWV0IGluc3RhbmNlcy4gWW91IGNhbiB1c2UgZWl0aGVyIHRoZSBzY3JpcHQgSUQgb3IgQVJOLiBTY3JpcHRzIG11c3QgYmUgdXBsb2FkZWQgdG8gR2FtZUxpZnQgcHJpb3IgdG8gY3JlYXRpbmcgdGhlIGZsZWV0LiBUaGlzIGZsZWV0IHByb3BlcnR5IGNhbm5vdCBiZSBjaGFuZ2VkIGxhdGVyLlxuICAgICAqXG4gICAgICogPiBZb3UgY2FuJ3QgdXNlIHRoZSBgIVJlZmAgY29tbWFuZCB0byByZWZlcmVuY2UgYSBzY3JpcHQgY3JlYXRlZCB3aXRoIGEgQ2xvdWRGb3JtYXRpb24gdGVtcGxhdGUgZm9yIHRoZSBmbGVldCBwcm9wZXJ0eSBgU2NyaXB0SWRgIC4gSW5zdGVhZCwgdXNlIGBGbjo6R2V0QXR0IFNjcmlwdC5Bcm5gIG9yIGBGbjo6R2V0QXR0IFNjcmlwdC5JZGAgdG8gcmV0cmlldmUgZWl0aGVyIG9mIHRoZXNlIHByb3BlcnRpZXMgYXMgaW5wdXQgZm9yIGBTY3JpcHRJZGAgLiBBbHRlcm5hdGl2ZWx5LCBlbnRlciBhIGBTY3JpcHRJZGAgc3RyaW5nIG1hbnVhbGx5LlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZ2FtZWxpZnQtZmxlZXQuaHRtbCNjZm4tZ2FtZWxpZnQtZmxlZXQtc2NyaXB0aWRcbiAgICAgKi9cbiAgICBwdWJsaWMgc2NyaXB0SWQ6IHN0cmluZyB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIENyZWF0ZSBhIG5ldyBgQVdTOjpHYW1lTGlmdDo6RmxlZXRgLlxuICAgICAqXG4gICAgICogQHBhcmFtIHNjb3BlIC0gc2NvcGUgaW4gd2hpY2ggdGhpcyByZXNvdXJjZSBpcyBkZWZpbmVkXG4gICAgICogQHBhcmFtIGlkICAgIC0gc2NvcGVkIGlkIG9mIHRoZSByZXNvdXJjZVxuICAgICAqIEBwYXJhbSBwcm9wcyAtIHJlc291cmNlIHByb3BlcnRpZXNcbiAgICAgKi9cbiAgICBjb25zdHJ1Y3RvcihzY29wZTogY2RrLkNvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IENmbkZsZWV0UHJvcHMgPSB7fSkge1xuICAgICAgICBzdXBlcihzY29wZSwgaWQsIHsgdHlwZTogQ2ZuRmxlZXQuQ0ZOX1JFU09VUkNFX1RZUEVfTkFNRSwgcHJvcGVydGllczogcHJvcHMgfSk7XG4gICAgICAgIHRoaXMuYXR0ckZsZWV0SWQgPSBjZGsuVG9rZW4uYXNTdHJpbmcodGhpcy5nZXRBdHQoJ0ZsZWV0SWQnKSk7XG5cbiAgICAgICAgdGhpcy5idWlsZElkID0gcHJvcHMuYnVpbGRJZDtcbiAgICAgICAgdGhpcy5jZXJ0aWZpY2F0ZUNvbmZpZ3VyYXRpb24gPSBwcm9wcy5jZXJ0aWZpY2F0ZUNvbmZpZ3VyYXRpb247XG4gICAgICAgIHRoaXMuZGVzY3JpcHRpb24gPSBwcm9wcy5kZXNjcmlwdGlvbjtcbiAgICAgICAgdGhpcy5kZXNpcmVkRWMySW5zdGFuY2VzID0gcHJvcHMuZGVzaXJlZEVjMkluc3RhbmNlcztcbiAgICAgICAgdGhpcy5lYzJJbmJvdW5kUGVybWlzc2lvbnMgPSBwcm9wcy5lYzJJbmJvdW5kUGVybWlzc2lvbnM7XG4gICAgICAgIHRoaXMuZWMySW5zdGFuY2VUeXBlID0gcHJvcHMuZWMySW5zdGFuY2VUeXBlO1xuICAgICAgICB0aGlzLmZsZWV0VHlwZSA9IHByb3BzLmZsZWV0VHlwZTtcbiAgICAgICAgdGhpcy5pbnN0YW5jZVJvbGVBcm4gPSBwcm9wcy5pbnN0YW5jZVJvbGVBcm47XG4gICAgICAgIHRoaXMubG9jYXRpb25zID0gcHJvcHMubG9jYXRpb25zO1xuICAgICAgICB0aGlzLm1heFNpemUgPSBwcm9wcy5tYXhTaXplO1xuICAgICAgICB0aGlzLm1ldHJpY0dyb3VwcyA9IHByb3BzLm1ldHJpY0dyb3VwcztcbiAgICAgICAgdGhpcy5taW5TaXplID0gcHJvcHMubWluU2l6ZTtcbiAgICAgICAgdGhpcy5uYW1lID0gcHJvcHMubmFtZTtcbiAgICAgICAgdGhpcy5uZXdHYW1lU2Vzc2lvblByb3RlY3Rpb25Qb2xpY3kgPSBwcm9wcy5uZXdHYW1lU2Vzc2lvblByb3RlY3Rpb25Qb2xpY3k7XG4gICAgICAgIHRoaXMucGVlclZwY0F3c0FjY291bnRJZCA9IHByb3BzLnBlZXJWcGNBd3NBY2NvdW50SWQ7XG4gICAgICAgIHRoaXMucGVlclZwY0lkID0gcHJvcHMucGVlclZwY0lkO1xuICAgICAgICB0aGlzLnJlc291cmNlQ3JlYXRpb25MaW1pdFBvbGljeSA9IHByb3BzLnJlc291cmNlQ3JlYXRpb25MaW1pdFBvbGljeTtcbiAgICAgICAgdGhpcy5ydW50aW1lQ29uZmlndXJhdGlvbiA9IHByb3BzLnJ1bnRpbWVDb25maWd1cmF0aW9uO1xuICAgICAgICB0aGlzLnNjcmlwdElkID0gcHJvcHMuc2NyaXB0SWQ7XG4gICAgfVxuXG4gICAgLyoqXG4gICAgICogRXhhbWluZXMgdGhlIENsb3VkRm9ybWF0aW9uIHJlc291cmNlIGFuZCBkaXNjbG9zZXMgYXR0cmlidXRlcy5cbiAgICAgKlxuICAgICAqIEBwYXJhbSBpbnNwZWN0b3IgLSB0cmVlIGluc3BlY3RvciB0byBjb2xsZWN0IGFuZCBwcm9jZXNzIGF0dHJpYnV0ZXNcbiAgICAgKlxuICAgICAqL1xuICAgIHB1YmxpYyBpbnNwZWN0KGluc3BlY3RvcjogY2RrLlRyZWVJbnNwZWN0b3IpIHtcbiAgICAgICAgaW5zcGVjdG9yLmFkZEF0dHJpYnV0ZShcImF3czpjZGs6Y2xvdWRmb3JtYXRpb246dHlwZVwiLCBDZm5GbGVldC5DRk5fUkVTT1VSQ0VfVFlQRV9OQU1FKTtcbiAgICAgICAgaW5zcGVjdG9yLmFkZEF0dHJpYnV0ZShcImF3czpjZGs6Y2xvdWRmb3JtYXRpb246cHJvcHNcIiwgdGhpcy5jZm5Qcm9wZXJ0aWVzKTtcbiAgICB9XG5cbiAgICBwcm90ZWN0ZWQgZ2V0IGNmblByb3BlcnRpZXMoKTogeyBba2V5OiBzdHJpbmddOiBhbnkgfSAge1xuICAgICAgICByZXR1cm4ge1xuICAgICAgICAgICAgYnVpbGRJZDogdGhpcy5idWlsZElkLFxuICAgICAgICAgICAgY2VydGlmaWNhdGVDb25maWd1cmF0aW9uOiB0aGlzLmNlcnRpZmljYXRlQ29uZmlndXJhdGlvbixcbiAgICAgICAgICAgIGRlc2NyaXB0aW9uOiB0aGlzLmRlc2NyaXB0aW9uLFxuICAgICAgICAgICAgZGVzaXJlZEVjMkluc3RhbmNlczogdGhpcy5kZXNpcmVkRWMySW5zdGFuY2VzLFxuICAgICAgICAgICAgZWMySW5ib3VuZFBlcm1pc3Npb25zOiB0aGlzLmVjMkluYm91bmRQZXJtaXNzaW9ucyxcbiAgICAgICAgICAgIGVjMkluc3RhbmNlVHlwZTogdGhpcy5lYzJJbnN0YW5jZVR5cGUsXG4gICAgICAgICAgICBmbGVldFR5cGU6IHRoaXMuZmxlZXRUeXBlLFxuICAgICAgICAgICAgaW5zdGFuY2VSb2xlQXJuOiB0aGlzLmluc3RhbmNlUm9sZUFybixcbiAgICAgICAgICAgIGxvY2F0aW9uczogdGhpcy5sb2NhdGlvbnMsXG4gICAgICAgICAgICBtYXhTaXplOiB0aGlzLm1heFNpemUsXG4gICAgICAgICAgICBtZXRyaWNHcm91cHM6IHRoaXMubWV0cmljR3JvdXBzLFxuICAgICAgICAgICAgbWluU2l6ZTogdGhpcy5taW5TaXplLFxuICAgICAgICAgICAgbmFtZTogdGhpcy5uYW1lLFxuICAgICAgICAgICAgbmV3R2FtZVNlc3Npb25Qcm90ZWN0aW9uUG9saWN5OiB0aGlzLm5ld0dhbWVTZXNzaW9uUHJvdGVjdGlvblBvbGljeSxcbiAgICAgICAgICAgIHBlZXJWcGNBd3NBY2NvdW50SWQ6IHRoaXMucGVlclZwY0F3c0FjY291bnRJZCxcbiAgICAgICAgICAgIHBlZXJWcGNJZDogdGhpcy5wZWVyVnBjSWQsXG4gICAgICAgICAgICByZXNvdXJjZUNyZWF0aW9uTGltaXRQb2xpY3k6IHRoaXMucmVzb3VyY2VDcmVhdGlvbkxpbWl0UG9saWN5LFxuICAgICAgICAgICAgcnVudGltZUNvbmZpZ3VyYXRpb246IHRoaXMucnVudGltZUNvbmZpZ3VyYXRpb24sXG4gICAgICAgICAgICBzY3JpcHRJZDogdGhpcy5zY3JpcHRJZCxcbiAgICAgICAgfTtcbiAgICB9XG5cbiAgICBwcm90ZWN0ZWQgcmVuZGVyUHJvcGVydGllcyhwcm9wczoge1trZXk6IHN0cmluZ106IGFueX0pOiB7IFtrZXk6IHN0cmluZ106IGFueSB9ICB7XG4gICAgICAgIHJldHVybiBjZm5GbGVldFByb3BzVG9DbG91ZEZvcm1hdGlvbihwcm9wcyk7XG4gICAgfVxufVxuXG5leHBvcnQgbmFtZXNwYWNlIENmbkZsZWV0IHtcbiAgICAvKipcbiAgICAgKiBEZXRlcm1pbmVzIHdoZXRoZXIgYSBUTFMvU1NMIGNlcnRpZmljYXRlIGlzIGdlbmVyYXRlZCBmb3IgYSBmbGVldC4gVGhpcyBmZWF0dXJlIG11c3QgYmUgZW5hYmxlZCB3aGVuIGNyZWF0aW5nIHRoZSBmbGVldC4gQWxsIGluc3RhbmNlcyBpbiBhIGZsZWV0IHNoYXJlIHRoZSBzYW1lIGNlcnRpZmljYXRlLiBUaGUgY2VydGlmaWNhdGUgY2FuIGJlIHJldHJpZXZlZCBieSBjYWxsaW5nIHRoZSBbR2FtZUxpZnQgU2VydmVyIFNES10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2dhbWVsaWZ0L2xhdGVzdC9kZXZlbG9wZXJndWlkZS9yZWZlcmVuY2Utc2VydmVyc2RrLmh0bWwpIG9wZXJhdGlvbiBgR2V0SW5zdGFuY2VDZXJ0aWZpY2F0ZWAgLlxuICAgICAqXG4gICAgICogQHN0cnVjdFxuICAgICAqIEBzdGFiaWxpdHkgZXh0ZXJuYWxcbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtZ2FtZWxpZnQtZmxlZXQtY2VydGlmaWNhdGVjb25maWd1cmF0aW9uLmh0bWxcbiAgICAgKi9cbiAgICBleHBvcnQgaW50ZXJmYWNlIENlcnRpZmljYXRlQ29uZmlndXJhdGlvblByb3BlcnR5IHtcbiAgICAgICAgLyoqXG4gICAgICAgICAqIEluZGljYXRlcyB3aGV0aGVyIGEgVExTL1NTTCBjZXJ0aWZpY2F0ZSBpcyBnZW5lcmF0ZWQgZm9yIGEgZmxlZXQuXG4gICAgICAgICAqXG4gICAgICAgICAqIFZhbGlkIHZhbHVlcyBpbmNsdWRlOlxuICAgICAgICAgKlxuICAgICAgICAgKiAtICpHRU5FUkFURUQqIC0gR2VuZXJhdGUgYSBUTFMvU1NMIGNlcnRpZmljYXRlIGZvciB0aGlzIGZsZWV0LlxuICAgICAgICAgKiAtICpESVNBQkxFRCogLSAoZGVmYXVsdCkgRG8gbm90IGdlbmVyYXRlIGEgVExTL1NTTCBjZXJ0aWZpY2F0ZSBmb3IgdGhpcyBmbGVldC5cbiAgICAgICAgICpcbiAgICAgICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1nYW1lbGlmdC1mbGVldC1jZXJ0aWZpY2F0ZWNvbmZpZ3VyYXRpb24uaHRtbCNjZm4tZ2FtZWxpZnQtZmxlZXQtY2VydGlmaWNhdGVjb25maWd1cmF0aW9uLWNlcnRpZmljYXRldHlwZVxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgY2VydGlmaWNhdGVUeXBlOiBzdHJpbmc7XG4gICAgfVxufVxuXG4vKipcbiAqIERldGVybWluZSB3aGV0aGVyIHRoZSBnaXZlbiBwcm9wZXJ0aWVzIG1hdGNoIHRob3NlIG9mIGEgYENlcnRpZmljYXRlQ29uZmlndXJhdGlvblByb3BlcnR5YFxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBDZXJ0aWZpY2F0ZUNvbmZpZ3VyYXRpb25Qcm9wZXJ0eWBcbiAqXG4gKiBAcmV0dXJucyB0aGUgcmVzdWx0IG9mIHRoZSB2YWxpZGF0aW9uLlxuICovXG5mdW5jdGlvbiBDZm5GbGVldF9DZXJ0aWZpY2F0ZUNvbmZpZ3VyYXRpb25Qcm9wZXJ0eVZhbGlkYXRvcihwcm9wZXJ0aWVzOiBhbnkpOiBjZGsuVmFsaWRhdGlvblJlc3VsdCB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gY2RrLlZBTElEQVRJT05fU1VDQ0VTUzsgfVxuICAgIGNvbnN0IGVycm9ycyA9IG5ldyBjZGsuVmFsaWRhdGlvblJlc3VsdHMoKTtcbiAgICBpZiAodHlwZW9mIHByb3BlcnRpZXMgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIGVycm9ycy5jb2xsZWN0KG5ldyBjZGsuVmFsaWRhdGlvblJlc3VsdCgnRXhwZWN0ZWQgYW4gb2JqZWN0LCBidXQgcmVjZWl2ZWQ6ICcgKyBKU09OLnN0cmluZ2lmeShwcm9wZXJ0aWVzKSkpO1xuICAgIH1cbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2NlcnRpZmljYXRlVHlwZScsIGNkay5yZXF1aXJlZFZhbGlkYXRvcikocHJvcGVydGllcy5jZXJ0aWZpY2F0ZVR5cGUpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2NlcnRpZmljYXRlVHlwZScsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5jZXJ0aWZpY2F0ZVR5cGUpKTtcbiAgICByZXR1cm4gZXJyb3JzLndyYXAoJ3N1cHBsaWVkIHByb3BlcnRpZXMgbm90IGNvcnJlY3QgZm9yIFwiQ2VydGlmaWNhdGVDb25maWd1cmF0aW9uUHJvcGVydHlcIicpO1xufVxuXG4vKipcbiAqIFJlbmRlcnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OkdhbWVMaWZ0OjpGbGVldC5DZXJ0aWZpY2F0ZUNvbmZpZ3VyYXRpb25gIHJlc291cmNlXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYENlcnRpZmljYXRlQ29uZmlndXJhdGlvblByb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpHYW1lTGlmdDo6RmxlZXQuQ2VydGlmaWNhdGVDb25maWd1cmF0aW9uYCByZXNvdXJjZS5cbiAqL1xuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIGNmbkZsZWV0Q2VydGlmaWNhdGVDb25maWd1cmF0aW9uUHJvcGVydHlUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGFueSB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gcHJvcGVydGllczsgfVxuICAgIENmbkZsZWV0X0NlcnRpZmljYXRlQ29uZmlndXJhdGlvblByb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXMpLmFzc2VydFN1Y2Nlc3MoKTtcbiAgICByZXR1cm4ge1xuICAgICAgICBDZXJ0aWZpY2F0ZVR5cGU6IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuY2VydGlmaWNhdGVUeXBlKSxcbiAgICB9O1xufVxuXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gQ2ZuRmxlZXRDZXJ0aWZpY2F0ZUNvbmZpZ3VyYXRpb25Qcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0PENmbkZsZWV0LkNlcnRpZmljYXRlQ29uZmlndXJhdGlvblByb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlPiB7XG4gICAgaWYgKGNkay5pc1Jlc29sdmFibGVPYmplY3QocHJvcGVydGllcykpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0KHByb3BlcnRpZXMpO1xuICAgIH1cbiAgICBwcm9wZXJ0aWVzID0gcHJvcGVydGllcyA9PSBudWxsID8ge30gOiBwcm9wZXJ0aWVzO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0KHByb3BlcnRpZXMpO1xuICAgIH1cbiAgICBjb25zdCByZXQgPSBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblByb3BlcnR5T2JqZWN0PENmbkZsZWV0LkNlcnRpZmljYXRlQ29uZmlndXJhdGlvblByb3BlcnR5PigpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnY2VydGlmaWNhdGVUeXBlJywgJ0NlcnRpZmljYXRlVHlwZScsIGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuQ2VydGlmaWNhdGVUeXBlKSk7XG4gICAgcmV0LmFkZFVucmVjb2duaXplZFByb3BlcnRpZXNBc0V4dHJhKHByb3BlcnRpZXMpO1xuICAgIHJldHVybiByZXQ7XG59XG5cbmV4cG9ydCBuYW1lc3BhY2UgQ2ZuRmxlZXQge1xuICAgIC8qKlxuICAgICAqIEEgcmFuZ2Ugb2YgSVAgYWRkcmVzc2VzIGFuZCBwb3J0IHNldHRpbmdzIHRoYXQgYWxsb3cgaW5ib3VuZCB0cmFmZmljIHRvIGNvbm5lY3QgdG8gc2VydmVyIHByb2Nlc3NlcyBvbiBhbiBpbnN0YW5jZSBpbiBhIGZsZWV0LiBOZXcgZ2FtZSBzZXNzaW9ucyBhcmUgYXNzaWduZWQgYW4gSVAgYWRkcmVzcy9wb3J0IG51bWJlciBjb21iaW5hdGlvbiwgd2hpY2ggbXVzdCBmYWxsIGludG8gdGhlIGZsZWV0J3MgYWxsb3dlZCByYW5nZXMuIEZsZWV0cyB3aXRoIGN1c3RvbSBnYW1lIGJ1aWxkcyBtdXN0IGhhdmUgcGVybWlzc2lvbnMgZXhwbGljaXRseSBzZXQuIEZvciBSZWFsdGltZSBTZXJ2ZXJzIGZsZWV0cywgR2FtZUxpZnQgYXV0b21hdGljYWxseSBvcGVucyB0d28gcG9ydCByYW5nZXMsIG9uZSBmb3IgVENQIG1lc3NhZ2luZyBhbmQgb25lIGZvciBVRFAuXG4gICAgICpcbiAgICAgKiBAc3RydWN0XG4gICAgICogQHN0YWJpbGl0eSBleHRlcm5hbFxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1nYW1lbGlmdC1mbGVldC1pcHBlcm1pc3Npb24uaHRtbFxuICAgICAqL1xuICAgIGV4cG9ydCBpbnRlcmZhY2UgSXBQZXJtaXNzaW9uUHJvcGVydHkge1xuICAgICAgICAvKipcbiAgICAgICAgICogQSBzdGFydGluZyB2YWx1ZSBmb3IgYSByYW5nZSBvZiBhbGxvd2VkIHBvcnQgbnVtYmVycy5cbiAgICAgICAgICpcbiAgICAgICAgICogRm9yIGZsZWV0cyB1c2luZyBXaW5kb3dzIGFuZCBMaW51eCBidWlsZHMsIG9ubHkgcG9ydHMgMTAyNi02MDAwMCBhcmUgdmFsaWQuXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtZ2FtZWxpZnQtZmxlZXQtaXBwZXJtaXNzaW9uLmh0bWwjY2ZuLWdhbWVsaWZ0LWZsZWV0LWlwcGVybWlzc2lvbi1mcm9tcG9ydFxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgZnJvbVBvcnQ6IG51bWJlcjtcbiAgICAgICAgLyoqXG4gICAgICAgICAqIEEgcmFuZ2Ugb2YgYWxsb3dlZCBJUCBhZGRyZXNzZXMuIFRoaXMgdmFsdWUgbXVzdCBiZSBleHByZXNzZWQgaW4gQ0lEUiBub3RhdGlvbi4gRXhhbXBsZTogXCIgYDAwMC4wMDAuMDAwLjAwMC9bc3VibmV0IG1hc2tdYCBcIiBvciBvcHRpb25hbGx5IHRoZSBzaG9ydGVuZWQgdmVyc2lvbiBcIiBgMC4wLjAuMC9bc3VibmV0IG1hc2tdYCBcIi5cbiAgICAgICAgICpcbiAgICAgICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1nYW1lbGlmdC1mbGVldC1pcHBlcm1pc3Npb24uaHRtbCNjZm4tZ2FtZWxpZnQtZmxlZXQtaXBwZXJtaXNzaW9uLWlwcmFuZ2VcbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IGlwUmFuZ2U6IHN0cmluZztcbiAgICAgICAgLyoqXG4gICAgICAgICAqIFRoZSBuZXR3b3JrIGNvbW11bmljYXRpb24gcHJvdG9jb2wgdXNlZCBieSB0aGUgZmxlZXQuXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtZ2FtZWxpZnQtZmxlZXQtaXBwZXJtaXNzaW9uLmh0bWwjY2ZuLWdhbWVsaWZ0LWZsZWV0LWlwcGVybWlzc2lvbi1wcm90b2NvbFxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgcHJvdG9jb2w6IHN0cmluZztcbiAgICAgICAgLyoqXG4gICAgICAgICAqIEFuIGVuZGluZyB2YWx1ZSBmb3IgYSByYW5nZSBvZiBhbGxvd2VkIHBvcnQgbnVtYmVycy4gUG9ydCBudW1iZXJzIGFyZSBlbmQtaW5jbHVzaXZlLiBUaGlzIHZhbHVlIG11c3QgYmUgaGlnaGVyIHRoYW4gYEZyb21Qb3J0YCAuXG4gICAgICAgICAqXG4gICAgICAgICAqIEZvciBmbGVldHMgdXNpbmcgV2luZG93cyBhbmQgTGludXggYnVpbGRzLCBvbmx5IHBvcnRzIDEwMjYtNjAwMDAgYXJlIHZhbGlkLlxuICAgICAgICAgKlxuICAgICAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWdhbWVsaWZ0LWZsZWV0LWlwcGVybWlzc2lvbi5odG1sI2Nmbi1nYW1lbGlmdC1mbGVldC1pcHBlcm1pc3Npb24tdG9wb3J0XG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSB0b1BvcnQ6IG51bWJlcjtcbiAgICB9XG59XG5cbi8qKlxuICogRGV0ZXJtaW5lIHdoZXRoZXIgdGhlIGdpdmVuIHByb3BlcnRpZXMgbWF0Y2ggdGhvc2Ugb2YgYSBgSXBQZXJtaXNzaW9uUHJvcGVydHlgXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYElwUGVybWlzc2lvblByb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSByZXN1bHQgb2YgdGhlIHZhbGlkYXRpb24uXG4gKi9cbmZ1bmN0aW9uIENmbkZsZWV0X0lwUGVybWlzc2lvblByb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXM6IGFueSk6IGNkay5WYWxpZGF0aW9uUmVzdWx0IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBjZGsuVkFMSURBVElPTl9TVUNDRVNTOyB9XG4gICAgY29uc3QgZXJyb3JzID0gbmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0cygpO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgZXJyb3JzLmNvbGxlY3QobmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0KCdFeHBlY3RlZCBhbiBvYmplY3QsIGJ1dCByZWNlaXZlZDogJyArIEpTT04uc3RyaW5naWZ5KHByb3BlcnRpZXMpKSk7XG4gICAgfVxuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignZnJvbVBvcnQnLCBjZGsucmVxdWlyZWRWYWxpZGF0b3IpKHByb3BlcnRpZXMuZnJvbVBvcnQpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2Zyb21Qb3J0JywgY2RrLnZhbGlkYXRlTnVtYmVyKShwcm9wZXJ0aWVzLmZyb21Qb3J0KSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdpcFJhbmdlJywgY2RrLnJlcXVpcmVkVmFsaWRhdG9yKShwcm9wZXJ0aWVzLmlwUmFuZ2UpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2lwUmFuZ2UnLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuaXBSYW5nZSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigncHJvdG9jb2wnLCBjZGsucmVxdWlyZWRWYWxpZGF0b3IpKHByb3BlcnRpZXMucHJvdG9jb2wpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3Byb3RvY29sJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLnByb3RvY29sKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCd0b1BvcnQnLCBjZGsucmVxdWlyZWRWYWxpZGF0b3IpKHByb3BlcnRpZXMudG9Qb3J0KSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCd0b1BvcnQnLCBjZGsudmFsaWRhdGVOdW1iZXIpKHByb3BlcnRpZXMudG9Qb3J0KSk7XG4gICAgcmV0dXJuIGVycm9ycy53cmFwKCdzdXBwbGllZCBwcm9wZXJ0aWVzIG5vdCBjb3JyZWN0IGZvciBcIklwUGVybWlzc2lvblByb3BlcnR5XCInKTtcbn1cblxuLyoqXG4gKiBSZW5kZXJzIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpHYW1lTGlmdDo6RmxlZXQuSXBQZXJtaXNzaW9uYCByZXNvdXJjZVxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBJcFBlcm1pc3Npb25Qcm9wZXJ0eWBcbiAqXG4gKiBAcmV0dXJucyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6R2FtZUxpZnQ6OkZsZWV0LklwUGVybWlzc2lvbmAgcmVzb3VyY2UuXG4gKi9cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBjZm5GbGVldElwUGVybWlzc2lvblByb3BlcnR5VG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBhbnkge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIHByb3BlcnRpZXM7IH1cbiAgICBDZm5GbGVldF9JcFBlcm1pc3Npb25Qcm9wZXJ0eVZhbGlkYXRvcihwcm9wZXJ0aWVzKS5hc3NlcnRTdWNjZXNzKCk7XG4gICAgcmV0dXJuIHtcbiAgICAgICAgRnJvbVBvcnQ6IGNkay5udW1iZXJUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuZnJvbVBvcnQpLFxuICAgICAgICBJcFJhbmdlOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLmlwUmFuZ2UpLFxuICAgICAgICBQcm90b2NvbDogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5wcm90b2NvbCksXG4gICAgICAgIFRvUG9ydDogY2RrLm51bWJlclRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy50b1BvcnQpLFxuICAgIH07XG59XG5cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBDZm5GbGVldElwUGVybWlzc2lvblByb3BlcnR5RnJvbUNsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQ8Q2ZuRmxlZXQuSXBQZXJtaXNzaW9uUHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGU+IHtcbiAgICBpZiAoY2RrLmlzUmVzb2x2YWJsZU9iamVjdChwcm9wZXJ0aWVzKSkge1xuICAgICAgICByZXR1cm4gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQocHJvcGVydGllcyk7XG4gICAgfVxuICAgIHByb3BlcnRpZXMgPSBwcm9wZXJ0aWVzID09IG51bGwgPyB7fSA6IHByb3BlcnRpZXM7XG4gICAgaWYgKHR5cGVvZiBwcm9wZXJ0aWVzICE9PSAnb2JqZWN0Jykge1xuICAgICAgICByZXR1cm4gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQocHJvcGVydGllcyk7XG4gICAgfVxuICAgIGNvbnN0IHJldCA9IG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUHJvcGVydHlPYmplY3Q8Q2ZuRmxlZXQuSXBQZXJtaXNzaW9uUHJvcGVydHk+KCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdmcm9tUG9ydCcsICdGcm9tUG9ydCcsIGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0TnVtYmVyKHByb3BlcnRpZXMuRnJvbVBvcnQpKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2lwUmFuZ2UnLCAnSXBSYW5nZScsIGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuSXBSYW5nZSkpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgncHJvdG9jb2wnLCAnUHJvdG9jb2wnLCBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLlByb3RvY29sKSk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCd0b1BvcnQnLCAnVG9Qb3J0JywgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXROdW1iZXIocHJvcGVydGllcy5Ub1BvcnQpKTtcbiAgICByZXQuYWRkVW5yZWNvZ25pemVkUHJvcGVydGllc0FzRXh0cmEocHJvcGVydGllcyk7XG4gICAgcmV0dXJuIHJldDtcbn1cblxuZXhwb3J0IG5hbWVzcGFjZSBDZm5GbGVldCB7XG4gICAgLyoqXG4gICAgICogQ3VycmVudCByZXNvdXJjZSBjYXBhY2l0eSBzZXR0aW5ncyBpbiBhIHNwZWNpZmllZCBmbGVldCBvciBsb2NhdGlvbi4gVGhlIGxvY2F0aW9uIHZhbHVlIG1pZ2h0IHJlZmVyIHRvIGEgZmxlZXQncyByZW1vdGUgbG9jYXRpb24gb3IgaXRzIGhvbWUgUmVnaW9uLlxuICAgICAqXG4gICAgICogKlJlbGF0ZWQgYWN0aW9ucypcbiAgICAgKlxuICAgICAqIFtEZXNjcmliZUZsZWV0Q2FwYWNpdHldKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9nYW1lbGlmdC9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9EZXNjcmliZUZsZWV0Q2FwYWNpdHkuaHRtbCkgfCBbRGVzY3JpYmVGbGVldExvY2F0aW9uQ2FwYWNpdHldKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9nYW1lbGlmdC9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9EZXNjcmliZUZsZWV0TG9jYXRpb25DYXBhY2l0eS5odG1sKSB8IFtVcGRhdGVGbGVldENhcGFjaXR5XShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZ2FtZWxpZnQvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfVXBkYXRlRmxlZXRDYXBhY2l0eS5odG1sKVxuICAgICAqXG4gICAgICogQHN0cnVjdFxuICAgICAqIEBzdGFiaWxpdHkgZXh0ZXJuYWxcbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtZ2FtZWxpZnQtZmxlZXQtbG9jYXRpb25jYXBhY2l0eS5odG1sXG4gICAgICovXG4gICAgZXhwb3J0IGludGVyZmFjZSBMb2NhdGlvbkNhcGFjaXR5UHJvcGVydHkge1xuICAgICAgICAvKipcbiAgICAgICAgICogVGhlIG51bWJlciBvZiBBbWF6b24gRUMyIGluc3RhbmNlcyB5b3Ugd2FudCB0byBtYWludGFpbiBpbiB0aGUgc3BlY2lmaWVkIGZsZWV0IGxvY2F0aW9uLiBUaGlzIHZhbHVlIG11c3QgZmFsbCBiZXR3ZWVuIHRoZSBtaW5pbXVtIGFuZCBtYXhpbXVtIHNpemUgbGltaXRzLlxuICAgICAgICAgKlxuICAgICAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWdhbWVsaWZ0LWZsZWV0LWxvY2F0aW9uY2FwYWNpdHkuaHRtbCNjZm4tZ2FtZWxpZnQtZmxlZXQtbG9jYXRpb25jYXBhY2l0eS1kZXNpcmVkZWMyaW5zdGFuY2VzXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBkZXNpcmVkRWMySW5zdGFuY2VzOiBudW1iZXI7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBUaGUgbWF4aW11bSBudW1iZXIgb2YgaW5zdGFuY2VzIHRoYXQgYXJlIGFsbG93ZWQgaW4gdGhlIHNwZWNpZmllZCBmbGVldCBsb2NhdGlvbi4gSWYgdGhpcyBwYXJhbWV0ZXIgaXMgbm90IHNldCwgdGhlIGRlZmF1bHQgaXMgMS5cbiAgICAgICAgICpcbiAgICAgICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1nYW1lbGlmdC1mbGVldC1sb2NhdGlvbmNhcGFjaXR5Lmh0bWwjY2ZuLWdhbWVsaWZ0LWZsZWV0LWxvY2F0aW9uY2FwYWNpdHktbWF4c2l6ZVxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgbWF4U2l6ZTogbnVtYmVyO1xuICAgICAgICAvKipcbiAgICAgICAgICogVGhlIG1pbmltdW0gbnVtYmVyIG9mIGluc3RhbmNlcyB0aGF0IGFyZSBhbGxvd2VkIGluIHRoZSBzcGVjaWZpZWQgZmxlZXQgbG9jYXRpb24uIElmIHRoaXMgcGFyYW1ldGVyIGlzIG5vdCBzZXQsIHRoZSBkZWZhdWx0IGlzIDAuXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtZ2FtZWxpZnQtZmxlZXQtbG9jYXRpb25jYXBhY2l0eS5odG1sI2Nmbi1nYW1lbGlmdC1mbGVldC1sb2NhdGlvbmNhcGFjaXR5LW1pbnNpemVcbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IG1pblNpemU6IG51bWJlcjtcbiAgICB9XG59XG5cbi8qKlxuICogRGV0ZXJtaW5lIHdoZXRoZXIgdGhlIGdpdmVuIHByb3BlcnRpZXMgbWF0Y2ggdGhvc2Ugb2YgYSBgTG9jYXRpb25DYXBhY2l0eVByb3BlcnR5YFxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBMb2NhdGlvbkNhcGFjaXR5UHJvcGVydHlgXG4gKlxuICogQHJldHVybnMgdGhlIHJlc3VsdCBvZiB0aGUgdmFsaWRhdGlvbi5cbiAqL1xuZnVuY3Rpb24gQ2ZuRmxlZXRfTG9jYXRpb25DYXBhY2l0eVByb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXM6IGFueSk6IGNkay5WYWxpZGF0aW9uUmVzdWx0IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBjZGsuVkFMSURBVElPTl9TVUNDRVNTOyB9XG4gICAgY29uc3QgZXJyb3JzID0gbmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0cygpO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgZXJyb3JzLmNvbGxlY3QobmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0KCdFeHBlY3RlZCBhbiBvYmplY3QsIGJ1dCByZWNlaXZlZDogJyArIEpTT04uc3RyaW5naWZ5KHByb3BlcnRpZXMpKSk7XG4gICAgfVxuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignZGVzaXJlZEVjMkluc3RhbmNlcycsIGNkay5yZXF1aXJlZFZhbGlkYXRvcikocHJvcGVydGllcy5kZXNpcmVkRWMySW5zdGFuY2VzKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdkZXNpcmVkRWMySW5zdGFuY2VzJywgY2RrLnZhbGlkYXRlTnVtYmVyKShwcm9wZXJ0aWVzLmRlc2lyZWRFYzJJbnN0YW5jZXMpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ21heFNpemUnLCBjZGsucmVxdWlyZWRWYWxpZGF0b3IpKHByb3BlcnRpZXMubWF4U2l6ZSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignbWF4U2l6ZScsIGNkay52YWxpZGF0ZU51bWJlcikocHJvcGVydGllcy5tYXhTaXplKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdtaW5TaXplJywgY2RrLnJlcXVpcmVkVmFsaWRhdG9yKShwcm9wZXJ0aWVzLm1pblNpemUpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ21pblNpemUnLCBjZGsudmFsaWRhdGVOdW1iZXIpKHByb3BlcnRpZXMubWluU2l6ZSkpO1xuICAgIHJldHVybiBlcnJvcnMud3JhcCgnc3VwcGxpZWQgcHJvcGVydGllcyBub3QgY29ycmVjdCBmb3IgXCJMb2NhdGlvbkNhcGFjaXR5UHJvcGVydHlcIicpO1xufVxuXG4vKipcbiAqIFJlbmRlcnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OkdhbWVMaWZ0OjpGbGVldC5Mb2NhdGlvbkNhcGFjaXR5YCByZXNvdXJjZVxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBMb2NhdGlvbkNhcGFjaXR5UHJvcGVydHlgXG4gKlxuICogQHJldHVybnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OkdhbWVMaWZ0OjpGbGVldC5Mb2NhdGlvbkNhcGFjaXR5YCByZXNvdXJjZS5cbiAqL1xuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIGNmbkZsZWV0TG9jYXRpb25DYXBhY2l0eVByb3BlcnR5VG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBhbnkge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIHByb3BlcnRpZXM7IH1cbiAgICBDZm5GbGVldF9Mb2NhdGlvbkNhcGFjaXR5UHJvcGVydHlWYWxpZGF0b3IocHJvcGVydGllcykuYXNzZXJ0U3VjY2VzcygpO1xuICAgIHJldHVybiB7XG4gICAgICAgIERlc2lyZWRFQzJJbnN0YW5jZXM6IGNkay5udW1iZXJUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuZGVzaXJlZEVjMkluc3RhbmNlcyksXG4gICAgICAgIE1heFNpemU6IGNkay5udW1iZXJUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMubWF4U2l6ZSksXG4gICAgICAgIE1pblNpemU6IGNkay5udW1iZXJUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMubWluU2l6ZSksXG4gICAgfTtcbn1cblxuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIENmbkZsZWV0TG9jYXRpb25DYXBhY2l0eVByb3BlcnR5RnJvbUNsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQ8Q2ZuRmxlZXQuTG9jYXRpb25DYXBhY2l0eVByb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlPiB7XG4gICAgaWYgKGNkay5pc1Jlc29sdmFibGVPYmplY3QocHJvcGVydGllcykpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0KHByb3BlcnRpZXMpO1xuICAgIH1cbiAgICBwcm9wZXJ0aWVzID0gcHJvcGVydGllcyA9PSBudWxsID8ge30gOiBwcm9wZXJ0aWVzO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0KHByb3BlcnRpZXMpO1xuICAgIH1cbiAgICBjb25zdCByZXQgPSBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblByb3BlcnR5T2JqZWN0PENmbkZsZWV0LkxvY2F0aW9uQ2FwYWNpdHlQcm9wZXJ0eT4oKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2Rlc2lyZWRFYzJJbnN0YW5jZXMnLCAnRGVzaXJlZEVDMkluc3RhbmNlcycsIGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0TnVtYmVyKHByb3BlcnRpZXMuRGVzaXJlZEVDMkluc3RhbmNlcykpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnbWF4U2l6ZScsICdNYXhTaXplJywgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXROdW1iZXIocHJvcGVydGllcy5NYXhTaXplKSk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdtaW5TaXplJywgJ01pblNpemUnLCBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldE51bWJlcihwcm9wZXJ0aWVzLk1pblNpemUpKTtcbiAgICByZXQuYWRkVW5yZWNvZ25pemVkUHJvcGVydGllc0FzRXh0cmEocHJvcGVydGllcyk7XG4gICAgcmV0dXJuIHJldDtcbn1cblxuZXhwb3J0IG5hbWVzcGFjZSBDZm5GbGVldCB7XG4gICAgLyoqXG4gICAgICogQSByZW1vdGUgbG9jYXRpb24gd2hlcmUgYSBtdWx0aS1sb2NhdGlvbiBmbGVldCBjYW4gZGVwbG95IEVDMiBpbnN0YW5jZXMgZm9yIGdhbWUgaG9zdGluZy5cbiAgICAgKlxuICAgICAqICpSZWxhdGVkIGFjdGlvbnMqXG4gICAgICpcbiAgICAgKiBbQ3JlYXRlRmxlZXRdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9nYW1lbGlmdC9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9DcmVhdGVGbGVldC5odG1sKVxuICAgICAqXG4gICAgICogQHN0cnVjdFxuICAgICAqIEBzdGFiaWxpdHkgZXh0ZXJuYWxcbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtZ2FtZWxpZnQtZmxlZXQtbG9jYXRpb25jb25maWd1cmF0aW9uLmh0bWxcbiAgICAgKi9cbiAgICBleHBvcnQgaW50ZXJmYWNlIExvY2F0aW9uQ29uZmlndXJhdGlvblByb3BlcnR5IHtcbiAgICAgICAgLyoqXG4gICAgICAgICAqIEFuIEFXUyBSZWdpb24gY29kZSwgc3VjaCBhcyBgdXMtd2VzdC0yYCAuXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtZ2FtZWxpZnQtZmxlZXQtbG9jYXRpb25jb25maWd1cmF0aW9uLmh0bWwjY2ZuLWdhbWVsaWZ0LWZsZWV0LWxvY2F0aW9uY29uZmlndXJhdGlvbi1sb2NhdGlvblxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgbG9jYXRpb246IHN0cmluZztcbiAgICAgICAgLyoqXG4gICAgICAgICAqIEN1cnJlbnQgcmVzb3VyY2UgY2FwYWNpdHkgc2V0dGluZ3MgaW4gYSBzcGVjaWZpZWQgZmxlZXQgb3IgbG9jYXRpb24uIFRoZSBsb2NhdGlvbiB2YWx1ZSBtaWdodCByZWZlciB0byBhIGZsZWV0J3MgcmVtb3RlIGxvY2F0aW9uIG9yIGl0cyBob21lIFJlZ2lvbi5cbiAgICAgICAgICpcbiAgICAgICAgICogKlJlbGF0ZWQgYWN0aW9ucypcbiAgICAgICAgICpcbiAgICAgICAgICogW0Rlc2NyaWJlRmxlZXRDYXBhY2l0eV0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2dhbWVsaWZ0L2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX0Rlc2NyaWJlRmxlZXRDYXBhY2l0eS5odG1sKSB8IFtEZXNjcmliZUZsZWV0TG9jYXRpb25DYXBhY2l0eV0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2dhbWVsaWZ0L2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX0Rlc2NyaWJlRmxlZXRMb2NhdGlvbkNhcGFjaXR5Lmh0bWwpIHwgW1VwZGF0ZUZsZWV0Q2FwYWNpdHldKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9nYW1lbGlmdC9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9VcGRhdGVGbGVldENhcGFjaXR5Lmh0bWwpXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtZ2FtZWxpZnQtZmxlZXQtbG9jYXRpb25jb25maWd1cmF0aW9uLmh0bWwjY2ZuLWdhbWVsaWZ0LWZsZWV0LWxvY2F0aW9uY29uZmlndXJhdGlvbi1sb2NhdGlvbmNhcGFjaXR5XG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBsb2NhdGlvbkNhcGFjaXR5PzogQ2ZuRmxlZXQuTG9jYXRpb25DYXBhY2l0eVByb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlO1xuICAgIH1cbn1cblxuLyoqXG4gKiBEZXRlcm1pbmUgd2hldGhlciB0aGUgZ2l2ZW4gcHJvcGVydGllcyBtYXRjaCB0aG9zZSBvZiBhIGBMb2NhdGlvbkNvbmZpZ3VyYXRpb25Qcm9wZXJ0eWBcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgTG9jYXRpb25Db25maWd1cmF0aW9uUHJvcGVydHlgXG4gKlxuICogQHJldHVybnMgdGhlIHJlc3VsdCBvZiB0aGUgdmFsaWRhdGlvbi5cbiAqL1xuZnVuY3Rpb24gQ2ZuRmxlZXRfTG9jYXRpb25Db25maWd1cmF0aW9uUHJvcGVydHlWYWxpZGF0b3IocHJvcGVydGllczogYW55KTogY2RrLlZhbGlkYXRpb25SZXN1bHQge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIGNkay5WQUxJREFUSU9OX1NVQ0NFU1M7IH1cbiAgICBjb25zdCBlcnJvcnMgPSBuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHRzKCk7XG4gICAgaWYgKHR5cGVvZiBwcm9wZXJ0aWVzICE9PSAnb2JqZWN0Jykge1xuICAgICAgICBlcnJvcnMuY29sbGVjdChuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHQoJ0V4cGVjdGVkIGFuIG9iamVjdCwgYnV0IHJlY2VpdmVkOiAnICsgSlNPTi5zdHJpbmdpZnkocHJvcGVydGllcykpKTtcbiAgICB9XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdsb2NhdGlvbicsIGNkay5yZXF1aXJlZFZhbGlkYXRvcikocHJvcGVydGllcy5sb2NhdGlvbikpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignbG9jYXRpb24nLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMubG9jYXRpb24pKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2xvY2F0aW9uQ2FwYWNpdHknLCBDZm5GbGVldF9Mb2NhdGlvbkNhcGFjaXR5UHJvcGVydHlWYWxpZGF0b3IpKHByb3BlcnRpZXMubG9jYXRpb25DYXBhY2l0eSkpO1xuICAgIHJldHVybiBlcnJvcnMud3JhcCgnc3VwcGxpZWQgcHJvcGVydGllcyBub3QgY29ycmVjdCBmb3IgXCJMb2NhdGlvbkNvbmZpZ3VyYXRpb25Qcm9wZXJ0eVwiJyk7XG59XG5cbi8qKlxuICogUmVuZGVycyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6R2FtZUxpZnQ6OkZsZWV0LkxvY2F0aW9uQ29uZmlndXJhdGlvbmAgcmVzb3VyY2VcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgTG9jYXRpb25Db25maWd1cmF0aW9uUHJvcGVydHlgXG4gKlxuICogQHJldHVybnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OkdhbWVMaWZ0OjpGbGVldC5Mb2NhdGlvbkNvbmZpZ3VyYXRpb25gIHJlc291cmNlLlxuICovXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gY2ZuRmxlZXRMb2NhdGlvbkNvbmZpZ3VyYXRpb25Qcm9wZXJ0eVRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogYW55IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBwcm9wZXJ0aWVzOyB9XG4gICAgQ2ZuRmxlZXRfTG9jYXRpb25Db25maWd1cmF0aW9uUHJvcGVydHlWYWxpZGF0b3IocHJvcGVydGllcykuYXNzZXJ0U3VjY2VzcygpO1xuICAgIHJldHVybiB7XG4gICAgICAgIExvY2F0aW9uOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLmxvY2F0aW9uKSxcbiAgICAgICAgTG9jYXRpb25DYXBhY2l0eTogY2ZuRmxlZXRMb2NhdGlvbkNhcGFjaXR5UHJvcGVydHlUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMubG9jYXRpb25DYXBhY2l0eSksXG4gICAgfTtcbn1cblxuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIENmbkZsZWV0TG9jYXRpb25Db25maWd1cmF0aW9uUHJvcGVydHlGcm9tQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdDxDZm5GbGVldC5Mb2NhdGlvbkNvbmZpZ3VyYXRpb25Qcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZT4ge1xuICAgIGlmIChjZGsuaXNSZXNvbHZhYmxlT2JqZWN0KHByb3BlcnRpZXMpKSB7XG4gICAgICAgIHJldHVybiBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdChwcm9wZXJ0aWVzKTtcbiAgICB9XG4gICAgcHJvcGVydGllcyA9IHByb3BlcnRpZXMgPT0gbnVsbCA/IHt9IDogcHJvcGVydGllcztcbiAgICBpZiAodHlwZW9mIHByb3BlcnRpZXMgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIHJldHVybiBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdChwcm9wZXJ0aWVzKTtcbiAgICB9XG4gICAgY29uc3QgcmV0ID0gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25Qcm9wZXJ0eU9iamVjdDxDZm5GbGVldC5Mb2NhdGlvbkNvbmZpZ3VyYXRpb25Qcm9wZXJ0eT4oKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2xvY2F0aW9uJywgJ0xvY2F0aW9uJywgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5Mb2NhdGlvbikpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnbG9jYXRpb25DYXBhY2l0eScsICdMb2NhdGlvbkNhcGFjaXR5JywgcHJvcGVydGllcy5Mb2NhdGlvbkNhcGFjaXR5ICE9IG51bGwgPyBDZm5GbGVldExvY2F0aW9uQ2FwYWNpdHlQcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLkxvY2F0aW9uQ2FwYWNpdHkpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkVW5yZWNvZ25pemVkUHJvcGVydGllc0FzRXh0cmEocHJvcGVydGllcyk7XG4gICAgcmV0dXJuIHJldDtcbn1cblxuZXhwb3J0IG5hbWVzcGFjZSBDZm5GbGVldCB7XG4gICAgLyoqXG4gICAgICogQSBwb2xpY3kgdGhhdCBsaW1pdHMgdGhlIG51bWJlciBvZiBnYW1lIHNlc3Npb25zIGEgcGxheWVyIGNhbiBjcmVhdGUgb24gdGhlIHNhbWUgZmxlZXQuIFRoaXMgb3B0aW9uYWwgcG9saWN5IGdpdmVzIGdhbWUgb3duZXJzIGNvbnRyb2wgb3ZlciBob3cgcGxheWVycyBjYW4gY29uc3VtZSBhdmFpbGFibGUgZ2FtZSBzZXJ2ZXIgcmVzb3VyY2VzLiBBIHJlc291cmNlIGNyZWF0aW9uIHBvbGljeSBtYWtlcyB0aGUgZm9sbG93aW5nIHN0YXRlbWVudDogXCJBbiBpbmRpdmlkdWFsIHBsYXllciBjYW4gY3JlYXRlIGEgbWF4aW11bSBudW1iZXIgb2YgbmV3IGdhbWUgc2Vzc2lvbnMgd2l0aGluIGEgc3BlY2lmaWVkIHRpbWUgcGVyaW9kXCIuXG4gICAgICpcbiAgICAgKiBUaGUgcG9saWN5IGlzIGV2YWx1YXRlZCB3aGVuIGEgcGxheWVyIHRyaWVzIHRvIGNyZWF0ZSBhIG5ldyBnYW1lIHNlc3Npb24uIEZvciBleGFtcGxlLCBhc3N1bWUgeW91IGhhdmUgYSBwb2xpY3kgb2YgMTAgbmV3IGdhbWUgc2Vzc2lvbnMgYW5kIGEgdGltZSBwZXJpb2Qgb2YgNjAgbWludXRlcy4gT24gcmVjZWl2aW5nIGEgYENyZWF0ZUdhbWVTZXNzaW9uYCByZXF1ZXN0LCBBbWF6b24gR2FtZUxpZnQgY2hlY2tzIHRoYXQgdGhlIHBsYXllciAoaWRlbnRpZmllZCBieSBgQ3JlYXRvcklkYCApIGhhcyBjcmVhdGVkIGZld2VyIHRoYW4gMTAgZ2FtZSBzZXNzaW9ucyBpbiB0aGUgcGFzdCA2MCBtaW51dGVzLlxuICAgICAqXG4gICAgICogQHN0cnVjdFxuICAgICAqIEBzdGFiaWxpdHkgZXh0ZXJuYWxcbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtZ2FtZWxpZnQtZmxlZXQtcmVzb3VyY2VjcmVhdGlvbmxpbWl0cG9saWN5Lmh0bWxcbiAgICAgKi9cbiAgICBleHBvcnQgaW50ZXJmYWNlIFJlc291cmNlQ3JlYXRpb25MaW1pdFBvbGljeVByb3BlcnR5IHtcbiAgICAgICAgLyoqXG4gICAgICAgICAqIFRoZSBtYXhpbXVtIG51bWJlciBvZiBnYW1lIHNlc3Npb25zIHRoYXQgYW4gaW5kaXZpZHVhbCBjYW4gY3JlYXRlIGR1cmluZyB0aGUgcG9saWN5IHBlcmlvZC5cbiAgICAgICAgICpcbiAgICAgICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1nYW1lbGlmdC1mbGVldC1yZXNvdXJjZWNyZWF0aW9ubGltaXRwb2xpY3kuaHRtbCNjZm4tZ2FtZWxpZnQtZmxlZXQtcmVzb3VyY2VjcmVhdGlvbmxpbWl0cG9saWN5LW5ld2dhbWVzZXNzaW9uc3BlcmNyZWF0b3JcbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IG5ld0dhbWVTZXNzaW9uc1BlckNyZWF0b3I/OiBudW1iZXI7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBUaGUgdGltZSBzcGFuIHVzZWQgaW4gZXZhbHVhdGluZyB0aGUgcmVzb3VyY2UgY3JlYXRpb24gbGltaXQgcG9saWN5LlxuICAgICAgICAgKlxuICAgICAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWdhbWVsaWZ0LWZsZWV0LXJlc291cmNlY3JlYXRpb25saW1pdHBvbGljeS5odG1sI2Nmbi1nYW1lbGlmdC1mbGVldC1yZXNvdXJjZWNyZWF0aW9ubGltaXRwb2xpY3ktcG9saWN5cGVyaW9kaW5taW51dGVzXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBwb2xpY3lQZXJpb2RJbk1pbnV0ZXM/OiBudW1iZXI7XG4gICAgfVxufVxuXG4vKipcbiAqIERldGVybWluZSB3aGV0aGVyIHRoZSBnaXZlbiBwcm9wZXJ0aWVzIG1hdGNoIHRob3NlIG9mIGEgYFJlc291cmNlQ3JlYXRpb25MaW1pdFBvbGljeVByb3BlcnR5YFxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBSZXNvdXJjZUNyZWF0aW9uTGltaXRQb2xpY3lQcm9wZXJ0eWBcbiAqXG4gKiBAcmV0dXJucyB0aGUgcmVzdWx0IG9mIHRoZSB2YWxpZGF0aW9uLlxuICovXG5mdW5jdGlvbiBDZm5GbGVldF9SZXNvdXJjZUNyZWF0aW9uTGltaXRQb2xpY3lQcm9wZXJ0eVZhbGlkYXRvcihwcm9wZXJ0aWVzOiBhbnkpOiBjZGsuVmFsaWRhdGlvblJlc3VsdCB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gY2RrLlZBTElEQVRJT05fU1VDQ0VTUzsgfVxuICAgIGNvbnN0IGVycm9ycyA9IG5ldyBjZGsuVmFsaWRhdGlvblJlc3VsdHMoKTtcbiAgICBpZiAodHlwZW9mIHByb3BlcnRpZXMgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIGVycm9ycy5jb2xsZWN0KG5ldyBjZGsuVmFsaWRhdGlvblJlc3VsdCgnRXhwZWN0ZWQgYW4gb2JqZWN0LCBidXQgcmVjZWl2ZWQ6ICcgKyBKU09OLnN0cmluZ2lmeShwcm9wZXJ0aWVzKSkpO1xuICAgIH1cbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ25ld0dhbWVTZXNzaW9uc1BlckNyZWF0b3InLCBjZGsudmFsaWRhdGVOdW1iZXIpKHByb3BlcnRpZXMubmV3R2FtZVNlc3Npb25zUGVyQ3JlYXRvcikpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigncG9saWN5UGVyaW9kSW5NaW51dGVzJywgY2RrLnZhbGlkYXRlTnVtYmVyKShwcm9wZXJ0aWVzLnBvbGljeVBlcmlvZEluTWludXRlcykpO1xuICAgIHJldHVybiBlcnJvcnMud3JhcCgnc3VwcGxpZWQgcHJvcGVydGllcyBub3QgY29ycmVjdCBmb3IgXCJSZXNvdXJjZUNyZWF0aW9uTGltaXRQb2xpY3lQcm9wZXJ0eVwiJyk7XG59XG5cbi8qKlxuICogUmVuZGVycyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6R2FtZUxpZnQ6OkZsZWV0LlJlc291cmNlQ3JlYXRpb25MaW1pdFBvbGljeWAgcmVzb3VyY2VcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgUmVzb3VyY2VDcmVhdGlvbkxpbWl0UG9saWN5UHJvcGVydHlgXG4gKlxuICogQHJldHVybnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OkdhbWVMaWZ0OjpGbGVldC5SZXNvdXJjZUNyZWF0aW9uTGltaXRQb2xpY3lgIHJlc291cmNlLlxuICovXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gY2ZuRmxlZXRSZXNvdXJjZUNyZWF0aW9uTGltaXRQb2xpY3lQcm9wZXJ0eVRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogYW55IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBwcm9wZXJ0aWVzOyB9XG4gICAgQ2ZuRmxlZXRfUmVzb3VyY2VDcmVhdGlvbkxpbWl0UG9saWN5UHJvcGVydHlWYWxpZGF0b3IocHJvcGVydGllcykuYXNzZXJ0U3VjY2VzcygpO1xuICAgIHJldHVybiB7XG4gICAgICAgIE5ld0dhbWVTZXNzaW9uc1BlckNyZWF0b3I6IGNkay5udW1iZXJUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMubmV3R2FtZVNlc3Npb25zUGVyQ3JlYXRvciksXG4gICAgICAgIFBvbGljeVBlcmlvZEluTWludXRlczogY2RrLm51bWJlclRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5wb2xpY3lQZXJpb2RJbk1pbnV0ZXMpLFxuICAgIH07XG59XG5cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBDZm5GbGVldFJlc291cmNlQ3JlYXRpb25MaW1pdFBvbGljeVByb3BlcnR5RnJvbUNsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQ8Q2ZuRmxlZXQuUmVzb3VyY2VDcmVhdGlvbkxpbWl0UG9saWN5UHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGU+IHtcbiAgICBpZiAoY2RrLmlzUmVzb2x2YWJsZU9iamVjdChwcm9wZXJ0aWVzKSkge1xuICAgICAgICByZXR1cm4gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQocHJvcGVydGllcyk7XG4gICAgfVxuICAgIHByb3BlcnRpZXMgPSBwcm9wZXJ0aWVzID09IG51bGwgPyB7fSA6IHByb3BlcnRpZXM7XG4gICAgaWYgKHR5cGVvZiBwcm9wZXJ0aWVzICE9PSAnb2JqZWN0Jykge1xuICAgICAgICByZXR1cm4gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQocHJvcGVydGllcyk7XG4gICAgfVxuICAgIGNvbnN0IHJldCA9IG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUHJvcGVydHlPYmplY3Q8Q2ZuRmxlZXQuUmVzb3VyY2VDcmVhdGlvbkxpbWl0UG9saWN5UHJvcGVydHk+KCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCduZXdHYW1lU2Vzc2lvbnNQZXJDcmVhdG9yJywgJ05ld0dhbWVTZXNzaW9uc1BlckNyZWF0b3InLCBwcm9wZXJ0aWVzLk5ld0dhbWVTZXNzaW9uc1BlckNyZWF0b3IgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0TnVtYmVyKHByb3BlcnRpZXMuTmV3R2FtZVNlc3Npb25zUGVyQ3JlYXRvcikgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgncG9saWN5UGVyaW9kSW5NaW51dGVzJywgJ1BvbGljeVBlcmlvZEluTWludXRlcycsIHByb3BlcnRpZXMuUG9saWN5UGVyaW9kSW5NaW51dGVzICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldE51bWJlcihwcm9wZXJ0aWVzLlBvbGljeVBlcmlvZEluTWludXRlcykgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRVbnJlY29nbml6ZWRQcm9wZXJ0aWVzQXNFeHRyYShwcm9wZXJ0aWVzKTtcbiAgICByZXR1cm4gcmV0O1xufVxuXG5leHBvcnQgbmFtZXNwYWNlIENmbkZsZWV0IHtcbiAgICAvKipcbiAgICAgKiBBIGNvbGxlY3Rpb24gb2Ygc2VydmVyIHByb2Nlc3MgY29uZmlndXJhdGlvbnMgdGhhdCBkZXNjcmliZSB0aGUgc2V0IG9mIHByb2Nlc3NlcyB0byBydW4gb24gZWFjaCBpbnN0YW5jZSBpbiBhIGZsZWV0LiBTZXJ2ZXIgcHJvY2Vzc2VzIHJ1biBlaXRoZXIgYW4gZXhlY3V0YWJsZSBpbiBhIGN1c3RvbSBnYW1lIGJ1aWxkIG9yIGEgUmVhbHRpbWUgU2VydmVycyBzY3JpcHQuIEdhbWVMaWZ0IGxhdW5jaGVzIHRoZSBjb25maWd1cmVkIHByb2Nlc3NlcywgbWFuYWdlcyB0aGVpciBsaWZlIGN5Y2xlLCBhbmQgcmVwbGFjZXMgdGhlbSBhcyBuZWVkZWQuIEVhY2ggaW5zdGFuY2UgY2hlY2tzIHJlZ3VsYXJseSBmb3IgYW4gdXBkYXRlZCBydW50aW1lIGNvbmZpZ3VyYXRpb24uXG4gICAgICpcbiAgICAgKiBBIEdhbWVMaWZ0IGluc3RhbmNlIGlzIGxpbWl0ZWQgdG8gNTAgcHJvY2Vzc2VzIHJ1bm5pbmcgY29uY3VycmVudGx5LiBUbyBjYWxjdWxhdGUgdGhlIHRvdGFsIG51bWJlciBvZiBwcm9jZXNzZXMgaW4gYSBydW50aW1lIGNvbmZpZ3VyYXRpb24sIGFkZCB0aGUgdmFsdWVzIG9mIHRoZSBgQ29uY3VycmVudEV4ZWN1dGlvbnNgIHBhcmFtZXRlciBmb3IgZWFjaCBTZXJ2ZXJQcm9jZXNzLiBMZWFybiBtb3JlIGFib3V0IFtSdW5uaW5nIE11bHRpcGxlIFByb2Nlc3NlcyBvbiBhIEZsZWV0XShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZ2FtZWxpZnQvbGF0ZXN0L2RldmVsb3Blcmd1aWRlL2ZsZWV0cy1tdWx0aXByb2Nlc3MuaHRtbCkgLlxuICAgICAqXG4gICAgICogQHN0cnVjdFxuICAgICAqIEBzdGFiaWxpdHkgZXh0ZXJuYWxcbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtZ2FtZWxpZnQtZmxlZXQtcnVudGltZWNvbmZpZ3VyYXRpb24uaHRtbFxuICAgICAqL1xuICAgIGV4cG9ydCBpbnRlcmZhY2UgUnVudGltZUNvbmZpZ3VyYXRpb25Qcm9wZXJ0eSB7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBUaGUgbWF4aW11bSBhbW91bnQgb2YgdGltZSAoaW4gc2Vjb25kcykgYWxsb3dlZCB0byBsYXVuY2ggYSBuZXcgZ2FtZSBzZXNzaW9uIGFuZCBoYXZlIGl0IHJlcG9ydCByZWFkeSB0byBob3N0IHBsYXllcnMuIER1cmluZyB0aGlzIHRpbWUsIHRoZSBnYW1lIHNlc3Npb24gaXMgaW4gc3RhdHVzIGBBQ1RJVkFUSU5HYCAuIElmIHRoZSBnYW1lIHNlc3Npb24gZG9lcyBub3QgYmVjb21lIGFjdGl2ZSBiZWZvcmUgdGhlIHRpbWVvdXQsIGl0IGlzIGVuZGVkIGFuZCB0aGUgZ2FtZSBzZXNzaW9uIHN0YXR1cyBpcyBjaGFuZ2VkIHRvIGBURVJNSU5BVEVEYCAuXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtZ2FtZWxpZnQtZmxlZXQtcnVudGltZWNvbmZpZ3VyYXRpb24uaHRtbCNjZm4tZ2FtZWxpZnQtZmxlZXQtcnVudGltZWNvbmZpZ3VyYXRpb24tZ2FtZXNlc3Npb25hY3RpdmF0aW9udGltZW91dHNlY29uZHNcbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IGdhbWVTZXNzaW9uQWN0aXZhdGlvblRpbWVvdXRTZWNvbmRzPzogbnVtYmVyO1xuICAgICAgICAvKipcbiAgICAgICAgICogVGhlIG51bWJlciBvZiBnYW1lIHNlc3Npb25zIGluIHN0YXR1cyBgQUNUSVZBVElOR2AgdG8gYWxsb3cgb24gYW4gaW5zdGFuY2UuIFRoaXMgc2V0dGluZyBsaW1pdHMgdGhlIGluc3RhbmNlIHJlc291cmNlcyB0aGF0IGNhbiBiZSB1c2VkIGZvciBuZXcgZ2FtZSBhY3RpdmF0aW9ucyBhdCBhbnkgb25lIHRpbWUuXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtZ2FtZWxpZnQtZmxlZXQtcnVudGltZWNvbmZpZ3VyYXRpb24uaHRtbCNjZm4tZ2FtZWxpZnQtZmxlZXQtcnVudGltZWNvbmZpZ3VyYXRpb24tbWF4Y29uY3VycmVudGdhbWVzZXNzaW9uYWN0aXZhdGlvbnNcbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IG1heENvbmN1cnJlbnRHYW1lU2Vzc2lvbkFjdGl2YXRpb25zPzogbnVtYmVyO1xuICAgICAgICAvKipcbiAgICAgICAgICogQSBjb2xsZWN0aW9uIG9mIHNlcnZlciBwcm9jZXNzIGNvbmZpZ3VyYXRpb25zIHRoYXQgaWRlbnRpZnkgd2hhdCBzZXJ2ZXIgcHJvY2Vzc2VzIHRvIHJ1biBvbiBlYWNoIGluc3RhbmNlIGluIGEgZmxlZXQuXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtZ2FtZWxpZnQtZmxlZXQtcnVudGltZWNvbmZpZ3VyYXRpb24uaHRtbCNjZm4tZ2FtZWxpZnQtZmxlZXQtcnVudGltZWNvbmZpZ3VyYXRpb24tc2VydmVycHJvY2Vzc2VzXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBzZXJ2ZXJQcm9jZXNzZXM/OiBBcnJheTxDZm5GbGVldC5TZXJ2ZXJQcm9jZXNzUHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGU+IHwgY2RrLklSZXNvbHZhYmxlO1xuICAgIH1cbn1cblxuLyoqXG4gKiBEZXRlcm1pbmUgd2hldGhlciB0aGUgZ2l2ZW4gcHJvcGVydGllcyBtYXRjaCB0aG9zZSBvZiBhIGBSdW50aW1lQ29uZmlndXJhdGlvblByb3BlcnR5YFxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBSdW50aW1lQ29uZmlndXJhdGlvblByb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSByZXN1bHQgb2YgdGhlIHZhbGlkYXRpb24uXG4gKi9cbmZ1bmN0aW9uIENmbkZsZWV0X1J1bnRpbWVDb25maWd1cmF0aW9uUHJvcGVydHlWYWxpZGF0b3IocHJvcGVydGllczogYW55KTogY2RrLlZhbGlkYXRpb25SZXN1bHQge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIGNkay5WQUxJREFUSU9OX1NVQ0NFU1M7IH1cbiAgICBjb25zdCBlcnJvcnMgPSBuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHRzKCk7XG4gICAgaWYgKHR5cGVvZiBwcm9wZXJ0aWVzICE9PSAnb2JqZWN0Jykge1xuICAgICAgICBlcnJvcnMuY29sbGVjdChuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHQoJ0V4cGVjdGVkIGFuIG9iamVjdCwgYnV0IHJlY2VpdmVkOiAnICsgSlNPTi5zdHJpbmdpZnkocHJvcGVydGllcykpKTtcbiAgICB9XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdnYW1lU2Vzc2lvbkFjdGl2YXRpb25UaW1lb3V0U2Vjb25kcycsIGNkay52YWxpZGF0ZU51bWJlcikocHJvcGVydGllcy5nYW1lU2Vzc2lvbkFjdGl2YXRpb25UaW1lb3V0U2Vjb25kcykpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignbWF4Q29uY3VycmVudEdhbWVTZXNzaW9uQWN0aXZhdGlvbnMnLCBjZGsudmFsaWRhdGVOdW1iZXIpKHByb3BlcnRpZXMubWF4Q29uY3VycmVudEdhbWVTZXNzaW9uQWN0aXZhdGlvbnMpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3NlcnZlclByb2Nlc3NlcycsIGNkay5saXN0VmFsaWRhdG9yKENmbkZsZWV0X1NlcnZlclByb2Nlc3NQcm9wZXJ0eVZhbGlkYXRvcikpKHByb3BlcnRpZXMuc2VydmVyUHJvY2Vzc2VzKSk7XG4gICAgcmV0dXJuIGVycm9ycy53cmFwKCdzdXBwbGllZCBwcm9wZXJ0aWVzIG5vdCBjb3JyZWN0IGZvciBcIlJ1bnRpbWVDb25maWd1cmF0aW9uUHJvcGVydHlcIicpO1xufVxuXG4vKipcbiAqIFJlbmRlcnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OkdhbWVMaWZ0OjpGbGVldC5SdW50aW1lQ29uZmlndXJhdGlvbmAgcmVzb3VyY2VcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgUnVudGltZUNvbmZpZ3VyYXRpb25Qcm9wZXJ0eWBcbiAqXG4gKiBAcmV0dXJucyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6R2FtZUxpZnQ6OkZsZWV0LlJ1bnRpbWVDb25maWd1cmF0aW9uYCByZXNvdXJjZS5cbiAqL1xuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIGNmbkZsZWV0UnVudGltZUNvbmZpZ3VyYXRpb25Qcm9wZXJ0eVRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogYW55IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBwcm9wZXJ0aWVzOyB9XG4gICAgQ2ZuRmxlZXRfUnVudGltZUNvbmZpZ3VyYXRpb25Qcm9wZXJ0eVZhbGlkYXRvcihwcm9wZXJ0aWVzKS5hc3NlcnRTdWNjZXNzKCk7XG4gICAgcmV0dXJuIHtcbiAgICAgICAgR2FtZVNlc3Npb25BY3RpdmF0aW9uVGltZW91dFNlY29uZHM6IGNkay5udW1iZXJUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuZ2FtZVNlc3Npb25BY3RpdmF0aW9uVGltZW91dFNlY29uZHMpLFxuICAgICAgICBNYXhDb25jdXJyZW50R2FtZVNlc3Npb25BY3RpdmF0aW9uczogY2RrLm51bWJlclRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5tYXhDb25jdXJyZW50R2FtZVNlc3Npb25BY3RpdmF0aW9ucyksXG4gICAgICAgIFNlcnZlclByb2Nlc3NlczogY2RrLmxpc3RNYXBwZXIoY2ZuRmxlZXRTZXJ2ZXJQcm9jZXNzUHJvcGVydHlUb0Nsb3VkRm9ybWF0aW9uKShwcm9wZXJ0aWVzLnNlcnZlclByb2Nlc3NlcyksXG4gICAgfTtcbn1cblxuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIENmbkZsZWV0UnVudGltZUNvbmZpZ3VyYXRpb25Qcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0PENmbkZsZWV0LlJ1bnRpbWVDb25maWd1cmF0aW9uUHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGU+IHtcbiAgICBpZiAoY2RrLmlzUmVzb2x2YWJsZU9iamVjdChwcm9wZXJ0aWVzKSkge1xuICAgICAgICByZXR1cm4gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQocHJvcGVydGllcyk7XG4gICAgfVxuICAgIHByb3BlcnRpZXMgPSBwcm9wZXJ0aWVzID09IG51bGwgPyB7fSA6IHByb3BlcnRpZXM7XG4gICAgaWYgKHR5cGVvZiBwcm9wZXJ0aWVzICE9PSAnb2JqZWN0Jykge1xuICAgICAgICByZXR1cm4gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQocHJvcGVydGllcyk7XG4gICAgfVxuICAgIGNvbnN0IHJldCA9IG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUHJvcGVydHlPYmplY3Q8Q2ZuRmxlZXQuUnVudGltZUNvbmZpZ3VyYXRpb25Qcm9wZXJ0eT4oKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2dhbWVTZXNzaW9uQWN0aXZhdGlvblRpbWVvdXRTZWNvbmRzJywgJ0dhbWVTZXNzaW9uQWN0aXZhdGlvblRpbWVvdXRTZWNvbmRzJywgcHJvcGVydGllcy5HYW1lU2Vzc2lvbkFjdGl2YXRpb25UaW1lb3V0U2Vjb25kcyAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXROdW1iZXIocHJvcGVydGllcy5HYW1lU2Vzc2lvbkFjdGl2YXRpb25UaW1lb3V0U2Vjb25kcykgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnbWF4Q29uY3VycmVudEdhbWVTZXNzaW9uQWN0aXZhdGlvbnMnLCAnTWF4Q29uY3VycmVudEdhbWVTZXNzaW9uQWN0aXZhdGlvbnMnLCBwcm9wZXJ0aWVzLk1heENvbmN1cnJlbnRHYW1lU2Vzc2lvbkFjdGl2YXRpb25zICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldE51bWJlcihwcm9wZXJ0aWVzLk1heENvbmN1cnJlbnRHYW1lU2Vzc2lvbkFjdGl2YXRpb25zKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdzZXJ2ZXJQcm9jZXNzZXMnLCAnU2VydmVyUHJvY2Vzc2VzJywgcHJvcGVydGllcy5TZXJ2ZXJQcm9jZXNzZXMgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0QXJyYXkoQ2ZuRmxlZXRTZXJ2ZXJQcm9jZXNzUHJvcGVydHlGcm9tQ2xvdWRGb3JtYXRpb24pKHByb3BlcnRpZXMuU2VydmVyUHJvY2Vzc2VzKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFVucmVjb2duaXplZFByb3BlcnRpZXNBc0V4dHJhKHByb3BlcnRpZXMpO1xuICAgIHJldHVybiByZXQ7XG59XG5cbmV4cG9ydCBuYW1lc3BhY2UgQ2ZuRmxlZXQge1xuICAgIC8qKlxuICAgICAqIEEgc2V0IG9mIGluc3RydWN0aW9ucyBmb3IgbGF1bmNoaW5nIHNlcnZlciBwcm9jZXNzZXMgb24gZWFjaCBpbnN0YW5jZSBpbiBhIGZsZWV0LiBTZXJ2ZXIgcHJvY2Vzc2VzIHJ1biBlaXRoZXIgYW4gZXhlY3V0YWJsZSBpbiBhIGN1c3RvbSBnYW1lIGJ1aWxkIG9yIGEgUmVhbHRpbWUgU2VydmVycyBzY3JpcHQuXG4gICAgICpcbiAgICAgKiBAc3RydWN0XG4gICAgICogQHN0YWJpbGl0eSBleHRlcm5hbFxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1nYW1lbGlmdC1mbGVldC1zZXJ2ZXJwcm9jZXNzLmh0bWxcbiAgICAgKi9cbiAgICBleHBvcnQgaW50ZXJmYWNlIFNlcnZlclByb2Nlc3NQcm9wZXJ0eSB7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBUaGUgbnVtYmVyIG9mIHNlcnZlciBwcm9jZXNzZXMgdXNpbmcgdGhpcyBjb25maWd1cmF0aW9uIHRoYXQgcnVuIGNvbmN1cnJlbnRseSBvbiBlYWNoIGluc3RhbmNlLlxuICAgICAgICAgKlxuICAgICAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWdhbWVsaWZ0LWZsZWV0LXNlcnZlcnByb2Nlc3MuaHRtbCNjZm4tZ2FtZWxpZnQtZmxlZXQtc2VydmVycHJvY2Vzcy1jb25jdXJyZW50ZXhlY3V0aW9uc1xuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgY29uY3VycmVudEV4ZWN1dGlvbnM6IG51bWJlcjtcbiAgICAgICAgLyoqXG4gICAgICAgICAqIFRoZSBsb2NhdGlvbiBvZiBhIGdhbWUgYnVpbGQgZXhlY3V0YWJsZSBvciB0aGUgUmVhbHRpbWUgc2NyaXB0IGZpbGUgdGhhdCBjb250YWlucyB0aGUgYEluaXQoKWAgZnVuY3Rpb24uIEdhbWUgYnVpbGRzIGFuZCBSZWFsdGltZSBzY3JpcHRzIGFyZSBpbnN0YWxsZWQgb24gaW5zdGFuY2VzIGF0IHRoZSByb290OlxuICAgICAgICAgKlxuICAgICAgICAgKiAtIFdpbmRvd3MgKGN1c3RvbSBnYW1lIGJ1aWxkcyBvbmx5KTogYEM6XFxnYW1lYCAuIEV4YW1wbGU6IFwiIGBDOlxcZ2FtZVxcTXlHYW1lXFxzZXJ2ZXIuZXhlYCBcIlxuICAgICAgICAgKiAtIExpbnV4OiBgL2xvY2FsL2dhbWVgIC4gRXhhbXBsZXM6IFwiIGAvbG9jYWwvZ2FtZS9NeUdhbWUvc2VydmVyLmV4ZWAgXCIgb3IgXCIgYC9sb2NhbC9nYW1lL015UmVhbHRpbWVTY3JpcHQuanNgIFwiXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtZ2FtZWxpZnQtZmxlZXQtc2VydmVycHJvY2Vzcy5odG1sI2Nmbi1nYW1lbGlmdC1mbGVldC1zZXJ2ZXJwcm9jZXNzLWxhdW5jaHBhdGhcbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IGxhdW5jaFBhdGg6IHN0cmluZztcbiAgICAgICAgLyoqXG4gICAgICAgICAqIEFuIG9wdGlvbmFsIGxpc3Qgb2YgcGFyYW1ldGVycyB0byBwYXNzIHRvIHRoZSBzZXJ2ZXIgZXhlY3V0YWJsZSBvciBSZWFsdGltZSBzY3JpcHQgb24gbGF1bmNoLlxuICAgICAgICAgKlxuICAgICAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWdhbWVsaWZ0LWZsZWV0LXNlcnZlcnByb2Nlc3MuaHRtbCNjZm4tZ2FtZWxpZnQtZmxlZXQtc2VydmVycHJvY2Vzcy1wYXJhbWV0ZXJzXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBwYXJhbWV0ZXJzPzogc3RyaW5nO1xuICAgIH1cbn1cblxuLyoqXG4gKiBEZXRlcm1pbmUgd2hldGhlciB0aGUgZ2l2ZW4gcHJvcGVydGllcyBtYXRjaCB0aG9zZSBvZiBhIGBTZXJ2ZXJQcm9jZXNzUHJvcGVydHlgXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYFNlcnZlclByb2Nlc3NQcm9wZXJ0eWBcbiAqXG4gKiBAcmV0dXJucyB0aGUgcmVzdWx0IG9mIHRoZSB2YWxpZGF0aW9uLlxuICovXG5mdW5jdGlvbiBDZm5GbGVldF9TZXJ2ZXJQcm9jZXNzUHJvcGVydHlWYWxpZGF0b3IocHJvcGVydGllczogYW55KTogY2RrLlZhbGlkYXRpb25SZXN1bHQge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIGNkay5WQUxJREFUSU9OX1NVQ0NFU1M7IH1cbiAgICBjb25zdCBlcnJvcnMgPSBuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHRzKCk7XG4gICAgaWYgKHR5cGVvZiBwcm9wZXJ0aWVzICE9PSAnb2JqZWN0Jykge1xuICAgICAgICBlcnJvcnMuY29sbGVjdChuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHQoJ0V4cGVjdGVkIGFuIG9iamVjdCwgYnV0IHJlY2VpdmVkOiAnICsgSlNPTi5zdHJpbmdpZnkocHJvcGVydGllcykpKTtcbiAgICB9XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdjb25jdXJyZW50RXhlY3V0aW9ucycsIGNkay5yZXF1aXJlZFZhbGlkYXRvcikocHJvcGVydGllcy5jb25jdXJyZW50RXhlY3V0aW9ucykpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignY29uY3VycmVudEV4ZWN1dGlvbnMnLCBjZGsudmFsaWRhdGVOdW1iZXIpKHByb3BlcnRpZXMuY29uY3VycmVudEV4ZWN1dGlvbnMpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2xhdW5jaFBhdGgnLCBjZGsucmVxdWlyZWRWYWxpZGF0b3IpKHByb3BlcnRpZXMubGF1bmNoUGF0aCkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignbGF1bmNoUGF0aCcsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5sYXVuY2hQYXRoKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdwYXJhbWV0ZXJzJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLnBhcmFtZXRlcnMpKTtcbiAgICByZXR1cm4gZXJyb3JzLndyYXAoJ3N1cHBsaWVkIHByb3BlcnRpZXMgbm90IGNvcnJlY3QgZm9yIFwiU2VydmVyUHJvY2Vzc1Byb3BlcnR5XCInKTtcbn1cblxuLyoqXG4gKiBSZW5kZXJzIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpHYW1lTGlmdDo6RmxlZXQuU2VydmVyUHJvY2Vzc2AgcmVzb3VyY2VcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgU2VydmVyUHJvY2Vzc1Byb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpHYW1lTGlmdDo6RmxlZXQuU2VydmVyUHJvY2Vzc2AgcmVzb3VyY2UuXG4gKi9cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBjZm5GbGVldFNlcnZlclByb2Nlc3NQcm9wZXJ0eVRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogYW55IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBwcm9wZXJ0aWVzOyB9XG4gICAgQ2ZuRmxlZXRfU2VydmVyUHJvY2Vzc1Byb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXMpLmFzc2VydFN1Y2Nlc3MoKTtcbiAgICByZXR1cm4ge1xuICAgICAgICBDb25jdXJyZW50RXhlY3V0aW9uczogY2RrLm51bWJlclRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5jb25jdXJyZW50RXhlY3V0aW9ucyksXG4gICAgICAgIExhdW5jaFBhdGg6IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMubGF1bmNoUGF0aCksXG4gICAgICAgIFBhcmFtZXRlcnM6IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMucGFyYW1ldGVycyksXG4gICAgfTtcbn1cblxuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIENmbkZsZWV0U2VydmVyUHJvY2Vzc1Byb3BlcnR5RnJvbUNsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQ8Q2ZuRmxlZXQuU2VydmVyUHJvY2Vzc1Byb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlPiB7XG4gICAgaWYgKGNkay5pc1Jlc29sdmFibGVPYmplY3QocHJvcGVydGllcykpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0KHByb3BlcnRpZXMpO1xuICAgIH1cbiAgICBwcm9wZXJ0aWVzID0gcHJvcGVydGllcyA9PSBudWxsID8ge30gOiBwcm9wZXJ0aWVzO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0KHByb3BlcnRpZXMpO1xuICAgIH1cbiAgICBjb25zdCByZXQgPSBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblByb3BlcnR5T2JqZWN0PENmbkZsZWV0LlNlcnZlclByb2Nlc3NQcm9wZXJ0eT4oKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2NvbmN1cnJlbnRFeGVjdXRpb25zJywgJ0NvbmN1cnJlbnRFeGVjdXRpb25zJywgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXROdW1iZXIocHJvcGVydGllcy5Db25jdXJyZW50RXhlY3V0aW9ucykpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnbGF1bmNoUGF0aCcsICdMYXVuY2hQYXRoJywgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5MYXVuY2hQYXRoKSk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdwYXJhbWV0ZXJzJywgJ1BhcmFtZXRlcnMnLCBwcm9wZXJ0aWVzLlBhcmFtZXRlcnMgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuUGFyYW1ldGVycykgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRVbnJlY29nbml6ZWRQcm9wZXJ0aWVzQXNFeHRyYShwcm9wZXJ0aWVzKTtcbiAgICByZXR1cm4gcmV0O1xufVxuXG4vKipcbiAqIFByb3BlcnRpZXMgZm9yIGRlZmluaW5nIGEgYENmbkdhbWVTZXJ2ZXJHcm91cGBcbiAqXG4gKiBAc3RydWN0XG4gKiBAc3RhYmlsaXR5IGV4dGVybmFsXG4gKlxuICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZ2FtZWxpZnQtZ2FtZXNlcnZlcmdyb3VwLmh0bWxcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBDZm5HYW1lU2VydmVyR3JvdXBQcm9wcyB7XG5cbiAgICAvKipcbiAgICAgKiBBIGRldmVsb3Blci1kZWZpbmVkIGlkZW50aWZpZXIgZm9yIHRoZSBnYW1lIHNlcnZlciBncm91cC4gVGhlIG5hbWUgaXMgdW5pcXVlIGZvciBlYWNoIFJlZ2lvbiBpbiBlYWNoIEFXUyBhY2NvdW50LlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZ2FtZWxpZnQtZ2FtZXNlcnZlcmdyb3VwLmh0bWwjY2ZuLWdhbWVsaWZ0LWdhbWVzZXJ2ZXJncm91cC1nYW1lc2VydmVyZ3JvdXBuYW1lXG4gICAgICovXG4gICAgcmVhZG9ubHkgZ2FtZVNlcnZlckdyb3VwTmFtZTogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogVGhlIHNldCBvZiBBbWF6b24gRUMyIGluc3RhbmNlIHR5cGVzIHRoYXQgR2FtZUxpZnQgRmxlZXRJUSBjYW4gdXNlIHdoZW4gYmFsYW5jaW5nIGFuZCBhdXRvbWF0aWNhbGx5IHNjYWxpbmcgaW5zdGFuY2VzIGluIHRoZSBjb3JyZXNwb25kaW5nIEF1dG8gU2NhbGluZyBncm91cC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWdhbWVsaWZ0LWdhbWVzZXJ2ZXJncm91cC5odG1sI2Nmbi1nYW1lbGlmdC1nYW1lc2VydmVyZ3JvdXAtaW5zdGFuY2VkZWZpbml0aW9uc1xuICAgICAqL1xuICAgIHJlYWRvbmx5IGluc3RhbmNlRGVmaW5pdGlvbnM6IEFycmF5PENmbkdhbWVTZXJ2ZXJHcm91cC5JbnN0YW5jZURlZmluaXRpb25Qcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZT4gfCBjZGsuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgQW1hem9uIEVDMiBsYXVuY2ggdGVtcGxhdGUgdGhhdCBjb250YWlucyBjb25maWd1cmF0aW9uIHNldHRpbmdzIGFuZCBnYW1lIHNlcnZlciBjb2RlIHRvIGJlIGRlcGxveWVkIHRvIGFsbCBpbnN0YW5jZXMgaW4gdGhlIGdhbWUgc2VydmVyIGdyb3VwLiBZb3UgY2FuIHNwZWNpZnkgdGhlIHRlbXBsYXRlIHVzaW5nIGVpdGhlciB0aGUgdGVtcGxhdGUgbmFtZSBvciBJRC4gRm9yIGhlbHAgd2l0aCBjcmVhdGluZyBhIGxhdW5jaCB0ZW1wbGF0ZSwgc2VlIFtDcmVhdGluZyBhIExhdW5jaCBUZW1wbGF0ZSBmb3IgYW4gQXV0byBTY2FsaW5nIEdyb3VwXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vYXV0b3NjYWxpbmcvZWMyL3VzZXJndWlkZS9jcmVhdGUtbGF1bmNoLXRlbXBsYXRlLmh0bWwpIGluIHRoZSAqQW1hem9uIEVsYXN0aWMgQ29tcHV0ZSBDbG91ZCBBdXRvIFNjYWxpbmcgVXNlciBHdWlkZSogLiBBZnRlciB0aGUgQXV0byBTY2FsaW5nIGdyb3VwIGlzIGNyZWF0ZWQsIHVwZGF0ZSB0aGlzIHZhbHVlIGRpcmVjdGx5IGluIHRoZSBBdXRvIFNjYWxpbmcgZ3JvdXAgdXNpbmcgdGhlIEFXUyBjb25zb2xlIG9yIEFQSXMuXG4gICAgICpcbiAgICAgKiA+IElmIHlvdSBzcGVjaWZ5IG5ldHdvcmsgaW50ZXJmYWNlcyBpbiB5b3VyIGxhdW5jaCB0ZW1wbGF0ZSwgeW91IG11c3QgZXhwbGljaXRseSBzZXQgdGhlIHByb3BlcnR5IGBBc3NvY2lhdGVQdWJsaWNJcEFkZHJlc3NgIHRvIFwidHJ1ZVwiLiBJZiBubyBuZXR3b3JrIGludGVyZmFjZSBpcyBzcGVjaWZpZWQgaW4gdGhlIGxhdW5jaCB0ZW1wbGF0ZSwgR2FtZUxpZnQgRmxlZXRJUSB1c2VzIHlvdXIgYWNjb3VudCdzIGRlZmF1bHQgVlBDLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZ2FtZWxpZnQtZ2FtZXNlcnZlcmdyb3VwLmh0bWwjY2ZuLWdhbWVsaWZ0LWdhbWVzZXJ2ZXJncm91cC1sYXVuY2h0ZW1wbGF0ZVxuICAgICAqL1xuICAgIHJlYWRvbmx5IGxhdW5jaFRlbXBsYXRlOiBDZm5HYW1lU2VydmVyR3JvdXAuTGF1bmNoVGVtcGxhdGVQcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFRoZSBBbWF6b24gUmVzb3VyY2UgTmFtZSAoIFtBUk5dKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BbWF6b25TMy9sYXRlc3QvZGV2L3MzLWFybi1mb3JtYXQuaHRtbCkgKSBmb3IgYW4gSUFNIHJvbGUgdGhhdCBhbGxvd3MgQW1hem9uIEdhbWVMaWZ0IHRvIGFjY2VzcyB5b3VyIEFtYXpvbiBFQzIgQXV0byBTY2FsaW5nIGdyb3Vwcy5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWdhbWVsaWZ0LWdhbWVzZXJ2ZXJncm91cC5odG1sI2Nmbi1nYW1lbGlmdC1nYW1lc2VydmVyZ3JvdXAtcm9sZWFyblxuICAgICAqL1xuICAgIHJlYWRvbmx5IHJvbGVBcm46IHN0cmluZztcblxuICAgIC8qKlxuICAgICAqIENvbmZpZ3VyYXRpb24gc2V0dGluZ3MgdG8gZGVmaW5lIGEgc2NhbGluZyBwb2xpY3kgZm9yIHRoZSBBdXRvIFNjYWxpbmcgZ3JvdXAgdGhhdCBpcyBvcHRpbWl6ZWQgZm9yIGdhbWUgaG9zdGluZy4gVGhlIHNjYWxpbmcgcG9saWN5IHVzZXMgdGhlIG1ldHJpYyBgXCJQZXJjZW50VXRpbGl6ZWRHYW1lU2VydmVyc1wiYCB0byBtYWludGFpbiBhIGJ1ZmZlciBvZiBpZGxlIGdhbWUgc2VydmVycyB0aGF0IGNhbiBpbW1lZGlhdGVseSBhY2NvbW1vZGF0ZSBuZXcgZ2FtZXMgYW5kIHBsYXllcnMuIEFmdGVyIHRoZSBBdXRvIFNjYWxpbmcgZ3JvdXAgaXMgY3JlYXRlZCwgdXBkYXRlIHRoaXMgdmFsdWUgZGlyZWN0bHkgaW4gdGhlIEF1dG8gU2NhbGluZyBncm91cCB1c2luZyB0aGUgQVdTIGNvbnNvbGUgb3IgQVBJcy5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWdhbWVsaWZ0LWdhbWVzZXJ2ZXJncm91cC5odG1sI2Nmbi1nYW1lbGlmdC1nYW1lc2VydmVyZ3JvdXAtYXV0b3NjYWxpbmdwb2xpY3lcbiAgICAgKi9cbiAgICByZWFkb25seSBhdXRvU2NhbGluZ1BvbGljeT86IENmbkdhbWVTZXJ2ZXJHcm91cC5BdXRvU2NhbGluZ1BvbGljeVByb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogSW5kaWNhdGVzIGhvdyBHYW1lTGlmdCBGbGVldElRIGJhbGFuY2VzIHRoZSB1c2Ugb2YgU3BvdCBJbnN0YW5jZXMgYW5kIE9uLURlbWFuZCBJbnN0YW5jZXMgaW4gdGhlIGdhbWUgc2VydmVyIGdyb3VwLiBNZXRob2Qgb3B0aW9ucyBpbmNsdWRlIHRoZSBmb2xsb3dpbmc6XG4gICAgICpcbiAgICAgKiAtIGBTUE9UX09OTFlgIC0gT25seSBTcG90IEluc3RhbmNlcyBhcmUgdXNlZCBpbiB0aGUgZ2FtZSBzZXJ2ZXIgZ3JvdXAuIElmIFNwb3QgSW5zdGFuY2VzIGFyZSB1bmF2YWlsYWJsZSBvciBub3QgdmlhYmxlIGZvciBnYW1lIGhvc3RpbmcsIHRoZSBnYW1lIHNlcnZlciBncm91cCBwcm92aWRlcyBubyBob3N0aW5nIGNhcGFjaXR5IHVudGlsIFNwb3QgSW5zdGFuY2VzIGNhbiBhZ2FpbiBiZSB1c2VkLiBVbnRpbCB0aGVuLCBubyBuZXcgaW5zdGFuY2VzIGFyZSBzdGFydGVkLCBhbmQgdGhlIGV4aXN0aW5nIG5vbnZpYWJsZSBTcG90IEluc3RhbmNlcyBhcmUgdGVybWluYXRlZCAoYWZ0ZXIgY3VycmVudCBnYW1lcGxheSBlbmRzKSBhbmQgYXJlIG5vdCByZXBsYWNlZC5cbiAgICAgKiAtIGBTUE9UX1BSRUZFUlJFRGAgLSAoZGVmYXVsdCB2YWx1ZSkgU3BvdCBJbnN0YW5jZXMgYXJlIHVzZWQgd2hlbmV2ZXIgYXZhaWxhYmxlIGluIHRoZSBnYW1lIHNlcnZlciBncm91cC4gSWYgU3BvdCBJbnN0YW5jZXMgYXJlIHVuYXZhaWxhYmxlLCB0aGUgZ2FtZSBzZXJ2ZXIgZ3JvdXAgY29udGludWVzIHRvIHByb3ZpZGUgaG9zdGluZyBjYXBhY2l0eSBieSBmYWxsaW5nIGJhY2sgdG8gT24tRGVtYW5kIEluc3RhbmNlcy4gRXhpc3Rpbmcgbm9udmlhYmxlIFNwb3QgSW5zdGFuY2VzIGFyZSB0ZXJtaW5hdGVkIChhZnRlciBjdXJyZW50IGdhbWVwbGF5IGVuZHMpIGFuZCBhcmUgcmVwbGFjZWQgd2l0aCBuZXcgT24tRGVtYW5kIEluc3RhbmNlcy5cbiAgICAgKiAtIGBPTl9ERU1BTkRfT05MWWAgLSBPbmx5IE9uLURlbWFuZCBJbnN0YW5jZXMgYXJlIHVzZWQgaW4gdGhlIGdhbWUgc2VydmVyIGdyb3VwLiBObyBTcG90IEluc3RhbmNlcyBhcmUgdXNlZCwgZXZlbiB3aGVuIGF2YWlsYWJsZSwgd2hpbGUgdGhpcyBiYWxhbmNpbmcgc3RyYXRlZ3kgaXMgaW4gZm9yY2UuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1nYW1lbGlmdC1nYW1lc2VydmVyZ3JvdXAuaHRtbCNjZm4tZ2FtZWxpZnQtZ2FtZXNlcnZlcmdyb3VwLWJhbGFuY2luZ3N0cmF0ZWd5XG4gICAgICovXG4gICAgcmVhZG9ubHkgYmFsYW5jaW5nU3RyYXRlZ3k/OiBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgdHlwZSBvZiBkZWxldGUgdG8gcGVyZm9ybS4gVG8gZGVsZXRlIGEgZ2FtZSBzZXJ2ZXIgZ3JvdXAsIHNwZWNpZnkgdGhlIGBEZWxldGVPcHRpb25gIC4gT3B0aW9ucyBpbmNsdWRlIHRoZSBmb2xsb3dpbmc6XG4gICAgICpcbiAgICAgKiAtIGBTQUZFX0RFTEVURWAg4oCTIChkZWZhdWx0KSBUZXJtaW5hdGVzIHRoZSBnYW1lIHNlcnZlciBncm91cCBhbmQgQW1hem9uIEVDMiBBdXRvIFNjYWxpbmcgZ3JvdXAgb25seSB3aGVuIGl0IGhhcyBubyBnYW1lIHNlcnZlcnMgdGhhdCBhcmUgaW4gYFVUSUxJWkVEYCBzdGF0dXMuXG4gICAgICogLSBgRk9SQ0VfREVMRVRFYCDigJMgVGVybWluYXRlcyB0aGUgZ2FtZSBzZXJ2ZXIgZ3JvdXAsIGluY2x1ZGluZyBhbGwgYWN0aXZlIGdhbWUgc2VydmVycyByZWdhcmRsZXNzIG9mIHRoZWlyIHV0aWxpemF0aW9uIHN0YXR1cywgYW5kIHRoZSBBbWF6b24gRUMyIEF1dG8gU2NhbGluZyBncm91cC5cbiAgICAgKiAtIGBSRVRBSU5gIOKAkyBEb2VzIGEgc2FmZSBkZWxldGUgb2YgdGhlIGdhbWUgc2VydmVyIGdyb3VwIGJ1dCByZXRhaW5zIHRoZSBBbWF6b24gRUMyIEF1dG8gU2NhbGluZyBncm91cCBhcyBpcy5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWdhbWVsaWZ0LWdhbWVzZXJ2ZXJncm91cC5odG1sI2Nmbi1nYW1lbGlmdC1nYW1lc2VydmVyZ3JvdXAtZGVsZXRlb3B0aW9uXG4gICAgICovXG4gICAgcmVhZG9ubHkgZGVsZXRlT3B0aW9uPzogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogQSBmbGFnIHRoYXQgaW5kaWNhdGVzIHdoZXRoZXIgaW5zdGFuY2VzIGluIHRoZSBnYW1lIHNlcnZlciBncm91cCBhcmUgcHJvdGVjdGVkIGZyb20gZWFybHkgdGVybWluYXRpb24uIFVucHJvdGVjdGVkIGluc3RhbmNlcyB0aGF0IGhhdmUgYWN0aXZlIGdhbWUgc2VydmVycyBydW5uaW5nIG1pZ2h0IGJlIHRlcm1pbmF0ZWQgZHVyaW5nIGEgc2NhbGUtZG93biBldmVudCwgY2F1c2luZyBwbGF5ZXJzIHRvIGJlIGRyb3BwZWQgZnJvbSB0aGUgZ2FtZS4gUHJvdGVjdGVkIGluc3RhbmNlcyBjYW5ub3QgYmUgdGVybWluYXRlZCB3aGlsZSB0aGVyZSBhcmUgYWN0aXZlIGdhbWUgc2VydmVycyBydW5uaW5nIGV4Y2VwdCBpbiB0aGUgZXZlbnQgb2YgYSBmb3JjZWQgZ2FtZSBzZXJ2ZXIgZ3JvdXAgZGVsZXRpb24gKHNlZSApLiBBbiBleGNlcHRpb24gdG8gdGhpcyBpcyB3aXRoIFNwb3QgSW5zdGFuY2VzLCB3aGljaCBjYW4gYmUgdGVybWluYXRlZCBieSBBV1MgcmVnYXJkbGVzcyBvZiBwcm90ZWN0aW9uIHN0YXR1cy5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWdhbWVsaWZ0LWdhbWVzZXJ2ZXJncm91cC5odG1sI2Nmbi1nYW1lbGlmdC1nYW1lc2VydmVyZ3JvdXAtZ2FtZXNlcnZlcnByb3RlY3Rpb25wb2xpY3lcbiAgICAgKi9cbiAgICByZWFkb25seSBnYW1lU2VydmVyUHJvdGVjdGlvblBvbGljeT86IHN0cmluZztcblxuICAgIC8qKlxuICAgICAqIFRoZSBtYXhpbXVtIG51bWJlciBvZiBpbnN0YW5jZXMgYWxsb3dlZCBpbiB0aGUgQW1hem9uIEVDMiBBdXRvIFNjYWxpbmcgZ3JvdXAuIER1cmluZyBhdXRvbWF0aWMgc2NhbGluZyBldmVudHMsIEdhbWVMaWZ0IEZsZWV0SVEgYW5kIEVDMiBkbyBub3Qgc2NhbGUgdXAgdGhlIGdyb3VwIGFib3ZlIHRoaXMgbWF4aW11bS4gQWZ0ZXIgdGhlIEF1dG8gU2NhbGluZyBncm91cCBpcyBjcmVhdGVkLCB1cGRhdGUgdGhpcyB2YWx1ZSBkaXJlY3RseSBpbiB0aGUgQXV0byBTY2FsaW5nIGdyb3VwIHVzaW5nIHRoZSBBV1MgY29uc29sZSBvciBBUElzLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZ2FtZWxpZnQtZ2FtZXNlcnZlcmdyb3VwLmh0bWwjY2ZuLWdhbWVsaWZ0LWdhbWVzZXJ2ZXJncm91cC1tYXhzaXplXG4gICAgICovXG4gICAgcmVhZG9ubHkgbWF4U2l6ZT86IG51bWJlcjtcblxuICAgIC8qKlxuICAgICAqIFRoZSBtaW5pbXVtIG51bWJlciBvZiBpbnN0YW5jZXMgYWxsb3dlZCBpbiB0aGUgQW1hem9uIEVDMiBBdXRvIFNjYWxpbmcgZ3JvdXAuIER1cmluZyBhdXRvbWF0aWMgc2NhbGluZyBldmVudHMsIEdhbWVMaWZ0IEZsZWV0SVEgYW5kIEFtYXpvbiBFQzIgZG8gbm90IHNjYWxlIGRvd24gdGhlIGdyb3VwIGJlbG93IHRoaXMgbWluaW11bS4gSW4gcHJvZHVjdGlvbiwgdGhpcyB2YWx1ZSBzaG91bGQgYmUgc2V0IHRvIGF0IGxlYXN0IDEuIEFmdGVyIHRoZSBBdXRvIFNjYWxpbmcgZ3JvdXAgaXMgY3JlYXRlZCwgdXBkYXRlIHRoaXMgdmFsdWUgZGlyZWN0bHkgaW4gdGhlIEF1dG8gU2NhbGluZyBncm91cCB1c2luZyB0aGUgQVdTIGNvbnNvbGUgb3IgQVBJcy5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWdhbWVsaWZ0LWdhbWVzZXJ2ZXJncm91cC5odG1sI2Nmbi1nYW1lbGlmdC1nYW1lc2VydmVyZ3JvdXAtbWluc2l6ZVxuICAgICAqL1xuICAgIHJlYWRvbmx5IG1pblNpemU/OiBudW1iZXI7XG5cbiAgICAvKipcbiAgICAgKiBBIGxpc3Qgb2YgbGFiZWxzIHRvIGFzc2lnbiB0byB0aGUgbmV3IGdhbWUgc2VydmVyIGdyb3VwIHJlc291cmNlLiBUYWdzIGFyZSBkZXZlbG9wZXItZGVmaW5lZCBrZXktdmFsdWUgcGFpcnMuIFRhZ2dpbmcgQVdTIHJlc291cmNlcyBpcyB1c2VmdWwgZm9yIHJlc291cmNlIG1hbmFnZW1lbnQsIGFjY2VzcyBtYW5hZ2VtZW50LCBhbmQgY29zdCBhbGxvY2F0aW9uLiBGb3IgbW9yZSBpbmZvcm1hdGlvbiwgc2VlIFtUYWdnaW5nIEFXUyBSZXNvdXJjZXNdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9nZW5lcmFsL2xhdGVzdC9nci9hd3NfdGFnZ2luZy5odG1sKSBpbiB0aGUgKkFXUyBHZW5lcmFsIFJlZmVyZW5jZSogLiBPbmNlIHRoZSByZXNvdXJjZSBpcyBjcmVhdGVkLCB5b3UgY2FuIHVzZSBUYWdSZXNvdXJjZSwgVW50YWdSZXNvdXJjZSwgYW5kIExpc3RUYWdzRm9yUmVzb3VyY2UgdG8gYWRkLCByZW1vdmUsIGFuZCB2aWV3IHRhZ3MsIHJlc3BlY3RpdmVseS4gVGhlIG1heGltdW0gdGFnIGxpbWl0IG1heSBiZSBsb3dlciB0aGFuIHN0YXRlZC4gU2VlIHRoZSBBV1MgR2VuZXJhbCBSZWZlcmVuY2UgZm9yIGFjdHVhbCB0YWdnaW5nIGxpbWl0cy5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWdhbWVsaWZ0LWdhbWVzZXJ2ZXJncm91cC5odG1sI2Nmbi1nYW1lbGlmdC1nYW1lc2VydmVyZ3JvdXAtdGFnc1xuICAgICAqL1xuICAgIHJlYWRvbmx5IHRhZ3M/OiBjZGsuQ2ZuVGFnW107XG5cbiAgICAvKipcbiAgICAgKiBBIGxpc3Qgb2YgdmlydHVhbCBwcml2YXRlIGNsb3VkIChWUEMpIHN1Ym5ldHMgdG8gdXNlIHdpdGggaW5zdGFuY2VzIGluIHRoZSBnYW1lIHNlcnZlciBncm91cC4gQnkgZGVmYXVsdCwgYWxsIEdhbWVMaWZ0IEZsZWV0SVEtc3VwcG9ydGVkIEF2YWlsYWJpbGl0eSBab25lcyBhcmUgdXNlZC4gWW91IGNhbiB1c2UgdGhpcyBwYXJhbWV0ZXIgdG8gc3BlY2lmeSBWUENzIHRoYXQgeW91J3ZlIHNldCB1cC4gVGhpcyBwcm9wZXJ0eSBjYW5ub3QgYmUgdXBkYXRlZCBhZnRlciB0aGUgZ2FtZSBzZXJ2ZXIgZ3JvdXAgaXMgY3JlYXRlZCwgYW5kIHRoZSBjb3JyZXNwb25kaW5nIEF1dG8gU2NhbGluZyBncm91cCB3aWxsIGFsd2F5cyB1c2UgdGhlIHByb3BlcnR5IHZhbHVlIHRoYXQgaXMgc2V0IHdpdGggdGhpcyByZXF1ZXN0LCBldmVuIGlmIHRoZSBBdXRvIFNjYWxpbmcgZ3JvdXAgaXMgdXBkYXRlZCBkaXJlY3RseS5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWdhbWVsaWZ0LWdhbWVzZXJ2ZXJncm91cC5odG1sI2Nmbi1nYW1lbGlmdC1nYW1lc2VydmVyZ3JvdXAtdnBjc3VibmV0c1xuICAgICAqL1xuICAgIHJlYWRvbmx5IHZwY1N1Ym5ldHM/OiBzdHJpbmdbXTtcbn1cblxuLyoqXG4gKiBEZXRlcm1pbmUgd2hldGhlciB0aGUgZ2l2ZW4gcHJvcGVydGllcyBtYXRjaCB0aG9zZSBvZiBhIGBDZm5HYW1lU2VydmVyR3JvdXBQcm9wc2BcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgQ2ZuR2FtZVNlcnZlckdyb3VwUHJvcHNgXG4gKlxuICogQHJldHVybnMgdGhlIHJlc3VsdCBvZiB0aGUgdmFsaWRhdGlvbi5cbiAqL1xuZnVuY3Rpb24gQ2ZuR2FtZVNlcnZlckdyb3VwUHJvcHNWYWxpZGF0b3IocHJvcGVydGllczogYW55KTogY2RrLlZhbGlkYXRpb25SZXN1bHQge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIGNkay5WQUxJREFUSU9OX1NVQ0NFU1M7IH1cbiAgICBjb25zdCBlcnJvcnMgPSBuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHRzKCk7XG4gICAgaWYgKHR5cGVvZiBwcm9wZXJ0aWVzICE9PSAnb2JqZWN0Jykge1xuICAgICAgICBlcnJvcnMuY29sbGVjdChuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHQoJ0V4cGVjdGVkIGFuIG9iamVjdCwgYnV0IHJlY2VpdmVkOiAnICsgSlNPTi5zdHJpbmdpZnkocHJvcGVydGllcykpKTtcbiAgICB9XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdhdXRvU2NhbGluZ1BvbGljeScsIENmbkdhbWVTZXJ2ZXJHcm91cF9BdXRvU2NhbGluZ1BvbGljeVByb3BlcnR5VmFsaWRhdG9yKShwcm9wZXJ0aWVzLmF1dG9TY2FsaW5nUG9saWN5KSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdiYWxhbmNpbmdTdHJhdGVneScsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5iYWxhbmNpbmdTdHJhdGVneSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignZGVsZXRlT3B0aW9uJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmRlbGV0ZU9wdGlvbikpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignZ2FtZVNlcnZlckdyb3VwTmFtZScsIGNkay5yZXF1aXJlZFZhbGlkYXRvcikocHJvcGVydGllcy5nYW1lU2VydmVyR3JvdXBOYW1lKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdnYW1lU2VydmVyR3JvdXBOYW1lJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmdhbWVTZXJ2ZXJHcm91cE5hbWUpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2dhbWVTZXJ2ZXJQcm90ZWN0aW9uUG9saWN5JywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmdhbWVTZXJ2ZXJQcm90ZWN0aW9uUG9saWN5KSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdpbnN0YW5jZURlZmluaXRpb25zJywgY2RrLnJlcXVpcmVkVmFsaWRhdG9yKShwcm9wZXJ0aWVzLmluc3RhbmNlRGVmaW5pdGlvbnMpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2luc3RhbmNlRGVmaW5pdGlvbnMnLCBjZGsubGlzdFZhbGlkYXRvcihDZm5HYW1lU2VydmVyR3JvdXBfSW5zdGFuY2VEZWZpbml0aW9uUHJvcGVydHlWYWxpZGF0b3IpKShwcm9wZXJ0aWVzLmluc3RhbmNlRGVmaW5pdGlvbnMpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2xhdW5jaFRlbXBsYXRlJywgY2RrLnJlcXVpcmVkVmFsaWRhdG9yKShwcm9wZXJ0aWVzLmxhdW5jaFRlbXBsYXRlKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdsYXVuY2hUZW1wbGF0ZScsIENmbkdhbWVTZXJ2ZXJHcm91cF9MYXVuY2hUZW1wbGF0ZVByb3BlcnR5VmFsaWRhdG9yKShwcm9wZXJ0aWVzLmxhdW5jaFRlbXBsYXRlKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdtYXhTaXplJywgY2RrLnZhbGlkYXRlTnVtYmVyKShwcm9wZXJ0aWVzLm1heFNpemUpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ21pblNpemUnLCBjZGsudmFsaWRhdGVOdW1iZXIpKHByb3BlcnRpZXMubWluU2l6ZSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigncm9sZUFybicsIGNkay5yZXF1aXJlZFZhbGlkYXRvcikocHJvcGVydGllcy5yb2xlQXJuKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdyb2xlQXJuJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLnJvbGVBcm4pKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3RhZ3MnLCBjZGsubGlzdFZhbGlkYXRvcihjZGsudmFsaWRhdGVDZm5UYWcpKShwcm9wZXJ0aWVzLnRhZ3MpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3ZwY1N1Ym5ldHMnLCBjZGsubGlzdFZhbGlkYXRvcihjZGsudmFsaWRhdGVTdHJpbmcpKShwcm9wZXJ0aWVzLnZwY1N1Ym5ldHMpKTtcbiAgICByZXR1cm4gZXJyb3JzLndyYXAoJ3N1cHBsaWVkIHByb3BlcnRpZXMgbm90IGNvcnJlY3QgZm9yIFwiQ2ZuR2FtZVNlcnZlckdyb3VwUHJvcHNcIicpO1xufVxuXG4vKipcbiAqIFJlbmRlcnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OkdhbWVMaWZ0OjpHYW1lU2VydmVyR3JvdXBgIHJlc291cmNlXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYENmbkdhbWVTZXJ2ZXJHcm91cFByb3BzYFxuICpcbiAqIEByZXR1cm5zIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpHYW1lTGlmdDo6R2FtZVNlcnZlckdyb3VwYCByZXNvdXJjZS5cbiAqL1xuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIGNmbkdhbWVTZXJ2ZXJHcm91cFByb3BzVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBhbnkge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIHByb3BlcnRpZXM7IH1cbiAgICBDZm5HYW1lU2VydmVyR3JvdXBQcm9wc1ZhbGlkYXRvcihwcm9wZXJ0aWVzKS5hc3NlcnRTdWNjZXNzKCk7XG4gICAgcmV0dXJuIHtcbiAgICAgICAgR2FtZVNlcnZlckdyb3VwTmFtZTogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5nYW1lU2VydmVyR3JvdXBOYW1lKSxcbiAgICAgICAgSW5zdGFuY2VEZWZpbml0aW9uczogY2RrLmxpc3RNYXBwZXIoY2ZuR2FtZVNlcnZlckdyb3VwSW5zdGFuY2VEZWZpbml0aW9uUHJvcGVydHlUb0Nsb3VkRm9ybWF0aW9uKShwcm9wZXJ0aWVzLmluc3RhbmNlRGVmaW5pdGlvbnMpLFxuICAgICAgICBMYXVuY2hUZW1wbGF0ZTogY2ZuR2FtZVNlcnZlckdyb3VwTGF1bmNoVGVtcGxhdGVQcm9wZXJ0eVRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5sYXVuY2hUZW1wbGF0ZSksXG4gICAgICAgIFJvbGVBcm46IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMucm9sZUFybiksXG4gICAgICAgIEF1dG9TY2FsaW5nUG9saWN5OiBjZm5HYW1lU2VydmVyR3JvdXBBdXRvU2NhbGluZ1BvbGljeVByb3BlcnR5VG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLmF1dG9TY2FsaW5nUG9saWN5KSxcbiAgICAgICAgQmFsYW5jaW5nU3RyYXRlZ3k6IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuYmFsYW5jaW5nU3RyYXRlZ3kpLFxuICAgICAgICBEZWxldGVPcHRpb246IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuZGVsZXRlT3B0aW9uKSxcbiAgICAgICAgR2FtZVNlcnZlclByb3RlY3Rpb25Qb2xpY3k6IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuZ2FtZVNlcnZlclByb3RlY3Rpb25Qb2xpY3kpLFxuICAgICAgICBNYXhTaXplOiBjZGsubnVtYmVyVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLm1heFNpemUpLFxuICAgICAgICBNaW5TaXplOiBjZGsubnVtYmVyVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLm1pblNpemUpLFxuICAgICAgICBUYWdzOiBjZGsubGlzdE1hcHBlcihjZGsuY2ZuVGFnVG9DbG91ZEZvcm1hdGlvbikocHJvcGVydGllcy50YWdzKSxcbiAgICAgICAgVnBjU3VibmV0czogY2RrLmxpc3RNYXBwZXIoY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24pKHByb3BlcnRpZXMudnBjU3VibmV0cyksXG4gICAgfTtcbn1cblxuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIENmbkdhbWVTZXJ2ZXJHcm91cFByb3BzRnJvbUNsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQ8Q2ZuR2FtZVNlcnZlckdyb3VwUHJvcHM+IHtcbiAgICBwcm9wZXJ0aWVzID0gcHJvcGVydGllcyA9PSBudWxsID8ge30gOiBwcm9wZXJ0aWVzO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0KHByb3BlcnRpZXMpO1xuICAgIH1cbiAgICBjb25zdCByZXQgPSBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblByb3BlcnR5T2JqZWN0PENmbkdhbWVTZXJ2ZXJHcm91cFByb3BzPigpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnZ2FtZVNlcnZlckdyb3VwTmFtZScsICdHYW1lU2VydmVyR3JvdXBOYW1lJywgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5HYW1lU2VydmVyR3JvdXBOYW1lKSk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdpbnN0YW5jZURlZmluaXRpb25zJywgJ0luc3RhbmNlRGVmaW5pdGlvbnMnLCBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldEFycmF5KENmbkdhbWVTZXJ2ZXJHcm91cEluc3RhbmNlRGVmaW5pdGlvblByb3BlcnR5RnJvbUNsb3VkRm9ybWF0aW9uKShwcm9wZXJ0aWVzLkluc3RhbmNlRGVmaW5pdGlvbnMpKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2xhdW5jaFRlbXBsYXRlJywgJ0xhdW5jaFRlbXBsYXRlJywgQ2ZuR2FtZVNlcnZlckdyb3VwTGF1bmNoVGVtcGxhdGVQcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLkxhdW5jaFRlbXBsYXRlKSk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdyb2xlQXJuJywgJ1JvbGVBcm4nLCBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLlJvbGVBcm4pKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2F1dG9TY2FsaW5nUG9saWN5JywgJ0F1dG9TY2FsaW5nUG9saWN5JywgcHJvcGVydGllcy5BdXRvU2NhbGluZ1BvbGljeSAhPSBudWxsID8gQ2ZuR2FtZVNlcnZlckdyb3VwQXV0b1NjYWxpbmdQb2xpY3lQcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLkF1dG9TY2FsaW5nUG9saWN5KSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdiYWxhbmNpbmdTdHJhdGVneScsICdCYWxhbmNpbmdTdHJhdGVneScsIHByb3BlcnRpZXMuQmFsYW5jaW5nU3RyYXRlZ3kgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuQmFsYW5jaW5nU3RyYXRlZ3kpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2RlbGV0ZU9wdGlvbicsICdEZWxldGVPcHRpb24nLCBwcm9wZXJ0aWVzLkRlbGV0ZU9wdGlvbiAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5EZWxldGVPcHRpb24pIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2dhbWVTZXJ2ZXJQcm90ZWN0aW9uUG9saWN5JywgJ0dhbWVTZXJ2ZXJQcm90ZWN0aW9uUG9saWN5JywgcHJvcGVydGllcy5HYW1lU2VydmVyUHJvdGVjdGlvblBvbGljeSAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5HYW1lU2VydmVyUHJvdGVjdGlvblBvbGljeSkgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnbWF4U2l6ZScsICdNYXhTaXplJywgcHJvcGVydGllcy5NYXhTaXplICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldE51bWJlcihwcm9wZXJ0aWVzLk1heFNpemUpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ21pblNpemUnLCAnTWluU2l6ZScsIHByb3BlcnRpZXMuTWluU2l6ZSAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXROdW1iZXIocHJvcGVydGllcy5NaW5TaXplKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCd0YWdzJywgJ1RhZ3MnLCBwcm9wZXJ0aWVzLlRhZ3MgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0QXJyYXkoY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRDZm5UYWcpKHByb3BlcnRpZXMuVGFncykgOiB1bmRlZmluZWQgYXMgYW55KTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ3ZwY1N1Ym5ldHMnLCAnVnBjU3VibmV0cycsIHByb3BlcnRpZXMuVnBjU3VibmV0cyAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmdBcnJheShwcm9wZXJ0aWVzLlZwY1N1Ym5ldHMpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkVW5yZWNvZ25pemVkUHJvcGVydGllc0FzRXh0cmEocHJvcGVydGllcyk7XG4gICAgcmV0dXJuIHJldDtcbn1cblxuLyoqXG4gKiBBIENsb3VkRm9ybWF0aW9uIGBBV1M6OkdhbWVMaWZ0OjpHYW1lU2VydmVyR3JvdXBgXG4gKlxuICogKlRoaXMgb3BlcmF0aW9uIGlzIHVzZWQgd2l0aCB0aGUgQW1hem9uIEdhbWVMaWZ0IEZsZWV0SVEgc29sdXRpb24gYW5kIGdhbWUgc2VydmVyIGdyb3Vwcy4qXG4gKlxuICogQ3JlYXRlcyBhIEdhbWVMaWZ0IEZsZWV0SVEgZ2FtZSBzZXJ2ZXIgZ3JvdXAgZm9yIG1hbmFnaW5nIGdhbWUgaG9zdGluZyBvbiBhIGNvbGxlY3Rpb24gb2YgQW1hem9uIEVDMiBpbnN0YW5jZXMgZm9yIGdhbWUgaG9zdGluZy4gVGhpcyBvcGVyYXRpb24gY3JlYXRlcyB0aGUgZ2FtZSBzZXJ2ZXIgZ3JvdXAsIGNyZWF0ZXMgYW4gQXV0byBTY2FsaW5nIGdyb3VwIGluIHlvdXIgQVdTIGFjY291bnQgLCBhbmQgZXN0YWJsaXNoZXMgYSBsaW5rIGJldHdlZW4gdGhlIHR3byBncm91cHMuIFlvdSBjYW4gdmlldyB0aGUgc3RhdHVzIG9mIHlvdXIgZ2FtZSBzZXJ2ZXIgZ3JvdXBzIGluIHRoZSBHYW1lTGlmdCBjb25zb2xlLiBHYW1lIHNlcnZlciBncm91cCBtZXRyaWNzIGFuZCBldmVudHMgYXJlIGVtaXR0ZWQgdG8gQW1hem9uIENsb3VkV2F0Y2guXG4gKlxuICogQmVmb3JlIGNyZWF0aW5nIGEgbmV3IGdhbWUgc2VydmVyIGdyb3VwLCB5b3UgbXVzdCBoYXZlIHRoZSBmb2xsb3dpbmc6XG4gKlxuICogLSBBbiBBbWF6b24gRUMyIGxhdW5jaCB0ZW1wbGF0ZSB0aGF0IHNwZWNpZmllcyBob3cgdG8gbGF1bmNoIEFtYXpvbiBFQzIgaW5zdGFuY2VzIHdpdGggeW91ciBnYW1lIHNlcnZlciBidWlsZC4gRm9yIG1vcmUgaW5mb3JtYXRpb24sIHNlZSBbTGF1bmNoaW5nIGFuIEluc3RhbmNlIGZyb20gYSBMYXVuY2ggVGVtcGxhdGVdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NFQzIvbGF0ZXN0L1VzZXJHdWlkZS9lYzItbGF1bmNoLXRlbXBsYXRlcy5odG1sKSBpbiB0aGUgKkFtYXpvbiBFQzIgVXNlciBHdWlkZSogLlxuICogLSBBbiBJQU0gcm9sZSB0aGF0IGV4dGVuZHMgbGltaXRlZCBhY2Nlc3MgdG8geW91ciBBV1MgYWNjb3VudCB0byBhbGxvdyBHYW1lTGlmdCBGbGVldElRIHRvIGNyZWF0ZSBhbmQgaW50ZXJhY3Qgd2l0aCB0aGUgQXV0byBTY2FsaW5nIGdyb3VwLiBGb3IgbW9yZSBpbmZvcm1hdGlvbiwgc2VlIFtDcmVhdGUgSUFNIHJvbGVzIGZvciBjcm9zcy1zZXJ2aWNlIGludGVyYWN0aW9uXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZ2FtZWxpZnQvbGF0ZXN0L2ZsZWV0aXFndWlkZS9nc2ctaWFtLXBlcm1pc3Npb25zLXJvbGVzLmh0bWwpIGluIHRoZSAqR2FtZUxpZnQgRmxlZXRJUSBEZXZlbG9wZXIgR3VpZGUqIC5cbiAqXG4gKiBUbyBjcmVhdGUgYSBuZXcgZ2FtZSBzZXJ2ZXIgZ3JvdXAsIHNwZWNpZnkgYSB1bmlxdWUgZ3JvdXAgbmFtZSwgSUFNIHJvbGUgYW5kIEFtYXpvbiBFQzIgbGF1bmNoIHRlbXBsYXRlLCBhbmQgcHJvdmlkZSBhIGxpc3Qgb2YgaW5zdGFuY2UgdHlwZXMgdGhhdCBjYW4gYmUgdXNlZCBpbiB0aGUgZ3JvdXAuIFlvdSBtdXN0IGFsc28gc2V0IGluaXRpYWwgbWF4aW11bSBhbmQgbWluaW11bSBsaW1pdHMgb24gdGhlIGdyb3VwJ3MgaW5zdGFuY2UgY291bnQuIFlvdSBjYW4gb3B0aW9uYWxseSBzZXQgYW4gQXV0byBTY2FsaW5nIHBvbGljeSB3aXRoIHRhcmdldCB0cmFja2luZyBiYXNlZCBvbiBhIEdhbWVMaWZ0IEZsZWV0SVEgbWV0cmljLlxuICpcbiAqIE9uY2UgdGhlIGdhbWUgc2VydmVyIGdyb3VwIGFuZCBjb3JyZXNwb25kaW5nIEF1dG8gU2NhbGluZyBncm91cCBhcmUgY3JlYXRlZCwgeW91IGhhdmUgZnVsbCBhY2Nlc3MgdG8gY2hhbmdlIHRoZSBBdXRvIFNjYWxpbmcgZ3JvdXAncyBjb25maWd1cmF0aW9uIGFzIG5lZWRlZC4gU2V2ZXJhbCBwcm9wZXJ0aWVzIHRoYXQgYXJlIHNldCB3aGVuIGNyZWF0aW5nIGEgZ2FtZSBzZXJ2ZXIgZ3JvdXAsIGluY2x1ZGluZyBtYXhpbXVtL21pbmltdW0gc2l6ZSBhbmQgYXV0by1zY2FsaW5nIHBvbGljeSBzZXR0aW5ncywgbXVzdCBiZSB1cGRhdGVkIGRpcmVjdGx5IGluIHRoZSBBdXRvIFNjYWxpbmcgZ3JvdXAuIEtlZXAgaW4gbWluZCB0aGF0IHNvbWUgQXV0byBTY2FsaW5nIGdyb3VwIHByb3BlcnRpZXMgYXJlIHBlcmlvZGljYWxseSB1cGRhdGVkIGJ5IEdhbWVMaWZ0IEZsZWV0SVEgYXMgcGFydCBvZiBpdHMgYmFsYW5jaW5nIGFjdGl2aXRpZXMgdG8gb3B0aW1pemUgZm9yIGF2YWlsYWJpbGl0eSBhbmQgY29zdC5cbiAqXG4gKiAqTGVhcm4gbW9yZSpcbiAqXG4gKiBbR2FtZUxpZnQgRmxlZXRJUSBHdWlkZV0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2dhbWVsaWZ0L2xhdGVzdC9mbGVldGlxZ3VpZGUvZ3NnLWludHJvLmh0bWwpXG4gKlxuICogQGNsb3VkZm9ybWF0aW9uUmVzb3VyY2UgQVdTOjpHYW1lTGlmdDo6R2FtZVNlcnZlckdyb3VwXG4gKiBAc3RhYmlsaXR5IGV4dGVybmFsXG4gKlxuICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZ2FtZWxpZnQtZ2FtZXNlcnZlcmdyb3VwLmh0bWxcbiAqL1xuZXhwb3J0IGNsYXNzIENmbkdhbWVTZXJ2ZXJHcm91cCBleHRlbmRzIGNkay5DZm5SZXNvdXJjZSBpbXBsZW1lbnRzIGNkay5JSW5zcGVjdGFibGUge1xuICAgIC8qKlxuICAgICAqIFRoZSBDbG91ZEZvcm1hdGlvbiByZXNvdXJjZSB0eXBlIG5hbWUgZm9yIHRoaXMgcmVzb3VyY2UgY2xhc3MuXG4gICAgICovXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBDRk5fUkVTT1VSQ0VfVFlQRV9OQU1FID0gXCJBV1M6OkdhbWVMaWZ0OjpHYW1lU2VydmVyR3JvdXBcIjtcblxuICAgIC8qKlxuICAgICAqIEEgZmFjdG9yeSBtZXRob2QgdGhhdCBjcmVhdGVzIGEgbmV3IGluc3RhbmNlIG9mIHRoaXMgY2xhc3MgZnJvbSBhbiBvYmplY3RcbiAgICAgKiBjb250YWluaW5nIHRoZSBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIHRoaXMgcmVzb3VyY2UuXG4gICAgICogVXNlZCBpbiB0aGUgQGF3cy1jZGsvY2xvdWRmb3JtYXRpb24taW5jbHVkZSBtb2R1bGUuXG4gICAgICpcbiAgICAgKiBAaW50ZXJuYWxcbiAgICAgKi9cbiAgICBwdWJsaWMgc3RhdGljIF9mcm9tQ2xvdWRGb3JtYXRpb24oc2NvcGU6IGNkay5Db25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHJlc291cmNlQXR0cmlidXRlczogYW55LCBvcHRpb25zOiBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uT3B0aW9ucyk6IENmbkdhbWVTZXJ2ZXJHcm91cCB7XG4gICAgICAgIHJlc291cmNlQXR0cmlidXRlcyA9IHJlc291cmNlQXR0cmlidXRlcyB8fCB7fTtcbiAgICAgICAgY29uc3QgcmVzb3VyY2VQcm9wZXJ0aWVzID0gb3B0aW9ucy5wYXJzZXIucGFyc2VWYWx1ZShyZXNvdXJjZUF0dHJpYnV0ZXMuUHJvcGVydGllcyk7XG4gICAgICAgIGNvbnN0IHByb3BzUmVzdWx0ID0gQ2ZuR2FtZVNlcnZlckdyb3VwUHJvcHNGcm9tQ2xvdWRGb3JtYXRpb24ocmVzb3VyY2VQcm9wZXJ0aWVzKTtcbiAgICAgICAgY29uc3QgcmV0ID0gbmV3IENmbkdhbWVTZXJ2ZXJHcm91cChzY29wZSwgaWQsIHByb3BzUmVzdWx0LnZhbHVlKTtcbiAgICAgICAgZm9yIChjb25zdCBbcHJvcEtleSwgcHJvcFZhbF0gb2YgT2JqZWN0LmVudHJpZXMocHJvcHNSZXN1bHQuZXh0cmFQcm9wZXJ0aWVzKSkgIHtcbiAgICAgICAgICAgIHJldC5hZGRQcm9wZXJ0eU92ZXJyaWRlKHByb3BLZXksIHByb3BWYWwpO1xuICAgICAgICB9XG4gICAgICAgIG9wdGlvbnMucGFyc2VyLmhhbmRsZUF0dHJpYnV0ZXMocmV0LCByZXNvdXJjZUF0dHJpYnV0ZXMsIGlkKTtcbiAgICAgICAgcmV0dXJuIHJldDtcbiAgICB9XG5cbiAgICAvKipcbiAgICAgKiBBIHVuaXF1ZSBpZGVudGlmaWVyIGZvciB0aGUgYXV0byBzY2FsaW5nIGdyb3VwLlxuICAgICAqIEBjbG91ZGZvcm1hdGlvbkF0dHJpYnV0ZSBBdXRvU2NhbGluZ0dyb3VwQXJuXG4gICAgICovXG4gICAgcHVibGljIHJlYWRvbmx5IGF0dHJBdXRvU2NhbGluZ0dyb3VwQXJuOiBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBBIHVuaXF1ZSBpZGVudGlmaWVyIGZvciB0aGUgZ2FtZSBzZXJ2ZXIgZ3JvdXAuXG4gICAgICogQGNsb3VkZm9ybWF0aW9uQXR0cmlidXRlIEdhbWVTZXJ2ZXJHcm91cEFyblxuICAgICAqL1xuICAgIHB1YmxpYyByZWFkb25seSBhdHRyR2FtZVNlcnZlckdyb3VwQXJuOiBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBBIGRldmVsb3Blci1kZWZpbmVkIGlkZW50aWZpZXIgZm9yIHRoZSBnYW1lIHNlcnZlciBncm91cC4gVGhlIG5hbWUgaXMgdW5pcXVlIGZvciBlYWNoIFJlZ2lvbiBpbiBlYWNoIEFXUyBhY2NvdW50LlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZ2FtZWxpZnQtZ2FtZXNlcnZlcmdyb3VwLmh0bWwjY2ZuLWdhbWVsaWZ0LWdhbWVzZXJ2ZXJncm91cC1nYW1lc2VydmVyZ3JvdXBuYW1lXG4gICAgICovXG4gICAgcHVibGljIGdhbWVTZXJ2ZXJHcm91cE5hbWU6IHN0cmluZztcblxuICAgIC8qKlxuICAgICAqIFRoZSBzZXQgb2YgQW1hem9uIEVDMiBpbnN0YW5jZSB0eXBlcyB0aGF0IEdhbWVMaWZ0IEZsZWV0SVEgY2FuIHVzZSB3aGVuIGJhbGFuY2luZyBhbmQgYXV0b21hdGljYWxseSBzY2FsaW5nIGluc3RhbmNlcyBpbiB0aGUgY29ycmVzcG9uZGluZyBBdXRvIFNjYWxpbmcgZ3JvdXAuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1nYW1lbGlmdC1nYW1lc2VydmVyZ3JvdXAuaHRtbCNjZm4tZ2FtZWxpZnQtZ2FtZXNlcnZlcmdyb3VwLWluc3RhbmNlZGVmaW5pdGlvbnNcbiAgICAgKi9cbiAgICBwdWJsaWMgaW5zdGFuY2VEZWZpbml0aW9uczogQXJyYXk8Q2ZuR2FtZVNlcnZlckdyb3VwLkluc3RhbmNlRGVmaW5pdGlvblByb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlPiB8IGNkay5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFRoZSBBbWF6b24gRUMyIGxhdW5jaCB0ZW1wbGF0ZSB0aGF0IGNvbnRhaW5zIGNvbmZpZ3VyYXRpb24gc2V0dGluZ3MgYW5kIGdhbWUgc2VydmVyIGNvZGUgdG8gYmUgZGVwbG95ZWQgdG8gYWxsIGluc3RhbmNlcyBpbiB0aGUgZ2FtZSBzZXJ2ZXIgZ3JvdXAuIFlvdSBjYW4gc3BlY2lmeSB0aGUgdGVtcGxhdGUgdXNpbmcgZWl0aGVyIHRoZSB0ZW1wbGF0ZSBuYW1lIG9yIElELiBGb3IgaGVscCB3aXRoIGNyZWF0aW5nIGEgbGF1bmNoIHRlbXBsYXRlLCBzZWUgW0NyZWF0aW5nIGEgTGF1bmNoIFRlbXBsYXRlIGZvciBhbiBBdXRvIFNjYWxpbmcgR3JvdXBdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9hdXRvc2NhbGluZy9lYzIvdXNlcmd1aWRlL2NyZWF0ZS1sYXVuY2gtdGVtcGxhdGUuaHRtbCkgaW4gdGhlICpBbWF6b24gRWxhc3RpYyBDb21wdXRlIENsb3VkIEF1dG8gU2NhbGluZyBVc2VyIEd1aWRlKiAuIEFmdGVyIHRoZSBBdXRvIFNjYWxpbmcgZ3JvdXAgaXMgY3JlYXRlZCwgdXBkYXRlIHRoaXMgdmFsdWUgZGlyZWN0bHkgaW4gdGhlIEF1dG8gU2NhbGluZyBncm91cCB1c2luZyB0aGUgQVdTIGNvbnNvbGUgb3IgQVBJcy5cbiAgICAgKlxuICAgICAqID4gSWYgeW91IHNwZWNpZnkgbmV0d29yayBpbnRlcmZhY2VzIGluIHlvdXIgbGF1bmNoIHRlbXBsYXRlLCB5b3UgbXVzdCBleHBsaWNpdGx5IHNldCB0aGUgcHJvcGVydHkgYEFzc29jaWF0ZVB1YmxpY0lwQWRkcmVzc2AgdG8gXCJ0cnVlXCIuIElmIG5vIG5ldHdvcmsgaW50ZXJmYWNlIGlzIHNwZWNpZmllZCBpbiB0aGUgbGF1bmNoIHRlbXBsYXRlLCBHYW1lTGlmdCBGbGVldElRIHVzZXMgeW91ciBhY2NvdW50J3MgZGVmYXVsdCBWUEMuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1nYW1lbGlmdC1nYW1lc2VydmVyZ3JvdXAuaHRtbCNjZm4tZ2FtZWxpZnQtZ2FtZXNlcnZlcmdyb3VwLWxhdW5jaHRlbXBsYXRlXG4gICAgICovXG4gICAgcHVibGljIGxhdW5jaFRlbXBsYXRlOiBDZm5HYW1lU2VydmVyR3JvdXAuTGF1bmNoVGVtcGxhdGVQcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFRoZSBBbWF6b24gUmVzb3VyY2UgTmFtZSAoIFtBUk5dKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BbWF6b25TMy9sYXRlc3QvZGV2L3MzLWFybi1mb3JtYXQuaHRtbCkgKSBmb3IgYW4gSUFNIHJvbGUgdGhhdCBhbGxvd3MgQW1hem9uIEdhbWVMaWZ0IHRvIGFjY2VzcyB5b3VyIEFtYXpvbiBFQzIgQXV0byBTY2FsaW5nIGdyb3Vwcy5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWdhbWVsaWZ0LWdhbWVzZXJ2ZXJncm91cC5odG1sI2Nmbi1nYW1lbGlmdC1nYW1lc2VydmVyZ3JvdXAtcm9sZWFyblxuICAgICAqL1xuICAgIHB1YmxpYyByb2xlQXJuOiBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBDb25maWd1cmF0aW9uIHNldHRpbmdzIHRvIGRlZmluZSBhIHNjYWxpbmcgcG9saWN5IGZvciB0aGUgQXV0byBTY2FsaW5nIGdyb3VwIHRoYXQgaXMgb3B0aW1pemVkIGZvciBnYW1lIGhvc3RpbmcuIFRoZSBzY2FsaW5nIHBvbGljeSB1c2VzIHRoZSBtZXRyaWMgYFwiUGVyY2VudFV0aWxpemVkR2FtZVNlcnZlcnNcImAgdG8gbWFpbnRhaW4gYSBidWZmZXIgb2YgaWRsZSBnYW1lIHNlcnZlcnMgdGhhdCBjYW4gaW1tZWRpYXRlbHkgYWNjb21tb2RhdGUgbmV3IGdhbWVzIGFuZCBwbGF5ZXJzLiBBZnRlciB0aGUgQXV0byBTY2FsaW5nIGdyb3VwIGlzIGNyZWF0ZWQsIHVwZGF0ZSB0aGlzIHZhbHVlIGRpcmVjdGx5IGluIHRoZSBBdXRvIFNjYWxpbmcgZ3JvdXAgdXNpbmcgdGhlIEFXUyBjb25zb2xlIG9yIEFQSXMuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1nYW1lbGlmdC1nYW1lc2VydmVyZ3JvdXAuaHRtbCNjZm4tZ2FtZWxpZnQtZ2FtZXNlcnZlcmdyb3VwLWF1dG9zY2FsaW5ncG9saWN5XG4gICAgICovXG4gICAgcHVibGljIGF1dG9TY2FsaW5nUG9saWN5OiBDZm5HYW1lU2VydmVyR3JvdXAuQXV0b1NjYWxpbmdQb2xpY3lQcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZSB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIEluZGljYXRlcyBob3cgR2FtZUxpZnQgRmxlZXRJUSBiYWxhbmNlcyB0aGUgdXNlIG9mIFNwb3QgSW5zdGFuY2VzIGFuZCBPbi1EZW1hbmQgSW5zdGFuY2VzIGluIHRoZSBnYW1lIHNlcnZlciBncm91cC4gTWV0aG9kIG9wdGlvbnMgaW5jbHVkZSB0aGUgZm9sbG93aW5nOlxuICAgICAqXG4gICAgICogLSBgU1BPVF9PTkxZYCAtIE9ubHkgU3BvdCBJbnN0YW5jZXMgYXJlIHVzZWQgaW4gdGhlIGdhbWUgc2VydmVyIGdyb3VwLiBJZiBTcG90IEluc3RhbmNlcyBhcmUgdW5hdmFpbGFibGUgb3Igbm90IHZpYWJsZSBmb3IgZ2FtZSBob3N0aW5nLCB0aGUgZ2FtZSBzZXJ2ZXIgZ3JvdXAgcHJvdmlkZXMgbm8gaG9zdGluZyBjYXBhY2l0eSB1bnRpbCBTcG90IEluc3RhbmNlcyBjYW4gYWdhaW4gYmUgdXNlZC4gVW50aWwgdGhlbiwgbm8gbmV3IGluc3RhbmNlcyBhcmUgc3RhcnRlZCwgYW5kIHRoZSBleGlzdGluZyBub252aWFibGUgU3BvdCBJbnN0YW5jZXMgYXJlIHRlcm1pbmF0ZWQgKGFmdGVyIGN1cnJlbnQgZ2FtZXBsYXkgZW5kcykgYW5kIGFyZSBub3QgcmVwbGFjZWQuXG4gICAgICogLSBgU1BPVF9QUkVGRVJSRURgIC0gKGRlZmF1bHQgdmFsdWUpIFNwb3QgSW5zdGFuY2VzIGFyZSB1c2VkIHdoZW5ldmVyIGF2YWlsYWJsZSBpbiB0aGUgZ2FtZSBzZXJ2ZXIgZ3JvdXAuIElmIFNwb3QgSW5zdGFuY2VzIGFyZSB1bmF2YWlsYWJsZSwgdGhlIGdhbWUgc2VydmVyIGdyb3VwIGNvbnRpbnVlcyB0byBwcm92aWRlIGhvc3RpbmcgY2FwYWNpdHkgYnkgZmFsbGluZyBiYWNrIHRvIE9uLURlbWFuZCBJbnN0YW5jZXMuIEV4aXN0aW5nIG5vbnZpYWJsZSBTcG90IEluc3RhbmNlcyBhcmUgdGVybWluYXRlZCAoYWZ0ZXIgY3VycmVudCBnYW1lcGxheSBlbmRzKSBhbmQgYXJlIHJlcGxhY2VkIHdpdGggbmV3IE9uLURlbWFuZCBJbnN0YW5jZXMuXG4gICAgICogLSBgT05fREVNQU5EX09OTFlgIC0gT25seSBPbi1EZW1hbmQgSW5zdGFuY2VzIGFyZSB1c2VkIGluIHRoZSBnYW1lIHNlcnZlciBncm91cC4gTm8gU3BvdCBJbnN0YW5jZXMgYXJlIHVzZWQsIGV2ZW4gd2hlbiBhdmFpbGFibGUsIHdoaWxlIHRoaXMgYmFsYW5jaW5nIHN0cmF0ZWd5IGlzIGluIGZvcmNlLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZ2FtZWxpZnQtZ2FtZXNlcnZlcmdyb3VwLmh0bWwjY2ZuLWdhbWVsaWZ0LWdhbWVzZXJ2ZXJncm91cC1iYWxhbmNpbmdzdHJhdGVneVxuICAgICAqL1xuICAgIHB1YmxpYyBiYWxhbmNpbmdTdHJhdGVneTogc3RyaW5nIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogVGhlIHR5cGUgb2YgZGVsZXRlIHRvIHBlcmZvcm0uIFRvIGRlbGV0ZSBhIGdhbWUgc2VydmVyIGdyb3VwLCBzcGVjaWZ5IHRoZSBgRGVsZXRlT3B0aW9uYCAuIE9wdGlvbnMgaW5jbHVkZSB0aGUgZm9sbG93aW5nOlxuICAgICAqXG4gICAgICogLSBgU0FGRV9ERUxFVEVgIOKAkyAoZGVmYXVsdCkgVGVybWluYXRlcyB0aGUgZ2FtZSBzZXJ2ZXIgZ3JvdXAgYW5kIEFtYXpvbiBFQzIgQXV0byBTY2FsaW5nIGdyb3VwIG9ubHkgd2hlbiBpdCBoYXMgbm8gZ2FtZSBzZXJ2ZXJzIHRoYXQgYXJlIGluIGBVVElMSVpFRGAgc3RhdHVzLlxuICAgICAqIC0gYEZPUkNFX0RFTEVURWAg4oCTIFRlcm1pbmF0ZXMgdGhlIGdhbWUgc2VydmVyIGdyb3VwLCBpbmNsdWRpbmcgYWxsIGFjdGl2ZSBnYW1lIHNlcnZlcnMgcmVnYXJkbGVzcyBvZiB0aGVpciB1dGlsaXphdGlvbiBzdGF0dXMsIGFuZCB0aGUgQW1hem9uIEVDMiBBdXRvIFNjYWxpbmcgZ3JvdXAuXG4gICAgICogLSBgUkVUQUlOYCDigJMgRG9lcyBhIHNhZmUgZGVsZXRlIG9mIHRoZSBnYW1lIHNlcnZlciBncm91cCBidXQgcmV0YWlucyB0aGUgQW1hem9uIEVDMiBBdXRvIFNjYWxpbmcgZ3JvdXAgYXMgaXMuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1nYW1lbGlmdC1nYW1lc2VydmVyZ3JvdXAuaHRtbCNjZm4tZ2FtZWxpZnQtZ2FtZXNlcnZlcmdyb3VwLWRlbGV0ZW9wdGlvblxuICAgICAqL1xuICAgIHB1YmxpYyBkZWxldGVPcHRpb246IHN0cmluZyB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIEEgZmxhZyB0aGF0IGluZGljYXRlcyB3aGV0aGVyIGluc3RhbmNlcyBpbiB0aGUgZ2FtZSBzZXJ2ZXIgZ3JvdXAgYXJlIHByb3RlY3RlZCBmcm9tIGVhcmx5IHRlcm1pbmF0aW9uLiBVbnByb3RlY3RlZCBpbnN0YW5jZXMgdGhhdCBoYXZlIGFjdGl2ZSBnYW1lIHNlcnZlcnMgcnVubmluZyBtaWdodCBiZSB0ZXJtaW5hdGVkIGR1cmluZyBhIHNjYWxlLWRvd24gZXZlbnQsIGNhdXNpbmcgcGxheWVycyB0byBiZSBkcm9wcGVkIGZyb20gdGhlIGdhbWUuIFByb3RlY3RlZCBpbnN0YW5jZXMgY2Fubm90IGJlIHRlcm1pbmF0ZWQgd2hpbGUgdGhlcmUgYXJlIGFjdGl2ZSBnYW1lIHNlcnZlcnMgcnVubmluZyBleGNlcHQgaW4gdGhlIGV2ZW50IG9mIGEgZm9yY2VkIGdhbWUgc2VydmVyIGdyb3VwIGRlbGV0aW9uIChzZWUgKS4gQW4gZXhjZXB0aW9uIHRvIHRoaXMgaXMgd2l0aCBTcG90IEluc3RhbmNlcywgd2hpY2ggY2FuIGJlIHRlcm1pbmF0ZWQgYnkgQVdTIHJlZ2FyZGxlc3Mgb2YgcHJvdGVjdGlvbiBzdGF0dXMuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1nYW1lbGlmdC1nYW1lc2VydmVyZ3JvdXAuaHRtbCNjZm4tZ2FtZWxpZnQtZ2FtZXNlcnZlcmdyb3VwLWdhbWVzZXJ2ZXJwcm90ZWN0aW9ucG9saWN5XG4gICAgICovXG4gICAgcHVibGljIGdhbWVTZXJ2ZXJQcm90ZWN0aW9uUG9saWN5OiBzdHJpbmcgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgbWF4aW11bSBudW1iZXIgb2YgaW5zdGFuY2VzIGFsbG93ZWQgaW4gdGhlIEFtYXpvbiBFQzIgQXV0byBTY2FsaW5nIGdyb3VwLiBEdXJpbmcgYXV0b21hdGljIHNjYWxpbmcgZXZlbnRzLCBHYW1lTGlmdCBGbGVldElRIGFuZCBFQzIgZG8gbm90IHNjYWxlIHVwIHRoZSBncm91cCBhYm92ZSB0aGlzIG1heGltdW0uIEFmdGVyIHRoZSBBdXRvIFNjYWxpbmcgZ3JvdXAgaXMgY3JlYXRlZCwgdXBkYXRlIHRoaXMgdmFsdWUgZGlyZWN0bHkgaW4gdGhlIEF1dG8gU2NhbGluZyBncm91cCB1c2luZyB0aGUgQVdTIGNvbnNvbGUgb3IgQVBJcy5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWdhbWVsaWZ0LWdhbWVzZXJ2ZXJncm91cC5odG1sI2Nmbi1nYW1lbGlmdC1nYW1lc2VydmVyZ3JvdXAtbWF4c2l6ZVxuICAgICAqL1xuICAgIHB1YmxpYyBtYXhTaXplOiBudW1iZXIgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgbWluaW11bSBudW1iZXIgb2YgaW5zdGFuY2VzIGFsbG93ZWQgaW4gdGhlIEFtYXpvbiBFQzIgQXV0byBTY2FsaW5nIGdyb3VwLiBEdXJpbmcgYXV0b21hdGljIHNjYWxpbmcgZXZlbnRzLCBHYW1lTGlmdCBGbGVldElRIGFuZCBBbWF6b24gRUMyIGRvIG5vdCBzY2FsZSBkb3duIHRoZSBncm91cCBiZWxvdyB0aGlzIG1pbmltdW0uIEluIHByb2R1Y3Rpb24sIHRoaXMgdmFsdWUgc2hvdWxkIGJlIHNldCB0byBhdCBsZWFzdCAxLiBBZnRlciB0aGUgQXV0byBTY2FsaW5nIGdyb3VwIGlzIGNyZWF0ZWQsIHVwZGF0ZSB0aGlzIHZhbHVlIGRpcmVjdGx5IGluIHRoZSBBdXRvIFNjYWxpbmcgZ3JvdXAgdXNpbmcgdGhlIEFXUyBjb25zb2xlIG9yIEFQSXMuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1nYW1lbGlmdC1nYW1lc2VydmVyZ3JvdXAuaHRtbCNjZm4tZ2FtZWxpZnQtZ2FtZXNlcnZlcmdyb3VwLW1pbnNpemVcbiAgICAgKi9cbiAgICBwdWJsaWMgbWluU2l6ZTogbnVtYmVyIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogQSBsaXN0IG9mIGxhYmVscyB0byBhc3NpZ24gdG8gdGhlIG5ldyBnYW1lIHNlcnZlciBncm91cCByZXNvdXJjZS4gVGFncyBhcmUgZGV2ZWxvcGVyLWRlZmluZWQga2V5LXZhbHVlIHBhaXJzLiBUYWdnaW5nIEFXUyByZXNvdXJjZXMgaXMgdXNlZnVsIGZvciByZXNvdXJjZSBtYW5hZ2VtZW50LCBhY2Nlc3MgbWFuYWdlbWVudCwgYW5kIGNvc3QgYWxsb2NhdGlvbi4gRm9yIG1vcmUgaW5mb3JtYXRpb24sIHNlZSBbVGFnZ2luZyBBV1MgUmVzb3VyY2VzXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZ2VuZXJhbC9sYXRlc3QvZ3IvYXdzX3RhZ2dpbmcuaHRtbCkgaW4gdGhlICpBV1MgR2VuZXJhbCBSZWZlcmVuY2UqIC4gT25jZSB0aGUgcmVzb3VyY2UgaXMgY3JlYXRlZCwgeW91IGNhbiB1c2UgVGFnUmVzb3VyY2UsIFVudGFnUmVzb3VyY2UsIGFuZCBMaXN0VGFnc0ZvclJlc291cmNlIHRvIGFkZCwgcmVtb3ZlLCBhbmQgdmlldyB0YWdzLCByZXNwZWN0aXZlbHkuIFRoZSBtYXhpbXVtIHRhZyBsaW1pdCBtYXkgYmUgbG93ZXIgdGhhbiBzdGF0ZWQuIFNlZSB0aGUgQVdTIEdlbmVyYWwgUmVmZXJlbmNlIGZvciBhY3R1YWwgdGFnZ2luZyBsaW1pdHMuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1nYW1lbGlmdC1nYW1lc2VydmVyZ3JvdXAuaHRtbCNjZm4tZ2FtZWxpZnQtZ2FtZXNlcnZlcmdyb3VwLXRhZ3NcbiAgICAgKi9cbiAgICBwdWJsaWMgcmVhZG9ubHkgdGFnczogY2RrLlRhZ01hbmFnZXI7XG5cbiAgICAvKipcbiAgICAgKiBBIGxpc3Qgb2YgdmlydHVhbCBwcml2YXRlIGNsb3VkIChWUEMpIHN1Ym5ldHMgdG8gdXNlIHdpdGggaW5zdGFuY2VzIGluIHRoZSBnYW1lIHNlcnZlciBncm91cC4gQnkgZGVmYXVsdCwgYWxsIEdhbWVMaWZ0IEZsZWV0SVEtc3VwcG9ydGVkIEF2YWlsYWJpbGl0eSBab25lcyBhcmUgdXNlZC4gWW91IGNhbiB1c2UgdGhpcyBwYXJhbWV0ZXIgdG8gc3BlY2lmeSBWUENzIHRoYXQgeW91J3ZlIHNldCB1cC4gVGhpcyBwcm9wZXJ0eSBjYW5ub3QgYmUgdXBkYXRlZCBhZnRlciB0aGUgZ2FtZSBzZXJ2ZXIgZ3JvdXAgaXMgY3JlYXRlZCwgYW5kIHRoZSBjb3JyZXNwb25kaW5nIEF1dG8gU2NhbGluZyBncm91cCB3aWxsIGFsd2F5cyB1c2UgdGhlIHByb3BlcnR5IHZhbHVlIHRoYXQgaXMgc2V0IHdpdGggdGhpcyByZXF1ZXN0LCBldmVuIGlmIHRoZSBBdXRvIFNjYWxpbmcgZ3JvdXAgaXMgdXBkYXRlZCBkaXJlY3RseS5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWdhbWVsaWZ0LWdhbWVzZXJ2ZXJncm91cC5odG1sI2Nmbi1nYW1lbGlmdC1nYW1lc2VydmVyZ3JvdXAtdnBjc3VibmV0c1xuICAgICAqL1xuICAgIHB1YmxpYyB2cGNTdWJuZXRzOiBzdHJpbmdbXSB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIENyZWF0ZSBhIG5ldyBgQVdTOjpHYW1lTGlmdDo6R2FtZVNlcnZlckdyb3VwYC5cbiAgICAgKlxuICAgICAqIEBwYXJhbSBzY29wZSAtIHNjb3BlIGluIHdoaWNoIHRoaXMgcmVzb3VyY2UgaXMgZGVmaW5lZFxuICAgICAqIEBwYXJhbSBpZCAgICAtIHNjb3BlZCBpZCBvZiB0aGUgcmVzb3VyY2VcbiAgICAgKiBAcGFyYW0gcHJvcHMgLSByZXNvdXJjZSBwcm9wZXJ0aWVzXG4gICAgICovXG4gICAgY29uc3RydWN0b3Ioc2NvcGU6IGNkay5Db25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBDZm5HYW1lU2VydmVyR3JvdXBQcm9wcykge1xuICAgICAgICBzdXBlcihzY29wZSwgaWQsIHsgdHlwZTogQ2ZuR2FtZVNlcnZlckdyb3VwLkNGTl9SRVNPVVJDRV9UWVBFX05BTUUsIHByb3BlcnRpZXM6IHByb3BzIH0pO1xuICAgICAgICBjZGsucmVxdWlyZVByb3BlcnR5KHByb3BzLCAnZ2FtZVNlcnZlckdyb3VwTmFtZScsIHRoaXMpO1xuICAgICAgICBjZGsucmVxdWlyZVByb3BlcnR5KHByb3BzLCAnaW5zdGFuY2VEZWZpbml0aW9ucycsIHRoaXMpO1xuICAgICAgICBjZGsucmVxdWlyZVByb3BlcnR5KHByb3BzLCAnbGF1bmNoVGVtcGxhdGUnLCB0aGlzKTtcbiAgICAgICAgY2RrLnJlcXVpcmVQcm9wZXJ0eShwcm9wcywgJ3JvbGVBcm4nLCB0aGlzKTtcbiAgICAgICAgdGhpcy5hdHRyQXV0b1NjYWxpbmdHcm91cEFybiA9IGNkay5Ub2tlbi5hc1N0cmluZyh0aGlzLmdldEF0dCgnQXV0b1NjYWxpbmdHcm91cEFybicpKTtcbiAgICAgICAgdGhpcy5hdHRyR2FtZVNlcnZlckdyb3VwQXJuID0gY2RrLlRva2VuLmFzU3RyaW5nKHRoaXMuZ2V0QXR0KCdHYW1lU2VydmVyR3JvdXBBcm4nKSk7XG5cbiAgICAgICAgdGhpcy5nYW1lU2VydmVyR3JvdXBOYW1lID0gcHJvcHMuZ2FtZVNlcnZlckdyb3VwTmFtZTtcbiAgICAgICAgdGhpcy5pbnN0YW5jZURlZmluaXRpb25zID0gcHJvcHMuaW5zdGFuY2VEZWZpbml0aW9ucztcbiAgICAgICAgdGhpcy5sYXVuY2hUZW1wbGF0ZSA9IHByb3BzLmxhdW5jaFRlbXBsYXRlO1xuICAgICAgICB0aGlzLnJvbGVBcm4gPSBwcm9wcy5yb2xlQXJuO1xuICAgICAgICB0aGlzLmF1dG9TY2FsaW5nUG9saWN5ID0gcHJvcHMuYXV0b1NjYWxpbmdQb2xpY3k7XG4gICAgICAgIHRoaXMuYmFsYW5jaW5nU3RyYXRlZ3kgPSBwcm9wcy5iYWxhbmNpbmdTdHJhdGVneTtcbiAgICAgICAgdGhpcy5kZWxldGVPcHRpb24gPSBwcm9wcy5kZWxldGVPcHRpb247XG4gICAgICAgIHRoaXMuZ2FtZVNlcnZlclByb3RlY3Rpb25Qb2xpY3kgPSBwcm9wcy5nYW1lU2VydmVyUHJvdGVjdGlvblBvbGljeTtcbiAgICAgICAgdGhpcy5tYXhTaXplID0gcHJvcHMubWF4U2l6ZTtcbiAgICAgICAgdGhpcy5taW5TaXplID0gcHJvcHMubWluU2l6ZTtcbiAgICAgICAgdGhpcy50YWdzID0gbmV3IGNkay5UYWdNYW5hZ2VyKGNkay5UYWdUeXBlLlNUQU5EQVJELCBcIkFXUzo6R2FtZUxpZnQ6OkdhbWVTZXJ2ZXJHcm91cFwiLCBwcm9wcy50YWdzLCB7IHRhZ1Byb3BlcnR5TmFtZTogJ3RhZ3MnIH0pO1xuICAgICAgICB0aGlzLnZwY1N1Ym5ldHMgPSBwcm9wcy52cGNTdWJuZXRzO1xuICAgIH1cblxuICAgIC8qKlxuICAgICAqIEV4YW1pbmVzIHRoZSBDbG91ZEZvcm1hdGlvbiByZXNvdXJjZSBhbmQgZGlzY2xvc2VzIGF0dHJpYnV0ZXMuXG4gICAgICpcbiAgICAgKiBAcGFyYW0gaW5zcGVjdG9yIC0gdHJlZSBpbnNwZWN0b3IgdG8gY29sbGVjdCBhbmQgcHJvY2VzcyBhdHRyaWJ1dGVzXG4gICAgICpcbiAgICAgKi9cbiAgICBwdWJsaWMgaW5zcGVjdChpbnNwZWN0b3I6IGNkay5UcmVlSW5zcGVjdG9yKSB7XG4gICAgICAgIGluc3BlY3Rvci5hZGRBdHRyaWJ1dGUoXCJhd3M6Y2RrOmNsb3VkZm9ybWF0aW9uOnR5cGVcIiwgQ2ZuR2FtZVNlcnZlckdyb3VwLkNGTl9SRVNPVVJDRV9UWVBFX05BTUUpO1xuICAgICAgICBpbnNwZWN0b3IuYWRkQXR0cmlidXRlKFwiYXdzOmNkazpjbG91ZGZvcm1hdGlvbjpwcm9wc1wiLCB0aGlzLmNmblByb3BlcnRpZXMpO1xuICAgIH1cblxuICAgIHByb3RlY3RlZCBnZXQgY2ZuUHJvcGVydGllcygpOiB7IFtrZXk6IHN0cmluZ106IGFueSB9ICB7XG4gICAgICAgIHJldHVybiB7XG4gICAgICAgICAgICBnYW1lU2VydmVyR3JvdXBOYW1lOiB0aGlzLmdhbWVTZXJ2ZXJHcm91cE5hbWUsXG4gICAgICAgICAgICBpbnN0YW5jZURlZmluaXRpb25zOiB0aGlzLmluc3RhbmNlRGVmaW5pdGlvbnMsXG4gICAgICAgICAgICBsYXVuY2hUZW1wbGF0ZTogdGhpcy5sYXVuY2hUZW1wbGF0ZSxcbiAgICAgICAgICAgIHJvbGVBcm46IHRoaXMucm9sZUFybixcbiAgICAgICAgICAgIGF1dG9TY2FsaW5nUG9saWN5OiB0aGlzLmF1dG9TY2FsaW5nUG9saWN5LFxuICAgICAgICAgICAgYmFsYW5jaW5nU3RyYXRlZ3k6IHRoaXMuYmFsYW5jaW5nU3RyYXRlZ3ksXG4gICAgICAgICAgICBkZWxldGVPcHRpb246IHRoaXMuZGVsZXRlT3B0aW9uLFxuICAgICAgICAgICAgZ2FtZVNlcnZlclByb3RlY3Rpb25Qb2xpY3k6IHRoaXMuZ2FtZVNlcnZlclByb3RlY3Rpb25Qb2xpY3ksXG4gICAgICAgICAgICBtYXhTaXplOiB0aGlzLm1heFNpemUsXG4gICAgICAgICAgICBtaW5TaXplOiB0aGlzLm1pblNpemUsXG4gICAgICAgICAgICB0YWdzOiB0aGlzLnRhZ3MucmVuZGVyVGFncygpLFxuICAgICAgICAgICAgdnBjU3VibmV0czogdGhpcy52cGNTdWJuZXRzLFxuICAgICAgICB9O1xuICAgIH1cblxuICAgIHByb3RlY3RlZCByZW5kZXJQcm9wZXJ0aWVzKHByb3BzOiB7W2tleTogc3RyaW5nXTogYW55fSk6IHsgW2tleTogc3RyaW5nXTogYW55IH0gIHtcbiAgICAgICAgcmV0dXJuIGNmbkdhbWVTZXJ2ZXJHcm91cFByb3BzVG9DbG91ZEZvcm1hdGlvbihwcm9wcyk7XG4gICAgfVxufVxuXG5leHBvcnQgbmFtZXNwYWNlIENmbkdhbWVTZXJ2ZXJHcm91cCB7XG4gICAgLyoqXG4gICAgICogKlRoaXMgZGF0YSB0eXBlIGlzIHVzZWQgd2l0aCB0aGUgR2FtZUxpZnQgRmxlZXRJUSBhbmQgZ2FtZSBzZXJ2ZXIgZ3JvdXBzLipcbiAgICAgKlxuICAgICAqIENvbmZpZ3VyYXRpb24gc2V0dGluZ3MgZm9yIGludGVsbGlnZW50IGF1dG9tYXRpYyBzY2FsaW5nIHRoYXQgdXNlcyB0YXJnZXQgdHJhY2tpbmcuIEFmdGVyIHRoZSBBdXRvIFNjYWxpbmcgZ3JvdXAgaXMgY3JlYXRlZCwgYWxsIHVwZGF0ZXMgdG8gQXV0byBTY2FsaW5nIHBvbGljaWVzLCBpbmNsdWRpbmcgY2hhbmdpbmcgdGhpcyBwb2xpY3kgYW5kIGFkZGluZyBvciByZW1vdmluZyBvdGhlciBwb2xpY2llcywgaXMgZG9uZSBkaXJlY3RseSBvbiB0aGUgQXV0byBTY2FsaW5nIGdyb3VwLlxuICAgICAqXG4gICAgICogQHN0cnVjdFxuICAgICAqIEBzdGFiaWxpdHkgZXh0ZXJuYWxcbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtZ2FtZWxpZnQtZ2FtZXNlcnZlcmdyb3VwLWF1dG9zY2FsaW5ncG9saWN5Lmh0bWxcbiAgICAgKi9cbiAgICBleHBvcnQgaW50ZXJmYWNlIEF1dG9TY2FsaW5nUG9saWN5UHJvcGVydHkge1xuICAgICAgICAvKipcbiAgICAgICAgICogTGVuZ3RoIG9mIHRpbWUsIGluIHNlY29uZHMsIGl0IHRha2VzIGZvciBhIG5ldyBpbnN0YW5jZSB0byBzdGFydCBuZXcgZ2FtZSBzZXJ2ZXIgcHJvY2Vzc2VzIGFuZCByZWdpc3RlciB3aXRoIEdhbWVMaWZ0IEZsZWV0SVEuIFNwZWNpZnlpbmcgYSB3YXJtLXVwIHRpbWUgY2FuIGJlIHVzZWZ1bCwgcGFydGljdWxhcmx5IHdpdGggZ2FtZSBzZXJ2ZXJzIHRoYXQgdGFrZSBhIGxvbmcgdGltZSB0byBzdGFydCB1cCwgYmVjYXVzZSBpdCBhdm9pZHMgcHJlbWF0dXJlbHkgc3RhcnRpbmcgbmV3IGluc3RhbmNlcy5cbiAgICAgICAgICpcbiAgICAgICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1nYW1lbGlmdC1nYW1lc2VydmVyZ3JvdXAtYXV0b3NjYWxpbmdwb2xpY3kuaHRtbCNjZm4tZ2FtZWxpZnQtZ2FtZXNlcnZlcmdyb3VwLWF1dG9zY2FsaW5ncG9saWN5LWVzdGltYXRlZGluc3RhbmNld2FybXVwXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBlc3RpbWF0ZWRJbnN0YW5jZVdhcm11cD86IG51bWJlcjtcbiAgICAgICAgLyoqXG4gICAgICAgICAqIFNldHRpbmdzIGZvciBhIHRhcmdldC1iYXNlZCBzY2FsaW5nIHBvbGljeSBhcHBsaWVkIHRvIEF1dG8gU2NhbGluZyBncm91cC4gVGhlc2Ugc2V0dGluZ3MgYXJlIHVzZWQgdG8gY3JlYXRlIGEgdGFyZ2V0LWJhc2VkIHBvbGljeSB0aGF0IHRyYWNrcyB0aGUgR2FtZUxpZnQgRmxlZXRJUSBtZXRyaWMgYFBlcmNlbnRVdGlsaXplZEdhbWVTZXJ2ZXJzYCBhbmQgc3BlY2lmaWVzIGEgdGFyZ2V0IHZhbHVlIGZvciB0aGUgbWV0cmljLiBBcyBwbGF5ZXIgdXNhZ2UgY2hhbmdlcywgdGhlIHBvbGljeSB0cmlnZ2VycyB0byBhZGp1c3QgdGhlIGdhbWUgc2VydmVyIGdyb3VwIGNhcGFjaXR5IHNvIHRoYXQgdGhlIG1ldHJpYyByZXR1cm5zIHRvIHRoZSB0YXJnZXQgdmFsdWUuXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtZ2FtZWxpZnQtZ2FtZXNlcnZlcmdyb3VwLWF1dG9zY2FsaW5ncG9saWN5Lmh0bWwjY2ZuLWdhbWVsaWZ0LWdhbWVzZXJ2ZXJncm91cC1hdXRvc2NhbGluZ3BvbGljeS10YXJnZXR0cmFja2luZ2NvbmZpZ3VyYXRpb25cbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IHRhcmdldFRyYWNraW5nQ29uZmlndXJhdGlvbjogQ2ZuR2FtZVNlcnZlckdyb3VwLlRhcmdldFRyYWNraW5nQ29uZmlndXJhdGlvblByb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlO1xuICAgIH1cbn1cblxuLyoqXG4gKiBEZXRlcm1pbmUgd2hldGhlciB0aGUgZ2l2ZW4gcHJvcGVydGllcyBtYXRjaCB0aG9zZSBvZiBhIGBBdXRvU2NhbGluZ1BvbGljeVByb3BlcnR5YFxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBBdXRvU2NhbGluZ1BvbGljeVByb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSByZXN1bHQgb2YgdGhlIHZhbGlkYXRpb24uXG4gKi9cbmZ1bmN0aW9uIENmbkdhbWVTZXJ2ZXJHcm91cF9BdXRvU2NhbGluZ1BvbGljeVByb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXM6IGFueSk6IGNkay5WYWxpZGF0aW9uUmVzdWx0IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBjZGsuVkFMSURBVElPTl9TVUNDRVNTOyB9XG4gICAgY29uc3QgZXJyb3JzID0gbmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0cygpO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgZXJyb3JzLmNvbGxlY3QobmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0KCdFeHBlY3RlZCBhbiBvYmplY3QsIGJ1dCByZWNlaXZlZDogJyArIEpTT04uc3RyaW5naWZ5KHByb3BlcnRpZXMpKSk7XG4gICAgfVxuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignZXN0aW1hdGVkSW5zdGFuY2VXYXJtdXAnLCBjZGsudmFsaWRhdGVOdW1iZXIpKHByb3BlcnRpZXMuZXN0aW1hdGVkSW5zdGFuY2VXYXJtdXApKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3RhcmdldFRyYWNraW5nQ29uZmlndXJhdGlvbicsIGNkay5yZXF1aXJlZFZhbGlkYXRvcikocHJvcGVydGllcy50YXJnZXRUcmFja2luZ0NvbmZpZ3VyYXRpb24pKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3RhcmdldFRyYWNraW5nQ29uZmlndXJhdGlvbicsIENmbkdhbWVTZXJ2ZXJHcm91cF9UYXJnZXRUcmFja2luZ0NvbmZpZ3VyYXRpb25Qcm9wZXJ0eVZhbGlkYXRvcikocHJvcGVydGllcy50YXJnZXRUcmFja2luZ0NvbmZpZ3VyYXRpb24pKTtcbiAgICByZXR1cm4gZXJyb3JzLndyYXAoJ3N1cHBsaWVkIHByb3BlcnRpZXMgbm90IGNvcnJlY3QgZm9yIFwiQXV0b1NjYWxpbmdQb2xpY3lQcm9wZXJ0eVwiJyk7XG59XG5cbi8qKlxuICogUmVuZGVycyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6R2FtZUxpZnQ6OkdhbWVTZXJ2ZXJHcm91cC5BdXRvU2NhbGluZ1BvbGljeWAgcmVzb3VyY2VcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgQXV0b1NjYWxpbmdQb2xpY3lQcm9wZXJ0eWBcbiAqXG4gKiBAcmV0dXJucyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6R2FtZUxpZnQ6OkdhbWVTZXJ2ZXJHcm91cC5BdXRvU2NhbGluZ1BvbGljeWAgcmVzb3VyY2UuXG4gKi9cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBjZm5HYW1lU2VydmVyR3JvdXBBdXRvU2NhbGluZ1BvbGljeVByb3BlcnR5VG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBhbnkge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIHByb3BlcnRpZXM7IH1cbiAgICBDZm5HYW1lU2VydmVyR3JvdXBfQXV0b1NjYWxpbmdQb2xpY3lQcm9wZXJ0eVZhbGlkYXRvcihwcm9wZXJ0aWVzKS5hc3NlcnRTdWNjZXNzKCk7XG4gICAgcmV0dXJuIHtcbiAgICAgICAgRXN0aW1hdGVkSW5zdGFuY2VXYXJtdXA6IGNkay5udW1iZXJUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuZXN0aW1hdGVkSW5zdGFuY2VXYXJtdXApLFxuICAgICAgICBUYXJnZXRUcmFja2luZ0NvbmZpZ3VyYXRpb246IGNmbkdhbWVTZXJ2ZXJHcm91cFRhcmdldFRyYWNraW5nQ29uZmlndXJhdGlvblByb3BlcnR5VG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLnRhcmdldFRyYWNraW5nQ29uZmlndXJhdGlvbiksXG4gICAgfTtcbn1cblxuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIENmbkdhbWVTZXJ2ZXJHcm91cEF1dG9TY2FsaW5nUG9saWN5UHJvcGVydHlGcm9tQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdDxDZm5HYW1lU2VydmVyR3JvdXAuQXV0b1NjYWxpbmdQb2xpY3lQcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZT4ge1xuICAgIGlmIChjZGsuaXNSZXNvbHZhYmxlT2JqZWN0KHByb3BlcnRpZXMpKSB7XG4gICAgICAgIHJldHVybiBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdChwcm9wZXJ0aWVzKTtcbiAgICB9XG4gICAgcHJvcGVydGllcyA9IHByb3BlcnRpZXMgPT0gbnVsbCA/IHt9IDogcHJvcGVydGllcztcbiAgICBpZiAodHlwZW9mIHByb3BlcnRpZXMgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIHJldHVybiBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdChwcm9wZXJ0aWVzKTtcbiAgICB9XG4gICAgY29uc3QgcmV0ID0gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25Qcm9wZXJ0eU9iamVjdDxDZm5HYW1lU2VydmVyR3JvdXAuQXV0b1NjYWxpbmdQb2xpY3lQcm9wZXJ0eT4oKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2VzdGltYXRlZEluc3RhbmNlV2FybXVwJywgJ0VzdGltYXRlZEluc3RhbmNlV2FybXVwJywgcHJvcGVydGllcy5Fc3RpbWF0ZWRJbnN0YW5jZVdhcm11cCAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXROdW1iZXIocHJvcGVydGllcy5Fc3RpbWF0ZWRJbnN0YW5jZVdhcm11cCkgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgndGFyZ2V0VHJhY2tpbmdDb25maWd1cmF0aW9uJywgJ1RhcmdldFRyYWNraW5nQ29uZmlndXJhdGlvbicsIENmbkdhbWVTZXJ2ZXJHcm91cFRhcmdldFRyYWNraW5nQ29uZmlndXJhdGlvblByb3BlcnR5RnJvbUNsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuVGFyZ2V0VHJhY2tpbmdDb25maWd1cmF0aW9uKSk7XG4gICAgcmV0LmFkZFVucmVjb2duaXplZFByb3BlcnRpZXNBc0V4dHJhKHByb3BlcnRpZXMpO1xuICAgIHJldHVybiByZXQ7XG59XG5cbmV4cG9ydCBuYW1lc3BhY2UgQ2ZuR2FtZVNlcnZlckdyb3VwIHtcbiAgICAvKipcbiAgICAgKiAqVGhpcyBkYXRhIHR5cGUgaXMgdXNlZCB3aXRoIHRoZSBBbWF6b24gR2FtZUxpZnQgRmxlZXRJUSBhbmQgZ2FtZSBzZXJ2ZXIgZ3JvdXBzLipcbiAgICAgKlxuICAgICAqIEFuIGFsbG93ZWQgaW5zdGFuY2UgdHlwZSBmb3IgYSBgR2FtZVNlcnZlckdyb3VwYCAuIEFsbCBnYW1lIHNlcnZlciBncm91cHMgbXVzdCBoYXZlIGF0IGxlYXN0IHR3byBpbnN0YW5jZSB0eXBlcyBkZWZpbmVkIGZvciBpdC4gR2FtZUxpZnQgRmxlZXRJUSBwZXJpb2RpY2FsbHkgZXZhbHVhdGVzIGVhY2ggZGVmaW5lZCBpbnN0YW5jZSB0eXBlIGZvciB2aWFiaWxpdHkuIEl0IHRoZW4gdXBkYXRlcyB0aGUgQXV0byBTY2FsaW5nIGdyb3VwIHdpdGggdGhlIGxpc3Qgb2YgdmlhYmxlIGluc3RhbmNlIHR5cGVzLlxuICAgICAqXG4gICAgICogQHN0cnVjdFxuICAgICAqIEBzdGFiaWxpdHkgZXh0ZXJuYWxcbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtZ2FtZWxpZnQtZ2FtZXNlcnZlcmdyb3VwLWluc3RhbmNlZGVmaW5pdGlvbi5odG1sXG4gICAgICovXG4gICAgZXhwb3J0IGludGVyZmFjZSBJbnN0YW5jZURlZmluaXRpb25Qcm9wZXJ0eSB7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBBbiBBbWF6b24gRUMyIGluc3RhbmNlIHR5cGUgZGVzaWduYXRpb24uXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtZ2FtZWxpZnQtZ2FtZXNlcnZlcmdyb3VwLWluc3RhbmNlZGVmaW5pdGlvbi5odG1sI2Nmbi1nYW1lbGlmdC1nYW1lc2VydmVyZ3JvdXAtaW5zdGFuY2VkZWZpbml0aW9uLWluc3RhbmNldHlwZVxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgaW5zdGFuY2VUeXBlOiBzdHJpbmc7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBJbnN0YW5jZSB3ZWlnaHRpbmcgdGhhdCBpbmRpY2F0ZXMgaG93IG11Y2ggdGhpcyBpbnN0YW5jZSB0eXBlIGNvbnRyaWJ1dGVzIHRvIHRoZSB0b3RhbCBjYXBhY2l0eSBvZiBhIGdhbWUgc2VydmVyIGdyb3VwLiBJbnN0YW5jZSB3ZWlnaHRzIGFyZSB1c2VkIGJ5IEdhbWVMaWZ0IEZsZWV0SVEgdG8gY2FsY3VsYXRlIHRoZSBpbnN0YW5jZSB0eXBlJ3MgY29zdCBwZXIgdW5pdCBob3VyIGFuZCBiZXR0ZXIgaWRlbnRpZnkgdGhlIG1vc3QgY29zdC1lZmZlY3RpdmUgb3B0aW9ucy4gRm9yIGRldGFpbGVkIGluZm9ybWF0aW9uIG9uIHdlaWdodGluZyBpbnN0YW5jZSBjYXBhY2l0eSwgc2VlIFtJbnN0YW5jZSBXZWlnaHRpbmddKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9hdXRvc2NhbGluZy9lYzIvdXNlcmd1aWRlL2FzZy1pbnN0YW5jZS13ZWlnaHRpbmcuaHRtbCkgaW4gdGhlICpBbWF6b24gRWxhc3RpYyBDb21wdXRlIENsb3VkIEF1dG8gU2NhbGluZyBVc2VyIEd1aWRlKiAuIERlZmF1bHQgdmFsdWUgaXMgXCIxXCIuXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtZ2FtZWxpZnQtZ2FtZXNlcnZlcmdyb3VwLWluc3RhbmNlZGVmaW5pdGlvbi5odG1sI2Nmbi1nYW1lbGlmdC1nYW1lc2VydmVyZ3JvdXAtaW5zdGFuY2VkZWZpbml0aW9uLXdlaWdodGVkY2FwYWNpdHlcbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IHdlaWdodGVkQ2FwYWNpdHk/OiBzdHJpbmc7XG4gICAgfVxufVxuXG4vKipcbiAqIERldGVybWluZSB3aGV0aGVyIHRoZSBnaXZlbiBwcm9wZXJ0aWVzIG1hdGNoIHRob3NlIG9mIGEgYEluc3RhbmNlRGVmaW5pdGlvblByb3BlcnR5YFxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBJbnN0YW5jZURlZmluaXRpb25Qcm9wZXJ0eWBcbiAqXG4gKiBAcmV0dXJucyB0aGUgcmVzdWx0IG9mIHRoZSB2YWxpZGF0aW9uLlxuICovXG5mdW5jdGlvbiBDZm5HYW1lU2VydmVyR3JvdXBfSW5zdGFuY2VEZWZpbml0aW9uUHJvcGVydHlWYWxpZGF0b3IocHJvcGVydGllczogYW55KTogY2RrLlZhbGlkYXRpb25SZXN1bHQge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIGNkay5WQUxJREFUSU9OX1NVQ0NFU1M7IH1cbiAgICBjb25zdCBlcnJvcnMgPSBuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHRzKCk7XG4gICAgaWYgKHR5cGVvZiBwcm9wZXJ0aWVzICE9PSAnb2JqZWN0Jykge1xuICAgICAgICBlcnJvcnMuY29sbGVjdChuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHQoJ0V4cGVjdGVkIGFuIG9iamVjdCwgYnV0IHJlY2VpdmVkOiAnICsgSlNPTi5zdHJpbmdpZnkocHJvcGVydGllcykpKTtcbiAgICB9XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdpbnN0YW5jZVR5cGUnLCBjZGsucmVxdWlyZWRWYWxpZGF0b3IpKHByb3BlcnRpZXMuaW5zdGFuY2VUeXBlKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdpbnN0YW5jZVR5cGUnLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuaW5zdGFuY2VUeXBlKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCd3ZWlnaHRlZENhcGFjaXR5JywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLndlaWdodGVkQ2FwYWNpdHkpKTtcbiAgICByZXR1cm4gZXJyb3JzLndyYXAoJ3N1cHBsaWVkIHByb3BlcnRpZXMgbm90IGNvcnJlY3QgZm9yIFwiSW5zdGFuY2VEZWZpbml0aW9uUHJvcGVydHlcIicpO1xufVxuXG4vKipcbiAqIFJlbmRlcnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OkdhbWVMaWZ0OjpHYW1lU2VydmVyR3JvdXAuSW5zdGFuY2VEZWZpbml0aW9uYCByZXNvdXJjZVxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBJbnN0YW5jZURlZmluaXRpb25Qcm9wZXJ0eWBcbiAqXG4gKiBAcmV0dXJucyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6R2FtZUxpZnQ6OkdhbWVTZXJ2ZXJHcm91cC5JbnN0YW5jZURlZmluaXRpb25gIHJlc291cmNlLlxuICovXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gY2ZuR2FtZVNlcnZlckdyb3VwSW5zdGFuY2VEZWZpbml0aW9uUHJvcGVydHlUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGFueSB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gcHJvcGVydGllczsgfVxuICAgIENmbkdhbWVTZXJ2ZXJHcm91cF9JbnN0YW5jZURlZmluaXRpb25Qcm9wZXJ0eVZhbGlkYXRvcihwcm9wZXJ0aWVzKS5hc3NlcnRTdWNjZXNzKCk7XG4gICAgcmV0dXJuIHtcbiAgICAgICAgSW5zdGFuY2VUeXBlOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLmluc3RhbmNlVHlwZSksXG4gICAgICAgIFdlaWdodGVkQ2FwYWNpdHk6IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMud2VpZ2h0ZWRDYXBhY2l0eSksXG4gICAgfTtcbn1cblxuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIENmbkdhbWVTZXJ2ZXJHcm91cEluc3RhbmNlRGVmaW5pdGlvblByb3BlcnR5RnJvbUNsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQ8Q2ZuR2FtZVNlcnZlckdyb3VwLkluc3RhbmNlRGVmaW5pdGlvblByb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlPiB7XG4gICAgaWYgKGNkay5pc1Jlc29sdmFibGVPYmplY3QocHJvcGVydGllcykpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0KHByb3BlcnRpZXMpO1xuICAgIH1cbiAgICBwcm9wZXJ0aWVzID0gcHJvcGVydGllcyA9PSBudWxsID8ge30gOiBwcm9wZXJ0aWVzO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0KHByb3BlcnRpZXMpO1xuICAgIH1cbiAgICBjb25zdCByZXQgPSBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblByb3BlcnR5T2JqZWN0PENmbkdhbWVTZXJ2ZXJHcm91cC5JbnN0YW5jZURlZmluaXRpb25Qcm9wZXJ0eT4oKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2luc3RhbmNlVHlwZScsICdJbnN0YW5jZVR5cGUnLCBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLkluc3RhbmNlVHlwZSkpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnd2VpZ2h0ZWRDYXBhY2l0eScsICdXZWlnaHRlZENhcGFjaXR5JywgcHJvcGVydGllcy5XZWlnaHRlZENhcGFjaXR5ICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLldlaWdodGVkQ2FwYWNpdHkpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkVW5yZWNvZ25pemVkUHJvcGVydGllc0FzRXh0cmEocHJvcGVydGllcyk7XG4gICAgcmV0dXJuIHJldDtcbn1cblxuZXhwb3J0IG5hbWVzcGFjZSBDZm5HYW1lU2VydmVyR3JvdXAge1xuICAgIC8qKlxuICAgICAqICpUaGlzIGRhdGEgdHlwZSBpcyB1c2VkIHdpdGggdGhlIEdhbWVMaWZ0IEZsZWV0SVEgYW5kIGdhbWUgc2VydmVyIGdyb3Vwcy4qXG4gICAgICpcbiAgICAgKiBBbiBBbWF6b24gRUMyIGxhdW5jaCB0ZW1wbGF0ZSB0aGF0IGNvbnRhaW5zIGNvbmZpZ3VyYXRpb24gc2V0dGluZ3MgYW5kIGdhbWUgc2VydmVyIGNvZGUgdG8gYmUgZGVwbG95ZWQgdG8gYWxsIGluc3RhbmNlcyBpbiBhIGdhbWUgc2VydmVyIGdyb3VwLiBUaGUgbGF1bmNoIHRlbXBsYXRlIGlzIHNwZWNpZmllZCB3aGVuIGNyZWF0aW5nIGEgbmV3IGdhbWUgc2VydmVyIGdyb3VwIHdpdGggYEdhbWVTZXJ2ZXJHcm91cGAgLlxuICAgICAqXG4gICAgICogQHN0cnVjdFxuICAgICAqIEBzdGFiaWxpdHkgZXh0ZXJuYWxcbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtZ2FtZWxpZnQtZ2FtZXNlcnZlcmdyb3VwLWxhdW5jaHRlbXBsYXRlLmh0bWxcbiAgICAgKi9cbiAgICBleHBvcnQgaW50ZXJmYWNlIExhdW5jaFRlbXBsYXRlUHJvcGVydHkge1xuICAgICAgICAvKipcbiAgICAgICAgICogQSB1bmlxdWUgaWRlbnRpZmllciBmb3IgYW4gZXhpc3RpbmcgQW1hem9uIEVDMiBsYXVuY2ggdGVtcGxhdGUuXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtZ2FtZWxpZnQtZ2FtZXNlcnZlcmdyb3VwLWxhdW5jaHRlbXBsYXRlLmh0bWwjY2ZuLWdhbWVsaWZ0LWdhbWVzZXJ2ZXJncm91cC1sYXVuY2h0ZW1wbGF0ZS1sYXVuY2h0ZW1wbGF0ZWlkXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBsYXVuY2hUZW1wbGF0ZUlkPzogc3RyaW5nO1xuICAgICAgICAvKipcbiAgICAgICAgICogQSByZWFkYWJsZSBpZGVudGlmaWVyIGZvciBhbiBleGlzdGluZyBBbWF6b24gRUMyIGxhdW5jaCB0ZW1wbGF0ZS5cbiAgICAgICAgICpcbiAgICAgICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1nYW1lbGlmdC1nYW1lc2VydmVyZ3JvdXAtbGF1bmNodGVtcGxhdGUuaHRtbCNjZm4tZ2FtZWxpZnQtZ2FtZXNlcnZlcmdyb3VwLWxhdW5jaHRlbXBsYXRlLWxhdW5jaHRlbXBsYXRlbmFtZVxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgbGF1bmNoVGVtcGxhdGVOYW1lPzogc3RyaW5nO1xuICAgICAgICAvKipcbiAgICAgICAgICogVGhlIHZlcnNpb24gb2YgdGhlIEFtYXpvbiBFQzIgbGF1bmNoIHRlbXBsYXRlIHRvIHVzZS4gSWYgbm8gdmVyc2lvbiBpcyBzcGVjaWZpZWQsIHRoZSBkZWZhdWx0IHZlcnNpb24gd2lsbCBiZSB1c2VkLiBXaXRoIEFtYXpvbiBFQzIsIHlvdSBjYW4gc3BlY2lmeSBhIGRlZmF1bHQgdmVyc2lvbiBmb3IgYSBsYXVuY2ggdGVtcGxhdGUuIElmIG5vbmUgaXMgc2V0LCB0aGUgZGVmYXVsdCBpcyB0aGUgZmlyc3QgdmVyc2lvbiBjcmVhdGVkLlxuICAgICAgICAgKlxuICAgICAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWdhbWVsaWZ0LWdhbWVzZXJ2ZXJncm91cC1sYXVuY2h0ZW1wbGF0ZS5odG1sI2Nmbi1nYW1lbGlmdC1nYW1lc2VydmVyZ3JvdXAtbGF1bmNodGVtcGxhdGUtdmVyc2lvblxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgdmVyc2lvbj86IHN0cmluZztcbiAgICB9XG59XG5cbi8qKlxuICogRGV0ZXJtaW5lIHdoZXRoZXIgdGhlIGdpdmVuIHByb3BlcnRpZXMgbWF0Y2ggdGhvc2Ugb2YgYSBgTGF1bmNoVGVtcGxhdGVQcm9wZXJ0eWBcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgTGF1bmNoVGVtcGxhdGVQcm9wZXJ0eWBcbiAqXG4gKiBAcmV0dXJucyB0aGUgcmVzdWx0IG9mIHRoZSB2YWxpZGF0aW9uLlxuICovXG5mdW5jdGlvbiBDZm5HYW1lU2VydmVyR3JvdXBfTGF1bmNoVGVtcGxhdGVQcm9wZXJ0eVZhbGlkYXRvcihwcm9wZXJ0aWVzOiBhbnkpOiBjZGsuVmFsaWRhdGlvblJlc3VsdCB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gY2RrLlZBTElEQVRJT05fU1VDQ0VTUzsgfVxuICAgIGNvbnN0IGVycm9ycyA9IG5ldyBjZGsuVmFsaWRhdGlvblJlc3VsdHMoKTtcbiAgICBpZiAodHlwZW9mIHByb3BlcnRpZXMgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIGVycm9ycy5jb2xsZWN0KG5ldyBjZGsuVmFsaWRhdGlvblJlc3VsdCgnRXhwZWN0ZWQgYW4gb2JqZWN0LCBidXQgcmVjZWl2ZWQ6ICcgKyBKU09OLnN0cmluZ2lmeShwcm9wZXJ0aWVzKSkpO1xuICAgIH1cbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2xhdW5jaFRlbXBsYXRlSWQnLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMubGF1bmNoVGVtcGxhdGVJZCkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignbGF1bmNoVGVtcGxhdGVOYW1lJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmxhdW5jaFRlbXBsYXRlTmFtZSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigndmVyc2lvbicsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy52ZXJzaW9uKSk7XG4gICAgcmV0dXJuIGVycm9ycy53cmFwKCdzdXBwbGllZCBwcm9wZXJ0aWVzIG5vdCBjb3JyZWN0IGZvciBcIkxhdW5jaFRlbXBsYXRlUHJvcGVydHlcIicpO1xufVxuXG4vKipcbiAqIFJlbmRlcnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OkdhbWVMaWZ0OjpHYW1lU2VydmVyR3JvdXAuTGF1bmNoVGVtcGxhdGVgIHJlc291cmNlXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYExhdW5jaFRlbXBsYXRlUHJvcGVydHlgXG4gKlxuICogQHJldHVybnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OkdhbWVMaWZ0OjpHYW1lU2VydmVyR3JvdXAuTGF1bmNoVGVtcGxhdGVgIHJlc291cmNlLlxuICovXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gY2ZuR2FtZVNlcnZlckdyb3VwTGF1bmNoVGVtcGxhdGVQcm9wZXJ0eVRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogYW55IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBwcm9wZXJ0aWVzOyB9XG4gICAgQ2ZuR2FtZVNlcnZlckdyb3VwX0xhdW5jaFRlbXBsYXRlUHJvcGVydHlWYWxpZGF0b3IocHJvcGVydGllcykuYXNzZXJ0U3VjY2VzcygpO1xuICAgIHJldHVybiB7XG4gICAgICAgIExhdW5jaFRlbXBsYXRlSWQ6IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMubGF1bmNoVGVtcGxhdGVJZCksXG4gICAgICAgIExhdW5jaFRlbXBsYXRlTmFtZTogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5sYXVuY2hUZW1wbGF0ZU5hbWUpLFxuICAgICAgICBWZXJzaW9uOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLnZlcnNpb24pLFxuICAgIH07XG59XG5cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBDZm5HYW1lU2VydmVyR3JvdXBMYXVuY2hUZW1wbGF0ZVByb3BlcnR5RnJvbUNsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQ8Q2ZuR2FtZVNlcnZlckdyb3VwLkxhdW5jaFRlbXBsYXRlUHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGU+IHtcbiAgICBpZiAoY2RrLmlzUmVzb2x2YWJsZU9iamVjdChwcm9wZXJ0aWVzKSkge1xuICAgICAgICByZXR1cm4gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQocHJvcGVydGllcyk7XG4gICAgfVxuICAgIHByb3BlcnRpZXMgPSBwcm9wZXJ0aWVzID09IG51bGwgPyB7fSA6IHByb3BlcnRpZXM7XG4gICAgaWYgKHR5cGVvZiBwcm9wZXJ0aWVzICE9PSAnb2JqZWN0Jykge1xuICAgICAgICByZXR1cm4gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQocHJvcGVydGllcyk7XG4gICAgfVxuICAgIGNvbnN0IHJldCA9IG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUHJvcGVydHlPYmplY3Q8Q2ZuR2FtZVNlcnZlckdyb3VwLkxhdW5jaFRlbXBsYXRlUHJvcGVydHk+KCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdsYXVuY2hUZW1wbGF0ZUlkJywgJ0xhdW5jaFRlbXBsYXRlSWQnLCBwcm9wZXJ0aWVzLkxhdW5jaFRlbXBsYXRlSWQgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuTGF1bmNoVGVtcGxhdGVJZCkgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnbGF1bmNoVGVtcGxhdGVOYW1lJywgJ0xhdW5jaFRlbXBsYXRlTmFtZScsIHByb3BlcnRpZXMuTGF1bmNoVGVtcGxhdGVOYW1lICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLkxhdW5jaFRlbXBsYXRlTmFtZSkgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgndmVyc2lvbicsICdWZXJzaW9uJywgcHJvcGVydGllcy5WZXJzaW9uICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLlZlcnNpb24pIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkVW5yZWNvZ25pemVkUHJvcGVydGllc0FzRXh0cmEocHJvcGVydGllcyk7XG4gICAgcmV0dXJuIHJldDtcbn1cblxuZXhwb3J0IG5hbWVzcGFjZSBDZm5HYW1lU2VydmVyR3JvdXAge1xuICAgIC8qKlxuICAgICAqICpUaGlzIGRhdGEgdHlwZSBpcyB1c2VkIHdpdGggdGhlIEFtYXpvbiBHYW1lTGlmdCBGbGVldElRIGFuZCBnYW1lIHNlcnZlciBncm91cHMuKlxuICAgICAqXG4gICAgICogU2V0dGluZ3MgZm9yIGEgdGFyZ2V0LWJhc2VkIHNjYWxpbmcgcG9saWN5IGFzIHBhcnQgb2YgYSBgR2FtZVNlcnZlckdyb3VwQXV0b1NjYWxpbmdQb2xpY3lgIC4gVGhlc2Ugc2V0dGluZ3MgYXJlIHVzZWQgdG8gY3JlYXRlIGEgdGFyZ2V0LWJhc2VkIHBvbGljeSB0aGF0IHRyYWNrcyB0aGUgR2FtZUxpZnQgRmxlZXRJUSBtZXRyaWMgYFwiUGVyY2VudFV0aWxpemVkR2FtZVNlcnZlcnNcImAgYW5kIHNwZWNpZmllcyBhIHRhcmdldCB2YWx1ZSBmb3IgdGhlIG1ldHJpYy4gQXMgcGxheWVyIHVzYWdlIGNoYW5nZXMsIHRoZSBwb2xpY3kgdHJpZ2dlcnMgdG8gYWRqdXN0IHRoZSBnYW1lIHNlcnZlciBncm91cCBjYXBhY2l0eSBzbyB0aGF0IHRoZSBtZXRyaWMgcmV0dXJucyB0byB0aGUgdGFyZ2V0IHZhbHVlLlxuICAgICAqXG4gICAgICogQHN0cnVjdFxuICAgICAqIEBzdGFiaWxpdHkgZXh0ZXJuYWxcbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtZ2FtZWxpZnQtZ2FtZXNlcnZlcmdyb3VwLXRhcmdldHRyYWNraW5nY29uZmlndXJhdGlvbi5odG1sXG4gICAgICovXG4gICAgZXhwb3J0IGludGVyZmFjZSBUYXJnZXRUcmFja2luZ0NvbmZpZ3VyYXRpb25Qcm9wZXJ0eSB7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBEZXNpcmVkIHZhbHVlIHRvIHVzZSB3aXRoIGEgZ2FtZSBzZXJ2ZXIgZ3JvdXAgdGFyZ2V0LWJhc2VkIHNjYWxpbmcgcG9saWN5LlxuICAgICAgICAgKlxuICAgICAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWdhbWVsaWZ0LWdhbWVzZXJ2ZXJncm91cC10YXJnZXR0cmFja2luZ2NvbmZpZ3VyYXRpb24uaHRtbCNjZm4tZ2FtZWxpZnQtZ2FtZXNlcnZlcmdyb3VwLXRhcmdldHRyYWNraW5nY29uZmlndXJhdGlvbi10YXJnZXR2YWx1ZVxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgdGFyZ2V0VmFsdWU6IG51bWJlcjtcbiAgICB9XG59XG5cbi8qKlxuICogRGV0ZXJtaW5lIHdoZXRoZXIgdGhlIGdpdmVuIHByb3BlcnRpZXMgbWF0Y2ggdGhvc2Ugb2YgYSBgVGFyZ2V0VHJhY2tpbmdDb25maWd1cmF0aW9uUHJvcGVydHlgXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYFRhcmdldFRyYWNraW5nQ29uZmlndXJhdGlvblByb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSByZXN1bHQgb2YgdGhlIHZhbGlkYXRpb24uXG4gKi9cbmZ1bmN0aW9uIENmbkdhbWVTZXJ2ZXJHcm91cF9UYXJnZXRUcmFja2luZ0NvbmZpZ3VyYXRpb25Qcm9wZXJ0eVZhbGlkYXRvcihwcm9wZXJ0aWVzOiBhbnkpOiBjZGsuVmFsaWRhdGlvblJlc3VsdCB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gY2RrLlZBTElEQVRJT05fU1VDQ0VTUzsgfVxuICAgIGNvbnN0IGVycm9ycyA9IG5ldyBjZGsuVmFsaWRhdGlvblJlc3VsdHMoKTtcbiAgICBpZiAodHlwZW9mIHByb3BlcnRpZXMgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIGVycm9ycy5jb2xsZWN0KG5ldyBjZGsuVmFsaWRhdGlvblJlc3VsdCgnRXhwZWN0ZWQgYW4gb2JqZWN0LCBidXQgcmVjZWl2ZWQ6ICcgKyBKU09OLnN0cmluZ2lmeShwcm9wZXJ0aWVzKSkpO1xuICAgIH1cbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3RhcmdldFZhbHVlJywgY2RrLnJlcXVpcmVkVmFsaWRhdG9yKShwcm9wZXJ0aWVzLnRhcmdldFZhbHVlKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCd0YXJnZXRWYWx1ZScsIGNkay52YWxpZGF0ZU51bWJlcikocHJvcGVydGllcy50YXJnZXRWYWx1ZSkpO1xuICAgIHJldHVybiBlcnJvcnMud3JhcCgnc3VwcGxpZWQgcHJvcGVydGllcyBub3QgY29ycmVjdCBmb3IgXCJUYXJnZXRUcmFja2luZ0NvbmZpZ3VyYXRpb25Qcm9wZXJ0eVwiJyk7XG59XG5cbi8qKlxuICogUmVuZGVycyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6R2FtZUxpZnQ6OkdhbWVTZXJ2ZXJHcm91cC5UYXJnZXRUcmFja2luZ0NvbmZpZ3VyYXRpb25gIHJlc291cmNlXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYFRhcmdldFRyYWNraW5nQ29uZmlndXJhdGlvblByb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpHYW1lTGlmdDo6R2FtZVNlcnZlckdyb3VwLlRhcmdldFRyYWNraW5nQ29uZmlndXJhdGlvbmAgcmVzb3VyY2UuXG4gKi9cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBjZm5HYW1lU2VydmVyR3JvdXBUYXJnZXRUcmFja2luZ0NvbmZpZ3VyYXRpb25Qcm9wZXJ0eVRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogYW55IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBwcm9wZXJ0aWVzOyB9XG4gICAgQ2ZuR2FtZVNlcnZlckdyb3VwX1RhcmdldFRyYWNraW5nQ29uZmlndXJhdGlvblByb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXMpLmFzc2VydFN1Y2Nlc3MoKTtcbiAgICByZXR1cm4ge1xuICAgICAgICBUYXJnZXRWYWx1ZTogY2RrLm51bWJlclRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy50YXJnZXRWYWx1ZSksXG4gICAgfTtcbn1cblxuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIENmbkdhbWVTZXJ2ZXJHcm91cFRhcmdldFRyYWNraW5nQ29uZmlndXJhdGlvblByb3BlcnR5RnJvbUNsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQ8Q2ZuR2FtZVNlcnZlckdyb3VwLlRhcmdldFRyYWNraW5nQ29uZmlndXJhdGlvblByb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlPiB7XG4gICAgaWYgKGNkay5pc1Jlc29sdmFibGVPYmplY3QocHJvcGVydGllcykpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0KHByb3BlcnRpZXMpO1xuICAgIH1cbiAgICBwcm9wZXJ0aWVzID0gcHJvcGVydGllcyA9PSBudWxsID8ge30gOiBwcm9wZXJ0aWVzO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0KHByb3BlcnRpZXMpO1xuICAgIH1cbiAgICBjb25zdCByZXQgPSBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblByb3BlcnR5T2JqZWN0PENmbkdhbWVTZXJ2ZXJHcm91cC5UYXJnZXRUcmFja2luZ0NvbmZpZ3VyYXRpb25Qcm9wZXJ0eT4oKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ3RhcmdldFZhbHVlJywgJ1RhcmdldFZhbHVlJywgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXROdW1iZXIocHJvcGVydGllcy5UYXJnZXRWYWx1ZSkpO1xuICAgIHJldC5hZGRVbnJlY29nbml6ZWRQcm9wZXJ0aWVzQXNFeHRyYShwcm9wZXJ0aWVzKTtcbiAgICByZXR1cm4gcmV0O1xufVxuXG4vKipcbiAqIFByb3BlcnRpZXMgZm9yIGRlZmluaW5nIGEgYENmbkdhbWVTZXNzaW9uUXVldWVgXG4gKlxuICogQHN0cnVjdFxuICogQHN0YWJpbGl0eSBleHRlcm5hbFxuICpcbiAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWdhbWVsaWZ0LWdhbWVzZXNzaW9ucXVldWUuaHRtbFxuICovXG5leHBvcnQgaW50ZXJmYWNlIENmbkdhbWVTZXNzaW9uUXVldWVQcm9wcyB7XG5cbiAgICAvKipcbiAgICAgKiBBIGRlc2NyaXB0aXZlIGxhYmVsIHRoYXQgaXMgYXNzb2NpYXRlZCB3aXRoIGdhbWUgc2Vzc2lvbiBxdWV1ZS4gUXVldWUgbmFtZXMgbXVzdCBiZSB1bmlxdWUgd2l0aGluIGVhY2ggUmVnaW9uLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZ2FtZWxpZnQtZ2FtZXNlc3Npb25xdWV1ZS5odG1sI2Nmbi1nYW1lbGlmdC1nYW1lc2Vzc2lvbnF1ZXVlLW5hbWVcbiAgICAgKi9cbiAgICByZWFkb25seSBuYW1lOiBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBJbmZvcm1hdGlvbiB0byBiZSBhZGRlZCB0byBhbGwgZXZlbnRzIHRoYXQgYXJlIHJlbGF0ZWQgdG8gdGhpcyBnYW1lIHNlc3Npb24gcXVldWUuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1nYW1lbGlmdC1nYW1lc2Vzc2lvbnF1ZXVlLmh0bWwjY2ZuLWdhbWVsaWZ0LWdhbWVzZXNzaW9ucXVldWUtY3VzdG9tZXZlbnRkYXRhXG4gICAgICovXG4gICAgcmVhZG9ubHkgY3VzdG9tRXZlbnREYXRhPzogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogQSBsaXN0IG9mIGZsZWV0cyBhbmQvb3IgZmxlZXQgYWxpYXNlcyB0aGF0IGNhbiBiZSB1c2VkIHRvIGZ1bGZpbGwgZ2FtZSBzZXNzaW9uIHBsYWNlbWVudCByZXF1ZXN0cyBpbiB0aGUgcXVldWUuIERlc3RpbmF0aW9ucyBhcmUgaWRlbnRpZmllZCBieSBlaXRoZXIgYSBmbGVldCBBUk4gb3IgYSBmbGVldCBhbGlhcyBBUk4sIGFuZCBhcmUgbGlzdGVkIGluIG9yZGVyIG9mIHBsYWNlbWVudCBwcmVmZXJlbmNlLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZ2FtZWxpZnQtZ2FtZXNlc3Npb25xdWV1ZS5odG1sI2Nmbi1nYW1lbGlmdC1nYW1lc2Vzc2lvbnF1ZXVlLWRlc3RpbmF0aW9uc1xuICAgICAqL1xuICAgIHJlYWRvbmx5IGRlc3RpbmF0aW9ucz86IEFycmF5PENmbkdhbWVTZXNzaW9uUXVldWUuRGVzdGluYXRpb25Qcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZT4gfCBjZGsuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBBIGxpc3Qgb2YgbG9jYXRpb25zIHdoZXJlIGEgcXVldWUgaXMgYWxsb3dlZCB0byBwbGFjZSBuZXcgZ2FtZSBzZXNzaW9ucy4gTG9jYXRpb25zIGFyZSBzcGVjaWZpZWQgaW4gdGhlIGZvcm0gb2YgQVdTIFJlZ2lvbiBjb2Rlcywgc3VjaCBhcyBgdXMtd2VzdC0yYCAuIElmIHRoaXMgcGFyYW1ldGVyIGlzIG5vdCBzZXQsIGdhbWUgc2Vzc2lvbnMgY2FuIGJlIHBsYWNlZCBpbiBhbnkgcXVldWUgbG9jYXRpb24uXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1nYW1lbGlmdC1nYW1lc2Vzc2lvbnF1ZXVlLmh0bWwjY2ZuLWdhbWVsaWZ0LWdhbWVzZXNzaW9ucXVldWUtZmlsdGVyY29uZmlndXJhdGlvblxuICAgICAqL1xuICAgIHJlYWRvbmx5IGZpbHRlckNvbmZpZ3VyYXRpb24/OiBDZm5HYW1lU2Vzc2lvblF1ZXVlLkZpbHRlckNvbmZpZ3VyYXRpb25Qcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIEFuIFNOUyB0b3BpYyBBUk4gdGhhdCBpcyBzZXQgdXAgdG8gcmVjZWl2ZSBnYW1lIHNlc3Npb24gcGxhY2VtZW50IG5vdGlmaWNhdGlvbnMuIFNlZSBbU2V0dGluZyB1cCBub3RpZmljYXRpb25zIGZvciBnYW1lIHNlc3Npb24gcGxhY2VtZW50XShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZ2FtZWxpZnQvbGF0ZXN0L2RldmVsb3Blcmd1aWRlL3F1ZXVlLW5vdGlmaWNhdGlvbi5odG1sKSAuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1nYW1lbGlmdC1nYW1lc2Vzc2lvbnF1ZXVlLmh0bWwjY2ZuLWdhbWVsaWZ0LWdhbWVzZXNzaW9ucXVldWUtbm90aWZpY2F0aW9udGFyZ2V0XG4gICAgICovXG4gICAgcmVhZG9ubHkgbm90aWZpY2F0aW9uVGFyZ2V0Pzogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogQSBzZXQgb2YgcG9saWNpZXMgdGhhdCBhY3QgYXMgYSBzbGlkaW5nIGNhcCBvbiBwbGF5ZXIgbGF0ZW5jeS4gRmxlZXRJUSB3b3JrcyB0byBkZWxpdmVyIGxvdyBsYXRlbmN5IGZvciBtb3N0IHBsYXllcnMgaW4gYSBnYW1lIHNlc3Npb24uIFRoZXNlIHBvbGljaWVzIGVuc3VyZSB0aGF0IG5vIGluZGl2aWR1YWwgcGxheWVyIGNhbiBiZSBwbGFjZWQgaW50byBhIGdhbWUgd2l0aCB1bnJlYXNvbmFibHkgaGlnaCBsYXRlbmN5LiBVc2UgbXVsdGlwbGUgcG9saWNpZXMgdG8gZ3JhZHVhbGx5IHJlbGF4IGxhdGVuY3kgcmVxdWlyZW1lbnRzIGEgc3RlcCBhdCBhIHRpbWUuIE11bHRpcGxlIHBvbGljaWVzIGFyZSBhcHBsaWVkIGJhc2VkIG9uIHRoZWlyIG1heGltdW0gYWxsb3dlZCBsYXRlbmN5LCBzdGFydGluZyB3aXRoIHRoZSBsb3dlc3QgdmFsdWUuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1nYW1lbGlmdC1nYW1lc2Vzc2lvbnF1ZXVlLmh0bWwjY2ZuLWdhbWVsaWZ0LWdhbWVzZXNzaW9ucXVldWUtcGxheWVybGF0ZW5jeXBvbGljaWVzXG4gICAgICovXG4gICAgcmVhZG9ubHkgcGxheWVyTGF0ZW5jeVBvbGljaWVzPzogQXJyYXk8Q2ZuR2FtZVNlc3Npb25RdWV1ZS5QbGF5ZXJMYXRlbmN5UG9saWN5UHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGU+IHwgY2RrLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQ3VzdG9tIHNldHRpbmdzIHRvIHVzZSB3aGVuIHByaW9yaXRpemluZyBkZXN0aW5hdGlvbnMgYW5kIGxvY2F0aW9ucyBmb3IgZ2FtZSBzZXNzaW9uIHBsYWNlbWVudHMuIFRoaXMgY29uZmlndXJhdGlvbiByZXBsYWNlcyB0aGUgRmxlZXRJUSBkZWZhdWx0IHByaW9yaXRpemF0aW9uIHByb2Nlc3MuIFByaW9yaXR5IHR5cGVzIHRoYXQgYXJlIG5vdCBleHBsaWNpdGx5IG5hbWVkIHdpbGwgYmUgYXV0b21hdGljYWxseSBhcHBsaWVkIGF0IHRoZSBlbmQgb2YgdGhlIHByaW9yaXRpemF0aW9uIHByb2Nlc3MuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1nYW1lbGlmdC1nYW1lc2Vzc2lvbnF1ZXVlLmh0bWwjY2ZuLWdhbWVsaWZ0LWdhbWVzZXNzaW9ucXVldWUtcHJpb3JpdHljb25maWd1cmF0aW9uXG4gICAgICovXG4gICAgcmVhZG9ubHkgcHJpb3JpdHlDb25maWd1cmF0aW9uPzogQ2ZuR2FtZVNlc3Npb25RdWV1ZS5Qcmlvcml0eUNvbmZpZ3VyYXRpb25Qcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIEEgbGlzdCBvZiBsYWJlbHMgdG8gYXNzaWduIHRvIHRoZSBuZXcgZ2FtZSBzZXNzaW9uIHF1ZXVlIHJlc291cmNlLiBUYWdzIGFyZSBkZXZlbG9wZXItZGVmaW5lZCBrZXktdmFsdWUgcGFpcnMuIFRhZ2dpbmcgQVdTIHJlc291cmNlcyBhcmUgdXNlZnVsIGZvciByZXNvdXJjZSBtYW5hZ2VtZW50LCBhY2Nlc3MgbWFuYWdlbWVudCBhbmQgY29zdCBhbGxvY2F0aW9uLiBGb3IgbW9yZSBpbmZvcm1hdGlvbiwgc2VlIFtUYWdnaW5nIEFXUyBSZXNvdXJjZXNdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9nZW5lcmFsL2xhdGVzdC9nci9hd3NfdGFnZ2luZy5odG1sKSBpbiB0aGUgKkFXUyBHZW5lcmFsIFJlZmVyZW5jZSogLiBPbmNlIHRoZSByZXNvdXJjZSBpcyBjcmVhdGVkLCB5b3UgY2FuIHVzZSBUYWdSZXNvdXJjZSwgVW50YWdSZXNvdXJjZSwgYW5kIExpc3RUYWdzRm9yUmVzb3VyY2UgdG8gYWRkLCByZW1vdmUsIGFuZCB2aWV3IHRhZ3MuIFRoZSBtYXhpbXVtIHRhZyBsaW1pdCBtYXkgYmUgbG93ZXIgdGhhbiBzdGF0ZWQuIFNlZSB0aGUgQVdTIEdlbmVyYWwgUmVmZXJlbmNlIGZvciBhY3R1YWwgdGFnZ2luZyBsaW1pdHMuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1nYW1lbGlmdC1nYW1lc2Vzc2lvbnF1ZXVlLmh0bWwjY2ZuLWdhbWVsaWZ0LWdhbWVzZXNzaW9ucXVldWUtdGFnc1xuICAgICAqL1xuICAgIHJlYWRvbmx5IHRhZ3M/OiBjZGsuQ2ZuVGFnW107XG5cbiAgICAvKipcbiAgICAgKiBUaGUgbWF4aW11bSB0aW1lLCBpbiBzZWNvbmRzLCB0aGF0IGEgbmV3IGdhbWUgc2Vzc2lvbiBwbGFjZW1lbnQgcmVxdWVzdCByZW1haW5zIGluIHRoZSBxdWV1ZS4gV2hlbiBhIHJlcXVlc3QgZXhjZWVkcyB0aGlzIHRpbWUsIHRoZSBnYW1lIHNlc3Npb24gcGxhY2VtZW50IGNoYW5nZXMgdG8gYSBgVElNRURfT1VUYCBzdGF0dXMuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1nYW1lbGlmdC1nYW1lc2Vzc2lvbnF1ZXVlLmh0bWwjY2ZuLWdhbWVsaWZ0LWdhbWVzZXNzaW9ucXVldWUtdGltZW91dGluc2Vjb25kc1xuICAgICAqL1xuICAgIHJlYWRvbmx5IHRpbWVvdXRJblNlY29uZHM/OiBudW1iZXI7XG59XG5cbi8qKlxuICogRGV0ZXJtaW5lIHdoZXRoZXIgdGhlIGdpdmVuIHByb3BlcnRpZXMgbWF0Y2ggdGhvc2Ugb2YgYSBgQ2ZuR2FtZVNlc3Npb25RdWV1ZVByb3BzYFxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBDZm5HYW1lU2Vzc2lvblF1ZXVlUHJvcHNgXG4gKlxuICogQHJldHVybnMgdGhlIHJlc3VsdCBvZiB0aGUgdmFsaWRhdGlvbi5cbiAqL1xuZnVuY3Rpb24gQ2ZuR2FtZVNlc3Npb25RdWV1ZVByb3BzVmFsaWRhdG9yKHByb3BlcnRpZXM6IGFueSk6IGNkay5WYWxpZGF0aW9uUmVzdWx0IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBjZGsuVkFMSURBVElPTl9TVUNDRVNTOyB9XG4gICAgY29uc3QgZXJyb3JzID0gbmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0cygpO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgZXJyb3JzLmNvbGxlY3QobmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0KCdFeHBlY3RlZCBhbiBvYmplY3QsIGJ1dCByZWNlaXZlZDogJyArIEpTT04uc3RyaW5naWZ5KHByb3BlcnRpZXMpKSk7XG4gICAgfVxuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignY3VzdG9tRXZlbnREYXRhJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmN1c3RvbUV2ZW50RGF0YSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignZGVzdGluYXRpb25zJywgY2RrLmxpc3RWYWxpZGF0b3IoQ2ZuR2FtZVNlc3Npb25RdWV1ZV9EZXN0aW5hdGlvblByb3BlcnR5VmFsaWRhdG9yKSkocHJvcGVydGllcy5kZXN0aW5hdGlvbnMpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2ZpbHRlckNvbmZpZ3VyYXRpb24nLCBDZm5HYW1lU2Vzc2lvblF1ZXVlX0ZpbHRlckNvbmZpZ3VyYXRpb25Qcm9wZXJ0eVZhbGlkYXRvcikocHJvcGVydGllcy5maWx0ZXJDb25maWd1cmF0aW9uKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCduYW1lJywgY2RrLnJlcXVpcmVkVmFsaWRhdG9yKShwcm9wZXJ0aWVzLm5hbWUpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ25hbWUnLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMubmFtZSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignbm90aWZpY2F0aW9uVGFyZ2V0JywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLm5vdGlmaWNhdGlvblRhcmdldCkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigncGxheWVyTGF0ZW5jeVBvbGljaWVzJywgY2RrLmxpc3RWYWxpZGF0b3IoQ2ZuR2FtZVNlc3Npb25RdWV1ZV9QbGF5ZXJMYXRlbmN5UG9saWN5UHJvcGVydHlWYWxpZGF0b3IpKShwcm9wZXJ0aWVzLnBsYXllckxhdGVuY3lQb2xpY2llcykpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigncHJpb3JpdHlDb25maWd1cmF0aW9uJywgQ2ZuR2FtZVNlc3Npb25RdWV1ZV9Qcmlvcml0eUNvbmZpZ3VyYXRpb25Qcm9wZXJ0eVZhbGlkYXRvcikocHJvcGVydGllcy5wcmlvcml0eUNvbmZpZ3VyYXRpb24pKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3RhZ3MnLCBjZGsubGlzdFZhbGlkYXRvcihjZGsudmFsaWRhdGVDZm5UYWcpKShwcm9wZXJ0aWVzLnRhZ3MpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3RpbWVvdXRJblNlY29uZHMnLCBjZGsudmFsaWRhdGVOdW1iZXIpKHByb3BlcnRpZXMudGltZW91dEluU2Vjb25kcykpO1xuICAgIHJldHVybiBlcnJvcnMud3JhcCgnc3VwcGxpZWQgcHJvcGVydGllcyBub3QgY29ycmVjdCBmb3IgXCJDZm5HYW1lU2Vzc2lvblF1ZXVlUHJvcHNcIicpO1xufVxuXG4vKipcbiAqIFJlbmRlcnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OkdhbWVMaWZ0OjpHYW1lU2Vzc2lvblF1ZXVlYCByZXNvdXJjZVxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBDZm5HYW1lU2Vzc2lvblF1ZXVlUHJvcHNgXG4gKlxuICogQHJldHVybnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OkdhbWVMaWZ0OjpHYW1lU2Vzc2lvblF1ZXVlYCByZXNvdXJjZS5cbiAqL1xuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIGNmbkdhbWVTZXNzaW9uUXVldWVQcm9wc1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogYW55IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBwcm9wZXJ0aWVzOyB9XG4gICAgQ2ZuR2FtZVNlc3Npb25RdWV1ZVByb3BzVmFsaWRhdG9yKHByb3BlcnRpZXMpLmFzc2VydFN1Y2Nlc3MoKTtcbiAgICByZXR1cm4ge1xuICAgICAgICBOYW1lOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLm5hbWUpLFxuICAgICAgICBDdXN0b21FdmVudERhdGE6IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuY3VzdG9tRXZlbnREYXRhKSxcbiAgICAgICAgRGVzdGluYXRpb25zOiBjZGsubGlzdE1hcHBlcihjZm5HYW1lU2Vzc2lvblF1ZXVlRGVzdGluYXRpb25Qcm9wZXJ0eVRvQ2xvdWRGb3JtYXRpb24pKHByb3BlcnRpZXMuZGVzdGluYXRpb25zKSxcbiAgICAgICAgRmlsdGVyQ29uZmlndXJhdGlvbjogY2ZuR2FtZVNlc3Npb25RdWV1ZUZpbHRlckNvbmZpZ3VyYXRpb25Qcm9wZXJ0eVRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5maWx0ZXJDb25maWd1cmF0aW9uKSxcbiAgICAgICAgTm90aWZpY2F0aW9uVGFyZ2V0OiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLm5vdGlmaWNhdGlvblRhcmdldCksXG4gICAgICAgIFBsYXllckxhdGVuY3lQb2xpY2llczogY2RrLmxpc3RNYXBwZXIoY2ZuR2FtZVNlc3Npb25RdWV1ZVBsYXllckxhdGVuY3lQb2xpY3lQcm9wZXJ0eVRvQ2xvdWRGb3JtYXRpb24pKHByb3BlcnRpZXMucGxheWVyTGF0ZW5jeVBvbGljaWVzKSxcbiAgICAgICAgUHJpb3JpdHlDb25maWd1cmF0aW9uOiBjZm5HYW1lU2Vzc2lvblF1ZXVlUHJpb3JpdHlDb25maWd1cmF0aW9uUHJvcGVydHlUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMucHJpb3JpdHlDb25maWd1cmF0aW9uKSxcbiAgICAgICAgVGFnczogY2RrLmxpc3RNYXBwZXIoY2RrLmNmblRhZ1RvQ2xvdWRGb3JtYXRpb24pKHByb3BlcnRpZXMudGFncyksXG4gICAgICAgIFRpbWVvdXRJblNlY29uZHM6IGNkay5udW1iZXJUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMudGltZW91dEluU2Vjb25kcyksXG4gICAgfTtcbn1cblxuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIENmbkdhbWVTZXNzaW9uUXVldWVQcm9wc0Zyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0PENmbkdhbWVTZXNzaW9uUXVldWVQcm9wcz4ge1xuICAgIHByb3BlcnRpZXMgPSBwcm9wZXJ0aWVzID09IG51bGwgPyB7fSA6IHByb3BlcnRpZXM7XG4gICAgaWYgKHR5cGVvZiBwcm9wZXJ0aWVzICE9PSAnb2JqZWN0Jykge1xuICAgICAgICByZXR1cm4gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQocHJvcGVydGllcyk7XG4gICAgfVxuICAgIGNvbnN0IHJldCA9IG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUHJvcGVydHlPYmplY3Q8Q2ZuR2FtZVNlc3Npb25RdWV1ZVByb3BzPigpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnbmFtZScsICdOYW1lJywgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5OYW1lKSk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdjdXN0b21FdmVudERhdGEnLCAnQ3VzdG9tRXZlbnREYXRhJywgcHJvcGVydGllcy5DdXN0b21FdmVudERhdGEgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuQ3VzdG9tRXZlbnREYXRhKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdkZXN0aW5hdGlvbnMnLCAnRGVzdGluYXRpb25zJywgcHJvcGVydGllcy5EZXN0aW5hdGlvbnMgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0QXJyYXkoQ2ZuR2FtZVNlc3Npb25RdWV1ZURlc3RpbmF0aW9uUHJvcGVydHlGcm9tQ2xvdWRGb3JtYXRpb24pKHByb3BlcnRpZXMuRGVzdGluYXRpb25zKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdmaWx0ZXJDb25maWd1cmF0aW9uJywgJ0ZpbHRlckNvbmZpZ3VyYXRpb24nLCBwcm9wZXJ0aWVzLkZpbHRlckNvbmZpZ3VyYXRpb24gIT0gbnVsbCA/IENmbkdhbWVTZXNzaW9uUXVldWVGaWx0ZXJDb25maWd1cmF0aW9uUHJvcGVydHlGcm9tQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5GaWx0ZXJDb25maWd1cmF0aW9uKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdub3RpZmljYXRpb25UYXJnZXQnLCAnTm90aWZpY2F0aW9uVGFyZ2V0JywgcHJvcGVydGllcy5Ob3RpZmljYXRpb25UYXJnZXQgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuTm90aWZpY2F0aW9uVGFyZ2V0KSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdwbGF5ZXJMYXRlbmN5UG9saWNpZXMnLCAnUGxheWVyTGF0ZW5jeVBvbGljaWVzJywgcHJvcGVydGllcy5QbGF5ZXJMYXRlbmN5UG9saWNpZXMgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0QXJyYXkoQ2ZuR2FtZVNlc3Npb25RdWV1ZVBsYXllckxhdGVuY3lQb2xpY3lQcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbikocHJvcGVydGllcy5QbGF5ZXJMYXRlbmN5UG9saWNpZXMpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ3ByaW9yaXR5Q29uZmlndXJhdGlvbicsICdQcmlvcml0eUNvbmZpZ3VyYXRpb24nLCBwcm9wZXJ0aWVzLlByaW9yaXR5Q29uZmlndXJhdGlvbiAhPSBudWxsID8gQ2ZuR2FtZVNlc3Npb25RdWV1ZVByaW9yaXR5Q29uZmlndXJhdGlvblByb3BlcnR5RnJvbUNsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuUHJpb3JpdHlDb25maWd1cmF0aW9uKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCd0YWdzJywgJ1RhZ3MnLCBwcm9wZXJ0aWVzLlRhZ3MgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0QXJyYXkoY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRDZm5UYWcpKHByb3BlcnRpZXMuVGFncykgOiB1bmRlZmluZWQgYXMgYW55KTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ3RpbWVvdXRJblNlY29uZHMnLCAnVGltZW91dEluU2Vjb25kcycsIHByb3BlcnRpZXMuVGltZW91dEluU2Vjb25kcyAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXROdW1iZXIocHJvcGVydGllcy5UaW1lb3V0SW5TZWNvbmRzKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFVucmVjb2duaXplZFByb3BlcnRpZXNBc0V4dHJhKHByb3BlcnRpZXMpO1xuICAgIHJldHVybiByZXQ7XG59XG5cbi8qKlxuICogQSBDbG91ZEZvcm1hdGlvbiBgQVdTOjpHYW1lTGlmdDo6R2FtZVNlc3Npb25RdWV1ZWBcbiAqXG4gKiBUaGUgYEFXUzo6R2FtZUxpZnQ6OkdhbWVTZXNzaW9uUXVldWVgIHJlc291cmNlIGNyZWF0ZXMgYSBwbGFjZW1lbnQgcXVldWUgdGhhdCBwcm9jZXNzZXMgcmVxdWVzdHMgZm9yIG5ldyBnYW1lIHNlc3Npb25zLiBBIHF1ZXVlIHVzZXMgRmxlZXRJUSBhbGdvcml0aG1zIHRvIGRldGVybWluZSB0aGUgYmVzdCBwbGFjZW1lbnQgbG9jYXRpb25zIGFuZCBmaW5kIGFuIGF2YWlsYWJsZSBnYW1lIHNlcnZlciwgdGhlbiBwcm9tcHRzIHRoZSBnYW1lIHNlcnZlciB0byBzdGFydCBhIG5ldyBnYW1lIHNlc3Npb24uIFF1ZXVlcyBjYW4gaGF2ZSBkZXN0aW5hdGlvbnMgKEdhbWVMaWZ0IGZsZWV0cyBvciBhbGlhc2VzKSwgd2hpY2ggZGV0ZXJtaW5lIHdoZXJlIHRoZSBxdWV1ZSBjYW4gcGxhY2UgbmV3IGdhbWUgc2Vzc2lvbnMuIEEgcXVldWUgY2FuIGhhdmUgZGVzdGluYXRpb25zIHdpdGggdmFyaWVkIGZsZWV0IHR5cGUgKFNwb3QgYW5kIE9uLURlbWFuZCksIGluc3RhbmNlIHR5cGUsIGFuZCBBV1MgUmVnaW9uIC5cbiAqXG4gKiBAY2xvdWRmb3JtYXRpb25SZXNvdXJjZSBBV1M6OkdhbWVMaWZ0OjpHYW1lU2Vzc2lvblF1ZXVlXG4gKiBAc3RhYmlsaXR5IGV4dGVybmFsXG4gKlxuICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZ2FtZWxpZnQtZ2FtZXNlc3Npb25xdWV1ZS5odG1sXG4gKi9cbmV4cG9ydCBjbGFzcyBDZm5HYW1lU2Vzc2lvblF1ZXVlIGV4dGVuZHMgY2RrLkNmblJlc291cmNlIGltcGxlbWVudHMgY2RrLklJbnNwZWN0YWJsZSB7XG4gICAgLyoqXG4gICAgICogVGhlIENsb3VkRm9ybWF0aW9uIHJlc291cmNlIHR5cGUgbmFtZSBmb3IgdGhpcyByZXNvdXJjZSBjbGFzcy5cbiAgICAgKi9cbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IENGTl9SRVNPVVJDRV9UWVBFX05BTUUgPSBcIkFXUzo6R2FtZUxpZnQ6OkdhbWVTZXNzaW9uUXVldWVcIjtcblxuICAgIC8qKlxuICAgICAqIEEgZmFjdG9yeSBtZXRob2QgdGhhdCBjcmVhdGVzIGEgbmV3IGluc3RhbmNlIG9mIHRoaXMgY2xhc3MgZnJvbSBhbiBvYmplY3RcbiAgICAgKiBjb250YWluaW5nIHRoZSBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIHRoaXMgcmVzb3VyY2UuXG4gICAgICogVXNlZCBpbiB0aGUgQGF3cy1jZGsvY2xvdWRmb3JtYXRpb24taW5jbHVkZSBtb2R1bGUuXG4gICAgICpcbiAgICAgKiBAaW50ZXJuYWxcbiAgICAgKi9cbiAgICBwdWJsaWMgc3RhdGljIF9mcm9tQ2xvdWRGb3JtYXRpb24oc2NvcGU6IGNkay5Db25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHJlc291cmNlQXR0cmlidXRlczogYW55LCBvcHRpb25zOiBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uT3B0aW9ucyk6IENmbkdhbWVTZXNzaW9uUXVldWUge1xuICAgICAgICByZXNvdXJjZUF0dHJpYnV0ZXMgPSByZXNvdXJjZUF0dHJpYnV0ZXMgfHwge307XG4gICAgICAgIGNvbnN0IHJlc291cmNlUHJvcGVydGllcyA9IG9wdGlvbnMucGFyc2VyLnBhcnNlVmFsdWUocmVzb3VyY2VBdHRyaWJ1dGVzLlByb3BlcnRpZXMpO1xuICAgICAgICBjb25zdCBwcm9wc1Jlc3VsdCA9IENmbkdhbWVTZXNzaW9uUXVldWVQcm9wc0Zyb21DbG91ZEZvcm1hdGlvbihyZXNvdXJjZVByb3BlcnRpZXMpO1xuICAgICAgICBjb25zdCByZXQgPSBuZXcgQ2ZuR2FtZVNlc3Npb25RdWV1ZShzY29wZSwgaWQsIHByb3BzUmVzdWx0LnZhbHVlKTtcbiAgICAgICAgZm9yIChjb25zdCBbcHJvcEtleSwgcHJvcFZhbF0gb2YgT2JqZWN0LmVudHJpZXMocHJvcHNSZXN1bHQuZXh0cmFQcm9wZXJ0aWVzKSkgIHtcbiAgICAgICAgICAgIHJldC5hZGRQcm9wZXJ0eU92ZXJyaWRlKHByb3BLZXksIHByb3BWYWwpO1xuICAgICAgICB9XG4gICAgICAgIG9wdGlvbnMucGFyc2VyLmhhbmRsZUF0dHJpYnV0ZXMocmV0LCByZXNvdXJjZUF0dHJpYnV0ZXMsIGlkKTtcbiAgICAgICAgcmV0dXJuIHJldDtcbiAgICB9XG5cbiAgICAvKipcbiAgICAgKiBUaGUgdW5pcXVlIEFtYXpvbiBSZXNvdXJjZSBOYW1lIChBUk4pIGZvciB0aGUgYEdhbWVTZXNzaW9uUXVldWVgIC5cbiAgICAgKiBAY2xvdWRmb3JtYXRpb25BdHRyaWJ1dGUgQXJuXG4gICAgICovXG4gICAgcHVibGljIHJlYWRvbmx5IGF0dHJBcm46IHN0cmluZztcblxuICAgIC8qKlxuICAgICAqIEEgZGVzY3JpcHRpdmUgbGFiZWwgdGhhdCBpcyBhc3NvY2lhdGVkIHdpdGggYSBnYW1lIHNlc3Npb24gcXVldWUuIE5hbWVzIGFyZSB1bmlxdWUgd2l0aGluIGVhY2ggUmVnaW9uLlxuICAgICAqIEBjbG91ZGZvcm1hdGlvbkF0dHJpYnV0ZSBOYW1lXG4gICAgICovXG4gICAgcHVibGljIHJlYWRvbmx5IGF0dHJOYW1lOiBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBBIGRlc2NyaXB0aXZlIGxhYmVsIHRoYXQgaXMgYXNzb2NpYXRlZCB3aXRoIGdhbWUgc2Vzc2lvbiBxdWV1ZS4gUXVldWUgbmFtZXMgbXVzdCBiZSB1bmlxdWUgd2l0aGluIGVhY2ggUmVnaW9uLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZ2FtZWxpZnQtZ2FtZXNlc3Npb25xdWV1ZS5odG1sI2Nmbi1nYW1lbGlmdC1nYW1lc2Vzc2lvbnF1ZXVlLW5hbWVcbiAgICAgKi9cbiAgICBwdWJsaWMgbmFtZTogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogSW5mb3JtYXRpb24gdG8gYmUgYWRkZWQgdG8gYWxsIGV2ZW50cyB0aGF0IGFyZSByZWxhdGVkIHRvIHRoaXMgZ2FtZSBzZXNzaW9uIHF1ZXVlLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZ2FtZWxpZnQtZ2FtZXNlc3Npb25xdWV1ZS5odG1sI2Nmbi1nYW1lbGlmdC1nYW1lc2Vzc2lvbnF1ZXVlLWN1c3RvbWV2ZW50ZGF0YVxuICAgICAqL1xuICAgIHB1YmxpYyBjdXN0b21FdmVudERhdGE6IHN0cmluZyB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIEEgbGlzdCBvZiBmbGVldHMgYW5kL29yIGZsZWV0IGFsaWFzZXMgdGhhdCBjYW4gYmUgdXNlZCB0byBmdWxmaWxsIGdhbWUgc2Vzc2lvbiBwbGFjZW1lbnQgcmVxdWVzdHMgaW4gdGhlIHF1ZXVlLiBEZXN0aW5hdGlvbnMgYXJlIGlkZW50aWZpZWQgYnkgZWl0aGVyIGEgZmxlZXQgQVJOIG9yIGEgZmxlZXQgYWxpYXMgQVJOLCBhbmQgYXJlIGxpc3RlZCBpbiBvcmRlciBvZiBwbGFjZW1lbnQgcHJlZmVyZW5jZS5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWdhbWVsaWZ0LWdhbWVzZXNzaW9ucXVldWUuaHRtbCNjZm4tZ2FtZWxpZnQtZ2FtZXNlc3Npb25xdWV1ZS1kZXN0aW5hdGlvbnNcbiAgICAgKi9cbiAgICBwdWJsaWMgZGVzdGluYXRpb25zOiBBcnJheTxDZm5HYW1lU2Vzc2lvblF1ZXVlLkRlc3RpbmF0aW9uUHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGU+IHwgY2RrLklSZXNvbHZhYmxlIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogQSBsaXN0IG9mIGxvY2F0aW9ucyB3aGVyZSBhIHF1ZXVlIGlzIGFsbG93ZWQgdG8gcGxhY2UgbmV3IGdhbWUgc2Vzc2lvbnMuIExvY2F0aW9ucyBhcmUgc3BlY2lmaWVkIGluIHRoZSBmb3JtIG9mIEFXUyBSZWdpb24gY29kZXMsIHN1Y2ggYXMgYHVzLXdlc3QtMmAgLiBJZiB0aGlzIHBhcmFtZXRlciBpcyBub3Qgc2V0LCBnYW1lIHNlc3Npb25zIGNhbiBiZSBwbGFjZWQgaW4gYW55IHF1ZXVlIGxvY2F0aW9uLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZ2FtZWxpZnQtZ2FtZXNlc3Npb25xdWV1ZS5odG1sI2Nmbi1nYW1lbGlmdC1nYW1lc2Vzc2lvbnF1ZXVlLWZpbHRlcmNvbmZpZ3VyYXRpb25cbiAgICAgKi9cbiAgICBwdWJsaWMgZmlsdGVyQ29uZmlndXJhdGlvbjogQ2ZuR2FtZVNlc3Npb25RdWV1ZS5GaWx0ZXJDb25maWd1cmF0aW9uUHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGUgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBBbiBTTlMgdG9waWMgQVJOIHRoYXQgaXMgc2V0IHVwIHRvIHJlY2VpdmUgZ2FtZSBzZXNzaW9uIHBsYWNlbWVudCBub3RpZmljYXRpb25zLiBTZWUgW1NldHRpbmcgdXAgbm90aWZpY2F0aW9ucyBmb3IgZ2FtZSBzZXNzaW9uIHBsYWNlbWVudF0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2dhbWVsaWZ0L2xhdGVzdC9kZXZlbG9wZXJndWlkZS9xdWV1ZS1ub3RpZmljYXRpb24uaHRtbCkgLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZ2FtZWxpZnQtZ2FtZXNlc3Npb25xdWV1ZS5odG1sI2Nmbi1nYW1lbGlmdC1nYW1lc2Vzc2lvbnF1ZXVlLW5vdGlmaWNhdGlvbnRhcmdldFxuICAgICAqL1xuICAgIHB1YmxpYyBub3RpZmljYXRpb25UYXJnZXQ6IHN0cmluZyB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIEEgc2V0IG9mIHBvbGljaWVzIHRoYXQgYWN0IGFzIGEgc2xpZGluZyBjYXAgb24gcGxheWVyIGxhdGVuY3kuIEZsZWV0SVEgd29ya3MgdG8gZGVsaXZlciBsb3cgbGF0ZW5jeSBmb3IgbW9zdCBwbGF5ZXJzIGluIGEgZ2FtZSBzZXNzaW9uLiBUaGVzZSBwb2xpY2llcyBlbnN1cmUgdGhhdCBubyBpbmRpdmlkdWFsIHBsYXllciBjYW4gYmUgcGxhY2VkIGludG8gYSBnYW1lIHdpdGggdW5yZWFzb25hYmx5IGhpZ2ggbGF0ZW5jeS4gVXNlIG11bHRpcGxlIHBvbGljaWVzIHRvIGdyYWR1YWxseSByZWxheCBsYXRlbmN5IHJlcXVpcmVtZW50cyBhIHN0ZXAgYXQgYSB0aW1lLiBNdWx0aXBsZSBwb2xpY2llcyBhcmUgYXBwbGllZCBiYXNlZCBvbiB0aGVpciBtYXhpbXVtIGFsbG93ZWQgbGF0ZW5jeSwgc3RhcnRpbmcgd2l0aCB0aGUgbG93ZXN0IHZhbHVlLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZ2FtZWxpZnQtZ2FtZXNlc3Npb25xdWV1ZS5odG1sI2Nmbi1nYW1lbGlmdC1nYW1lc2Vzc2lvbnF1ZXVlLXBsYXllcmxhdGVuY3lwb2xpY2llc1xuICAgICAqL1xuICAgIHB1YmxpYyBwbGF5ZXJMYXRlbmN5UG9saWNpZXM6IEFycmF5PENmbkdhbWVTZXNzaW9uUXVldWUuUGxheWVyTGF0ZW5jeVBvbGljeVByb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlPiB8IGNkay5JUmVzb2x2YWJsZSB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIEN1c3RvbSBzZXR0aW5ncyB0byB1c2Ugd2hlbiBwcmlvcml0aXppbmcgZGVzdGluYXRpb25zIGFuZCBsb2NhdGlvbnMgZm9yIGdhbWUgc2Vzc2lvbiBwbGFjZW1lbnRzLiBUaGlzIGNvbmZpZ3VyYXRpb24gcmVwbGFjZXMgdGhlIEZsZWV0SVEgZGVmYXVsdCBwcmlvcml0aXphdGlvbiBwcm9jZXNzLiBQcmlvcml0eSB0eXBlcyB0aGF0IGFyZSBub3QgZXhwbGljaXRseSBuYW1lZCB3aWxsIGJlIGF1dG9tYXRpY2FsbHkgYXBwbGllZCBhdCB0aGUgZW5kIG9mIHRoZSBwcmlvcml0aXphdGlvbiBwcm9jZXNzLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZ2FtZWxpZnQtZ2FtZXNlc3Npb25xdWV1ZS5odG1sI2Nmbi1nYW1lbGlmdC1nYW1lc2Vzc2lvbnF1ZXVlLXByaW9yaXR5Y29uZmlndXJhdGlvblxuICAgICAqL1xuICAgIHB1YmxpYyBwcmlvcml0eUNvbmZpZ3VyYXRpb246IENmbkdhbWVTZXNzaW9uUXVldWUuUHJpb3JpdHlDb25maWd1cmF0aW9uUHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGUgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBBIGxpc3Qgb2YgbGFiZWxzIHRvIGFzc2lnbiB0byB0aGUgbmV3IGdhbWUgc2Vzc2lvbiBxdWV1ZSByZXNvdXJjZS4gVGFncyBhcmUgZGV2ZWxvcGVyLWRlZmluZWQga2V5LXZhbHVlIHBhaXJzLiBUYWdnaW5nIEFXUyByZXNvdXJjZXMgYXJlIHVzZWZ1bCBmb3IgcmVzb3VyY2UgbWFuYWdlbWVudCwgYWNjZXNzIG1hbmFnZW1lbnQgYW5kIGNvc3QgYWxsb2NhdGlvbi4gRm9yIG1vcmUgaW5mb3JtYXRpb24sIHNlZSBbVGFnZ2luZyBBV1MgUmVzb3VyY2VzXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZ2VuZXJhbC9sYXRlc3QvZ3IvYXdzX3RhZ2dpbmcuaHRtbCkgaW4gdGhlICpBV1MgR2VuZXJhbCBSZWZlcmVuY2UqIC4gT25jZSB0aGUgcmVzb3VyY2UgaXMgY3JlYXRlZCwgeW91IGNhbiB1c2UgVGFnUmVzb3VyY2UsIFVudGFnUmVzb3VyY2UsIGFuZCBMaXN0VGFnc0ZvclJlc291cmNlIHRvIGFkZCwgcmVtb3ZlLCBhbmQgdmlldyB0YWdzLiBUaGUgbWF4aW11bSB0YWcgbGltaXQgbWF5IGJlIGxvd2VyIHRoYW4gc3RhdGVkLiBTZWUgdGhlIEFXUyBHZW5lcmFsIFJlZmVyZW5jZSBmb3IgYWN0dWFsIHRhZ2dpbmcgbGltaXRzLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZ2FtZWxpZnQtZ2FtZXNlc3Npb25xdWV1ZS5odG1sI2Nmbi1nYW1lbGlmdC1nYW1lc2Vzc2lvbnF1ZXVlLXRhZ3NcbiAgICAgKi9cbiAgICBwdWJsaWMgcmVhZG9ubHkgdGFnczogY2RrLlRhZ01hbmFnZXI7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgbWF4aW11bSB0aW1lLCBpbiBzZWNvbmRzLCB0aGF0IGEgbmV3IGdhbWUgc2Vzc2lvbiBwbGFjZW1lbnQgcmVxdWVzdCByZW1haW5zIGluIHRoZSBxdWV1ZS4gV2hlbiBhIHJlcXVlc3QgZXhjZWVkcyB0aGlzIHRpbWUsIHRoZSBnYW1lIHNlc3Npb24gcGxhY2VtZW50IGNoYW5nZXMgdG8gYSBgVElNRURfT1VUYCBzdGF0dXMuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1nYW1lbGlmdC1nYW1lc2Vzc2lvbnF1ZXVlLmh0bWwjY2ZuLWdhbWVsaWZ0LWdhbWVzZXNzaW9ucXVldWUtdGltZW91dGluc2Vjb25kc1xuICAgICAqL1xuICAgIHB1YmxpYyB0aW1lb3V0SW5TZWNvbmRzOiBudW1iZXIgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBDcmVhdGUgYSBuZXcgYEFXUzo6R2FtZUxpZnQ6OkdhbWVTZXNzaW9uUXVldWVgLlxuICAgICAqXG4gICAgICogQHBhcmFtIHNjb3BlIC0gc2NvcGUgaW4gd2hpY2ggdGhpcyByZXNvdXJjZSBpcyBkZWZpbmVkXG4gICAgICogQHBhcmFtIGlkICAgIC0gc2NvcGVkIGlkIG9mIHRoZSByZXNvdXJjZVxuICAgICAqIEBwYXJhbSBwcm9wcyAtIHJlc291cmNlIHByb3BlcnRpZXNcbiAgICAgKi9cbiAgICBjb25zdHJ1Y3RvcihzY29wZTogY2RrLkNvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IENmbkdhbWVTZXNzaW9uUXVldWVQcm9wcykge1xuICAgICAgICBzdXBlcihzY29wZSwgaWQsIHsgdHlwZTogQ2ZuR2FtZVNlc3Npb25RdWV1ZS5DRk5fUkVTT1VSQ0VfVFlQRV9OQU1FLCBwcm9wZXJ0aWVzOiBwcm9wcyB9KTtcbiAgICAgICAgY2RrLnJlcXVpcmVQcm9wZXJ0eShwcm9wcywgJ25hbWUnLCB0aGlzKTtcbiAgICAgICAgdGhpcy5hdHRyQXJuID0gY2RrLlRva2VuLmFzU3RyaW5nKHRoaXMuZ2V0QXR0KCdBcm4nKSk7XG4gICAgICAgIHRoaXMuYXR0ck5hbWUgPSBjZGsuVG9rZW4uYXNTdHJpbmcodGhpcy5nZXRBdHQoJ05hbWUnKSk7XG5cbiAgICAgICAgdGhpcy5uYW1lID0gcHJvcHMubmFtZTtcbiAgICAgICAgdGhpcy5jdXN0b21FdmVudERhdGEgPSBwcm9wcy5jdXN0b21FdmVudERhdGE7XG4gICAgICAgIHRoaXMuZGVzdGluYXRpb25zID0gcHJvcHMuZGVzdGluYXRpb25zO1xuICAgICAgICB0aGlzLmZpbHRlckNvbmZpZ3VyYXRpb24gPSBwcm9wcy5maWx0ZXJDb25maWd1cmF0aW9uO1xuICAgICAgICB0aGlzLm5vdGlmaWNhdGlvblRhcmdldCA9IHByb3BzLm5vdGlmaWNhdGlvblRhcmdldDtcbiAgICAgICAgdGhpcy5wbGF5ZXJMYXRlbmN5UG9saWNpZXMgPSBwcm9wcy5wbGF5ZXJMYXRlbmN5UG9saWNpZXM7XG4gICAgICAgIHRoaXMucHJpb3JpdHlDb25maWd1cmF0aW9uID0gcHJvcHMucHJpb3JpdHlDb25maWd1cmF0aW9uO1xuICAgICAgICB0aGlzLnRhZ3MgPSBuZXcgY2RrLlRhZ01hbmFnZXIoY2RrLlRhZ1R5cGUuU1RBTkRBUkQsIFwiQVdTOjpHYW1lTGlmdDo6R2FtZVNlc3Npb25RdWV1ZVwiLCBwcm9wcy50YWdzLCB7IHRhZ1Byb3BlcnR5TmFtZTogJ3RhZ3MnIH0pO1xuICAgICAgICB0aGlzLnRpbWVvdXRJblNlY29uZHMgPSBwcm9wcy50aW1lb3V0SW5TZWNvbmRzO1xuICAgIH1cblxuICAgIC8qKlxuICAgICAqIEV4YW1pbmVzIHRoZSBDbG91ZEZvcm1hdGlvbiByZXNvdXJjZSBhbmQgZGlzY2xvc2VzIGF0dHJpYnV0ZXMuXG4gICAgICpcbiAgICAgKiBAcGFyYW0gaW5zcGVjdG9yIC0gdHJlZSBpbnNwZWN0b3IgdG8gY29sbGVjdCBhbmQgcHJvY2VzcyBhdHRyaWJ1dGVzXG4gICAgICpcbiAgICAgKi9cbiAgICBwdWJsaWMgaW5zcGVjdChpbnNwZWN0b3I6IGNkay5UcmVlSW5zcGVjdG9yKSB7XG4gICAgICAgIGluc3BlY3Rvci5hZGRBdHRyaWJ1dGUoXCJhd3M6Y2RrOmNsb3VkZm9ybWF0aW9uOnR5cGVcIiwgQ2ZuR2FtZVNlc3Npb25RdWV1ZS5DRk5fUkVTT1VSQ0VfVFlQRV9OQU1FKTtcbiAgICAgICAgaW5zcGVjdG9yLmFkZEF0dHJpYnV0ZShcImF3czpjZGs6Y2xvdWRmb3JtYXRpb246cHJvcHNcIiwgdGhpcy5jZm5Qcm9wZXJ0aWVzKTtcbiAgICB9XG5cbiAgICBwcm90ZWN0ZWQgZ2V0IGNmblByb3BlcnRpZXMoKTogeyBba2V5OiBzdHJpbmddOiBhbnkgfSAge1xuICAgICAgICByZXR1cm4ge1xuICAgICAgICAgICAgbmFtZTogdGhpcy5uYW1lLFxuICAgICAgICAgICAgY3VzdG9tRXZlbnREYXRhOiB0aGlzLmN1c3RvbUV2ZW50RGF0YSxcbiAgICAgICAgICAgIGRlc3RpbmF0aW9uczogdGhpcy5kZXN0aW5hdGlvbnMsXG4gICAgICAgICAgICBmaWx0ZXJDb25maWd1cmF0aW9uOiB0aGlzLmZpbHRlckNvbmZpZ3VyYXRpb24sXG4gICAgICAgICAgICBub3RpZmljYXRpb25UYXJnZXQ6IHRoaXMubm90aWZpY2F0aW9uVGFyZ2V0LFxuICAgICAgICAgICAgcGxheWVyTGF0ZW5jeVBvbGljaWVzOiB0aGlzLnBsYXllckxhdGVuY3lQb2xpY2llcyxcbiAgICAgICAgICAgIHByaW9yaXR5Q29uZmlndXJhdGlvbjogdGhpcy5wcmlvcml0eUNvbmZpZ3VyYXRpb24sXG4gICAgICAgICAgICB0YWdzOiB0aGlzLnRhZ3MucmVuZGVyVGFncygpLFxuICAgICAgICAgICAgdGltZW91dEluU2Vjb25kczogdGhpcy50aW1lb3V0SW5TZWNvbmRzLFxuICAgICAgICB9O1xuICAgIH1cblxuICAgIHByb3RlY3RlZCByZW5kZXJQcm9wZXJ0aWVzKHByb3BzOiB7W2tleTogc3RyaW5nXTogYW55fSk6IHsgW2tleTogc3RyaW5nXTogYW55IH0gIHtcbiAgICAgICAgcmV0dXJuIGNmbkdhbWVTZXNzaW9uUXVldWVQcm9wc1RvQ2xvdWRGb3JtYXRpb24ocHJvcHMpO1xuICAgIH1cbn1cblxuZXhwb3J0IG5hbWVzcGFjZSBDZm5HYW1lU2Vzc2lvblF1ZXVlIHtcbiAgICAvKipcbiAgICAgKiBBIGZsZWV0IG9yIGFsaWFzIGRlc2lnbmF0ZWQgaW4gYSBnYW1lIHNlc3Npb24gcXVldWUuIFF1ZXVlcyBmdWxmaWxsIHJlcXVlc3RzIGZvciBuZXcgZ2FtZSBzZXNzaW9ucyBieSBwbGFjaW5nIGEgbmV3IGdhbWUgc2Vzc2lvbiBvbiBhbnkgb2YgdGhlIHF1ZXVlJ3MgZGVzdGluYXRpb25zLlxuICAgICAqXG4gICAgICogQHN0cnVjdFxuICAgICAqIEBzdGFiaWxpdHkgZXh0ZXJuYWxcbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtZ2FtZWxpZnQtZ2FtZXNlc3Npb25xdWV1ZS1kZXN0aW5hdGlvbi5odG1sXG4gICAgICovXG4gICAgZXhwb3J0IGludGVyZmFjZSBEZXN0aW5hdGlvblByb3BlcnR5IHtcbiAgICAgICAgLyoqXG4gICAgICAgICAqIFRoZSBBbWF6b24gUmVzb3VyY2UgTmFtZSAoQVJOKSB0aGF0IGlzIGFzc2lnbmVkIHRvIGZsZWV0IG9yIGZsZWV0IGFsaWFzLiBBUk5zLCB3aGljaCBpbmNsdWRlIGEgZmxlZXQgSUQgb3IgYWxpYXMgSUQgYW5kIGEgUmVnaW9uIG5hbWUsIHByb3ZpZGUgYSB1bmlxdWUgaWRlbnRpZmllciBhY3Jvc3MgYWxsIFJlZ2lvbnMuXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtZ2FtZWxpZnQtZ2FtZXNlc3Npb25xdWV1ZS1kZXN0aW5hdGlvbi5odG1sI2Nmbi1nYW1lbGlmdC1nYW1lc2Vzc2lvbnF1ZXVlLWRlc3RpbmF0aW9uLWRlc3RpbmF0aW9uYXJuXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBkZXN0aW5hdGlvbkFybj86IHN0cmluZztcbiAgICB9XG59XG5cbi8qKlxuICogRGV0ZXJtaW5lIHdoZXRoZXIgdGhlIGdpdmVuIHByb3BlcnRpZXMgbWF0Y2ggdGhvc2Ugb2YgYSBgRGVzdGluYXRpb25Qcm9wZXJ0eWBcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgRGVzdGluYXRpb25Qcm9wZXJ0eWBcbiAqXG4gKiBAcmV0dXJucyB0aGUgcmVzdWx0IG9mIHRoZSB2YWxpZGF0aW9uLlxuICovXG5mdW5jdGlvbiBDZm5HYW1lU2Vzc2lvblF1ZXVlX0Rlc3RpbmF0aW9uUHJvcGVydHlWYWxpZGF0b3IocHJvcGVydGllczogYW55KTogY2RrLlZhbGlkYXRpb25SZXN1bHQge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIGNkay5WQUxJREFUSU9OX1NVQ0NFU1M7IH1cbiAgICBjb25zdCBlcnJvcnMgPSBuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHRzKCk7XG4gICAgaWYgKHR5cGVvZiBwcm9wZXJ0aWVzICE9PSAnb2JqZWN0Jykge1xuICAgICAgICBlcnJvcnMuY29sbGVjdChuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHQoJ0V4cGVjdGVkIGFuIG9iamVjdCwgYnV0IHJlY2VpdmVkOiAnICsgSlNPTi5zdHJpbmdpZnkocHJvcGVydGllcykpKTtcbiAgICB9XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdkZXN0aW5hdGlvbkFybicsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5kZXN0aW5hdGlvbkFybikpO1xuICAgIHJldHVybiBlcnJvcnMud3JhcCgnc3VwcGxpZWQgcHJvcGVydGllcyBub3QgY29ycmVjdCBmb3IgXCJEZXN0aW5hdGlvblByb3BlcnR5XCInKTtcbn1cblxuLyoqXG4gKiBSZW5kZXJzIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpHYW1lTGlmdDo6R2FtZVNlc3Npb25RdWV1ZS5EZXN0aW5hdGlvbmAgcmVzb3VyY2VcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgRGVzdGluYXRpb25Qcm9wZXJ0eWBcbiAqXG4gKiBAcmV0dXJucyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6R2FtZUxpZnQ6OkdhbWVTZXNzaW9uUXVldWUuRGVzdGluYXRpb25gIHJlc291cmNlLlxuICovXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gY2ZuR2FtZVNlc3Npb25RdWV1ZURlc3RpbmF0aW9uUHJvcGVydHlUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGFueSB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gcHJvcGVydGllczsgfVxuICAgIENmbkdhbWVTZXNzaW9uUXVldWVfRGVzdGluYXRpb25Qcm9wZXJ0eVZhbGlkYXRvcihwcm9wZXJ0aWVzKS5hc3NlcnRTdWNjZXNzKCk7XG4gICAgcmV0dXJuIHtcbiAgICAgICAgRGVzdGluYXRpb25Bcm46IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuZGVzdGluYXRpb25Bcm4pLFxuICAgIH07XG59XG5cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBDZm5HYW1lU2Vzc2lvblF1ZXVlRGVzdGluYXRpb25Qcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0PENmbkdhbWVTZXNzaW9uUXVldWUuRGVzdGluYXRpb25Qcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZT4ge1xuICAgIGlmIChjZGsuaXNSZXNvbHZhYmxlT2JqZWN0KHByb3BlcnRpZXMpKSB7XG4gICAgICAgIHJldHVybiBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdChwcm9wZXJ0aWVzKTtcbiAgICB9XG4gICAgcHJvcGVydGllcyA9IHByb3BlcnRpZXMgPT0gbnVsbCA/IHt9IDogcHJvcGVydGllcztcbiAgICBpZiAodHlwZW9mIHByb3BlcnRpZXMgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIHJldHVybiBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdChwcm9wZXJ0aWVzKTtcbiAgICB9XG4gICAgY29uc3QgcmV0ID0gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25Qcm9wZXJ0eU9iamVjdDxDZm5HYW1lU2Vzc2lvblF1ZXVlLkRlc3RpbmF0aW9uUHJvcGVydHk+KCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdkZXN0aW5hdGlvbkFybicsICdEZXN0aW5hdGlvbkFybicsIHByb3BlcnRpZXMuRGVzdGluYXRpb25Bcm4gIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuRGVzdGluYXRpb25Bcm4pIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkVW5yZWNvZ25pemVkUHJvcGVydGllc0FzRXh0cmEocHJvcGVydGllcyk7XG4gICAgcmV0dXJuIHJldDtcbn1cblxuZXhwb3J0IG5hbWVzcGFjZSBDZm5HYW1lU2Vzc2lvblF1ZXVlIHtcbiAgICAvKipcbiAgICAgKiBBIGxpc3Qgb2YgZmxlZXQgbG9jYXRpb25zIHdoZXJlIGEgZ2FtZSBzZXNzaW9uIHF1ZXVlIGNhbiBwbGFjZSBuZXcgZ2FtZSBzZXNzaW9ucy4gWW91IGNhbiB1c2UgYSBmaWx0ZXIgdG8gdGVtcG9yYXJpbHkgdHVybiBvZmYgcGxhY2VtZW50cyBmb3Igc3BlY2lmaWMgbG9jYXRpb25zLiBGb3IgcXVldWVzIHRoYXQgaGF2ZSBtdWx0aS1sb2NhdGlvbiBmbGVldHMsIHlvdSBjYW4gdXNlIGEgZmlsdGVyIGNvbmZpZ3VyYXRpb24gYWxsb3cgcGxhY2VtZW50IHdpdGggc29tZSwgYnV0IG5vdCBhbGwgb2YgdGhlc2UgbG9jYXRpb25zLlxuICAgICAqXG4gICAgICogQHN0cnVjdFxuICAgICAqIEBzdGFiaWxpdHkgZXh0ZXJuYWxcbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtZ2FtZWxpZnQtZ2FtZXNlc3Npb25xdWV1ZS1maWx0ZXJjb25maWd1cmF0aW9uLmh0bWxcbiAgICAgKi9cbiAgICBleHBvcnQgaW50ZXJmYWNlIEZpbHRlckNvbmZpZ3VyYXRpb25Qcm9wZXJ0eSB7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBBIGxpc3Qgb2YgbG9jYXRpb25zIHRvIGFsbG93IGdhbWUgc2Vzc2lvbiBwbGFjZW1lbnQgaW4sIGluIHRoZSBmb3JtIG9mIEFXUyBSZWdpb24gY29kZXMgc3VjaCBhcyBgdXMtd2VzdC0yYCAuXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtZ2FtZWxpZnQtZ2FtZXNlc3Npb25xdWV1ZS1maWx0ZXJjb25maWd1cmF0aW9uLmh0bWwjY2ZuLWdhbWVsaWZ0LWdhbWVzZXNzaW9ucXVldWUtZmlsdGVyY29uZmlndXJhdGlvbi1hbGxvd2VkbG9jYXRpb25zXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBhbGxvd2VkTG9jYXRpb25zPzogc3RyaW5nW107XG4gICAgfVxufVxuXG4vKipcbiAqIERldGVybWluZSB3aGV0aGVyIHRoZSBnaXZlbiBwcm9wZXJ0aWVzIG1hdGNoIHRob3NlIG9mIGEgYEZpbHRlckNvbmZpZ3VyYXRpb25Qcm9wZXJ0eWBcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgRmlsdGVyQ29uZmlndXJhdGlvblByb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSByZXN1bHQgb2YgdGhlIHZhbGlkYXRpb24uXG4gKi9cbmZ1bmN0aW9uIENmbkdhbWVTZXNzaW9uUXVldWVfRmlsdGVyQ29uZmlndXJhdGlvblByb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXM6IGFueSk6IGNkay5WYWxpZGF0aW9uUmVzdWx0IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBjZGsuVkFMSURBVElPTl9TVUNDRVNTOyB9XG4gICAgY29uc3QgZXJyb3JzID0gbmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0cygpO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgZXJyb3JzLmNvbGxlY3QobmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0KCdFeHBlY3RlZCBhbiBvYmplY3QsIGJ1dCByZWNlaXZlZDogJyArIEpTT04uc3RyaW5naWZ5KHByb3BlcnRpZXMpKSk7XG4gICAgfVxuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignYWxsb3dlZExvY2F0aW9ucycsIGNkay5saXN0VmFsaWRhdG9yKGNkay52YWxpZGF0ZVN0cmluZykpKHByb3BlcnRpZXMuYWxsb3dlZExvY2F0aW9ucykpO1xuICAgIHJldHVybiBlcnJvcnMud3JhcCgnc3VwcGxpZWQgcHJvcGVydGllcyBub3QgY29ycmVjdCBmb3IgXCJGaWx0ZXJDb25maWd1cmF0aW9uUHJvcGVydHlcIicpO1xufVxuXG4vKipcbiAqIFJlbmRlcnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OkdhbWVMaWZ0OjpHYW1lU2Vzc2lvblF1ZXVlLkZpbHRlckNvbmZpZ3VyYXRpb25gIHJlc291cmNlXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYEZpbHRlckNvbmZpZ3VyYXRpb25Qcm9wZXJ0eWBcbiAqXG4gKiBAcmV0dXJucyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6R2FtZUxpZnQ6OkdhbWVTZXNzaW9uUXVldWUuRmlsdGVyQ29uZmlndXJhdGlvbmAgcmVzb3VyY2UuXG4gKi9cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBjZm5HYW1lU2Vzc2lvblF1ZXVlRmlsdGVyQ29uZmlndXJhdGlvblByb3BlcnR5VG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBhbnkge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIHByb3BlcnRpZXM7IH1cbiAgICBDZm5HYW1lU2Vzc2lvblF1ZXVlX0ZpbHRlckNvbmZpZ3VyYXRpb25Qcm9wZXJ0eVZhbGlkYXRvcihwcm9wZXJ0aWVzKS5hc3NlcnRTdWNjZXNzKCk7XG4gICAgcmV0dXJuIHtcbiAgICAgICAgQWxsb3dlZExvY2F0aW9uczogY2RrLmxpc3RNYXBwZXIoY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24pKHByb3BlcnRpZXMuYWxsb3dlZExvY2F0aW9ucyksXG4gICAgfTtcbn1cblxuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIENmbkdhbWVTZXNzaW9uUXVldWVGaWx0ZXJDb25maWd1cmF0aW9uUHJvcGVydHlGcm9tQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdDxDZm5HYW1lU2Vzc2lvblF1ZXVlLkZpbHRlckNvbmZpZ3VyYXRpb25Qcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZT4ge1xuICAgIGlmIChjZGsuaXNSZXNvbHZhYmxlT2JqZWN0KHByb3BlcnRpZXMpKSB7XG4gICAgICAgIHJldHVybiBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdChwcm9wZXJ0aWVzKTtcbiAgICB9XG4gICAgcHJvcGVydGllcyA9IHByb3BlcnRpZXMgPT0gbnVsbCA/IHt9IDogcHJvcGVydGllcztcbiAgICBpZiAodHlwZW9mIHByb3BlcnRpZXMgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIHJldHVybiBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdChwcm9wZXJ0aWVzKTtcbiAgICB9XG4gICAgY29uc3QgcmV0ID0gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25Qcm9wZXJ0eU9iamVjdDxDZm5HYW1lU2Vzc2lvblF1ZXVlLkZpbHRlckNvbmZpZ3VyYXRpb25Qcm9wZXJ0eT4oKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2FsbG93ZWRMb2NhdGlvbnMnLCAnQWxsb3dlZExvY2F0aW9ucycsIHByb3BlcnRpZXMuQWxsb3dlZExvY2F0aW9ucyAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmdBcnJheShwcm9wZXJ0aWVzLkFsbG93ZWRMb2NhdGlvbnMpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkVW5yZWNvZ25pemVkUHJvcGVydGllc0FzRXh0cmEocHJvcGVydGllcyk7XG4gICAgcmV0dXJuIHJldDtcbn1cblxuZXhwb3J0IG5hbWVzcGFjZSBDZm5HYW1lU2Vzc2lvblF1ZXVlIHtcbiAgICAvKipcbiAgICAgKiBUaGUgcXVldWUgc2V0dGluZyB0aGF0IGRldGVybWluZXMgdGhlIGhpZ2hlc3QgbGF0ZW5jeSBhbGxvd2VkIGZvciBpbmRpdmlkdWFsIHBsYXllcnMgd2hlbiBwbGFjaW5nIGEgZ2FtZSBzZXNzaW9uLiBXaGVuIGEgbGF0ZW5jeSBwb2xpY3kgaXMgaW4gZm9yY2UsIGEgZ2FtZSBzZXNzaW9uIGNhbm5vdCBiZSBwbGFjZWQgd2l0aCBhbnkgZmxlZXQgaW4gYSBSZWdpb24gd2hlcmUgYSBwbGF5ZXIgcmVwb3J0cyBsYXRlbmN5IGhpZ2hlciB0aGFuIHRoZSBjYXAuIExhdGVuY3kgcG9saWNpZXMgYXJlIG9ubHkgZW5mb3JjZWQgd2hlbiB0aGUgcGxhY2VtZW50IHJlcXVlc3QgY29udGFpbnMgcGxheWVyIGxhdGVuY3kgaW5mb3JtYXRpb24uXG4gICAgICpcbiAgICAgKiBAc3RydWN0XG4gICAgICogQHN0YWJpbGl0eSBleHRlcm5hbFxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1nYW1lbGlmdC1nYW1lc2Vzc2lvbnF1ZXVlLXBsYXllcmxhdGVuY3lwb2xpY3kuaHRtbFxuICAgICAqL1xuICAgIGV4cG9ydCBpbnRlcmZhY2UgUGxheWVyTGF0ZW5jeVBvbGljeVByb3BlcnR5IHtcbiAgICAgICAgLyoqXG4gICAgICAgICAqIFRoZSBtYXhpbXVtIGxhdGVuY3kgdmFsdWUgdGhhdCBpcyBhbGxvd2VkIGZvciBhbnkgcGxheWVyLCBpbiBtaWxsaXNlY29uZHMuIEFsbCBwb2xpY2llcyBtdXN0IGhhdmUgYSB2YWx1ZSBzZXQgZm9yIHRoaXMgcHJvcGVydHkuXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtZ2FtZWxpZnQtZ2FtZXNlc3Npb25xdWV1ZS1wbGF5ZXJsYXRlbmN5cG9saWN5Lmh0bWwjY2ZuLWdhbWVsaWZ0LWdhbWVzZXNzaW9ucXVldWUtcGxheWVybGF0ZW5jeXBvbGljeS1tYXhpbXVtaW5kaXZpZHVhbHBsYXllcmxhdGVuY3ltaWxsaXNlY29uZHNcbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IG1heGltdW1JbmRpdmlkdWFsUGxheWVyTGF0ZW5jeU1pbGxpc2Vjb25kcz86IG51bWJlcjtcbiAgICAgICAgLyoqXG4gICAgICAgICAqIFRoZSBsZW5ndGggb2YgdGltZSwgaW4gc2Vjb25kcywgdGhhdCB0aGUgcG9saWN5IGlzIGVuZm9yY2VkIHdoaWxlIHBsYWNpbmcgYSBuZXcgZ2FtZSBzZXNzaW9uLiBBIG51bGwgdmFsdWUgZm9yIHRoaXMgcHJvcGVydHkgbWVhbnMgdGhhdCB0aGUgcG9saWN5IGlzIGVuZm9yY2VkIHVudGlsIHRoZSBxdWV1ZSB0aW1lcyBvdXQuXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtZ2FtZWxpZnQtZ2FtZXNlc3Npb25xdWV1ZS1wbGF5ZXJsYXRlbmN5cG9saWN5Lmh0bWwjY2ZuLWdhbWVsaWZ0LWdhbWVzZXNzaW9ucXVldWUtcGxheWVybGF0ZW5jeXBvbGljeS1wb2xpY3lkdXJhdGlvbnNlY29uZHNcbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IHBvbGljeUR1cmF0aW9uU2Vjb25kcz86IG51bWJlcjtcbiAgICB9XG59XG5cbi8qKlxuICogRGV0ZXJtaW5lIHdoZXRoZXIgdGhlIGdpdmVuIHByb3BlcnRpZXMgbWF0Y2ggdGhvc2Ugb2YgYSBgUGxheWVyTGF0ZW5jeVBvbGljeVByb3BlcnR5YFxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBQbGF5ZXJMYXRlbmN5UG9saWN5UHJvcGVydHlgXG4gKlxuICogQHJldHVybnMgdGhlIHJlc3VsdCBvZiB0aGUgdmFsaWRhdGlvbi5cbiAqL1xuZnVuY3Rpb24gQ2ZuR2FtZVNlc3Npb25RdWV1ZV9QbGF5ZXJMYXRlbmN5UG9saWN5UHJvcGVydHlWYWxpZGF0b3IocHJvcGVydGllczogYW55KTogY2RrLlZhbGlkYXRpb25SZXN1bHQge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIGNkay5WQUxJREFUSU9OX1NVQ0NFU1M7IH1cbiAgICBjb25zdCBlcnJvcnMgPSBuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHRzKCk7XG4gICAgaWYgKHR5cGVvZiBwcm9wZXJ0aWVzICE9PSAnb2JqZWN0Jykge1xuICAgICAgICBlcnJvcnMuY29sbGVjdChuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHQoJ0V4cGVjdGVkIGFuIG9iamVjdCwgYnV0IHJlY2VpdmVkOiAnICsgSlNPTi5zdHJpbmdpZnkocHJvcGVydGllcykpKTtcbiAgICB9XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdtYXhpbXVtSW5kaXZpZHVhbFBsYXllckxhdGVuY3lNaWxsaXNlY29uZHMnLCBjZGsudmFsaWRhdGVOdW1iZXIpKHByb3BlcnRpZXMubWF4aW11bUluZGl2aWR1YWxQbGF5ZXJMYXRlbmN5TWlsbGlzZWNvbmRzKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdwb2xpY3lEdXJhdGlvblNlY29uZHMnLCBjZGsudmFsaWRhdGVOdW1iZXIpKHByb3BlcnRpZXMucG9saWN5RHVyYXRpb25TZWNvbmRzKSk7XG4gICAgcmV0dXJuIGVycm9ycy53cmFwKCdzdXBwbGllZCBwcm9wZXJ0aWVzIG5vdCBjb3JyZWN0IGZvciBcIlBsYXllckxhdGVuY3lQb2xpY3lQcm9wZXJ0eVwiJyk7XG59XG5cbi8qKlxuICogUmVuZGVycyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6R2FtZUxpZnQ6OkdhbWVTZXNzaW9uUXVldWUuUGxheWVyTGF0ZW5jeVBvbGljeWAgcmVzb3VyY2VcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgUGxheWVyTGF0ZW5jeVBvbGljeVByb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpHYW1lTGlmdDo6R2FtZVNlc3Npb25RdWV1ZS5QbGF5ZXJMYXRlbmN5UG9saWN5YCByZXNvdXJjZS5cbiAqL1xuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIGNmbkdhbWVTZXNzaW9uUXVldWVQbGF5ZXJMYXRlbmN5UG9saWN5UHJvcGVydHlUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGFueSB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gcHJvcGVydGllczsgfVxuICAgIENmbkdhbWVTZXNzaW9uUXVldWVfUGxheWVyTGF0ZW5jeVBvbGljeVByb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXMpLmFzc2VydFN1Y2Nlc3MoKTtcbiAgICByZXR1cm4ge1xuICAgICAgICBNYXhpbXVtSW5kaXZpZHVhbFBsYXllckxhdGVuY3lNaWxsaXNlY29uZHM6IGNkay5udW1iZXJUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMubWF4aW11bUluZGl2aWR1YWxQbGF5ZXJMYXRlbmN5TWlsbGlzZWNvbmRzKSxcbiAgICAgICAgUG9saWN5RHVyYXRpb25TZWNvbmRzOiBjZGsubnVtYmVyVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLnBvbGljeUR1cmF0aW9uU2Vjb25kcyksXG4gICAgfTtcbn1cblxuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIENmbkdhbWVTZXNzaW9uUXVldWVQbGF5ZXJMYXRlbmN5UG9saWN5UHJvcGVydHlGcm9tQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdDxDZm5HYW1lU2Vzc2lvblF1ZXVlLlBsYXllckxhdGVuY3lQb2xpY3lQcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZT4ge1xuICAgIGlmIChjZGsuaXNSZXNvbHZhYmxlT2JqZWN0KHByb3BlcnRpZXMpKSB7XG4gICAgICAgIHJldHVybiBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdChwcm9wZXJ0aWVzKTtcbiAgICB9XG4gICAgcHJvcGVydGllcyA9IHByb3BlcnRpZXMgPT0gbnVsbCA/IHt9IDogcHJvcGVydGllcztcbiAgICBpZiAodHlwZW9mIHByb3BlcnRpZXMgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIHJldHVybiBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdChwcm9wZXJ0aWVzKTtcbiAgICB9XG4gICAgY29uc3QgcmV0ID0gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25Qcm9wZXJ0eU9iamVjdDxDZm5HYW1lU2Vzc2lvblF1ZXVlLlBsYXllckxhdGVuY3lQb2xpY3lQcm9wZXJ0eT4oKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ21heGltdW1JbmRpdmlkdWFsUGxheWVyTGF0ZW5jeU1pbGxpc2Vjb25kcycsICdNYXhpbXVtSW5kaXZpZHVhbFBsYXllckxhdGVuY3lNaWxsaXNlY29uZHMnLCBwcm9wZXJ0aWVzLk1heGltdW1JbmRpdmlkdWFsUGxheWVyTGF0ZW5jeU1pbGxpc2Vjb25kcyAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXROdW1iZXIocHJvcGVydGllcy5NYXhpbXVtSW5kaXZpZHVhbFBsYXllckxhdGVuY3lNaWxsaXNlY29uZHMpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ3BvbGljeUR1cmF0aW9uU2Vjb25kcycsICdQb2xpY3lEdXJhdGlvblNlY29uZHMnLCBwcm9wZXJ0aWVzLlBvbGljeUR1cmF0aW9uU2Vjb25kcyAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXROdW1iZXIocHJvcGVydGllcy5Qb2xpY3lEdXJhdGlvblNlY29uZHMpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkVW5yZWNvZ25pemVkUHJvcGVydGllc0FzRXh0cmEocHJvcGVydGllcyk7XG4gICAgcmV0dXJuIHJldDtcbn1cblxuZXhwb3J0IG5hbWVzcGFjZSBDZm5HYW1lU2Vzc2lvblF1ZXVlIHtcbiAgICAvKipcbiAgICAgKiBDdXN0b20gcHJpb3JpdGl6YXRpb24gc2V0dGluZ3MgZm9yIHVzZSBieSBhIGdhbWUgc2Vzc2lvbiBxdWV1ZSB3aGVuIHBsYWNpbmcgbmV3IGdhbWUgc2Vzc2lvbnMgd2l0aCBhdmFpbGFibGUgZ2FtZSBzZXJ2ZXJzLiBXaGVuIGRlZmluZWQsIHRoaXMgY29uZmlndXJhdGlvbiByZXBsYWNlcyB0aGUgZGVmYXVsdCBGbGVldElRIHByaW9yaXRpemF0aW9uIHByb2Nlc3MsIHdoaWNoIGlzIGFzIGZvbGxvd3M6XG4gICAgICpcbiAgICAgKiAtIElmIHBsYXllciBsYXRlbmN5IGRhdGEgaXMgaW5jbHVkZWQgaW4gYSBnYW1lIHNlc3Npb24gcmVxdWVzdCwgZGVzdGluYXRpb25zIGFuZCBsb2NhdGlvbnMgYXJlIHByaW9yaXRpemVkIGZpcnN0IGJhc2VkIG9uIGxvd2VzdCBhdmVyYWdlIGxhdGVuY3kgKDEpLCB0aGVuIG9uIGxvd2VzdCBob3N0aW5nIGNvc3QgKDIpLCB0aGVuIG9uIGRlc3RpbmF0aW9uIGxpc3Qgb3JkZXIgKDMpLCBhbmQgZmluYWxseSBvbiBsb2NhdGlvbiAoYWxwaGFiZXRpY2FsKSAoNCkuIFRoaXMgYXBwcm9hY2ggZW5zdXJlcyB0aGF0IHRoZSBxdWV1ZSdzIHRvcCBwcmlvcml0eSBpcyB0byBwbGFjZSBnYW1lIHNlc3Npb25zIHdoZXJlIGF2ZXJhZ2UgcGxheWVyIGxhdGVuY3kgaXMgbG93ZXN0LCBhbmQtLWlmIGxhdGVuY3kgaXMgdGhlIHNhbWUtLXdoZXJlIHRoZSBob3N0aW5nIGNvc3QgaXMgbGVzcywgZXRjLlxuICAgICAqIC0gSWYgcGxheWVyIGxhdGVuY3kgZGF0YSBpcyBub3QgaW5jbHVkZWQsIGRlc3RpbmF0aW9ucyBhbmQgbG9jYXRpb25zIGFyZSBwcmlvcml0aXplZCBmaXJzdCBvbiBkZXN0aW5hdGlvbiBsaXN0IG9yZGVyICgxKSwgYW5kIHRoZW4gb24gbG9jYXRpb24gKGFscGhhYmV0aWNhbCkgKDIpLiBUaGlzIGFwcHJvYWNoIGVuc3VyZXMgdGhhdCB0aGUgcXVldWUncyB0b3AgcHJpb3JpdHkgaXMgdG8gcGxhY2UgZ2FtZSBzZXNzaW9ucyBvbiB0aGUgZmlyc3QgZGVzdGluYXRpb24gZmxlZXQgbGlzdGVkLiBJZiB0aGF0IGZsZWV0IGhhcyBtdWx0aXBsZSBsb2NhdGlvbnMsIHRoZSBnYW1lIHNlc3Npb24gaXMgcGxhY2VkIG9uIHRoZSBmaXJzdCBsb2NhdGlvbiAod2hlbiBsaXN0ZWQgYWxwaGFiZXRpY2FsbHkpLlxuICAgICAqXG4gICAgICogQ2hhbmdpbmcgdGhlIHByaW9yaXR5IG9yZGVyIHdpbGwgYWZmZWN0IGhvdyBnYW1lIHNlc3Npb25zIGFyZSBwbGFjZWQuXG4gICAgICpcbiAgICAgKiBAc3RydWN0XG4gICAgICogQHN0YWJpbGl0eSBleHRlcm5hbFxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1nYW1lbGlmdC1nYW1lc2Vzc2lvbnF1ZXVlLXByaW9yaXR5Y29uZmlndXJhdGlvbi5odG1sXG4gICAgICovXG4gICAgZXhwb3J0IGludGVyZmFjZSBQcmlvcml0eUNvbmZpZ3VyYXRpb25Qcm9wZXJ0eSB7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBUaGUgcHJpb3JpdGl6YXRpb24gb3JkZXIgdG8gdXNlIGZvciBmbGVldCBsb2NhdGlvbnMsIHdoZW4gdGhlIGBQcmlvcml0eU9yZGVyYCBwcm9wZXJ0eSBpbmNsdWRlcyBgTE9DQVRJT05gIC4gTG9jYXRpb25zIGFyZSBpZGVudGlmaWVkIGJ5IEFXUyBSZWdpb24gY29kZXMgc3VjaCBhcyBgdXMtd2VzdC0yYCAuIEVhY2ggbG9jYXRpb24gY2FuIG9ubHkgYmUgbGlzdGVkIG9uY2UuXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtZ2FtZWxpZnQtZ2FtZXNlc3Npb25xdWV1ZS1wcmlvcml0eWNvbmZpZ3VyYXRpb24uaHRtbCNjZm4tZ2FtZWxpZnQtZ2FtZXNlc3Npb25xdWV1ZS1wcmlvcml0eWNvbmZpZ3VyYXRpb24tbG9jYXRpb25vcmRlclxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgbG9jYXRpb25PcmRlcj86IHN0cmluZ1tdO1xuICAgICAgICAvKipcbiAgICAgICAgICogVGhlIHJlY29tbWVuZGVkIHNlcXVlbmNlIHRvIHVzZSB3aGVuIHByaW9yaXRpemluZyB3aGVyZSB0byBwbGFjZSBuZXcgZ2FtZSBzZXNzaW9ucy4gRWFjaCB0eXBlIGNhbiBvbmx5IGJlIGxpc3RlZCBvbmNlLlxuICAgICAgICAgKlxuICAgICAgICAgKiAtIGBMQVRFTkNZYCAtLSBGbGVldElRIHByaW9yaXRpemVzIGxvY2F0aW9ucyB3aGVyZSB0aGUgYXZlcmFnZSBwbGF5ZXIgbGF0ZW5jeSAocHJvdmlkZWQgaW4gZWFjaCBnYW1lIHNlc3Npb24gcmVxdWVzdCkgaXMgbG93ZXN0LlxuICAgICAgICAgKiAtIGBDT1NUYCAtLSBGbGVldElRIHByaW9yaXRpemVzIGRlc3RpbmF0aW9ucyB3aXRoIHRoZSBsb3dlc3QgY3VycmVudCBob3N0aW5nIGNvc3RzLiBDb3N0IGlzIGV2YWx1YXRlZCBiYXNlZCBvbiB0aGUgbG9jYXRpb24sIGluc3RhbmNlIHR5cGUsIGFuZCBmbGVldCB0eXBlIChTcG90IG9yIE9uLURlbWFuZCkgZm9yIGVhY2ggZGVzdGluYXRpb24gaW4gdGhlIHF1ZXVlLlxuICAgICAgICAgKiAtIGBERVNUSU5BVElPTmAgLS0gRmxlZXRJUSBwcmlvcml0aXplcyBiYXNlZCBvbiB0aGUgb3JkZXIgdGhhdCBkZXN0aW5hdGlvbnMgYXJlIGxpc3RlZCBpbiB0aGUgcXVldWUgY29uZmlndXJhdGlvbi5cbiAgICAgICAgICogLSBgTE9DQVRJT05gIC0tIEZsZWV0SVEgcHJpb3JpdGl6ZXMgYmFzZWQgb24gdGhlIHByb3ZpZGVkIG9yZGVyIG9mIGxvY2F0aW9ucywgYXMgZGVmaW5lZCBpbiBgTG9jYXRpb25PcmRlcmAgLlxuICAgICAgICAgKlxuICAgICAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWdhbWVsaWZ0LWdhbWVzZXNzaW9ucXVldWUtcHJpb3JpdHljb25maWd1cmF0aW9uLmh0bWwjY2ZuLWdhbWVsaWZ0LWdhbWVzZXNzaW9ucXVldWUtcHJpb3JpdHljb25maWd1cmF0aW9uLXByaW9yaXR5b3JkZXJcbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IHByaW9yaXR5T3JkZXI/OiBzdHJpbmdbXTtcbiAgICB9XG59XG5cbi8qKlxuICogRGV0ZXJtaW5lIHdoZXRoZXIgdGhlIGdpdmVuIHByb3BlcnRpZXMgbWF0Y2ggdGhvc2Ugb2YgYSBgUHJpb3JpdHlDb25maWd1cmF0aW9uUHJvcGVydHlgXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYFByaW9yaXR5Q29uZmlndXJhdGlvblByb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSByZXN1bHQgb2YgdGhlIHZhbGlkYXRpb24uXG4gKi9cbmZ1bmN0aW9uIENmbkdhbWVTZXNzaW9uUXVldWVfUHJpb3JpdHlDb25maWd1cmF0aW9uUHJvcGVydHlWYWxpZGF0b3IocHJvcGVydGllczogYW55KTogY2RrLlZhbGlkYXRpb25SZXN1bHQge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIGNkay5WQUxJREFUSU9OX1NVQ0NFU1M7IH1cbiAgICBjb25zdCBlcnJvcnMgPSBuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHRzKCk7XG4gICAgaWYgKHR5cGVvZiBwcm9wZXJ0aWVzICE9PSAnb2JqZWN0Jykge1xuICAgICAgICBlcnJvcnMuY29sbGVjdChuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHQoJ0V4cGVjdGVkIGFuIG9iamVjdCwgYnV0IHJlY2VpdmVkOiAnICsgSlNPTi5zdHJpbmdpZnkocHJvcGVydGllcykpKTtcbiAgICB9XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdsb2NhdGlvbk9yZGVyJywgY2RrLmxpc3RWYWxpZGF0b3IoY2RrLnZhbGlkYXRlU3RyaW5nKSkocHJvcGVydGllcy5sb2NhdGlvbk9yZGVyKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdwcmlvcml0eU9yZGVyJywgY2RrLmxpc3RWYWxpZGF0b3IoY2RrLnZhbGlkYXRlU3RyaW5nKSkocHJvcGVydGllcy5wcmlvcml0eU9yZGVyKSk7XG4gICAgcmV0dXJuIGVycm9ycy53cmFwKCdzdXBwbGllZCBwcm9wZXJ0aWVzIG5vdCBjb3JyZWN0IGZvciBcIlByaW9yaXR5Q29uZmlndXJhdGlvblByb3BlcnR5XCInKTtcbn1cblxuLyoqXG4gKiBSZW5kZXJzIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpHYW1lTGlmdDo6R2FtZVNlc3Npb25RdWV1ZS5Qcmlvcml0eUNvbmZpZ3VyYXRpb25gIHJlc291cmNlXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYFByaW9yaXR5Q29uZmlndXJhdGlvblByb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpHYW1lTGlmdDo6R2FtZVNlc3Npb25RdWV1ZS5Qcmlvcml0eUNvbmZpZ3VyYXRpb25gIHJlc291cmNlLlxuICovXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gY2ZuR2FtZVNlc3Npb25RdWV1ZVByaW9yaXR5Q29uZmlndXJhdGlvblByb3BlcnR5VG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBhbnkge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIHByb3BlcnRpZXM7IH1cbiAgICBDZm5HYW1lU2Vzc2lvblF1ZXVlX1ByaW9yaXR5Q29uZmlndXJhdGlvblByb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXMpLmFzc2VydFN1Y2Nlc3MoKTtcbiAgICByZXR1cm4ge1xuICAgICAgICBMb2NhdGlvbk9yZGVyOiBjZGsubGlzdE1hcHBlcihjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbikocHJvcGVydGllcy5sb2NhdGlvbk9yZGVyKSxcbiAgICAgICAgUHJpb3JpdHlPcmRlcjogY2RrLmxpc3RNYXBwZXIoY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24pKHByb3BlcnRpZXMucHJpb3JpdHlPcmRlciksXG4gICAgfTtcbn1cblxuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIENmbkdhbWVTZXNzaW9uUXVldWVQcmlvcml0eUNvbmZpZ3VyYXRpb25Qcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0PENmbkdhbWVTZXNzaW9uUXVldWUuUHJpb3JpdHlDb25maWd1cmF0aW9uUHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGU+IHtcbiAgICBpZiAoY2RrLmlzUmVzb2x2YWJsZU9iamVjdChwcm9wZXJ0aWVzKSkge1xuICAgICAgICByZXR1cm4gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQocHJvcGVydGllcyk7XG4gICAgfVxuICAgIHByb3BlcnRpZXMgPSBwcm9wZXJ0aWVzID09IG51bGwgPyB7fSA6IHByb3BlcnRpZXM7XG4gICAgaWYgKHR5cGVvZiBwcm9wZXJ0aWVzICE9PSAnb2JqZWN0Jykge1xuICAgICAgICByZXR1cm4gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQocHJvcGVydGllcyk7XG4gICAgfVxuICAgIGNvbnN0IHJldCA9IG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUHJvcGVydHlPYmplY3Q8Q2ZuR2FtZVNlc3Npb25RdWV1ZS5Qcmlvcml0eUNvbmZpZ3VyYXRpb25Qcm9wZXJ0eT4oKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2xvY2F0aW9uT3JkZXInLCAnTG9jYXRpb25PcmRlcicsIHByb3BlcnRpZXMuTG9jYXRpb25PcmRlciAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmdBcnJheShwcm9wZXJ0aWVzLkxvY2F0aW9uT3JkZXIpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ3ByaW9yaXR5T3JkZXInLCAnUHJpb3JpdHlPcmRlcicsIHByb3BlcnRpZXMuUHJpb3JpdHlPcmRlciAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmdBcnJheShwcm9wZXJ0aWVzLlByaW9yaXR5T3JkZXIpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkVW5yZWNvZ25pemVkUHJvcGVydGllc0FzRXh0cmEocHJvcGVydGllcyk7XG4gICAgcmV0dXJuIHJldDtcbn1cblxuLyoqXG4gKiBQcm9wZXJ0aWVzIGZvciBkZWZpbmluZyBhIGBDZm5NYXRjaG1ha2luZ0NvbmZpZ3VyYXRpb25gXG4gKlxuICogQHN0cnVjdFxuICogQHN0YWJpbGl0eSBleHRlcm5hbFxuICpcbiAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWdhbWVsaWZ0LW1hdGNobWFraW5nY29uZmlndXJhdGlvbi5odG1sXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgQ2ZuTWF0Y2htYWtpbmdDb25maWd1cmF0aW9uUHJvcHMge1xuXG4gICAgLyoqXG4gICAgICogQSBmbGFnIHRoYXQgZGV0ZXJtaW5lcyB3aGV0aGVyIGEgbWF0Y2ggdGhhdCB3YXMgY3JlYXRlZCB3aXRoIHRoaXMgY29uZmlndXJhdGlvbiBtdXN0IGJlIGFjY2VwdGVkIGJ5IHRoZSBtYXRjaGVkIHBsYXllcnMuIFRvIHJlcXVpcmUgYWNjZXB0YW5jZSwgc2V0IHRvIGBUUlVFYCAuIFdpdGggdGhpcyBvcHRpb24gZW5hYmxlZCwgbWF0Y2htYWtpbmcgdGlja2V0cyB1c2UgdGhlIHN0YXR1cyBgUkVRVUlSRVNfQUNDRVBUQU5DRWAgdG8gaW5kaWNhdGUgd2hlbiBhIGNvbXBsZXRlZCBwb3RlbnRpYWwgbWF0Y2ggaXMgd2FpdGluZyBmb3IgcGxheWVyIGFjY2VwdGFuY2UuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1nYW1lbGlmdC1tYXRjaG1ha2luZ2NvbmZpZ3VyYXRpb24uaHRtbCNjZm4tZ2FtZWxpZnQtbWF0Y2htYWtpbmdjb25maWd1cmF0aW9uLWFjY2VwdGFuY2VyZXF1aXJlZFxuICAgICAqL1xuICAgIHJlYWRvbmx5IGFjY2VwdGFuY2VSZXF1aXJlZDogYm9vbGVhbiB8IGNkay5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIEEgdW5pcXVlIGlkZW50aWZpZXIgZm9yIHRoZSBtYXRjaG1ha2luZyBjb25maWd1cmF0aW9uLiBUaGlzIG5hbWUgaXMgdXNlZCB0byBpZGVudGlmeSB0aGUgY29uZmlndXJhdGlvbiBhc3NvY2lhdGVkIHdpdGggYSBtYXRjaG1ha2luZyByZXF1ZXN0IG9yIHRpY2tldC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWdhbWVsaWZ0LW1hdGNobWFraW5nY29uZmlndXJhdGlvbi5odG1sI2Nmbi1nYW1lbGlmdC1tYXRjaG1ha2luZ2NvbmZpZ3VyYXRpb24tbmFtZVxuICAgICAqL1xuICAgIHJlYWRvbmx5IG5hbWU6IHN0cmluZztcblxuICAgIC8qKlxuICAgICAqIFRoZSBtYXhpbXVtIGR1cmF0aW9uLCBpbiBzZWNvbmRzLCB0aGF0IGEgbWF0Y2htYWtpbmcgdGlja2V0IGNhbiByZW1haW4gaW4gcHJvY2VzcyBiZWZvcmUgdGltaW5nIG91dC4gUmVxdWVzdHMgdGhhdCBmYWlsIGR1ZSB0byB0aW1pbmcgb3V0IGNhbiBiZSByZXN1Ym1pdHRlZCBhcyBuZWVkZWQuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1nYW1lbGlmdC1tYXRjaG1ha2luZ2NvbmZpZ3VyYXRpb24uaHRtbCNjZm4tZ2FtZWxpZnQtbWF0Y2htYWtpbmdjb25maWd1cmF0aW9uLXJlcXVlc3R0aW1lb3V0c2Vjb25kc1xuICAgICAqL1xuICAgIHJlYWRvbmx5IHJlcXVlc3RUaW1lb3V0U2Vjb25kczogbnVtYmVyO1xuXG4gICAgLyoqXG4gICAgICogQSB1bmlxdWUgaWRlbnRpZmllciBmb3IgdGhlIG1hdGNobWFraW5nIHJ1bGUgc2V0IHRvIHVzZSB3aXRoIHRoaXMgY29uZmlndXJhdGlvbi4gWW91IGNhbiB1c2UgZWl0aGVyIHRoZSBydWxlIHNldCBuYW1lIG9yIEFSTiB2YWx1ZS4gQSBtYXRjaG1ha2luZyBjb25maWd1cmF0aW9uIGNhbiBvbmx5IHVzZSBydWxlIHNldHMgdGhhdCBhcmUgZGVmaW5lZCBpbiB0aGUgc2FtZSBSZWdpb24uXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1nYW1lbGlmdC1tYXRjaG1ha2luZ2NvbmZpZ3VyYXRpb24uaHRtbCNjZm4tZ2FtZWxpZnQtbWF0Y2htYWtpbmdjb25maWd1cmF0aW9uLXJ1bGVzZXRuYW1lXG4gICAgICovXG4gICAgcmVhZG9ubHkgcnVsZVNldE5hbWU6IHN0cmluZztcblxuICAgIC8qKlxuICAgICAqIFRoZSBsZW5ndGggb2YgdGltZSAoaW4gc2Vjb25kcykgdG8gd2FpdCBmb3IgcGxheWVycyB0byBhY2NlcHQgYSBwcm9wb3NlZCBtYXRjaCwgaWYgYWNjZXB0YW5jZSBpcyByZXF1aXJlZC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWdhbWVsaWZ0LW1hdGNobWFraW5nY29uZmlndXJhdGlvbi5odG1sI2Nmbi1nYW1lbGlmdC1tYXRjaG1ha2luZ2NvbmZpZ3VyYXRpb24tYWNjZXB0YW5jZXRpbWVvdXRzZWNvbmRzXG4gICAgICovXG4gICAgcmVhZG9ubHkgYWNjZXB0YW5jZVRpbWVvdXRTZWNvbmRzPzogbnVtYmVyO1xuXG4gICAgLyoqXG4gICAgICogVGhlIG51bWJlciBvZiBwbGF5ZXIgc2xvdHMgaW4gYSBtYXRjaCB0byBrZWVwIG9wZW4gZm9yIGZ1dHVyZSBwbGF5ZXJzLiBGb3IgZXhhbXBsZSwgaWYgdGhlIGNvbmZpZ3VyYXRpb24ncyBydWxlIHNldCBzcGVjaWZpZXMgYSBtYXRjaCBmb3IgYSBzaW5nbGUgMTItcGVyc29uIHRlYW0sIGFuZCB0aGUgYWRkaXRpb25hbCBwbGF5ZXIgY291bnQgaXMgc2V0IHRvIDIsIG9ubHkgMTAgcGxheWVycyBhcmUgc2VsZWN0ZWQgZm9yIHRoZSBtYXRjaC4gVGhpcyBwYXJhbWV0ZXIgaXMgbm90IHVzZWQgaWYgYEZsZXhNYXRjaE1vZGVgIGlzIHNldCB0byBgU1RBTkRBTE9ORWAgLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZ2FtZWxpZnQtbWF0Y2htYWtpbmdjb25maWd1cmF0aW9uLmh0bWwjY2ZuLWdhbWVsaWZ0LW1hdGNobWFraW5nY29uZmlndXJhdGlvbi1hZGRpdGlvbmFscGxheWVyY291bnRcbiAgICAgKi9cbiAgICByZWFkb25seSBhZGRpdGlvbmFsUGxheWVyQ291bnQ/OiBudW1iZXI7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgbWV0aG9kIHVzZWQgdG8gYmFja2ZpbGwgZ2FtZSBzZXNzaW9ucyB0aGF0IGFyZSBjcmVhdGVkIHdpdGggdGhpcyBtYXRjaG1ha2luZyBjb25maWd1cmF0aW9uLiBTcGVjaWZ5IGBNQU5VQUxgIHdoZW4geW91ciBnYW1lIG1hbmFnZXMgYmFja2ZpbGwgcmVxdWVzdHMgbWFudWFsbHkgb3IgZG9lcyBub3QgdXNlIHRoZSBtYXRjaCBiYWNrZmlsbCBmZWF0dXJlLiBTcGVjaWZ5IGBBVVRPTUFUSUNgIHRvIGhhdmUgR2FtZUxpZnQgY3JlYXRlIGEgYFN0YXJ0TWF0Y2hCYWNrZmlsbGAgcmVxdWVzdCB3aGVuZXZlciBhIGdhbWUgc2Vzc2lvbiBoYXMgb25lIG9yIG1vcmUgb3BlbiBzbG90cy4gTGVhcm4gbW9yZSBhYm91dCBtYW51YWwgYW5kIGF1dG9tYXRpYyBiYWNrZmlsbCBpbiBbQmFja2ZpbGwgRXhpc3RpbmcgR2FtZXMgd2l0aCBGbGV4TWF0Y2hdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9nYW1lbGlmdC9sYXRlc3QvZmxleG1hdGNoZ3VpZGUvbWF0Y2gtYmFja2ZpbGwuaHRtbCkgLiBBdXRvbWF0aWMgYmFja2ZpbGwgaXMgbm90IGF2YWlsYWJsZSB3aGVuIGBGbGV4TWF0Y2hNb2RlYCBpcyBzZXQgdG8gYFNUQU5EQUxPTkVgIC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWdhbWVsaWZ0LW1hdGNobWFraW5nY29uZmlndXJhdGlvbi5odG1sI2Nmbi1nYW1lbGlmdC1tYXRjaG1ha2luZ2NvbmZpZ3VyYXRpb24tYmFja2ZpbGxtb2RlXG4gICAgICovXG4gICAgcmVhZG9ubHkgYmFja2ZpbGxNb2RlPzogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogSW5mb3JtYXRpb24gdG8gYWRkIHRvIGFsbCBldmVudHMgcmVsYXRlZCB0byB0aGUgbWF0Y2htYWtpbmcgY29uZmlndXJhdGlvbi5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWdhbWVsaWZ0LW1hdGNobWFraW5nY29uZmlndXJhdGlvbi5odG1sI2Nmbi1nYW1lbGlmdC1tYXRjaG1ha2luZ2NvbmZpZ3VyYXRpb24tY3VzdG9tZXZlbnRkYXRhXG4gICAgICovXG4gICAgcmVhZG9ubHkgY3VzdG9tRXZlbnREYXRhPzogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogQSBkZXNjcmlwdGl2ZSBsYWJlbCB0aGF0IGlzIGFzc29jaWF0ZWQgd2l0aCBtYXRjaG1ha2luZyBjb25maWd1cmF0aW9uLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZ2FtZWxpZnQtbWF0Y2htYWtpbmdjb25maWd1cmF0aW9uLmh0bWwjY2ZuLWdhbWVsaWZ0LW1hdGNobWFraW5nY29uZmlndXJhdGlvbi1kZXNjcmlwdGlvblxuICAgICAqL1xuICAgIHJlYWRvbmx5IGRlc2NyaXB0aW9uPzogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogSW5kaWNhdGVzIHdoZXRoZXIgdGhpcyBtYXRjaG1ha2luZyBjb25maWd1cmF0aW9uIGlzIGJlaW5nIHVzZWQgd2l0aCBHYW1lTGlmdCBob3N0aW5nIG9yIGFzIGEgc3RhbmRhbG9uZSBtYXRjaG1ha2luZyBzb2x1dGlvbi5cbiAgICAgKlxuICAgICAqIC0gKlNUQU5EQUxPTkUqIC0gRmxleE1hdGNoIGZvcm1zIG1hdGNoZXMgYW5kIHJldHVybnMgbWF0Y2ggaW5mb3JtYXRpb24sIGluY2x1ZGluZyBwbGF5ZXJzIGFuZCB0ZWFtIGFzc2lnbm1lbnRzLCBpbiBhIFtNYXRjaG1ha2luZ1N1Y2NlZWRlZF0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2dhbWVsaWZ0L2xhdGVzdC9mbGV4bWF0Y2hndWlkZS9tYXRjaC1ldmVudHMuaHRtbCNtYXRjaC1ldmVudHMtbWF0Y2htYWtpbmdzdWNjZWVkZWQpIGV2ZW50LlxuICAgICAqIC0gKldJVEhfUVVFVUUqIC0gRmxleE1hdGNoIGZvcm1zIG1hdGNoZXMgYW5kIHVzZXMgdGhlIHNwZWNpZmllZCBHYW1lTGlmdCBxdWV1ZSB0byBzdGFydCBhIGdhbWUgc2Vzc2lvbiBmb3IgdGhlIG1hdGNoLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZ2FtZWxpZnQtbWF0Y2htYWtpbmdjb25maWd1cmF0aW9uLmh0bWwjY2ZuLWdhbWVsaWZ0LW1hdGNobWFraW5nY29uZmlndXJhdGlvbi1mbGV4bWF0Y2htb2RlXG4gICAgICovXG4gICAgcmVhZG9ubHkgZmxleE1hdGNoTW9kZT86IHN0cmluZztcblxuICAgIC8qKlxuICAgICAqIEEgc2V0IG9mIGN1c3RvbSBwcm9wZXJ0aWVzIGZvciBhIGdhbWUgc2Vzc2lvbiwgZm9ybWF0dGVkIGFzIGtleS12YWx1ZSBwYWlycy4gVGhlc2UgcHJvcGVydGllcyBhcmUgcGFzc2VkIHRvIGEgZ2FtZSBzZXJ2ZXIgcHJvY2VzcyB3aXRoIGEgcmVxdWVzdCB0byBzdGFydCBhIG5ldyBnYW1lIHNlc3Npb24uIFNlZSBbU3RhcnQgYSBHYW1lIFNlc3Npb25dKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9nYW1lbGlmdC9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUvZ2FtZWxpZnQtc2RrLXNlcnZlci1hcGkuaHRtbCNnYW1lbGlmdC1zZGstc2VydmVyLXN0YXJ0c2Vzc2lvbikgLiBUaGlzIHBhcmFtZXRlciBpcyBub3QgdXNlZCBpZiBgRmxleE1hdGNoTW9kZWAgaXMgc2V0IHRvIGBTVEFOREFMT05FYCAuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1nYW1lbGlmdC1tYXRjaG1ha2luZ2NvbmZpZ3VyYXRpb24uaHRtbCNjZm4tZ2FtZWxpZnQtbWF0Y2htYWtpbmdjb25maWd1cmF0aW9uLWdhbWVwcm9wZXJ0aWVzXG4gICAgICovXG4gICAgcmVhZG9ubHkgZ2FtZVByb3BlcnRpZXM/OiBBcnJheTxDZm5NYXRjaG1ha2luZ0NvbmZpZ3VyYXRpb24uR2FtZVByb3BlcnR5UHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGU+IHwgY2RrLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQSBzZXQgb2YgY3VzdG9tIGdhbWUgc2Vzc2lvbiBwcm9wZXJ0aWVzLCBmb3JtYXR0ZWQgYXMgYSBzaW5nbGUgc3RyaW5nIHZhbHVlLiBUaGlzIGRhdGEgaXMgcGFzc2VkIHRvIGEgZ2FtZSBzZXJ2ZXIgcHJvY2VzcyB3aXRoIGEgcmVxdWVzdCB0byBzdGFydCBhIG5ldyBnYW1lIHNlc3Npb24uIFNlZSBbU3RhcnQgYSBHYW1lIFNlc3Npb25dKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9nYW1lbGlmdC9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUvZ2FtZWxpZnQtc2RrLXNlcnZlci1hcGkuaHRtbCNnYW1lbGlmdC1zZGstc2VydmVyLXN0YXJ0c2Vzc2lvbikgLiBUaGlzIHBhcmFtZXRlciBpcyBub3QgdXNlZCBpZiBgRmxleE1hdGNoTW9kZWAgaXMgc2V0IHRvIGBTVEFOREFMT05FYCAuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1nYW1lbGlmdC1tYXRjaG1ha2luZ2NvbmZpZ3VyYXRpb24uaHRtbCNjZm4tZ2FtZWxpZnQtbWF0Y2htYWtpbmdjb25maWd1cmF0aW9uLWdhbWVzZXNzaW9uZGF0YVxuICAgICAqL1xuICAgIHJlYWRvbmx5IGdhbWVTZXNzaW9uRGF0YT86IHN0cmluZztcblxuICAgIC8qKlxuICAgICAqIFRoZSBBbWF6b24gUmVzb3VyY2UgTmFtZSAoIFtBUk5dKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BbWF6b25TMy9sYXRlc3QvZGV2L3MzLWFybi1mb3JtYXQuaHRtbCkgKSB0aGF0IGlzIGFzc2lnbmVkIHRvIGEgR2FtZUxpZnQgZ2FtZSBzZXNzaW9uIHF1ZXVlIHJlc291cmNlIGFuZCB1bmlxdWVseSBpZGVudGlmaWVzIGl0LiBBUk5zIGFyZSB1bmlxdWUgYWNyb3NzIGFsbCBSZWdpb25zLiBGb3JtYXQgaXMgYGFybjphd3M6Z2FtZWxpZnQ6PHJlZ2lvbj46OmdhbWVzZXNzaW9ucXVldWUvPHF1ZXVlIG5hbWU+YCAuIFF1ZXVlcyBjYW4gYmUgbG9jYXRlZCBpbiBhbnkgUmVnaW9uLiBRdWV1ZXMgYXJlIHVzZWQgdG8gc3RhcnQgbmV3IEdhbWVMaWZ0LWhvc3RlZCBnYW1lIHNlc3Npb25zIGZvciBtYXRjaGVzIHRoYXQgYXJlIGNyZWF0ZWQgd2l0aCB0aGlzIG1hdGNobWFraW5nIGNvbmZpZ3VyYXRpb24uIElmIGBGbGV4TWF0Y2hNb2RlYCBpcyBzZXQgdG8gYFNUQU5EQUxPTkVgICwgZG8gbm90IHNldCB0aGlzIHBhcmFtZXRlci5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWdhbWVsaWZ0LW1hdGNobWFraW5nY29uZmlndXJhdGlvbi5odG1sI2Nmbi1nYW1lbGlmdC1tYXRjaG1ha2luZ2NvbmZpZ3VyYXRpb24tZ2FtZXNlc3Npb25xdWV1ZWFybnNcbiAgICAgKi9cbiAgICByZWFkb25seSBnYW1lU2Vzc2lvblF1ZXVlQXJucz86IHN0cmluZ1tdO1xuXG4gICAgLyoqXG4gICAgICogQW4gU05TIHRvcGljIEFSTiB0aGF0IGlzIHNldCB1cCB0byByZWNlaXZlIG1hdGNobWFraW5nIG5vdGlmaWNhdGlvbnMuIFNlZSBbU2V0dGluZyB1cCBub3RpZmljYXRpb25zIGZvciBtYXRjaG1ha2luZ10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2dhbWVsaWZ0L2xhdGVzdC9mbGV4bWF0Y2hndWlkZS9tYXRjaC1ub3RpZmljYXRpb24uaHRtbCkgZm9yIG1vcmUgaW5mb3JtYXRpb24uXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1nYW1lbGlmdC1tYXRjaG1ha2luZ2NvbmZpZ3VyYXRpb24uaHRtbCNjZm4tZ2FtZWxpZnQtbWF0Y2htYWtpbmdjb25maWd1cmF0aW9uLW5vdGlmaWNhdGlvbnRhcmdldFxuICAgICAqL1xuICAgIHJlYWRvbmx5IG5vdGlmaWNhdGlvblRhcmdldD86IHN0cmluZztcblxuICAgIC8qKlxuICAgICAqIEEgbGlzdCBvZiBsYWJlbHMgdG8gYXNzaWduIHRvIHRoZSBuZXcgbWF0Y2htYWtpbmcgY29uZmlndXJhdGlvbiByZXNvdXJjZS4gVGFncyBhcmUgZGV2ZWxvcGVyLWRlZmluZWQga2V5LXZhbHVlIHBhaXJzLiBUYWdnaW5nIEFXUyByZXNvdXJjZXMgYXJlIHVzZWZ1bCBmb3IgcmVzb3VyY2UgbWFuYWdlbWVudCwgYWNjZXNzIG1hbmFnZW1lbnQgYW5kIGNvc3QgYWxsb2NhdGlvbi4gRm9yIG1vcmUgaW5mb3JtYXRpb24sIHNlZSBbVGFnZ2luZyBBV1MgUmVzb3VyY2VzXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZ2VuZXJhbC9sYXRlc3QvZ3IvYXdzX3RhZ2dpbmcuaHRtbCkgaW4gdGhlICpBV1MgR2VuZXJhbCBSZWZlcmVuY2UqIC4gT25jZSB0aGUgcmVzb3VyY2UgaXMgY3JlYXRlZCwgeW91IGNhbiB1c2UgVGFnUmVzb3VyY2UsIFVudGFnUmVzb3VyY2UsIGFuZCBMaXN0VGFnc0ZvclJlc291cmNlIHRvIGFkZCwgcmVtb3ZlLCBhbmQgdmlldyB0YWdzLiBUaGUgbWF4aW11bSB0YWcgbGltaXQgbWF5IGJlIGxvd2VyIHRoYW4gc3RhdGVkLiBTZWUgdGhlIEFXUyBHZW5lcmFsIFJlZmVyZW5jZSBmb3IgYWN0dWFsIHRhZ2dpbmcgbGltaXRzLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZ2FtZWxpZnQtbWF0Y2htYWtpbmdjb25maWd1cmF0aW9uLmh0bWwjY2ZuLWdhbWVsaWZ0LW1hdGNobWFraW5nY29uZmlndXJhdGlvbi10YWdzXG4gICAgICovXG4gICAgcmVhZG9ubHkgdGFncz86IGNkay5DZm5UYWdbXTtcbn1cblxuLyoqXG4gKiBEZXRlcm1pbmUgd2hldGhlciB0aGUgZ2l2ZW4gcHJvcGVydGllcyBtYXRjaCB0aG9zZSBvZiBhIGBDZm5NYXRjaG1ha2luZ0NvbmZpZ3VyYXRpb25Qcm9wc2BcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgQ2ZuTWF0Y2htYWtpbmdDb25maWd1cmF0aW9uUHJvcHNgXG4gKlxuICogQHJldHVybnMgdGhlIHJlc3VsdCBvZiB0aGUgdmFsaWRhdGlvbi5cbiAqL1xuZnVuY3Rpb24gQ2ZuTWF0Y2htYWtpbmdDb25maWd1cmF0aW9uUHJvcHNWYWxpZGF0b3IocHJvcGVydGllczogYW55KTogY2RrLlZhbGlkYXRpb25SZXN1bHQge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIGNkay5WQUxJREFUSU9OX1NVQ0NFU1M7IH1cbiAgICBjb25zdCBlcnJvcnMgPSBuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHRzKCk7XG4gICAgaWYgKHR5cGVvZiBwcm9wZXJ0aWVzICE9PSAnb2JqZWN0Jykge1xuICAgICAgICBlcnJvcnMuY29sbGVjdChuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHQoJ0V4cGVjdGVkIGFuIG9iamVjdCwgYnV0IHJlY2VpdmVkOiAnICsgSlNPTi5zdHJpbmdpZnkocHJvcGVydGllcykpKTtcbiAgICB9XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdhY2NlcHRhbmNlUmVxdWlyZWQnLCBjZGsucmVxdWlyZWRWYWxpZGF0b3IpKHByb3BlcnRpZXMuYWNjZXB0YW5jZVJlcXVpcmVkKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdhY2NlcHRhbmNlUmVxdWlyZWQnLCBjZGsudmFsaWRhdGVCb29sZWFuKShwcm9wZXJ0aWVzLmFjY2VwdGFuY2VSZXF1aXJlZCkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignYWNjZXB0YW5jZVRpbWVvdXRTZWNvbmRzJywgY2RrLnZhbGlkYXRlTnVtYmVyKShwcm9wZXJ0aWVzLmFjY2VwdGFuY2VUaW1lb3V0U2Vjb25kcykpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignYWRkaXRpb25hbFBsYXllckNvdW50JywgY2RrLnZhbGlkYXRlTnVtYmVyKShwcm9wZXJ0aWVzLmFkZGl0aW9uYWxQbGF5ZXJDb3VudCkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignYmFja2ZpbGxNb2RlJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmJhY2tmaWxsTW9kZSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignY3VzdG9tRXZlbnREYXRhJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmN1c3RvbUV2ZW50RGF0YSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignZGVzY3JpcHRpb24nLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuZGVzY3JpcHRpb24pKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2ZsZXhNYXRjaE1vZGUnLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuZmxleE1hdGNoTW9kZSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignZ2FtZVByb3BlcnRpZXMnLCBjZGsubGlzdFZhbGlkYXRvcihDZm5NYXRjaG1ha2luZ0NvbmZpZ3VyYXRpb25fR2FtZVByb3BlcnR5UHJvcGVydHlWYWxpZGF0b3IpKShwcm9wZXJ0aWVzLmdhbWVQcm9wZXJ0aWVzKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdnYW1lU2Vzc2lvbkRhdGEnLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuZ2FtZVNlc3Npb25EYXRhKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdnYW1lU2Vzc2lvblF1ZXVlQXJucycsIGNkay5saXN0VmFsaWRhdG9yKGNkay52YWxpZGF0ZVN0cmluZykpKHByb3BlcnRpZXMuZ2FtZVNlc3Npb25RdWV1ZUFybnMpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ25hbWUnLCBjZGsucmVxdWlyZWRWYWxpZGF0b3IpKHByb3BlcnRpZXMubmFtZSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignbmFtZScsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5uYW1lKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdub3RpZmljYXRpb25UYXJnZXQnLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMubm90aWZpY2F0aW9uVGFyZ2V0KSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdyZXF1ZXN0VGltZW91dFNlY29uZHMnLCBjZGsucmVxdWlyZWRWYWxpZGF0b3IpKHByb3BlcnRpZXMucmVxdWVzdFRpbWVvdXRTZWNvbmRzKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdyZXF1ZXN0VGltZW91dFNlY29uZHMnLCBjZGsudmFsaWRhdGVOdW1iZXIpKHByb3BlcnRpZXMucmVxdWVzdFRpbWVvdXRTZWNvbmRzKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdydWxlU2V0TmFtZScsIGNkay5yZXF1aXJlZFZhbGlkYXRvcikocHJvcGVydGllcy5ydWxlU2V0TmFtZSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigncnVsZVNldE5hbWUnLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMucnVsZVNldE5hbWUpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3RhZ3MnLCBjZGsubGlzdFZhbGlkYXRvcihjZGsudmFsaWRhdGVDZm5UYWcpKShwcm9wZXJ0aWVzLnRhZ3MpKTtcbiAgICByZXR1cm4gZXJyb3JzLndyYXAoJ3N1cHBsaWVkIHByb3BlcnRpZXMgbm90IGNvcnJlY3QgZm9yIFwiQ2ZuTWF0Y2htYWtpbmdDb25maWd1cmF0aW9uUHJvcHNcIicpO1xufVxuXG4vKipcbiAqIFJlbmRlcnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OkdhbWVMaWZ0OjpNYXRjaG1ha2luZ0NvbmZpZ3VyYXRpb25gIHJlc291cmNlXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYENmbk1hdGNobWFraW5nQ29uZmlndXJhdGlvblByb3BzYFxuICpcbiAqIEByZXR1cm5zIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpHYW1lTGlmdDo6TWF0Y2htYWtpbmdDb25maWd1cmF0aW9uYCByZXNvdXJjZS5cbiAqL1xuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIGNmbk1hdGNobWFraW5nQ29uZmlndXJhdGlvblByb3BzVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBhbnkge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIHByb3BlcnRpZXM7IH1cbiAgICBDZm5NYXRjaG1ha2luZ0NvbmZpZ3VyYXRpb25Qcm9wc1ZhbGlkYXRvcihwcm9wZXJ0aWVzKS5hc3NlcnRTdWNjZXNzKCk7XG4gICAgcmV0dXJuIHtcbiAgICAgICAgQWNjZXB0YW5jZVJlcXVpcmVkOiBjZGsuYm9vbGVhblRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5hY2NlcHRhbmNlUmVxdWlyZWQpLFxuICAgICAgICBOYW1lOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLm5hbWUpLFxuICAgICAgICBSZXF1ZXN0VGltZW91dFNlY29uZHM6IGNkay5udW1iZXJUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMucmVxdWVzdFRpbWVvdXRTZWNvbmRzKSxcbiAgICAgICAgUnVsZVNldE5hbWU6IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMucnVsZVNldE5hbWUpLFxuICAgICAgICBBY2NlcHRhbmNlVGltZW91dFNlY29uZHM6IGNkay5udW1iZXJUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuYWNjZXB0YW5jZVRpbWVvdXRTZWNvbmRzKSxcbiAgICAgICAgQWRkaXRpb25hbFBsYXllckNvdW50OiBjZGsubnVtYmVyVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLmFkZGl0aW9uYWxQbGF5ZXJDb3VudCksXG4gICAgICAgIEJhY2tmaWxsTW9kZTogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5iYWNrZmlsbE1vZGUpLFxuICAgICAgICBDdXN0b21FdmVudERhdGE6IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuY3VzdG9tRXZlbnREYXRhKSxcbiAgICAgICAgRGVzY3JpcHRpb246IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuZGVzY3JpcHRpb24pLFxuICAgICAgICBGbGV4TWF0Y2hNb2RlOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLmZsZXhNYXRjaE1vZGUpLFxuICAgICAgICBHYW1lUHJvcGVydGllczogY2RrLmxpc3RNYXBwZXIoY2ZuTWF0Y2htYWtpbmdDb25maWd1cmF0aW9uR2FtZVByb3BlcnR5UHJvcGVydHlUb0Nsb3VkRm9ybWF0aW9uKShwcm9wZXJ0aWVzLmdhbWVQcm9wZXJ0aWVzKSxcbiAgICAgICAgR2FtZVNlc3Npb25EYXRhOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLmdhbWVTZXNzaW9uRGF0YSksXG4gICAgICAgIEdhbWVTZXNzaW9uUXVldWVBcm5zOiBjZGsubGlzdE1hcHBlcihjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbikocHJvcGVydGllcy5nYW1lU2Vzc2lvblF1ZXVlQXJucyksXG4gICAgICAgIE5vdGlmaWNhdGlvblRhcmdldDogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5ub3RpZmljYXRpb25UYXJnZXQpLFxuICAgICAgICBUYWdzOiBjZGsubGlzdE1hcHBlcihjZGsuY2ZuVGFnVG9DbG91ZEZvcm1hdGlvbikocHJvcGVydGllcy50YWdzKSxcbiAgICB9O1xufVxuXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gQ2ZuTWF0Y2htYWtpbmdDb25maWd1cmF0aW9uUHJvcHNGcm9tQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdDxDZm5NYXRjaG1ha2luZ0NvbmZpZ3VyYXRpb25Qcm9wcz4ge1xuICAgIHByb3BlcnRpZXMgPSBwcm9wZXJ0aWVzID09IG51bGwgPyB7fSA6IHByb3BlcnRpZXM7XG4gICAgaWYgKHR5cGVvZiBwcm9wZXJ0aWVzICE9PSAnb2JqZWN0Jykge1xuICAgICAgICByZXR1cm4gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQocHJvcGVydGllcyk7XG4gICAgfVxuICAgIGNvbnN0IHJldCA9IG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUHJvcGVydHlPYmplY3Q8Q2ZuTWF0Y2htYWtpbmdDb25maWd1cmF0aW9uUHJvcHM+KCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdhY2NlcHRhbmNlUmVxdWlyZWQnLCAnQWNjZXB0YW5jZVJlcXVpcmVkJywgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRCb29sZWFuKHByb3BlcnRpZXMuQWNjZXB0YW5jZVJlcXVpcmVkKSk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCduYW1lJywgJ05hbWUnLCBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLk5hbWUpKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ3JlcXVlc3RUaW1lb3V0U2Vjb25kcycsICdSZXF1ZXN0VGltZW91dFNlY29uZHMnLCBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldE51bWJlcihwcm9wZXJ0aWVzLlJlcXVlc3RUaW1lb3V0U2Vjb25kcykpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgncnVsZVNldE5hbWUnLCAnUnVsZVNldE5hbWUnLCBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLlJ1bGVTZXROYW1lKSk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdhY2NlcHRhbmNlVGltZW91dFNlY29uZHMnLCAnQWNjZXB0YW5jZVRpbWVvdXRTZWNvbmRzJywgcHJvcGVydGllcy5BY2NlcHRhbmNlVGltZW91dFNlY29uZHMgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0TnVtYmVyKHByb3BlcnRpZXMuQWNjZXB0YW5jZVRpbWVvdXRTZWNvbmRzKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdhZGRpdGlvbmFsUGxheWVyQ291bnQnLCAnQWRkaXRpb25hbFBsYXllckNvdW50JywgcHJvcGVydGllcy5BZGRpdGlvbmFsUGxheWVyQ291bnQgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0TnVtYmVyKHByb3BlcnRpZXMuQWRkaXRpb25hbFBsYXllckNvdW50KSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdiYWNrZmlsbE1vZGUnLCAnQmFja2ZpbGxNb2RlJywgcHJvcGVydGllcy5CYWNrZmlsbE1vZGUgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuQmFja2ZpbGxNb2RlKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdjdXN0b21FdmVudERhdGEnLCAnQ3VzdG9tRXZlbnREYXRhJywgcHJvcGVydGllcy5DdXN0b21FdmVudERhdGEgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuQ3VzdG9tRXZlbnREYXRhKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdkZXNjcmlwdGlvbicsICdEZXNjcmlwdGlvbicsIHByb3BlcnRpZXMuRGVzY3JpcHRpb24gIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuRGVzY3JpcHRpb24pIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2ZsZXhNYXRjaE1vZGUnLCAnRmxleE1hdGNoTW9kZScsIHByb3BlcnRpZXMuRmxleE1hdGNoTW9kZSAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5GbGV4TWF0Y2hNb2RlKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdnYW1lUHJvcGVydGllcycsICdHYW1lUHJvcGVydGllcycsIHByb3BlcnRpZXMuR2FtZVByb3BlcnRpZXMgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0QXJyYXkoQ2ZuTWF0Y2htYWtpbmdDb25maWd1cmF0aW9uR2FtZVByb3BlcnR5UHJvcGVydHlGcm9tQ2xvdWRGb3JtYXRpb24pKHByb3BlcnRpZXMuR2FtZVByb3BlcnRpZXMpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2dhbWVTZXNzaW9uRGF0YScsICdHYW1lU2Vzc2lvbkRhdGEnLCBwcm9wZXJ0aWVzLkdhbWVTZXNzaW9uRGF0YSAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5HYW1lU2Vzc2lvbkRhdGEpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2dhbWVTZXNzaW9uUXVldWVBcm5zJywgJ0dhbWVTZXNzaW9uUXVldWVBcm5zJywgcHJvcGVydGllcy5HYW1lU2Vzc2lvblF1ZXVlQXJucyAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmdBcnJheShwcm9wZXJ0aWVzLkdhbWVTZXNzaW9uUXVldWVBcm5zKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdub3RpZmljYXRpb25UYXJnZXQnLCAnTm90aWZpY2F0aW9uVGFyZ2V0JywgcHJvcGVydGllcy5Ob3RpZmljYXRpb25UYXJnZXQgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuTm90aWZpY2F0aW9uVGFyZ2V0KSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCd0YWdzJywgJ1RhZ3MnLCBwcm9wZXJ0aWVzLlRhZ3MgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0QXJyYXkoY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRDZm5UYWcpKHByb3BlcnRpZXMuVGFncykgOiB1bmRlZmluZWQgYXMgYW55KTtcbiAgICByZXQuYWRkVW5yZWNvZ25pemVkUHJvcGVydGllc0FzRXh0cmEocHJvcGVydGllcyk7XG4gICAgcmV0dXJuIHJldDtcbn1cblxuLyoqXG4gKiBBIENsb3VkRm9ybWF0aW9uIGBBV1M6OkdhbWVMaWZ0OjpNYXRjaG1ha2luZ0NvbmZpZ3VyYXRpb25gXG4gKlxuICogVGhlIGBBV1M6OkdhbWVMaWZ0OjpNYXRjaG1ha2luZ0NvbmZpZ3VyYXRpb25gIHJlc291cmNlIGRlZmluZXMgYSBuZXcgbWF0Y2htYWtpbmcgY29uZmlndXJhdGlvbiBmb3IgdXNlIHdpdGggRmxleE1hdGNoLiBXaGV0aGVyIHlvdSdyZSB1c2luZyBGbGV4TWF0Y2ggd2l0aCBHYW1lTGlmdCBob3N0aW5nIG9yIGFzIGEgc3RhbmRhbG9uZSBtYXRjaG1ha2luZyBzZXJ2aWNlLCB0aGUgbWF0Y2htYWtpbmcgY29uZmlndXJhdGlvbiBzZXRzIG91dCBydWxlcyBmb3IgbWF0Y2hpbmcgcGxheWVycyBhbmQgZm9ybWluZyB0ZWFtcy4gSWYgeW91J3JlIHVzaW5nIEdhbWVMaWZ0IGhvc3RpbmcsIGl0IGFsc28gZGVmaW5lcyBob3cgdG8gc3RhcnQgZ2FtZSBzZXNzaW9ucyBmb3IgZWFjaCBtYXRjaC4gWW91ciBtYXRjaG1ha2luZyBzeXN0ZW0gY2FuIHVzZSBtdWx0aXBsZSBjb25maWd1cmF0aW9ucyB0byBoYW5kbGUgZGlmZmVyZW50IGdhbWUgc2NlbmFyaW9zLiBBbGwgbWF0Y2htYWtpbmcgcmVxdWVzdHMgaWRlbnRpZnkgdGhlIG1hdGNobWFraW5nIGNvbmZpZ3VyYXRpb24gdG8gdXNlIGFuZCBwcm92aWRlIHBsYXllciBhdHRyaWJ1dGVzIHRoYXQgYXJlIGNvbnNpc3RlbnQgd2l0aCB0aGF0IGNvbmZpZ3VyYXRpb24uXG4gKlxuICogQGNsb3VkZm9ybWF0aW9uUmVzb3VyY2UgQVdTOjpHYW1lTGlmdDo6TWF0Y2htYWtpbmdDb25maWd1cmF0aW9uXG4gKiBAc3RhYmlsaXR5IGV4dGVybmFsXG4gKlxuICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZ2FtZWxpZnQtbWF0Y2htYWtpbmdjb25maWd1cmF0aW9uLmh0bWxcbiAqL1xuZXhwb3J0IGNsYXNzIENmbk1hdGNobWFraW5nQ29uZmlndXJhdGlvbiBleHRlbmRzIGNkay5DZm5SZXNvdXJjZSBpbXBsZW1lbnRzIGNkay5JSW5zcGVjdGFibGUge1xuICAgIC8qKlxuICAgICAqIFRoZSBDbG91ZEZvcm1hdGlvbiByZXNvdXJjZSB0eXBlIG5hbWUgZm9yIHRoaXMgcmVzb3VyY2UgY2xhc3MuXG4gICAgICovXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBDRk5fUkVTT1VSQ0VfVFlQRV9OQU1FID0gXCJBV1M6OkdhbWVMaWZ0OjpNYXRjaG1ha2luZ0NvbmZpZ3VyYXRpb25cIjtcblxuICAgIC8qKlxuICAgICAqIEEgZmFjdG9yeSBtZXRob2QgdGhhdCBjcmVhdGVzIGEgbmV3IGluc3RhbmNlIG9mIHRoaXMgY2xhc3MgZnJvbSBhbiBvYmplY3RcbiAgICAgKiBjb250YWluaW5nIHRoZSBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIHRoaXMgcmVzb3VyY2UuXG4gICAgICogVXNlZCBpbiB0aGUgQGF3cy1jZGsvY2xvdWRmb3JtYXRpb24taW5jbHVkZSBtb2R1bGUuXG4gICAgICpcbiAgICAgKiBAaW50ZXJuYWxcbiAgICAgKi9cbiAgICBwdWJsaWMgc3RhdGljIF9mcm9tQ2xvdWRGb3JtYXRpb24oc2NvcGU6IGNkay5Db25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHJlc291cmNlQXR0cmlidXRlczogYW55LCBvcHRpb25zOiBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uT3B0aW9ucyk6IENmbk1hdGNobWFraW5nQ29uZmlndXJhdGlvbiB7XG4gICAgICAgIHJlc291cmNlQXR0cmlidXRlcyA9IHJlc291cmNlQXR0cmlidXRlcyB8fCB7fTtcbiAgICAgICAgY29uc3QgcmVzb3VyY2VQcm9wZXJ0aWVzID0gb3B0aW9ucy5wYXJzZXIucGFyc2VWYWx1ZShyZXNvdXJjZUF0dHJpYnV0ZXMuUHJvcGVydGllcyk7XG4gICAgICAgIGNvbnN0IHByb3BzUmVzdWx0ID0gQ2ZuTWF0Y2htYWtpbmdDb25maWd1cmF0aW9uUHJvcHNGcm9tQ2xvdWRGb3JtYXRpb24ocmVzb3VyY2VQcm9wZXJ0aWVzKTtcbiAgICAgICAgY29uc3QgcmV0ID0gbmV3IENmbk1hdGNobWFraW5nQ29uZmlndXJhdGlvbihzY29wZSwgaWQsIHByb3BzUmVzdWx0LnZhbHVlKTtcbiAgICAgICAgZm9yIChjb25zdCBbcHJvcEtleSwgcHJvcFZhbF0gb2YgT2JqZWN0LmVudHJpZXMocHJvcHNSZXN1bHQuZXh0cmFQcm9wZXJ0aWVzKSkgIHtcbiAgICAgICAgICAgIHJldC5hZGRQcm9wZXJ0eU92ZXJyaWRlKHByb3BLZXksIHByb3BWYWwpO1xuICAgICAgICB9XG4gICAgICAgIG9wdGlvbnMucGFyc2VyLmhhbmRsZUF0dHJpYnV0ZXMocmV0LCByZXNvdXJjZUF0dHJpYnV0ZXMsIGlkKTtcbiAgICAgICAgcmV0dXJuIHJldDtcbiAgICB9XG5cbiAgICAvKipcbiAgICAgKiBUaGUgdW5pcXVlIEFtYXpvbiBSZXNvdXJjZSBOYW1lIChBUk4pIGZvciB0aGUgYE1hdGNobWFraW5nQ29uZmlndXJhdGlvbmAgLlxuICAgICAqIEBjbG91ZGZvcm1hdGlvbkF0dHJpYnV0ZSBBcm5cbiAgICAgKi9cbiAgICBwdWJsaWMgcmVhZG9ubHkgYXR0ckFybjogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogVGhlIGBNYXRjaG1ha2luZ0NvbmZpZ3VyYXRpb25gIG5hbWUsIHdoaWNoIGlzIHVuaXF1ZS5cbiAgICAgKiBAY2xvdWRmb3JtYXRpb25BdHRyaWJ1dGUgTmFtZVxuICAgICAqL1xuICAgIHB1YmxpYyByZWFkb25seSBhdHRyTmFtZTogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogQSBmbGFnIHRoYXQgZGV0ZXJtaW5lcyB3aGV0aGVyIGEgbWF0Y2ggdGhhdCB3YXMgY3JlYXRlZCB3aXRoIHRoaXMgY29uZmlndXJhdGlvbiBtdXN0IGJlIGFjY2VwdGVkIGJ5IHRoZSBtYXRjaGVkIHBsYXllcnMuIFRvIHJlcXVpcmUgYWNjZXB0YW5jZSwgc2V0IHRvIGBUUlVFYCAuIFdpdGggdGhpcyBvcHRpb24gZW5hYmxlZCwgbWF0Y2htYWtpbmcgdGlja2V0cyB1c2UgdGhlIHN0YXR1cyBgUkVRVUlSRVNfQUNDRVBUQU5DRWAgdG8gaW5kaWNhdGUgd2hlbiBhIGNvbXBsZXRlZCBwb3RlbnRpYWwgbWF0Y2ggaXMgd2FpdGluZyBmb3IgcGxheWVyIGFjY2VwdGFuY2UuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1nYW1lbGlmdC1tYXRjaG1ha2luZ2NvbmZpZ3VyYXRpb24uaHRtbCNjZm4tZ2FtZWxpZnQtbWF0Y2htYWtpbmdjb25maWd1cmF0aW9uLWFjY2VwdGFuY2VyZXF1aXJlZFxuICAgICAqL1xuICAgIHB1YmxpYyBhY2NlcHRhbmNlUmVxdWlyZWQ6IGJvb2xlYW4gfCBjZGsuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBBIHVuaXF1ZSBpZGVudGlmaWVyIGZvciB0aGUgbWF0Y2htYWtpbmcgY29uZmlndXJhdGlvbi4gVGhpcyBuYW1lIGlzIHVzZWQgdG8gaWRlbnRpZnkgdGhlIGNvbmZpZ3VyYXRpb24gYXNzb2NpYXRlZCB3aXRoIGEgbWF0Y2htYWtpbmcgcmVxdWVzdCBvciB0aWNrZXQuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1nYW1lbGlmdC1tYXRjaG1ha2luZ2NvbmZpZ3VyYXRpb24uaHRtbCNjZm4tZ2FtZWxpZnQtbWF0Y2htYWtpbmdjb25maWd1cmF0aW9uLW5hbWVcbiAgICAgKi9cbiAgICBwdWJsaWMgbmFtZTogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogVGhlIG1heGltdW0gZHVyYXRpb24sIGluIHNlY29uZHMsIHRoYXQgYSBtYXRjaG1ha2luZyB0aWNrZXQgY2FuIHJlbWFpbiBpbiBwcm9jZXNzIGJlZm9yZSB0aW1pbmcgb3V0LiBSZXF1ZXN0cyB0aGF0IGZhaWwgZHVlIHRvIHRpbWluZyBvdXQgY2FuIGJlIHJlc3VibWl0dGVkIGFzIG5lZWRlZC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWdhbWVsaWZ0LW1hdGNobWFraW5nY29uZmlndXJhdGlvbi5odG1sI2Nmbi1nYW1lbGlmdC1tYXRjaG1ha2luZ2NvbmZpZ3VyYXRpb24tcmVxdWVzdHRpbWVvdXRzZWNvbmRzXG4gICAgICovXG4gICAgcHVibGljIHJlcXVlc3RUaW1lb3V0U2Vjb25kczogbnVtYmVyO1xuXG4gICAgLyoqXG4gICAgICogQSB1bmlxdWUgaWRlbnRpZmllciBmb3IgdGhlIG1hdGNobWFraW5nIHJ1bGUgc2V0IHRvIHVzZSB3aXRoIHRoaXMgY29uZmlndXJhdGlvbi4gWW91IGNhbiB1c2UgZWl0aGVyIHRoZSBydWxlIHNldCBuYW1lIG9yIEFSTiB2YWx1ZS4gQSBtYXRjaG1ha2luZyBjb25maWd1cmF0aW9uIGNhbiBvbmx5IHVzZSBydWxlIHNldHMgdGhhdCBhcmUgZGVmaW5lZCBpbiB0aGUgc2FtZSBSZWdpb24uXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1nYW1lbGlmdC1tYXRjaG1ha2luZ2NvbmZpZ3VyYXRpb24uaHRtbCNjZm4tZ2FtZWxpZnQtbWF0Y2htYWtpbmdjb25maWd1cmF0aW9uLXJ1bGVzZXRuYW1lXG4gICAgICovXG4gICAgcHVibGljIHJ1bGVTZXROYW1lOiBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgbGVuZ3RoIG9mIHRpbWUgKGluIHNlY29uZHMpIHRvIHdhaXQgZm9yIHBsYXllcnMgdG8gYWNjZXB0IGEgcHJvcG9zZWQgbWF0Y2gsIGlmIGFjY2VwdGFuY2UgaXMgcmVxdWlyZWQuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1nYW1lbGlmdC1tYXRjaG1ha2luZ2NvbmZpZ3VyYXRpb24uaHRtbCNjZm4tZ2FtZWxpZnQtbWF0Y2htYWtpbmdjb25maWd1cmF0aW9uLWFjY2VwdGFuY2V0aW1lb3V0c2Vjb25kc1xuICAgICAqL1xuICAgIHB1YmxpYyBhY2NlcHRhbmNlVGltZW91dFNlY29uZHM6IG51bWJlciB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIFRoZSBudW1iZXIgb2YgcGxheWVyIHNsb3RzIGluIGEgbWF0Y2ggdG8ga2VlcCBvcGVuIGZvciBmdXR1cmUgcGxheWVycy4gRm9yIGV4YW1wbGUsIGlmIHRoZSBjb25maWd1cmF0aW9uJ3MgcnVsZSBzZXQgc3BlY2lmaWVzIGEgbWF0Y2ggZm9yIGEgc2luZ2xlIDEyLXBlcnNvbiB0ZWFtLCBhbmQgdGhlIGFkZGl0aW9uYWwgcGxheWVyIGNvdW50IGlzIHNldCB0byAyLCBvbmx5IDEwIHBsYXllcnMgYXJlIHNlbGVjdGVkIGZvciB0aGUgbWF0Y2guIFRoaXMgcGFyYW1ldGVyIGlzIG5vdCB1c2VkIGlmIGBGbGV4TWF0Y2hNb2RlYCBpcyBzZXQgdG8gYFNUQU5EQUxPTkVgIC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWdhbWVsaWZ0LW1hdGNobWFraW5nY29uZmlndXJhdGlvbi5odG1sI2Nmbi1nYW1lbGlmdC1tYXRjaG1ha2luZ2NvbmZpZ3VyYXRpb24tYWRkaXRpb25hbHBsYXllcmNvdW50XG4gICAgICovXG4gICAgcHVibGljIGFkZGl0aW9uYWxQbGF5ZXJDb3VudDogbnVtYmVyIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogVGhlIG1ldGhvZCB1c2VkIHRvIGJhY2tmaWxsIGdhbWUgc2Vzc2lvbnMgdGhhdCBhcmUgY3JlYXRlZCB3aXRoIHRoaXMgbWF0Y2htYWtpbmcgY29uZmlndXJhdGlvbi4gU3BlY2lmeSBgTUFOVUFMYCB3aGVuIHlvdXIgZ2FtZSBtYW5hZ2VzIGJhY2tmaWxsIHJlcXVlc3RzIG1hbnVhbGx5IG9yIGRvZXMgbm90IHVzZSB0aGUgbWF0Y2ggYmFja2ZpbGwgZmVhdHVyZS4gU3BlY2lmeSBgQVVUT01BVElDYCB0byBoYXZlIEdhbWVMaWZ0IGNyZWF0ZSBhIGBTdGFydE1hdGNoQmFja2ZpbGxgIHJlcXVlc3Qgd2hlbmV2ZXIgYSBnYW1lIHNlc3Npb24gaGFzIG9uZSBvciBtb3JlIG9wZW4gc2xvdHMuIExlYXJuIG1vcmUgYWJvdXQgbWFudWFsIGFuZCBhdXRvbWF0aWMgYmFja2ZpbGwgaW4gW0JhY2tmaWxsIEV4aXN0aW5nIEdhbWVzIHdpdGggRmxleE1hdGNoXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZ2FtZWxpZnQvbGF0ZXN0L2ZsZXhtYXRjaGd1aWRlL21hdGNoLWJhY2tmaWxsLmh0bWwpIC4gQXV0b21hdGljIGJhY2tmaWxsIGlzIG5vdCBhdmFpbGFibGUgd2hlbiBgRmxleE1hdGNoTW9kZWAgaXMgc2V0IHRvIGBTVEFOREFMT05FYCAuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1nYW1lbGlmdC1tYXRjaG1ha2luZ2NvbmZpZ3VyYXRpb24uaHRtbCNjZm4tZ2FtZWxpZnQtbWF0Y2htYWtpbmdjb25maWd1cmF0aW9uLWJhY2tmaWxsbW9kZVxuICAgICAqL1xuICAgIHB1YmxpYyBiYWNrZmlsbE1vZGU6IHN0cmluZyB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIEluZm9ybWF0aW9uIHRvIGFkZCB0byBhbGwgZXZlbnRzIHJlbGF0ZWQgdG8gdGhlIG1hdGNobWFraW5nIGNvbmZpZ3VyYXRpb24uXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1nYW1lbGlmdC1tYXRjaG1ha2luZ2NvbmZpZ3VyYXRpb24uaHRtbCNjZm4tZ2FtZWxpZnQtbWF0Y2htYWtpbmdjb25maWd1cmF0aW9uLWN1c3RvbWV2ZW50ZGF0YVxuICAgICAqL1xuICAgIHB1YmxpYyBjdXN0b21FdmVudERhdGE6IHN0cmluZyB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIEEgZGVzY3JpcHRpdmUgbGFiZWwgdGhhdCBpcyBhc3NvY2lhdGVkIHdpdGggbWF0Y2htYWtpbmcgY29uZmlndXJhdGlvbi5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWdhbWVsaWZ0LW1hdGNobWFraW5nY29uZmlndXJhdGlvbi5odG1sI2Nmbi1nYW1lbGlmdC1tYXRjaG1ha2luZ2NvbmZpZ3VyYXRpb24tZGVzY3JpcHRpb25cbiAgICAgKi9cbiAgICBwdWJsaWMgZGVzY3JpcHRpb246IHN0cmluZyB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIEluZGljYXRlcyB3aGV0aGVyIHRoaXMgbWF0Y2htYWtpbmcgY29uZmlndXJhdGlvbiBpcyBiZWluZyB1c2VkIHdpdGggR2FtZUxpZnQgaG9zdGluZyBvciBhcyBhIHN0YW5kYWxvbmUgbWF0Y2htYWtpbmcgc29sdXRpb24uXG4gICAgICpcbiAgICAgKiAtICpTVEFOREFMT05FKiAtIEZsZXhNYXRjaCBmb3JtcyBtYXRjaGVzIGFuZCByZXR1cm5zIG1hdGNoIGluZm9ybWF0aW9uLCBpbmNsdWRpbmcgcGxheWVycyBhbmQgdGVhbSBhc3NpZ25tZW50cywgaW4gYSBbTWF0Y2htYWtpbmdTdWNjZWVkZWRdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9nYW1lbGlmdC9sYXRlc3QvZmxleG1hdGNoZ3VpZGUvbWF0Y2gtZXZlbnRzLmh0bWwjbWF0Y2gtZXZlbnRzLW1hdGNobWFraW5nc3VjY2VlZGVkKSBldmVudC5cbiAgICAgKiAtICpXSVRIX1FVRVVFKiAtIEZsZXhNYXRjaCBmb3JtcyBtYXRjaGVzIGFuZCB1c2VzIHRoZSBzcGVjaWZpZWQgR2FtZUxpZnQgcXVldWUgdG8gc3RhcnQgYSBnYW1lIHNlc3Npb24gZm9yIHRoZSBtYXRjaC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWdhbWVsaWZ0LW1hdGNobWFraW5nY29uZmlndXJhdGlvbi5odG1sI2Nmbi1nYW1lbGlmdC1tYXRjaG1ha2luZ2NvbmZpZ3VyYXRpb24tZmxleG1hdGNobW9kZVxuICAgICAqL1xuICAgIHB1YmxpYyBmbGV4TWF0Y2hNb2RlOiBzdHJpbmcgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBBIHNldCBvZiBjdXN0b20gcHJvcGVydGllcyBmb3IgYSBnYW1lIHNlc3Npb24sIGZvcm1hdHRlZCBhcyBrZXktdmFsdWUgcGFpcnMuIFRoZXNlIHByb3BlcnRpZXMgYXJlIHBhc3NlZCB0byBhIGdhbWUgc2VydmVyIHByb2Nlc3Mgd2l0aCBhIHJlcXVlc3QgdG8gc3RhcnQgYSBuZXcgZ2FtZSBzZXNzaW9uLiBTZWUgW1N0YXJ0IGEgR2FtZSBTZXNzaW9uXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZ2FtZWxpZnQvbGF0ZXN0L2RldmVsb3Blcmd1aWRlL2dhbWVsaWZ0LXNkay1zZXJ2ZXItYXBpLmh0bWwjZ2FtZWxpZnQtc2RrLXNlcnZlci1zdGFydHNlc3Npb24pIC4gVGhpcyBwYXJhbWV0ZXIgaXMgbm90IHVzZWQgaWYgYEZsZXhNYXRjaE1vZGVgIGlzIHNldCB0byBgU1RBTkRBTE9ORWAgLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZ2FtZWxpZnQtbWF0Y2htYWtpbmdjb25maWd1cmF0aW9uLmh0bWwjY2ZuLWdhbWVsaWZ0LW1hdGNobWFraW5nY29uZmlndXJhdGlvbi1nYW1lcHJvcGVydGllc1xuICAgICAqL1xuICAgIHB1YmxpYyBnYW1lUHJvcGVydGllczogQXJyYXk8Q2ZuTWF0Y2htYWtpbmdDb25maWd1cmF0aW9uLkdhbWVQcm9wZXJ0eVByb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlPiB8IGNkay5JUmVzb2x2YWJsZSB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIEEgc2V0IG9mIGN1c3RvbSBnYW1lIHNlc3Npb24gcHJvcGVydGllcywgZm9ybWF0dGVkIGFzIGEgc2luZ2xlIHN0cmluZyB2YWx1ZS4gVGhpcyBkYXRhIGlzIHBhc3NlZCB0byBhIGdhbWUgc2VydmVyIHByb2Nlc3Mgd2l0aCBhIHJlcXVlc3QgdG8gc3RhcnQgYSBuZXcgZ2FtZSBzZXNzaW9uLiBTZWUgW1N0YXJ0IGEgR2FtZSBTZXNzaW9uXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZ2FtZWxpZnQvbGF0ZXN0L2RldmVsb3Blcmd1aWRlL2dhbWVsaWZ0LXNkay1zZXJ2ZXItYXBpLmh0bWwjZ2FtZWxpZnQtc2RrLXNlcnZlci1zdGFydHNlc3Npb24pIC4gVGhpcyBwYXJhbWV0ZXIgaXMgbm90IHVzZWQgaWYgYEZsZXhNYXRjaE1vZGVgIGlzIHNldCB0byBgU1RBTkRBTE9ORWAgLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZ2FtZWxpZnQtbWF0Y2htYWtpbmdjb25maWd1cmF0aW9uLmh0bWwjY2ZuLWdhbWVsaWZ0LW1hdGNobWFraW5nY29uZmlndXJhdGlvbi1nYW1lc2Vzc2lvbmRhdGFcbiAgICAgKi9cbiAgICBwdWJsaWMgZ2FtZVNlc3Npb25EYXRhOiBzdHJpbmcgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgQW1hem9uIFJlc291cmNlIE5hbWUgKCBbQVJOXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQW1hem9uUzMvbGF0ZXN0L2Rldi9zMy1hcm4tZm9ybWF0Lmh0bWwpICkgdGhhdCBpcyBhc3NpZ25lZCB0byBhIEdhbWVMaWZ0IGdhbWUgc2Vzc2lvbiBxdWV1ZSByZXNvdXJjZSBhbmQgdW5pcXVlbHkgaWRlbnRpZmllcyBpdC4gQVJOcyBhcmUgdW5pcXVlIGFjcm9zcyBhbGwgUmVnaW9ucy4gRm9ybWF0IGlzIGBhcm46YXdzOmdhbWVsaWZ0OjxyZWdpb24+OjpnYW1lc2Vzc2lvbnF1ZXVlLzxxdWV1ZSBuYW1lPmAgLiBRdWV1ZXMgY2FuIGJlIGxvY2F0ZWQgaW4gYW55IFJlZ2lvbi4gUXVldWVzIGFyZSB1c2VkIHRvIHN0YXJ0IG5ldyBHYW1lTGlmdC1ob3N0ZWQgZ2FtZSBzZXNzaW9ucyBmb3IgbWF0Y2hlcyB0aGF0IGFyZSBjcmVhdGVkIHdpdGggdGhpcyBtYXRjaG1ha2luZyBjb25maWd1cmF0aW9uLiBJZiBgRmxleE1hdGNoTW9kZWAgaXMgc2V0IHRvIGBTVEFOREFMT05FYCAsIGRvIG5vdCBzZXQgdGhpcyBwYXJhbWV0ZXIuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1nYW1lbGlmdC1tYXRjaG1ha2luZ2NvbmZpZ3VyYXRpb24uaHRtbCNjZm4tZ2FtZWxpZnQtbWF0Y2htYWtpbmdjb25maWd1cmF0aW9uLWdhbWVzZXNzaW9ucXVldWVhcm5zXG4gICAgICovXG4gICAgcHVibGljIGdhbWVTZXNzaW9uUXVldWVBcm5zOiBzdHJpbmdbXSB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIEFuIFNOUyB0b3BpYyBBUk4gdGhhdCBpcyBzZXQgdXAgdG8gcmVjZWl2ZSBtYXRjaG1ha2luZyBub3RpZmljYXRpb25zLiBTZWUgW1NldHRpbmcgdXAgbm90aWZpY2F0aW9ucyBmb3IgbWF0Y2htYWtpbmddKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9nYW1lbGlmdC9sYXRlc3QvZmxleG1hdGNoZ3VpZGUvbWF0Y2gtbm90aWZpY2F0aW9uLmh0bWwpIGZvciBtb3JlIGluZm9ybWF0aW9uLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZ2FtZWxpZnQtbWF0Y2htYWtpbmdjb25maWd1cmF0aW9uLmh0bWwjY2ZuLWdhbWVsaWZ0LW1hdGNobWFraW5nY29uZmlndXJhdGlvbi1ub3RpZmljYXRpb250YXJnZXRcbiAgICAgKi9cbiAgICBwdWJsaWMgbm90aWZpY2F0aW9uVGFyZ2V0OiBzdHJpbmcgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBBIGxpc3Qgb2YgbGFiZWxzIHRvIGFzc2lnbiB0byB0aGUgbmV3IG1hdGNobWFraW5nIGNvbmZpZ3VyYXRpb24gcmVzb3VyY2UuIFRhZ3MgYXJlIGRldmVsb3Blci1kZWZpbmVkIGtleS12YWx1ZSBwYWlycy4gVGFnZ2luZyBBV1MgcmVzb3VyY2VzIGFyZSB1c2VmdWwgZm9yIHJlc291cmNlIG1hbmFnZW1lbnQsIGFjY2VzcyBtYW5hZ2VtZW50IGFuZCBjb3N0IGFsbG9jYXRpb24uIEZvciBtb3JlIGluZm9ybWF0aW9uLCBzZWUgW1RhZ2dpbmcgQVdTIFJlc291cmNlc10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2dlbmVyYWwvbGF0ZXN0L2dyL2F3c190YWdnaW5nLmh0bWwpIGluIHRoZSAqQVdTIEdlbmVyYWwgUmVmZXJlbmNlKiAuIE9uY2UgdGhlIHJlc291cmNlIGlzIGNyZWF0ZWQsIHlvdSBjYW4gdXNlIFRhZ1Jlc291cmNlLCBVbnRhZ1Jlc291cmNlLCBhbmQgTGlzdFRhZ3NGb3JSZXNvdXJjZSB0byBhZGQsIHJlbW92ZSwgYW5kIHZpZXcgdGFncy4gVGhlIG1heGltdW0gdGFnIGxpbWl0IG1heSBiZSBsb3dlciB0aGFuIHN0YXRlZC4gU2VlIHRoZSBBV1MgR2VuZXJhbCBSZWZlcmVuY2UgZm9yIGFjdHVhbCB0YWdnaW5nIGxpbWl0cy5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWdhbWVsaWZ0LW1hdGNobWFraW5nY29uZmlndXJhdGlvbi5odG1sI2Nmbi1nYW1lbGlmdC1tYXRjaG1ha2luZ2NvbmZpZ3VyYXRpb24tdGFnc1xuICAgICAqL1xuICAgIHB1YmxpYyByZWFkb25seSB0YWdzOiBjZGsuVGFnTWFuYWdlcjtcblxuICAgIC8qKlxuICAgICAqIENyZWF0ZSBhIG5ldyBgQVdTOjpHYW1lTGlmdDo6TWF0Y2htYWtpbmdDb25maWd1cmF0aW9uYC5cbiAgICAgKlxuICAgICAqIEBwYXJhbSBzY29wZSAtIHNjb3BlIGluIHdoaWNoIHRoaXMgcmVzb3VyY2UgaXMgZGVmaW5lZFxuICAgICAqIEBwYXJhbSBpZCAgICAtIHNjb3BlZCBpZCBvZiB0aGUgcmVzb3VyY2VcbiAgICAgKiBAcGFyYW0gcHJvcHMgLSByZXNvdXJjZSBwcm9wZXJ0aWVzXG4gICAgICovXG4gICAgY29uc3RydWN0b3Ioc2NvcGU6IGNkay5Db25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBDZm5NYXRjaG1ha2luZ0NvbmZpZ3VyYXRpb25Qcm9wcykge1xuICAgICAgICBzdXBlcihzY29wZSwgaWQsIHsgdHlwZTogQ2ZuTWF0Y2htYWtpbmdDb25maWd1cmF0aW9uLkNGTl9SRVNPVVJDRV9UWVBFX05BTUUsIHByb3BlcnRpZXM6IHByb3BzIH0pO1xuICAgICAgICBjZGsucmVxdWlyZVByb3BlcnR5KHByb3BzLCAnYWNjZXB0YW5jZVJlcXVpcmVkJywgdGhpcyk7XG4gICAgICAgIGNkay5yZXF1aXJlUHJvcGVydHkocHJvcHMsICduYW1lJywgdGhpcyk7XG4gICAgICAgIGNkay5yZXF1aXJlUHJvcGVydHkocHJvcHMsICdyZXF1ZXN0VGltZW91dFNlY29uZHMnLCB0aGlzKTtcbiAgICAgICAgY2RrLnJlcXVpcmVQcm9wZXJ0eShwcm9wcywgJ3J1bGVTZXROYW1lJywgdGhpcyk7XG4gICAgICAgIHRoaXMuYXR0ckFybiA9IGNkay5Ub2tlbi5hc1N0cmluZyh0aGlzLmdldEF0dCgnQXJuJykpO1xuICAgICAgICB0aGlzLmF0dHJOYW1lID0gY2RrLlRva2VuLmFzU3RyaW5nKHRoaXMuZ2V0QXR0KCdOYW1lJykpO1xuXG4gICAgICAgIHRoaXMuYWNjZXB0YW5jZVJlcXVpcmVkID0gcHJvcHMuYWNjZXB0YW5jZVJlcXVpcmVkO1xuICAgICAgICB0aGlzLm5hbWUgPSBwcm9wcy5uYW1lO1xuICAgICAgICB0aGlzLnJlcXVlc3RUaW1lb3V0U2Vjb25kcyA9IHByb3BzLnJlcXVlc3RUaW1lb3V0U2Vjb25kcztcbiAgICAgICAgdGhpcy5ydWxlU2V0TmFtZSA9IHByb3BzLnJ1bGVTZXROYW1lO1xuICAgICAgICB0aGlzLmFjY2VwdGFuY2VUaW1lb3V0U2Vjb25kcyA9IHByb3BzLmFjY2VwdGFuY2VUaW1lb3V0U2Vjb25kcztcbiAgICAgICAgdGhpcy5hZGRpdGlvbmFsUGxheWVyQ291bnQgPSBwcm9wcy5hZGRpdGlvbmFsUGxheWVyQ291bnQ7XG4gICAgICAgIHRoaXMuYmFja2ZpbGxNb2RlID0gcHJvcHMuYmFja2ZpbGxNb2RlO1xuICAgICAgICB0aGlzLmN1c3RvbUV2ZW50RGF0YSA9IHByb3BzLmN1c3RvbUV2ZW50RGF0YTtcbiAgICAgICAgdGhpcy5kZXNjcmlwdGlvbiA9IHByb3BzLmRlc2NyaXB0aW9uO1xuICAgICAgICB0aGlzLmZsZXhNYXRjaE1vZGUgPSBwcm9wcy5mbGV4TWF0Y2hNb2RlO1xuICAgICAgICB0aGlzLmdhbWVQcm9wZXJ0aWVzID0gcHJvcHMuZ2FtZVByb3BlcnRpZXM7XG4gICAgICAgIHRoaXMuZ2FtZVNlc3Npb25EYXRhID0gcHJvcHMuZ2FtZVNlc3Npb25EYXRhO1xuICAgICAgICB0aGlzLmdhbWVTZXNzaW9uUXVldWVBcm5zID0gcHJvcHMuZ2FtZVNlc3Npb25RdWV1ZUFybnM7XG4gICAgICAgIHRoaXMubm90aWZpY2F0aW9uVGFyZ2V0ID0gcHJvcHMubm90aWZpY2F0aW9uVGFyZ2V0O1xuICAgICAgICB0aGlzLnRhZ3MgPSBuZXcgY2RrLlRhZ01hbmFnZXIoY2RrLlRhZ1R5cGUuU1RBTkRBUkQsIFwiQVdTOjpHYW1lTGlmdDo6TWF0Y2htYWtpbmdDb25maWd1cmF0aW9uXCIsIHByb3BzLnRhZ3MsIHsgdGFnUHJvcGVydHlOYW1lOiAndGFncycgfSk7XG4gICAgfVxuXG4gICAgLyoqXG4gICAgICogRXhhbWluZXMgdGhlIENsb3VkRm9ybWF0aW9uIHJlc291cmNlIGFuZCBkaXNjbG9zZXMgYXR0cmlidXRlcy5cbiAgICAgKlxuICAgICAqIEBwYXJhbSBpbnNwZWN0b3IgLSB0cmVlIGluc3BlY3RvciB0byBjb2xsZWN0IGFuZCBwcm9jZXNzIGF0dHJpYnV0ZXNcbiAgICAgKlxuICAgICAqL1xuICAgIHB1YmxpYyBpbnNwZWN0KGluc3BlY3RvcjogY2RrLlRyZWVJbnNwZWN0b3IpIHtcbiAgICAgICAgaW5zcGVjdG9yLmFkZEF0dHJpYnV0ZShcImF3czpjZGs6Y2xvdWRmb3JtYXRpb246dHlwZVwiLCBDZm5NYXRjaG1ha2luZ0NvbmZpZ3VyYXRpb24uQ0ZOX1JFU09VUkNFX1RZUEVfTkFNRSk7XG4gICAgICAgIGluc3BlY3Rvci5hZGRBdHRyaWJ1dGUoXCJhd3M6Y2RrOmNsb3VkZm9ybWF0aW9uOnByb3BzXCIsIHRoaXMuY2ZuUHJvcGVydGllcyk7XG4gICAgfVxuXG4gICAgcHJvdGVjdGVkIGdldCBjZm5Qcm9wZXJ0aWVzKCk6IHsgW2tleTogc3RyaW5nXTogYW55IH0gIHtcbiAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICAgIGFjY2VwdGFuY2VSZXF1aXJlZDogdGhpcy5hY2NlcHRhbmNlUmVxdWlyZWQsXG4gICAgICAgICAgICBuYW1lOiB0aGlzLm5hbWUsXG4gICAgICAgICAgICByZXF1ZXN0VGltZW91dFNlY29uZHM6IHRoaXMucmVxdWVzdFRpbWVvdXRTZWNvbmRzLFxuICAgICAgICAgICAgcnVsZVNldE5hbWU6IHRoaXMucnVsZVNldE5hbWUsXG4gICAgICAgICAgICBhY2NlcHRhbmNlVGltZW91dFNlY29uZHM6IHRoaXMuYWNjZXB0YW5jZVRpbWVvdXRTZWNvbmRzLFxuICAgICAgICAgICAgYWRkaXRpb25hbFBsYXllckNvdW50OiB0aGlzLmFkZGl0aW9uYWxQbGF5ZXJDb3VudCxcbiAgICAgICAgICAgIGJhY2tmaWxsTW9kZTogdGhpcy5iYWNrZmlsbE1vZGUsXG4gICAgICAgICAgICBjdXN0b21FdmVudERhdGE6IHRoaXMuY3VzdG9tRXZlbnREYXRhLFxuICAgICAgICAgICAgZGVzY3JpcHRpb246IHRoaXMuZGVzY3JpcHRpb24sXG4gICAgICAgICAgICBmbGV4TWF0Y2hNb2RlOiB0aGlzLmZsZXhNYXRjaE1vZGUsXG4gICAgICAgICAgICBnYW1lUHJvcGVydGllczogdGhpcy5nYW1lUHJvcGVydGllcyxcbiAgICAgICAgICAgIGdhbWVTZXNzaW9uRGF0YTogdGhpcy5nYW1lU2Vzc2lvbkRhdGEsXG4gICAgICAgICAgICBnYW1lU2Vzc2lvblF1ZXVlQXJuczogdGhpcy5nYW1lU2Vzc2lvblF1ZXVlQXJucyxcbiAgICAgICAgICAgIG5vdGlmaWNhdGlvblRhcmdldDogdGhpcy5ub3RpZmljYXRpb25UYXJnZXQsXG4gICAgICAgICAgICB0YWdzOiB0aGlzLnRhZ3MucmVuZGVyVGFncygpLFxuICAgICAgICB9O1xuICAgIH1cblxuICAgIHByb3RlY3RlZCByZW5kZXJQcm9wZXJ0aWVzKHByb3BzOiB7W2tleTogc3RyaW5nXTogYW55fSk6IHsgW2tleTogc3RyaW5nXTogYW55IH0gIHtcbiAgICAgICAgcmV0dXJuIGNmbk1hdGNobWFraW5nQ29uZmlndXJhdGlvblByb3BzVG9DbG91ZEZvcm1hdGlvbihwcm9wcyk7XG4gICAgfVxufVxuXG5leHBvcnQgbmFtZXNwYWNlIENmbk1hdGNobWFraW5nQ29uZmlndXJhdGlvbiB7XG4gICAgLyoqXG4gICAgICogU2V0IG9mIGtleS12YWx1ZSBwYWlycyB0aGF0IGNvbnRhaW4gaW5mb3JtYXRpb24gYWJvdXQgYSBnYW1lIHNlc3Npb24uIFdoZW4gaW5jbHVkZWQgaW4gYSBnYW1lIHNlc3Npb24gcmVxdWVzdCwgdGhlc2UgcHJvcGVydGllcyBjb21tdW5pY2F0ZSBkZXRhaWxzIHRvIGJlIHVzZWQgd2hlbiBzZXR0aW5nIHVwIHRoZSBuZXcgZ2FtZSBzZXNzaW9uLiBGb3IgZXhhbXBsZSwgYSBnYW1lIHByb3BlcnR5IG1pZ2h0IHNwZWNpZnkgYSBnYW1lIG1vZGUsIGxldmVsLCBvciBtYXAuIEdhbWUgcHJvcGVydGllcyBhcmUgcGFzc2VkIHRvIHRoZSBnYW1lIHNlcnZlciBwcm9jZXNzIHdoZW4gaW5pdGlhdGluZyBhIG5ldyBnYW1lIHNlc3Npb24uIEZvciBtb3JlIGluZm9ybWF0aW9uLCBzZWUgdGhlIFtHYW1lTGlmdCBEZXZlbG9wZXIgR3VpZGVdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9nYW1lbGlmdC9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUvZ2FtZWxpZnQtc2RrLWNsaWVudC1hcGkuaHRtbCNnYW1lbGlmdC1zZGstY2xpZW50LWFwaS1jcmVhdGUpIC5cbiAgICAgKlxuICAgICAqIEBzdHJ1Y3RcbiAgICAgKiBAc3RhYmlsaXR5IGV4dGVybmFsXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWdhbWVsaWZ0LW1hdGNobWFraW5nY29uZmlndXJhdGlvbi1nYW1lcHJvcGVydHkuaHRtbFxuICAgICAqL1xuICAgIGV4cG9ydCBpbnRlcmZhY2UgR2FtZVByb3BlcnR5UHJvcGVydHkge1xuICAgICAgICAvKipcbiAgICAgICAgICogVGhlIGdhbWUgcHJvcGVydHkgaWRlbnRpZmllci5cbiAgICAgICAgICpcbiAgICAgICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1nYW1lbGlmdC1tYXRjaG1ha2luZ2NvbmZpZ3VyYXRpb24tZ2FtZXByb3BlcnR5Lmh0bWwjY2ZuLWdhbWVsaWZ0LW1hdGNobWFraW5nY29uZmlndXJhdGlvbi1nYW1lcHJvcGVydHkta2V5XG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBrZXk6IHN0cmluZztcbiAgICAgICAgLyoqXG4gICAgICAgICAqIFRoZSBnYW1lIHByb3BlcnR5IHZhbHVlLlxuICAgICAgICAgKlxuICAgICAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWdhbWVsaWZ0LW1hdGNobWFraW5nY29uZmlndXJhdGlvbi1nYW1lcHJvcGVydHkuaHRtbCNjZm4tZ2FtZWxpZnQtbWF0Y2htYWtpbmdjb25maWd1cmF0aW9uLWdhbWVwcm9wZXJ0eS12YWx1ZVxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgdmFsdWU6IHN0cmluZztcbiAgICB9XG59XG5cbi8qKlxuICogRGV0ZXJtaW5lIHdoZXRoZXIgdGhlIGdpdmVuIHByb3BlcnRpZXMgbWF0Y2ggdGhvc2Ugb2YgYSBgR2FtZVByb3BlcnR5UHJvcGVydHlgXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYEdhbWVQcm9wZXJ0eVByb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSByZXN1bHQgb2YgdGhlIHZhbGlkYXRpb24uXG4gKi9cbmZ1bmN0aW9uIENmbk1hdGNobWFraW5nQ29uZmlndXJhdGlvbl9HYW1lUHJvcGVydHlQcm9wZXJ0eVZhbGlkYXRvcihwcm9wZXJ0aWVzOiBhbnkpOiBjZGsuVmFsaWRhdGlvblJlc3VsdCB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gY2RrLlZBTElEQVRJT05fU1VDQ0VTUzsgfVxuICAgIGNvbnN0IGVycm9ycyA9IG5ldyBjZGsuVmFsaWRhdGlvblJlc3VsdHMoKTtcbiAgICBpZiAodHlwZW9mIHByb3BlcnRpZXMgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIGVycm9ycy5jb2xsZWN0KG5ldyBjZGsuVmFsaWRhdGlvblJlc3VsdCgnRXhwZWN0ZWQgYW4gb2JqZWN0LCBidXQgcmVjZWl2ZWQ6ICcgKyBKU09OLnN0cmluZ2lmeShwcm9wZXJ0aWVzKSkpO1xuICAgIH1cbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2tleScsIGNkay5yZXF1aXJlZFZhbGlkYXRvcikocHJvcGVydGllcy5rZXkpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2tleScsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5rZXkpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3ZhbHVlJywgY2RrLnJlcXVpcmVkVmFsaWRhdG9yKShwcm9wZXJ0aWVzLnZhbHVlKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCd2YWx1ZScsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy52YWx1ZSkpO1xuICAgIHJldHVybiBlcnJvcnMud3JhcCgnc3VwcGxpZWQgcHJvcGVydGllcyBub3QgY29ycmVjdCBmb3IgXCJHYW1lUHJvcGVydHlQcm9wZXJ0eVwiJyk7XG59XG5cbi8qKlxuICogUmVuZGVycyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6R2FtZUxpZnQ6Ok1hdGNobWFraW5nQ29uZmlndXJhdGlvbi5HYW1lUHJvcGVydHlgIHJlc291cmNlXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYEdhbWVQcm9wZXJ0eVByb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpHYW1lTGlmdDo6TWF0Y2htYWtpbmdDb25maWd1cmF0aW9uLkdhbWVQcm9wZXJ0eWAgcmVzb3VyY2UuXG4gKi9cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBjZm5NYXRjaG1ha2luZ0NvbmZpZ3VyYXRpb25HYW1lUHJvcGVydHlQcm9wZXJ0eVRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogYW55IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBwcm9wZXJ0aWVzOyB9XG4gICAgQ2ZuTWF0Y2htYWtpbmdDb25maWd1cmF0aW9uX0dhbWVQcm9wZXJ0eVByb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXMpLmFzc2VydFN1Y2Nlc3MoKTtcbiAgICByZXR1cm4ge1xuICAgICAgICBLZXk6IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMua2V5KSxcbiAgICAgICAgVmFsdWU6IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMudmFsdWUpLFxuICAgIH07XG59XG5cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBDZm5NYXRjaG1ha2luZ0NvbmZpZ3VyYXRpb25HYW1lUHJvcGVydHlQcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0PENmbk1hdGNobWFraW5nQ29uZmlndXJhdGlvbi5HYW1lUHJvcGVydHlQcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZT4ge1xuICAgIGlmIChjZGsuaXNSZXNvbHZhYmxlT2JqZWN0KHByb3BlcnRpZXMpKSB7XG4gICAgICAgIHJldHVybiBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdChwcm9wZXJ0aWVzKTtcbiAgICB9XG4gICAgcHJvcGVydGllcyA9IHByb3BlcnRpZXMgPT0gbnVsbCA/IHt9IDogcHJvcGVydGllcztcbiAgICBpZiAodHlwZW9mIHByb3BlcnRpZXMgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIHJldHVybiBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdChwcm9wZXJ0aWVzKTtcbiAgICB9XG4gICAgY29uc3QgcmV0ID0gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25Qcm9wZXJ0eU9iamVjdDxDZm5NYXRjaG1ha2luZ0NvbmZpZ3VyYXRpb24uR2FtZVByb3BlcnR5UHJvcGVydHk+KCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdrZXknLCAnS2V5JywgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5LZXkpKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ3ZhbHVlJywgJ1ZhbHVlJywgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5WYWx1ZSkpO1xuICAgIHJldC5hZGRVbnJlY29nbml6ZWRQcm9wZXJ0aWVzQXNFeHRyYShwcm9wZXJ0aWVzKTtcbiAgICByZXR1cm4gcmV0O1xufVxuXG4vKipcbiAqIFByb3BlcnRpZXMgZm9yIGRlZmluaW5nIGEgYENmbk1hdGNobWFraW5nUnVsZVNldGBcbiAqXG4gKiBAc3RydWN0XG4gKiBAc3RhYmlsaXR5IGV4dGVybmFsXG4gKlxuICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZ2FtZWxpZnQtbWF0Y2htYWtpbmdydWxlc2V0Lmh0bWxcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBDZm5NYXRjaG1ha2luZ1J1bGVTZXRQcm9wcyB7XG5cbiAgICAvKipcbiAgICAgKiBBIHVuaXF1ZSBpZGVudGlmaWVyIGZvciB0aGUgbWF0Y2htYWtpbmcgcnVsZSBzZXQuIEEgbWF0Y2htYWtpbmcgY29uZmlndXJhdGlvbiBpZGVudGlmaWVzIHRoZSBydWxlIHNldCBpdCB1c2VzIGJ5IHRoaXMgbmFtZSB2YWx1ZS4gTm90ZSB0aGF0IHRoZSBydWxlIHNldCBuYW1lIGlzIGRpZmZlcmVudCBmcm9tIHRoZSBvcHRpb25hbCBgbmFtZWAgZmllbGQgaW4gdGhlIHJ1bGUgc2V0IGJvZHkuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1nYW1lbGlmdC1tYXRjaG1ha2luZ3J1bGVzZXQuaHRtbCNjZm4tZ2FtZWxpZnQtbWF0Y2htYWtpbmdydWxlc2V0LW5hbWVcbiAgICAgKi9cbiAgICByZWFkb25seSBuYW1lOiBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBBIGNvbGxlY3Rpb24gb2YgbWF0Y2htYWtpbmcgcnVsZXMsIGZvcm1hdHRlZCBhcyBhIEpTT04gc3RyaW5nLiBDb21tZW50cyBhcmUgbm90IGFsbG93ZWQgaW4gSlNPTiwgYnV0IG1vc3QgZWxlbWVudHMgc3VwcG9ydCBhIGRlc2NyaXB0aW9uIGZpZWxkLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZ2FtZWxpZnQtbWF0Y2htYWtpbmdydWxlc2V0Lmh0bWwjY2ZuLWdhbWVsaWZ0LW1hdGNobWFraW5ncnVsZXNldC1ydWxlc2V0Ym9keVxuICAgICAqL1xuICAgIHJlYWRvbmx5IHJ1bGVTZXRCb2R5OiBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBBIGxpc3Qgb2YgbGFiZWxzIHRvIGFzc2lnbiB0byB0aGUgbmV3IG1hdGNobWFraW5nIHJ1bGUgc2V0IHJlc291cmNlLiBUYWdzIGFyZSBkZXZlbG9wZXItZGVmaW5lZCBrZXktdmFsdWUgcGFpcnMuIFRhZ2dpbmcgQVdTIHJlc291cmNlcyBhcmUgdXNlZnVsIGZvciByZXNvdXJjZSBtYW5hZ2VtZW50LCBhY2Nlc3MgbWFuYWdlbWVudCBhbmQgY29zdCBhbGxvY2F0aW9uLiBGb3IgbW9yZSBpbmZvcm1hdGlvbiwgc2VlIFtUYWdnaW5nIEFXUyBSZXNvdXJjZXNdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9nZW5lcmFsL2xhdGVzdC9nci9hd3NfdGFnZ2luZy5odG1sKSBpbiB0aGUgKkFXUyBHZW5lcmFsIFJlZmVyZW5jZSogLiBPbmNlIHRoZSByZXNvdXJjZSBpcyBjcmVhdGVkLCB5b3UgY2FuIHVzZSBUYWdSZXNvdXJjZSwgVW50YWdSZXNvdXJjZSwgYW5kIExpc3RUYWdzRm9yUmVzb3VyY2UgdG8gYWRkLCByZW1vdmUsIGFuZCB2aWV3IHRhZ3MuIFRoZSBtYXhpbXVtIHRhZyBsaW1pdCBtYXkgYmUgbG93ZXIgdGhhbiBzdGF0ZWQuIFNlZSB0aGUgQVdTIEdlbmVyYWwgUmVmZXJlbmNlIGZvciBhY3R1YWwgdGFnZ2luZyBsaW1pdHMuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1nYW1lbGlmdC1tYXRjaG1ha2luZ3J1bGVzZXQuaHRtbCNjZm4tZ2FtZWxpZnQtbWF0Y2htYWtpbmdydWxlc2V0LXRhZ3NcbiAgICAgKi9cbiAgICByZWFkb25seSB0YWdzPzogY2RrLkNmblRhZ1tdO1xufVxuXG4vKipcbiAqIERldGVybWluZSB3aGV0aGVyIHRoZSBnaXZlbiBwcm9wZXJ0aWVzIG1hdGNoIHRob3NlIG9mIGEgYENmbk1hdGNobWFraW5nUnVsZVNldFByb3BzYFxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBDZm5NYXRjaG1ha2luZ1J1bGVTZXRQcm9wc2BcbiAqXG4gKiBAcmV0dXJucyB0aGUgcmVzdWx0IG9mIHRoZSB2YWxpZGF0aW9uLlxuICovXG5mdW5jdGlvbiBDZm5NYXRjaG1ha2luZ1J1bGVTZXRQcm9wc1ZhbGlkYXRvcihwcm9wZXJ0aWVzOiBhbnkpOiBjZGsuVmFsaWRhdGlvblJlc3VsdCB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gY2RrLlZBTElEQVRJT05fU1VDQ0VTUzsgfVxuICAgIGNvbnN0IGVycm9ycyA9IG5ldyBjZGsuVmFsaWRhdGlvblJlc3VsdHMoKTtcbiAgICBpZiAodHlwZW9mIHByb3BlcnRpZXMgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIGVycm9ycy5jb2xsZWN0KG5ldyBjZGsuVmFsaWRhdGlvblJlc3VsdCgnRXhwZWN0ZWQgYW4gb2JqZWN0LCBidXQgcmVjZWl2ZWQ6ICcgKyBKU09OLnN0cmluZ2lmeShwcm9wZXJ0aWVzKSkpO1xuICAgIH1cbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ25hbWUnLCBjZGsucmVxdWlyZWRWYWxpZGF0b3IpKHByb3BlcnRpZXMubmFtZSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignbmFtZScsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5uYW1lKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdydWxlU2V0Qm9keScsIGNkay5yZXF1aXJlZFZhbGlkYXRvcikocHJvcGVydGllcy5ydWxlU2V0Qm9keSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigncnVsZVNldEJvZHknLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMucnVsZVNldEJvZHkpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3RhZ3MnLCBjZGsubGlzdFZhbGlkYXRvcihjZGsudmFsaWRhdGVDZm5UYWcpKShwcm9wZXJ0aWVzLnRhZ3MpKTtcbiAgICByZXR1cm4gZXJyb3JzLndyYXAoJ3N1cHBsaWVkIHByb3BlcnRpZXMgbm90IGNvcnJlY3QgZm9yIFwiQ2ZuTWF0Y2htYWtpbmdSdWxlU2V0UHJvcHNcIicpO1xufVxuXG4vKipcbiAqIFJlbmRlcnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OkdhbWVMaWZ0OjpNYXRjaG1ha2luZ1J1bGVTZXRgIHJlc291cmNlXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYENmbk1hdGNobWFraW5nUnVsZVNldFByb3BzYFxuICpcbiAqIEByZXR1cm5zIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpHYW1lTGlmdDo6TWF0Y2htYWtpbmdSdWxlU2V0YCByZXNvdXJjZS5cbiAqL1xuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIGNmbk1hdGNobWFraW5nUnVsZVNldFByb3BzVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBhbnkge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIHByb3BlcnRpZXM7IH1cbiAgICBDZm5NYXRjaG1ha2luZ1J1bGVTZXRQcm9wc1ZhbGlkYXRvcihwcm9wZXJ0aWVzKS5hc3NlcnRTdWNjZXNzKCk7XG4gICAgcmV0dXJuIHtcbiAgICAgICAgTmFtZTogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5uYW1lKSxcbiAgICAgICAgUnVsZVNldEJvZHk6IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMucnVsZVNldEJvZHkpLFxuICAgICAgICBUYWdzOiBjZGsubGlzdE1hcHBlcihjZGsuY2ZuVGFnVG9DbG91ZEZvcm1hdGlvbikocHJvcGVydGllcy50YWdzKSxcbiAgICB9O1xufVxuXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gQ2ZuTWF0Y2htYWtpbmdSdWxlU2V0UHJvcHNGcm9tQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdDxDZm5NYXRjaG1ha2luZ1J1bGVTZXRQcm9wcz4ge1xuICAgIHByb3BlcnRpZXMgPSBwcm9wZXJ0aWVzID09IG51bGwgPyB7fSA6IHByb3BlcnRpZXM7XG4gICAgaWYgKHR5cGVvZiBwcm9wZXJ0aWVzICE9PSAnb2JqZWN0Jykge1xuICAgICAgICByZXR1cm4gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQocHJvcGVydGllcyk7XG4gICAgfVxuICAgIGNvbnN0IHJldCA9IG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUHJvcGVydHlPYmplY3Q8Q2ZuTWF0Y2htYWtpbmdSdWxlU2V0UHJvcHM+KCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCduYW1lJywgJ05hbWUnLCBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLk5hbWUpKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ3J1bGVTZXRCb2R5JywgJ1J1bGVTZXRCb2R5JywgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5SdWxlU2V0Qm9keSkpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgndGFncycsICdUYWdzJywgcHJvcGVydGllcy5UYWdzICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldEFycmF5KGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0Q2ZuVGFnKShwcm9wZXJ0aWVzLlRhZ3MpIDogdW5kZWZpbmVkIGFzIGFueSk7XG4gICAgcmV0LmFkZFVucmVjb2duaXplZFByb3BlcnRpZXNBc0V4dHJhKHByb3BlcnRpZXMpO1xuICAgIHJldHVybiByZXQ7XG59XG5cbi8qKlxuICogQSBDbG91ZEZvcm1hdGlvbiBgQVdTOjpHYW1lTGlmdDo6TWF0Y2htYWtpbmdSdWxlU2V0YFxuICpcbiAqIENyZWF0ZXMgYSBuZXcgcnVsZSBzZXQgZm9yIEZsZXhNYXRjaCBtYXRjaG1ha2luZy4gQSBydWxlIHNldCBkZXNjcmliZXMgdGhlIHR5cGUgb2YgbWF0Y2ggdG8gY3JlYXRlLCBzdWNoIGFzIHRoZSBudW1iZXIgYW5kIHNpemUgb2YgdGVhbXMuIEl0IGFsc28gc2V0cyB0aGUgcGFyYW1ldGVycyBmb3IgYWNjZXB0YWJsZSBwbGF5ZXIgbWF0Y2hlcywgc3VjaCBhcyBtaW5pbXVtIHNraWxsIGxldmVsIG9yIGNoYXJhY3RlciB0eXBlLlxuICpcbiAqIFRvIGNyZWF0ZSBhIG1hdGNobWFraW5nIHJ1bGUgc2V0LCBwcm92aWRlIHVuaXF1ZSBydWxlIHNldCBuYW1lIGFuZCB0aGUgcnVsZSBzZXQgYm9keSBpbiBKU09OIGZvcm1hdC4gUnVsZSBzZXRzIG11c3QgYmUgZGVmaW5lZCBpbiB0aGUgc2FtZSBSZWdpb24gYXMgdGhlIG1hdGNobWFraW5nIGNvbmZpZ3VyYXRpb24gdGhleSBhcmUgdXNlZCB3aXRoLlxuICpcbiAqIFNpbmNlIG1hdGNobWFraW5nIHJ1bGUgc2V0cyBjYW5ub3QgYmUgZWRpdGVkLCBpdCBpcyBhIGdvb2QgaWRlYSB0byBjaGVjayB0aGUgcnVsZSBzZXQgc3ludGF4LlxuICpcbiAqICpMZWFybiBtb3JlKlxuICpcbiAqIC0gW0J1aWxkIGEgcnVsZSBzZXRdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9nYW1lbGlmdC9sYXRlc3QvZmxleG1hdGNoZ3VpZGUvbWF0Y2gtcnVsZXNldHMuaHRtbClcbiAqIC0gW0Rlc2lnbiBhIG1hdGNobWFrZXJdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9nYW1lbGlmdC9sYXRlc3QvZmxleG1hdGNoZ3VpZGUvbWF0Y2gtY29uZmlndXJhdGlvbi5odG1sKVxuICogLSBbTWF0Y2htYWtpbmcgd2l0aCBGbGV4TWF0Y2hdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9nYW1lbGlmdC9sYXRlc3QvZmxleG1hdGNoZ3VpZGUvbWF0Y2gtaW50cm8uaHRtbClcbiAqXG4gKiBAY2xvdWRmb3JtYXRpb25SZXNvdXJjZSBBV1M6OkdhbWVMaWZ0OjpNYXRjaG1ha2luZ1J1bGVTZXRcbiAqIEBzdGFiaWxpdHkgZXh0ZXJuYWxcbiAqXG4gKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1nYW1lbGlmdC1tYXRjaG1ha2luZ3J1bGVzZXQuaHRtbFxuICovXG5leHBvcnQgY2xhc3MgQ2ZuTWF0Y2htYWtpbmdSdWxlU2V0IGV4dGVuZHMgY2RrLkNmblJlc291cmNlIGltcGxlbWVudHMgY2RrLklJbnNwZWN0YWJsZSB7XG4gICAgLyoqXG4gICAgICogVGhlIENsb3VkRm9ybWF0aW9uIHJlc291cmNlIHR5cGUgbmFtZSBmb3IgdGhpcyByZXNvdXJjZSBjbGFzcy5cbiAgICAgKi9cbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IENGTl9SRVNPVVJDRV9UWVBFX05BTUUgPSBcIkFXUzo6R2FtZUxpZnQ6Ok1hdGNobWFraW5nUnVsZVNldFwiO1xuXG4gICAgLyoqXG4gICAgICogQSBmYWN0b3J5IG1ldGhvZCB0aGF0IGNyZWF0ZXMgYSBuZXcgaW5zdGFuY2Ugb2YgdGhpcyBjbGFzcyBmcm9tIGFuIG9iamVjdFxuICAgICAqIGNvbnRhaW5pbmcgdGhlIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgdGhpcyByZXNvdXJjZS5cbiAgICAgKiBVc2VkIGluIHRoZSBAYXdzLWNkay9jbG91ZGZvcm1hdGlvbi1pbmNsdWRlIG1vZHVsZS5cbiAgICAgKlxuICAgICAqIEBpbnRlcm5hbFxuICAgICAqL1xuICAgIHB1YmxpYyBzdGF0aWMgX2Zyb21DbG91ZEZvcm1hdGlvbihzY29wZTogY2RrLkNvbnN0cnVjdCwgaWQ6IHN0cmluZywgcmVzb3VyY2VBdHRyaWJ1dGVzOiBhbnksIG9wdGlvbnM6IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25PcHRpb25zKTogQ2ZuTWF0Y2htYWtpbmdSdWxlU2V0IHtcbiAgICAgICAgcmVzb3VyY2VBdHRyaWJ1dGVzID0gcmVzb3VyY2VBdHRyaWJ1dGVzIHx8IHt9O1xuICAgICAgICBjb25zdCByZXNvdXJjZVByb3BlcnRpZXMgPSBvcHRpb25zLnBhcnNlci5wYXJzZVZhbHVlKHJlc291cmNlQXR0cmlidXRlcy5Qcm9wZXJ0aWVzKTtcbiAgICAgICAgY29uc3QgcHJvcHNSZXN1bHQgPSBDZm5NYXRjaG1ha2luZ1J1bGVTZXRQcm9wc0Zyb21DbG91ZEZvcm1hdGlvbihyZXNvdXJjZVByb3BlcnRpZXMpO1xuICAgICAgICBjb25zdCByZXQgPSBuZXcgQ2ZuTWF0Y2htYWtpbmdSdWxlU2V0KHNjb3BlLCBpZCwgcHJvcHNSZXN1bHQudmFsdWUpO1xuICAgICAgICBmb3IgKGNvbnN0IFtwcm9wS2V5LCBwcm9wVmFsXSBvZiBPYmplY3QuZW50cmllcyhwcm9wc1Jlc3VsdC5leHRyYVByb3BlcnRpZXMpKSAge1xuICAgICAgICAgICAgcmV0LmFkZFByb3BlcnR5T3ZlcnJpZGUocHJvcEtleSwgcHJvcFZhbCk7XG4gICAgICAgIH1cbiAgICAgICAgb3B0aW9ucy5wYXJzZXIuaGFuZGxlQXR0cmlidXRlcyhyZXQsIHJlc291cmNlQXR0cmlidXRlcywgaWQpO1xuICAgICAgICByZXR1cm4gcmV0O1xuICAgIH1cblxuICAgIC8qKlxuICAgICAqIFRoZSB1bmlxdWUgQW1hem9uIFJlc291cmNlIE5hbWUgKEFSTikgYXNzaWduZWQgdG8gdGhlIHJ1bGUgc2V0LlxuICAgICAqIEBjbG91ZGZvcm1hdGlvbkF0dHJpYnV0ZSBBcm5cbiAgICAgKi9cbiAgICBwdWJsaWMgcmVhZG9ubHkgYXR0ckFybjogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogVGhlIHVuaXF1ZSBuYW1lIG9mIHRoZSBydWxlIHNldC5cbiAgICAgKiBAY2xvdWRmb3JtYXRpb25BdHRyaWJ1dGUgTmFtZVxuICAgICAqL1xuICAgIHB1YmxpYyByZWFkb25seSBhdHRyTmFtZTogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogQSB1bmlxdWUgaWRlbnRpZmllciBmb3IgdGhlIG1hdGNobWFraW5nIHJ1bGUgc2V0LiBBIG1hdGNobWFraW5nIGNvbmZpZ3VyYXRpb24gaWRlbnRpZmllcyB0aGUgcnVsZSBzZXQgaXQgdXNlcyBieSB0aGlzIG5hbWUgdmFsdWUuIE5vdGUgdGhhdCB0aGUgcnVsZSBzZXQgbmFtZSBpcyBkaWZmZXJlbnQgZnJvbSB0aGUgb3B0aW9uYWwgYG5hbWVgIGZpZWxkIGluIHRoZSBydWxlIHNldCBib2R5LlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZ2FtZWxpZnQtbWF0Y2htYWtpbmdydWxlc2V0Lmh0bWwjY2ZuLWdhbWVsaWZ0LW1hdGNobWFraW5ncnVsZXNldC1uYW1lXG4gICAgICovXG4gICAgcHVibGljIG5hbWU6IHN0cmluZztcblxuICAgIC8qKlxuICAgICAqIEEgY29sbGVjdGlvbiBvZiBtYXRjaG1ha2luZyBydWxlcywgZm9ybWF0dGVkIGFzIGEgSlNPTiBzdHJpbmcuIENvbW1lbnRzIGFyZSBub3QgYWxsb3dlZCBpbiBKU09OLCBidXQgbW9zdCBlbGVtZW50cyBzdXBwb3J0IGEgZGVzY3JpcHRpb24gZmllbGQuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1nYW1lbGlmdC1tYXRjaG1ha2luZ3J1bGVzZXQuaHRtbCNjZm4tZ2FtZWxpZnQtbWF0Y2htYWtpbmdydWxlc2V0LXJ1bGVzZXRib2R5XG4gICAgICovXG4gICAgcHVibGljIHJ1bGVTZXRCb2R5OiBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBBIGxpc3Qgb2YgbGFiZWxzIHRvIGFzc2lnbiB0byB0aGUgbmV3IG1hdGNobWFraW5nIHJ1bGUgc2V0IHJlc291cmNlLiBUYWdzIGFyZSBkZXZlbG9wZXItZGVmaW5lZCBrZXktdmFsdWUgcGFpcnMuIFRhZ2dpbmcgQVdTIHJlc291cmNlcyBhcmUgdXNlZnVsIGZvciByZXNvdXJjZSBtYW5hZ2VtZW50LCBhY2Nlc3MgbWFuYWdlbWVudCBhbmQgY29zdCBhbGxvY2F0aW9uLiBGb3IgbW9yZSBpbmZvcm1hdGlvbiwgc2VlIFtUYWdnaW5nIEFXUyBSZXNvdXJjZXNdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9nZW5lcmFsL2xhdGVzdC9nci9hd3NfdGFnZ2luZy5odG1sKSBpbiB0aGUgKkFXUyBHZW5lcmFsIFJlZmVyZW5jZSogLiBPbmNlIHRoZSByZXNvdXJjZSBpcyBjcmVhdGVkLCB5b3UgY2FuIHVzZSBUYWdSZXNvdXJjZSwgVW50YWdSZXNvdXJjZSwgYW5kIExpc3RUYWdzRm9yUmVzb3VyY2UgdG8gYWRkLCByZW1vdmUsIGFuZCB2aWV3IHRhZ3MuIFRoZSBtYXhpbXVtIHRhZyBsaW1pdCBtYXkgYmUgbG93ZXIgdGhhbiBzdGF0ZWQuIFNlZSB0aGUgQVdTIEdlbmVyYWwgUmVmZXJlbmNlIGZvciBhY3R1YWwgdGFnZ2luZyBsaW1pdHMuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1nYW1lbGlmdC1tYXRjaG1ha2luZ3J1bGVzZXQuaHRtbCNjZm4tZ2FtZWxpZnQtbWF0Y2htYWtpbmdydWxlc2V0LXRhZ3NcbiAgICAgKi9cbiAgICBwdWJsaWMgcmVhZG9ubHkgdGFnczogY2RrLlRhZ01hbmFnZXI7XG5cbiAgICAvKipcbiAgICAgKiBDcmVhdGUgYSBuZXcgYEFXUzo6R2FtZUxpZnQ6Ok1hdGNobWFraW5nUnVsZVNldGAuXG4gICAgICpcbiAgICAgKiBAcGFyYW0gc2NvcGUgLSBzY29wZSBpbiB3aGljaCB0aGlzIHJlc291cmNlIGlzIGRlZmluZWRcbiAgICAgKiBAcGFyYW0gaWQgICAgLSBzY29wZWQgaWQgb2YgdGhlIHJlc291cmNlXG4gICAgICogQHBhcmFtIHByb3BzIC0gcmVzb3VyY2UgcHJvcGVydGllc1xuICAgICAqL1xuICAgIGNvbnN0cnVjdG9yKHNjb3BlOiBjZGsuQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogQ2ZuTWF0Y2htYWtpbmdSdWxlU2V0UHJvcHMpIHtcbiAgICAgICAgc3VwZXIoc2NvcGUsIGlkLCB7IHR5cGU6IENmbk1hdGNobWFraW5nUnVsZVNldC5DRk5fUkVTT1VSQ0VfVFlQRV9OQU1FLCBwcm9wZXJ0aWVzOiBwcm9wcyB9KTtcbiAgICAgICAgY2RrLnJlcXVpcmVQcm9wZXJ0eShwcm9wcywgJ25hbWUnLCB0aGlzKTtcbiAgICAgICAgY2RrLnJlcXVpcmVQcm9wZXJ0eShwcm9wcywgJ3J1bGVTZXRCb2R5JywgdGhpcyk7XG4gICAgICAgIHRoaXMuYXR0ckFybiA9IGNkay5Ub2tlbi5hc1N0cmluZyh0aGlzLmdldEF0dCgnQXJuJykpO1xuICAgICAgICB0aGlzLmF0dHJOYW1lID0gY2RrLlRva2VuLmFzU3RyaW5nKHRoaXMuZ2V0QXR0KCdOYW1lJykpO1xuXG4gICAgICAgIHRoaXMubmFtZSA9IHByb3BzLm5hbWU7XG4gICAgICAgIHRoaXMucnVsZVNldEJvZHkgPSBwcm9wcy5ydWxlU2V0Qm9keTtcbiAgICAgICAgdGhpcy50YWdzID0gbmV3IGNkay5UYWdNYW5hZ2VyKGNkay5UYWdUeXBlLlNUQU5EQVJELCBcIkFXUzo6R2FtZUxpZnQ6Ok1hdGNobWFraW5nUnVsZVNldFwiLCBwcm9wcy50YWdzLCB7IHRhZ1Byb3BlcnR5TmFtZTogJ3RhZ3MnIH0pO1xuICAgIH1cblxuICAgIC8qKlxuICAgICAqIEV4YW1pbmVzIHRoZSBDbG91ZEZvcm1hdGlvbiByZXNvdXJjZSBhbmQgZGlzY2xvc2VzIGF0dHJpYnV0ZXMuXG4gICAgICpcbiAgICAgKiBAcGFyYW0gaW5zcGVjdG9yIC0gdHJlZSBpbnNwZWN0b3IgdG8gY29sbGVjdCBhbmQgcHJvY2VzcyBhdHRyaWJ1dGVzXG4gICAgICpcbiAgICAgKi9cbiAgICBwdWJsaWMgaW5zcGVjdChpbnNwZWN0b3I6IGNkay5UcmVlSW5zcGVjdG9yKSB7XG4gICAgICAgIGluc3BlY3Rvci5hZGRBdHRyaWJ1dGUoXCJhd3M6Y2RrOmNsb3VkZm9ybWF0aW9uOnR5cGVcIiwgQ2ZuTWF0Y2htYWtpbmdSdWxlU2V0LkNGTl9SRVNPVVJDRV9UWVBFX05BTUUpO1xuICAgICAgICBpbnNwZWN0b3IuYWRkQXR0cmlidXRlKFwiYXdzOmNkazpjbG91ZGZvcm1hdGlvbjpwcm9wc1wiLCB0aGlzLmNmblByb3BlcnRpZXMpO1xuICAgIH1cblxuICAgIHByb3RlY3RlZCBnZXQgY2ZuUHJvcGVydGllcygpOiB7IFtrZXk6IHN0cmluZ106IGFueSB9ICB7XG4gICAgICAgIHJldHVybiB7XG4gICAgICAgICAgICBuYW1lOiB0aGlzLm5hbWUsXG4gICAgICAgICAgICBydWxlU2V0Qm9keTogdGhpcy5ydWxlU2V0Qm9keSxcbiAgICAgICAgICAgIHRhZ3M6IHRoaXMudGFncy5yZW5kZXJUYWdzKCksXG4gICAgICAgIH07XG4gICAgfVxuXG4gICAgcHJvdGVjdGVkIHJlbmRlclByb3BlcnRpZXMocHJvcHM6IHtba2V5OiBzdHJpbmddOiBhbnl9KTogeyBba2V5OiBzdHJpbmddOiBhbnkgfSAge1xuICAgICAgICByZXR1cm4gY2ZuTWF0Y2htYWtpbmdSdWxlU2V0UHJvcHNUb0Nsb3VkRm9ybWF0aW9uKHByb3BzKTtcbiAgICB9XG59XG5cbi8qKlxuICogUHJvcGVydGllcyBmb3IgZGVmaW5pbmcgYSBgQ2ZuU2NyaXB0YFxuICpcbiAqIEBzdHJ1Y3RcbiAqIEBzdGFiaWxpdHkgZXh0ZXJuYWxcbiAqXG4gKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1nYW1lbGlmdC1zY3JpcHQuaHRtbFxuICovXG5leHBvcnQgaW50ZXJmYWNlIENmblNjcmlwdFByb3BzIHtcblxuICAgIC8qKlxuICAgICAqIFRoZSBsb2NhdGlvbiBvZiB0aGUgQW1hem9uIFMzIGJ1Y2tldCB3aGVyZSBhIHppcHBlZCBmaWxlIGNvbnRhaW5pbmcgeW91ciBSZWFsdGltZSBzY3JpcHRzIGlzIHN0b3JlZC4gVGhlIHN0b3JhZ2UgbG9jYXRpb24gbXVzdCBzcGVjaWZ5IHRoZSBBbWF6b24gUzMgYnVja2V0IG5hbWUsIHRoZSB6aXAgZmlsZSBuYW1lICh0aGUgXCJrZXlcIiksIGFuZCBhIHJvbGUgQVJOIHRoYXQgYWxsb3dzIEFtYXpvbiBHYW1lTGlmdCB0byBhY2Nlc3MgdGhlIEFtYXpvbiBTMyBzdG9yYWdlIGxvY2F0aW9uLiBUaGUgUzMgYnVja2V0IG11c3QgYmUgaW4gdGhlIHNhbWUgUmVnaW9uIHdoZXJlIHlvdSB3YW50IHRvIGNyZWF0ZSBhIG5ldyBzY3JpcHQuIEJ5IGRlZmF1bHQsIEFtYXpvbiBHYW1lTGlmdCB1cGxvYWRzIHRoZSBsYXRlc3QgdmVyc2lvbiBvZiB0aGUgemlwIGZpbGU7IGlmIHlvdSBoYXZlIFMzIG9iamVjdCB2ZXJzaW9uaW5nIHR1cm5lZCBvbiwgeW91IGNhbiB1c2UgdGhlIGBPYmplY3RWZXJzaW9uYCBwYXJhbWV0ZXIgdG8gc3BlY2lmeSBhbiBlYXJsaWVyIHZlcnNpb24uXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1nYW1lbGlmdC1zY3JpcHQuaHRtbCNjZm4tZ2FtZWxpZnQtc2NyaXB0LXN0b3JhZ2Vsb2NhdGlvblxuICAgICAqL1xuICAgIHJlYWRvbmx5IHN0b3JhZ2VMb2NhdGlvbjogQ2ZuU2NyaXB0LlMzTG9jYXRpb25Qcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIEEgZGVzY3JpcHRpdmUgbGFiZWwgdGhhdCBpcyBhc3NvY2lhdGVkIHdpdGggYSBzY3JpcHQuIFNjcmlwdCBuYW1lcyBkbyBub3QgbmVlZCB0byBiZSB1bmlxdWUuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1nYW1lbGlmdC1zY3JpcHQuaHRtbCNjZm4tZ2FtZWxpZnQtc2NyaXB0LW5hbWVcbiAgICAgKi9cbiAgICByZWFkb25seSBuYW1lPzogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogQSBsaXN0IG9mIGxhYmVscyB0byBhc3NpZ24gdG8gdGhlIG5ldyBzY3JpcHQgcmVzb3VyY2UuIFRhZ3MgYXJlIGRldmVsb3Blci1kZWZpbmVkIGtleS12YWx1ZSBwYWlycy4gVGFnZ2luZyBBV1MgcmVzb3VyY2VzIGFyZSB1c2VmdWwgZm9yIHJlc291cmNlIG1hbmFnZW1lbnQsIGFjY2VzcyBtYW5hZ2VtZW50IGFuZCBjb3N0IGFsbG9jYXRpb24uIEZvciBtb3JlIGluZm9ybWF0aW9uLCBzZWUgW1RhZ2dpbmcgQVdTIFJlc291cmNlc10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2dlbmVyYWwvbGF0ZXN0L2dyL2F3c190YWdnaW5nLmh0bWwpIGluIHRoZSAqQVdTIEdlbmVyYWwgUmVmZXJlbmNlKiAuIE9uY2UgdGhlIHJlc291cmNlIGlzIGNyZWF0ZWQsIHlvdSBjYW4gdXNlIFRhZ1Jlc291cmNlLCBVbnRhZ1Jlc291cmNlLCBhbmQgTGlzdFRhZ3NGb3JSZXNvdXJjZSB0byBhZGQsIHJlbW92ZSwgYW5kIHZpZXcgdGFncy4gVGhlIG1heGltdW0gdGFnIGxpbWl0IG1heSBiZSBsb3dlciB0aGFuIHN0YXRlZC4gU2VlIHRoZSBBV1MgR2VuZXJhbCBSZWZlcmVuY2UgZm9yIGFjdHVhbCB0YWdnaW5nIGxpbWl0cy5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWdhbWVsaWZ0LXNjcmlwdC5odG1sI2Nmbi1nYW1lbGlmdC1zY3JpcHQtdGFnc1xuICAgICAqL1xuICAgIHJlYWRvbmx5IHRhZ3M/OiBjZGsuQ2ZuVGFnW107XG5cbiAgICAvKipcbiAgICAgKiBUaGUgdmVyc2lvbiB0aGF0IGlzIGFzc29jaWF0ZWQgd2l0aCBhIGJ1aWxkIG9yIHNjcmlwdC4gVmVyc2lvbiBzdHJpbmdzIGRvIG5vdCBuZWVkIHRvIGJlIHVuaXF1ZS5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWdhbWVsaWZ0LXNjcmlwdC5odG1sI2Nmbi1nYW1lbGlmdC1zY3JpcHQtdmVyc2lvblxuICAgICAqL1xuICAgIHJlYWRvbmx5IHZlcnNpb24/OiBzdHJpbmc7XG59XG5cbi8qKlxuICogRGV0ZXJtaW5lIHdoZXRoZXIgdGhlIGdpdmVuIHByb3BlcnRpZXMgbWF0Y2ggdGhvc2Ugb2YgYSBgQ2ZuU2NyaXB0UHJvcHNgXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYENmblNjcmlwdFByb3BzYFxuICpcbiAqIEByZXR1cm5zIHRoZSByZXN1bHQgb2YgdGhlIHZhbGlkYXRpb24uXG4gKi9cbmZ1bmN0aW9uIENmblNjcmlwdFByb3BzVmFsaWRhdG9yKHByb3BlcnRpZXM6IGFueSk6IGNkay5WYWxpZGF0aW9uUmVzdWx0IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBjZGsuVkFMSURBVElPTl9TVUNDRVNTOyB9XG4gICAgY29uc3QgZXJyb3JzID0gbmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0cygpO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgZXJyb3JzLmNvbGxlY3QobmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0KCdFeHBlY3RlZCBhbiBvYmplY3QsIGJ1dCByZWNlaXZlZDogJyArIEpTT04uc3RyaW5naWZ5KHByb3BlcnRpZXMpKSk7XG4gICAgfVxuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignbmFtZScsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5uYW1lKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdzdG9yYWdlTG9jYXRpb24nLCBjZGsucmVxdWlyZWRWYWxpZGF0b3IpKHByb3BlcnRpZXMuc3RvcmFnZUxvY2F0aW9uKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdzdG9yYWdlTG9jYXRpb24nLCBDZm5TY3JpcHRfUzNMb2NhdGlvblByb3BlcnR5VmFsaWRhdG9yKShwcm9wZXJ0aWVzLnN0b3JhZ2VMb2NhdGlvbikpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigndGFncycsIGNkay5saXN0VmFsaWRhdG9yKGNkay52YWxpZGF0ZUNmblRhZykpKHByb3BlcnRpZXMudGFncykpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigndmVyc2lvbicsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy52ZXJzaW9uKSk7XG4gICAgcmV0dXJuIGVycm9ycy53cmFwKCdzdXBwbGllZCBwcm9wZXJ0aWVzIG5vdCBjb3JyZWN0IGZvciBcIkNmblNjcmlwdFByb3BzXCInKTtcbn1cblxuLyoqXG4gKiBSZW5kZXJzIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpHYW1lTGlmdDo6U2NyaXB0YCByZXNvdXJjZVxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBDZm5TY3JpcHRQcm9wc2BcbiAqXG4gKiBAcmV0dXJucyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6R2FtZUxpZnQ6OlNjcmlwdGAgcmVzb3VyY2UuXG4gKi9cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBjZm5TY3JpcHRQcm9wc1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogYW55IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBwcm9wZXJ0aWVzOyB9XG4gICAgQ2ZuU2NyaXB0UHJvcHNWYWxpZGF0b3IocHJvcGVydGllcykuYXNzZXJ0U3VjY2VzcygpO1xuICAgIHJldHVybiB7XG4gICAgICAgIFN0b3JhZ2VMb2NhdGlvbjogY2ZuU2NyaXB0UzNMb2NhdGlvblByb3BlcnR5VG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLnN0b3JhZ2VMb2NhdGlvbiksXG4gICAgICAgIE5hbWU6IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMubmFtZSksXG4gICAgICAgIFRhZ3M6IGNkay5saXN0TWFwcGVyKGNkay5jZm5UYWdUb0Nsb3VkRm9ybWF0aW9uKShwcm9wZXJ0aWVzLnRhZ3MpLFxuICAgICAgICBWZXJzaW9uOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLnZlcnNpb24pLFxuICAgIH07XG59XG5cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBDZm5TY3JpcHRQcm9wc0Zyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0PENmblNjcmlwdFByb3BzPiB7XG4gICAgcHJvcGVydGllcyA9IHByb3BlcnRpZXMgPT0gbnVsbCA/IHt9IDogcHJvcGVydGllcztcbiAgICBpZiAodHlwZW9mIHByb3BlcnRpZXMgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIHJldHVybiBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdChwcm9wZXJ0aWVzKTtcbiAgICB9XG4gICAgY29uc3QgcmV0ID0gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25Qcm9wZXJ0eU9iamVjdDxDZm5TY3JpcHRQcm9wcz4oKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ3N0b3JhZ2VMb2NhdGlvbicsICdTdG9yYWdlTG9jYXRpb24nLCBDZm5TY3JpcHRTM0xvY2F0aW9uUHJvcGVydHlGcm9tQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5TdG9yYWdlTG9jYXRpb24pKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ25hbWUnLCAnTmFtZScsIHByb3BlcnRpZXMuTmFtZSAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5OYW1lKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCd0YWdzJywgJ1RhZ3MnLCBwcm9wZXJ0aWVzLlRhZ3MgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0QXJyYXkoY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRDZm5UYWcpKHByb3BlcnRpZXMuVGFncykgOiB1bmRlZmluZWQgYXMgYW55KTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ3ZlcnNpb24nLCAnVmVyc2lvbicsIHByb3BlcnRpZXMuVmVyc2lvbiAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5WZXJzaW9uKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFVucmVjb2duaXplZFByb3BlcnRpZXNBc0V4dHJhKHByb3BlcnRpZXMpO1xuICAgIHJldHVybiByZXQ7XG59XG5cbi8qKlxuICogQSBDbG91ZEZvcm1hdGlvbiBgQVdTOjpHYW1lTGlmdDo6U2NyaXB0YFxuICpcbiAqIFRoZSBgQVdTOjpHYW1lTGlmdDo6U2NyaXB0YCByZXNvdXJjZSBjcmVhdGVzIGEgbmV3IHNjcmlwdCByZWNvcmQgZm9yIHlvdXIgUmVhbHRpbWUgU2VydmVycyBzY3JpcHQuIFJlYWx0aW1lIHNjcmlwdHMgYXJlIEphdmFTY3JpcHQgdGhhdCBwcm92aWRlIGNvbmZpZ3VyYXRpb24gc2V0dGluZ3MgYW5kIG9wdGlvbmFsIGN1c3RvbSBnYW1lIGxvZ2ljIGZvciB5b3VyIGdhbWUuIFRoZSBzY3JpcHQgaXMgZGVwbG95ZWQgd2hlbiB5b3UgY3JlYXRlIGEgUmVhbHRpbWUgU2VydmVycyBmbGVldCB0byBob3N0IHlvdXIgZ2FtZSBzZXNzaW9ucy4gU2NyaXB0IGxvZ2ljIGlzIGV4ZWN1dGVkIGR1cmluZyBhbiBhY3RpdmUgZ2FtZSBzZXNzaW9uLlxuICpcbiAqIEBjbG91ZGZvcm1hdGlvblJlc291cmNlIEFXUzo6R2FtZUxpZnQ6OlNjcmlwdFxuICogQHN0YWJpbGl0eSBleHRlcm5hbFxuICpcbiAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWdhbWVsaWZ0LXNjcmlwdC5odG1sXG4gKi9cbmV4cG9ydCBjbGFzcyBDZm5TY3JpcHQgZXh0ZW5kcyBjZGsuQ2ZuUmVzb3VyY2UgaW1wbGVtZW50cyBjZGsuSUluc3BlY3RhYmxlIHtcbiAgICAvKipcbiAgICAgKiBUaGUgQ2xvdWRGb3JtYXRpb24gcmVzb3VyY2UgdHlwZSBuYW1lIGZvciB0aGlzIHJlc291cmNlIGNsYXNzLlxuICAgICAqL1xuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgQ0ZOX1JFU09VUkNFX1RZUEVfTkFNRSA9IFwiQVdTOjpHYW1lTGlmdDo6U2NyaXB0XCI7XG5cbiAgICAvKipcbiAgICAgKiBBIGZhY3RvcnkgbWV0aG9kIHRoYXQgY3JlYXRlcyBhIG5ldyBpbnN0YW5jZSBvZiB0aGlzIGNsYXNzIGZyb20gYW4gb2JqZWN0XG4gICAgICogY29udGFpbmluZyB0aGUgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiB0aGlzIHJlc291cmNlLlxuICAgICAqIFVzZWQgaW4gdGhlIEBhd3MtY2RrL2Nsb3VkZm9ybWF0aW9uLWluY2x1ZGUgbW9kdWxlLlxuICAgICAqXG4gICAgICogQGludGVybmFsXG4gICAgICovXG4gICAgcHVibGljIHN0YXRpYyBfZnJvbUNsb3VkRm9ybWF0aW9uKHNjb3BlOiBjZGsuQ29uc3RydWN0LCBpZDogc3RyaW5nLCByZXNvdXJjZUF0dHJpYnV0ZXM6IGFueSwgb3B0aW9uczogY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbk9wdGlvbnMpOiBDZm5TY3JpcHQge1xuICAgICAgICByZXNvdXJjZUF0dHJpYnV0ZXMgPSByZXNvdXJjZUF0dHJpYnV0ZXMgfHwge307XG4gICAgICAgIGNvbnN0IHJlc291cmNlUHJvcGVydGllcyA9IG9wdGlvbnMucGFyc2VyLnBhcnNlVmFsdWUocmVzb3VyY2VBdHRyaWJ1dGVzLlByb3BlcnRpZXMpO1xuICAgICAgICBjb25zdCBwcm9wc1Jlc3VsdCA9IENmblNjcmlwdFByb3BzRnJvbUNsb3VkRm9ybWF0aW9uKHJlc291cmNlUHJvcGVydGllcyk7XG4gICAgICAgIGNvbnN0IHJldCA9IG5ldyBDZm5TY3JpcHQoc2NvcGUsIGlkLCBwcm9wc1Jlc3VsdC52YWx1ZSk7XG4gICAgICAgIGZvciAoY29uc3QgW3Byb3BLZXksIHByb3BWYWxdIG9mIE9iamVjdC5lbnRyaWVzKHByb3BzUmVzdWx0LmV4dHJhUHJvcGVydGllcykpICB7XG4gICAgICAgICAgICByZXQuYWRkUHJvcGVydHlPdmVycmlkZShwcm9wS2V5LCBwcm9wVmFsKTtcbiAgICAgICAgfVxuICAgICAgICBvcHRpb25zLnBhcnNlci5oYW5kbGVBdHRyaWJ1dGVzKHJldCwgcmVzb3VyY2VBdHRyaWJ1dGVzLCBpZCk7XG4gICAgICAgIHJldHVybiByZXQ7XG4gICAgfVxuXG4gICAgLyoqXG4gICAgICogVGhlIHVuaXF1ZSBBbWF6b24gUmVzb3VyY2UgTmFtZSAoQVJOKSBmb3IgdGhlIHNjcmlwdC5cbiAgICAgKiBAY2xvdWRmb3JtYXRpb25BdHRyaWJ1dGUgQXJuXG4gICAgICovXG4gICAgcHVibGljIHJlYWRvbmx5IGF0dHJBcm46IHN0cmluZztcblxuICAgIC8qKlxuICAgICAqIEEgdW5pcXVlIGlkZW50aWZpZXIgZm9yIGEgUmVhbHRpbWUgc2NyaXB0LlxuICAgICAqIEBjbG91ZGZvcm1hdGlvbkF0dHJpYnV0ZSBJZFxuICAgICAqL1xuICAgIHB1YmxpYyByZWFkb25seSBhdHRySWQ6IHN0cmluZztcblxuICAgIC8qKlxuICAgICAqIFRoZSBsb2NhdGlvbiBvZiB0aGUgQW1hem9uIFMzIGJ1Y2tldCB3aGVyZSBhIHppcHBlZCBmaWxlIGNvbnRhaW5pbmcgeW91ciBSZWFsdGltZSBzY3JpcHRzIGlzIHN0b3JlZC4gVGhlIHN0b3JhZ2UgbG9jYXRpb24gbXVzdCBzcGVjaWZ5IHRoZSBBbWF6b24gUzMgYnVja2V0IG5hbWUsIHRoZSB6aXAgZmlsZSBuYW1lICh0aGUgXCJrZXlcIiksIGFuZCBhIHJvbGUgQVJOIHRoYXQgYWxsb3dzIEFtYXpvbiBHYW1lTGlmdCB0byBhY2Nlc3MgdGhlIEFtYXpvbiBTMyBzdG9yYWdlIGxvY2F0aW9uLiBUaGUgUzMgYnVja2V0IG11c3QgYmUgaW4gdGhlIHNhbWUgUmVnaW9uIHdoZXJlIHlvdSB3YW50IHRvIGNyZWF0ZSBhIG5ldyBzY3JpcHQuIEJ5IGRlZmF1bHQsIEFtYXpvbiBHYW1lTGlmdCB1cGxvYWRzIHRoZSBsYXRlc3QgdmVyc2lvbiBvZiB0aGUgemlwIGZpbGU7IGlmIHlvdSBoYXZlIFMzIG9iamVjdCB2ZXJzaW9uaW5nIHR1cm5lZCBvbiwgeW91IGNhbiB1c2UgdGhlIGBPYmplY3RWZXJzaW9uYCBwYXJhbWV0ZXIgdG8gc3BlY2lmeSBhbiBlYXJsaWVyIHZlcnNpb24uXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1nYW1lbGlmdC1zY3JpcHQuaHRtbCNjZm4tZ2FtZWxpZnQtc2NyaXB0LXN0b3JhZ2Vsb2NhdGlvblxuICAgICAqL1xuICAgIHB1YmxpYyBzdG9yYWdlTG9jYXRpb246IENmblNjcmlwdC5TM0xvY2F0aW9uUHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBBIGRlc2NyaXB0aXZlIGxhYmVsIHRoYXQgaXMgYXNzb2NpYXRlZCB3aXRoIGEgc2NyaXB0LiBTY3JpcHQgbmFtZXMgZG8gbm90IG5lZWQgdG8gYmUgdW5pcXVlLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZ2FtZWxpZnQtc2NyaXB0Lmh0bWwjY2ZuLWdhbWVsaWZ0LXNjcmlwdC1uYW1lXG4gICAgICovXG4gICAgcHVibGljIG5hbWU6IHN0cmluZyB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIEEgbGlzdCBvZiBsYWJlbHMgdG8gYXNzaWduIHRvIHRoZSBuZXcgc2NyaXB0IHJlc291cmNlLiBUYWdzIGFyZSBkZXZlbG9wZXItZGVmaW5lZCBrZXktdmFsdWUgcGFpcnMuIFRhZ2dpbmcgQVdTIHJlc291cmNlcyBhcmUgdXNlZnVsIGZvciByZXNvdXJjZSBtYW5hZ2VtZW50LCBhY2Nlc3MgbWFuYWdlbWVudCBhbmQgY29zdCBhbGxvY2F0aW9uLiBGb3IgbW9yZSBpbmZvcm1hdGlvbiwgc2VlIFtUYWdnaW5nIEFXUyBSZXNvdXJjZXNdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9nZW5lcmFsL2xhdGVzdC9nci9hd3NfdGFnZ2luZy5odG1sKSBpbiB0aGUgKkFXUyBHZW5lcmFsIFJlZmVyZW5jZSogLiBPbmNlIHRoZSByZXNvdXJjZSBpcyBjcmVhdGVkLCB5b3UgY2FuIHVzZSBUYWdSZXNvdXJjZSwgVW50YWdSZXNvdXJjZSwgYW5kIExpc3RUYWdzRm9yUmVzb3VyY2UgdG8gYWRkLCByZW1vdmUsIGFuZCB2aWV3IHRhZ3MuIFRoZSBtYXhpbXVtIHRhZyBsaW1pdCBtYXkgYmUgbG93ZXIgdGhhbiBzdGF0ZWQuIFNlZSB0aGUgQVdTIEdlbmVyYWwgUmVmZXJlbmNlIGZvciBhY3R1YWwgdGFnZ2luZyBsaW1pdHMuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1nYW1lbGlmdC1zY3JpcHQuaHRtbCNjZm4tZ2FtZWxpZnQtc2NyaXB0LXRhZ3NcbiAgICAgKi9cbiAgICBwdWJsaWMgcmVhZG9ubHkgdGFnczogY2RrLlRhZ01hbmFnZXI7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgdmVyc2lvbiB0aGF0IGlzIGFzc29jaWF0ZWQgd2l0aCBhIGJ1aWxkIG9yIHNjcmlwdC4gVmVyc2lvbiBzdHJpbmdzIGRvIG5vdCBuZWVkIHRvIGJlIHVuaXF1ZS5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWdhbWVsaWZ0LXNjcmlwdC5odG1sI2Nmbi1nYW1lbGlmdC1zY3JpcHQtdmVyc2lvblxuICAgICAqL1xuICAgIHB1YmxpYyB2ZXJzaW9uOiBzdHJpbmcgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBDcmVhdGUgYSBuZXcgYEFXUzo6R2FtZUxpZnQ6OlNjcmlwdGAuXG4gICAgICpcbiAgICAgKiBAcGFyYW0gc2NvcGUgLSBzY29wZSBpbiB3aGljaCB0aGlzIHJlc291cmNlIGlzIGRlZmluZWRcbiAgICAgKiBAcGFyYW0gaWQgICAgLSBzY29wZWQgaWQgb2YgdGhlIHJlc291cmNlXG4gICAgICogQHBhcmFtIHByb3BzIC0gcmVzb3VyY2UgcHJvcGVydGllc1xuICAgICAqL1xuICAgIGNvbnN0cnVjdG9yKHNjb3BlOiBjZGsuQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogQ2ZuU2NyaXB0UHJvcHMpIHtcbiAgICAgICAgc3VwZXIoc2NvcGUsIGlkLCB7IHR5cGU6IENmblNjcmlwdC5DRk5fUkVTT1VSQ0VfVFlQRV9OQU1FLCBwcm9wZXJ0aWVzOiBwcm9wcyB9KTtcbiAgICAgICAgY2RrLnJlcXVpcmVQcm9wZXJ0eShwcm9wcywgJ3N0b3JhZ2VMb2NhdGlvbicsIHRoaXMpO1xuICAgICAgICB0aGlzLmF0dHJBcm4gPSBjZGsuVG9rZW4uYXNTdHJpbmcodGhpcy5nZXRBdHQoJ0FybicpKTtcbiAgICAgICAgdGhpcy5hdHRySWQgPSBjZGsuVG9rZW4uYXNTdHJpbmcodGhpcy5nZXRBdHQoJ0lkJykpO1xuXG4gICAgICAgIHRoaXMuc3RvcmFnZUxvY2F0aW9uID0gcHJvcHMuc3RvcmFnZUxvY2F0aW9uO1xuICAgICAgICB0aGlzLm5hbWUgPSBwcm9wcy5uYW1lO1xuICAgICAgICB0aGlzLnRhZ3MgPSBuZXcgY2RrLlRhZ01hbmFnZXIoY2RrLlRhZ1R5cGUuU1RBTkRBUkQsIFwiQVdTOjpHYW1lTGlmdDo6U2NyaXB0XCIsIHByb3BzLnRhZ3MsIHsgdGFnUHJvcGVydHlOYW1lOiAndGFncycgfSk7XG4gICAgICAgIHRoaXMudmVyc2lvbiA9IHByb3BzLnZlcnNpb247XG4gICAgfVxuXG4gICAgLyoqXG4gICAgICogRXhhbWluZXMgdGhlIENsb3VkRm9ybWF0aW9uIHJlc291cmNlIGFuZCBkaXNjbG9zZXMgYXR0cmlidXRlcy5cbiAgICAgKlxuICAgICAqIEBwYXJhbSBpbnNwZWN0b3IgLSB0cmVlIGluc3BlY3RvciB0byBjb2xsZWN0IGFuZCBwcm9jZXNzIGF0dHJpYnV0ZXNcbiAgICAgKlxuICAgICAqL1xuICAgIHB1YmxpYyBpbnNwZWN0KGluc3BlY3RvcjogY2RrLlRyZWVJbnNwZWN0b3IpIHtcbiAgICAgICAgaW5zcGVjdG9yLmFkZEF0dHJpYnV0ZShcImF3czpjZGs6Y2xvdWRmb3JtYXRpb246dHlwZVwiLCBDZm5TY3JpcHQuQ0ZOX1JFU09VUkNFX1RZUEVfTkFNRSk7XG4gICAgICAgIGluc3BlY3Rvci5hZGRBdHRyaWJ1dGUoXCJhd3M6Y2RrOmNsb3VkZm9ybWF0aW9uOnByb3BzXCIsIHRoaXMuY2ZuUHJvcGVydGllcyk7XG4gICAgfVxuXG4gICAgcHJvdGVjdGVkIGdldCBjZm5Qcm9wZXJ0aWVzKCk6IHsgW2tleTogc3RyaW5nXTogYW55IH0gIHtcbiAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICAgIHN0b3JhZ2VMb2NhdGlvbjogdGhpcy5zdG9yYWdlTG9jYXRpb24sXG4gICAgICAgICAgICBuYW1lOiB0aGlzLm5hbWUsXG4gICAgICAgICAgICB0YWdzOiB0aGlzLnRhZ3MucmVuZGVyVGFncygpLFxuICAgICAgICAgICAgdmVyc2lvbjogdGhpcy52ZXJzaW9uLFxuICAgICAgICB9O1xuICAgIH1cblxuICAgIHByb3RlY3RlZCByZW5kZXJQcm9wZXJ0aWVzKHByb3BzOiB7W2tleTogc3RyaW5nXTogYW55fSk6IHsgW2tleTogc3RyaW5nXTogYW55IH0gIHtcbiAgICAgICAgcmV0dXJuIGNmblNjcmlwdFByb3BzVG9DbG91ZEZvcm1hdGlvbihwcm9wcyk7XG4gICAgfVxufVxuXG5leHBvcnQgbmFtZXNwYWNlIENmblNjcmlwdCB7XG4gICAgLyoqXG4gICAgICogVGhlIGxvY2F0aW9uIGluIEFtYXpvbiBTMyB3aGVyZSBidWlsZCBvciBzY3JpcHQgZmlsZXMgY2FuIGJlIHN0b3JlZCBmb3IgYWNjZXNzIGJ5IEFtYXpvbiBHYW1lTGlmdC5cbiAgICAgKlxuICAgICAqIEBzdHJ1Y3RcbiAgICAgKiBAc3RhYmlsaXR5IGV4dGVybmFsXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWdhbWVsaWZ0LXNjcmlwdC1zM2xvY2F0aW9uLmh0bWxcbiAgICAgKi9cbiAgICBleHBvcnQgaW50ZXJmYWNlIFMzTG9jYXRpb25Qcm9wZXJ0eSB7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBBbiBBbWF6b24gUzMgYnVja2V0IGlkZW50aWZpZXIuIFRoaXMgaXMgdGhlIG5hbWUgb2YgdGhlIFMzIGJ1Y2tldC5cbiAgICAgICAgICpcbiAgICAgICAgICogPiBHYW1lTGlmdCBjdXJyZW50bHkgZG9lcyBub3Qgc3VwcG9ydCB1cGxvYWRpbmcgZnJvbSBBbWF6b24gUzMgYnVja2V0cyB3aXRoIG5hbWVzIHRoYXQgY29udGFpbiBhIGRvdCAoLikuXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtZ2FtZWxpZnQtc2NyaXB0LXMzbG9jYXRpb24uaHRtbCNjZm4tZ2FtZWxpZnQtc2NyaXB0LXMzbG9jYXRpb24tYnVja2V0XG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBidWNrZXQ6IHN0cmluZztcbiAgICAgICAgLyoqXG4gICAgICAgICAqIFRoZSBuYW1lIG9mIHRoZSB6aXAgZmlsZSB0aGF0IGNvbnRhaW5zIHRoZSBidWlsZCBmaWxlcyBvciBzY3JpcHQgZmlsZXMuXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtZ2FtZWxpZnQtc2NyaXB0LXMzbG9jYXRpb24uaHRtbCNjZm4tZ2FtZWxpZnQtc2NyaXB0LXMzbG9jYXRpb24ta2V5XG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBrZXk6IHN0cmluZztcbiAgICAgICAgLyoqXG4gICAgICAgICAqIFRoZSB2ZXJzaW9uIG9mIHRoZSBmaWxlLCBpZiBvYmplY3QgdmVyc2lvbmluZyBpcyB0dXJuZWQgb24gZm9yIHRoZSBidWNrZXQuIEFtYXpvbiBHYW1lTGlmdCB1c2VzIHRoaXMgaW5mb3JtYXRpb24gd2hlbiByZXRyaWV2aW5nIGZpbGVzIGZyb20gYW4gUzMgYnVja2V0IHRoYXQgeW91IG93bi4gVXNlIHRoaXMgcGFyYW1ldGVyIHRvIHNwZWNpZnkgYSBzcGVjaWZpYyB2ZXJzaW9uIG9mIHRoZSBmaWxlLiBJZiBub3Qgc2V0LCB0aGUgbGF0ZXN0IHZlcnNpb24gb2YgdGhlIGZpbGUgaXMgcmV0cmlldmVkLlxuICAgICAgICAgKlxuICAgICAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWdhbWVsaWZ0LXNjcmlwdC1zM2xvY2F0aW9uLmh0bWwjY2ZuLWdhbWVsaWZ0LXNjcmlwdC1zM2xvY2F0aW9uLW9iamVjdHZlcnNpb25cbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IG9iamVjdFZlcnNpb24/OiBzdHJpbmc7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBUaGUgQW1hem9uIFJlc291cmNlIE5hbWUgKCBbQVJOXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQW1hem9uUzMvbGF0ZXN0L2Rldi9zMy1hcm4tZm9ybWF0Lmh0bWwpICkgZm9yIGFuIElBTSByb2xlIHRoYXQgYWxsb3dzIEFtYXpvbiBHYW1lTGlmdCB0byBhY2Nlc3MgdGhlIFMzIGJ1Y2tldC5cbiAgICAgICAgICpcbiAgICAgICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1nYW1lbGlmdC1zY3JpcHQtczNsb2NhdGlvbi5odG1sI2Nmbi1nYW1lbGlmdC1zY3JpcHQtczNsb2NhdGlvbi1yb2xlYXJuXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSByb2xlQXJuOiBzdHJpbmc7XG4gICAgfVxufVxuXG4vKipcbiAqIERldGVybWluZSB3aGV0aGVyIHRoZSBnaXZlbiBwcm9wZXJ0aWVzIG1hdGNoIHRob3NlIG9mIGEgYFMzTG9jYXRpb25Qcm9wZXJ0eWBcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgUzNMb2NhdGlvblByb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSByZXN1bHQgb2YgdGhlIHZhbGlkYXRpb24uXG4gKi9cbmZ1bmN0aW9uIENmblNjcmlwdF9TM0xvY2F0aW9uUHJvcGVydHlWYWxpZGF0b3IocHJvcGVydGllczogYW55KTogY2RrLlZhbGlkYXRpb25SZXN1bHQge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIGNkay5WQUxJREFUSU9OX1NVQ0NFU1M7IH1cbiAgICBjb25zdCBlcnJvcnMgPSBuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHRzKCk7XG4gICAgaWYgKHR5cGVvZiBwcm9wZXJ0aWVzICE9PSAnb2JqZWN0Jykge1xuICAgICAgICBlcnJvcnMuY29sbGVjdChuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHQoJ0V4cGVjdGVkIGFuIG9iamVjdCwgYnV0IHJlY2VpdmVkOiAnICsgSlNPTi5zdHJpbmdpZnkocHJvcGVydGllcykpKTtcbiAgICB9XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdidWNrZXQnLCBjZGsucmVxdWlyZWRWYWxpZGF0b3IpKHByb3BlcnRpZXMuYnVja2V0KSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdidWNrZXQnLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuYnVja2V0KSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdrZXknLCBjZGsucmVxdWlyZWRWYWxpZGF0b3IpKHByb3BlcnRpZXMua2V5KSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdrZXknLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMua2V5KSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdvYmplY3RWZXJzaW9uJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLm9iamVjdFZlcnNpb24pKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3JvbGVBcm4nLCBjZGsucmVxdWlyZWRWYWxpZGF0b3IpKHByb3BlcnRpZXMucm9sZUFybikpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigncm9sZUFybicsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5yb2xlQXJuKSk7XG4gICAgcmV0dXJuIGVycm9ycy53cmFwKCdzdXBwbGllZCBwcm9wZXJ0aWVzIG5vdCBjb3JyZWN0IGZvciBcIlMzTG9jYXRpb25Qcm9wZXJ0eVwiJyk7XG59XG5cbi8qKlxuICogUmVuZGVycyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6R2FtZUxpZnQ6OlNjcmlwdC5TM0xvY2F0aW9uYCByZXNvdXJjZVxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBTM0xvY2F0aW9uUHJvcGVydHlgXG4gKlxuICogQHJldHVybnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OkdhbWVMaWZ0OjpTY3JpcHQuUzNMb2NhdGlvbmAgcmVzb3VyY2UuXG4gKi9cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBjZm5TY3JpcHRTM0xvY2F0aW9uUHJvcGVydHlUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGFueSB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gcHJvcGVydGllczsgfVxuICAgIENmblNjcmlwdF9TM0xvY2F0aW9uUHJvcGVydHlWYWxpZGF0b3IocHJvcGVydGllcykuYXNzZXJ0U3VjY2VzcygpO1xuICAgIHJldHVybiB7XG4gICAgICAgIEJ1Y2tldDogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5idWNrZXQpLFxuICAgICAgICBLZXk6IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMua2V5KSxcbiAgICAgICAgT2JqZWN0VmVyc2lvbjogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5vYmplY3RWZXJzaW9uKSxcbiAgICAgICAgUm9sZUFybjogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5yb2xlQXJuKSxcbiAgICB9O1xufVxuXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gQ2ZuU2NyaXB0UzNMb2NhdGlvblByb3BlcnR5RnJvbUNsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQ8Q2ZuU2NyaXB0LlMzTG9jYXRpb25Qcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZT4ge1xuICAgIGlmIChjZGsuaXNSZXNvbHZhYmxlT2JqZWN0KHByb3BlcnRpZXMpKSB7XG4gICAgICAgIHJldHVybiBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdChwcm9wZXJ0aWVzKTtcbiAgICB9XG4gICAgcHJvcGVydGllcyA9IHByb3BlcnRpZXMgPT0gbnVsbCA/IHt9IDogcHJvcGVydGllcztcbiAgICBpZiAodHlwZW9mIHByb3BlcnRpZXMgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIHJldHVybiBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdChwcm9wZXJ0aWVzKTtcbiAgICB9XG4gICAgY29uc3QgcmV0ID0gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25Qcm9wZXJ0eU9iamVjdDxDZm5TY3JpcHQuUzNMb2NhdGlvblByb3BlcnR5PigpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnYnVja2V0JywgJ0J1Y2tldCcsIGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuQnVja2V0KSk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdrZXknLCAnS2V5JywgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5LZXkpKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ29iamVjdFZlcnNpb24nLCAnT2JqZWN0VmVyc2lvbicsIHByb3BlcnRpZXMuT2JqZWN0VmVyc2lvbiAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5PYmplY3RWZXJzaW9uKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdyb2xlQXJuJywgJ1JvbGVBcm4nLCBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLlJvbGVBcm4pKTtcbiAgICByZXQuYWRkVW5yZWNvZ25pemVkUHJvcGVydGllc0FzRXh0cmEocHJvcGVydGllcyk7XG4gICAgcmV0dXJuIHJldDtcbn1cbiJdfQ==