import { aws_ecs } from 'aws-cdk-lib';
import * as ecs from 'aws-cdk-lib/aws-ecs';
import { FargateTaskDefinitionProps } from 'aws-cdk-lib/aws-ecs';
import { Construct } from 'constructs';
import { RdsDatabaseProps } from './kong-eks';
export interface KongEcsControlPlaneProps {
    /**
     * @summary Define ClusterProps for ECS cluster
     */
    readonly clusterProps: ecs.ClusterProps;
    /**
     * @summary Name of the hosted zone
     */
    readonly hostedZoneName: string;
    /**
     * @summary If control plane is internet facing
     */
    readonly internetFacing?: boolean;
    /**
     * @summary RDS Database properties
     */
    readonly rdsProps: RdsDatabaseProps;
    /**
     * @summary ECS Task properties
     */
    readonly kongTaskProps: FargateTaskDefinitionProps;
    /**
     * @summary Kong Features properties
     */
    readonly kongFeaturesProps: KongFeatureProps;
    readonly desiredCount: number;
    /**
     * @summary Kong image with tag
     */
    readonly image?: string;
    /**
     * @summary Name of the Secret in AWS Secrets Manager
     */
    readonly licenseSecret?: string;
}
export interface KongFeatureProps {
    /**
     * @summary Kong Admin Props
     */
    readonly adminProps: AdminProps;
    /**
     * @summary Kong Manager Props
     */
    readonly kongManagerProps: KongManagerProps;
    /**
     * @summary Kong DevPortal Props
     */
    readonly devPortalProps: DevPortalProps;
    /**
     * @summary Kong Cluster Props
     */
    readonly clusterProps: ClusterProps;
    /**
     * @summary Kong Telemetry Props
     */
    readonly clusterTelemetryProps: ClusterTelemetryProps;
    /**
     * @summary Kong Database Migration enable flag
     */
    readonly kongBootstrapMigration: boolean;
}
export interface AdminProps {
    /**
     * @summary Enable Kong Admin
     */
    /**
     * @summary  Kong Admin Http Port
     */
    readonly httpPort?: number;
    /**
     * @summary Enable Kong Admin on http
     */
    readonly enableHttp?: boolean;
    /**
     * @summary Kong Admin Https Port
     */
    readonly httpsPort?: number;
}
export interface DevPortalProps {
    /**
     * @summary Enable Kong Dev Portal
     */
    readonly enabled: boolean;
    /**
     * @summary Enable Kong DevPortal Port
     */
    readonly port?: number;
}
export interface ClusterProps {
    /**
     * @summary Enable Cluster  communication
     */
    readonly enabled: boolean;
    /**
     * @summary Cluster communication port
     */
    readonly port?: number;
}
export interface ClusterTelemetryProps {
    /**
     * @summary Enable Cluster Telemetry
     */
    readonly enabled: boolean;
    /**
     * @summary Enable Cluster Telemetry port
     */
    readonly port?: number;
}
export interface KongManagerProps {
    /**
     * @summary Enable Kong Manager
     */
    readonly enabled: boolean;
    /**
     * @summary Enable Kong Manager http port
     */
    readonly httpPort?: number;
    /**
     * @summary Enable Kong Manager over https
     */
    readonly enableHttp?: boolean;
    /**
     * @summary Kong Manager https port
     */
    readonly httpsPort?: number;
}
export declare class KongEcs extends Construct {
    readonly controlPlane: aws_ecs.Cluster;
    privateCaArn: string;
    telemetryDns: string;
    clusterDns: string;
    constructor(scope: Construct, id: string, props: KongEcsControlPlaneProps);
}
