import * as cdk from 'aws-cdk-lib';
import * as constructs from 'constructs';
/**
 * CloudFormation equivalent of ad_user
 *
 * @schema CfnUserProps
 */
export interface CfnUserProps {
    /**
     * @schema CfnUserProps#CannotChangePassword
     */
    readonly cannotChangePassword?: boolean;
    /**
     * @schema CfnUserProps#City
     */
    readonly city?: string;
    /**
     * @schema CfnUserProps#Company
     */
    readonly company?: string;
    /**
     * @schema CfnUserProps#Container
     */
    readonly container?: string;
    /**
     * @schema CfnUserProps#Country
     */
    readonly country?: string;
    /**
     * @schema CfnUserProps#CustomAttributes
     */
    readonly customAttributes?: string;
    /**
     * @schema CfnUserProps#Department
     */
    readonly department?: string;
    /**
     * @schema CfnUserProps#Description
     */
    readonly description?: string;
    /**
     * @schema CfnUserProps#DisplayName
     */
    readonly displayName: string;
    /**
     * @schema CfnUserProps#Division
     */
    readonly division?: string;
    /**
     * @schema CfnUserProps#EmailAddress
     */
    readonly emailAddress?: string;
    /**
     * @schema CfnUserProps#EmployeeId
     */
    readonly employeeId?: string;
    /**
     * @schema CfnUserProps#EmployeeNumber
     */
    readonly employeeNumber?: string;
    /**
     * @schema CfnUserProps#Enabled
     */
    readonly enabled?: boolean;
    /**
     * @schema CfnUserProps#Fax
     */
    readonly fax?: string;
    /**
     * @schema CfnUserProps#GivenName
     */
    readonly givenName?: string;
    /**
     * @schema CfnUserProps#HomeDirectory
     */
    readonly homeDirectory?: string;
    /**
     * @schema CfnUserProps#HomeDrive
     */
    readonly homeDrive?: string;
    /**
     * @schema CfnUserProps#HomePage
     */
    readonly homePage?: string;
    /**
     * @schema CfnUserProps#HomePhone
     */
    readonly homePhone?: string;
    /**
     * @schema CfnUserProps#InitialPassword
     */
    readonly initialPassword?: string;
    /**
     * @schema CfnUserProps#Initials
     */
    readonly initials?: string;
    /**
     * @schema CfnUserProps#MobilePhone
     */
    readonly mobilePhone?: string;
    /**
     * @schema CfnUserProps#Office
     */
    readonly office?: string;
    /**
     * @schema CfnUserProps#OfficePhone
     */
    readonly officePhone?: string;
    /**
     * @schema CfnUserProps#Organization
     */
    readonly organization?: string;
    /**
     * @schema CfnUserProps#OtherName
     */
    readonly otherName?: string;
    /**
     * @schema CfnUserProps#PasswordNeverExpires
     */
    readonly passwordNeverExpires?: boolean;
    /**
     * @schema CfnUserProps#PoBox
     */
    readonly poBox?: string;
    /**
     * @schema CfnUserProps#PostalCode
     */
    readonly postalCode?: string;
    /**
     * @schema CfnUserProps#PrincipalName
     */
    readonly principalName: string;
    /**
     * @schema CfnUserProps#SamAccountName
     */
    readonly samAccountName: string;
    /**
     * @schema CfnUserProps#SmartCardLogonRequired
     */
    readonly smartCardLogonRequired?: boolean;
    /**
     * @schema CfnUserProps#State
     */
    readonly state?: string;
    /**
     * @schema CfnUserProps#StreetAddress
     */
    readonly streetAddress?: string;
    /**
     * @schema CfnUserProps#Surname
     */
    readonly surname?: string;
    /**
     * @schema CfnUserProps#Title
     */
    readonly title?: string;
    /**
     * @schema CfnUserProps#TrustedForDelegation
     */
    readonly trustedForDelegation?: boolean;
}
/**
 * Converts an object of type 'CfnUserProps' to JSON representation.
 */
export declare function toJson_CfnUserProps(obj: CfnUserProps | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `TF::AD::User`
 *
 * @cloudformationResource TF::AD::User
 * @stability external
 * @link https://github.com/iann0036/cfn-tf-custom-types.git
 */
export declare class CfnUser extends cdk.CfnResource {
    /**
    * The CloudFormation resource type name for this resource class.
    */
    static readonly CFN_RESOURCE_TYPE_NAME = "TF::AD::User";
    /**
     * Resource props.
     */
    readonly props: CfnUserProps;
    /**
     * Attribute `TF::AD::User.tfcfnid`
     * @link https://github.com/iann0036/cfn-tf-custom-types.git
     */
    readonly attrTfcfnid: string;
    /**
     * Attribute `TF::AD::User.Id`
     * @link https://github.com/iann0036/cfn-tf-custom-types.git
     */
    readonly attrId: string;
    /**
     * Attribute `TF::AD::User.Sid`
     * @link https://github.com/iann0036/cfn-tf-custom-types.git
     */
    readonly attrSid: string;
    /**
     * Create a new `TF::AD::User`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnUserProps);
}
