"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnUser = exports.toJson_CfnUserProps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Generated by cdk-import
const cdk = require("aws-cdk-lib");
/**
 * Converts an object of type 'CfnUserProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnUserProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'CannotChangePassword': obj.cannotChangePassword,
        'City': obj.city,
        'Company': obj.company,
        'Container': obj.container,
        'Country': obj.country,
        'CustomAttributes': obj.customAttributes,
        'Department': obj.department,
        'Description': obj.description,
        'DisplayName': obj.displayName,
        'Division': obj.division,
        'EmailAddress': obj.emailAddress,
        'EmployeeId': obj.employeeId,
        'EmployeeNumber': obj.employeeNumber,
        'Enabled': obj.enabled,
        'Fax': obj.fax,
        'GivenName': obj.givenName,
        'HomeDirectory': obj.homeDirectory,
        'HomeDrive': obj.homeDrive,
        'HomePage': obj.homePage,
        'HomePhone': obj.homePhone,
        'InitialPassword': obj.initialPassword,
        'Initials': obj.initials,
        'MobilePhone': obj.mobilePhone,
        'Office': obj.office,
        'OfficePhone': obj.officePhone,
        'Organization': obj.organization,
        'OtherName': obj.otherName,
        'PasswordNeverExpires': obj.passwordNeverExpires,
        'PoBox': obj.poBox,
        'PostalCode': obj.postalCode,
        'PrincipalName': obj.principalName,
        'SamAccountName': obj.samAccountName,
        'SmartCardLogonRequired': obj.smartCardLogonRequired,
        'State': obj.state,
        'StreetAddress': obj.streetAddress,
        'Surname': obj.surname,
        'Title': obj.title,
        'TrustedForDelegation': obj.trustedForDelegation,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnUserProps = toJson_CfnUserProps;
/* eslint-enable max-len, quote-props */
/**
 * A CloudFormation `TF::AD::User`
 *
 * @cloudformationResource TF::AD::User
 * @stability external
 * @link https://github.com/iann0036/cfn-tf-custom-types.git
 */
class CfnUser extends cdk.CfnResource {
    /**
     * Create a new `TF::AD::User`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnUser.CFN_RESOURCE_TYPE_NAME, properties: toJson_CfnUserProps(props) });
        this.props = props;
        this.attrTfcfnid = cdk.Token.asString(this.getAtt('tfcfnid'));
        this.attrId = cdk.Token.asString(this.getAtt('Id'));
        this.attrSid = cdk.Token.asString(this.getAtt('Sid'));
    }
}
exports.CfnUser = CfnUser;
_a = JSII_RTTI_SYMBOL_1;
CfnUser[_a] = { fqn: "@cdk-cloudformation/tf-ad-user.CfnUser", version: "1.0.0-alpha.7" };
/**
* The CloudFormation resource type name for this resource class.
*/
CfnUser.CFN_RESOURCE_TYPE_NAME = "TF::AD::User";
//# sourceMappingURL=data:application/json;base64,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