# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Const Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.3
# Namespace: com.sun.star.awt
from enum import IntEnum
from typing import TYPE_CHECKING
from ooo.oenv.env_const import UNO_ENVIRONMENT, UNO_RUNTIME
_DYNAMIC = False
if (not TYPE_CHECKING) and UNO_RUNTIME and UNO_ENVIRONMENT:
    _DYNAMIC = True

if not TYPE_CHECKING and _DYNAMIC:
    from com.sun.star.awt import Command as Command
    if hasattr(Command, '_constants') and isinstance(Command._constants, dict):
        Command._constants['__ooo_ns__'] = 'com.sun.star.awt'
        Command._constants['__ooo_full_ns__'] = 'com.sun.star.awt.Command'
        Command._constants['__ooo_type_name__'] = 'const'
    def build_enum():
        global CommandEnum
        ls = [f for f in dir(Command) if not callable(getattr(Command, f)) and not f.startswith('__')]
        _dict = {}
        for name in ls:
            _dict[name] = getattr(Command, name)
        CommandEnum = IntEnum('CommandEnum', _dict)
    build_enum()
else:
    from ...lo.awt.command import Command as Command

    class CommandEnum(IntEnum):
        """
        Enum of Const Class Command

        these values specify the different command types available.
        """
        CONTEXTMENU = Command.CONTEXTMENU
        """
        specifies a requests for a context menu.
        """
        STARTDRAG = Command.STARTDRAG
        """
        specifies the beginning of a drag operation.
        """
        WHEEL = Command.WHEEL
        """
        specifies a mouse wheel operation.
        """
        STARTAUTOSCROLL = Command.STARTAUTOSCROLL
        """
        specifies the beginning of an auto scroll operation.
        """
        AUTOSCROLL = Command.AUTOSCROLL
        """
        specifies an auto scroll operation.
        """
        VOICE = Command.VOICE
        """
        specifies a request for a voice operation.
        """
        STARTEXTTEXTINPUT = Command.STARTEXTTEXTINPUT
        """
        specifies the beginning of an extended text input operation.
        """
        EXTTEXTINPUT = Command.EXTTEXTINPUT
        """
        specifies an extended text input operation.
        """
        ENDEXTTEXTINPUT = Command.ENDEXTTEXTINPUT
        """
        specifies the end of an extended text input operation.
        """
        INPUTCONTEXTCHANGE = Command.INPUTCONTEXTCHANGE
        """
        specifies that the input context has been changed.
        """
        CURSORPOS = Command.CURSORPOS
        """
        specifies the cursor position.
        """
        PASTESELECTION = Command.PASTESELECTION
        """
        specifies a paste selection command.
        """
        MODKEYCHANGE = Command.MODKEYCHANGE
        """
        specifies that the state of a key modifier has changed.
        """
        HANGUL_HANJA_CONVERSION = Command.HANGUL_HANJA_CONVERSION
        """
        specifies a Hangul hanja conversion command.
        """
        USER = Command.USER
        """
        specifies a user-defined command.
        """

__all__ = ['Command', 'CommandEnum']
