# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Const Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.3
# Namespace: com.sun.star.awt
from enum import IntEnum
from typing import TYPE_CHECKING
from ooo.oenv.env_const import UNO_ENVIRONMENT, UNO_RUNTIME
_DYNAMIC = False
if (not TYPE_CHECKING) and UNO_RUNTIME and UNO_ENVIRONMENT:
    _DYNAMIC = True

if not TYPE_CHECKING and _DYNAMIC:
    from com.sun.star.awt import ImagePosition as ImagePosition
    if hasattr(ImagePosition, '_constants') and isinstance(ImagePosition._constants, dict):
        ImagePosition._constants['__ooo_ns__'] = 'com.sun.star.awt'
        ImagePosition._constants['__ooo_full_ns__'] = 'com.sun.star.awt.ImagePosition'
        ImagePosition._constants['__ooo_type_name__'] = 'const'
    def build_enum():
        global ImagePositionEnum
        ls = [f for f in dir(ImagePosition) if not callable(getattr(ImagePosition, f)) and not f.startswith('__')]
        _dict = {}
        for name in ls:
            _dict[name] = getattr(ImagePosition, name)
        ImagePositionEnum = IntEnum('ImagePositionEnum', _dict)
    build_enum()
else:
    from ...lo.awt.image_position import ImagePosition as ImagePosition

    class ImagePositionEnum(IntEnum):
        """
        Enum of Const Class ImagePosition

        specifies the position of an image, relative to another object
        """
        LeftTop = ImagePosition.LeftTop
        """
        specifies that the image should be positioned at the left of, and top-aligned to, the other object
        """
        LeftCenter = ImagePosition.LeftCenter
        """
        specifies that the image should be positioned at the left of, and vertically centered to, the other object
        """
        LeftBottom = ImagePosition.LeftBottom
        """
        specifies that the image should be positioned at the left of, and bottom-aligned to, the other object
        """
        RightTop = ImagePosition.RightTop
        """
        specifies that the image should be positioned at the right of, and top-aligned to, the other object
        """
        RightCenter = ImagePosition.RightCenter
        """
        specifies that the image should be positioned at the right of, and vertically centered to, the other object
        """
        RightBottom = ImagePosition.RightBottom
        """
        specifies that the image should be positioned at the right of, and bottom-aligned to, the other object
        """
        AboveLeft = ImagePosition.AboveLeft
        """
        specifies that the image should be positioned above and left-aligned to the other object
        """
        AboveCenter = ImagePosition.AboveCenter
        """
        specifies that the image should be positioned above and horizontally centered to the other object
        """
        AboveRight = ImagePosition.AboveRight
        """
        specifies that the image should be positioned above and right-aligned to the other object
        """
        BelowLeft = ImagePosition.BelowLeft
        """
        specifies that the image should be positioned below and left-aligned to the other object
        """
        BelowCenter = ImagePosition.BelowCenter
        """
        specifies that the image should be positioned below and horizontally centered to the other object
        """
        BelowRight = ImagePosition.BelowRight
        """
        specifies that the image should be positioned below and right-aligned centered to the other object
        """
        Centered = ImagePosition.Centered
        """
        specifies that the image should be horizontally and vertically centered to the other object.
        """

__all__ = ['ImagePosition', 'ImagePositionEnum']
