# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Const Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.3
# Namespace: com.sun.star.awt
from enum import IntEnum
from typing import TYPE_CHECKING
from ooo.oenv.env_const import UNO_ENVIRONMENT, UNO_RUNTIME
_DYNAMIC = False
if (not TYPE_CHECKING) and UNO_RUNTIME and UNO_ENVIRONMENT:
    _DYNAMIC = True

if not TYPE_CHECKING and _DYNAMIC:
    from com.sun.star.awt import MouseWheelBehavior as MouseWheelBehavior
    if hasattr(MouseWheelBehavior, '_constants') and isinstance(MouseWheelBehavior._constants, dict):
        MouseWheelBehavior._constants['__ooo_ns__'] = 'com.sun.star.awt'
        MouseWheelBehavior._constants['__ooo_full_ns__'] = 'com.sun.star.awt.MouseWheelBehavior'
        MouseWheelBehavior._constants['__ooo_type_name__'] = 'const'
    def build_enum():
        global MouseWheelBehaviorEnum
        ls = [f for f in dir(MouseWheelBehavior) if not callable(getattr(MouseWheelBehavior, f)) and not f.startswith('__')]
        _dict = {}
        for name in ls:
            _dict[name] = getattr(MouseWheelBehavior, name)
        MouseWheelBehaviorEnum = IntEnum('MouseWheelBehaviorEnum', _dict)
    build_enum()
else:
    from ...lo.awt.mouse_wheel_behavior import MouseWheelBehavior as MouseWheelBehavior

    class MouseWheelBehaviorEnum(IntEnum):
        """
        Enum of Const Class MouseWheelBehavior

        describes the scroll behavior of the mouse wheel for a control
        
        **since**
        
            OOo 3.2
        """
        SCROLL_DISABLED = MouseWheelBehavior.SCROLL_DISABLED
        """
        defines that the mouse wheel cannot be used to scroll through the control's content
        """
        SCROLL_FOCUS_ONLY = MouseWheelBehavior.SCROLL_FOCUS_ONLY
        """
        defines that the mouse can only be used to scroll through the control's content if it currently has the focus.
        """
        SCROLL_ALWAYS = MouseWheelBehavior.SCROLL_ALWAYS
        """
        defines that the mouse can be used to scroll through the control's content, no matter whether or not it has the focus, as long as the mouse pointer is over the control.
        """

__all__ = ['MouseWheelBehavior', 'MouseWheelBehaviorEnum']
