# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Const Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.3
# Namespace: com.sun.star.datatransfer.clipboard
from enum import IntEnum
from typing import TYPE_CHECKING
from ooo.oenv.env_const import UNO_ENVIRONMENT, UNO_RUNTIME
_DYNAMIC = False
if (not TYPE_CHECKING) and UNO_RUNTIME and UNO_ENVIRONMENT:
    _DYNAMIC = True

if not TYPE_CHECKING and _DYNAMIC:
    from com.sun.star.datatransfer.clipboard import RenderingCapabilities as RenderingCapabilities
    if hasattr(RenderingCapabilities, '_constants') and isinstance(RenderingCapabilities._constants, dict):
        RenderingCapabilities._constants['__ooo_ns__'] = 'com.sun.star.datatransfer.clipboard'
        RenderingCapabilities._constants['__ooo_full_ns__'] = 'com.sun.star.datatransfer.clipboard.RenderingCapabilities'
        RenderingCapabilities._constants['__ooo_type_name__'] = 'const'
    def build_enum():
        global RenderingCapabilitiesEnum
        ls = [f for f in dir(RenderingCapabilities) if not callable(getattr(RenderingCapabilities, f)) and not f.startswith('__')]
        _dict = {}
        for name in ls:
            _dict[name] = getattr(RenderingCapabilities, name)
        RenderingCapabilitiesEnum = IntEnum('RenderingCapabilitiesEnum', _dict)
    build_enum()
else:
    from ....lo.datatransfer.clipboard.rendering_capabilities import RenderingCapabilities as RenderingCapabilities

    class RenderingCapabilitiesEnum(IntEnum):
        """
        Enum of Const Class RenderingCapabilities

        These flags describe the capabilities a system clipboard has to transfer data to other applications via the OS.
        """
        Delayed = RenderingCapabilities.Delayed
        """
        The implementation supports delayed rendering.
        """
        Persistant = RenderingCapabilities.Persistant
        """
        The implementation is able to store the data persistent in the system so that it does not get lost when the source application no longer exist.
        """
        Persistent = RenderingCapabilities.Persistent
        """
        The implementation is able to store the data persistent in the system so that it does not get lost when the source application no longer exist.
        """

__all__ = ['RenderingCapabilities', 'RenderingCapabilitiesEnum']
