# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Const Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.3
# Namespace: com.sun.star.drawing
from enum import IntEnum
from typing import TYPE_CHECKING
from ooo.oenv.env_const import UNO_ENVIRONMENT, UNO_RUNTIME
_DYNAMIC = False
if (not TYPE_CHECKING) and UNO_RUNTIME and UNO_ENVIRONMENT:
    _DYNAMIC = True

if not TYPE_CHECKING and _DYNAMIC:
    from com.sun.star.drawing import BarCodeErrorCorrection as BarCodeErrorCorrection
    if hasattr(BarCodeErrorCorrection, '_constants') and isinstance(BarCodeErrorCorrection._constants, dict):
        BarCodeErrorCorrection._constants['__ooo_ns__'] = 'com.sun.star.drawing'
        BarCodeErrorCorrection._constants['__ooo_full_ns__'] = 'com.sun.star.drawing.BarCodeErrorCorrection'
        BarCodeErrorCorrection._constants['__ooo_type_name__'] = 'const'
    def build_enum():
        global BarCodeErrorCorrectionEnum
        ls = [f for f in dir(BarCodeErrorCorrection) if not callable(getattr(BarCodeErrorCorrection, f)) and not f.startswith('__')]
        _dict = {}
        for name in ls:
            _dict[name] = getattr(BarCodeErrorCorrection, name)
        BarCodeErrorCorrectionEnum = IntEnum('BarCodeErrorCorrectionEnum', _dict)
    build_enum()
else:
    from ...lo.drawing.bar_code_error_correction import BarCodeErrorCorrection as BarCodeErrorCorrection

    class BarCodeErrorCorrectionEnum(IntEnum):
        """
        Enum of Const Class BarCodeErrorCorrection

        These constants identify the type of Error Correction for a Bar Code.
        
        The Error Correction for a Bar code is a measure that helps a Bar code to recover, if it is destroyed.
        
        Level L (Low) 7% of codewords can be restored. Level M (Medium) 15% of codewords can be restored. Level Q (Quartile) 25% of codewords can be restored. Level H (High) 30% of codewords can be restored.
        
        More Info - here
        
        **since**
        
            LibreOffice 7.3
        """
        LOW = BarCodeErrorCorrection.LOW
        MEDIUM = BarCodeErrorCorrection.MEDIUM
        QUARTILE = BarCodeErrorCorrection.QUARTILE
        HIGH = BarCodeErrorCorrection.HIGH

__all__ = ['BarCodeErrorCorrection', 'BarCodeErrorCorrectionEnum']
