# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Const Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.3
# Namespace: com.sun.star.i18n
from enum import IntEnum
from typing import TYPE_CHECKING
from ooo.oenv.env_const import UNO_ENVIRONMENT, UNO_RUNTIME
_DYNAMIC = False
if (not TYPE_CHECKING) and UNO_RUNTIME and UNO_ENVIRONMENT:
    _DYNAMIC = True

if not TYPE_CHECKING and _DYNAMIC:
    from com.sun.star.i18n import WordType as WordType
    if hasattr(WordType, '_constants') and isinstance(WordType._constants, dict):
        WordType._constants['__ooo_ns__'] = 'com.sun.star.i18n'
        WordType._constants['__ooo_full_ns__'] = 'com.sun.star.i18n.WordType'
        WordType._constants['__ooo_type_name__'] = 'const'
    def build_enum():
        global WordTypeEnum
        ls = [f for f in dir(WordType) if not callable(getattr(WordType, f)) and not f.startswith('__')]
        _dict = {}
        for name in ls:
            _dict[name] = getattr(WordType, name)
        WordTypeEnum = IntEnum('WordTypeEnum', _dict)
    build_enum()
else:
    from ...lo.i18n.word_type import WordType as WordType

    class WordTypeEnum(IntEnum):
        """
        Enum of Const Class WordType

        Constants to specify the type of words.
        
        Used with XBreakIterator.nextWord(), XBreakIterator.previousWord(), XBreakIterator.getWordBoundary(), XBreakIterator.getWordType(), XBreakIterator.isBeginWord(), XBreakIterator.isEndWord()
        """
        ANY_WORD = WordType.ANY_WORD
        """
        Any \"words\" - words in the meaning of same character types, collection of alphanumeric characters, or collection of non-alphanumeric characters.
        """
        ANYWORD_IGNOREWHITESPACES = WordType.ANYWORD_IGNOREWHITESPACES
        """
        Any \"words\" - words in the meaning of same character types, collection of alphanumeric characters, or collection of non-alphanumeric characters except blanks.
        """
        DICTIONARY_WORD = WordType.DICTIONARY_WORD
        """
        \"words\" - in the meaning of a collection of alphanumeric characters and some punctuations, like dot for abbreviation.
        """
        WORD_COUNT = WordType.WORD_COUNT
        """
        The mode for counting words, it will combine punctuations and spaces as word trail.
        """

__all__ = ['WordType', 'WordTypeEnum']
