# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.accessibility
# Libre Office Version: 7.3
from ooo.oenv.env_const import UNO_NONE
import typing
from ..uno.x_interface import XInterface as XInterface_8f010a43


class AccessibleRelation(object):
    """
    Struct Class

    An AccessibleRelation object defines a one-to-many relation.
    
    The represented relation points from the implementing object to a set of target objects.
    
    **since**
    
        OOo 1.1.2

    See Also:
        `API AccessibleRelation <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1accessibility_1_1AccessibleRelation.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.accessibility'
    __ooo_full_ns__: str = 'com.sun.star.accessibility.AccessibleRelation'
    __ooo_type_name__: str = 'struct'
    typeName: str = 'com.sun.star.accessibility.AccessibleRelation'
    """Literal Constant ``com.sun.star.accessibility.AccessibleRelation``"""

    def __init__(self, TargetSet: typing.Optional[typing.Tuple[XInterface_8f010a43, ...]] = UNO_NONE, RelationType: typing.Optional[int] = 0) -> None:
        """
        Constructor

        Arguments:
            TargetSet (typing.Tuple[XInterface, ...], optional): TargetSet value.
            RelationType (int, optional): RelationType value.
        """
        super().__init__()

        if isinstance(TargetSet, AccessibleRelation):
            oth: AccessibleRelation = TargetSet
            self.TargetSet = oth.TargetSet
            self.RelationType = oth.RelationType
            return

        kargs = {
            "TargetSet": TargetSet,
            "RelationType": RelationType,
        }
        if kargs["TargetSet"] is UNO_NONE:
            kargs["TargetSet"] = None
        self._init(**kargs)

    def _init(self, **kwargs) -> None:
        self._target_set = kwargs["TargetSet"]
        self._relation_type = kwargs["RelationType"]


    @property
    def TargetSet(self) -> typing.Tuple[XInterface_8f010a43, ...]:
        """
        Set of objects that are the relation's targets.
        
        The content of this set is undefined if the relation's type is INVALID. The set must not contain references to one object more than once.
        """
        return self._target_set
    
    @TargetSet.setter
    def TargetSet(self, value: typing.Tuple[XInterface_8f010a43, ...]) -> None:
        self._target_set = value

    @property
    def RelationType(self) -> int:
        """
        Type of the relation.
        
        Its value has to be one of the constants defined by AccessibleRelationType. If that value is INVALID then the whole relation is regarded as invalid. The content of the TargetSet is then undefined.
        """
        return self._relation_type
    
    @RelationType.setter
    def RelationType(self, value: int) -> None:
        self._relation_type = value


__all__ = ['AccessibleRelation']
