# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Const Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.3
# Namespace: com.sun.star.accessibility


class AccessibleRole(object):
    """
    Const Class

    Collection of roles.
    
    This collection of constants defines the set of possible roles of classes implementing the XAccessible interface according to the Java class javax.accessibility.AccessibleRole. The role of an object describes its generic function like \"button\", \"menu\", or \"text\". You can obtain an object's role by calling the getAccessibleRole() method of the XAccessibleContext interface.
    
    We are using constants instead of a more typesafe enum. The reason for this is that IDL enums may not be extended. Therefore, in order to include future extensions to the set of roles we have to use constants here.
    
    For some roles there exist two labels with the same value. Please use the one with the underscores. The other ones are somewhat deprecated and will be removed in the future.
    
    **since**
    
        OOo 1.1.2

    See Also:
        `API AccessibleRole <https://api.libreoffice.org/docs/idl/ref/namespacecom_1_1sun_1_1star_1_1accessibility_1_1AccessibleRole.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.accessibility'
    __ooo_full_ns__: str = 'com.sun.star.accessibility.AccessibleRole'
    __ooo_type_name__: str = 'const'

    UNKNOWN = 0
    """
    Unknown role.
    
    The object contains some Accessible information, but its role is not known.
    """
    ALERT = 1
    """
    Object is used to alert the user about something.
    """
    COLUMN_HEADER = 2
    """
    The header for a column of data.
    """
    CANVAS = 3
    """
    Object that can be drawn into and is used to trap events.
    
    See also FRAME, GLASS_PANE, and LAYERED_PANE.
    """
    CHECK_BOX = 4
    """
    Check box role.
    
    A choice that can be checked or unchecked and provides a separate indicator for the current state.
    
    See also PUSH_BUTTON, TOGGLE_BUTTON, and RADIO_BUTTON.
    """
    CHECK_MENU_ITEM = 5
    """
    This role is used for check buttons that are menu items.
    """
    COLOR_CHOOSER = 6
    """
    A specialized dialog that lets the user choose a color.
    """
    COMBO_BOX = 7
    """
    Combo box role.
    
    A list of choices the user can select from. Also optionally allows the user to enter a choice of their own.
    """
    DATE_EDITOR = 8
    """
    Date editor role.
    
    A DATE_EDITOR is a component that allows users to edit date and time.
    """
    DESKTOP_ICON = 9
    """
    An iconified internal frame in a DESKTOP_PANE.
    
    See also DESKTOP_PANE and INTERNAL_FRAME.
    """
    DESKTOP_PANE = 10
    """
    Desktop pane role.
    
    A pane that supports internal frames and iconified versions of those internal frames.
    """
    DIRECTORY_PANE = 11
    """
    Directory pane role.
    
    A pane that allows the user to navigate through and select the contents of a directory. May be used by a file chooser.
    
    See also FILE_CHOOSER.
    """
    DIALOG = 12
    """
    Dialog box role.
    
    A top level window with title bar and a border. A dialog is similar to a frame, but it has fewer properties and is often used as a secondary window for an application.
    
    See also FRAME and WINDOW.
    """
    DOCUMENT = 13
    """
    View of a document.
    
    The view of an actual document. Its content depends on the document type.
    """
    EMBEDDED_OBJECT = 14
    """
    Embedded (OLE) object.
    """
    END_NOTE = 15
    """
    Text that is used as an endnote (footnote at the end of a chapter or section.
    """
    FILE_CHOOSER = 16
    """
    File chooser role.
    
    A specialized dialog that displays the files in the directory and lets the user select a file, browse a different directory, or specify a filename. May use the directory pane to show the contents of a directory.
    
    See also DIRECTORY_PANE.
    """
    FILLER = 17
    """
    Filler role.
    
    An object that fills up space in a user interface. It is often used in interfaces to tweak the spacing between components, but serves no other purpose.
    """
    FONT_CHOOSER = 18
    """
    Font chooser role.
    
    A FONT_CHOOSER is a component that lets the user pick various attributes for fonts.
    """
    FOOTER = 19
    """
    Footer of a document page.
    """
    FOOTNOTE = 20
    """
    Text that is used as a footnote.
    """
    FRAME = 21
    """
    Frame role.
    
    A top level window with a title bar, border, menu bar, etc. It is often used as the primary window for an application.
    
    See also DIALOG, CANVAS, and WINDOW.
    """
    GLASS_PANE = 22
    """
    Glass pane role.
    
    A pane that is guaranteed to be painted on top of all panes beneath it.
    
    See also ROOT_PANE and CANVAS.
    """
    GRAPHIC = 23
    """
    Graphical object.
    """
    GROUP_BOX = 24
    """
    Group box role.
    
    A GROUP_BOX is a simple container that contains a border around it and contains components inside it.
    """
    HEADER = 25
    """
    Header of a document page.
    """
    HEADING = 26
    """
    Chapter or section heading.
    """
    HYPER_LINK = 27
    """
    A hypertext anchor.
    """
    ICON = 28
    """
    A small fixed size picture, typically used to decorate components.
    """
    INTERNAL_FRAME = 29
    """
    Internal frame role.
    
    A frame-like object that is clipped by a desktop pane. The desktop pane, internal frame, and desktop icon objects are often used to create multiple document interfaces within an application.
    
    See also DESKTOP_ICON, DESKTOP_PANE, and FRAME.
    """
    LABEL = 30
    """
    An object used to present an icon or short string in an interface.
    
    See also TEXT and STATIC.
    """
    LAYERED_PANE = 31
    """
    layered pane role.
    
    A specialized pane that allows its children to be drawn in layers, providing a form of stacking order. This is usually the pane that holds the menu bar as well as the pane that contains most of the visual components in a window.
    
    See also GLASS_PANE and ROOT_PANE.
    """
    LIST = 32
    """
    List role.
    
    An object that presents a list of objects to the user and allows the user to select one or more of them. A list is usually contained within a scroll pane.
    
    See also SCROLL_PANE and LIST_ITEM.
    """
    LIST_ITEM = 33
    """
    List item role.
    
    An object that presents an element in a list. A list is usually contained within a scroll pane.
    
    See also SCROLL_PANE and LIST.
    """
    MENU = 34
    """
    Menu role.
    
    An object usually found inside a menu bar that contains a list of actions the user can choose from. A menu can have any object as its children, but most often they are menu items, other menus, or rudimentary objects such as radio buttons, check boxes, or separators. For example, an application may have an \"Edit\" menu that contains menu items for \"Cut\" and \"Paste.\"
    
    See also MENU_BAR, MENU_ITEM, SEPARATOR, RADIO_BUTTON, CHECK_BOX, and POPUP_MENU.
    """
    MENU_BAR = 35
    """
    Menu bar role.
    
    An object usually drawn at the top of the primary dialog box of an application that contains a list of menus the user can choose from. For example, a menu bar might contain menus for \"File,\" \"Edit,\" and \"Help.\"
    
    See also MENU, POPUP_MENU, and LAYERED_PANE.
    """
    MENU_ITEM = 36
    """
    Menu item role.
    
    An object usually contained in a menu that presents an action the user can choose. For example, the \"Cut\" menu item in an \"Edit\" menu would be an action the user can select to cut the selected area of text in a document.
    
    See also MENUBAR, SEPARATOR, and POPUP_MENU.
    """
    OPTION_PANE = 37
    """
    A specialized pane whose primary use is inside a DIALOG.
    
    See also DIALOG.
    """
    PAGE_TAB = 38
    """
    Page tab role.
    
    An object that is a child of a page tab list. Its sole child is the panel that is to be presented to the user when the user selects the page tab from the list of tabs in the page tab list.
    
    See also PAGE_TAB_LIST.
    """
    PAGE_TAB_LIST = 39
    """
    Page tab list role.
    
    An object that presents a series of panels (or page tabs), one at a time, through some mechanism provided by the object. The most common mechanism is a list of tabs at the top of the panel. The children of a page tab list are all page tabs.
    
    See also PAGE_TAB.
    """
    PANEL = 40
    """
    A generic container that is often used to group objects.
    """
    PARAGRAPH = 41
    """
    Paragraph of text.
    """
    PASSWORD_TEXT = 42
    """
    Password text role.
    
    A text object used for passwords, or other places where the text contents is not shown visibly to the user.
    """
    POPUP_MENU = 43
    """
    Pop-up menu role.
    
    A temporary window that is usually used to offer the user a list of choices, and then hides when the user selects one of those choices.
    
    See also MENU and MENU_ITEM.
    """
    PUSH_BUTTON = 44
    """
    Push button role.
    
    An object the user can manipulate to tell the application to do something.
    
    See also CHECK_BOX, TOGGLE_BUTTON, RADIO_BUTTON, BUTTON_MENU and BUTTON_DROPDOWN.
    """
    PROGRESS_BAR = 45
    """
    An object used to indicate how much of a task has been completed.
    """
    RADIO_BUTTON = 46
    """
    Radio button role.
    
    A specialized check box that will cause other radio buttons in the same group to become unchecked when this one is checked.
    
    See also PUSH_BUTTON, TOGGLE_BUTTON, and CHECK_BOX.
    """
    RADIO_MENU_ITEM = 47
    """
    This role is used for radio buttons that are menu items.
    """
    ROW_HEADER = 48
    """
    The header for a row of data.
    """
    ROOT_PANE = 49
    """
    Root pane role.
    
    A specialized pane that has a glass pane and a layered pane as its children.
    
    See also GLASS_PANE and LAYERED_PANE.
    """
    SCROLL_BAR = 50
    """
    Scroll bar role.
    
    An object usually used to allow a user to incrementally view a large amount of data. Usually used only by a scroll pane.
    
    See also SCROLL_PANE.
    """
    SCROLL_PANE = 51
    """
    Scroll pane role.
    
    An object that allows a user to incrementally view a large amount of information. Its children can include scroll bars and a viewport.
    
    See also SCROLL_BAR and VIEW_PORT.
    """
    SHAPE = 52
    """
    Object with graphical representation used to represent content on draw pages.
    """
    SEPARATOR = 53
    """
    Separator role.
    
    An object usually contained in a menu to provide a visual and logical separation of the contents in a menu. For example, the \"File\" menu of an application might contain menu items for \"Open,\" \"Close,\" and \"Exit,\" and will place a separator between \"Close\" and \"Exit\" menu items.
    
    See also MENU and MENU_ITEM.
    """
    SLIDER = 54
    """
    Slider role.
    
    An object that allows the user to select from a bounded range. For example, a slider might be used to select a number between 0 and 100.
    """
    SPIN_BOX = 55
    """
    Spin box role.
    
    A SPIN_BOX is a simple spinner component and its main use is for simple numbers.
    """
    SPLIT_PANE = 56
    """
    Split pane role.
    
    A specialized panel that presents two other panels at the same time. Between the two panels is a divider the user can manipulate to make one panel larger and the other panel smaller.
    """
    STATUS_BAR = 57
    """
    Status bar role.
    
    A STATUS_BAR is an simple component that can contain multiple labels of status information to the user.
    """
    TABLE = 58
    """
    Table component.
    
    An object used to present information in terms of rows and columns. An example might include a spreadsheet application.
    """
    TABLE_CELL = 59
    """
    Single cell in a table.
    """
    TEXT = 60
    """
    Text role.
    
    An object that presents text to the user. The text is usually editable by the user as opposed to a label or static text.
    
    See also LABEL and STATIC.
    """
    TEXT_FRAME = 61
    """
    Collection of objects that constitute a logical text entity.
    """
    TOGGLE_BUTTON = 62
    """
    Toggle button role.
    
    A specialized push button that can be checked or unchecked, but does not provide a separate indicator for the current state.
    
    See also PUSH_BUTTON, CHECK_BOX and RADIO_BUTTON.
    """
    TOOL_BAR = 63
    """
    Tool bar role.
    
    A bar or palette usually composed of push buttons or toggle buttons. It is often used to provide the most frequently used functions for an application.
    """
    TOOL_TIP = 64
    """
    Tool tip role.
    
    An object that provides information about another object. The accessible Description property of the tool tip is often displayed to the user in a small \"help bubble\" when the user causes the mouse to hover over the object associated with the tool tip.
    """
    TREE = 65
    """
    Tree role.
    
    An object used to present hierarchical information to the user. The individual nodes in the tree can be collapsed and expanded to provide selective disclosure of the tree's contents.
    """
    VIEW_PORT = 66
    """
    Viewport role.
    
    An object usually used in a scroll pane. It represents the portion of the entire data that the user can see. As the user manipulates the scroll bars, the contents of the viewport can change.
    
    See also SCROLL_PANE.
    """
    WINDOW = 67
    """
    A top level window with no title or border.
    
    See also FRAME and DIALOG.
    """
    BUTTON_DROPDOWN = 68
    """
    Button dropdown role.
    
    The object represents a button that drops down a list of items.
    
    See also PUSH_BUTTON and BUTTON_MENU.
    
    **since**
    
        OOo 3.0
    """
    BUTTON_MENU = 69
    """
    Button menu role.
    
    The object represents a button that drops down a menu.
    
    See also PUSH_BUTTON and BUTTON_DROPDOWN.
    
    **since**
    
        OOo 3.0
    """
    CAPTION = 70
    """
    Caption role.
    
    The object contains descriptive information, usually textual, about another user interface element such as a table, chart, or image.
    
    .
    
    **since**
    
        OOo 3.0
    """
    CHART = 71
    """
    Chart role.
    
    The object is a graphical depiction of quantitative data. It may contain multiple subelements whose attributes and/or description may be queried to obtain both the quantitative data and information about how the data is being presented.
    
    **since**
    
        OOo 3.0
    """
    EDIT_BAR = 72
    """
    Edit bar role.
    
    A role indicating the object acts as a formula for calculating a value.
    
    **since**
    
        OOo 3.0
    """
    FORM = 73
    """
    Form role.
    
    The object is a container for form controls, for instance as part of a web form or user-input form within a document.
    
    **since**
    
        OOo 3.0
    """
    IMAGE_MAP = 74
    """
    Image map role.
    
    Usually a graphic with multiple hotspots, where each hotspot can be activated resulting in the loading of another document or section of a document.
    
    **since**
    
        OOo 3.0
    """
    NOTE = 75
    """
    Note role.
    
    An embedded note which is not visible until activated.
    
    **since**
    
        OOo 3.0
    """
    PAGE = 76
    """
    Page role.
    
    An object representing a page of document content. It is used in documents which are accessed by the user on a page by page basis.
    
    **since**
    
        OOo 3.0
    """
    RULER = 77
    """
    Ruler role.
    
    An object which describes margins and tab stops, etc. for text objects which it controls.
    
    **since**
    
        OOo 3.0
    """
    SECTION = 78
    """
    Section role.
    
    The object is a containing instance of document content which constitutes a particular \"logical\" section of the document.
    
    **since**
    
        OOo 3.0
    """
    TREE_ITEM = 79
    """
    Tree item role.
    
    An object that presents an element in a tree
    
    See also TREE and TREE_TABLE.
    
    **since**
    
        OOo 3.0
    """
    TREE_TABLE = 80
    """
    Tree table role.
    
    An object which represents both hierarchical and tabular information.
    
    **since**
    
        OOo 3.0
    """
    COMMENT = 81
    """
    Comment role.
    
    An object which represents a comment.
    
    A comment is anchored at a certain content position in the document and annotates this document content position or a certain text range of the document content. In the OpenDocument file format a comment is known as an annotation.
    
    See also COMMENT_END.
    
    **since**
    
        OOo 3.2
    """
    COMMENT_END = 82
    """
    Comment end role.
    
    An invisible object which represents the end position of a text range which is annotated by a comment - see COMMENT.
    
    This object and the corresponding object representing the comment shall be in relation of type MEMBER_OF.
    
    **since**
    
        OOo 3.2
    """
    DOCUMENT_PRESENTATION = 83
    """
    View of a presentation document.
    
    It's an specific variation of DOCUMENT for presentations.
    
    **since**
    
        LibreOffice 4.3
    """
    DOCUMENT_SPREADSHEET = 84
    """
    View of an spreadsheet document.
    
    It's an specific variation of DOCUMENT for spreadsheets.
    
    **since**
    
        LibreOffice 4.3
    """
    DOCUMENT_TEXT = 85
    """
    View of a text document.
    
    It's an specific variation of DOCUMENT for text.
    
    **since**
    
        LibreOffice 4.3
    """
    STATIC = 86
    """
    Static text role.
    
    An object that presents a brief amount of information to the user. The text is not editable by the user as opposed to a text, and not meant to have a relation with another object as opposed to a label.
    
    See also LABEL and TEXT.
    """

__all__ = ['AccessibleRole']
