# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.animations
# Libre Office Version: 7.3
from ooo.oenv.env_const import UNO_NONE
import typing


class Event(object):
    """
    Struct Class

    an event has a source that causes an event to be fired and a trigger that defines under which condition an event should be raised and an offset if the event should be raised a defined amount of time after the event is triggered.

    See Also:
        `API Event <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1animations_1_1Event.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.animations'
    __ooo_full_ns__: str = 'com.sun.star.animations.Event'
    __ooo_type_name__: str = 'struct'
    typeName: str = 'com.sun.star.animations.Event'
    """Literal Constant ``com.sun.star.animations.Event``"""

    def __init__(self, Source: typing.Optional[object] = None, Trigger: typing.Optional[int] = 0, Offset: typing.Optional[object] = None, Repeat: typing.Optional[int] = 0) -> None:
        """
        Constructor

        Arguments:
            Source (object, optional): Source value.
            Trigger (int, optional): Trigger value.
            Offset (object, optional): Offset value.
            Repeat (int, optional): Repeat value.
        """
        super().__init__()

        if isinstance(Source, Event):
            oth: Event = Source
            self.Source = oth.Source
            self.Trigger = oth.Trigger
            self.Offset = oth.Offset
            self.Repeat = oth.Repeat
            return

        kargs = {
            "Source": Source,
            "Trigger": Trigger,
            "Offset": Offset,
            "Repeat": Repeat,
        }
        self._init(**kargs)

    def _init(self, **kwargs) -> None:
        self._source = kwargs["Source"]
        self._trigger = kwargs["Trigger"]
        self._offset = kwargs["Offset"]
        self._repeat = kwargs["Repeat"]


    @property
    def Source(self) -> object:
        """
        this is the source for this event.
        """
        return self._source
    
    @Source.setter
    def Source(self, value: object) -> None:
        self._source = value

    @property
    def Trigger(self) -> int:
        """
        this is the trigger that fires this event.
        """
        return self._trigger
    
    @Trigger.setter
    def Trigger(self, value: int) -> None:
        self._trigger = value

    @property
    def Offset(self) -> object:
        """
        an optional offset in seconds or Timing.INDEFINITE.
        
        This is the timespan between the triggering of the event and actually raising the event
        """
        return self._offset
    
    @Offset.setter
    def Offset(self, value: object) -> None:
        self._offset = value

    @property
    def Repeat(self) -> int:
        """
        an option repeat value.
        
        If the Trigger is EventTrigger, this is the number of repeats after which the event is initially raised.
        """
        return self._repeat
    
    @Repeat.setter
    def Repeat(self, value: int) -> None:
        self._repeat = value


__all__ = ['Event']
