# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.awt
# Libre Office Version: 7.3
from ooo.oenv.env_const import UNO_NONE
from ..lang.event_object import EventObject as EventObject_a3d70b03
from ..uno.x_interface import XInterface as XInterface_8f010a43
import typing


class InputEvent(EventObject_a3d70b03):
    """
    Struct Class

    the root event class for all component-level input events.
    
    Input events are delivered to listeners before they are processed normally by the source where they originated.

    See Also:
        `API InputEvent <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1awt_1_1InputEvent.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.awt'
    __ooo_full_ns__: str = 'com.sun.star.awt.InputEvent'
    __ooo_type_name__: str = 'struct'
    typeName: str = 'com.sun.star.awt.InputEvent'
    """Literal Constant ``com.sun.star.awt.InputEvent``"""

    def __init__(self, Source: typing.Optional[XInterface_8f010a43] = None, Modifiers: typing.Optional[int] = 0) -> None:
        """
        Constructor

        Arguments:
            Source (XInterface, optional): Source value.
            Modifiers (int, optional): Modifiers value.
        """

        if isinstance(Source, InputEvent):
            oth: InputEvent = Source
            self.Source = oth.Source
            self.Modifiers = oth.Modifiers
            return

        kargs = {
            "Source": Source,
            "Modifiers": Modifiers,
        }
        self._init(**kargs)

    def _init(self, **kwargs) -> None:
        self._modifiers = kwargs["Modifiers"]
        inst_keys = ('Modifiers',)
        kargs = kwargs.copy()
        for key in inst_keys:
            del kargs[key]
        super()._init(**kargs)


    @property
    def Modifiers(self) -> int:
        """
        contains the modifier keys which were pressed while the event occurred.
        
        Zero or more constants from the com.sun.star.awt.KeyModifier group.
        """
        return self._modifiers
    
    @Modifiers.setter
    def Modifiers(self, value: int) -> None:
        self._modifiers = value


__all__ = ['InputEvent']
