# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.awt
# Libre Office Version: 7.3
from ooo.oenv.env_const import UNO_NONE
import typing


class SimpleFontMetric(object):
    """
    Struct Class

    describes the general metrics of a certain font.

    See Also:
        `API SimpleFontMetric <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1awt_1_1SimpleFontMetric.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.awt'
    __ooo_full_ns__: str = 'com.sun.star.awt.SimpleFontMetric'
    __ooo_type_name__: str = 'struct'
    typeName: str = 'com.sun.star.awt.SimpleFontMetric'
    """Literal Constant ``com.sun.star.awt.SimpleFontMetric``"""

    def __init__(self, Ascent: typing.Optional[int] = 0, Descent: typing.Optional[int] = 0, Leading: typing.Optional[int] = 0, Slant: typing.Optional[int] = 0, FirstChar: typing.Optional[str] = '\u0000', LastChar: typing.Optional[str] = '\u0000') -> None:
        """
        Constructor

        Arguments:
            Ascent (int, optional): Ascent value.
            Descent (int, optional): Descent value.
            Leading (int, optional): Leading value.
            Slant (int, optional): Slant value.
            FirstChar (str, optional): FirstChar value.
            LastChar (str, optional): LastChar value.
        """
        super().__init__()

        if isinstance(Ascent, SimpleFontMetric):
            oth: SimpleFontMetric = Ascent
            self.Ascent = oth.Ascent
            self.Descent = oth.Descent
            self.Leading = oth.Leading
            self.Slant = oth.Slant
            self.FirstChar = oth.FirstChar
            self.LastChar = oth.LastChar
            return

        kargs = {
            "Ascent": Ascent,
            "Descent": Descent,
            "Leading": Leading,
            "Slant": Slant,
            "FirstChar": FirstChar,
            "LastChar": LastChar,
        }
        self._init(**kargs)

    def _init(self, **kwargs) -> None:
        self._ascent = kwargs["Ascent"]
        self._descent = kwargs["Descent"]
        self._leading = kwargs["Leading"]
        self._slant = kwargs["Slant"]
        self._first_char = kwargs["FirstChar"]
        self._last_char = kwargs["LastChar"]


    @property
    def Ascent(self) -> int:
        """
        specifies the portion of a lower case character that rises above the height of the character \"x\" of the font.
        
        For example, the letters \"b\", \"d\", \"h\", \"k\" and \"l\" have an ascent unequal to 0.
        
        The ascent is measured in pixels, thus the font metric is device dependent.
        """
        return self._ascent
    
    @Ascent.setter
    def Ascent(self, value: int) -> None:
        self._ascent = value

    @property
    def Descent(self) -> int:
        """
        specifies the portion of a letter falling below the baseline.
        
        For example, the letters \"g\", \"p\", and \"y\" have a descent unequal to 0.
        
        The descent is measured in pixels, thus the font metric is device dependent.
        """
        return self._descent
    
    @Descent.setter
    def Descent(self, value: int) -> None:
        self._descent = value

    @property
    def Leading(self) -> int:
        """
        specifies the vertical space between lines of this font; it is also called internal line spacing.
        
        The leading is measured in pixels, thus the font metric is device dependent.
        """
        return self._leading
    
    @Leading.setter
    def Leading(self, value: int) -> None:
        self._leading = value

    @property
    def Slant(self) -> int:
        """
        specifies the slant of the characters (italic).
        
        The slant is measured in degrees from 0 to 359.
        """
        return self._slant
    
    @Slant.setter
    def Slant(self, value: int) -> None:
        self._slant = value

    @property
    def FirstChar(self) -> str:
        """
        specifies the code of the first printable character in the font.
        """
        return self._first_char
    
    @FirstChar.setter
    def FirstChar(self, value: str) -> None:
        self._first_char = value

    @property
    def LastChar(self) -> str:
        """
        specifies the code of the last printable character in the font.
        """
        return self._last_char
    
    @LastChar.setter
    def LastChar(self, value: str) -> None:
        self._last_char = value


__all__ = ['SimpleFontMetric']
