# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Service Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.3
# Namespace: com.sun.star.awt
import typing
from abc import abstractproperty
from .uno_control_model import UnoControlModel as UnoControlModel_c8ce0c58
from ..container.x_index_container import XIndexContainer as XIndexContainer_1c040ebe
if typing.TYPE_CHECKING:
    from ..graphic.x_graphic import XGraphic as XGraphic_a4da0afc

class UnoControlRoadmapModel(UnoControlModel_c8ce0c58, XIndexContainer_1c040ebe):
    """
    Service Class

    specifies the standard model of a UnoControlContainer.
    
    **since**
    
        OOo 2.1

    See Also:
        `API UnoControlRoadmapModel <https://api.libreoffice.org/docs/idl/ref/servicecom_1_1sun_1_1star_1_1awt_1_1UnoControlRoadmapModel.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.awt'
    __ooo_full_ns__: str = 'com.sun.star.awt.UnoControlRoadmapModel'
    __ooo_type_name__: str = 'service'

    @abstractproperty
    def BackgroundColor(self) -> int:
        """
        specifies the background color (RGB) of the control.
        
        The Default value is white
        """

    @abstractproperty
    def Border(self) -> int:
        """
        specifies the border style of the control.
        """

    @abstractproperty
    def Complete(self) -> bool:
        """
        determines whether the control container is complete or not.
        
        If it is false than a non - interactive RoadmapItem is appended
        """

    @abstractproperty
    def CurrentItemID(self) -> int:
        """
        refers to the ID of the currently selected item.
        
        Initially this property is set to \"-1\" which is equal to \"undefined\" If the Roadmap Item that the CurrentItemID refers to is removed the property \"CurrentItemID\" is set to -1
        """

    @abstractproperty
    def Graphic(self) -> 'XGraphic_a4da0afc':
        """
        specifies a graphic to be displayed on the control
        
        If this property is present, it interacts with the ImageURL in the following way:
        
        **since**
        
            OOo 2.1
        """

    @abstractproperty
    def HelpText(self) -> str:
        """
        specifies the help text of the control.
        """

    @abstractproperty
    def HelpURL(self) -> str:
        """
        specifies the help URL of the control.
        """

    @abstractproperty
    def ImageURL(self) -> str:
        """
        specifies a URL to an image to use for the control.
        
        The image is placed in the lower right corner of the control
        """

    @abstractproperty
    def Interactive(self) -> bool:
        """
        determines whether the control is interactive or not.
        
        A roadmap control which is interactive allows selecting its items out-of-order, by simply clicking them.
        """

    @abstractproperty
    def Printable(self) -> bool:
        """
        specifies whether the control will be printed with the document.
        """

    @abstractproperty
    def Text(self) -> str:
        """
        specifies the text displayed in the control.
        """



__all__ = ['UnoControlRoadmapModel']

