# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Interface Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.3
# Namespace: com.sun.star.awt
import typing
from abc import abstractmethod
from ..uno.x_interface import XInterface as XInterface_8f010a43
if typing.TYPE_CHECKING:
    from .x_item_listener import XItemListener as XItemListener_af710b81

class XCheckBox(XInterface_8f010a43):
    """
    gives access to the state of a check box and makes it possible to register for events.

    See Also:
        `API XCheckBox <https://api.libreoffice.org/docs/idl/ref/interfacecom_1_1sun_1_1star_1_1awt_1_1XCheckBox.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.awt'
    __ooo_full_ns__: str = 'com.sun.star.awt.XCheckBox'
    __ooo_type_name__: str = 'interface'
    __pyunointerface__: str = 'com.sun.star.awt.XCheckBox'

    @abstractmethod
    def addItemListener(self, l: 'XItemListener_af710b81') -> None:
        """
        registers a listener for item events.
        """
    @abstractmethod
    def enableTriState(self, b: bool) -> None:
        """
        enables or disables the tri state mode.
        """
    @abstractmethod
    def getState(self) -> int:
        """
        returns the state of the check box.
        """
    @abstractmethod
    def removeItemListener(self, l: 'XItemListener_af710b81') -> None:
        """
        unregisters a listener for item events.
        """
    @abstractmethod
    def setLabel(self, Label: str) -> None:
        """
        sets the label of the check box.
        """
    @abstractmethod
    def setState(self, n: int) -> None:
        """
        sets the state of the check box.
        """

__all__ = ['XCheckBox']

