# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Service Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.3
# Namespace: com.sun.star.chart
from abc import abstractproperty
from .chart_axis_x_supplier import ChartAxisXSupplier as ChartAxisXSupplier_a950e4d
from .chart_axis_z_supplier import ChartAxisZSupplier as ChartAxisZSupplier_aa70e4f
from .chart_statistics import ChartStatistics as ChartStatistics_e2190d37
from .chart_two_axis_y_supplier import ChartTwoAxisYSupplier as ChartTwoAxisYSupplier_380d0f88
from .diagram import Diagram as Diagram_844409cf
from .dim3_d_diagram import Dim3DDiagram as Dim3DDiagram_b7a60b60
from .stackable_diagram import StackableDiagram as StackableDiagram_ee760d59

class BarDiagram(ChartAxisXSupplier_a950e4d, ChartAxisZSupplier_aa70e4f, ChartStatistics_e2190d37, ChartTwoAxisYSupplier_380d0f88, Diagram_844409cf, Dim3DDiagram_b7a60b60, StackableDiagram_ee760d59):
    """
    Service Class

    This is a service for bar and column diagrams.

    See Also:
        `API BarDiagram <https://api.libreoffice.org/docs/idl/ref/servicecom_1_1sun_1_1star_1_1chart_1_1BarDiagram.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.chart'
    __ooo_full_ns__: str = 'com.sun.star.chart.BarDiagram'
    __ooo_type_name__: str = 'service'

    @abstractproperty
    def Deep(self) -> bool:
        """
        If TRUE, determines that in a three-dimensional bar chart the bars of each series are arranged behind each other in the z-direction.
        
        If FALSE the arrangement of bars is like in two-dimensional bar charts.
        """

    @abstractproperty
    def GroupBarsPerAxis(self) -> bool:
        """
        If bars of a bar or column chart are attached to different axis, this property determines how to display those.
        
        If TRUE, the bars are grouped together in one block for each axis, thus they are painted one group over the other.
        
        If FALSE, the bars are displayed side-by-side, as if they were all attached to the same axis.
        
        If all data series of a bar or column chart are attached to only one axis, this property has no effect.
        """

    @abstractproperty
    def NumberOfLines(self) -> int:
        """
        Determines how many data rows are displayed as lines rather than bars.
        
        If this property differs from zero the last BarDiagram.NumberOfLines data rows are shown as lines. It is currently supported by two dimensional vertical bar charts only.
        """

    @abstractproperty
    def StackedBarsConnected(self) -> bool:
        """
        determines if, in a stacked chart, there are connecting lines between corresponding bars.
        
        Currently, bar charts with horizontal bars do not support this property.
        """

    @abstractproperty
    def Vertical(self) -> bool:
        """
        Determines if the bars of a chart are drawn vertically or horizontally.
        
        Default is vertical.
        
        If Vertical is FALSE you get a column chart rather than a bar chart.
        """



__all__ = ['BarDiagram']

