# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.drawing
# Libre Office Version: 7.3
from ooo.oenv.env_const import UNO_NONE
import typing
from .homogen_matrix_line3 import HomogenMatrixLine3 as HomogenMatrixLine3_2b160ef1


class HomogenMatrix3(object):
    """
    Struct Class

    specifies a homogeneous matrix by three homogeneous lines

    See Also:
        `API HomogenMatrix3 <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1drawing_1_1HomogenMatrix3.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.drawing'
    __ooo_full_ns__: str = 'com.sun.star.drawing.HomogenMatrix3'
    __ooo_type_name__: str = 'struct'
    typeName: str = 'com.sun.star.drawing.HomogenMatrix3'
    """Literal Constant ``com.sun.star.drawing.HomogenMatrix3``"""

    def __init__(self, Line1: typing.Optional[HomogenMatrixLine3_2b160ef1] = UNO_NONE, Line2: typing.Optional[HomogenMatrixLine3_2b160ef1] = UNO_NONE, Line3: typing.Optional[HomogenMatrixLine3_2b160ef1] = UNO_NONE) -> None:
        """
        Constructor

        Arguments:
            Line1 (HomogenMatrixLine3, optional): Line1 value.
            Line2 (HomogenMatrixLine3, optional): Line2 value.
            Line3 (HomogenMatrixLine3, optional): Line3 value.
        """
        super().__init__()

        if isinstance(Line1, HomogenMatrix3):
            oth: HomogenMatrix3 = Line1
            self.Line1 = oth.Line1
            self.Line2 = oth.Line2
            self.Line3 = oth.Line3
            return

        kargs = {
            "Line1": Line1,
            "Line2": Line2,
            "Line3": Line3,
        }
        if kargs["Line1"] is UNO_NONE:
            kargs["Line1"] = None
        if kargs["Line2"] is UNO_NONE:
            kargs["Line2"] = None
        if kargs["Line3"] is UNO_NONE:
            kargs["Line3"] = None
        self._init(**kargs)

    def _init(self, **kwargs) -> None:
        self._line1 = kwargs["Line1"]
        self._line2 = kwargs["Line2"]
        self._line3 = kwargs["Line3"]


    @property
    def Line1(self) -> HomogenMatrixLine3_2b160ef1:
        return self._line1
    
    @Line1.setter
    def Line1(self, value: HomogenMatrixLine3_2b160ef1) -> None:
        self._line1 = value

    @property
    def Line2(self) -> HomogenMatrixLine3_2b160ef1:
        return self._line2
    
    @Line2.setter
    def Line2(self, value: HomogenMatrixLine3_2b160ef1) -> None:
        self._line2 = value

    @property
    def Line3(self) -> HomogenMatrixLine3_2b160ef1:
        return self._line3
    
    @Line3.setter
    def Line3(self, value: HomogenMatrixLine3_2b160ef1) -> None:
        self._line3 = value


__all__ = ['HomogenMatrix3']
