# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Interface Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.3
# Namespace: com.sun.star.form.binding
import typing
from abc import abstractmethod
from ...uno.x_interface import XInterface as XInterface_8f010a43

class XValueBinding(XInterface_8f010a43):
    """
    specifies a binding to a value which can be read and written.

    See Also:
        `API XValueBinding <https://api.libreoffice.org/docs/idl/ref/interfacecom_1_1sun_1_1star_1_1form_1_1binding_1_1XValueBinding.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.form.binding'
    __ooo_full_ns__: str = 'com.sun.star.form.binding.XValueBinding'
    __ooo_type_name__: str = 'interface'
    __pyunointerface__: str = 'com.sun.star.form.binding.XValueBinding'

    @abstractmethod
    def getSupportedValueTypes(self) -> 'typing.Tuple[object, ...]':
        """
        determines the types which are supported by this binding for value exchange
        """
    @abstractmethod
    def getValue(self, aType: object) -> object:
        """
        retrieves the current value

        Raises:
            IncompatibleTypesException: ``IncompatibleTypesException``
        """
    @abstractmethod
    def setValue(self, aValue: object) -> None:
        """
        sets the current value

        Raises:
            IncompatibleTypesException: ``IncompatibleTypesException``
            InvalidBindingStateException: ``InvalidBindingStateException``
            com.sun.star.lang.NoSupportException: ``NoSupportException``
        """
    @abstractmethod
    def supportsType(self, aType: object) -> bool:
        """
        determines whether a given type is supported by this binding for value exchange
        
        Calling this method is equal to calling getSupportedValueTypes(), and looking up the given type in the resulting type sequence.
        """

__all__ = ['XValueBinding']

