# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Const Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.3
# Namespace: com.sun.star.form


class FormComponentType(object):
    """
    Const Class

    These constants specify the class types used to identify a component.

    See Also:
        `API FormComponentType <https://api.libreoffice.org/docs/idl/ref/namespacecom_1_1sun_1_1star_1_1form_1_1FormComponentType.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.form'
    __ooo_full_ns__: str = 'com.sun.star.form.FormComponentType'
    __ooo_type_name__: str = 'const'

    CONTROL = 1
    """
    This generic identifier is for controls which cannot be identified by another specific identifier.
    """
    COMMANDBUTTON = 2
    """
    specifies a control that is used to begin, interrupt, or end a process.
    """
    RADIOBUTTON = 3
    """
    specifies a control that acts like a radio button.
    
    Grouped together, such radio buttons present a set of two or more mutually exclusive choices to the user.
    """
    IMAGEBUTTON = 4
    """
    specifies a control that displays an image that responds to mouse clicks.
    """
    CHECKBOX = 5
    """
    specifies a control that is used to check or uncheck to turn an option on or off.
    """
    LISTBOX = 6
    """
    specifies a control that displays a list from which the user can select one or more items.
    """
    COMBOBOX = 7
    """
    specifies a control that is used when a list box combined with a static text control or an edit control is needed.
    """
    GROUPBOX = 8
    """
    specifies a control that displays a frame around a group of controls with or without a caption.
    """
    TEXTFIELD = 9
    """
    specifies a control that is a text component that allows for the editing of a single line of text.
    """
    FIXEDTEXT = 10
    """
    specifies a control to display a fixed text, usually used to label other controls.
    """
    GRIDCONTROL = 11
    """
    is a table like control to display database data.
    """
    FILECONTROL = 12
    """
    specifies a control which can be used to enter text, extended by an (user-startable) file dialog to browse for files.
    """
    HIDDENCONTROL = 13
    """
    specifies a control that should not be visible.
    """
    IMAGECONTROL = 14
    """
    specifies a control to display an image.
    """
    DATEFIELD = 15
    """
    specifies a control to display and edit a date value.
    """
    TIMEFIELD = 16
    """
    specifies a control to display and edit a time value.
    """
    NUMERICFIELD = 17
    """
    specifies a field to display and edit a numeric value.
    """
    CURRENCYFIELD = 18
    """
    specifies a field to display and edit a currency value.
    """
    PATTERNFIELD = 19
    """
    specifies a control to display and edit a string according to a pattern.
    """
    SCROLLBAR = 20
    """
    specifies a control to display and edit, in the form of a scrollbar, a value from a continuous value range
    """
    SPINBUTTON = 21
    """
    specifies a control to edit, in the form of a spin field, a value from a continuous range of values
    """
    NAVIGATIONBAR = 22
    """
    specifies a control which provides controller functionality for the com.sun.star.form.component.DataForm it belongs to, such as functionality to navigate or filter this form.
    """

__all__ = ['FormComponentType']
