# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.form.runtime
# Libre Office Version: 7.3
from ooo.oenv.env_const import UNO_NONE
from ...lang.event_object import EventObject as EventObject_a3d70b03
from ...uno.x_interface import XInterface as XInterface_8f010a43
import typing


class FilterEvent(EventObject_a3d70b03):
    """
    Struct Class

    is an event fired by a filter controller, when the filter managed by the controller changes.
    
    **since**
    
        OOo 3.3

    See Also:
        `API FilterEvent <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1form_1_1runtime_1_1FilterEvent.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.form.runtime'
    __ooo_full_ns__: str = 'com.sun.star.form.runtime.FilterEvent'
    __ooo_type_name__: str = 'struct'
    typeName: str = 'com.sun.star.form.runtime.FilterEvent'
    """Literal Constant ``com.sun.star.form.runtime.FilterEvent``"""

    def __init__(self, Source: typing.Optional[XInterface_8f010a43] = None, DisjunctiveTerm: typing.Optional[int] = 0, FilterComponent: typing.Optional[int] = 0, PredicateExpression: typing.Optional[str] = '') -> None:
        """
        Constructor

        Arguments:
            Source (XInterface, optional): Source value.
            DisjunctiveTerm (int, optional): DisjunctiveTerm value.
            FilterComponent (int, optional): FilterComponent value.
            PredicateExpression (str, optional): PredicateExpression value.
        """

        if isinstance(Source, FilterEvent):
            oth: FilterEvent = Source
            self.Source = oth.Source
            self.DisjunctiveTerm = oth.DisjunctiveTerm
            self.FilterComponent = oth.FilterComponent
            self.PredicateExpression = oth.PredicateExpression
            return

        kargs = {
            "Source": Source,
            "DisjunctiveTerm": DisjunctiveTerm,
            "FilterComponent": FilterComponent,
            "PredicateExpression": PredicateExpression,
        }
        self._init(**kargs)

    def _init(self, **kwargs) -> None:
        self._disjunctive_term = kwargs["DisjunctiveTerm"]
        self._filter_component = kwargs["FilterComponent"]
        self._predicate_expression = kwargs["PredicateExpression"]
        inst_keys = ('DisjunctiveTerm', 'FilterComponent', 'PredicateExpression')
        kargs = kwargs.copy()
        for key in inst_keys:
            del kargs[key]
        super()._init(**kargs)


    @property
    def DisjunctiveTerm(self) -> int:
        """
        denotes the index of the disjunctive term to which the event applies, if any.
        """
        return self._disjunctive_term
    
    @DisjunctiveTerm.setter
    def DisjunctiveTerm(self, value: int) -> None:
        self._disjunctive_term = value

    @property
    def FilterComponent(self) -> int:
        """
        denotes the index of the filter component to which the event applies, if any.
        """
        return self._filter_component
    
    @FilterComponent.setter
    def FilterComponent(self, value: int) -> None:
        self._filter_component = value

    @property
    def PredicateExpression(self) -> str:
        """
        denotes the predicate expression associated with the event.
        """
        return self._predicate_expression
    
    @PredicateExpression.setter
    def PredicateExpression(self, value: str) -> None:
        self._predicate_expression = value


__all__ = ['FilterEvent']
