# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.frame
# Libre Office Version: 7.3
from ooo.oenv.env_const import UNO_NONE
import typing


class DispatchInformation(object):
    """
    Struct Class

    provides information about a supported command
    
    **since**
    
        OOo 2.0

    See Also:
        `API DispatchInformation <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1frame_1_1DispatchInformation.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.frame'
    __ooo_full_ns__: str = 'com.sun.star.frame.DispatchInformation'
    __ooo_type_name__: str = 'struct'
    typeName: str = 'com.sun.star.frame.DispatchInformation'
    """Literal Constant ``com.sun.star.frame.DispatchInformation``"""

    def __init__(self, Command: typing.Optional[str] = '', GroupId: typing.Optional[int] = 0) -> None:
        """
        Constructor

        Arguments:
            Command (str, optional): Command value.
            GroupId (int, optional): GroupId value.
        """
        super().__init__()

        if isinstance(Command, DispatchInformation):
            oth: DispatchInformation = Command
            self.Command = oth.Command
            self.GroupId = oth.GroupId
            return

        kargs = {
            "Command": Command,
            "GroupId": GroupId,
        }
        self._init(**kargs)

    def _init(self, **kwargs) -> None:
        self._command = kwargs["Command"]
        self._group_id = kwargs["GroupId"]


    @property
    def Command(self) -> str:
        """
        command URL of a supported command.
        """
        return self._command
    
    @Command.setter
    def Command(self, value: str) -> None:
        self._command = value

    @property
    def GroupId(self) -> int:
        """
        group identifier to which the supported command belong.
        """
        return self._group_id
    
    @GroupId.setter
    def GroupId(self, value: int) -> None:
        self._group_id = value


__all__ = ['DispatchInformation']
