# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.frame.status
# Libre Office Version: 7.3
from ooo.oenv.env_const import UNO_NONE
import typing


class ItemStatus(object):
    """
    Struct Class

    describes a state of a property.
    
    **since**
    
        OOo 2.0

    See Also:
        `API ItemStatus <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1frame_1_1status_1_1ItemStatus.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.frame.status'
    __ooo_full_ns__: str = 'com.sun.star.frame.status.ItemStatus'
    __ooo_type_name__: str = 'struct'
    typeName: str = 'com.sun.star.frame.status.ItemStatus'
    """Literal Constant ``com.sun.star.frame.status.ItemStatus``"""

    def __init__(self, State: typing.Optional[int] = 0, aStateData: typing.Optional[object] = None) -> None:
        """
        Constructor

        Arguments:
            State (int, optional): State value.
            aStateData (object, optional): aStateData value.
        """
        super().__init__()

        if isinstance(State, ItemStatus):
            oth: ItemStatus = State
            self.State = oth.State
            self.aStateData = oth.aStateData
            return

        kargs = {
            "State": State,
            "aStateData": aStateData,
        }
        self._init(**kargs)

    def _init(self, **kwargs) -> None:
        self._state = kwargs["State"]
        self._a_state_data = kwargs["aStateData"]


    @property
    def State(self) -> int:
        """
        numerical value which describes the current state of an item.
        """
        return self._state
    
    @State.setter
    def State(self, value: int) -> None:
        self._state = value

    @property
    def aStateData(self) -> object:
        """
        optional data which can be used by an implementation to send additional information.
        
        The content is dependent on the specific implementation.
        """
        return self._a_state_data
    
    @aStateData.setter
    def aStateData(self, value: object) -> None:
        self._a_state_data = value


__all__ = ['ItemStatus']
