# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Interface Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.3
# Namespace: com.sun.star.i18n
from abc import abstractmethod
from .x_input_sequence_checker import XInputSequenceChecker as XInputSequenceChecker_1eb00e9e

class XExtendedInputSequenceChecker(XInputSequenceChecker_1eb00e9e):
    """
    This interface perform input sequence correction for the languages like Thai and Hindi.
    
    It is derived from com.sun.star.i18n.XInputSequenceChecker and provides additional functionality to correct input sequence.
    
    **since**
    
        OOo 2.0.1

    See Also:
        `API XExtendedInputSequenceChecker <https://api.libreoffice.org/docs/idl/ref/interfacecom_1_1sun_1_1star_1_1i18n_1_1XExtendedInputSequenceChecker.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.i18n'
    __ooo_full_ns__: str = 'com.sun.star.i18n.XExtendedInputSequenceChecker'
    __ooo_type_name__: str = 'interface'
    __pyunointerface__: str = 'com.sun.star.i18n.XExtendedInputSequenceChecker'

    @abstractmethod
    def correctInputSequence(self, aText: object, nPos: int, cInputChar: str, nInputCheckMode: int) -> int:
        """
        """

__all__ = ['XExtendedInputSequenceChecker']

