# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Interface Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.3
# Namespace: com.sun.star.linguistic2
import typing
from abc import abstractmethod
from ..uno.x_interface import XInterface as XInterface_8f010a43
if typing.TYPE_CHECKING:
    from ..container.x_name_container import XNameContainer as XNameContainer_cb90e47
    from ..lang.locale import Locale as Locale_70d308fa
    from .conversion_direction import ConversionDirection as ConversionDirection_7dfe113c
    from .x_conversion_dictionary import XConversionDictionary as XConversionDictionary_a04e1209

class XConversionDictionaryList(XInterface_8f010a43):
    """
    is used to manage and maintain a list of conversion dictionaries.
    
    The dictionaries added to the list may or may not support the com.sun.star.util.XFlushable interface. If they do those dictionaries have to be flushed upon termination of the dictionary list.
    
    **since**
    
        OOo 1.1.2

    See Also:
        `API XConversionDictionaryList <https://api.libreoffice.org/docs/idl/ref/interfacecom_1_1sun_1_1star_1_1linguistic2_1_1XConversionDictionaryList.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.linguistic2'
    __ooo_full_ns__: str = 'com.sun.star.linguistic2.XConversionDictionaryList'
    __ooo_type_name__: str = 'interface'
    __pyunointerface__: str = 'com.sun.star.linguistic2.XConversionDictionaryList'

    @abstractmethod
    def addNewDictionary(self, aName: str, aLocale: 'Locale_70d308fa', nConversionDictionaryType: int) -> 'XConversionDictionary_a04e1209':
        """
        creates a new dictionary and adds it to the dictionary list.
        
        The dictionary will be empty and active.

        Raises:
            com.sun.star.lang.NoSupportException: ``NoSupportException``
            com.sun.star.container.ElementExistException: ``ElementExistException``
        """
    @abstractmethod
    def getDictionaryContainer(self) -> 'XNameContainer_cb90e47':
        """
        The interface can be used to add, remove or retrieve dictionaries from the list by specifying the name of the dictionary, and (in case of inserting) the interface to the dictionary as second parameter.
        
        A dictionary to be added must support the com.sun.star.linguistic2.XConversionDictionary interface. The dictionary to be added needs not necessarily be created by this service.
        
        The com.sun.star.container.XNameReplace.replaceByName function is implemented empty since renaming of dictionaries is not allowed.
        """
    @abstractmethod
    def queryConversions(self, aText: str, nStartPos: int, nLength: int, aLocale: 'Locale_70d308fa', nConversionDictionaryType: int, eDirection: 'ConversionDirection_7dfe113c', nTextConversionOptions: int) -> 'typing.Tuple[str, ...]':
        """
        searches for entries that match the given text.
        
        All active dictionaries with matching locales and conversion type will be searched for entries matching the given text.
        
        The exact string to be looked for is the substring from the aText parameter that starts at position nStartPos and has the length nLength.

        Raises:
            com.sun.star.lang.IllegalArgumentException: ``IllegalArgumentException``
            com.sun.star.lang.NoSupportException: ``NoSupportException``
        """
    @abstractmethod
    def queryMaxCharCount(self, aLocale: 'Locale_70d308fa', nConversionDictionaryType: int, eDirection: 'ConversionDirection_7dfe113c') -> int:
        """
        returns the maximum number of characters used as left or right text in entries.
        
        All active dictionaries of the specified locale and type will be looked up to get the result.
        
        The parameter eDirection specifies if only the left text or the right text from entries should be considered.
        """

__all__ = ['XConversionDictionaryList']

