# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Interface Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.3
# Namespace: com.sun.star.packages.manifest
import typing
from abc import abstractmethod
from ...uno.x_interface import XInterface as XInterface_8f010a43
if typing.TYPE_CHECKING:
    from ...beans.property_value import PropertyValue as PropertyValue_c9610c73
    from ...io.x_input_stream import XInputStream as XInputStream_98d40ab4

class XManifestReader(XInterface_8f010a43):
    """
    This interface reads the manifest data from a file.
    
    The user must supply an XInputStream when calling readManifestSequence() to receive a sequence of manifest entries. Each manifest entry is represented by a sequence of PropertyValues.

    See Also:
        `API XManifestReader <https://api.libreoffice.org/docs/idl/ref/interfacecom_1_1sun_1_1star_1_1packages_1_1manifest_1_1XManifestReader.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.packages.manifest'
    __ooo_full_ns__: str = 'com.sun.star.packages.manifest.XManifestReader'
    __ooo_type_name__: str = 'interface'
    __pyunointerface__: str = 'com.sun.star.packages.manifest.XManifestReader'

    @abstractmethod
    def readManifestSequence(self, rStream: 'XInputStream_98d40ab4') -> 'typing.Tuple[typing.Tuple[PropertyValue_c9610c73, ...], ...]':
        """
        Supplies the XManifestReader with an XInputStream to read from, reads the data and returns it to the caller.
        """

__all__ = ['XManifestReader']

