# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Const Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.3
# Namespace: com.sun.star.packages.zip


class ZipConstants(object):
    """
    Const Class

    defines the constants used by the ZIP interfaces.

    See Also:
        `API ZipConstants <https://api.libreoffice.org/docs/idl/ref/namespacecom_1_1sun_1_1star_1_1packages_1_1zip_1_1ZipConstants.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.packages.zip'
    __ooo_full_ns__: str = 'com.sun.star.packages.zip.ZipConstants'
    __ooo_type_name__: str = 'const'

    DEFLATED = 8
    """
    Compression method for the deflate algorithm (the only one currently supported).
    """
    NO_COMPRESSION = 0
    """
    Compression level for no compression.
    """
    BEST_SPEED = 1
    """
    Compression level for fastest compression.
    """
    BEST_COMPRESSION = 9
    """
    Compression level for best compression.
    """
    DEFAULT_COMPRESSION = -1
    """
    Default compression level.
    """
    FILTERED = 1
    """
    Compression strategy best used for data consisting mostly of small values with a somewhat random distribution.
    
    Forces more Huffman coding and less string matching.
    """
    HUFFMAN_ONLY = 2
    """
    Compression strategy for Huffman coding only.
    """
    DEFAULT_STRATEGY = 0
    """
    Default compression strategy.
    """
    STORED = 0
    """
    entry is uncompressed
    """
    DEF_MEM_LEVEL = 8
    """
    entry is uncompressed
    """
    LOCSIG = 67324752
    """
    Header Signature: \"PK\\003\\004\".
    """
    EXTSIG = 134695760
    """
    Header Signature: \"PK\\007\\008\".
    """
    CENSIG = 33639248
    """
    Header Signature: \"PK\\001\\002\".
    """
    ENDSIG = 101010256
    """
    Header Signature: \"PK\\005\\006\".
    """
    SPANSIG = 134695760
    """
    Header Signature: \"PK\\007\\008\".
    """
    LOCHDR = 30
    """
    LOC header size in bytes (including signatures)
    """
    EXTHDR = 16
    """
    EXT header size in bytes (including signatures)
    """
    CENHDR = 46
    """
    CEN header size in bytes (including signatures)
    """
    ENDHDR = 22
    """
    END header size in bytes (including signatures)
    """
    LOCVER = 4
    """
    LOC LOC LOC.
    
    LOC header field \"version needed to extract\" offset
    """
    LOCFLG = 6
    """
    LOC header field \"general purpose bit flags\" offset.
    """
    LOCHOW = 8
    """
    LOC header field \"compression method\" offset.
    """
    LOCTIM = 10
    """
    LOC header field \"modification time\" offset.
    """
    LOCCRC = 14
    """
    LOC header field \"CRC of uncompressed data\" offset.
    """
    LOCSIZ = 18
    """
    LOC header field \"compressed data size\" offset.
    """
    LOCLEN = 22
    """
    LOC header field \"uncompressed data size\" offset.
    """
    LOCNAM = 26
    """
    LOC header field \"filename length\" offset.
    """
    LOCEXT = 28
    """
    LOC header field \"extra field length\" offset.
    """
    EXTCRC = 4
    """
    EXT header field \"CRC of uncompressed data\" offsets.
    """
    EXTSIZ = 8
    """
    EXT header field \"compressed size\" offsets.
    """
    EXTLEN = 12
    """
    EXT header field \"uncompressed size\" offsets.
    """
    CENVEM = 4
    """
    CEN header field \"version made by\" offset.
    """
    CENVER = 6
    """
    CEN header field \"version needed to extract\" offset.
    """
    CENFLG = 8
    """
    CEN header field \"general purpose bit flags\" offset.
    """
    CENHOW = 10
    """
    CEN header field \"compression method\" offset.
    """
    CENTIM = 12
    """
    CEN header field \"modification time\" offset.
    """
    CENDAT = 14
    """
    CEN header field \"modification time\" offset.
    """
    CENCRC = 16
    """
    CEN header field \"CRC of uncompressed data\" offset.
    """
    CENSIZ = 20
    """
    CEN header field \"compressed size\" offset.
    """
    CENLEN = 24
    """
    CEN header field \"uncompressed size\" offset.
    """
    CENNAM = 28
    """
    CEN header field \"length of filename\" offset.
    """
    CENEXT = 30
    """
    CEN header field \"length of extra field\" offset.
    """
    CENCOM = 32
    """
    CEN header field \"file comment length\" offset.
    """
    CENDSK = 34
    """
    CEN header field \"disk number start\" offset.
    """
    CENATT = 36
    """
    CEN header field \"internal file attributes\" offset.
    """
    CENATX = 38
    """
    CEN header field \"external file attributes\" offset.
    """
    CENOFF = 42
    """
    CEN header field \"offset of local header\" offset.
    """
    ENDSUB = 8
    """
    END header field \"number of entries on this disk\" offset.
    """
    ENDTOT = 10
    """
    END header field \"total number of entries\" offset.
    """
    ENDSIZ = 12
    """
    END header field \"central directory size\" offset.
    """
    ENDOFF = 16
    """
    END header field \"central directory offset\" offset.
    """
    ENDCOM = 20
    """
    END header field \"size of zip file comment\" offset.
    """

__all__ = ['ZipConstants']
